// Code generated by MockGen. DO NOT EDIT.
// Source: datastore.go

// Package mocks is a generated GoMock package.
package mocks

import (
	context "context"
	reflect "reflect"

	gomock "github.com/golang/mock/gomock"
	compliance "github.com/stackrox/rox/central/compliance"
	datastore "github.com/stackrox/rox/central/compliance/datastore"
	types "github.com/stackrox/rox/central/compliance/datastore/types"
	v1 "github.com/stackrox/rox/generated/api/v1"
	storage "github.com/stackrox/rox/generated/storage"
)

// MockDataStore is a mock of DataStore interface.
type MockDataStore struct {
	ctrl     *gomock.Controller
	recorder *MockDataStoreMockRecorder
}

// MockDataStoreMockRecorder is the mock recorder for MockDataStore.
type MockDataStoreMockRecorder struct {
	mock *MockDataStore
}

// NewMockDataStore creates a new mock instance.
func NewMockDataStore(ctrl *gomock.Controller) *MockDataStore {
	mock := &MockDataStore{ctrl: ctrl}
	mock.recorder = &MockDataStoreMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockDataStore) EXPECT() *MockDataStoreMockRecorder {
	return m.recorder
}

// ClearAggregationResults mocks base method.
func (m *MockDataStore) ClearAggregationResults(ctx context.Context) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ClearAggregationResults", ctx)
	ret0, _ := ret[0].(error)
	return ret0
}

// ClearAggregationResults indicates an expected call of ClearAggregationResults.
func (mr *MockDataStoreMockRecorder) ClearAggregationResults(ctx interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ClearAggregationResults", reflect.TypeOf((*MockDataStore)(nil).ClearAggregationResults), ctx)
}

// GetLatestRunResults mocks base method.
func (m *MockDataStore) GetLatestRunResults(ctx context.Context, clusterID, standardID string, flags types.GetFlags) (types.ResultsWithStatus, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetLatestRunResults", ctx, clusterID, standardID, flags)
	ret0, _ := ret[0].(types.ResultsWithStatus)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetLatestRunResults indicates an expected call of GetLatestRunResults.
func (mr *MockDataStoreMockRecorder) GetLatestRunResults(ctx, clusterID, standardID, flags interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetLatestRunResults", reflect.TypeOf((*MockDataStore)(nil).GetLatestRunResults), ctx, clusterID, standardID, flags)
}

// GetLatestRunResultsBatch mocks base method.
func (m *MockDataStore) GetLatestRunResultsBatch(ctx context.Context, clusterIDs, standardIDs []string, flags types.GetFlags) (map[compliance.ClusterStandardPair]types.ResultsWithStatus, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetLatestRunResultsBatch", ctx, clusterIDs, standardIDs, flags)
	ret0, _ := ret[0].(map[compliance.ClusterStandardPair]types.ResultsWithStatus)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetLatestRunResultsBatch indicates an expected call of GetLatestRunResultsBatch.
func (mr *MockDataStoreMockRecorder) GetLatestRunResultsBatch(ctx, clusterIDs, standardIDs, flags interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetLatestRunResultsBatch", reflect.TypeOf((*MockDataStore)(nil).GetLatestRunResultsBatch), ctx, clusterIDs, standardIDs, flags)
}

// GetLatestRunResultsForClustersAndStandards mocks base method.
func (m *MockDataStore) GetLatestRunResultsForClustersAndStandards(ctx context.Context, clusterIDs, standardIDs []string, flags types.GetFlags) (map[compliance.ClusterStandardPair]types.ResultsWithStatus, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetLatestRunResultsForClustersAndStandards", ctx, clusterIDs, standardIDs, flags)
	ret0, _ := ret[0].(map[compliance.ClusterStandardPair]types.ResultsWithStatus)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetLatestRunResultsForClustersAndStandards indicates an expected call of GetLatestRunResultsForClustersAndStandards.
func (mr *MockDataStoreMockRecorder) GetLatestRunResultsForClustersAndStandards(ctx, clusterIDs, standardIDs, flags interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetLatestRunResultsForClustersAndStandards", reflect.TypeOf((*MockDataStore)(nil).GetLatestRunResultsForClustersAndStandards), ctx, clusterIDs, standardIDs, flags)
}

// GetSpecificRunResults mocks base method.
func (m *MockDataStore) GetSpecificRunResults(ctx context.Context, clusterID, standardID, runID string, flags types.GetFlags) (types.ResultsWithStatus, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetSpecificRunResults", ctx, clusterID, standardID, runID, flags)
	ret0, _ := ret[0].(types.ResultsWithStatus)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetSpecificRunResults indicates an expected call of GetSpecificRunResults.
func (mr *MockDataStoreMockRecorder) GetSpecificRunResults(ctx, clusterID, standardID, runID, flags interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetSpecificRunResults", reflect.TypeOf((*MockDataStore)(nil).GetSpecificRunResults), ctx, clusterID, standardID, runID, flags)
}

// IsComplianceRunSuccessfulOnCluster mocks base method.
func (m *MockDataStore) IsComplianceRunSuccessfulOnCluster(ctx context.Context, clusterID string, standardIDs []string) (bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsComplianceRunSuccessfulOnCluster", ctx, clusterID, standardIDs)
	ret0, _ := ret[0].(bool)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// IsComplianceRunSuccessfulOnCluster indicates an expected call of IsComplianceRunSuccessfulOnCluster.
func (mr *MockDataStoreMockRecorder) IsComplianceRunSuccessfulOnCluster(ctx, clusterID, standardIDs interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsComplianceRunSuccessfulOnCluster", reflect.TypeOf((*MockDataStore)(nil).IsComplianceRunSuccessfulOnCluster), ctx, clusterID, standardIDs)
}

// PerformStoredAggregation mocks base method.
func (m *MockDataStore) PerformStoredAggregation(ctx context.Context, args *datastore.StoredAggregationArgs) ([]*storage.ComplianceAggregation_Result, []*storage.ComplianceAggregation_Source, map[*storage.ComplianceAggregation_Result]*storage.ComplianceDomain, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PerformStoredAggregation", ctx, args)
	ret0, _ := ret[0].([]*storage.ComplianceAggregation_Result)
	ret1, _ := ret[1].([]*storage.ComplianceAggregation_Source)
	ret2, _ := ret[2].(map[*storage.ComplianceAggregation_Result]*storage.ComplianceDomain)
	ret3, _ := ret[3].(error)
	return ret0, ret1, ret2, ret3
}

// PerformStoredAggregation indicates an expected call of PerformStoredAggregation.
func (mr *MockDataStoreMockRecorder) PerformStoredAggregation(ctx, args interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PerformStoredAggregation", reflect.TypeOf((*MockDataStore)(nil).PerformStoredAggregation), ctx, args)
}

// QueryControlResults mocks base method.
func (m *MockDataStore) QueryControlResults(ctx context.Context, query *v1.Query) ([]*storage.ComplianceControlResult, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "QueryControlResults", ctx, query)
	ret0, _ := ret[0].([]*storage.ComplianceControlResult)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// QueryControlResults indicates an expected call of QueryControlResults.
func (mr *MockDataStoreMockRecorder) QueryControlResults(ctx, query interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "QueryControlResults", reflect.TypeOf((*MockDataStore)(nil).QueryControlResults), ctx, query)
}

// StoreComplianceDomain mocks base method.
func (m *MockDataStore) StoreComplianceDomain(ctx context.Context, domain *storage.ComplianceDomain) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "StoreComplianceDomain", ctx, domain)
	ret0, _ := ret[0].(error)
	return ret0
}

// StoreComplianceDomain indicates an expected call of StoreComplianceDomain.
func (mr *MockDataStoreMockRecorder) StoreComplianceDomain(ctx, domain interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StoreComplianceDomain", reflect.TypeOf((*MockDataStore)(nil).StoreComplianceDomain), ctx, domain)
}

// StoreFailure mocks base method.
func (m *MockDataStore) StoreFailure(ctx context.Context, metadata *storage.ComplianceRunMetadata) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "StoreFailure", ctx, metadata)
	ret0, _ := ret[0].(error)
	return ret0
}

// StoreFailure indicates an expected call of StoreFailure.
func (mr *MockDataStoreMockRecorder) StoreFailure(ctx, metadata interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StoreFailure", reflect.TypeOf((*MockDataStore)(nil).StoreFailure), ctx, metadata)
}

// StoreRunResults mocks base method.
func (m *MockDataStore) StoreRunResults(ctx context.Context, results *storage.ComplianceRunResults) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "StoreRunResults", ctx, results)
	ret0, _ := ret[0].(error)
	return ret0
}

// StoreRunResults indicates an expected call of StoreRunResults.
func (mr *MockDataStoreMockRecorder) StoreRunResults(ctx, results interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StoreRunResults", reflect.TypeOf((*MockDataStore)(nil).StoreRunResults), ctx, results)
}
