// Code generated by blevebindings generator. DO NOT EDIT.

package index

import (
	"bytes"
	bleve "github.com/blevesearch/bleve"
	mappings "github.com/stackrox/rox/central/cve/mappings"
	metrics "github.com/stackrox/rox/central/metrics"
	v1 "github.com/stackrox/rox/generated/api/v1"
	storage "github.com/stackrox/rox/generated/storage"
	batcher "github.com/stackrox/rox/pkg/batcher"
	ops "github.com/stackrox/rox/pkg/metrics"
	search "github.com/stackrox/rox/pkg/search"
	blevesearch "github.com/stackrox/rox/pkg/search/blevesearch"
	"time"
)

const batchSize = 5000

const resourceName = "CVE"

type indexerImpl struct {
	index bleve.Index
}

type cVEWrapper struct {
	*storage.CVE `json:"c_v_e"`
	Type         string `json:"type"`
}

func (b *indexerImpl) AddCVE(cve *storage.CVE) error {
	defer metrics.SetIndexOperationDurationTime(time.Now(), ops.Add, "CVE")
	if err := b.index.Index(cve.GetId(), &cVEWrapper{
		CVE:  cve,
		Type: v1.SearchCategory_VULNERABILITIES.String(),
	}); err != nil {
		return err
	}
	return nil
}

func (b *indexerImpl) AddCVEs(cves []*storage.CVE) error {
	defer metrics.SetIndexOperationDurationTime(time.Now(), ops.AddMany, "CVE")
	batchManager := batcher.New(len(cves), batchSize)
	for {
		start, end, ok := batchManager.Next()
		if !ok {
			break
		}
		if err := b.processBatch(cves[start:end]); err != nil {
			return err
		}
	}
	return nil
}

func (b *indexerImpl) processBatch(cves []*storage.CVE) error {
	batch := b.index.NewBatch()
	for _, cve := range cves {
		if err := batch.Index(cve.GetId(), &cVEWrapper{
			CVE:  cve,
			Type: v1.SearchCategory_VULNERABILITIES.String(),
		}); err != nil {
			return err
		}
	}
	return b.index.Batch(batch)
}

func (b *indexerImpl) Count(q *v1.Query, opts ...blevesearch.SearchOption) (int, error) {
	defer metrics.SetIndexOperationDurationTime(time.Now(), ops.Count, "CVE")
	return blevesearch.RunCountRequest(v1.SearchCategory_VULNERABILITIES, q, b.index, mappings.OptionsMap, opts...)
}

func (b *indexerImpl) DeleteCVE(id string) error {
	defer metrics.SetIndexOperationDurationTime(time.Now(), ops.Remove, "CVE")
	if err := b.index.Delete(id); err != nil {
		return err
	}
	return nil
}

func (b *indexerImpl) DeleteCVEs(ids []string) error {
	defer metrics.SetIndexOperationDurationTime(time.Now(), ops.RemoveMany, "CVE")
	batch := b.index.NewBatch()
	for _, id := range ids {
		batch.Delete(id)
	}
	if err := b.index.Batch(batch); err != nil {
		return err
	}
	return nil
}

func (b *indexerImpl) MarkInitialIndexingComplete() error {
	return b.index.SetInternal([]byte(resourceName), []byte("old"))
}

func (b *indexerImpl) NeedsInitialIndexing() (bool, error) {
	data, err := b.index.GetInternal([]byte(resourceName))
	if err != nil {
		return false, err
	}
	return !bytes.Equal([]byte("old"), data), nil
}

func (b *indexerImpl) Search(q *v1.Query, opts ...blevesearch.SearchOption) ([]search.Result, error) {
	defer metrics.SetIndexOperationDurationTime(time.Now(), ops.Search, "CVE")
	return blevesearch.RunSearchRequest(v1.SearchCategory_VULNERABILITIES, q, b.index, mappings.OptionsMap, opts...)
}
