// Code generated by notifier generator. DO NOT EDIT.

package notifier

import (
	storage "github.com/stackrox/rox/generated/storage"
	sync "github.com/stackrox/rox/pkg/sync"
)

func newNotifier() *notifier {
	return &notifier{}
}

type notifier struct {
	lock      sync.RWMutex
	onDeletes []func(deployment *storage.Deployment)
	onUpserts []func(deployment *storage.Deployment)
}

func (n *notifier) OnDelete(onDelete func(deployment *storage.Deployment)) {
	n.lock.Lock()
	defer n.lock.Unlock()
	n.onDeletes = append(n.onDeletes, onDelete)
}

func (n *notifier) Deleted(deployment *storage.Deployment) {
	n.lock.RLock()
	defer n.lock.RUnlock()
	for _, f := range n.onDeletes {
		f(deployment)
	}
}

func (n *notifier) OnUpsert(onUpsert func(deployment *storage.Deployment)) {
	n.lock.Lock()
	defer n.lock.Unlock()
	n.onUpserts = append(n.onUpserts, onUpsert)
}

func (n *notifier) Upserted(deployment *storage.Deployment) {
	n.lock.RLock()
	defer n.lock.RUnlock()
	for _, f := range n.onUpserts {
		f(deployment)
	}
}
