// Code generated by graphql-generator. DO NOT EDIT.

package resolvers

import (
	"context"
	"reflect"

	"github.com/graph-gophers/graphql-go"
	"github.com/stackrox/rox/central/graphql/generator"
	"github.com/stackrox/rox/generated/api/v1"
	"github.com/stackrox/rox/generated/storage" // end range imports
	"github.com/stackrox/rox/pkg/utils"
)

func registerGeneratedTypes(builder generator.SchemaBuilder) {
	utils.Must(builder.AddType("Label", []string{"key: String!", "value: String!"}))
	utils.Must(builder.AddType("AWSProviderMetadata", []string{
		"accountId: String!",
	}))
	utils.Must(builder.AddType("AWSSecurityHub", []string{
		"accountId: String!",
		"credentials: AWSSecurityHub_Credentials",
		"region: String!",
	}))
	utils.Must(builder.AddType("AWSSecurityHub_Credentials", []string{
		"accessKeyId: String!",
		"secretAccessKey: String!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.Access(0)))
	utils.Must(builder.AddType("ActiveComponent_ActiveContext", []string{
		"containerName: String!",
		"imageId: String!",
	}))
	utils.Must(builder.AddType("AdmissionControlHealthInfo", []string{
		"statusErrors: [String!]!",
	}))
	utils.Must(builder.AddType("AdmissionControllerConfig", []string{
		"disableBypass: Boolean!",
		"enabled: Boolean!",
		"enforceOnUpdates: Boolean!",
		"scanInline: Boolean!",
		"timeoutSeconds: Int!",
	}))
	utils.Must(builder.AddType("Alert", []string{
		"deployment: Alert_Deployment",
		"enforcement: Alert_Enforcement",
		"firstOccurred: Time",
		"id: ID!",
		"image: ContainerImage",
		"lifecycleStage: LifecycleStage!",
		"policy: Policy",
		"processViolation: Alert_ProcessViolation",
		"resolvedAt: Time",
		"resource: Alert_Resource",
		"snoozeTill: Time",
		"state: ViolationState!",
		"tags: [String!]!",
		"time: Time",
		"violations: [Alert_Violation]!",
		"entity: AlertEntity",
	}))
	utils.Must(builder.AddUnionType("AlertEntity", []string{
		"Alert_Deployment",
		"ContainerImage",
		"Alert_Resource",
	}))
	utils.Must(builder.AddType("Alert_Deployment", []string{
		"annotations: [Label!]!",
		"clusterId: String!",
		"clusterName: String!",
		"containers: [Alert_Deployment_Container]!",
		"id: ID!",
		"inactive: Boolean!",
		"labels: [Label!]!",
		"name: String!",
		"namespace: String!",
		"namespaceId: String!",
		"type: String!",
	}))
	utils.Must(builder.AddType("Alert_Deployment_Container", []string{
		"image: ContainerImage",
		"name: String!",
	}))
	utils.Must(builder.AddType("Alert_Enforcement", []string{
		"action: EnforcementAction!",
		"message: String!",
	}))
	utils.Must(builder.AddType("Alert_ProcessViolation", []string{
		"message: String!",
		"processes: [ProcessIndicator]!",
	}))
	utils.Must(builder.AddType("Alert_Resource", []string{
		"clusterId: String!",
		"clusterName: String!",
		"name: String!",
		"namespace: String!",
		"namespaceId: String!",
		"resourceType: Alert_Resource_ResourceType!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.Alert_Resource_ResourceType(0)))
	utils.Must(builder.AddType("Alert_Violation", []string{
		"keyValueAttrs: Alert_Violation_KeyValueAttrs",
		"message: String!",
		"networkFlowInfo: Alert_Violation_NetworkFlowInfo",
		"time: Time",
		"type: Alert_Violation_Type!",
		"messageAttributes: Alert_ViolationMessageAttributes",
	}))
	utils.Must(builder.AddUnionType("Alert_ViolationMessageAttributes", []string{
		"Alert_Violation_KeyValueAttrs",
		"Alert_Violation_NetworkFlowInfo",
	}))
	utils.Must(builder.AddType("Alert_Violation_KeyValueAttrs", []string{
		"attrs: [Alert_Violation_KeyValueAttrs_KeyValueAttr]!",
	}))
	utils.Must(builder.AddType("Alert_Violation_KeyValueAttrs_KeyValueAttr", []string{
		"key: String!",
		"value: String!",
	}))
	utils.Must(builder.AddType("Alert_Violation_NetworkFlowInfo", []string{
		"destination: Alert_Violation_NetworkFlowInfo_Entity",
		"protocol: L4Protocol!",
		"source: Alert_Violation_NetworkFlowInfo_Entity",
	}))
	utils.Must(builder.AddType("Alert_Violation_NetworkFlowInfo_Entity", []string{
		"deploymentNamespace: String!",
		"deploymentType: String!",
		"entityType: NetworkEntityInfo_Type!",
		"name: String!",
		"port: Int!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.Alert_Violation_Type(0)))
	utils.Must(builder.AddType("AzureProviderMetadata", []string{
		"subscriptionId: String!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.BooleanOperator(0)))
	utils.Must(builder.AddType("CSCC", []string{
		"serviceAccount: String!",
		"sourceId: String!",
	}))
	utils.Must(builder.AddType("CVE", []string{
		"createdAt: Time",
		"id: ID!",
		"impactScore: Float!",
		"lastModified: Time",
		"link: String!",
		"publishedOn: Time",
		"references: [CVE_Reference]!",
		"scoreVersion: CVE_ScoreVersion!",
		"severity: VulnerabilitySeverity!",
		"summary: String!",
		"suppressActivation: Time",
		"suppressExpiry: Time",
		"suppressed: Boolean!",
		"type: CVE_CVEType!",
		"types: [CVE_CVEType!]!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.CVE_CVEType(0)))
	utils.Must(builder.AddType("CVE_Reference", []string{
		"tags: [String!]!",
		"uRI: String!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.CVE_ScoreVersion(0)))
	utils.Must(builder.AddType("CVSSV2", []string{
		"accessComplexity: CVSSV2_AccessComplexity!",
		"attackVector: CVSSV2_AttackVector!",
		"authentication: CVSSV2_Authentication!",
		"availability: CVSSV2_Impact!",
		"confidentiality: CVSSV2_Impact!",
		"exploitabilityScore: Float!",
		"impactScore: Float!",
		"integrity: CVSSV2_Impact!",
		"score: Float!",
		"severity: CVSSV2_Severity!",
		"vector: String!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.CVSSV2_AccessComplexity(0)))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.CVSSV2_AttackVector(0)))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.CVSSV2_Authentication(0)))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.CVSSV2_Impact(0)))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.CVSSV2_Severity(0)))
	utils.Must(builder.AddType("CVSSV3", []string{
		"attackComplexity: CVSSV3_Complexity!",
		"attackVector: CVSSV3_AttackVector!",
		"availability: CVSSV3_Impact!",
		"confidentiality: CVSSV3_Impact!",
		"exploitabilityScore: Float!",
		"impactScore: Float!",
		"integrity: CVSSV3_Impact!",
		"privilegesRequired: CVSSV3_Privileges!",
		"scope: CVSSV3_Scope!",
		"score: Float!",
		"severity: CVSSV3_Severity!",
		"userInteraction: CVSSV3_UserInteraction!",
		"vector: String!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.CVSSV3_AttackVector(0)))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.CVSSV3_Complexity(0)))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.CVSSV3_Impact(0)))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.CVSSV3_Privileges(0)))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.CVSSV3_Scope(0)))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.CVSSV3_Severity(0)))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.CVSSV3_UserInteraction(0)))
	utils.Must(builder.AddType("Cert", []string{
		"algorithm: String!",
		"endDate: Time",
		"issuer: CertName",
		"sans: [String!]!",
		"startDate: Time",
		"subject: CertName",
	}))
	utils.Must(builder.AddType("CertName", []string{
		"commonName: String!",
		"country: String!",
		"locality: String!",
		"names: [String!]!",
		"organization: String!",
		"organizationUnit: String!",
		"postalCode: String!",
		"province: String!",
		"streetAddress: String!",
	}))
	utils.Must(builder.AddType("Cluster", []string{
		"admissionController: Boolean!",
		"admissionControllerEvents: Boolean!",
		"admissionControllerUpdates: Boolean!",
		"centralApiEndpoint: String!",
		"collectionMethod: CollectionMethod!",
		"collectorImage: String!",
		"dynamicConfig: DynamicClusterConfig",
		"healthStatus: ClusterHealthStatus",
		"helmConfig: CompleteClusterConfig",
		"id: ID!",
		"initBundleId: String!",
		"labels: [Label!]!",
		"mainImage: String!",
		"managedBy: ManagerType!",
		"mostRecentSensorId: SensorDeploymentIdentification",
		"name: String!",
		"priority: Int!",
		"runtimeSupport: Boolean!",
		"slimCollector: Boolean!",
		"status: ClusterStatus",
		"tolerationsConfig: TolerationsConfig",
		"type: ClusterType!",
	}))
	utils.Must(builder.AddType("ClusterCertExpiryStatus", []string{
		"sensorCertExpiry: Time",
	}))
	utils.Must(builder.AddType("ClusterHealthStatus", []string{
		"admissionControlHealthInfo: AdmissionControlHealthInfo",
		"admissionControlHealthStatus: ClusterHealthStatus_HealthStatusLabel!",
		"collectorHealthInfo: CollectorHealthInfo",
		"collectorHealthStatus: ClusterHealthStatus_HealthStatusLabel!",
		"healthInfoComplete: Boolean!",
		"lastContact: Time",
		"overallHealthStatus: ClusterHealthStatus_HealthStatusLabel!",
		"sensorHealthStatus: ClusterHealthStatus_HealthStatusLabel!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.ClusterHealthStatus_HealthStatusLabel(0)))
	utils.Must(builder.AddType("ClusterStatus", []string{
		"certExpiryStatus: ClusterCertExpiryStatus",
		"orchestratorMetadata: OrchestratorMetadata",
		"providerMetadata: ProviderMetadata",
		"sensorVersion: String!",
		"upgradeStatus: ClusterUpgradeStatus",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.ClusterType(0)))
	utils.Must(builder.AddType("ClusterUpgradeStatus", []string{
		"mostRecentProcess: ClusterUpgradeStatus_UpgradeProcessStatus",
		"upgradability: ClusterUpgradeStatus_Upgradability!",
		"upgradabilityStatusReason: String!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.ClusterUpgradeStatus_Upgradability(0)))
	utils.Must(builder.AddType("ClusterUpgradeStatus_UpgradeProcessStatus", []string{
		"active: Boolean!",
		"id: ID!",
		"initiatedAt: Time",
		"progress: UpgradeProgress",
		"targetVersion: String!",
		"type: ClusterUpgradeStatus_UpgradeProcessStatus_UpgradeProcessType!",
		"upgraderImage: String!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.ClusterUpgradeStatus_UpgradeProcessStatus_UpgradeProcessType(0)))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.CollectionMethod(0)))
	utils.Must(builder.AddType("CollectorHealthInfo", []string{
		"statusErrors: [String!]!",
		"version: String!",
	}))
	utils.Must(builder.AddType("Comment", []string{
		"commentId: String!",
		"commentMessage: String!",
		"createdAt: Time",
		"lastModified: Time",
		"resourceId: String!",
		"resourceType: ResourceType!",
		"user: Comment_User",
	}))
	utils.Must(builder.AddType("Comment_User", []string{
		"email: String!",
		"id: ID!",
		"name: String!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.Comparator(0)))
	utils.Must(builder.AddType("CompleteClusterConfig", []string{
		"clusterLabels: [Label!]!",
		"configFingerprint: String!",
		"dynamicConfig: DynamicClusterConfig",
		"staticConfig: StaticClusterConfig",
	}))
	utils.Must(builder.AddType("ComplianceAggregation_AggregationKey", []string{
		"id: ID!",
		"scope: ComplianceAggregation_Scope!",
	}))
	utils.Must(builder.AddType("ComplianceAggregation_Response", []string{
		"errorMessage: String!",
		"results: [ComplianceAggregation_Result]!",
		"sources: [ComplianceAggregation_Source]!",
	}))
	utils.Must(builder.AddType("ComplianceAggregation_Result", []string{
		"aggregationKeys: [ComplianceAggregation_AggregationKey]!",
		"numFailing: Int!",
		"numPassing: Int!",
		"numSkipped: Int!",
		"unit: ComplianceAggregation_Scope!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.ComplianceAggregation_Scope(0)))
	utils.Must(builder.AddType("ComplianceAggregation_Source", []string{
		"clusterId: String!",
		"failedRuns: [ComplianceRunMetadata]!",
		"standardId: String!",
		"successfulRun: ComplianceRunMetadata",
	}))
	utils.Must(builder.AddType("ComplianceControl", []string{
		"description: String!",
		"groupId: String!",
		"id: ID!",
		"implemented: Boolean!",
		"interpretationText: String!",
		"name: String!",
		"standardId: String!",
	}))
	utils.Must(builder.AddType("ComplianceControlGroup", []string{
		"description: String!",
		"id: ID!",
		"name: String!",
		"numImplementedChecks: Int!",
		"standardId: String!",
	}))
	utils.Must(builder.AddType("ComplianceControlResult", []string{
		"controlId: String!",
		"resource: ComplianceResource",
		"value: ComplianceResultValue",
	}))
	utils.Must(builder.AddType("ComplianceResource", []string{
		"cluster: ComplianceResource_ClusterName",
		"deployment: ComplianceResource_DeploymentName",
		"image: ImageName",
		"node: ComplianceResource_NodeName",
		"resource: ComplianceResourceResource",
	}))
	utils.Must(builder.AddUnionType("ComplianceResourceResource", []string{
		"ComplianceResource_ClusterName",
		"ComplianceResource_DeploymentName",
		"ComplianceResource_NodeName",
		"ImageName",
	}))
	utils.Must(builder.AddType("ComplianceResource_ClusterName", []string{
		"id: ID!",
		"name: String!",
	}))
	utils.Must(builder.AddType("ComplianceResource_DeploymentName", []string{
		"cluster: ComplianceResource_ClusterName",
		"id: ID!",
		"name: String!",
		"namespace: String!",
	}))
	utils.Must(builder.AddType("ComplianceResource_NodeName", []string{
		"cluster: ComplianceResource_ClusterName",
		"id: ID!",
		"name: String!",
	}))
	utils.Must(builder.AddType("ComplianceResultValue", []string{
		"evidence: [ComplianceResultValue_Evidence]!",
		"overallState: ComplianceState!",
	}))
	utils.Must(builder.AddType("ComplianceResultValue_Evidence", []string{
		"message: String!",
		"messageId: Int!",
		"state: ComplianceState!",
	}))
	utils.Must(builder.AddType("ComplianceRun", []string{
		"clusterId: String!",
		"errorMessage: String!",
		"finishTime: Time",
		"id: ID!",
		"scheduleId: String!",
		"standardId: String!",
		"startTime: Time",
		"state: ComplianceRun_State!",
	}))
	utils.Must(builder.AddType("ComplianceRunMetadata", []string{
		"clusterId: String!",
		"domainId: String!",
		"errorMessage: String!",
		"finishTimestamp: Time",
		"runId: String!",
		"standardId: String!",
		"startTimestamp: Time",
		"success: Boolean!",
	}))
	utils.Must(builder.AddType("ComplianceRunSchedule", []string{
		"clusterId: String!",
		"crontabSpec: String!",
		"id: ID!",
		"standardId: String!",
		"suspended: Boolean!",
	}))
	utils.Must(builder.AddType("ComplianceRunScheduleInfo", []string{
		"lastCompletedRun: ComplianceRun",
		"lastRun: ComplianceRun",
		"nextRunTime: Time",
		"schedule: ComplianceRunSchedule",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(v1.ComplianceRun_State(0)))
	utils.Must(builder.AddType("ComplianceStandard", []string{
		"controls: [ComplianceControl]!",
		"groups: [ComplianceControlGroup]!",
		"metadata: ComplianceStandardMetadata",
	}))
	utils.Must(builder.AddType("ComplianceStandardMetadata", []string{
		"description: String!",
		"dynamic: Boolean!",
		"id: ID!",
		"name: String!",
		"numImplementedChecks: Int!",
		"scopes: [ComplianceStandardMetadata_Scope!]!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(v1.ComplianceStandardMetadata_Scope(0)))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.ComplianceState(0)))
	utils.Must(builder.AddType("Component", []string{
		"name: String!",
		"version: String!",
	}))
	utils.Must(builder.AddType("Container", []string{
		"config: ContainerConfig",
		"id: ID!",
		"image: ContainerImage",
		"livenessProbe: LivenessProbe",
		"name: String!",
		"ports: [PortConfig]!",
		"readinessProbe: ReadinessProbe",
		"resources: Resources",
		"secrets: [EmbeddedSecret]!",
		"securityContext: SecurityContext",
		"volumes: [Volume]!",
	}))
	utils.Must(builder.AddType("ContainerConfig", []string{
		"appArmorProfile: String!",
		"args: [String!]!",
		"command: [String!]!",
		"directory: String!",
		"env: [ContainerConfig_EnvironmentConfig]!",
		"uid: Int!",
		"user: String!",
	}))
	utils.Must(builder.AddType("ContainerConfig_EnvironmentConfig", []string{
		"envVarSource: ContainerConfig_EnvironmentConfig_EnvVarSource!",
		"key: String!",
		"value: String!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.ContainerConfig_EnvironmentConfig_EnvVarSource(0)))
	utils.Must(builder.AddType("ContainerImage", []string{
		"id: ID!",
		"isClusterLocal: Boolean!",
		"name: ImageName",
		"notPullable: Boolean!",
	}))
	utils.Must(builder.AddType("ContainerInstance", []string{
		"containerIps: [String!]!",
		"containerName: String!",
		"containingPodId: String!",
		"exitCode: Int!",
		"finished: Time",
		"imageDigest: String!",
		"instanceId: ContainerInstanceID",
		"started: Time",
		"terminationReason: String!",
	}))
	utils.Must(builder.AddType("ContainerInstanceID", []string{
		"containerRuntime: ContainerRuntime!",
		"id: ID!",
		"node: String!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.ContainerRuntime(0)))
	utils.Must(builder.AddType("ContainerRuntimeInfo", []string{
		"type: ContainerRuntime!",
		"version: String!",
	}))
	utils.Must(builder.AddType("CosignSignature", []string{
	}))
	utils.Must(builder.AddType("DataSource", []string{
		"id: ID!",
		"name: String!",
	}))
	utils.Must(builder.AddType("Deployment", []string{
		"annotations: [Label!]!",
		"automountServiceAccountToken: Boolean!",
		"clusterId: String!",
		"clusterName: String!",
		"containers: [Container]!",
		"created: Time",
		"hostIpc: Boolean!",
		"hostNetwork: Boolean!",
		"hostPid: Boolean!",
		"id: ID!",
		"imagePullSecrets: [String!]!",
		"inactive: Boolean!",
		"labelSelector: LabelSelector",
		"labels: [Label!]!",
		"name: String!",
		"namespace: String!",
		"namespaceId: String!",
		"orchestratorComponent: Boolean!",
		"podLabels: [Label!]!",
		"ports: [PortConfig]!",
		"priority: Int!",
		"processTags: [String!]!",
		"replicas: Int!",
		"riskScore: Float!",
		"runtimeClass: String!",
		"serviceAccount: String!",
		"serviceAccountPermissionLevel: PermissionLevel!",
		"stateTimestamp: Int!",
		"tolerations: [Toleration]!",
		"type: String!",
	}))
	utils.Must(builder.AddType("DockerfileLineRuleField", []string{
		"instruction: String!",
		"value: String!",
	}))
	utils.Must(builder.AddType("DynamicClusterConfig", []string{
		"admissionControllerConfig: AdmissionControllerConfig",
		"disableAuditLogs: Boolean!",
		"registryOverride: String!",
	}))
	utils.Must(builder.AddType("Email", []string{
		"disableTLS: Boolean!",
		"from: String!",
		"password: String!",
		"sender: String!",
		"server: String!",
		"startTLSAuthMethod: Email_AuthMethod!",
		"username: String!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.Email_AuthMethod(0)))
	utils.Must(builder.AddType("EmbeddedImageScanComponent_Executable", []string{
		"dependencies: [String!]!",
		"path: String!",
	}))
	utils.Must(builder.AddType("EmbeddedSecret", []string{
		"name: String!",
		"path: String!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.EmbeddedVulnerability_ScoreVersion(0)))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.EmbeddedVulnerability_VulnerabilityType(0)))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.EnforcementAction(0)))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.EventSource(0)))
	utils.Must(builder.AddType("Exclusion", []string{
		"deployment: Exclusion_Deployment",
		"expiration: Time",
		"image: Exclusion_Image",
		"name: String!",
	}))
	utils.Must(builder.AddType("Exclusion_Deployment", []string{
		"name: String!",
		"scope: Scope",
	}))
	utils.Must(builder.AddType("Exclusion_Image", []string{
		"name: String!",
	}))
	utils.Must(builder.AddType("FalsePositiveRequest", []string{
	}))
	utils.Must(builder.AddInput("FalsePositiveVulnRequest", []string{
		"comment: String",
		"cve: String",
		"scope: VulnReqScope",
	}))
	utils.Must(builder.AddType("GenerateTokenResponse", []string{
		"metadata: TokenMetadata",
		"token: String!",
	}))
	utils.Must(builder.AddType("Generic", []string{
		"auditLoggingEnabled: Boolean!",
		"caCert: String!",
		"endpoint: String!",
		"extraFields: [KeyValuePair]!",
		"headers: [KeyValuePair]!",
		"password: String!",
		"skipTLSVerify: Boolean!",
		"username: String!",
	}))
	utils.Must(builder.AddType("GetComplianceRunStatusesResponse", []string{
		"invalidRunIds: [String!]!",
		"runs: [ComplianceRun]!",
	}))
	utils.Must(builder.AddType("GetPermissionsResponse", []string{
	}))
	utils.Must(builder.AddType("GoogleProviderMetadata", []string{
		"clusterName: String!",
		"project: String!",
	}))
	utils.Must(builder.AddType("Group", []string{
		"props: GroupProperties",
		"roleName: String!",
	}))
	utils.Must(builder.AddType("GroupProperties", []string{
		"authProviderId: String!",
		"key: String!",
		"value: String!",
	}))
	utils.Must(builder.AddType("HostMountPolicy", []string{
	}))
	utils.Must(builder.AddType("Image", []string{
		"id: ID!",
		"isClusterLocal: Boolean!",
		"lastUpdated: Time",
		"metadata: ImageMetadata",
		"name: ImageName",
		"notPullable: Boolean!",
		"notes: [Image_Note!]!",
		"priority: Int!",
		"riskScore: Float!",
		"scan: ImageScan",
		"signature: ImageSignature",
		"signatureVerificationData: ImageSignatureVerificationData",
	}))
	utils.Must(builder.AddType("ImageComponent", []string{
		"fixedBy: String!",
		"id: ID!",
		"license: License",
		"name: String!",
		"priority: Int!",
		"riskScore: Float!",
		"source: SourceType!",
		"version: String!",
	}))
	utils.Must(builder.AddType("ImageLayer", []string{
		"author: String!",
		"created: Time",
		"empty: Boolean!",
		"instruction: String!",
		"value: String!",
	}))
	utils.Must(builder.AddType("ImageMetadata", []string{
		"dataSource: DataSource",
		"layerShas: [String!]!",
		"v1: V1Metadata",
		"v2: V2Metadata",
	}))
	utils.Must(builder.AddType("ImageName", []string{
		"fullName: String!",
		"registry: String!",
		"remote: String!",
		"tag: String!",
	}))
	utils.Must(builder.AddType("ImageNamePolicy", []string{
		"registry: String!",
		"remote: String!",
		"tag: String!",
	}))
	utils.Must(builder.AddType("ImagePullSecret", []string{
		"registries: [ImagePullSecret_Registry]!",
	}))
	utils.Must(builder.AddType("ImagePullSecret_Registry", []string{
		"name: String!",
		"username: String!",
	}))
	utils.Must(builder.AddType("ImageScan", []string{
		"dataSource: DataSource",
		"notes: [ImageScan_Note!]!",
		"operatingSystem: String!",
		"scanTime: Time",
		"scannerVersion: String!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.ImageScan_Note(0)))
	utils.Must(builder.AddType("ImageSignature", []string{
		"signatures: [Signature]!",
	}))
	utils.Must(builder.AddType("ImageSignatureVerificationData", []string{
		"results: [ImageSignatureVerificationResult]!",
	}))
	utils.Must(builder.AddType("ImageSignatureVerificationResult", []string{
		"description: String!",
		"status: ImageSignatureVerificationResult_Status!",
		"verificationTime: Time",
		"verifierId: String!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.ImageSignatureVerificationResult_Status(0)))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.Image_Note(0)))
	utils.Must(builder.AddType("Jira", []string{
		"defaultFieldsJson: String!",
		"issueType: String!",
		"password: String!",
		"priorityMappings: [Jira_PriorityMapping]!",
		"url: String!",
		"username: String!",
	}))
	utils.Must(builder.AddType("Jira_PriorityMapping", []string{
		"priorityName: String!",
		"severity: Severity!",
	}))
	utils.Must(builder.AddType("K8SRole", []string{
		"annotations: [Label!]!",
		"clusterId: String!",
		"clusterName: String!",
		"clusterRole: Boolean!",
		"createdAt: Time",
		"id: ID!",
		"labels: [Label!]!",
		"name: String!",
		"namespace: String!",
		"rules: [PolicyRule]!",
	}))
	utils.Must(builder.AddType("K8SRoleBinding", []string{
		"annotations: [Label!]!",
		"clusterId: String!",
		"clusterName: String!",
		"clusterRole: Boolean!",
		"createdAt: Time",
		"id: ID!",
		"labels: [Label!]!",
		"name: String!",
		"namespace: String!",
		"roleId: String!",
		"subjects: [Subject]!",
	}))
	utils.Must(builder.AddType("KeyValuePair", []string{
		"key: String!",
		"value: String!",
	}))
	utils.Must(builder.AddType("KeyValuePolicy", []string{
		"envVarSource: ContainerConfig_EnvironmentConfig_EnvVarSource!",
		"key: String!",
		"value: String!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.L4Protocol(0)))
	utils.Must(builder.AddType("LabelSelector", []string{
		"matchLabels: [Label!]!",
		"requirements: [LabelSelector_Requirement]!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.LabelSelector_Operator(0)))
	utils.Must(builder.AddType("LabelSelector_Requirement", []string{
		"key: String!",
		"op: LabelSelector_Operator!",
		"values: [String!]!",
	}))
	utils.Must(builder.AddType("License", []string{
		"name: String!",
		"type: String!",
		"url: String!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.LifecycleStage(0)))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.ListAlert_ResourceType(0)))
	utils.Must(builder.AddType("LivenessProbe", []string{
		"defined: Boolean!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.ManagerType(0)))
	utils.Must(builder.AddType("Metadata", []string{
		"buildFlavor: String!",
		"licenseStatus: Metadata_LicenseStatus!",
		"releaseBuild: Boolean!",
		"version: String!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(v1.Metadata_LicenseStatus(0)))
	utils.Must(builder.AddType("MitreAttackVector", []string{
		"tactic: MitreTactic",
		"techniques: [MitreTechnique]!",
	}))
	utils.Must(builder.AddType("MitreTactic", []string{
		"description: String!",
		"id: ID!",
		"name: String!",
	}))
	utils.Must(builder.AddType("MitreTechnique", []string{
		"description: String!",
		"id: ID!",
		"name: String!",
	}))
	utils.Must(builder.AddType("Namespace", []string{
		"metadata: NamespaceMetadata",
		"numDeployments: Int!",
		"numNetworkPolicies: Int!",
		"numSecrets: Int!",
	}))
	utils.Must(builder.AddType("NamespaceMetadata", []string{
		"annotations: [Label!]!",
		"clusterId: String!",
		"clusterName: String!",
		"creationTime: Time",
		"id: ID!",
		"labels: [Label!]!",
		"name: String!",
		"priority: Int!",
	}))
	utils.Must(builder.AddType("NetworkEntityInfo", []string{
		"deployment: NetworkEntityInfo_Deployment",
		"externalSource: NetworkEntityInfo_ExternalSource",
		"id: ID!",
		"type: NetworkEntityInfo_Type!",
		"desc: NetworkEntityInfoDesc",
	}))
	utils.Must(builder.AddUnionType("NetworkEntityInfoDesc", []string{
		"NetworkEntityInfo_Deployment",
		"NetworkEntityInfo_ExternalSource",
	}))
	utils.Must(builder.AddType("NetworkEntityInfo_Deployment", []string{
		"cluster: String!",
		"listenPorts: [NetworkEntityInfo_Deployment_ListenPort]!",
		"name: String!",
		"namespace: String!",
	}))
	utils.Must(builder.AddType("NetworkEntityInfo_Deployment_ListenPort", []string{
		"l4Protocol: L4Protocol!",
		"port: Int!",
	}))
	utils.Must(builder.AddType("NetworkEntityInfo_ExternalSource", []string{
		"default: Boolean!",
		"name: String!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.NetworkEntityInfo_Type(0)))
	utils.Must(builder.AddType("NetworkFlow", []string{
		"lastSeenTimestamp: Time",
		"props: NetworkFlowProperties",
	}))
	utils.Must(builder.AddType("NetworkFlowProperties", []string{
		"dstEntity: NetworkEntityInfo",
		"dstPort: Int!",
		"l4Protocol: L4Protocol!",
		"srcEntity: NetworkEntityInfo",
	}))
	utils.Must(builder.AddType("Node", []string{
		"annotations: [Label!]!",
		"clusterId: String!",
		"clusterName: String!",
		"containerRuntime: ContainerRuntimeInfo",
		"containerRuntimeVersion: String!",
		"externalIpAddresses: [String!]!",
		"id: ID!",
		"internalIpAddresses: [String!]!",
		"joinedAt: Time",
		"k8SUpdated: Time",
		"kernelVersion: String!",
		"kubeProxyVersion: String!",
		"kubeletVersion: String!",
		"labels: [Label!]!",
		"lastUpdated: Time",
		"name: String!",
		"operatingSystem: String!",
		"osImage: String!",
		"priority: Int!",
		"riskScore: Float!",
		"scan: NodeScan",
		"taints: [Taint]!",
	}))
	utils.Must(builder.AddType("NodeScan", []string{
		"operatingSystem: String!",
		"scanTime: Time",
	}))
	utils.Must(builder.AddType("Notifier", []string{
		"awsSecurityHub: AWSSecurityHub",
		"cscc: CSCC",
		"email: Email",
		"generic: Generic",
		"id: ID!",
		"jira: Jira",
		"labelDefault: String!",
		"labelKey: String!",
		"name: String!",
		"pagerduty: PagerDuty",
		"splunk: Splunk",
		"sumologic: SumoLogic",
		"syslog: Syslog",
		"type: String!",
		"uiEndpoint: String!",
		"config: NotifierConfig",
	}))
	utils.Must(builder.AddUnionType("NotifierConfig", []string{
		"Jira",
		"Email",
		"CSCC",
		"Splunk",
		"PagerDuty",
		"Generic",
		"SumoLogic",
		"AWSSecurityHub",
		"Syslog",
	}))
	utils.Must(builder.AddType("NumericalPolicy", []string{
		"op: Comparator!",
		"value: Float!",
	}))
	utils.Must(builder.AddType("OrchestratorMetadata", []string{
		"apiVersions: [String!]!",
		"buildDate: Time",
		"version: String!",
	}))
	utils.Must(builder.AddType("PagerDuty", []string{
		"apiKey: String!",
	}))
	utils.Must(builder.AddInput("Pagination", []string{
		"limit: Int",
		"offset: Int",
		"sortOption: SortOption",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.PermissionLevel(0)))
	utils.Must(builder.AddType("PermissionPolicy", []string{
		"permissionLevel: PermissionLevel!",
	}))
	utils.Must(builder.AddType("PermissionSet", []string{
		"description: String!",
		"id: ID!",
		"name: String!",
	}))
	utils.Must(builder.AddType("Pod", []string{
		"clusterId: String!",
		"deploymentId: String!",
		"id: ID!",
		"liveInstances: [ContainerInstance]!",
		"name: String!",
		"namespace: String!",
		"started: Time",
		"terminatedInstances: [Pod_ContainerInstanceList]!",
	}))
	utils.Must(builder.AddType("Pod_ContainerInstanceList", []string{
		"instances: [ContainerInstance]!",
	}))
	utils.Must(builder.AddType("Policy", []string{
		"categories: [String!]!",
		"criteriaLocked: Boolean!",
		"description: String!",
		"disabled: Boolean!",
		"enforcementActions: [EnforcementAction!]!",
		"eventSource: EventSource!",
		"exclusions: [Exclusion]!",
		"fields: PolicyFields",
		"id: ID!",
		"isDefault: Boolean!",
		"lastUpdated: Time",
		"lifecycleStages: [LifecycleStage!]!",
		"mitreAttackVectors: [Policy_MitreAttackVectors]!",
		"mitreVectorsLocked: Boolean!",
		"name: String!",
		"notifiers: [String!]!",
		"policySections: [PolicySection]!",
		"policyVersion: String!",
		"rationale: String!",
		"remediation: String!",
		"sORTEnforcement: Boolean!",
		"sORTLifecycleStage: String!",
		"sORTName: String!",
		"scope: [Scope]!",
		"severity: Severity!",
	}))
	utils.Must(builder.AddType("PolicyFields", []string{
		"addCapabilities: [String!]!",
		"args: String!",
		"command: String!",
		"component: Component",
		"containerResourcePolicy: ResourcePolicy",
		"cve: String!",
		"cvss: NumericalPolicy",
		"directory: String!",
		"disallowedAnnotation: KeyValuePolicy",
		"disallowedImageLabel: KeyValuePolicy",
		"dropCapabilities: [String!]!",
		"env: KeyValuePolicy",
		"fixedBy: String!",
		"hostMountPolicy: HostMountPolicy",
		"imageName: ImageNamePolicy",
		"lineRule: DockerfileLineRuleField",
		"permissionPolicy: PermissionPolicy",
		"portExposurePolicy: PortExposurePolicy",
		"portPolicy: PortPolicy",
		"processPolicy: ProcessPolicy",
		"requiredAnnotation: KeyValuePolicy",
		"requiredImageLabel: KeyValuePolicy",
		"requiredLabel: KeyValuePolicy",
		"user: String!",
		"volumePolicy: VolumePolicy",
	}))
	utils.Must(builder.AddType("PolicyGroup", []string{
		"booleanOperator: BooleanOperator!",
		"fieldName: String!",
		"negate: Boolean!",
		"values: [PolicyValue]!",
	}))
	utils.Must(builder.AddType("PolicyRule", []string{
		"apiGroups: [String!]!",
		"nonResourceUrls: [String!]!",
		"resourceNames: [String!]!",
		"resources: [String!]!",
		"verbs: [String!]!",
	}))
	utils.Must(builder.AddType("PolicySection", []string{
		"policyGroups: [PolicyGroup]!",
		"sectionName: String!",
	}))
	utils.Must(builder.AddType("PolicyValue", []string{
		"value: String!",
	}))
	utils.Must(builder.AddType("Policy_MitreAttackVectors", []string{
		"tactic: String!",
		"techniques: [String!]!",
	}))
	utils.Must(builder.AddType("PortConfig", []string{
		"containerPort: Int!",
		"exposedPort: Int!",
		"exposure: PortConfig_ExposureLevel!",
		"exposureInfos: [PortConfig_ExposureInfo]!",
		"name: String!",
		"protocol: String!",
	}))
	utils.Must(builder.AddType("PortConfig_ExposureInfo", []string{
		"externalHostnames: [String!]!",
		"externalIps: [String!]!",
		"level: PortConfig_ExposureLevel!",
		"nodePort: Int!",
		"serviceClusterIp: String!",
		"serviceId: String!",
		"serviceName: String!",
		"servicePort: Int!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.PortConfig_ExposureLevel(0)))
	utils.Must(builder.AddType("PortExposurePolicy", []string{
		"exposureLevels: [PortConfig_ExposureLevel!]!",
	}))
	utils.Must(builder.AddType("PortPolicy", []string{
		"port: Int!",
		"protocol: String!",
	}))
	utils.Must(builder.AddType("ProcessGroup", []string{
		"args: String!",
		"signals: [ProcessIndicator]!",
	}))
	utils.Must(builder.AddType("ProcessIndicator", []string{
		"clusterId: String!",
		"containerName: String!",
		"containerStartTime: Time",
		"deploymentId: String!",
		"id: ID!",
		"imageId: String!",
		"namespace: String!",
		"podId: String!",
		"podUid: String!",
		"signal: ProcessSignal",
	}))
	utils.Must(builder.AddType("ProcessNameGroup", []string{
		"groups: [ProcessGroup]!",
		"name: String!",
		"timesExecuted: Int!",
	}))
	utils.Must(builder.AddInput("ProcessNoteKey", []string{
		"args: String!",
		"containerName: String!",
		"deploymentID: String!",
		"execFilePath: String!",
	}))
	utils.Must(builder.AddType("ProcessPolicy", []string{
		"ancestor: String!",
		"args: String!",
		"name: String!",
		"uid: String!",
	}))
	utils.Must(builder.AddType("ProcessSignal", []string{
		"args: String!",
		"containerId: String!",
		"execFilePath: String!",
		"gid: Int!",
		"id: ID!",
		"lineage: [String!]!",
		"lineageInfo: [ProcessSignal_LineageInfo]!",
		"name: String!",
		"pid: Int!",
		"scraped: Boolean!",
		"time: Time",
		"uid: Int!",
	}))
	utils.Must(builder.AddType("ProcessSignal_LineageInfo", []string{
		"parentExecFilePath: String!",
		"parentUid: Int!",
	}))
	utils.Must(builder.AddType("ProviderMetadata", []string{
		"aws: AWSProviderMetadata",
		"azure: AzureProviderMetadata",
		"google: GoogleProviderMetadata",
		"region: String!",
		"verified: Boolean!",
		"zone: String!",
		"provider: ProviderMetadataProvider",
	}))
	utils.Must(builder.AddUnionType("ProviderMetadataProvider", []string{
		"GoogleProviderMetadata",
		"AWSProviderMetadata",
		"AzureProviderMetadata",
	}))
	utils.Must(builder.AddType("ReadinessProbe", []string{
		"defined: Boolean!",
	}))
	utils.Must(builder.AddType("RequestComment", []string{
		"createdAt: Time",
		"id: ID!",
		"message: String!",
		"user: SlimUser",
	}))
	utils.Must(builder.AddType("ResourcePolicy", []string{
		"cpuResourceLimit: NumericalPolicy",
		"cpuResourceRequest: NumericalPolicy",
		"memoryResourceLimit: NumericalPolicy",
		"memoryResourceRequest: NumericalPolicy",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.ResourceType(0)))
	utils.Must(builder.AddType("Resources", []string{
		"cpuCoresLimit: Float!",
		"cpuCoresRequest: Float!",
		"memoryMbLimit: Float!",
		"memoryMbRequest: Float!",
	}))
	utils.Must(builder.AddType("Risk", []string{
		"id: ID!",
		"results: [Risk_Result]!",
		"score: Float!",
		"subject: RiskSubject",
	}))
	utils.Must(builder.AddType("RiskSubject", []string{
		"clusterId: String!",
		"id: ID!",
		"namespace: String!",
		"type: RiskSubjectType!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.RiskSubjectType(0)))
	utils.Must(builder.AddType("Risk_Result", []string{
		"factors: [Risk_Result_Factor]!",
		"name: String!",
		"score: Float!",
	}))
	utils.Must(builder.AddType("Risk_Result_Factor", []string{
		"message: String!",
		"url: String!",
	}))
	utils.Must(builder.AddType("Role", []string{
		"accessScopeId: String!",
		"description: String!",
		"globalAccess: Access!",
		"name: String!",
		"permissionSetId: String!",
	}))
	utils.Must(builder.AddType("Scope", []string{
		"cluster: String!",
		"label: Scope_Label",
		"namespace: String!",
	}))
	utils.Must(builder.AddType("Scope_Label", []string{
		"key: String!",
		"value: String!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(v1.SearchCategory(0)))
	utils.Must(builder.AddType("SearchResult", []string{
		"category: SearchCategory!",
		"id: ID!",
		"location: String!",
		"name: String!",
		"score: Float!",
	}))
	utils.Must(builder.AddType("Secret", []string{
		"annotations: [Label!]!",
		"clusterId: String!",
		"clusterName: String!",
		"createdAt: Time",
		"files: [SecretDataFile]!",
		"id: ID!",
		"labels: [Label!]!",
		"name: String!",
		"namespace: String!",
		"relationship: SecretRelationship",
		"type: String!",
	}))
	utils.Must(builder.AddType("SecretContainerRelationship", []string{
		"id: ID!",
		"path: String!",
	}))
	utils.Must(builder.AddType("SecretDataFile", []string{
		"cert: Cert",
		"imagePullSecret: ImagePullSecret",
		"name: String!",
		"type: SecretType!",
		"metadata: SecretDataFileMetadata",
	}))
	utils.Must(builder.AddUnionType("SecretDataFileMetadata", []string{
		"Cert",
		"ImagePullSecret",
	}))
	utils.Must(builder.AddType("SecretDeploymentRelationship", []string{
		"id: ID!",
		"name: String!",
	}))
	utils.Must(builder.AddType("SecretRelationship", []string{
		"containerRelationships: [SecretContainerRelationship]!",
		"deploymentRelationships: [SecretDeploymentRelationship]!",
		"id: ID!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.SecretType(0)))
	utils.Must(builder.AddType("SecurityContext", []string{
		"addCapabilities: [String!]!",
		"dropCapabilities: [String!]!",
		"privileged: Boolean!",
		"readOnlyRootFilesystem: Boolean!",
		"seccompProfile: SecurityContext_SeccompProfile",
		"selinux: SecurityContext_SELinux",
	}))
	utils.Must(builder.AddType("SecurityContext_SELinux", []string{
		"level: String!",
		"role: String!",
		"type: String!",
		"user: String!",
	}))
	utils.Must(builder.AddType("SecurityContext_SeccompProfile", []string{
		"localhostProfile: String!",
		"type: SecurityContext_SeccompProfile_ProfileType!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.SecurityContext_SeccompProfile_ProfileType(0)))
	utils.Must(builder.AddType("SensorDeploymentIdentification", []string{
		"appNamespace: String!",
		"appNamespaceId: String!",
		"appServiceaccountId: String!",
		"defaultNamespaceId: String!",
		"k8SNodeName: String!",
		"systemNamespaceId: String!",
	}))
	utils.Must(builder.AddType("ServiceAccount", []string{
		"annotations: [Label!]!",
		"automountToken: Boolean!",
		"clusterId: String!",
		"clusterName: String!",
		"createdAt: Time",
		"id: ID!",
		"imagePullSecrets: [String!]!",
		"labels: [Label!]!",
		"name: String!",
		"namespace: String!",
		"secrets: [String!]!",
	}))
	utils.Must(builder.AddType("SetBasedLabelSelector", []string{
		"requirements: [SetBasedLabelSelector_Requirement]!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.SetBasedLabelSelector_Operator(0)))
	utils.Must(builder.AddType("SetBasedLabelSelector_Requirement", []string{
		"key: String!",
		"op: SetBasedLabelSelector_Operator!",
		"values: [String!]!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.Severity(0)))
	utils.Must(builder.AddType("Signature", []string{
		"cosign: CosignSignature",
		"signature: SignatureSignature",
	}))
	utils.Must(builder.AddUnionType("SignatureSignature", []string{
		"CosignSignature",
	}))
	utils.Must(builder.AddType("SimpleAccessScope", []string{
		"description: String!",
		"id: ID!",
		"name: String!",
		"rules: SimpleAccessScope_Rules",
	}))
	utils.Must(builder.AddType("SimpleAccessScope_Rules", []string{
		"clusterLabelSelectors: [SetBasedLabelSelector]!",
		"includedClusters: [String!]!",
		"includedNamespaces: [SimpleAccessScope_Rules_Namespace]!",
		"namespaceLabelSelectors: [SetBasedLabelSelector]!",
	}))
	utils.Must(builder.AddType("SimpleAccessScope_Rules_Namespace", []string{
		"clusterName: String!",
		"namespaceName: String!",
	}))
	utils.Must(builder.AddType("SlimUser", []string{
		"id: ID!",
		"name: String!",
	}))
	utils.Must(builder.AddInput("SortOption", []string{
		"field: String",
		"reversed: Boolean",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.SourceType(0)))
	utils.Must(builder.AddType("Splunk", []string{
		"auditLoggingEnabled: Boolean!",
		"httpEndpoint: String!",
		"httpToken: String!",
		"insecure: Boolean!",
		"sourceTypes: [Label!]!",
		"truncate: Int!",
	}))
	utils.Must(builder.AddType("StaticClusterConfig", []string{
		"admissionController: Boolean!",
		"admissionControllerEvents: Boolean!",
		"admissionControllerUpdates: Boolean!",
		"centralApiEndpoint: String!",
		"collectionMethod: CollectionMethod!",
		"collectorImage: String!",
		"mainImage: String!",
		"slimCollector: Boolean!",
		"tolerationsConfig: TolerationsConfig",
		"type: ClusterType!",
	}))
	utils.Must(builder.AddType("Subject", []string{
		"clusterId: String!",
		"clusterName: String!",
		"id: ID!",
		"kind: SubjectKind!",
		"name: String!",
		"namespace: String!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.SubjectKind(0)))
	utils.Must(builder.AddType("SumoLogic", []string{
		"httpSourceAddress: String!",
		"skipTLSVerify: Boolean!",
	}))
	utils.Must(builder.AddType("Syslog", []string{
		"localFacility: Syslog_LocalFacility!",
		"tcpConfig: Syslog_TCPConfig",
		"endpoint: SyslogEndpoint",
	}))
	utils.Must(builder.AddUnionType("SyslogEndpoint", []string{
		"Syslog_TCPConfig",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.Syslog_LocalFacility(0)))
	utils.Must(builder.AddType("Syslog_TCPConfig", []string{
		"hostname: String!",
		"port: Int!",
		"skipTlsVerify: Boolean!",
		"useTls: Boolean!",
	}))
	utils.Must(builder.AddType("Taint", []string{
		"key: String!",
		"taintEffect: TaintEffect!",
		"value: String!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.TaintEffect(0)))
	utils.Must(builder.AddType("TokenMetadata", []string{
		"expiration: Time",
		"id: ID!",
		"issuedAt: Time",
		"name: String!",
		"revoked: Boolean!",
		"role: String!",
		"roles: [String!]!",
	}))
	utils.Must(builder.AddType("Toleration", []string{
		"key: String!",
		"operator: Toleration_Operator!",
		"taintEffect: TaintEffect!",
		"value: String!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.Toleration_Operator(0)))
	utils.Must(builder.AddType("TolerationsConfig", []string{
		"disabled: Boolean!",
	}))
	utils.Must(builder.AddType("UpgradeProgress", []string{
		"since: Time",
		"upgradeState: UpgradeProgress_UpgradeState!",
		"upgradeStatusDetail: String!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.UpgradeProgress_UpgradeState(0)))
	utils.Must(builder.AddType("V1Metadata", []string{
		"author: String!",
		"command: [String!]!",
		"created: Time",
		"digest: String!",
		"entrypoint: [String!]!",
		"labels: [Label!]!",
		"layers: [ImageLayer]!",
		"user: String!",
		"volumes: [String!]!",
	}))
	utils.Must(builder.AddType("V2Metadata", []string{
		"digest: String!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.ViolationState(0)))
	utils.Must(builder.AddType("Volume", []string{
		"destination: String!",
		"mountPropagation: Volume_MountPropagation!",
		"name: String!",
		"readOnly: Boolean!",
		"source: String!",
		"type: String!",
	}))
	utils.Must(builder.AddType("VolumePolicy", []string{
		"destination: String!",
		"name: String!",
		"source: String!",
		"type: String!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.Volume_MountPropagation(0)))
	utils.Must(builder.AddInput("VulnReqGlobalScope", []string{
		"images: VulnReqImageScope",
	}))
	utils.Must(builder.AddInput("VulnReqImageScope", []string{
		"registry: String",
		"remote: String",
		"tag: String",
	}))
	utils.Must(builder.AddInput("VulnReqScope", []string{
		"globalScope: VulnReqGlobalScope",
		"imageScope: VulnReqImageScope",
	}))
	utils.Must(builder.AddType("VulnerabilityRequest_CVEs", []string{
		"ids: [String!]!",
	}))
	utils.Must(builder.AddType("VulnerabilityRequest_Scope", []string{
		"globalScope: VulnerabilityRequest_Scope_Global",
		"imageScope: VulnerabilityRequest_Scope_Image",
		"info: VulnerabilityRequest_ScopeInfo",
	}))
	utils.Must(builder.AddUnionType("VulnerabilityRequest_ScopeInfo", []string{
		"VulnerabilityRequest_Scope_Image",
		"VulnerabilityRequest_Scope_Global",
	}))
	utils.Must(builder.AddType("VulnerabilityRequest_Scope_Global", []string{
	}))
	utils.Must(builder.AddType("VulnerabilityRequest_Scope_Image", []string{
		"registry: String!",
		"remote: String!",
		"tag: String!",
	}))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.VulnerabilitySeverity(0)))
	generator.RegisterProtoEnum(builder, reflect.TypeOf(storage.VulnerabilityState(0)))
}

type aWSProviderMetadataResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.AWSProviderMetadata
}

func (resolver *Resolver) wrapAWSProviderMetadata(value *storage.AWSProviderMetadata, ok bool, err error) (*aWSProviderMetadataResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &aWSProviderMetadataResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapAWSProviderMetadatas(values []*storage.AWSProviderMetadata, err error) ([]*aWSProviderMetadataResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*aWSProviderMetadataResolver, len(values))
	for i, v := range values {
		output[i] = &aWSProviderMetadataResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *aWSProviderMetadataResolver) AccountId(ctx context.Context) string {
	value := resolver.data.GetAccountId()
	return value
}

type aWSSecurityHubResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.AWSSecurityHub
}

func (resolver *Resolver) wrapAWSSecurityHub(value *storage.AWSSecurityHub, ok bool, err error) (*aWSSecurityHubResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &aWSSecurityHubResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapAWSSecurityHubs(values []*storage.AWSSecurityHub, err error) ([]*aWSSecurityHubResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*aWSSecurityHubResolver, len(values))
	for i, v := range values {
		output[i] = &aWSSecurityHubResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *aWSSecurityHubResolver) AccountId(ctx context.Context) string {
	value := resolver.data.GetAccountId()
	return value
}

func (resolver *aWSSecurityHubResolver) Credentials(ctx context.Context) (*aWSSecurityHub_CredentialsResolver, error) {
	value := resolver.data.GetCredentials()
	return resolver.root.wrapAWSSecurityHub_Credentials(value, true, nil)
}

func (resolver *aWSSecurityHubResolver) Region(ctx context.Context) string {
	value := resolver.data.GetRegion()
	return value
}

type aWSSecurityHub_CredentialsResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.AWSSecurityHub_Credentials
}

func (resolver *Resolver) wrapAWSSecurityHub_Credentials(value *storage.AWSSecurityHub_Credentials, ok bool, err error) (*aWSSecurityHub_CredentialsResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &aWSSecurityHub_CredentialsResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapAWSSecurityHub_Credentialses(values []*storage.AWSSecurityHub_Credentials, err error) ([]*aWSSecurityHub_CredentialsResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*aWSSecurityHub_CredentialsResolver, len(values))
	for i, v := range values {
		output[i] = &aWSSecurityHub_CredentialsResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *aWSSecurityHub_CredentialsResolver) AccessKeyId(ctx context.Context) string {
	value := resolver.data.GetAccessKeyId()
	return value
}

func (resolver *aWSSecurityHub_CredentialsResolver) SecretAccessKey(ctx context.Context) string {
	value := resolver.data.GetSecretAccessKey()
	return value
}

func toAccess(value *string) storage.Access {
	if value != nil {
		return storage.Access(storage.Access_value[*value])
	}
	return storage.Access(0)
}

func toAccesses(values *[]string) []storage.Access {
	if values == nil {
		return nil
	}
	output := make([]storage.Access, len(*values))
	for i, v := range *values {
		output[i] = toAccess(&v)
	}
	return output
}

type activeComponent_ActiveContextResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ActiveComponent_ActiveContext
}

func (resolver *Resolver) wrapActiveComponent_ActiveContext(value *storage.ActiveComponent_ActiveContext, ok bool, err error) (*activeComponent_ActiveContextResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &activeComponent_ActiveContextResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapActiveComponent_ActiveContexts(values []*storage.ActiveComponent_ActiveContext, err error) ([]*activeComponent_ActiveContextResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*activeComponent_ActiveContextResolver, len(values))
	for i, v := range values {
		output[i] = &activeComponent_ActiveContextResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *activeComponent_ActiveContextResolver) ContainerName(ctx context.Context) string {
	value := resolver.data.GetContainerName()
	return value
}

func (resolver *activeComponent_ActiveContextResolver) ImageId(ctx context.Context) string {
	value := resolver.data.GetImageId()
	return value
}

type admissionControlHealthInfoResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.AdmissionControlHealthInfo
}

func (resolver *Resolver) wrapAdmissionControlHealthInfo(value *storage.AdmissionControlHealthInfo, ok bool, err error) (*admissionControlHealthInfoResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &admissionControlHealthInfoResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapAdmissionControlHealthInfos(values []*storage.AdmissionControlHealthInfo, err error) ([]*admissionControlHealthInfoResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*admissionControlHealthInfoResolver, len(values))
	for i, v := range values {
		output[i] = &admissionControlHealthInfoResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *admissionControlHealthInfoResolver) StatusErrors(ctx context.Context) []string {
	value := resolver.data.GetStatusErrors()
	return value
}

type admissionControllerConfigResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.AdmissionControllerConfig
}

func (resolver *Resolver) wrapAdmissionControllerConfig(value *storage.AdmissionControllerConfig, ok bool, err error) (*admissionControllerConfigResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &admissionControllerConfigResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapAdmissionControllerConfigs(values []*storage.AdmissionControllerConfig, err error) ([]*admissionControllerConfigResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*admissionControllerConfigResolver, len(values))
	for i, v := range values {
		output[i] = &admissionControllerConfigResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *admissionControllerConfigResolver) DisableBypass(ctx context.Context) bool {
	value := resolver.data.GetDisableBypass()
	return value
}

func (resolver *admissionControllerConfigResolver) Enabled(ctx context.Context) bool {
	value := resolver.data.GetEnabled()
	return value
}

func (resolver *admissionControllerConfigResolver) EnforceOnUpdates(ctx context.Context) bool {
	value := resolver.data.GetEnforceOnUpdates()
	return value
}

func (resolver *admissionControllerConfigResolver) ScanInline(ctx context.Context) bool {
	value := resolver.data.GetScanInline()
	return value
}

func (resolver *admissionControllerConfigResolver) TimeoutSeconds(ctx context.Context) int32 {
	value := resolver.data.GetTimeoutSeconds()
	return value
}

type alertResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Alert
	list *storage.ListAlert
}

func (resolver *Resolver) wrapAlert(value *storage.Alert, ok bool, err error) (*alertResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &alertResolver{root: resolver, data: value, list: nil}, nil
}

func (resolver *Resolver) wrapAlerts(values []*storage.Alert, err error) ([]*alertResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*alertResolver, len(values))
	for i, v := range values {
		output[i] = &alertResolver{root: resolver, data: v, list: nil}
	}
	return output, nil
}

func (resolver *Resolver) wrapListAlerts(values []*storage.ListAlert, err error) ([]*alertResolver, error) {
	if err != nil || values == nil {
		return nil, err
	}
	output := make([]*alertResolver, len(values))
	for i, v := range values {
		output[i] = &alertResolver{root: resolver, data: nil, list: v}
	}
	return output, nil
}

func (resolver *alertResolver) ensureData(ctx context.Context) {
	if resolver.data == nil {
		resolver.data = resolver.root.getAlert(ctx, resolver.list.GetId())
	}
}

func (resolver *alertResolver) Deployment(ctx context.Context) (*alert_DeploymentResolver, error) {
	resolver.ensureData(ctx)
	value := resolver.data.GetDeployment()
	return resolver.root.wrapAlert_Deployment(value, true, nil)
}

func (resolver *alertResolver) Enforcement(ctx context.Context) (*alert_EnforcementResolver, error) {
	resolver.ensureData(ctx)
	value := resolver.data.GetEnforcement()
	return resolver.root.wrapAlert_Enforcement(value, true, nil)
}

func (resolver *alertResolver) FirstOccurred(ctx context.Context) (*graphql.Time, error) {
	resolver.ensureData(ctx)
	value := resolver.data.GetFirstOccurred()
	return timestamp(value)
}

func (resolver *alertResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	if resolver.data == nil {
		value = resolver.list.GetId()
	}
	return graphql.ID(value)
}

func (resolver *alertResolver) Image(ctx context.Context) (*containerImageResolver, error) {
	resolver.ensureData(ctx)
	value := resolver.data.GetImage()
	return resolver.root.wrapContainerImage(value, true, nil)
}

func (resolver *alertResolver) LifecycleStage(ctx context.Context) string {
	value := resolver.data.GetLifecycleStage()
	if resolver.data == nil {
		value = resolver.list.GetLifecycleStage()
	}
	return value.String()
}

func (resolver *alertResolver) Policy(ctx context.Context) (*policyResolver, error) {
	resolver.ensureData(ctx)
	value := resolver.data.GetPolicy()
	return resolver.root.wrapPolicy(value, true, nil)
}

func (resolver *alertResolver) ProcessViolation(ctx context.Context) (*alert_ProcessViolationResolver, error) {
	resolver.ensureData(ctx)
	value := resolver.data.GetProcessViolation()
	return resolver.root.wrapAlert_ProcessViolation(value, true, nil)
}

func (resolver *alertResolver) ResolvedAt(ctx context.Context) (*graphql.Time, error) {
	resolver.ensureData(ctx)
	value := resolver.data.GetResolvedAt()
	return timestamp(value)
}

func (resolver *alertResolver) Resource(ctx context.Context) (*alert_ResourceResolver, error) {
	resolver.ensureData(ctx)
	value := resolver.data.GetResource()
	return resolver.root.wrapAlert_Resource(value, true, nil)
}

func (resolver *alertResolver) SnoozeTill(ctx context.Context) (*graphql.Time, error) {
	resolver.ensureData(ctx)
	value := resolver.data.GetSnoozeTill()
	return timestamp(value)
}

func (resolver *alertResolver) State(ctx context.Context) string {
	value := resolver.data.GetState()
	if resolver.data == nil {
		value = resolver.list.GetState()
	}
	return value.String()
}

func (resolver *alertResolver) Tags(ctx context.Context) []string {
	value := resolver.data.GetTags()
	if resolver.data == nil {
		value = resolver.list.GetTags()
	}
	return value
}

func (resolver *alertResolver) Time(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetTime()
	if resolver.data == nil {
		value = resolver.list.GetTime()
	}
	return timestamp(value)
}

func (resolver *alertResolver) Violations(ctx context.Context) ([]*alert_ViolationResolver, error) {
	resolver.ensureData(ctx)
	value := resolver.data.GetViolations()
	return resolver.root.wrapAlert_Violations(value, nil)
}

type alertEntityResolver struct {
	resolver interface{}
}

func (resolver *alertResolver) Entity() *alertEntityResolver {
	if val := resolver.data.GetDeployment(); val != nil {
		return &alertEntityResolver{
			resolver: &alert_DeploymentResolver{root: resolver.root, data: val},
		}
	}
	if val := resolver.data.GetImage(); val != nil {
		return &alertEntityResolver{
			resolver: &containerImageResolver{root: resolver.root, data: val},
		}
	}
	if val := resolver.data.GetResource(); val != nil {
		return &alertEntityResolver{
			resolver: &alert_ResourceResolver{root: resolver.root, data: val},
		}
	}
	return nil
}

func (resolver *alertEntityResolver) ToAlert_Deployment() (*alert_DeploymentResolver, bool) {
	res, ok := resolver.resolver.(*alert_DeploymentResolver)
	return res, ok
}

func (resolver *alertEntityResolver) ToContainerImage() (*containerImageResolver, bool) {
	res, ok := resolver.resolver.(*containerImageResolver)
	return res, ok
}

func (resolver *alertEntityResolver) ToAlert_Resource() (*alert_ResourceResolver, bool) {
	res, ok := resolver.resolver.(*alert_ResourceResolver)
	return res, ok
}

type alert_DeploymentResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Alert_Deployment
}

func (resolver *Resolver) wrapAlert_Deployment(value *storage.Alert_Deployment, ok bool, err error) (*alert_DeploymentResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &alert_DeploymentResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapAlert_Deployments(values []*storage.Alert_Deployment, err error) ([]*alert_DeploymentResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*alert_DeploymentResolver, len(values))
	for i, v := range values {
		output[i] = &alert_DeploymentResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *alert_DeploymentResolver) Annotations(ctx context.Context) labels {
	value := resolver.data.GetAnnotations()
	return labelsResolver(value)
}

func (resolver *alert_DeploymentResolver) ClusterId(ctx context.Context) string {
	value := resolver.data.GetClusterId()
	return value
}

func (resolver *alert_DeploymentResolver) ClusterName(ctx context.Context) string {
	value := resolver.data.GetClusterName()
	return value
}

func (resolver *alert_DeploymentResolver) Containers(ctx context.Context) ([]*alert_Deployment_ContainerResolver, error) {
	value := resolver.data.GetContainers()
	return resolver.root.wrapAlert_Deployment_Containers(value, nil)
}

func (resolver *alert_DeploymentResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *alert_DeploymentResolver) Inactive(ctx context.Context) bool {
	value := resolver.data.GetInactive()
	return value
}

func (resolver *alert_DeploymentResolver) Labels(ctx context.Context) labels {
	value := resolver.data.GetLabels()
	return labelsResolver(value)
}

func (resolver *alert_DeploymentResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func (resolver *alert_DeploymentResolver) Namespace(ctx context.Context) string {
	value := resolver.data.GetNamespace()
	return value
}

func (resolver *alert_DeploymentResolver) NamespaceId(ctx context.Context) string {
	value := resolver.data.GetNamespaceId()
	return value
}

func (resolver *alert_DeploymentResolver) Type(ctx context.Context) string {
	value := resolver.data.GetType()
	return value
}

type alert_Deployment_ContainerResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Alert_Deployment_Container
}

func (resolver *Resolver) wrapAlert_Deployment_Container(value *storage.Alert_Deployment_Container, ok bool, err error) (*alert_Deployment_ContainerResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &alert_Deployment_ContainerResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapAlert_Deployment_Containers(values []*storage.Alert_Deployment_Container, err error) ([]*alert_Deployment_ContainerResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*alert_Deployment_ContainerResolver, len(values))
	for i, v := range values {
		output[i] = &alert_Deployment_ContainerResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *alert_Deployment_ContainerResolver) Image(ctx context.Context) (*containerImageResolver, error) {
	value := resolver.data.GetImage()
	return resolver.root.wrapContainerImage(value, true, nil)
}

func (resolver *alert_Deployment_ContainerResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

type alert_EnforcementResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Alert_Enforcement
}

func (resolver *Resolver) wrapAlert_Enforcement(value *storage.Alert_Enforcement, ok bool, err error) (*alert_EnforcementResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &alert_EnforcementResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapAlert_Enforcements(values []*storage.Alert_Enforcement, err error) ([]*alert_EnforcementResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*alert_EnforcementResolver, len(values))
	for i, v := range values {
		output[i] = &alert_EnforcementResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *alert_EnforcementResolver) Action(ctx context.Context) string {
	value := resolver.data.GetAction()
	return value.String()
}

func (resolver *alert_EnforcementResolver) Message(ctx context.Context) string {
	value := resolver.data.GetMessage()
	return value
}

type alert_ProcessViolationResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Alert_ProcessViolation
}

func (resolver *Resolver) wrapAlert_ProcessViolation(value *storage.Alert_ProcessViolation, ok bool, err error) (*alert_ProcessViolationResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &alert_ProcessViolationResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapAlert_ProcessViolations(values []*storage.Alert_ProcessViolation, err error) ([]*alert_ProcessViolationResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*alert_ProcessViolationResolver, len(values))
	for i, v := range values {
		output[i] = &alert_ProcessViolationResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *alert_ProcessViolationResolver) Message(ctx context.Context) string {
	value := resolver.data.GetMessage()
	return value
}

func (resolver *alert_ProcessViolationResolver) Processes(ctx context.Context) ([]*processIndicatorResolver, error) {
	value := resolver.data.GetProcesses()
	return resolver.root.wrapProcessIndicators(value, nil)
}

type alert_ResourceResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Alert_Resource
}

func (resolver *Resolver) wrapAlert_Resource(value *storage.Alert_Resource, ok bool, err error) (*alert_ResourceResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &alert_ResourceResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapAlert_Resources(values []*storage.Alert_Resource, err error) ([]*alert_ResourceResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*alert_ResourceResolver, len(values))
	for i, v := range values {
		output[i] = &alert_ResourceResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *alert_ResourceResolver) ClusterId(ctx context.Context) string {
	value := resolver.data.GetClusterId()
	return value
}

func (resolver *alert_ResourceResolver) ClusterName(ctx context.Context) string {
	value := resolver.data.GetClusterName()
	return value
}

func (resolver *alert_ResourceResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func (resolver *alert_ResourceResolver) Namespace(ctx context.Context) string {
	value := resolver.data.GetNamespace()
	return value
}

func (resolver *alert_ResourceResolver) NamespaceId(ctx context.Context) string {
	value := resolver.data.GetNamespaceId()
	return value
}

func (resolver *alert_ResourceResolver) ResourceType(ctx context.Context) string {
	value := resolver.data.GetResourceType()
	return value.String()
}

func toAlert_Resource_ResourceType(value *string) storage.Alert_Resource_ResourceType {
	if value != nil {
		return storage.Alert_Resource_ResourceType(storage.Alert_Resource_ResourceType_value[*value])
	}
	return storage.Alert_Resource_ResourceType(0)
}

func toAlert_Resource_ResourceTypes(values *[]string) []storage.Alert_Resource_ResourceType {
	if values == nil {
		return nil
	}
	output := make([]storage.Alert_Resource_ResourceType, len(*values))
	for i, v := range *values {
		output[i] = toAlert_Resource_ResourceType(&v)
	}
	return output
}

type alert_ViolationResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Alert_Violation
}

func (resolver *Resolver) wrapAlert_Violation(value *storage.Alert_Violation, ok bool, err error) (*alert_ViolationResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &alert_ViolationResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapAlert_Violations(values []*storage.Alert_Violation, err error) ([]*alert_ViolationResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*alert_ViolationResolver, len(values))
	for i, v := range values {
		output[i] = &alert_ViolationResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *alert_ViolationResolver) KeyValueAttrs(ctx context.Context) (*alert_Violation_KeyValueAttrsResolver, error) {
	value := resolver.data.GetKeyValueAttrs()
	return resolver.root.wrapAlert_Violation_KeyValueAttrs(value, true, nil)
}

func (resolver *alert_ViolationResolver) Message(ctx context.Context) string {
	value := resolver.data.GetMessage()
	return value
}

func (resolver *alert_ViolationResolver) NetworkFlowInfo(ctx context.Context) (*alert_Violation_NetworkFlowInfoResolver, error) {
	value := resolver.data.GetNetworkFlowInfo()
	return resolver.root.wrapAlert_Violation_NetworkFlowInfo(value, true, nil)
}

func (resolver *alert_ViolationResolver) Time(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetTime()
	return timestamp(value)
}

func (resolver *alert_ViolationResolver) Type(ctx context.Context) string {
	value := resolver.data.GetType()
	return value.String()
}

type alert_ViolationMessageAttributesResolver struct {
	resolver interface{}
}

func (resolver *alert_ViolationResolver) MessageAttributes() *alert_ViolationMessageAttributesResolver {
	if val := resolver.data.GetKeyValueAttrs(); val != nil {
		return &alert_ViolationMessageAttributesResolver{
			resolver: &alert_Violation_KeyValueAttrsResolver{root: resolver.root, data: val},
		}
	}
	if val := resolver.data.GetNetworkFlowInfo(); val != nil {
		return &alert_ViolationMessageAttributesResolver{
			resolver: &alert_Violation_NetworkFlowInfoResolver{root: resolver.root, data: val},
		}
	}
	return nil
}

func (resolver *alert_ViolationMessageAttributesResolver) ToAlert_Violation_KeyValueAttrs() (*alert_Violation_KeyValueAttrsResolver, bool) {
	res, ok := resolver.resolver.(*alert_Violation_KeyValueAttrsResolver)
	return res, ok
}

func (resolver *alert_ViolationMessageAttributesResolver) ToAlert_Violation_NetworkFlowInfo() (*alert_Violation_NetworkFlowInfoResolver, bool) {
	res, ok := resolver.resolver.(*alert_Violation_NetworkFlowInfoResolver)
	return res, ok
}

type alert_Violation_KeyValueAttrsResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Alert_Violation_KeyValueAttrs
}

func (resolver *Resolver) wrapAlert_Violation_KeyValueAttrs(value *storage.Alert_Violation_KeyValueAttrs, ok bool, err error) (*alert_Violation_KeyValueAttrsResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &alert_Violation_KeyValueAttrsResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapAlert_Violation_KeyValueAttrses(values []*storage.Alert_Violation_KeyValueAttrs, err error) ([]*alert_Violation_KeyValueAttrsResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*alert_Violation_KeyValueAttrsResolver, len(values))
	for i, v := range values {
		output[i] = &alert_Violation_KeyValueAttrsResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *alert_Violation_KeyValueAttrsResolver) Attrs(ctx context.Context) ([]*alert_Violation_KeyValueAttrs_KeyValueAttrResolver, error) {
	value := resolver.data.GetAttrs()
	return resolver.root.wrapAlert_Violation_KeyValueAttrs_KeyValueAttrs(value, nil)
}

type alert_Violation_KeyValueAttrs_KeyValueAttrResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Alert_Violation_KeyValueAttrs_KeyValueAttr
}

func (resolver *Resolver) wrapAlert_Violation_KeyValueAttrs_KeyValueAttr(value *storage.Alert_Violation_KeyValueAttrs_KeyValueAttr, ok bool, err error) (*alert_Violation_KeyValueAttrs_KeyValueAttrResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &alert_Violation_KeyValueAttrs_KeyValueAttrResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapAlert_Violation_KeyValueAttrs_KeyValueAttrs(values []*storage.Alert_Violation_KeyValueAttrs_KeyValueAttr, err error) ([]*alert_Violation_KeyValueAttrs_KeyValueAttrResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*alert_Violation_KeyValueAttrs_KeyValueAttrResolver, len(values))
	for i, v := range values {
		output[i] = &alert_Violation_KeyValueAttrs_KeyValueAttrResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *alert_Violation_KeyValueAttrs_KeyValueAttrResolver) Key(ctx context.Context) string {
	value := resolver.data.GetKey()
	return value
}

func (resolver *alert_Violation_KeyValueAttrs_KeyValueAttrResolver) Value(ctx context.Context) string {
	value := resolver.data.GetValue()
	return value
}

type alert_Violation_NetworkFlowInfoResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Alert_Violation_NetworkFlowInfo
}

func (resolver *Resolver) wrapAlert_Violation_NetworkFlowInfo(value *storage.Alert_Violation_NetworkFlowInfo, ok bool, err error) (*alert_Violation_NetworkFlowInfoResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &alert_Violation_NetworkFlowInfoResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapAlert_Violation_NetworkFlowInfos(values []*storage.Alert_Violation_NetworkFlowInfo, err error) ([]*alert_Violation_NetworkFlowInfoResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*alert_Violation_NetworkFlowInfoResolver, len(values))
	for i, v := range values {
		output[i] = &alert_Violation_NetworkFlowInfoResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *alert_Violation_NetworkFlowInfoResolver) Destination(ctx context.Context) (*alert_Violation_NetworkFlowInfo_EntityResolver, error) {
	value := resolver.data.GetDestination()
	return resolver.root.wrapAlert_Violation_NetworkFlowInfo_Entity(value, true, nil)
}

func (resolver *alert_Violation_NetworkFlowInfoResolver) Protocol(ctx context.Context) string {
	value := resolver.data.GetProtocol()
	return value.String()
}

func (resolver *alert_Violation_NetworkFlowInfoResolver) Source(ctx context.Context) (*alert_Violation_NetworkFlowInfo_EntityResolver, error) {
	value := resolver.data.GetSource()
	return resolver.root.wrapAlert_Violation_NetworkFlowInfo_Entity(value, true, nil)
}

type alert_Violation_NetworkFlowInfo_EntityResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Alert_Violation_NetworkFlowInfo_Entity
}

func (resolver *Resolver) wrapAlert_Violation_NetworkFlowInfo_Entity(value *storage.Alert_Violation_NetworkFlowInfo_Entity, ok bool, err error) (*alert_Violation_NetworkFlowInfo_EntityResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &alert_Violation_NetworkFlowInfo_EntityResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapAlert_Violation_NetworkFlowInfo_Entities(values []*storage.Alert_Violation_NetworkFlowInfo_Entity, err error) ([]*alert_Violation_NetworkFlowInfo_EntityResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*alert_Violation_NetworkFlowInfo_EntityResolver, len(values))
	for i, v := range values {
		output[i] = &alert_Violation_NetworkFlowInfo_EntityResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *alert_Violation_NetworkFlowInfo_EntityResolver) DeploymentNamespace(ctx context.Context) string {
	value := resolver.data.GetDeploymentNamespace()
	return value
}

func (resolver *alert_Violation_NetworkFlowInfo_EntityResolver) DeploymentType(ctx context.Context) string {
	value := resolver.data.GetDeploymentType()
	return value
}

func (resolver *alert_Violation_NetworkFlowInfo_EntityResolver) EntityType(ctx context.Context) string {
	value := resolver.data.GetEntityType()
	return value.String()
}

func (resolver *alert_Violation_NetworkFlowInfo_EntityResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func (resolver *alert_Violation_NetworkFlowInfo_EntityResolver) Port(ctx context.Context) int32 {
	value := resolver.data.GetPort()
	return value
}

func toAlert_Violation_Type(value *string) storage.Alert_Violation_Type {
	if value != nil {
		return storage.Alert_Violation_Type(storage.Alert_Violation_Type_value[*value])
	}
	return storage.Alert_Violation_Type(0)
}

func toAlert_Violation_Types(values *[]string) []storage.Alert_Violation_Type {
	if values == nil {
		return nil
	}
	output := make([]storage.Alert_Violation_Type, len(*values))
	for i, v := range *values {
		output[i] = toAlert_Violation_Type(&v)
	}
	return output
}

type azureProviderMetadataResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.AzureProviderMetadata
}

func (resolver *Resolver) wrapAzureProviderMetadata(value *storage.AzureProviderMetadata, ok bool, err error) (*azureProviderMetadataResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &azureProviderMetadataResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapAzureProviderMetadatas(values []*storage.AzureProviderMetadata, err error) ([]*azureProviderMetadataResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*azureProviderMetadataResolver, len(values))
	for i, v := range values {
		output[i] = &azureProviderMetadataResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *azureProviderMetadataResolver) SubscriptionId(ctx context.Context) string {
	value := resolver.data.GetSubscriptionId()
	return value
}

func toBooleanOperator(value *string) storage.BooleanOperator {
	if value != nil {
		return storage.BooleanOperator(storage.BooleanOperator_value[*value])
	}
	return storage.BooleanOperator(0)
}

func toBooleanOperators(values *[]string) []storage.BooleanOperator {
	if values == nil {
		return nil
	}
	output := make([]storage.BooleanOperator, len(*values))
	for i, v := range *values {
		output[i] = toBooleanOperator(&v)
	}
	return output
}

type cSCCResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.CSCC
}

func (resolver *Resolver) wrapCSCC(value *storage.CSCC, ok bool, err error) (*cSCCResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &cSCCResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapCSCCs(values []*storage.CSCC, err error) ([]*cSCCResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*cSCCResolver, len(values))
	for i, v := range values {
		output[i] = &cSCCResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *cSCCResolver) ServiceAccount(ctx context.Context) string {
	value := resolver.data.GetServiceAccount()
	return value
}

func (resolver *cSCCResolver) SourceId(ctx context.Context) string {
	value := resolver.data.GetSourceId()
	return value
}

type cVEResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.CVE
}

func (resolver *Resolver) wrapCVE(value *storage.CVE, ok bool, err error) (*cVEResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &cVEResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapCVEs(values []*storage.CVE, err error) ([]*cVEResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*cVEResolver, len(values))
	for i, v := range values {
		output[i] = &cVEResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *cVEResolver) CreatedAt(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetCreatedAt()
	return timestamp(value)
}

func (resolver *cVEResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *cVEResolver) ImpactScore(ctx context.Context) float64 {
	value := resolver.data.GetImpactScore()
	return float64(value)
}

func (resolver *cVEResolver) LastModified(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetLastModified()
	return timestamp(value)
}

func (resolver *cVEResolver) Link(ctx context.Context) string {
	value := resolver.data.GetLink()
	return value
}

func (resolver *cVEResolver) PublishedOn(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetPublishedOn()
	return timestamp(value)
}

func (resolver *cVEResolver) References(ctx context.Context) ([]*cVE_ReferenceResolver, error) {
	value := resolver.data.GetReferences()
	return resolver.root.wrapCVE_References(value, nil)
}

func (resolver *cVEResolver) ScoreVersion(ctx context.Context) string {
	value := resolver.data.GetScoreVersion()
	return value.String()
}

func (resolver *cVEResolver) Severity(ctx context.Context) string {
	value := resolver.data.GetSeverity()
	return value.String()
}

func (resolver *cVEResolver) Summary(ctx context.Context) string {
	value := resolver.data.GetSummary()
	return value
}

func (resolver *cVEResolver) SuppressActivation(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetSuppressActivation()
	return timestamp(value)
}

func (resolver *cVEResolver) SuppressExpiry(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetSuppressExpiry()
	return timestamp(value)
}

func (resolver *cVEResolver) Suppressed(ctx context.Context) bool {
	value := resolver.data.GetSuppressed()
	return value
}

func (resolver *cVEResolver) Type(ctx context.Context) string {
	value := resolver.data.GetType()
	return value.String()
}

func (resolver *cVEResolver) Types(ctx context.Context) []string {
	value := resolver.data.GetTypes()
	return stringSlice(value)
}

func toCVE_CVEType(value *string) storage.CVE_CVEType {
	if value != nil {
		return storage.CVE_CVEType(storage.CVE_CVEType_value[*value])
	}
	return storage.CVE_CVEType(0)
}

func toCVE_CVETypes(values *[]string) []storage.CVE_CVEType {
	if values == nil {
		return nil
	}
	output := make([]storage.CVE_CVEType, len(*values))
	for i, v := range *values {
		output[i] = toCVE_CVEType(&v)
	}
	return output
}

type cVE_ReferenceResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.CVE_Reference
}

func (resolver *Resolver) wrapCVE_Reference(value *storage.CVE_Reference, ok bool, err error) (*cVE_ReferenceResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &cVE_ReferenceResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapCVE_References(values []*storage.CVE_Reference, err error) ([]*cVE_ReferenceResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*cVE_ReferenceResolver, len(values))
	for i, v := range values {
		output[i] = &cVE_ReferenceResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *cVE_ReferenceResolver) Tags(ctx context.Context) []string {
	value := resolver.data.GetTags()
	return value
}

func (resolver *cVE_ReferenceResolver) URI(ctx context.Context) string {
	value := resolver.data.GetURI()
	return value
}

func toCVE_ScoreVersion(value *string) storage.CVE_ScoreVersion {
	if value != nil {
		return storage.CVE_ScoreVersion(storage.CVE_ScoreVersion_value[*value])
	}
	return storage.CVE_ScoreVersion(0)
}

func toCVE_ScoreVersions(values *[]string) []storage.CVE_ScoreVersion {
	if values == nil {
		return nil
	}
	output := make([]storage.CVE_ScoreVersion, len(*values))
	for i, v := range *values {
		output[i] = toCVE_ScoreVersion(&v)
	}
	return output
}

type cVSSV2Resolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.CVSSV2
}

func (resolver *Resolver) wrapCVSSV2(value *storage.CVSSV2, ok bool, err error) (*cVSSV2Resolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &cVSSV2Resolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapCVSSV2s(values []*storage.CVSSV2, err error) ([]*cVSSV2Resolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*cVSSV2Resolver, len(values))
	for i, v := range values {
		output[i] = &cVSSV2Resolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *cVSSV2Resolver) AccessComplexity(ctx context.Context) string {
	value := resolver.data.GetAccessComplexity()
	return value.String()
}

func (resolver *cVSSV2Resolver) AttackVector(ctx context.Context) string {
	value := resolver.data.GetAttackVector()
	return value.String()
}

func (resolver *cVSSV2Resolver) Authentication(ctx context.Context) string {
	value := resolver.data.GetAuthentication()
	return value.String()
}

func (resolver *cVSSV2Resolver) Availability(ctx context.Context) string {
	value := resolver.data.GetAvailability()
	return value.String()
}

func (resolver *cVSSV2Resolver) Confidentiality(ctx context.Context) string {
	value := resolver.data.GetConfidentiality()
	return value.String()
}

func (resolver *cVSSV2Resolver) ExploitabilityScore(ctx context.Context) float64 {
	value := resolver.data.GetExploitabilityScore()
	return float64(value)
}

func (resolver *cVSSV2Resolver) ImpactScore(ctx context.Context) float64 {
	value := resolver.data.GetImpactScore()
	return float64(value)
}

func (resolver *cVSSV2Resolver) Integrity(ctx context.Context) string {
	value := resolver.data.GetIntegrity()
	return value.String()
}

func (resolver *cVSSV2Resolver) Score(ctx context.Context) float64 {
	value := resolver.data.GetScore()
	return float64(value)
}

func (resolver *cVSSV2Resolver) Severity(ctx context.Context) string {
	value := resolver.data.GetSeverity()
	return value.String()
}

func (resolver *cVSSV2Resolver) Vector(ctx context.Context) string {
	value := resolver.data.GetVector()
	return value
}

func toCVSSV2_AccessComplexity(value *string) storage.CVSSV2_AccessComplexity {
	if value != nil {
		return storage.CVSSV2_AccessComplexity(storage.CVSSV2_AccessComplexity_value[*value])
	}
	return storage.CVSSV2_AccessComplexity(0)
}

func toCVSSV2_AccessComplexities(values *[]string) []storage.CVSSV2_AccessComplexity {
	if values == nil {
		return nil
	}
	output := make([]storage.CVSSV2_AccessComplexity, len(*values))
	for i, v := range *values {
		output[i] = toCVSSV2_AccessComplexity(&v)
	}
	return output
}

func toCVSSV2_AttackVector(value *string) storage.CVSSV2_AttackVector {
	if value != nil {
		return storage.CVSSV2_AttackVector(storage.CVSSV2_AttackVector_value[*value])
	}
	return storage.CVSSV2_AttackVector(0)
}

func toCVSSV2_AttackVectors(values *[]string) []storage.CVSSV2_AttackVector {
	if values == nil {
		return nil
	}
	output := make([]storage.CVSSV2_AttackVector, len(*values))
	for i, v := range *values {
		output[i] = toCVSSV2_AttackVector(&v)
	}
	return output
}

func toCVSSV2_Authentication(value *string) storage.CVSSV2_Authentication {
	if value != nil {
		return storage.CVSSV2_Authentication(storage.CVSSV2_Authentication_value[*value])
	}
	return storage.CVSSV2_Authentication(0)
}

func toCVSSV2_Authentications(values *[]string) []storage.CVSSV2_Authentication {
	if values == nil {
		return nil
	}
	output := make([]storage.CVSSV2_Authentication, len(*values))
	for i, v := range *values {
		output[i] = toCVSSV2_Authentication(&v)
	}
	return output
}

func toCVSSV2_Impact(value *string) storage.CVSSV2_Impact {
	if value != nil {
		return storage.CVSSV2_Impact(storage.CVSSV2_Impact_value[*value])
	}
	return storage.CVSSV2_Impact(0)
}

func toCVSSV2_Impacts(values *[]string) []storage.CVSSV2_Impact {
	if values == nil {
		return nil
	}
	output := make([]storage.CVSSV2_Impact, len(*values))
	for i, v := range *values {
		output[i] = toCVSSV2_Impact(&v)
	}
	return output
}

func toCVSSV2_Severity(value *string) storage.CVSSV2_Severity {
	if value != nil {
		return storage.CVSSV2_Severity(storage.CVSSV2_Severity_value[*value])
	}
	return storage.CVSSV2_Severity(0)
}

func toCVSSV2_Severities(values *[]string) []storage.CVSSV2_Severity {
	if values == nil {
		return nil
	}
	output := make([]storage.CVSSV2_Severity, len(*values))
	for i, v := range *values {
		output[i] = toCVSSV2_Severity(&v)
	}
	return output
}

type cVSSV3Resolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.CVSSV3
}

func (resolver *Resolver) wrapCVSSV3(value *storage.CVSSV3, ok bool, err error) (*cVSSV3Resolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &cVSSV3Resolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapCVSSV3s(values []*storage.CVSSV3, err error) ([]*cVSSV3Resolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*cVSSV3Resolver, len(values))
	for i, v := range values {
		output[i] = &cVSSV3Resolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *cVSSV3Resolver) AttackComplexity(ctx context.Context) string {
	value := resolver.data.GetAttackComplexity()
	return value.String()
}

func (resolver *cVSSV3Resolver) AttackVector(ctx context.Context) string {
	value := resolver.data.GetAttackVector()
	return value.String()
}

func (resolver *cVSSV3Resolver) Availability(ctx context.Context) string {
	value := resolver.data.GetAvailability()
	return value.String()
}

func (resolver *cVSSV3Resolver) Confidentiality(ctx context.Context) string {
	value := resolver.data.GetConfidentiality()
	return value.String()
}

func (resolver *cVSSV3Resolver) ExploitabilityScore(ctx context.Context) float64 {
	value := resolver.data.GetExploitabilityScore()
	return float64(value)
}

func (resolver *cVSSV3Resolver) ImpactScore(ctx context.Context) float64 {
	value := resolver.data.GetImpactScore()
	return float64(value)
}

func (resolver *cVSSV3Resolver) Integrity(ctx context.Context) string {
	value := resolver.data.GetIntegrity()
	return value.String()
}

func (resolver *cVSSV3Resolver) PrivilegesRequired(ctx context.Context) string {
	value := resolver.data.GetPrivilegesRequired()
	return value.String()
}

func (resolver *cVSSV3Resolver) Scope(ctx context.Context) string {
	value := resolver.data.GetScope()
	return value.String()
}

func (resolver *cVSSV3Resolver) Score(ctx context.Context) float64 {
	value := resolver.data.GetScore()
	return float64(value)
}

func (resolver *cVSSV3Resolver) Severity(ctx context.Context) string {
	value := resolver.data.GetSeverity()
	return value.String()
}

func (resolver *cVSSV3Resolver) UserInteraction(ctx context.Context) string {
	value := resolver.data.GetUserInteraction()
	return value.String()
}

func (resolver *cVSSV3Resolver) Vector(ctx context.Context) string {
	value := resolver.data.GetVector()
	return value
}

func toCVSSV3_AttackVector(value *string) storage.CVSSV3_AttackVector {
	if value != nil {
		return storage.CVSSV3_AttackVector(storage.CVSSV3_AttackVector_value[*value])
	}
	return storage.CVSSV3_AttackVector(0)
}

func toCVSSV3_AttackVectors(values *[]string) []storage.CVSSV3_AttackVector {
	if values == nil {
		return nil
	}
	output := make([]storage.CVSSV3_AttackVector, len(*values))
	for i, v := range *values {
		output[i] = toCVSSV3_AttackVector(&v)
	}
	return output
}

func toCVSSV3_Complexity(value *string) storage.CVSSV3_Complexity {
	if value != nil {
		return storage.CVSSV3_Complexity(storage.CVSSV3_Complexity_value[*value])
	}
	return storage.CVSSV3_Complexity(0)
}

func toCVSSV3_Complexities(values *[]string) []storage.CVSSV3_Complexity {
	if values == nil {
		return nil
	}
	output := make([]storage.CVSSV3_Complexity, len(*values))
	for i, v := range *values {
		output[i] = toCVSSV3_Complexity(&v)
	}
	return output
}

func toCVSSV3_Impact(value *string) storage.CVSSV3_Impact {
	if value != nil {
		return storage.CVSSV3_Impact(storage.CVSSV3_Impact_value[*value])
	}
	return storage.CVSSV3_Impact(0)
}

func toCVSSV3_Impacts(values *[]string) []storage.CVSSV3_Impact {
	if values == nil {
		return nil
	}
	output := make([]storage.CVSSV3_Impact, len(*values))
	for i, v := range *values {
		output[i] = toCVSSV3_Impact(&v)
	}
	return output
}

func toCVSSV3_Privileges(value *string) storage.CVSSV3_Privileges {
	if value != nil {
		return storage.CVSSV3_Privileges(storage.CVSSV3_Privileges_value[*value])
	}
	return storage.CVSSV3_Privileges(0)
}

func toCVSSV3_Privilegeses(values *[]string) []storage.CVSSV3_Privileges {
	if values == nil {
		return nil
	}
	output := make([]storage.CVSSV3_Privileges, len(*values))
	for i, v := range *values {
		output[i] = toCVSSV3_Privileges(&v)
	}
	return output
}

func toCVSSV3_Scope(value *string) storage.CVSSV3_Scope {
	if value != nil {
		return storage.CVSSV3_Scope(storage.CVSSV3_Scope_value[*value])
	}
	return storage.CVSSV3_Scope(0)
}

func toCVSSV3_Scopes(values *[]string) []storage.CVSSV3_Scope {
	if values == nil {
		return nil
	}
	output := make([]storage.CVSSV3_Scope, len(*values))
	for i, v := range *values {
		output[i] = toCVSSV3_Scope(&v)
	}
	return output
}

func toCVSSV3_Severity(value *string) storage.CVSSV3_Severity {
	if value != nil {
		return storage.CVSSV3_Severity(storage.CVSSV3_Severity_value[*value])
	}
	return storage.CVSSV3_Severity(0)
}

func toCVSSV3_Severities(values *[]string) []storage.CVSSV3_Severity {
	if values == nil {
		return nil
	}
	output := make([]storage.CVSSV3_Severity, len(*values))
	for i, v := range *values {
		output[i] = toCVSSV3_Severity(&v)
	}
	return output
}

func toCVSSV3_UserInteraction(value *string) storage.CVSSV3_UserInteraction {
	if value != nil {
		return storage.CVSSV3_UserInteraction(storage.CVSSV3_UserInteraction_value[*value])
	}
	return storage.CVSSV3_UserInteraction(0)
}

func toCVSSV3_UserInteractions(values *[]string) []storage.CVSSV3_UserInteraction {
	if values == nil {
		return nil
	}
	output := make([]storage.CVSSV3_UserInteraction, len(*values))
	for i, v := range *values {
		output[i] = toCVSSV3_UserInteraction(&v)
	}
	return output
}

type certResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Cert
}

func (resolver *Resolver) wrapCert(value *storage.Cert, ok bool, err error) (*certResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &certResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapCerts(values []*storage.Cert, err error) ([]*certResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*certResolver, len(values))
	for i, v := range values {
		output[i] = &certResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *certResolver) Algorithm(ctx context.Context) string {
	value := resolver.data.GetAlgorithm()
	return value
}

func (resolver *certResolver) EndDate(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetEndDate()
	return timestamp(value)
}

func (resolver *certResolver) Issuer(ctx context.Context) (*certNameResolver, error) {
	value := resolver.data.GetIssuer()
	return resolver.root.wrapCertName(value, true, nil)
}

func (resolver *certResolver) Sans(ctx context.Context) []string {
	value := resolver.data.GetSans()
	return value
}

func (resolver *certResolver) StartDate(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetStartDate()
	return timestamp(value)
}

func (resolver *certResolver) Subject(ctx context.Context) (*certNameResolver, error) {
	value := resolver.data.GetSubject()
	return resolver.root.wrapCertName(value, true, nil)
}

type certNameResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.CertName
}

func (resolver *Resolver) wrapCertName(value *storage.CertName, ok bool, err error) (*certNameResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &certNameResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapCertNames(values []*storage.CertName, err error) ([]*certNameResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*certNameResolver, len(values))
	for i, v := range values {
		output[i] = &certNameResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *certNameResolver) CommonName(ctx context.Context) string {
	value := resolver.data.GetCommonName()
	return value
}

func (resolver *certNameResolver) Country(ctx context.Context) string {
	value := resolver.data.GetCountry()
	return value
}

func (resolver *certNameResolver) Locality(ctx context.Context) string {
	value := resolver.data.GetLocality()
	return value
}

func (resolver *certNameResolver) Names(ctx context.Context) []string {
	value := resolver.data.GetNames()
	return value
}

func (resolver *certNameResolver) Organization(ctx context.Context) string {
	value := resolver.data.GetOrganization()
	return value
}

func (resolver *certNameResolver) OrganizationUnit(ctx context.Context) string {
	value := resolver.data.GetOrganizationUnit()
	return value
}

func (resolver *certNameResolver) PostalCode(ctx context.Context) string {
	value := resolver.data.GetPostalCode()
	return value
}

func (resolver *certNameResolver) Province(ctx context.Context) string {
	value := resolver.data.GetProvince()
	return value
}

func (resolver *certNameResolver) StreetAddress(ctx context.Context) string {
	value := resolver.data.GetStreetAddress()
	return value
}

type clusterResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Cluster
}

func (resolver *Resolver) wrapCluster(value *storage.Cluster, ok bool, err error) (*clusterResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &clusterResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapClusters(values []*storage.Cluster, err error) ([]*clusterResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*clusterResolver, len(values))
	for i, v := range values {
		output[i] = &clusterResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *clusterResolver) AdmissionController(ctx context.Context) bool {
	value := resolver.data.GetAdmissionController()
	return value
}

func (resolver *clusterResolver) AdmissionControllerEvents(ctx context.Context) bool {
	value := resolver.data.GetAdmissionControllerEvents()
	return value
}

func (resolver *clusterResolver) AdmissionControllerUpdates(ctx context.Context) bool {
	value := resolver.data.GetAdmissionControllerUpdates()
	return value
}

func (resolver *clusterResolver) CentralApiEndpoint(ctx context.Context) string {
	value := resolver.data.GetCentralApiEndpoint()
	return value
}

func (resolver *clusterResolver) CollectionMethod(ctx context.Context) string {
	value := resolver.data.GetCollectionMethod()
	return value.String()
}

func (resolver *clusterResolver) CollectorImage(ctx context.Context) string {
	value := resolver.data.GetCollectorImage()
	return value
}

func (resolver *clusterResolver) DynamicConfig(ctx context.Context) (*dynamicClusterConfigResolver, error) {
	value := resolver.data.GetDynamicConfig()
	return resolver.root.wrapDynamicClusterConfig(value, true, nil)
}

func (resolver *clusterResolver) HealthStatus(ctx context.Context) (*clusterHealthStatusResolver, error) {
	value := resolver.data.GetHealthStatus()
	return resolver.root.wrapClusterHealthStatus(value, true, nil)
}

func (resolver *clusterResolver) HelmConfig(ctx context.Context) (*completeClusterConfigResolver, error) {
	value := resolver.data.GetHelmConfig()
	return resolver.root.wrapCompleteClusterConfig(value, true, nil)
}

func (resolver *clusterResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *clusterResolver) InitBundleId(ctx context.Context) string {
	value := resolver.data.GetInitBundleId()
	return value
}

func (resolver *clusterResolver) Labels(ctx context.Context) labels {
	value := resolver.data.GetLabels()
	return labelsResolver(value)
}

func (resolver *clusterResolver) MainImage(ctx context.Context) string {
	value := resolver.data.GetMainImage()
	return value
}

func (resolver *clusterResolver) ManagedBy(ctx context.Context) string {
	value := resolver.data.GetManagedBy()
	return value.String()
}

func (resolver *clusterResolver) MostRecentSensorId(ctx context.Context) (*sensorDeploymentIdentificationResolver, error) {
	value := resolver.data.GetMostRecentSensorId()
	return resolver.root.wrapSensorDeploymentIdentification(value, true, nil)
}

func (resolver *clusterResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func (resolver *clusterResolver) Priority(ctx context.Context) int32 {
	value := resolver.data.GetPriority()
	return int32(value)
}

func (resolver *clusterResolver) RuntimeSupport(ctx context.Context) bool {
	value := resolver.data.GetRuntimeSupport()
	return value
}

func (resolver *clusterResolver) SlimCollector(ctx context.Context) bool {
	value := resolver.data.GetSlimCollector()
	return value
}

func (resolver *clusterResolver) Status(ctx context.Context) (*clusterStatusResolver, error) {
	value := resolver.data.GetStatus()
	return resolver.root.wrapClusterStatus(value, true, nil)
}

func (resolver *clusterResolver) TolerationsConfig(ctx context.Context) (*tolerationsConfigResolver, error) {
	value := resolver.data.GetTolerationsConfig()
	return resolver.root.wrapTolerationsConfig(value, true, nil)
}

func (resolver *clusterResolver) Type(ctx context.Context) string {
	value := resolver.data.GetType()
	return value.String()
}

type clusterCertExpiryStatusResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ClusterCertExpiryStatus
}

func (resolver *Resolver) wrapClusterCertExpiryStatus(value *storage.ClusterCertExpiryStatus, ok bool, err error) (*clusterCertExpiryStatusResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &clusterCertExpiryStatusResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapClusterCertExpiryStatuses(values []*storage.ClusterCertExpiryStatus, err error) ([]*clusterCertExpiryStatusResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*clusterCertExpiryStatusResolver, len(values))
	for i, v := range values {
		output[i] = &clusterCertExpiryStatusResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *clusterCertExpiryStatusResolver) SensorCertExpiry(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetSensorCertExpiry()
	return timestamp(value)
}

type clusterHealthStatusResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ClusterHealthStatus
}

func (resolver *Resolver) wrapClusterHealthStatus(value *storage.ClusterHealthStatus, ok bool, err error) (*clusterHealthStatusResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &clusterHealthStatusResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapClusterHealthStatuses(values []*storage.ClusterHealthStatus, err error) ([]*clusterHealthStatusResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*clusterHealthStatusResolver, len(values))
	for i, v := range values {
		output[i] = &clusterHealthStatusResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *clusterHealthStatusResolver) AdmissionControlHealthInfo(ctx context.Context) (*admissionControlHealthInfoResolver, error) {
	value := resolver.data.GetAdmissionControlHealthInfo()
	return resolver.root.wrapAdmissionControlHealthInfo(value, true, nil)
}

func (resolver *clusterHealthStatusResolver) AdmissionControlHealthStatus(ctx context.Context) string {
	value := resolver.data.GetAdmissionControlHealthStatus()
	return value.String()
}

func (resolver *clusterHealthStatusResolver) CollectorHealthInfo(ctx context.Context) (*collectorHealthInfoResolver, error) {
	value := resolver.data.GetCollectorHealthInfo()
	return resolver.root.wrapCollectorHealthInfo(value, true, nil)
}

func (resolver *clusterHealthStatusResolver) CollectorHealthStatus(ctx context.Context) string {
	value := resolver.data.GetCollectorHealthStatus()
	return value.String()
}

func (resolver *clusterHealthStatusResolver) HealthInfoComplete(ctx context.Context) bool {
	value := resolver.data.GetHealthInfoComplete()
	return value
}

func (resolver *clusterHealthStatusResolver) LastContact(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetLastContact()
	return timestamp(value)
}

func (resolver *clusterHealthStatusResolver) OverallHealthStatus(ctx context.Context) string {
	value := resolver.data.GetOverallHealthStatus()
	return value.String()
}

func (resolver *clusterHealthStatusResolver) SensorHealthStatus(ctx context.Context) string {
	value := resolver.data.GetSensorHealthStatus()
	return value.String()
}

func toClusterHealthStatus_HealthStatusLabel(value *string) storage.ClusterHealthStatus_HealthStatusLabel {
	if value != nil {
		return storage.ClusterHealthStatus_HealthStatusLabel(storage.ClusterHealthStatus_HealthStatusLabel_value[*value])
	}
	return storage.ClusterHealthStatus_HealthStatusLabel(0)
}

func toClusterHealthStatus_HealthStatusLabels(values *[]string) []storage.ClusterHealthStatus_HealthStatusLabel {
	if values == nil {
		return nil
	}
	output := make([]storage.ClusterHealthStatus_HealthStatusLabel, len(*values))
	for i, v := range *values {
		output[i] = toClusterHealthStatus_HealthStatusLabel(&v)
	}
	return output
}

type clusterStatusResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ClusterStatus
}

func (resolver *Resolver) wrapClusterStatus(value *storage.ClusterStatus, ok bool, err error) (*clusterStatusResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &clusterStatusResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapClusterStatuses(values []*storage.ClusterStatus, err error) ([]*clusterStatusResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*clusterStatusResolver, len(values))
	for i, v := range values {
		output[i] = &clusterStatusResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *clusterStatusResolver) CertExpiryStatus(ctx context.Context) (*clusterCertExpiryStatusResolver, error) {
	value := resolver.data.GetCertExpiryStatus()
	return resolver.root.wrapClusterCertExpiryStatus(value, true, nil)
}

func (resolver *clusterStatusResolver) OrchestratorMetadata(ctx context.Context) (*orchestratorMetadataResolver, error) {
	value := resolver.data.GetOrchestratorMetadata()
	return resolver.root.wrapOrchestratorMetadata(value, true, nil)
}

func (resolver *clusterStatusResolver) ProviderMetadata(ctx context.Context) (*providerMetadataResolver, error) {
	value := resolver.data.GetProviderMetadata()
	return resolver.root.wrapProviderMetadata(value, true, nil)
}

func (resolver *clusterStatusResolver) SensorVersion(ctx context.Context) string {
	value := resolver.data.GetSensorVersion()
	return value
}

func (resolver *clusterStatusResolver) UpgradeStatus(ctx context.Context) (*clusterUpgradeStatusResolver, error) {
	value := resolver.data.GetUpgradeStatus()
	return resolver.root.wrapClusterUpgradeStatus(value, true, nil)
}

func toClusterType(value *string) storage.ClusterType {
	if value != nil {
		return storage.ClusterType(storage.ClusterType_value[*value])
	}
	return storage.ClusterType(0)
}

func toClusterTypes(values *[]string) []storage.ClusterType {
	if values == nil {
		return nil
	}
	output := make([]storage.ClusterType, len(*values))
	for i, v := range *values {
		output[i] = toClusterType(&v)
	}
	return output
}

type clusterUpgradeStatusResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ClusterUpgradeStatus
}

func (resolver *Resolver) wrapClusterUpgradeStatus(value *storage.ClusterUpgradeStatus, ok bool, err error) (*clusterUpgradeStatusResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &clusterUpgradeStatusResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapClusterUpgradeStatuses(values []*storage.ClusterUpgradeStatus, err error) ([]*clusterUpgradeStatusResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*clusterUpgradeStatusResolver, len(values))
	for i, v := range values {
		output[i] = &clusterUpgradeStatusResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *clusterUpgradeStatusResolver) MostRecentProcess(ctx context.Context) (*clusterUpgradeStatus_UpgradeProcessStatusResolver, error) {
	value := resolver.data.GetMostRecentProcess()
	return resolver.root.wrapClusterUpgradeStatus_UpgradeProcessStatus(value, true, nil)
}

func (resolver *clusterUpgradeStatusResolver) Upgradability(ctx context.Context) string {
	value := resolver.data.GetUpgradability()
	return value.String()
}

func (resolver *clusterUpgradeStatusResolver) UpgradabilityStatusReason(ctx context.Context) string {
	value := resolver.data.GetUpgradabilityStatusReason()
	return value
}

func toClusterUpgradeStatus_Upgradability(value *string) storage.ClusterUpgradeStatus_Upgradability {
	if value != nil {
		return storage.ClusterUpgradeStatus_Upgradability(storage.ClusterUpgradeStatus_Upgradability_value[*value])
	}
	return storage.ClusterUpgradeStatus_Upgradability(0)
}

func toClusterUpgradeStatus_Upgradabilities(values *[]string) []storage.ClusterUpgradeStatus_Upgradability {
	if values == nil {
		return nil
	}
	output := make([]storage.ClusterUpgradeStatus_Upgradability, len(*values))
	for i, v := range *values {
		output[i] = toClusterUpgradeStatus_Upgradability(&v)
	}
	return output
}

type clusterUpgradeStatus_UpgradeProcessStatusResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ClusterUpgradeStatus_UpgradeProcessStatus
}

func (resolver *Resolver) wrapClusterUpgradeStatus_UpgradeProcessStatus(value *storage.ClusterUpgradeStatus_UpgradeProcessStatus, ok bool, err error) (*clusterUpgradeStatus_UpgradeProcessStatusResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &clusterUpgradeStatus_UpgradeProcessStatusResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapClusterUpgradeStatus_UpgradeProcessStatuses(values []*storage.ClusterUpgradeStatus_UpgradeProcessStatus, err error) ([]*clusterUpgradeStatus_UpgradeProcessStatusResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*clusterUpgradeStatus_UpgradeProcessStatusResolver, len(values))
	for i, v := range values {
		output[i] = &clusterUpgradeStatus_UpgradeProcessStatusResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *clusterUpgradeStatus_UpgradeProcessStatusResolver) Active(ctx context.Context) bool {
	value := resolver.data.GetActive()
	return value
}

func (resolver *clusterUpgradeStatus_UpgradeProcessStatusResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *clusterUpgradeStatus_UpgradeProcessStatusResolver) InitiatedAt(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetInitiatedAt()
	return timestamp(value)
}

func (resolver *clusterUpgradeStatus_UpgradeProcessStatusResolver) Progress(ctx context.Context) (*upgradeProgressResolver, error) {
	value := resolver.data.GetProgress()
	return resolver.root.wrapUpgradeProgress(value, true, nil)
}

func (resolver *clusterUpgradeStatus_UpgradeProcessStatusResolver) TargetVersion(ctx context.Context) string {
	value := resolver.data.GetTargetVersion()
	return value
}

func (resolver *clusterUpgradeStatus_UpgradeProcessStatusResolver) Type(ctx context.Context) string {
	value := resolver.data.GetType()
	return value.String()
}

func (resolver *clusterUpgradeStatus_UpgradeProcessStatusResolver) UpgraderImage(ctx context.Context) string {
	value := resolver.data.GetUpgraderImage()
	return value
}

func toClusterUpgradeStatus_UpgradeProcessStatus_UpgradeProcessType(value *string) storage.ClusterUpgradeStatus_UpgradeProcessStatus_UpgradeProcessType {
	if value != nil {
		return storage.ClusterUpgradeStatus_UpgradeProcessStatus_UpgradeProcessType(storage.ClusterUpgradeStatus_UpgradeProcessStatus_UpgradeProcessType_value[*value])
	}
	return storage.ClusterUpgradeStatus_UpgradeProcessStatus_UpgradeProcessType(0)
}

func toClusterUpgradeStatus_UpgradeProcessStatus_UpgradeProcessTypes(values *[]string) []storage.ClusterUpgradeStatus_UpgradeProcessStatus_UpgradeProcessType {
	if values == nil {
		return nil
	}
	output := make([]storage.ClusterUpgradeStatus_UpgradeProcessStatus_UpgradeProcessType, len(*values))
	for i, v := range *values {
		output[i] = toClusterUpgradeStatus_UpgradeProcessStatus_UpgradeProcessType(&v)
	}
	return output
}

func toCollectionMethod(value *string) storage.CollectionMethod {
	if value != nil {
		return storage.CollectionMethod(storage.CollectionMethod_value[*value])
	}
	return storage.CollectionMethod(0)
}

func toCollectionMethods(values *[]string) []storage.CollectionMethod {
	if values == nil {
		return nil
	}
	output := make([]storage.CollectionMethod, len(*values))
	for i, v := range *values {
		output[i] = toCollectionMethod(&v)
	}
	return output
}

type collectorHealthInfoResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.CollectorHealthInfo
}

func (resolver *Resolver) wrapCollectorHealthInfo(value *storage.CollectorHealthInfo, ok bool, err error) (*collectorHealthInfoResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &collectorHealthInfoResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapCollectorHealthInfos(values []*storage.CollectorHealthInfo, err error) ([]*collectorHealthInfoResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*collectorHealthInfoResolver, len(values))
	for i, v := range values {
		output[i] = &collectorHealthInfoResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *collectorHealthInfoResolver) StatusErrors(ctx context.Context) []string {
	value := resolver.data.GetStatusErrors()
	return value
}

func (resolver *collectorHealthInfoResolver) Version(ctx context.Context) string {
	value := resolver.data.GetVersion()
	return value
}

type commentResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Comment
}

func (resolver *Resolver) wrapComment(value *storage.Comment, ok bool, err error) (*commentResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &commentResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapComments(values []*storage.Comment, err error) ([]*commentResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*commentResolver, len(values))
	for i, v := range values {
		output[i] = &commentResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *commentResolver) CommentId(ctx context.Context) string {
	value := resolver.data.GetCommentId()
	return value
}

func (resolver *commentResolver) CommentMessage(ctx context.Context) string {
	value := resolver.data.GetCommentMessage()
	return value
}

func (resolver *commentResolver) CreatedAt(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetCreatedAt()
	return timestamp(value)
}

func (resolver *commentResolver) LastModified(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetLastModified()
	return timestamp(value)
}

func (resolver *commentResolver) ResourceId(ctx context.Context) string {
	value := resolver.data.GetResourceId()
	return value
}

func (resolver *commentResolver) ResourceType(ctx context.Context) string {
	value := resolver.data.GetResourceType()
	return value.String()
}

func (resolver *commentResolver) User(ctx context.Context) (*comment_UserResolver, error) {
	value := resolver.data.GetUser()
	return resolver.root.wrapComment_User(value, true, nil)
}

type comment_UserResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Comment_User
}

func (resolver *Resolver) wrapComment_User(value *storage.Comment_User, ok bool, err error) (*comment_UserResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &comment_UserResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapComment_Users(values []*storage.Comment_User, err error) ([]*comment_UserResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*comment_UserResolver, len(values))
	for i, v := range values {
		output[i] = &comment_UserResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *comment_UserResolver) Email(ctx context.Context) string {
	value := resolver.data.GetEmail()
	return value
}

func (resolver *comment_UserResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *comment_UserResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func toComparator(value *string) storage.Comparator {
	if value != nil {
		return storage.Comparator(storage.Comparator_value[*value])
	}
	return storage.Comparator(0)
}

func toComparators(values *[]string) []storage.Comparator {
	if values == nil {
		return nil
	}
	output := make([]storage.Comparator, len(*values))
	for i, v := range *values {
		output[i] = toComparator(&v)
	}
	return output
}

type completeClusterConfigResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.CompleteClusterConfig
}

func (resolver *Resolver) wrapCompleteClusterConfig(value *storage.CompleteClusterConfig, ok bool, err error) (*completeClusterConfigResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &completeClusterConfigResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapCompleteClusterConfigs(values []*storage.CompleteClusterConfig, err error) ([]*completeClusterConfigResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*completeClusterConfigResolver, len(values))
	for i, v := range values {
		output[i] = &completeClusterConfigResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *completeClusterConfigResolver) ClusterLabels(ctx context.Context) labels {
	value := resolver.data.GetClusterLabels()
	return labelsResolver(value)
}

func (resolver *completeClusterConfigResolver) ConfigFingerprint(ctx context.Context) string {
	value := resolver.data.GetConfigFingerprint()
	return value
}

func (resolver *completeClusterConfigResolver) DynamicConfig(ctx context.Context) (*dynamicClusterConfigResolver, error) {
	value := resolver.data.GetDynamicConfig()
	return resolver.root.wrapDynamicClusterConfig(value, true, nil)
}

func (resolver *completeClusterConfigResolver) StaticConfig(ctx context.Context) (*staticClusterConfigResolver, error) {
	value := resolver.data.GetStaticConfig()
	return resolver.root.wrapStaticClusterConfig(value, true, nil)
}

type complianceAggregation_AggregationKeyResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ComplianceAggregation_AggregationKey
}

func (resolver *Resolver) wrapComplianceAggregation_AggregationKey(value *storage.ComplianceAggregation_AggregationKey, ok bool, err error) (*complianceAggregation_AggregationKeyResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &complianceAggregation_AggregationKeyResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapComplianceAggregation_AggregationKeies(values []*storage.ComplianceAggregation_AggregationKey, err error) ([]*complianceAggregation_AggregationKeyResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*complianceAggregation_AggregationKeyResolver, len(values))
	for i, v := range values {
		output[i] = &complianceAggregation_AggregationKeyResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *complianceAggregation_AggregationKeyResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *complianceAggregation_AggregationKeyResolver) Scope(ctx context.Context) string {
	value := resolver.data.GetScope()
	return value.String()
}

type complianceAggregation_ResponseResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ComplianceAggregation_Response
}

func (resolver *Resolver) wrapComplianceAggregation_Response(value *storage.ComplianceAggregation_Response, ok bool, err error) (*complianceAggregation_ResponseResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &complianceAggregation_ResponseResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapComplianceAggregation_Responses(values []*storage.ComplianceAggregation_Response, err error) ([]*complianceAggregation_ResponseResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*complianceAggregation_ResponseResolver, len(values))
	for i, v := range values {
		output[i] = &complianceAggregation_ResponseResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *complianceAggregation_ResponseResolver) ErrorMessage(ctx context.Context) string {
	value := resolver.data.GetErrorMessage()
	return value
}

func (resolver *complianceAggregation_ResponseResolver) Results(ctx context.Context) ([]*complianceAggregation_ResultResolver, error) {
	value := resolver.data.GetResults()
	return resolver.root.wrapComplianceAggregation_Results(value, nil)
}

func (resolver *complianceAggregation_ResponseResolver) Sources(ctx context.Context) ([]*complianceAggregation_SourceResolver, error) {
	value := resolver.data.GetSources()
	return resolver.root.wrapComplianceAggregation_Sources(value, nil)
}

type complianceAggregation_ResultResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ComplianceAggregation_Result
}

func (resolver *Resolver) wrapComplianceAggregation_Result(value *storage.ComplianceAggregation_Result, ok bool, err error) (*complianceAggregation_ResultResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &complianceAggregation_ResultResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapComplianceAggregation_Results(values []*storage.ComplianceAggregation_Result, err error) ([]*complianceAggregation_ResultResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*complianceAggregation_ResultResolver, len(values))
	for i, v := range values {
		output[i] = &complianceAggregation_ResultResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *complianceAggregation_ResultResolver) AggregationKeys(ctx context.Context) ([]*complianceAggregation_AggregationKeyResolver, error) {
	value := resolver.data.GetAggregationKeys()
	return resolver.root.wrapComplianceAggregation_AggregationKeies(value, nil)
}

func (resolver *complianceAggregation_ResultResolver) NumFailing(ctx context.Context) int32 {
	value := resolver.data.GetNumFailing()
	return value
}

func (resolver *complianceAggregation_ResultResolver) NumPassing(ctx context.Context) int32 {
	value := resolver.data.GetNumPassing()
	return value
}

func (resolver *complianceAggregation_ResultResolver) NumSkipped(ctx context.Context) int32 {
	value := resolver.data.GetNumSkipped()
	return value
}

func (resolver *complianceAggregation_ResultResolver) Unit(ctx context.Context) string {
	value := resolver.data.GetUnit()
	return value.String()
}

func toComplianceAggregation_Scope(value *string) storage.ComplianceAggregation_Scope {
	if value != nil {
		return storage.ComplianceAggregation_Scope(storage.ComplianceAggregation_Scope_value[*value])
	}
	return storage.ComplianceAggregation_Scope(0)
}

func toComplianceAggregation_Scopes(values *[]string) []storage.ComplianceAggregation_Scope {
	if values == nil {
		return nil
	}
	output := make([]storage.ComplianceAggregation_Scope, len(*values))
	for i, v := range *values {
		output[i] = toComplianceAggregation_Scope(&v)
	}
	return output
}

type complianceAggregation_SourceResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ComplianceAggregation_Source
}

func (resolver *Resolver) wrapComplianceAggregation_Source(value *storage.ComplianceAggregation_Source, ok bool, err error) (*complianceAggregation_SourceResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &complianceAggregation_SourceResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapComplianceAggregation_Sources(values []*storage.ComplianceAggregation_Source, err error) ([]*complianceAggregation_SourceResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*complianceAggregation_SourceResolver, len(values))
	for i, v := range values {
		output[i] = &complianceAggregation_SourceResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *complianceAggregation_SourceResolver) ClusterId(ctx context.Context) string {
	value := resolver.data.GetClusterId()
	return value
}

func (resolver *complianceAggregation_SourceResolver) FailedRuns(ctx context.Context) ([]*complianceRunMetadataResolver, error) {
	value := resolver.data.GetFailedRuns()
	return resolver.root.wrapComplianceRunMetadatas(value, nil)
}

func (resolver *complianceAggregation_SourceResolver) StandardId(ctx context.Context) string {
	value := resolver.data.GetStandardId()
	return value
}

func (resolver *complianceAggregation_SourceResolver) SuccessfulRun(ctx context.Context) (*complianceRunMetadataResolver, error) {
	value := resolver.data.GetSuccessfulRun()
	return resolver.root.wrapComplianceRunMetadata(value, true, nil)
}

type complianceControlResolver struct {
	ctx  context.Context
	root *Resolver
	data *v1.ComplianceControl
}

func (resolver *Resolver) wrapComplianceControl(value *v1.ComplianceControl, ok bool, err error) (*complianceControlResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &complianceControlResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapComplianceControls(values []*v1.ComplianceControl, err error) ([]*complianceControlResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*complianceControlResolver, len(values))
	for i, v := range values {
		output[i] = &complianceControlResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *complianceControlResolver) Description(ctx context.Context) string {
	value := resolver.data.GetDescription()
	return value
}

func (resolver *complianceControlResolver) GroupId(ctx context.Context) string {
	value := resolver.data.GetGroupId()
	return value
}

func (resolver *complianceControlResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *complianceControlResolver) Implemented(ctx context.Context) bool {
	value := resolver.data.GetImplemented()
	return value
}

func (resolver *complianceControlResolver) InterpretationText(ctx context.Context) string {
	value := resolver.data.GetInterpretationText()
	return value
}

func (resolver *complianceControlResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func (resolver *complianceControlResolver) StandardId(ctx context.Context) string {
	value := resolver.data.GetStandardId()
	return value
}

type complianceControlGroupResolver struct {
	ctx  context.Context
	root *Resolver
	data *v1.ComplianceControlGroup
}

func (resolver *Resolver) wrapComplianceControlGroup(value *v1.ComplianceControlGroup, ok bool, err error) (*complianceControlGroupResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &complianceControlGroupResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapComplianceControlGroups(values []*v1.ComplianceControlGroup, err error) ([]*complianceControlGroupResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*complianceControlGroupResolver, len(values))
	for i, v := range values {
		output[i] = &complianceControlGroupResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *complianceControlGroupResolver) Description(ctx context.Context) string {
	value := resolver.data.GetDescription()
	return value
}

func (resolver *complianceControlGroupResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *complianceControlGroupResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func (resolver *complianceControlGroupResolver) NumImplementedChecks(ctx context.Context) int32 {
	value := resolver.data.GetNumImplementedChecks()
	return value
}

func (resolver *complianceControlGroupResolver) StandardId(ctx context.Context) string {
	value := resolver.data.GetStandardId()
	return value
}

type complianceControlResultResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ComplianceControlResult
}

func (resolver *Resolver) wrapComplianceControlResult(value *storage.ComplianceControlResult, ok bool, err error) (*complianceControlResultResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &complianceControlResultResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapComplianceControlResults(values []*storage.ComplianceControlResult, err error) ([]*complianceControlResultResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*complianceControlResultResolver, len(values))
	for i, v := range values {
		output[i] = &complianceControlResultResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *complianceControlResultResolver) ControlId(ctx context.Context) string {
	value := resolver.data.GetControlId()
	return value
}

func (resolver *complianceControlResultResolver) Resource(ctx context.Context) (*complianceResourceResolver, error) {
	value := resolver.data.GetResource()
	return resolver.root.wrapComplianceResource(value, true, nil)
}

func (resolver *complianceControlResultResolver) Value(ctx context.Context) (*complianceResultValueResolver, error) {
	value := resolver.data.GetValue()
	return resolver.root.wrapComplianceResultValue(value, true, nil)
}

type complianceResourceResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ComplianceResource
}

func (resolver *Resolver) wrapComplianceResource(value *storage.ComplianceResource, ok bool, err error) (*complianceResourceResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &complianceResourceResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapComplianceResources(values []*storage.ComplianceResource, err error) ([]*complianceResourceResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*complianceResourceResolver, len(values))
	for i, v := range values {
		output[i] = &complianceResourceResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *complianceResourceResolver) Cluster(ctx context.Context) (*complianceResource_ClusterNameResolver, error) {
	value := resolver.data.GetCluster()
	return resolver.root.wrapComplianceResource_ClusterName(value, true, nil)
}

func (resolver *complianceResourceResolver) Deployment(ctx context.Context) (*complianceResource_DeploymentNameResolver, error) {
	value := resolver.data.GetDeployment()
	return resolver.root.wrapComplianceResource_DeploymentName(value, true, nil)
}

func (resolver *complianceResourceResolver) Image(ctx context.Context) (*imageNameResolver, error) {
	value := resolver.data.GetImage()
	return resolver.root.wrapImageName(value, true, nil)
}

func (resolver *complianceResourceResolver) Node(ctx context.Context) (*complianceResource_NodeNameResolver, error) {
	value := resolver.data.GetNode()
	return resolver.root.wrapComplianceResource_NodeName(value, true, nil)
}

type complianceResourceResourceResolver struct {
	resolver interface{}
}

func (resolver *complianceResourceResolver) Resource() *complianceResourceResourceResolver {
	if val := resolver.data.GetCluster(); val != nil {
		return &complianceResourceResourceResolver{
			resolver: &complianceResource_ClusterNameResolver{root: resolver.root, data: val},
		}
	}
	if val := resolver.data.GetDeployment(); val != nil {
		return &complianceResourceResourceResolver{
			resolver: &complianceResource_DeploymentNameResolver{root: resolver.root, data: val},
		}
	}
	if val := resolver.data.GetNode(); val != nil {
		return &complianceResourceResourceResolver{
			resolver: &complianceResource_NodeNameResolver{root: resolver.root, data: val},
		}
	}
	if val := resolver.data.GetImage(); val != nil {
		return &complianceResourceResourceResolver{
			resolver: &imageNameResolver{root: resolver.root, data: val},
		}
	}
	return nil
}

func (resolver *complianceResourceResourceResolver) ToComplianceResource_ClusterName() (*complianceResource_ClusterNameResolver, bool) {
	res, ok := resolver.resolver.(*complianceResource_ClusterNameResolver)
	return res, ok
}

func (resolver *complianceResourceResourceResolver) ToComplianceResource_DeploymentName() (*complianceResource_DeploymentNameResolver, bool) {
	res, ok := resolver.resolver.(*complianceResource_DeploymentNameResolver)
	return res, ok
}

func (resolver *complianceResourceResourceResolver) ToComplianceResource_NodeName() (*complianceResource_NodeNameResolver, bool) {
	res, ok := resolver.resolver.(*complianceResource_NodeNameResolver)
	return res, ok
}

func (resolver *complianceResourceResourceResolver) ToImageName() (*imageNameResolver, bool) {
	res, ok := resolver.resolver.(*imageNameResolver)
	return res, ok
}

type complianceResource_ClusterNameResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ComplianceResource_ClusterName
}

func (resolver *Resolver) wrapComplianceResource_ClusterName(value *storage.ComplianceResource_ClusterName, ok bool, err error) (*complianceResource_ClusterNameResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &complianceResource_ClusterNameResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapComplianceResource_ClusterNames(values []*storage.ComplianceResource_ClusterName, err error) ([]*complianceResource_ClusterNameResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*complianceResource_ClusterNameResolver, len(values))
	for i, v := range values {
		output[i] = &complianceResource_ClusterNameResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *complianceResource_ClusterNameResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *complianceResource_ClusterNameResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

type complianceResource_DeploymentNameResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ComplianceResource_DeploymentName
}

func (resolver *Resolver) wrapComplianceResource_DeploymentName(value *storage.ComplianceResource_DeploymentName, ok bool, err error) (*complianceResource_DeploymentNameResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &complianceResource_DeploymentNameResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapComplianceResource_DeploymentNames(values []*storage.ComplianceResource_DeploymentName, err error) ([]*complianceResource_DeploymentNameResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*complianceResource_DeploymentNameResolver, len(values))
	for i, v := range values {
		output[i] = &complianceResource_DeploymentNameResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *complianceResource_DeploymentNameResolver) Cluster(ctx context.Context) (*complianceResource_ClusterNameResolver, error) {
	value := resolver.data.GetCluster()
	return resolver.root.wrapComplianceResource_ClusterName(value, true, nil)
}

func (resolver *complianceResource_DeploymentNameResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *complianceResource_DeploymentNameResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func (resolver *complianceResource_DeploymentNameResolver) Namespace(ctx context.Context) string {
	value := resolver.data.GetNamespace()
	return value
}

type complianceResource_NodeNameResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ComplianceResource_NodeName
}

func (resolver *Resolver) wrapComplianceResource_NodeName(value *storage.ComplianceResource_NodeName, ok bool, err error) (*complianceResource_NodeNameResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &complianceResource_NodeNameResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapComplianceResource_NodeNames(values []*storage.ComplianceResource_NodeName, err error) ([]*complianceResource_NodeNameResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*complianceResource_NodeNameResolver, len(values))
	for i, v := range values {
		output[i] = &complianceResource_NodeNameResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *complianceResource_NodeNameResolver) Cluster(ctx context.Context) (*complianceResource_ClusterNameResolver, error) {
	value := resolver.data.GetCluster()
	return resolver.root.wrapComplianceResource_ClusterName(value, true, nil)
}

func (resolver *complianceResource_NodeNameResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *complianceResource_NodeNameResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

type complianceResultValueResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ComplianceResultValue
}

func (resolver *Resolver) wrapComplianceResultValue(value *storage.ComplianceResultValue, ok bool, err error) (*complianceResultValueResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &complianceResultValueResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapComplianceResultValues(values []*storage.ComplianceResultValue, err error) ([]*complianceResultValueResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*complianceResultValueResolver, len(values))
	for i, v := range values {
		output[i] = &complianceResultValueResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *complianceResultValueResolver) Evidence(ctx context.Context) ([]*complianceResultValue_EvidenceResolver, error) {
	value := resolver.data.GetEvidence()
	return resolver.root.wrapComplianceResultValue_Evidences(value, nil)
}

func (resolver *complianceResultValueResolver) OverallState(ctx context.Context) string {
	value := resolver.data.GetOverallState()
	return value.String()
}

type complianceResultValue_EvidenceResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ComplianceResultValue_Evidence
}

func (resolver *Resolver) wrapComplianceResultValue_Evidence(value *storage.ComplianceResultValue_Evidence, ok bool, err error) (*complianceResultValue_EvidenceResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &complianceResultValue_EvidenceResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapComplianceResultValue_Evidences(values []*storage.ComplianceResultValue_Evidence, err error) ([]*complianceResultValue_EvidenceResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*complianceResultValue_EvidenceResolver, len(values))
	for i, v := range values {
		output[i] = &complianceResultValue_EvidenceResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *complianceResultValue_EvidenceResolver) Message(ctx context.Context) string {
	value := resolver.data.GetMessage()
	return value
}

func (resolver *complianceResultValue_EvidenceResolver) MessageId(ctx context.Context) int32 {
	value := resolver.data.GetMessageId()
	return value
}

func (resolver *complianceResultValue_EvidenceResolver) State(ctx context.Context) string {
	value := resolver.data.GetState()
	return value.String()
}

type complianceRunResolver struct {
	ctx  context.Context
	root *Resolver
	data *v1.ComplianceRun
}

func (resolver *Resolver) wrapComplianceRun(value *v1.ComplianceRun, ok bool, err error) (*complianceRunResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &complianceRunResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapComplianceRuns(values []*v1.ComplianceRun, err error) ([]*complianceRunResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*complianceRunResolver, len(values))
	for i, v := range values {
		output[i] = &complianceRunResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *complianceRunResolver) ClusterId(ctx context.Context) string {
	value := resolver.data.GetClusterId()
	return value
}

func (resolver *complianceRunResolver) ErrorMessage(ctx context.Context) string {
	value := resolver.data.GetErrorMessage()
	return value
}

func (resolver *complianceRunResolver) FinishTime(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetFinishTime()
	return timestamp(value)
}

func (resolver *complianceRunResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *complianceRunResolver) ScheduleId(ctx context.Context) string {
	value := resolver.data.GetScheduleId()
	return value
}

func (resolver *complianceRunResolver) StandardId(ctx context.Context) string {
	value := resolver.data.GetStandardId()
	return value
}

func (resolver *complianceRunResolver) StartTime(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetStartTime()
	return timestamp(value)
}

func (resolver *complianceRunResolver) State(ctx context.Context) string {
	value := resolver.data.GetState()
	return value.String()
}

type complianceRunMetadataResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ComplianceRunMetadata
}

func (resolver *Resolver) wrapComplianceRunMetadata(value *storage.ComplianceRunMetadata, ok bool, err error) (*complianceRunMetadataResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &complianceRunMetadataResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapComplianceRunMetadatas(values []*storage.ComplianceRunMetadata, err error) ([]*complianceRunMetadataResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*complianceRunMetadataResolver, len(values))
	for i, v := range values {
		output[i] = &complianceRunMetadataResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *complianceRunMetadataResolver) ClusterId(ctx context.Context) string {
	value := resolver.data.GetClusterId()
	return value
}

func (resolver *complianceRunMetadataResolver) DomainId(ctx context.Context) string {
	value := resolver.data.GetDomainId()
	return value
}

func (resolver *complianceRunMetadataResolver) ErrorMessage(ctx context.Context) string {
	value := resolver.data.GetErrorMessage()
	return value
}

func (resolver *complianceRunMetadataResolver) FinishTimestamp(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetFinishTimestamp()
	return timestamp(value)
}

func (resolver *complianceRunMetadataResolver) RunId(ctx context.Context) string {
	value := resolver.data.GetRunId()
	return value
}

func (resolver *complianceRunMetadataResolver) StandardId(ctx context.Context) string {
	value := resolver.data.GetStandardId()
	return value
}

func (resolver *complianceRunMetadataResolver) StartTimestamp(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetStartTimestamp()
	return timestamp(value)
}

func (resolver *complianceRunMetadataResolver) Success(ctx context.Context) bool {
	value := resolver.data.GetSuccess()
	return value
}

type complianceRunScheduleResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ComplianceRunSchedule
}

func (resolver *Resolver) wrapComplianceRunSchedule(value *storage.ComplianceRunSchedule, ok bool, err error) (*complianceRunScheduleResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &complianceRunScheduleResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapComplianceRunSchedules(values []*storage.ComplianceRunSchedule, err error) ([]*complianceRunScheduleResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*complianceRunScheduleResolver, len(values))
	for i, v := range values {
		output[i] = &complianceRunScheduleResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *complianceRunScheduleResolver) ClusterId(ctx context.Context) string {
	value := resolver.data.GetClusterId()
	return value
}

func (resolver *complianceRunScheduleResolver) CrontabSpec(ctx context.Context) string {
	value := resolver.data.GetCrontabSpec()
	return value
}

func (resolver *complianceRunScheduleResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *complianceRunScheduleResolver) StandardId(ctx context.Context) string {
	value := resolver.data.GetStandardId()
	return value
}

func (resolver *complianceRunScheduleResolver) Suspended(ctx context.Context) bool {
	value := resolver.data.GetSuspended()
	return value
}

type complianceRunScheduleInfoResolver struct {
	ctx  context.Context
	root *Resolver
	data *v1.ComplianceRunScheduleInfo
}

func (resolver *Resolver) wrapComplianceRunScheduleInfo(value *v1.ComplianceRunScheduleInfo, ok bool, err error) (*complianceRunScheduleInfoResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &complianceRunScheduleInfoResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapComplianceRunScheduleInfos(values []*v1.ComplianceRunScheduleInfo, err error) ([]*complianceRunScheduleInfoResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*complianceRunScheduleInfoResolver, len(values))
	for i, v := range values {
		output[i] = &complianceRunScheduleInfoResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *complianceRunScheduleInfoResolver) LastCompletedRun(ctx context.Context) (*complianceRunResolver, error) {
	value := resolver.data.GetLastCompletedRun()
	return resolver.root.wrapComplianceRun(value, true, nil)
}

func (resolver *complianceRunScheduleInfoResolver) LastRun(ctx context.Context) (*complianceRunResolver, error) {
	value := resolver.data.GetLastRun()
	return resolver.root.wrapComplianceRun(value, true, nil)
}

func (resolver *complianceRunScheduleInfoResolver) NextRunTime(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetNextRunTime()
	return timestamp(value)
}

func (resolver *complianceRunScheduleInfoResolver) Schedule(ctx context.Context) (*complianceRunScheduleResolver, error) {
	value := resolver.data.GetSchedule()
	return resolver.root.wrapComplianceRunSchedule(value, true, nil)
}

func toComplianceRun_State(value *string) v1.ComplianceRun_State {
	if value != nil {
		return v1.ComplianceRun_State(v1.ComplianceRun_State_value[*value])
	}
	return v1.ComplianceRun_State(0)
}

func toComplianceRun_States(values *[]string) []v1.ComplianceRun_State {
	if values == nil {
		return nil
	}
	output := make([]v1.ComplianceRun_State, len(*values))
	for i, v := range *values {
		output[i] = toComplianceRun_State(&v)
	}
	return output
}

type complianceStandardResolver struct {
	ctx  context.Context
	root *Resolver
	data *v1.ComplianceStandard
}

func (resolver *Resolver) wrapComplianceStandard(value *v1.ComplianceStandard, ok bool, err error) (*complianceStandardResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &complianceStandardResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapComplianceStandards(values []*v1.ComplianceStandard, err error) ([]*complianceStandardResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*complianceStandardResolver, len(values))
	for i, v := range values {
		output[i] = &complianceStandardResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *complianceStandardResolver) Controls(ctx context.Context) ([]*complianceControlResolver, error) {
	value := resolver.data.GetControls()
	return resolver.root.wrapComplianceControls(value, nil)
}

func (resolver *complianceStandardResolver) Groups(ctx context.Context) ([]*complianceControlGroupResolver, error) {
	value := resolver.data.GetGroups()
	return resolver.root.wrapComplianceControlGroups(value, nil)
}

func (resolver *complianceStandardResolver) Metadata(ctx context.Context) (*complianceStandardMetadataResolver, error) {
	value := resolver.data.GetMetadata()
	return resolver.root.wrapComplianceStandardMetadata(value, true, nil)
}

type complianceStandardMetadataResolver struct {
	ctx  context.Context
	root *Resolver
	data *v1.ComplianceStandardMetadata
}

func (resolver *Resolver) wrapComplianceStandardMetadata(value *v1.ComplianceStandardMetadata, ok bool, err error) (*complianceStandardMetadataResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &complianceStandardMetadataResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapComplianceStandardMetadatas(values []*v1.ComplianceStandardMetadata, err error) ([]*complianceStandardMetadataResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*complianceStandardMetadataResolver, len(values))
	for i, v := range values {
		output[i] = &complianceStandardMetadataResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *complianceStandardMetadataResolver) Description(ctx context.Context) string {
	value := resolver.data.GetDescription()
	return value
}

func (resolver *complianceStandardMetadataResolver) Dynamic(ctx context.Context) bool {
	value := resolver.data.GetDynamic()
	return value
}

func (resolver *complianceStandardMetadataResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *complianceStandardMetadataResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func (resolver *complianceStandardMetadataResolver) NumImplementedChecks(ctx context.Context) int32 {
	value := resolver.data.GetNumImplementedChecks()
	return value
}

func (resolver *complianceStandardMetadataResolver) Scopes(ctx context.Context) []string {
	value := resolver.data.GetScopes()
	return stringSlice(value)
}

func toComplianceStandardMetadata_Scope(value *string) v1.ComplianceStandardMetadata_Scope {
	if value != nil {
		return v1.ComplianceStandardMetadata_Scope(v1.ComplianceStandardMetadata_Scope_value[*value])
	}
	return v1.ComplianceStandardMetadata_Scope(0)
}

func toComplianceStandardMetadata_Scopes(values *[]string) []v1.ComplianceStandardMetadata_Scope {
	if values == nil {
		return nil
	}
	output := make([]v1.ComplianceStandardMetadata_Scope, len(*values))
	for i, v := range *values {
		output[i] = toComplianceStandardMetadata_Scope(&v)
	}
	return output
}

func toComplianceState(value *string) storage.ComplianceState {
	if value != nil {
		return storage.ComplianceState(storage.ComplianceState_value[*value])
	}
	return storage.ComplianceState(0)
}

func toComplianceStates(values *[]string) []storage.ComplianceState {
	if values == nil {
		return nil
	}
	output := make([]storage.ComplianceState, len(*values))
	for i, v := range *values {
		output[i] = toComplianceState(&v)
	}
	return output
}

type componentResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Component
}

func (resolver *Resolver) wrapComponent(value *storage.Component, ok bool, err error) (*componentResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &componentResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapComponents(values []*storage.Component, err error) ([]*componentResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*componentResolver, len(values))
	for i, v := range values {
		output[i] = &componentResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *componentResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func (resolver *componentResolver) Version(ctx context.Context) string {
	value := resolver.data.GetVersion()
	return value
}

type containerResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Container
}

func (resolver *Resolver) wrapContainer(value *storage.Container, ok bool, err error) (*containerResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &containerResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapContainers(values []*storage.Container, err error) ([]*containerResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*containerResolver, len(values))
	for i, v := range values {
		output[i] = &containerResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *containerResolver) Config(ctx context.Context) (*containerConfigResolver, error) {
	value := resolver.data.GetConfig()
	return resolver.root.wrapContainerConfig(value, true, nil)
}

func (resolver *containerResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *containerResolver) Image(ctx context.Context) (*containerImageResolver, error) {
	value := resolver.data.GetImage()
	return resolver.root.wrapContainerImage(value, true, nil)
}

func (resolver *containerResolver) LivenessProbe(ctx context.Context) (*livenessProbeResolver, error) {
	value := resolver.data.GetLivenessProbe()
	return resolver.root.wrapLivenessProbe(value, true, nil)
}

func (resolver *containerResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func (resolver *containerResolver) Ports(ctx context.Context) ([]*portConfigResolver, error) {
	value := resolver.data.GetPorts()
	return resolver.root.wrapPortConfigs(value, nil)
}

func (resolver *containerResolver) ReadinessProbe(ctx context.Context) (*readinessProbeResolver, error) {
	value := resolver.data.GetReadinessProbe()
	return resolver.root.wrapReadinessProbe(value, true, nil)
}

func (resolver *containerResolver) Resources(ctx context.Context) (*resourcesResolver, error) {
	value := resolver.data.GetResources()
	return resolver.root.wrapResources(value, true, nil)
}

func (resolver *containerResolver) Secrets(ctx context.Context) ([]*embeddedSecretResolver, error) {
	value := resolver.data.GetSecrets()
	return resolver.root.wrapEmbeddedSecrets(value, nil)
}

func (resolver *containerResolver) SecurityContext(ctx context.Context) (*securityContextResolver, error) {
	value := resolver.data.GetSecurityContext()
	return resolver.root.wrapSecurityContext(value, true, nil)
}

func (resolver *containerResolver) Volumes(ctx context.Context) ([]*volumeResolver, error) {
	value := resolver.data.GetVolumes()
	return resolver.root.wrapVolumes(value, nil)
}

type containerConfigResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ContainerConfig
}

func (resolver *Resolver) wrapContainerConfig(value *storage.ContainerConfig, ok bool, err error) (*containerConfigResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &containerConfigResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapContainerConfigs(values []*storage.ContainerConfig, err error) ([]*containerConfigResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*containerConfigResolver, len(values))
	for i, v := range values {
		output[i] = &containerConfigResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *containerConfigResolver) AppArmorProfile(ctx context.Context) string {
	value := resolver.data.GetAppArmorProfile()
	return value
}

func (resolver *containerConfigResolver) Args(ctx context.Context) []string {
	value := resolver.data.GetArgs()
	return value
}

func (resolver *containerConfigResolver) Command(ctx context.Context) []string {
	value := resolver.data.GetCommand()
	return value
}

func (resolver *containerConfigResolver) Directory(ctx context.Context) string {
	value := resolver.data.GetDirectory()
	return value
}

func (resolver *containerConfigResolver) Env(ctx context.Context) ([]*containerConfig_EnvironmentConfigResolver, error) {
	value := resolver.data.GetEnv()
	return resolver.root.wrapContainerConfig_EnvironmentConfigs(value, nil)
}

func (resolver *containerConfigResolver) Uid(ctx context.Context) int32 {
	value := resolver.data.GetUid()
	return int32(value)
}

func (resolver *containerConfigResolver) User(ctx context.Context) string {
	value := resolver.data.GetUser()
	return value
}

type containerConfig_EnvironmentConfigResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ContainerConfig_EnvironmentConfig
}

func (resolver *Resolver) wrapContainerConfig_EnvironmentConfig(value *storage.ContainerConfig_EnvironmentConfig, ok bool, err error) (*containerConfig_EnvironmentConfigResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &containerConfig_EnvironmentConfigResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapContainerConfig_EnvironmentConfigs(values []*storage.ContainerConfig_EnvironmentConfig, err error) ([]*containerConfig_EnvironmentConfigResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*containerConfig_EnvironmentConfigResolver, len(values))
	for i, v := range values {
		output[i] = &containerConfig_EnvironmentConfigResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *containerConfig_EnvironmentConfigResolver) EnvVarSource(ctx context.Context) string {
	value := resolver.data.GetEnvVarSource()
	return value.String()
}

func (resolver *containerConfig_EnvironmentConfigResolver) Key(ctx context.Context) string {
	value := resolver.data.GetKey()
	return value
}

func (resolver *containerConfig_EnvironmentConfigResolver) Value(ctx context.Context) string {
	value := resolver.data.GetValue()
	return value
}

func toContainerConfig_EnvironmentConfig_EnvVarSource(value *string) storage.ContainerConfig_EnvironmentConfig_EnvVarSource {
	if value != nil {
		return storage.ContainerConfig_EnvironmentConfig_EnvVarSource(storage.ContainerConfig_EnvironmentConfig_EnvVarSource_value[*value])
	}
	return storage.ContainerConfig_EnvironmentConfig_EnvVarSource(0)
}

func toContainerConfig_EnvironmentConfig_EnvVarSources(values *[]string) []storage.ContainerConfig_EnvironmentConfig_EnvVarSource {
	if values == nil {
		return nil
	}
	output := make([]storage.ContainerConfig_EnvironmentConfig_EnvVarSource, len(*values))
	for i, v := range *values {
		output[i] = toContainerConfig_EnvironmentConfig_EnvVarSource(&v)
	}
	return output
}

type containerImageResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ContainerImage
}

func (resolver *Resolver) wrapContainerImage(value *storage.ContainerImage, ok bool, err error) (*containerImageResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &containerImageResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapContainerImages(values []*storage.ContainerImage, err error) ([]*containerImageResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*containerImageResolver, len(values))
	for i, v := range values {
		output[i] = &containerImageResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *containerImageResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *containerImageResolver) IsClusterLocal(ctx context.Context) bool {
	value := resolver.data.GetIsClusterLocal()
	return value
}

func (resolver *containerImageResolver) Name(ctx context.Context) (*imageNameResolver, error) {
	value := resolver.data.GetName()
	return resolver.root.wrapImageName(value, true, nil)
}

func (resolver *containerImageResolver) NotPullable(ctx context.Context) bool {
	value := resolver.data.GetNotPullable()
	return value
}

type containerInstanceResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ContainerInstance
}

func (resolver *Resolver) wrapContainerInstance(value *storage.ContainerInstance, ok bool, err error) (*containerInstanceResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &containerInstanceResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapContainerInstances(values []*storage.ContainerInstance, err error) ([]*containerInstanceResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*containerInstanceResolver, len(values))
	for i, v := range values {
		output[i] = &containerInstanceResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *containerInstanceResolver) ContainerIps(ctx context.Context) []string {
	value := resolver.data.GetContainerIps()
	return value
}

func (resolver *containerInstanceResolver) ContainerName(ctx context.Context) string {
	value := resolver.data.GetContainerName()
	return value
}

func (resolver *containerInstanceResolver) ContainingPodId(ctx context.Context) string {
	value := resolver.data.GetContainingPodId()
	return value
}

func (resolver *containerInstanceResolver) ExitCode(ctx context.Context) int32 {
	value := resolver.data.GetExitCode()
	return value
}

func (resolver *containerInstanceResolver) Finished(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetFinished()
	return timestamp(value)
}

func (resolver *containerInstanceResolver) ImageDigest(ctx context.Context) string {
	value := resolver.data.GetImageDigest()
	return value
}

func (resolver *containerInstanceResolver) InstanceId(ctx context.Context) (*containerInstanceIDResolver, error) {
	value := resolver.data.GetInstanceId()
	return resolver.root.wrapContainerInstanceID(value, true, nil)
}

func (resolver *containerInstanceResolver) Started(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetStarted()
	return timestamp(value)
}

func (resolver *containerInstanceResolver) TerminationReason(ctx context.Context) string {
	value := resolver.data.GetTerminationReason()
	return value
}

type containerInstanceIDResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ContainerInstanceID
}

func (resolver *Resolver) wrapContainerInstanceID(value *storage.ContainerInstanceID, ok bool, err error) (*containerInstanceIDResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &containerInstanceIDResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapContainerInstanceIDs(values []*storage.ContainerInstanceID, err error) ([]*containerInstanceIDResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*containerInstanceIDResolver, len(values))
	for i, v := range values {
		output[i] = &containerInstanceIDResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *containerInstanceIDResolver) ContainerRuntime(ctx context.Context) string {
	value := resolver.data.GetContainerRuntime()
	return value.String()
}

func (resolver *containerInstanceIDResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *containerInstanceIDResolver) Node(ctx context.Context) string {
	value := resolver.data.GetNode()
	return value
}

func toContainerRuntime(value *string) storage.ContainerRuntime {
	if value != nil {
		return storage.ContainerRuntime(storage.ContainerRuntime_value[*value])
	}
	return storage.ContainerRuntime(0)
}

func toContainerRuntimes(values *[]string) []storage.ContainerRuntime {
	if values == nil {
		return nil
	}
	output := make([]storage.ContainerRuntime, len(*values))
	for i, v := range *values {
		output[i] = toContainerRuntime(&v)
	}
	return output
}

type containerRuntimeInfoResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ContainerRuntimeInfo
}

func (resolver *Resolver) wrapContainerRuntimeInfo(value *storage.ContainerRuntimeInfo, ok bool, err error) (*containerRuntimeInfoResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &containerRuntimeInfoResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapContainerRuntimeInfos(values []*storage.ContainerRuntimeInfo, err error) ([]*containerRuntimeInfoResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*containerRuntimeInfoResolver, len(values))
	for i, v := range values {
		output[i] = &containerRuntimeInfoResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *containerRuntimeInfoResolver) Type(ctx context.Context) string {
	value := resolver.data.GetType()
	return value.String()
}

func (resolver *containerRuntimeInfoResolver) Version(ctx context.Context) string {
	value := resolver.data.GetVersion()
	return value
}

type cosignSignatureResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.CosignSignature
}

func (resolver *Resolver) wrapCosignSignature(value *storage.CosignSignature, ok bool, err error) (*cosignSignatureResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &cosignSignatureResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapCosignSignatures(values []*storage.CosignSignature, err error) ([]*cosignSignatureResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*cosignSignatureResolver, len(values))
	for i, v := range values {
		output[i] = &cosignSignatureResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *cosignSignatureResolver) RawSignature(ctx context.Context) []byte {
	value := resolver.data.GetRawSignature()
	return value
}

func (resolver *cosignSignatureResolver) SignaturePayload(ctx context.Context) []byte {
	value := resolver.data.GetSignaturePayload()
	return value
}

type dataSourceResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.DataSource
}

func (resolver *Resolver) wrapDataSource(value *storage.DataSource, ok bool, err error) (*dataSourceResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &dataSourceResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapDataSources(values []*storage.DataSource, err error) ([]*dataSourceResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*dataSourceResolver, len(values))
	for i, v := range values {
		output[i] = &dataSourceResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *dataSourceResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *dataSourceResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

type deploymentResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Deployment
	list *storage.ListDeployment
}

func (resolver *Resolver) wrapDeployment(value *storage.Deployment, ok bool, err error) (*deploymentResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &deploymentResolver{root: resolver, data: value, list: nil}, nil
}

func (resolver *Resolver) wrapDeployments(values []*storage.Deployment, err error) ([]*deploymentResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*deploymentResolver, len(values))
	for i, v := range values {
		output[i] = &deploymentResolver{root: resolver, data: v, list: nil}
	}
	return output, nil
}

func (resolver *Resolver) wrapListDeployments(values []*storage.ListDeployment, err error) ([]*deploymentResolver, error) {
	if err != nil || values == nil {
		return nil, err
	}
	output := make([]*deploymentResolver, len(values))
	for i, v := range values {
		output[i] = &deploymentResolver{root: resolver, data: nil, list: v}
	}
	return output, nil
}

func (resolver *deploymentResolver) ensureData(ctx context.Context) {
	if resolver.data == nil {
		resolver.data = resolver.root.getDeployment(ctx, resolver.list.GetId())
	}
}

func (resolver *deploymentResolver) Annotations(ctx context.Context) labels {
	resolver.ensureData(ctx)
	value := resolver.data.GetAnnotations()
	return labelsResolver(value)
}

func (resolver *deploymentResolver) AutomountServiceAccountToken(ctx context.Context) bool {
	resolver.ensureData(ctx)
	value := resolver.data.GetAutomountServiceAccountToken()
	return value
}

func (resolver *deploymentResolver) ClusterId(ctx context.Context) string {
	value := resolver.data.GetClusterId()
	if resolver.data == nil {
		value = resolver.list.GetClusterId()
	}
	return value
}

func (resolver *deploymentResolver) ClusterName(ctx context.Context) string {
	resolver.ensureData(ctx)
	value := resolver.data.GetClusterName()
	return value
}

func (resolver *deploymentResolver) Containers(ctx context.Context) ([]*containerResolver, error) {
	resolver.ensureData(ctx)
	value := resolver.data.GetContainers()
	return resolver.root.wrapContainers(value, nil)
}

func (resolver *deploymentResolver) Created(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetCreated()
	if resolver.data == nil {
		value = resolver.list.GetCreated()
	}
	return timestamp(value)
}

func (resolver *deploymentResolver) HostIpc(ctx context.Context) bool {
	resolver.ensureData(ctx)
	value := resolver.data.GetHostIpc()
	return value
}

func (resolver *deploymentResolver) HostNetwork(ctx context.Context) bool {
	resolver.ensureData(ctx)
	value := resolver.data.GetHostNetwork()
	return value
}

func (resolver *deploymentResolver) HostPid(ctx context.Context) bool {
	resolver.ensureData(ctx)
	value := resolver.data.GetHostPid()
	return value
}

func (resolver *deploymentResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	if resolver.data == nil {
		value = resolver.list.GetId()
	}
	return graphql.ID(value)
}

func (resolver *deploymentResolver) ImagePullSecrets(ctx context.Context) []string {
	resolver.ensureData(ctx)
	value := resolver.data.GetImagePullSecrets()
	return value
}

func (resolver *deploymentResolver) Inactive(ctx context.Context) bool {
	resolver.ensureData(ctx)
	value := resolver.data.GetInactive()
	return value
}

func (resolver *deploymentResolver) LabelSelector(ctx context.Context) (*labelSelectorResolver, error) {
	resolver.ensureData(ctx)
	value := resolver.data.GetLabelSelector()
	return resolver.root.wrapLabelSelector(value, true, nil)
}

func (resolver *deploymentResolver) Labels(ctx context.Context) labels {
	resolver.ensureData(ctx)
	value := resolver.data.GetLabels()
	return labelsResolver(value)
}

func (resolver *deploymentResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	if resolver.data == nil {
		value = resolver.list.GetName()
	}
	return value
}

func (resolver *deploymentResolver) Namespace(ctx context.Context) string {
	value := resolver.data.GetNamespace()
	if resolver.data == nil {
		value = resolver.list.GetNamespace()
	}
	return value
}

func (resolver *deploymentResolver) NamespaceId(ctx context.Context) string {
	resolver.ensureData(ctx)
	value := resolver.data.GetNamespaceId()
	return value
}

func (resolver *deploymentResolver) OrchestratorComponent(ctx context.Context) bool {
	resolver.ensureData(ctx)
	value := resolver.data.GetOrchestratorComponent()
	return value
}

func (resolver *deploymentResolver) PodLabels(ctx context.Context) labels {
	resolver.ensureData(ctx)
	value := resolver.data.GetPodLabels()
	return labelsResolver(value)
}

func (resolver *deploymentResolver) Ports(ctx context.Context) ([]*portConfigResolver, error) {
	resolver.ensureData(ctx)
	value := resolver.data.GetPorts()
	return resolver.root.wrapPortConfigs(value, nil)
}

func (resolver *deploymentResolver) Priority(ctx context.Context) int32 {
	value := resolver.data.GetPriority()
	if resolver.data == nil {
		value = resolver.list.GetPriority()
	}
	return int32(value)
}

func (resolver *deploymentResolver) ProcessTags(ctx context.Context) []string {
	resolver.ensureData(ctx)
	value := resolver.data.GetProcessTags()
	return value
}

func (resolver *deploymentResolver) Replicas(ctx context.Context) int32 {
	resolver.ensureData(ctx)
	value := resolver.data.GetReplicas()
	return int32(value)
}

func (resolver *deploymentResolver) RiskScore(ctx context.Context) float64 {
	resolver.ensureData(ctx)
	value := resolver.data.GetRiskScore()
	return float64(value)
}

func (resolver *deploymentResolver) RuntimeClass(ctx context.Context) string {
	resolver.ensureData(ctx)
	value := resolver.data.GetRuntimeClass()
	return value
}

func (resolver *deploymentResolver) ServiceAccount(ctx context.Context) string {
	resolver.ensureData(ctx)
	value := resolver.data.GetServiceAccount()
	return value
}

func (resolver *deploymentResolver) ServiceAccountPermissionLevel(ctx context.Context) string {
	resolver.ensureData(ctx)
	value := resolver.data.GetServiceAccountPermissionLevel()
	return value.String()
}

func (resolver *deploymentResolver) StateTimestamp(ctx context.Context) int32 {
	resolver.ensureData(ctx)
	value := resolver.data.GetStateTimestamp()
	return int32(value)
}

func (resolver *deploymentResolver) Tolerations(ctx context.Context) ([]*tolerationResolver, error) {
	resolver.ensureData(ctx)
	value := resolver.data.GetTolerations()
	return resolver.root.wrapTolerations(value, nil)
}

func (resolver *deploymentResolver) Type(ctx context.Context) string {
	resolver.ensureData(ctx)
	value := resolver.data.GetType()
	return value
}

type dockerfileLineRuleFieldResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.DockerfileLineRuleField
}

func (resolver *Resolver) wrapDockerfileLineRuleField(value *storage.DockerfileLineRuleField, ok bool, err error) (*dockerfileLineRuleFieldResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &dockerfileLineRuleFieldResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapDockerfileLineRuleFields(values []*storage.DockerfileLineRuleField, err error) ([]*dockerfileLineRuleFieldResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*dockerfileLineRuleFieldResolver, len(values))
	for i, v := range values {
		output[i] = &dockerfileLineRuleFieldResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *dockerfileLineRuleFieldResolver) Instruction(ctx context.Context) string {
	value := resolver.data.GetInstruction()
	return value
}

func (resolver *dockerfileLineRuleFieldResolver) Value(ctx context.Context) string {
	value := resolver.data.GetValue()
	return value
}

type dynamicClusterConfigResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.DynamicClusterConfig
}

func (resolver *Resolver) wrapDynamicClusterConfig(value *storage.DynamicClusterConfig, ok bool, err error) (*dynamicClusterConfigResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &dynamicClusterConfigResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapDynamicClusterConfigs(values []*storage.DynamicClusterConfig, err error) ([]*dynamicClusterConfigResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*dynamicClusterConfigResolver, len(values))
	for i, v := range values {
		output[i] = &dynamicClusterConfigResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *dynamicClusterConfigResolver) AdmissionControllerConfig(ctx context.Context) (*admissionControllerConfigResolver, error) {
	value := resolver.data.GetAdmissionControllerConfig()
	return resolver.root.wrapAdmissionControllerConfig(value, true, nil)
}

func (resolver *dynamicClusterConfigResolver) DisableAuditLogs(ctx context.Context) bool {
	value := resolver.data.GetDisableAuditLogs()
	return value
}

func (resolver *dynamicClusterConfigResolver) RegistryOverride(ctx context.Context) string {
	value := resolver.data.GetRegistryOverride()
	return value
}

type emailResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Email
}

func (resolver *Resolver) wrapEmail(value *storage.Email, ok bool, err error) (*emailResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &emailResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapEmails(values []*storage.Email, err error) ([]*emailResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*emailResolver, len(values))
	for i, v := range values {
		output[i] = &emailResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *emailResolver) DisableTLS(ctx context.Context) bool {
	value := resolver.data.GetDisableTLS()
	return value
}

func (resolver *emailResolver) From(ctx context.Context) string {
	value := resolver.data.GetFrom()
	return value
}

func (resolver *emailResolver) Password(ctx context.Context) string {
	value := resolver.data.GetPassword()
	return value
}

func (resolver *emailResolver) Sender(ctx context.Context) string {
	value := resolver.data.GetSender()
	return value
}

func (resolver *emailResolver) Server(ctx context.Context) string {
	value := resolver.data.GetServer()
	return value
}

func (resolver *emailResolver) StartTLSAuthMethod(ctx context.Context) string {
	value := resolver.data.GetStartTLSAuthMethod()
	return value.String()
}

func (resolver *emailResolver) Username(ctx context.Context) string {
	value := resolver.data.GetUsername()
	return value
}

func toEmail_AuthMethod(value *string) storage.Email_AuthMethod {
	if value != nil {
		return storage.Email_AuthMethod(storage.Email_AuthMethod_value[*value])
	}
	return storage.Email_AuthMethod(0)
}

func toEmail_AuthMethods(values *[]string) []storage.Email_AuthMethod {
	if values == nil {
		return nil
	}
	output := make([]storage.Email_AuthMethod, len(*values))
	for i, v := range *values {
		output[i] = toEmail_AuthMethod(&v)
	}
	return output
}

type embeddedImageScanComponent_ExecutableResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.EmbeddedImageScanComponent_Executable
}

func (resolver *Resolver) wrapEmbeddedImageScanComponent_Executable(value *storage.EmbeddedImageScanComponent_Executable, ok bool, err error) (*embeddedImageScanComponent_ExecutableResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &embeddedImageScanComponent_ExecutableResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapEmbeddedImageScanComponent_Executables(values []*storage.EmbeddedImageScanComponent_Executable, err error) ([]*embeddedImageScanComponent_ExecutableResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*embeddedImageScanComponent_ExecutableResolver, len(values))
	for i, v := range values {
		output[i] = &embeddedImageScanComponent_ExecutableResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *embeddedImageScanComponent_ExecutableResolver) Dependencies(ctx context.Context) []string {
	value := resolver.data.GetDependencies()
	return value
}

func (resolver *embeddedImageScanComponent_ExecutableResolver) Path(ctx context.Context) string {
	value := resolver.data.GetPath()
	return value
}

type embeddedSecretResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.EmbeddedSecret
}

func (resolver *Resolver) wrapEmbeddedSecret(value *storage.EmbeddedSecret, ok bool, err error) (*embeddedSecretResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &embeddedSecretResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapEmbeddedSecrets(values []*storage.EmbeddedSecret, err error) ([]*embeddedSecretResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*embeddedSecretResolver, len(values))
	for i, v := range values {
		output[i] = &embeddedSecretResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *embeddedSecretResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func (resolver *embeddedSecretResolver) Path(ctx context.Context) string {
	value := resolver.data.GetPath()
	return value
}

func toEmbeddedVulnerability_ScoreVersion(value *string) storage.EmbeddedVulnerability_ScoreVersion {
	if value != nil {
		return storage.EmbeddedVulnerability_ScoreVersion(storage.EmbeddedVulnerability_ScoreVersion_value[*value])
	}
	return storage.EmbeddedVulnerability_ScoreVersion(0)
}

func toEmbeddedVulnerability_ScoreVersions(values *[]string) []storage.EmbeddedVulnerability_ScoreVersion {
	if values == nil {
		return nil
	}
	output := make([]storage.EmbeddedVulnerability_ScoreVersion, len(*values))
	for i, v := range *values {
		output[i] = toEmbeddedVulnerability_ScoreVersion(&v)
	}
	return output
}

func toEmbeddedVulnerability_VulnerabilityType(value *string) storage.EmbeddedVulnerability_VulnerabilityType {
	if value != nil {
		return storage.EmbeddedVulnerability_VulnerabilityType(storage.EmbeddedVulnerability_VulnerabilityType_value[*value])
	}
	return storage.EmbeddedVulnerability_VulnerabilityType(0)
}

func toEmbeddedVulnerability_VulnerabilityTypes(values *[]string) []storage.EmbeddedVulnerability_VulnerabilityType {
	if values == nil {
		return nil
	}
	output := make([]storage.EmbeddedVulnerability_VulnerabilityType, len(*values))
	for i, v := range *values {
		output[i] = toEmbeddedVulnerability_VulnerabilityType(&v)
	}
	return output
}

func toEnforcementAction(value *string) storage.EnforcementAction {
	if value != nil {
		return storage.EnforcementAction(storage.EnforcementAction_value[*value])
	}
	return storage.EnforcementAction(0)
}

func toEnforcementActions(values *[]string) []storage.EnforcementAction {
	if values == nil {
		return nil
	}
	output := make([]storage.EnforcementAction, len(*values))
	for i, v := range *values {
		output[i] = toEnforcementAction(&v)
	}
	return output
}

func toEventSource(value *string) storage.EventSource {
	if value != nil {
		return storage.EventSource(storage.EventSource_value[*value])
	}
	return storage.EventSource(0)
}

func toEventSources(values *[]string) []storage.EventSource {
	if values == nil {
		return nil
	}
	output := make([]storage.EventSource, len(*values))
	for i, v := range *values {
		output[i] = toEventSource(&v)
	}
	return output
}

type exclusionResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Exclusion
}

func (resolver *Resolver) wrapExclusion(value *storage.Exclusion, ok bool, err error) (*exclusionResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &exclusionResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapExclusions(values []*storage.Exclusion, err error) ([]*exclusionResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*exclusionResolver, len(values))
	for i, v := range values {
		output[i] = &exclusionResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *exclusionResolver) Deployment(ctx context.Context) (*exclusion_DeploymentResolver, error) {
	value := resolver.data.GetDeployment()
	return resolver.root.wrapExclusion_Deployment(value, true, nil)
}

func (resolver *exclusionResolver) Expiration(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetExpiration()
	return timestamp(value)
}

func (resolver *exclusionResolver) Image(ctx context.Context) (*exclusion_ImageResolver, error) {
	value := resolver.data.GetImage()
	return resolver.root.wrapExclusion_Image(value, true, nil)
}

func (resolver *exclusionResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

type exclusion_DeploymentResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Exclusion_Deployment
}

func (resolver *Resolver) wrapExclusion_Deployment(value *storage.Exclusion_Deployment, ok bool, err error) (*exclusion_DeploymentResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &exclusion_DeploymentResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapExclusion_Deployments(values []*storage.Exclusion_Deployment, err error) ([]*exclusion_DeploymentResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*exclusion_DeploymentResolver, len(values))
	for i, v := range values {
		output[i] = &exclusion_DeploymentResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *exclusion_DeploymentResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func (resolver *exclusion_DeploymentResolver) Scope(ctx context.Context) (*scopeResolver, error) {
	value := resolver.data.GetScope()
	return resolver.root.wrapScope(value, true, nil)
}

type exclusion_ImageResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Exclusion_Image
}

func (resolver *Resolver) wrapExclusion_Image(value *storage.Exclusion_Image, ok bool, err error) (*exclusion_ImageResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &exclusion_ImageResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapExclusion_Images(values []*storage.Exclusion_Image, err error) ([]*exclusion_ImageResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*exclusion_ImageResolver, len(values))
	for i, v := range values {
		output[i] = &exclusion_ImageResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *exclusion_ImageResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

type falsePositiveRequestResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.FalsePositiveRequest
}

func (resolver *Resolver) wrapFalsePositiveRequest(value *storage.FalsePositiveRequest, ok bool, err error) (*falsePositiveRequestResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &falsePositiveRequestResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapFalsePositiveRequests(values []*storage.FalsePositiveRequest, err error) ([]*falsePositiveRequestResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*falsePositiveRequestResolver, len(values))
	for i, v := range values {
		output[i] = &falsePositiveRequestResolver{root: resolver, data: v}
	}
	return output, nil
}

type generateTokenResponseResolver struct {
	ctx  context.Context
	root *Resolver
	data *v1.GenerateTokenResponse
}

func (resolver *Resolver) wrapGenerateTokenResponse(value *v1.GenerateTokenResponse, ok bool, err error) (*generateTokenResponseResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &generateTokenResponseResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapGenerateTokenResponses(values []*v1.GenerateTokenResponse, err error) ([]*generateTokenResponseResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*generateTokenResponseResolver, len(values))
	for i, v := range values {
		output[i] = &generateTokenResponseResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *generateTokenResponseResolver) Metadata(ctx context.Context) (*tokenMetadataResolver, error) {
	value := resolver.data.GetMetadata()
	return resolver.root.wrapTokenMetadata(value, true, nil)
}

func (resolver *generateTokenResponseResolver) Token(ctx context.Context) string {
	value := resolver.data.GetToken()
	return value
}

type genericResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Generic
}

func (resolver *Resolver) wrapGeneric(value *storage.Generic, ok bool, err error) (*genericResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &genericResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapGenerics(values []*storage.Generic, err error) ([]*genericResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*genericResolver, len(values))
	for i, v := range values {
		output[i] = &genericResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *genericResolver) AuditLoggingEnabled(ctx context.Context) bool {
	value := resolver.data.GetAuditLoggingEnabled()
	return value
}

func (resolver *genericResolver) CaCert(ctx context.Context) string {
	value := resolver.data.GetCaCert()
	return value
}

func (resolver *genericResolver) Endpoint(ctx context.Context) string {
	value := resolver.data.GetEndpoint()
	return value
}

func (resolver *genericResolver) ExtraFields(ctx context.Context) ([]*keyValuePairResolver, error) {
	value := resolver.data.GetExtraFields()
	return resolver.root.wrapKeyValuePairs(value, nil)
}

func (resolver *genericResolver) Headers(ctx context.Context) ([]*keyValuePairResolver, error) {
	value := resolver.data.GetHeaders()
	return resolver.root.wrapKeyValuePairs(value, nil)
}

func (resolver *genericResolver) Password(ctx context.Context) string {
	value := resolver.data.GetPassword()
	return value
}

func (resolver *genericResolver) SkipTLSVerify(ctx context.Context) bool {
	value := resolver.data.GetSkipTLSVerify()
	return value
}

func (resolver *genericResolver) Username(ctx context.Context) string {
	value := resolver.data.GetUsername()
	return value
}

type getComplianceRunStatusesResponseResolver struct {
	ctx  context.Context
	root *Resolver
	data *v1.GetComplianceRunStatusesResponse
}

func (resolver *Resolver) wrapGetComplianceRunStatusesResponse(value *v1.GetComplianceRunStatusesResponse, ok bool, err error) (*getComplianceRunStatusesResponseResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &getComplianceRunStatusesResponseResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapGetComplianceRunStatusesResponses(values []*v1.GetComplianceRunStatusesResponse, err error) ([]*getComplianceRunStatusesResponseResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*getComplianceRunStatusesResponseResolver, len(values))
	for i, v := range values {
		output[i] = &getComplianceRunStatusesResponseResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *getComplianceRunStatusesResponseResolver) InvalidRunIds(ctx context.Context) []string {
	value := resolver.data.GetInvalidRunIds()
	return value
}

func (resolver *getComplianceRunStatusesResponseResolver) Runs(ctx context.Context) ([]*complianceRunResolver, error) {
	value := resolver.data.GetRuns()
	return resolver.root.wrapComplianceRuns(value, nil)
}

type getPermissionsResponseResolver struct {
	ctx  context.Context
	root *Resolver
	data *v1.GetPermissionsResponse
}

func (resolver *Resolver) wrapGetPermissionsResponse(value *v1.GetPermissionsResponse, ok bool, err error) (*getPermissionsResponseResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &getPermissionsResponseResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapGetPermissionsResponses(values []*v1.GetPermissionsResponse, err error) ([]*getPermissionsResponseResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*getPermissionsResponseResolver, len(values))
	for i, v := range values {
		output[i] = &getPermissionsResponseResolver{root: resolver, data: v}
	}
	return output, nil
}

type googleProviderMetadataResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.GoogleProviderMetadata
}

func (resolver *Resolver) wrapGoogleProviderMetadata(value *storage.GoogleProviderMetadata, ok bool, err error) (*googleProviderMetadataResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &googleProviderMetadataResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapGoogleProviderMetadatas(values []*storage.GoogleProviderMetadata, err error) ([]*googleProviderMetadataResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*googleProviderMetadataResolver, len(values))
	for i, v := range values {
		output[i] = &googleProviderMetadataResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *googleProviderMetadataResolver) ClusterName(ctx context.Context) string {
	value := resolver.data.GetClusterName()
	return value
}

func (resolver *googleProviderMetadataResolver) Project(ctx context.Context) string {
	value := resolver.data.GetProject()
	return value
}

type groupResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Group
}

func (resolver *Resolver) wrapGroup(value *storage.Group, ok bool, err error) (*groupResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &groupResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapGroups(values []*storage.Group, err error) ([]*groupResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*groupResolver, len(values))
	for i, v := range values {
		output[i] = &groupResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *groupResolver) Props(ctx context.Context) (*groupPropertiesResolver, error) {
	value := resolver.data.GetProps()
	return resolver.root.wrapGroupProperties(value, true, nil)
}

func (resolver *groupResolver) RoleName(ctx context.Context) string {
	value := resolver.data.GetRoleName()
	return value
}

type groupPropertiesResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.GroupProperties
}

func (resolver *Resolver) wrapGroupProperties(value *storage.GroupProperties, ok bool, err error) (*groupPropertiesResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &groupPropertiesResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapGroupPropertieses(values []*storage.GroupProperties, err error) ([]*groupPropertiesResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*groupPropertiesResolver, len(values))
	for i, v := range values {
		output[i] = &groupPropertiesResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *groupPropertiesResolver) AuthProviderId(ctx context.Context) string {
	value := resolver.data.GetAuthProviderId()
	return value
}

func (resolver *groupPropertiesResolver) Key(ctx context.Context) string {
	value := resolver.data.GetKey()
	return value
}

func (resolver *groupPropertiesResolver) Value(ctx context.Context) string {
	value := resolver.data.GetValue()
	return value
}

type hostMountPolicyResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.HostMountPolicy
}

func (resolver *Resolver) wrapHostMountPolicy(value *storage.HostMountPolicy, ok bool, err error) (*hostMountPolicyResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &hostMountPolicyResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapHostMountPolicies(values []*storage.HostMountPolicy, err error) ([]*hostMountPolicyResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*hostMountPolicyResolver, len(values))
	for i, v := range values {
		output[i] = &hostMountPolicyResolver{root: resolver, data: v}
	}
	return output, nil
}

type imageResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Image
	list *storage.ListImage
}

func (resolver *Resolver) wrapImage(value *storage.Image, ok bool, err error) (*imageResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &imageResolver{root: resolver, data: value, list: nil}, nil
}

func (resolver *Resolver) wrapImages(values []*storage.Image, err error) ([]*imageResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*imageResolver, len(values))
	for i, v := range values {
		output[i] = &imageResolver{root: resolver, data: v, list: nil}
	}
	return output, nil
}

func (resolver *Resolver) wrapListImages(values []*storage.ListImage, err error) ([]*imageResolver, error) {
	if err != nil || values == nil {
		return nil, err
	}
	output := make([]*imageResolver, len(values))
	for i, v := range values {
		output[i] = &imageResolver{root: resolver, data: nil, list: v}
	}
	return output, nil
}

func (resolver *imageResolver) ensureData(ctx context.Context) {
	if resolver.data == nil {
		resolver.data = resolver.root.getImage(ctx, resolver.list.GetId())
	}
}

func (resolver *imageResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	if resolver.data == nil {
		value = resolver.list.GetId()
	}
	return graphql.ID(value)
}

func (resolver *imageResolver) IsClusterLocal(ctx context.Context) bool {
	resolver.ensureData(ctx)
	value := resolver.data.GetIsClusterLocal()
	return value
}

func (resolver *imageResolver) LastUpdated(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetLastUpdated()
	if resolver.data == nil {
		value = resolver.list.GetLastUpdated()
	}
	return timestamp(value)
}

func (resolver *imageResolver) Metadata(ctx context.Context) (*imageMetadataResolver, error) {
	resolver.ensureData(ctx)
	value := resolver.data.GetMetadata()
	return resolver.root.wrapImageMetadata(value, true, nil)
}

func (resolver *imageResolver) Name(ctx context.Context) (*imageNameResolver, error) {
	resolver.ensureData(ctx)
	value := resolver.data.GetName()
	return resolver.root.wrapImageName(value, true, nil)
}

func (resolver *imageResolver) NotPullable(ctx context.Context) bool {
	resolver.ensureData(ctx)
	value := resolver.data.GetNotPullable()
	return value
}

func (resolver *imageResolver) Notes(ctx context.Context) []string {
	resolver.ensureData(ctx)
	value := resolver.data.GetNotes()
	return stringSlice(value)
}

func (resolver *imageResolver) Priority(ctx context.Context) int32 {
	value := resolver.data.GetPriority()
	if resolver.data == nil {
		value = resolver.list.GetPriority()
	}
	return int32(value)
}

func (resolver *imageResolver) RiskScore(ctx context.Context) float64 {
	resolver.ensureData(ctx)
	value := resolver.data.GetRiskScore()
	return float64(value)
}

func (resolver *imageResolver) Scan(ctx context.Context) (*imageScanResolver, error) {
	resolver.ensureData(ctx)
	value := resolver.data.GetScan()
	return resolver.root.wrapImageScan(value, true, nil)
}

func (resolver *imageResolver) Signature(ctx context.Context) (*imageSignatureResolver, error) {
	resolver.ensureData(ctx)
	value := resolver.data.GetSignature()
	return resolver.root.wrapImageSignature(value, true, nil)
}

func (resolver *imageResolver) SignatureVerificationData(ctx context.Context) (*imageSignatureVerificationDataResolver, error) {
	resolver.ensureData(ctx)
	value := resolver.data.GetSignatureVerificationData()
	return resolver.root.wrapImageSignatureVerificationData(value, true, nil)
}

type imageComponentResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ImageComponent
}

func (resolver *Resolver) wrapImageComponent(value *storage.ImageComponent, ok bool, err error) (*imageComponentResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &imageComponentResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapImageComponents(values []*storage.ImageComponent, err error) ([]*imageComponentResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*imageComponentResolver, len(values))
	for i, v := range values {
		output[i] = &imageComponentResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *imageComponentResolver) FixedBy(ctx context.Context) string {
	value := resolver.data.GetFixedBy()
	return value
}

func (resolver *imageComponentResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *imageComponentResolver) License(ctx context.Context) (*licenseResolver, error) {
	value := resolver.data.GetLicense()
	return resolver.root.wrapLicense(value, true, nil)
}

func (resolver *imageComponentResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func (resolver *imageComponentResolver) Priority(ctx context.Context) int32 {
	value := resolver.data.GetPriority()
	return int32(value)
}

func (resolver *imageComponentResolver) RiskScore(ctx context.Context) float64 {
	value := resolver.data.GetRiskScore()
	return float64(value)
}

func (resolver *imageComponentResolver) Source(ctx context.Context) string {
	value := resolver.data.GetSource()
	return value.String()
}

func (resolver *imageComponentResolver) Version(ctx context.Context) string {
	value := resolver.data.GetVersion()
	return value
}

type imageLayerResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ImageLayer
}

func (resolver *Resolver) wrapImageLayer(value *storage.ImageLayer, ok bool, err error) (*imageLayerResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &imageLayerResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapImageLayers(values []*storage.ImageLayer, err error) ([]*imageLayerResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*imageLayerResolver, len(values))
	for i, v := range values {
		output[i] = &imageLayerResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *imageLayerResolver) Author(ctx context.Context) string {
	value := resolver.data.GetAuthor()
	return value
}

func (resolver *imageLayerResolver) Created(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetCreated()
	return timestamp(value)
}

func (resolver *imageLayerResolver) Empty(ctx context.Context) bool {
	value := resolver.data.GetEmpty()
	return value
}

func (resolver *imageLayerResolver) Instruction(ctx context.Context) string {
	value := resolver.data.GetInstruction()
	return value
}

func (resolver *imageLayerResolver) Value(ctx context.Context) string {
	value := resolver.data.GetValue()
	return value
}

type imageMetadataResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ImageMetadata
}

func (resolver *Resolver) wrapImageMetadata(value *storage.ImageMetadata, ok bool, err error) (*imageMetadataResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &imageMetadataResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapImageMetadatas(values []*storage.ImageMetadata, err error) ([]*imageMetadataResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*imageMetadataResolver, len(values))
	for i, v := range values {
		output[i] = &imageMetadataResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *imageMetadataResolver) DataSource(ctx context.Context) (*dataSourceResolver, error) {
	value := resolver.data.GetDataSource()
	return resolver.root.wrapDataSource(value, true, nil)
}

func (resolver *imageMetadataResolver) LayerShas(ctx context.Context) []string {
	value := resolver.data.GetLayerShas()
	return value
}

func (resolver *imageMetadataResolver) V1(ctx context.Context) (*v1MetadataResolver, error) {
	value := resolver.data.GetV1()
	return resolver.root.wrapV1Metadata(value, true, nil)
}

func (resolver *imageMetadataResolver) V2(ctx context.Context) (*v2MetadataResolver, error) {
	value := resolver.data.GetV2()
	return resolver.root.wrapV2Metadata(value, true, nil)
}

type imageNameResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ImageName
}

func (resolver *Resolver) wrapImageName(value *storage.ImageName, ok bool, err error) (*imageNameResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &imageNameResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapImageNames(values []*storage.ImageName, err error) ([]*imageNameResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*imageNameResolver, len(values))
	for i, v := range values {
		output[i] = &imageNameResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *imageNameResolver) FullName(ctx context.Context) string {
	value := resolver.data.GetFullName()
	return value
}

func (resolver *imageNameResolver) Registry(ctx context.Context) string {
	value := resolver.data.GetRegistry()
	return value
}

func (resolver *imageNameResolver) Remote(ctx context.Context) string {
	value := resolver.data.GetRemote()
	return value
}

func (resolver *imageNameResolver) Tag(ctx context.Context) string {
	value := resolver.data.GetTag()
	return value
}

type imageNamePolicyResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ImageNamePolicy
}

func (resolver *Resolver) wrapImageNamePolicy(value *storage.ImageNamePolicy, ok bool, err error) (*imageNamePolicyResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &imageNamePolicyResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapImageNamePolicies(values []*storage.ImageNamePolicy, err error) ([]*imageNamePolicyResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*imageNamePolicyResolver, len(values))
	for i, v := range values {
		output[i] = &imageNamePolicyResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *imageNamePolicyResolver) Registry(ctx context.Context) string {
	value := resolver.data.GetRegistry()
	return value
}

func (resolver *imageNamePolicyResolver) Remote(ctx context.Context) string {
	value := resolver.data.GetRemote()
	return value
}

func (resolver *imageNamePolicyResolver) Tag(ctx context.Context) string {
	value := resolver.data.GetTag()
	return value
}

type imagePullSecretResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ImagePullSecret
}

func (resolver *Resolver) wrapImagePullSecret(value *storage.ImagePullSecret, ok bool, err error) (*imagePullSecretResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &imagePullSecretResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapImagePullSecrets(values []*storage.ImagePullSecret, err error) ([]*imagePullSecretResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*imagePullSecretResolver, len(values))
	for i, v := range values {
		output[i] = &imagePullSecretResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *imagePullSecretResolver) Registries(ctx context.Context) ([]*imagePullSecret_RegistryResolver, error) {
	value := resolver.data.GetRegistries()
	return resolver.root.wrapImagePullSecret_Registries(value, nil)
}

type imagePullSecret_RegistryResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ImagePullSecret_Registry
}

func (resolver *Resolver) wrapImagePullSecret_Registry(value *storage.ImagePullSecret_Registry, ok bool, err error) (*imagePullSecret_RegistryResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &imagePullSecret_RegistryResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapImagePullSecret_Registries(values []*storage.ImagePullSecret_Registry, err error) ([]*imagePullSecret_RegistryResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*imagePullSecret_RegistryResolver, len(values))
	for i, v := range values {
		output[i] = &imagePullSecret_RegistryResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *imagePullSecret_RegistryResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func (resolver *imagePullSecret_RegistryResolver) Username(ctx context.Context) string {
	value := resolver.data.GetUsername()
	return value
}

type imageScanResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ImageScan
}

func (resolver *Resolver) wrapImageScan(value *storage.ImageScan, ok bool, err error) (*imageScanResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &imageScanResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapImageScans(values []*storage.ImageScan, err error) ([]*imageScanResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*imageScanResolver, len(values))
	for i, v := range values {
		output[i] = &imageScanResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *imageScanResolver) DataSource(ctx context.Context) (*dataSourceResolver, error) {
	value := resolver.data.GetDataSource()
	return resolver.root.wrapDataSource(value, true, nil)
}

func (resolver *imageScanResolver) Notes(ctx context.Context) []string {
	value := resolver.data.GetNotes()
	return stringSlice(value)
}

func (resolver *imageScanResolver) OperatingSystem(ctx context.Context) string {
	value := resolver.data.GetOperatingSystem()
	return value
}

func (resolver *imageScanResolver) ScanTime(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetScanTime()
	return timestamp(value)
}

func (resolver *imageScanResolver) ScannerVersion(ctx context.Context) string {
	value := resolver.data.GetScannerVersion()
	return value
}

func toImageScan_Note(value *string) storage.ImageScan_Note {
	if value != nil {
		return storage.ImageScan_Note(storage.ImageScan_Note_value[*value])
	}
	return storage.ImageScan_Note(0)
}

func toImageScan_Notes(values *[]string) []storage.ImageScan_Note {
	if values == nil {
		return nil
	}
	output := make([]storage.ImageScan_Note, len(*values))
	for i, v := range *values {
		output[i] = toImageScan_Note(&v)
	}
	return output
}

type imageSignatureResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ImageSignature
}

func (resolver *Resolver) wrapImageSignature(value *storage.ImageSignature, ok bool, err error) (*imageSignatureResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &imageSignatureResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapImageSignatures(values []*storage.ImageSignature, err error) ([]*imageSignatureResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*imageSignatureResolver, len(values))
	for i, v := range values {
		output[i] = &imageSignatureResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *imageSignatureResolver) Signatures(ctx context.Context) ([]*signatureResolver, error) {
	value := resolver.data.GetSignatures()
	return resolver.root.wrapSignatures(value, nil)
}

type imageSignatureVerificationDataResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ImageSignatureVerificationData
}

func (resolver *Resolver) wrapImageSignatureVerificationData(value *storage.ImageSignatureVerificationData, ok bool, err error) (*imageSignatureVerificationDataResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &imageSignatureVerificationDataResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapImageSignatureVerificationDatas(values []*storage.ImageSignatureVerificationData, err error) ([]*imageSignatureVerificationDataResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*imageSignatureVerificationDataResolver, len(values))
	for i, v := range values {
		output[i] = &imageSignatureVerificationDataResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *imageSignatureVerificationDataResolver) Results(ctx context.Context) ([]*imageSignatureVerificationResultResolver, error) {
	value := resolver.data.GetResults()
	return resolver.root.wrapImageSignatureVerificationResults(value, nil)
}

type imageSignatureVerificationResultResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ImageSignatureVerificationResult
}

func (resolver *Resolver) wrapImageSignatureVerificationResult(value *storage.ImageSignatureVerificationResult, ok bool, err error) (*imageSignatureVerificationResultResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &imageSignatureVerificationResultResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapImageSignatureVerificationResults(values []*storage.ImageSignatureVerificationResult, err error) ([]*imageSignatureVerificationResultResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*imageSignatureVerificationResultResolver, len(values))
	for i, v := range values {
		output[i] = &imageSignatureVerificationResultResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *imageSignatureVerificationResultResolver) Description(ctx context.Context) string {
	value := resolver.data.GetDescription()
	return value
}

func (resolver *imageSignatureVerificationResultResolver) Status(ctx context.Context) string {
	value := resolver.data.GetStatus()
	return value.String()
}

func (resolver *imageSignatureVerificationResultResolver) VerificationTime(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetVerificationTime()
	return timestamp(value)
}

func (resolver *imageSignatureVerificationResultResolver) VerifierId(ctx context.Context) string {
	value := resolver.data.GetVerifierId()
	return value
}

func toImageSignatureVerificationResult_Status(value *string) storage.ImageSignatureVerificationResult_Status {
	if value != nil {
		return storage.ImageSignatureVerificationResult_Status(storage.ImageSignatureVerificationResult_Status_value[*value])
	}
	return storage.ImageSignatureVerificationResult_Status(0)
}

func toImageSignatureVerificationResult_Statuses(values *[]string) []storage.ImageSignatureVerificationResult_Status {
	if values == nil {
		return nil
	}
	output := make([]storage.ImageSignatureVerificationResult_Status, len(*values))
	for i, v := range *values {
		output[i] = toImageSignatureVerificationResult_Status(&v)
	}
	return output
}

func toImage_Note(value *string) storage.Image_Note {
	if value != nil {
		return storage.Image_Note(storage.Image_Note_value[*value])
	}
	return storage.Image_Note(0)
}

func toImage_Notes(values *[]string) []storage.Image_Note {
	if values == nil {
		return nil
	}
	output := make([]storage.Image_Note, len(*values))
	for i, v := range *values {
		output[i] = toImage_Note(&v)
	}
	return output
}

type jiraResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Jira
}

func (resolver *Resolver) wrapJira(value *storage.Jira, ok bool, err error) (*jiraResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &jiraResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapJiras(values []*storage.Jira, err error) ([]*jiraResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*jiraResolver, len(values))
	for i, v := range values {
		output[i] = &jiraResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *jiraResolver) DefaultFieldsJson(ctx context.Context) string {
	value := resolver.data.GetDefaultFieldsJson()
	return value
}

func (resolver *jiraResolver) IssueType(ctx context.Context) string {
	value := resolver.data.GetIssueType()
	return value
}

func (resolver *jiraResolver) Password(ctx context.Context) string {
	value := resolver.data.GetPassword()
	return value
}

func (resolver *jiraResolver) PriorityMappings(ctx context.Context) ([]*jira_PriorityMappingResolver, error) {
	value := resolver.data.GetPriorityMappings()
	return resolver.root.wrapJira_PriorityMappings(value, nil)
}

func (resolver *jiraResolver) Url(ctx context.Context) string {
	value := resolver.data.GetUrl()
	return value
}

func (resolver *jiraResolver) Username(ctx context.Context) string {
	value := resolver.data.GetUsername()
	return value
}

type jira_PriorityMappingResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Jira_PriorityMapping
}

func (resolver *Resolver) wrapJira_PriorityMapping(value *storage.Jira_PriorityMapping, ok bool, err error) (*jira_PriorityMappingResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &jira_PriorityMappingResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapJira_PriorityMappings(values []*storage.Jira_PriorityMapping, err error) ([]*jira_PriorityMappingResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*jira_PriorityMappingResolver, len(values))
	for i, v := range values {
		output[i] = &jira_PriorityMappingResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *jira_PriorityMappingResolver) PriorityName(ctx context.Context) string {
	value := resolver.data.GetPriorityName()
	return value
}

func (resolver *jira_PriorityMappingResolver) Severity(ctx context.Context) string {
	value := resolver.data.GetSeverity()
	return value.String()
}

type k8SRoleResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.K8SRole
}

func (resolver *Resolver) wrapK8SRole(value *storage.K8SRole, ok bool, err error) (*k8SRoleResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &k8SRoleResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapK8SRoles(values []*storage.K8SRole, err error) ([]*k8SRoleResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*k8SRoleResolver, len(values))
	for i, v := range values {
		output[i] = &k8SRoleResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *k8SRoleResolver) Annotations(ctx context.Context) labels {
	value := resolver.data.GetAnnotations()
	return labelsResolver(value)
}

func (resolver *k8SRoleResolver) ClusterId(ctx context.Context) string {
	value := resolver.data.GetClusterId()
	return value
}

func (resolver *k8SRoleResolver) ClusterName(ctx context.Context) string {
	value := resolver.data.GetClusterName()
	return value
}

func (resolver *k8SRoleResolver) ClusterRole(ctx context.Context) bool {
	value := resolver.data.GetClusterRole()
	return value
}

func (resolver *k8SRoleResolver) CreatedAt(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetCreatedAt()
	return timestamp(value)
}

func (resolver *k8SRoleResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *k8SRoleResolver) Labels(ctx context.Context) labels {
	value := resolver.data.GetLabels()
	return labelsResolver(value)
}

func (resolver *k8SRoleResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func (resolver *k8SRoleResolver) Namespace(ctx context.Context) string {
	value := resolver.data.GetNamespace()
	return value
}

func (resolver *k8SRoleResolver) Rules(ctx context.Context) ([]*policyRuleResolver, error) {
	value := resolver.data.GetRules()
	return resolver.root.wrapPolicyRules(value, nil)
}

type k8SRoleBindingResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.K8SRoleBinding
}

func (resolver *Resolver) wrapK8SRoleBinding(value *storage.K8SRoleBinding, ok bool, err error) (*k8SRoleBindingResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &k8SRoleBindingResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapK8SRoleBindings(values []*storage.K8SRoleBinding, err error) ([]*k8SRoleBindingResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*k8SRoleBindingResolver, len(values))
	for i, v := range values {
		output[i] = &k8SRoleBindingResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *k8SRoleBindingResolver) Annotations(ctx context.Context) labels {
	value := resolver.data.GetAnnotations()
	return labelsResolver(value)
}

func (resolver *k8SRoleBindingResolver) ClusterId(ctx context.Context) string {
	value := resolver.data.GetClusterId()
	return value
}

func (resolver *k8SRoleBindingResolver) ClusterName(ctx context.Context) string {
	value := resolver.data.GetClusterName()
	return value
}

func (resolver *k8SRoleBindingResolver) ClusterRole(ctx context.Context) bool {
	value := resolver.data.GetClusterRole()
	return value
}

func (resolver *k8SRoleBindingResolver) CreatedAt(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetCreatedAt()
	return timestamp(value)
}

func (resolver *k8SRoleBindingResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *k8SRoleBindingResolver) Labels(ctx context.Context) labels {
	value := resolver.data.GetLabels()
	return labelsResolver(value)
}

func (resolver *k8SRoleBindingResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func (resolver *k8SRoleBindingResolver) Namespace(ctx context.Context) string {
	value := resolver.data.GetNamespace()
	return value
}

func (resolver *k8SRoleBindingResolver) RoleId(ctx context.Context) string {
	value := resolver.data.GetRoleId()
	return value
}

func (resolver *k8SRoleBindingResolver) Subjects(ctx context.Context) ([]*subjectResolver, error) {
	value := resolver.data.GetSubjects()
	return resolver.root.wrapSubjects(value, nil)
}

type keyValuePairResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.KeyValuePair
}

func (resolver *Resolver) wrapKeyValuePair(value *storage.KeyValuePair, ok bool, err error) (*keyValuePairResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &keyValuePairResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapKeyValuePairs(values []*storage.KeyValuePair, err error) ([]*keyValuePairResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*keyValuePairResolver, len(values))
	for i, v := range values {
		output[i] = &keyValuePairResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *keyValuePairResolver) Key(ctx context.Context) string {
	value := resolver.data.GetKey()
	return value
}

func (resolver *keyValuePairResolver) Value(ctx context.Context) string {
	value := resolver.data.GetValue()
	return value
}

type keyValuePolicyResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.KeyValuePolicy
}

func (resolver *Resolver) wrapKeyValuePolicy(value *storage.KeyValuePolicy, ok bool, err error) (*keyValuePolicyResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &keyValuePolicyResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapKeyValuePolicies(values []*storage.KeyValuePolicy, err error) ([]*keyValuePolicyResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*keyValuePolicyResolver, len(values))
	for i, v := range values {
		output[i] = &keyValuePolicyResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *keyValuePolicyResolver) EnvVarSource(ctx context.Context) string {
	value := resolver.data.GetEnvVarSource()
	return value.String()
}

func (resolver *keyValuePolicyResolver) Key(ctx context.Context) string {
	value := resolver.data.GetKey()
	return value
}

func (resolver *keyValuePolicyResolver) Value(ctx context.Context) string {
	value := resolver.data.GetValue()
	return value
}

func toL4Protocol(value *string) storage.L4Protocol {
	if value != nil {
		return storage.L4Protocol(storage.L4Protocol_value[*value])
	}
	return storage.L4Protocol(0)
}

func toL4Protocols(values *[]string) []storage.L4Protocol {
	if values == nil {
		return nil
	}
	output := make([]storage.L4Protocol, len(*values))
	for i, v := range *values {
		output[i] = toL4Protocol(&v)
	}
	return output
}

type labelSelectorResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.LabelSelector
}

func (resolver *Resolver) wrapLabelSelector(value *storage.LabelSelector, ok bool, err error) (*labelSelectorResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &labelSelectorResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapLabelSelectors(values []*storage.LabelSelector, err error) ([]*labelSelectorResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*labelSelectorResolver, len(values))
	for i, v := range values {
		output[i] = &labelSelectorResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *labelSelectorResolver) MatchLabels(ctx context.Context) labels {
	value := resolver.data.GetMatchLabels()
	return labelsResolver(value)
}

func (resolver *labelSelectorResolver) Requirements(ctx context.Context) ([]*labelSelector_RequirementResolver, error) {
	value := resolver.data.GetRequirements()
	return resolver.root.wrapLabelSelector_Requirements(value, nil)
}

func toLabelSelector_Operator(value *string) storage.LabelSelector_Operator {
	if value != nil {
		return storage.LabelSelector_Operator(storage.LabelSelector_Operator_value[*value])
	}
	return storage.LabelSelector_Operator(0)
}

func toLabelSelector_Operators(values *[]string) []storage.LabelSelector_Operator {
	if values == nil {
		return nil
	}
	output := make([]storage.LabelSelector_Operator, len(*values))
	for i, v := range *values {
		output[i] = toLabelSelector_Operator(&v)
	}
	return output
}

type labelSelector_RequirementResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.LabelSelector_Requirement
}

func (resolver *Resolver) wrapLabelSelector_Requirement(value *storage.LabelSelector_Requirement, ok bool, err error) (*labelSelector_RequirementResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &labelSelector_RequirementResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapLabelSelector_Requirements(values []*storage.LabelSelector_Requirement, err error) ([]*labelSelector_RequirementResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*labelSelector_RequirementResolver, len(values))
	for i, v := range values {
		output[i] = &labelSelector_RequirementResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *labelSelector_RequirementResolver) Key(ctx context.Context) string {
	value := resolver.data.GetKey()
	return value
}

func (resolver *labelSelector_RequirementResolver) Op(ctx context.Context) string {
	value := resolver.data.GetOp()
	return value.String()
}

func (resolver *labelSelector_RequirementResolver) Values(ctx context.Context) []string {
	value := resolver.data.GetValues()
	return value
}

type licenseResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.License
}

func (resolver *Resolver) wrapLicense(value *storage.License, ok bool, err error) (*licenseResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &licenseResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapLicenses(values []*storage.License, err error) ([]*licenseResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*licenseResolver, len(values))
	for i, v := range values {
		output[i] = &licenseResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *licenseResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func (resolver *licenseResolver) Type(ctx context.Context) string {
	value := resolver.data.GetType()
	return value
}

func (resolver *licenseResolver) Url(ctx context.Context) string {
	value := resolver.data.GetUrl()
	return value
}

func toLifecycleStage(value *string) storage.LifecycleStage {
	if value != nil {
		return storage.LifecycleStage(storage.LifecycleStage_value[*value])
	}
	return storage.LifecycleStage(0)
}

func toLifecycleStages(values *[]string) []storage.LifecycleStage {
	if values == nil {
		return nil
	}
	output := make([]storage.LifecycleStage, len(*values))
	for i, v := range *values {
		output[i] = toLifecycleStage(&v)
	}
	return output
}

func toListAlert_ResourceType(value *string) storage.ListAlert_ResourceType {
	if value != nil {
		return storage.ListAlert_ResourceType(storage.ListAlert_ResourceType_value[*value])
	}
	return storage.ListAlert_ResourceType(0)
}

func toListAlert_ResourceTypes(values *[]string) []storage.ListAlert_ResourceType {
	if values == nil {
		return nil
	}
	output := make([]storage.ListAlert_ResourceType, len(*values))
	for i, v := range *values {
		output[i] = toListAlert_ResourceType(&v)
	}
	return output
}

type livenessProbeResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.LivenessProbe
}

func (resolver *Resolver) wrapLivenessProbe(value *storage.LivenessProbe, ok bool, err error) (*livenessProbeResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &livenessProbeResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapLivenessProbes(values []*storage.LivenessProbe, err error) ([]*livenessProbeResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*livenessProbeResolver, len(values))
	for i, v := range values {
		output[i] = &livenessProbeResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *livenessProbeResolver) Defined(ctx context.Context) bool {
	value := resolver.data.GetDefined()
	return value
}

func toManagerType(value *string) storage.ManagerType {
	if value != nil {
		return storage.ManagerType(storage.ManagerType_value[*value])
	}
	return storage.ManagerType(0)
}

func toManagerTypes(values *[]string) []storage.ManagerType {
	if values == nil {
		return nil
	}
	output := make([]storage.ManagerType, len(*values))
	for i, v := range *values {
		output[i] = toManagerType(&v)
	}
	return output
}

type metadataResolver struct {
	ctx  context.Context
	root *Resolver
	data *v1.Metadata
}

func (resolver *Resolver) wrapMetadata(value *v1.Metadata, ok bool, err error) (*metadataResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &metadataResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapMetadatas(values []*v1.Metadata, err error) ([]*metadataResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*metadataResolver, len(values))
	for i, v := range values {
		output[i] = &metadataResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *metadataResolver) BuildFlavor(ctx context.Context) string {
	value := resolver.data.GetBuildFlavor()
	return value
}

func (resolver *metadataResolver) LicenseStatus(ctx context.Context) string {
	value := resolver.data.GetLicenseStatus()
	return value.String()
}

func (resolver *metadataResolver) ReleaseBuild(ctx context.Context) bool {
	value := resolver.data.GetReleaseBuild()
	return value
}

func (resolver *metadataResolver) Version(ctx context.Context) string {
	value := resolver.data.GetVersion()
	return value
}

func toMetadata_LicenseStatus(value *string) v1.Metadata_LicenseStatus {
	if value != nil {
		return v1.Metadata_LicenseStatus(v1.Metadata_LicenseStatus_value[*value])
	}
	return v1.Metadata_LicenseStatus(0)
}

func toMetadata_LicenseStatuses(values *[]string) []v1.Metadata_LicenseStatus {
	if values == nil {
		return nil
	}
	output := make([]v1.Metadata_LicenseStatus, len(*values))
	for i, v := range *values {
		output[i] = toMetadata_LicenseStatus(&v)
	}
	return output
}

type mitreAttackVectorResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.MitreAttackVector
}

func (resolver *Resolver) wrapMitreAttackVector(value *storage.MitreAttackVector, ok bool, err error) (*mitreAttackVectorResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &mitreAttackVectorResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapMitreAttackVectors(values []*storage.MitreAttackVector, err error) ([]*mitreAttackVectorResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*mitreAttackVectorResolver, len(values))
	for i, v := range values {
		output[i] = &mitreAttackVectorResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *mitreAttackVectorResolver) Tactic(ctx context.Context) (*mitreTacticResolver, error) {
	value := resolver.data.GetTactic()
	return resolver.root.wrapMitreTactic(value, true, nil)
}

func (resolver *mitreAttackVectorResolver) Techniques(ctx context.Context) ([]*mitreTechniqueResolver, error) {
	value := resolver.data.GetTechniques()
	return resolver.root.wrapMitreTechniques(value, nil)
}

type mitreTacticResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.MitreTactic
}

func (resolver *Resolver) wrapMitreTactic(value *storage.MitreTactic, ok bool, err error) (*mitreTacticResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &mitreTacticResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapMitreTactics(values []*storage.MitreTactic, err error) ([]*mitreTacticResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*mitreTacticResolver, len(values))
	for i, v := range values {
		output[i] = &mitreTacticResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *mitreTacticResolver) Description(ctx context.Context) string {
	value := resolver.data.GetDescription()
	return value
}

func (resolver *mitreTacticResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *mitreTacticResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

type mitreTechniqueResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.MitreTechnique
}

func (resolver *Resolver) wrapMitreTechnique(value *storage.MitreTechnique, ok bool, err error) (*mitreTechniqueResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &mitreTechniqueResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapMitreTechniques(values []*storage.MitreTechnique, err error) ([]*mitreTechniqueResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*mitreTechniqueResolver, len(values))
	for i, v := range values {
		output[i] = &mitreTechniqueResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *mitreTechniqueResolver) Description(ctx context.Context) string {
	value := resolver.data.GetDescription()
	return value
}

func (resolver *mitreTechniqueResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *mitreTechniqueResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

type namespaceResolver struct {
	ctx  context.Context
	root *Resolver
	data *v1.Namespace
}

func (resolver *Resolver) wrapNamespace(value *v1.Namespace, ok bool, err error) (*namespaceResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &namespaceResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapNamespaces(values []*v1.Namespace, err error) ([]*namespaceResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*namespaceResolver, len(values))
	for i, v := range values {
		output[i] = &namespaceResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *namespaceResolver) Metadata(ctx context.Context) (*namespaceMetadataResolver, error) {
	value := resolver.data.GetMetadata()
	return resolver.root.wrapNamespaceMetadata(value, true, nil)
}

func (resolver *namespaceResolver) NumDeployments(ctx context.Context) int32 {
	value := resolver.data.GetNumDeployments()
	return value
}

func (resolver *namespaceResolver) NumNetworkPolicies(ctx context.Context) int32 {
	value := resolver.data.GetNumNetworkPolicies()
	return value
}

func (resolver *namespaceResolver) NumSecrets(ctx context.Context) int32 {
	value := resolver.data.GetNumSecrets()
	return value
}

type namespaceMetadataResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.NamespaceMetadata
}

func (resolver *Resolver) wrapNamespaceMetadata(value *storage.NamespaceMetadata, ok bool, err error) (*namespaceMetadataResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &namespaceMetadataResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapNamespaceMetadatas(values []*storage.NamespaceMetadata, err error) ([]*namespaceMetadataResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*namespaceMetadataResolver, len(values))
	for i, v := range values {
		output[i] = &namespaceMetadataResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *namespaceMetadataResolver) Annotations(ctx context.Context) labels {
	value := resolver.data.GetAnnotations()
	return labelsResolver(value)
}

func (resolver *namespaceMetadataResolver) ClusterId(ctx context.Context) string {
	value := resolver.data.GetClusterId()
	return value
}

func (resolver *namespaceMetadataResolver) ClusterName(ctx context.Context) string {
	value := resolver.data.GetClusterName()
	return value
}

func (resolver *namespaceMetadataResolver) CreationTime(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetCreationTime()
	return timestamp(value)
}

func (resolver *namespaceMetadataResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *namespaceMetadataResolver) Labels(ctx context.Context) labels {
	value := resolver.data.GetLabels()
	return labelsResolver(value)
}

func (resolver *namespaceMetadataResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func (resolver *namespaceMetadataResolver) Priority(ctx context.Context) int32 {
	value := resolver.data.GetPriority()
	return int32(value)
}

type networkEntityInfoResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.NetworkEntityInfo
}

func (resolver *Resolver) wrapNetworkEntityInfo(value *storage.NetworkEntityInfo, ok bool, err error) (*networkEntityInfoResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &networkEntityInfoResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapNetworkEntityInfos(values []*storage.NetworkEntityInfo, err error) ([]*networkEntityInfoResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*networkEntityInfoResolver, len(values))
	for i, v := range values {
		output[i] = &networkEntityInfoResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *networkEntityInfoResolver) Deployment(ctx context.Context) (*networkEntityInfo_DeploymentResolver, error) {
	value := resolver.data.GetDeployment()
	return resolver.root.wrapNetworkEntityInfo_Deployment(value, true, nil)
}

func (resolver *networkEntityInfoResolver) ExternalSource(ctx context.Context) (*networkEntityInfo_ExternalSourceResolver, error) {
	value := resolver.data.GetExternalSource()
	return resolver.root.wrapNetworkEntityInfo_ExternalSource(value, true, nil)
}

func (resolver *networkEntityInfoResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *networkEntityInfoResolver) Type(ctx context.Context) string {
	value := resolver.data.GetType()
	return value.String()
}

type networkEntityInfoDescResolver struct {
	resolver interface{}
}

func (resolver *networkEntityInfoResolver) Desc() *networkEntityInfoDescResolver {
	if val := resolver.data.GetDeployment(); val != nil {
		return &networkEntityInfoDescResolver{
			resolver: &networkEntityInfo_DeploymentResolver{root: resolver.root, data: val},
		}
	}
	if val := resolver.data.GetExternalSource(); val != nil {
		return &networkEntityInfoDescResolver{
			resolver: &networkEntityInfo_ExternalSourceResolver{root: resolver.root, data: val},
		}
	}
	return nil
}

func (resolver *networkEntityInfoDescResolver) ToNetworkEntityInfo_Deployment() (*networkEntityInfo_DeploymentResolver, bool) {
	res, ok := resolver.resolver.(*networkEntityInfo_DeploymentResolver)
	return res, ok
}

func (resolver *networkEntityInfoDescResolver) ToNetworkEntityInfo_ExternalSource() (*networkEntityInfo_ExternalSourceResolver, bool) {
	res, ok := resolver.resolver.(*networkEntityInfo_ExternalSourceResolver)
	return res, ok
}

type networkEntityInfo_DeploymentResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.NetworkEntityInfo_Deployment
}

func (resolver *Resolver) wrapNetworkEntityInfo_Deployment(value *storage.NetworkEntityInfo_Deployment, ok bool, err error) (*networkEntityInfo_DeploymentResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &networkEntityInfo_DeploymentResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapNetworkEntityInfo_Deployments(values []*storage.NetworkEntityInfo_Deployment, err error) ([]*networkEntityInfo_DeploymentResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*networkEntityInfo_DeploymentResolver, len(values))
	for i, v := range values {
		output[i] = &networkEntityInfo_DeploymentResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *networkEntityInfo_DeploymentResolver) Cluster(ctx context.Context) string {
	value := resolver.data.GetCluster()
	return value
}

func (resolver *networkEntityInfo_DeploymentResolver) ListenPorts(ctx context.Context) ([]*networkEntityInfo_Deployment_ListenPortResolver, error) {
	value := resolver.data.GetListenPorts()
	return resolver.root.wrapNetworkEntityInfo_Deployment_ListenPorts(value, nil)
}

func (resolver *networkEntityInfo_DeploymentResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func (resolver *networkEntityInfo_DeploymentResolver) Namespace(ctx context.Context) string {
	value := resolver.data.GetNamespace()
	return value
}

type networkEntityInfo_Deployment_ListenPortResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.NetworkEntityInfo_Deployment_ListenPort
}

func (resolver *Resolver) wrapNetworkEntityInfo_Deployment_ListenPort(value *storage.NetworkEntityInfo_Deployment_ListenPort, ok bool, err error) (*networkEntityInfo_Deployment_ListenPortResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &networkEntityInfo_Deployment_ListenPortResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapNetworkEntityInfo_Deployment_ListenPorts(values []*storage.NetworkEntityInfo_Deployment_ListenPort, err error) ([]*networkEntityInfo_Deployment_ListenPortResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*networkEntityInfo_Deployment_ListenPortResolver, len(values))
	for i, v := range values {
		output[i] = &networkEntityInfo_Deployment_ListenPortResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *networkEntityInfo_Deployment_ListenPortResolver) L4Protocol(ctx context.Context) string {
	value := resolver.data.GetL4Protocol()
	return value.String()
}

func (resolver *networkEntityInfo_Deployment_ListenPortResolver) Port(ctx context.Context) int32 {
	value := resolver.data.GetPort()
	return int32(value)
}

type networkEntityInfo_ExternalSourceResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.NetworkEntityInfo_ExternalSource
}

func (resolver *Resolver) wrapNetworkEntityInfo_ExternalSource(value *storage.NetworkEntityInfo_ExternalSource, ok bool, err error) (*networkEntityInfo_ExternalSourceResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &networkEntityInfo_ExternalSourceResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapNetworkEntityInfo_ExternalSources(values []*storage.NetworkEntityInfo_ExternalSource, err error) ([]*networkEntityInfo_ExternalSourceResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*networkEntityInfo_ExternalSourceResolver, len(values))
	for i, v := range values {
		output[i] = &networkEntityInfo_ExternalSourceResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *networkEntityInfo_ExternalSourceResolver) Default(ctx context.Context) bool {
	value := resolver.data.GetDefault()
	return value
}

func (resolver *networkEntityInfo_ExternalSourceResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func toNetworkEntityInfo_Type(value *string) storage.NetworkEntityInfo_Type {
	if value != nil {
		return storage.NetworkEntityInfo_Type(storage.NetworkEntityInfo_Type_value[*value])
	}
	return storage.NetworkEntityInfo_Type(0)
}

func toNetworkEntityInfo_Types(values *[]string) []storage.NetworkEntityInfo_Type {
	if values == nil {
		return nil
	}
	output := make([]storage.NetworkEntityInfo_Type, len(*values))
	for i, v := range *values {
		output[i] = toNetworkEntityInfo_Type(&v)
	}
	return output
}

type networkFlowResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.NetworkFlow
}

func (resolver *Resolver) wrapNetworkFlow(value *storage.NetworkFlow, ok bool, err error) (*networkFlowResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &networkFlowResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapNetworkFlows(values []*storage.NetworkFlow, err error) ([]*networkFlowResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*networkFlowResolver, len(values))
	for i, v := range values {
		output[i] = &networkFlowResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *networkFlowResolver) LastSeenTimestamp(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetLastSeenTimestamp()
	return timestamp(value)
}

func (resolver *networkFlowResolver) Props(ctx context.Context) (*networkFlowPropertiesResolver, error) {
	value := resolver.data.GetProps()
	return resolver.root.wrapNetworkFlowProperties(value, true, nil)
}

type networkFlowPropertiesResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.NetworkFlowProperties
}

func (resolver *Resolver) wrapNetworkFlowProperties(value *storage.NetworkFlowProperties, ok bool, err error) (*networkFlowPropertiesResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &networkFlowPropertiesResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapNetworkFlowPropertieses(values []*storage.NetworkFlowProperties, err error) ([]*networkFlowPropertiesResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*networkFlowPropertiesResolver, len(values))
	for i, v := range values {
		output[i] = &networkFlowPropertiesResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *networkFlowPropertiesResolver) DstEntity(ctx context.Context) (*networkEntityInfoResolver, error) {
	value := resolver.data.GetDstEntity()
	return resolver.root.wrapNetworkEntityInfo(value, true, nil)
}

func (resolver *networkFlowPropertiesResolver) DstPort(ctx context.Context) int32 {
	value := resolver.data.GetDstPort()
	return int32(value)
}

func (resolver *networkFlowPropertiesResolver) L4Protocol(ctx context.Context) string {
	value := resolver.data.GetL4Protocol()
	return value.String()
}

func (resolver *networkFlowPropertiesResolver) SrcEntity(ctx context.Context) (*networkEntityInfoResolver, error) {
	value := resolver.data.GetSrcEntity()
	return resolver.root.wrapNetworkEntityInfo(value, true, nil)
}

type nodeResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Node
}

func (resolver *Resolver) wrapNode(value *storage.Node, ok bool, err error) (*nodeResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &nodeResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapNodes(values []*storage.Node, err error) ([]*nodeResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*nodeResolver, len(values))
	for i, v := range values {
		output[i] = &nodeResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *nodeResolver) Annotations(ctx context.Context) labels {
	value := resolver.data.GetAnnotations()
	return labelsResolver(value)
}

func (resolver *nodeResolver) ClusterId(ctx context.Context) string {
	value := resolver.data.GetClusterId()
	return value
}

func (resolver *nodeResolver) ClusterName(ctx context.Context) string {
	value := resolver.data.GetClusterName()
	return value
}

func (resolver *nodeResolver) ContainerRuntime(ctx context.Context) (*containerRuntimeInfoResolver, error) {
	value := resolver.data.GetContainerRuntime()
	return resolver.root.wrapContainerRuntimeInfo(value, true, nil)
}

func (resolver *nodeResolver) ContainerRuntimeVersion(ctx context.Context) string {
	value := resolver.data.GetContainerRuntimeVersion()
	return value
}

func (resolver *nodeResolver) ExternalIpAddresses(ctx context.Context) []string {
	value := resolver.data.GetExternalIpAddresses()
	return value
}

func (resolver *nodeResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *nodeResolver) InternalIpAddresses(ctx context.Context) []string {
	value := resolver.data.GetInternalIpAddresses()
	return value
}

func (resolver *nodeResolver) JoinedAt(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetJoinedAt()
	return timestamp(value)
}

func (resolver *nodeResolver) K8SUpdated(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetK8SUpdated()
	return timestamp(value)
}

func (resolver *nodeResolver) KernelVersion(ctx context.Context) string {
	value := resolver.data.GetKernelVersion()
	return value
}

func (resolver *nodeResolver) KubeProxyVersion(ctx context.Context) string {
	value := resolver.data.GetKubeProxyVersion()
	return value
}

func (resolver *nodeResolver) KubeletVersion(ctx context.Context) string {
	value := resolver.data.GetKubeletVersion()
	return value
}

func (resolver *nodeResolver) Labels(ctx context.Context) labels {
	value := resolver.data.GetLabels()
	return labelsResolver(value)
}

func (resolver *nodeResolver) LastUpdated(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetLastUpdated()
	return timestamp(value)
}

func (resolver *nodeResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func (resolver *nodeResolver) OperatingSystem(ctx context.Context) string {
	value := resolver.data.GetOperatingSystem()
	return value
}

func (resolver *nodeResolver) OsImage(ctx context.Context) string {
	value := resolver.data.GetOsImage()
	return value
}

func (resolver *nodeResolver) Priority(ctx context.Context) int32 {
	value := resolver.data.GetPriority()
	return int32(value)
}

func (resolver *nodeResolver) RiskScore(ctx context.Context) float64 {
	value := resolver.data.GetRiskScore()
	return float64(value)
}

func (resolver *nodeResolver) Scan(ctx context.Context) (*nodeScanResolver, error) {
	value := resolver.data.GetScan()
	return resolver.root.wrapNodeScan(value, true, nil)
}

func (resolver *nodeResolver) Taints(ctx context.Context) ([]*taintResolver, error) {
	value := resolver.data.GetTaints()
	return resolver.root.wrapTaints(value, nil)
}

type nodeScanResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.NodeScan
}

func (resolver *Resolver) wrapNodeScan(value *storage.NodeScan, ok bool, err error) (*nodeScanResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &nodeScanResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapNodeScans(values []*storage.NodeScan, err error) ([]*nodeScanResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*nodeScanResolver, len(values))
	for i, v := range values {
		output[i] = &nodeScanResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *nodeScanResolver) OperatingSystem(ctx context.Context) string {
	value := resolver.data.GetOperatingSystem()
	return value
}

func (resolver *nodeScanResolver) ScanTime(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetScanTime()
	return timestamp(value)
}

type notifierResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Notifier
}

func (resolver *Resolver) wrapNotifier(value *storage.Notifier, ok bool, err error) (*notifierResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &notifierResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapNotifiers(values []*storage.Notifier, err error) ([]*notifierResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*notifierResolver, len(values))
	for i, v := range values {
		output[i] = &notifierResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *notifierResolver) AwsSecurityHub(ctx context.Context) (*aWSSecurityHubResolver, error) {
	value := resolver.data.GetAwsSecurityHub()
	return resolver.root.wrapAWSSecurityHub(value, true, nil)
}

func (resolver *notifierResolver) Cscc(ctx context.Context) (*cSCCResolver, error) {
	value := resolver.data.GetCscc()
	return resolver.root.wrapCSCC(value, true, nil)
}

func (resolver *notifierResolver) Email(ctx context.Context) (*emailResolver, error) {
	value := resolver.data.GetEmail()
	return resolver.root.wrapEmail(value, true, nil)
}

func (resolver *notifierResolver) Generic(ctx context.Context) (*genericResolver, error) {
	value := resolver.data.GetGeneric()
	return resolver.root.wrapGeneric(value, true, nil)
}

func (resolver *notifierResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *notifierResolver) Jira(ctx context.Context) (*jiraResolver, error) {
	value := resolver.data.GetJira()
	return resolver.root.wrapJira(value, true, nil)
}

func (resolver *notifierResolver) LabelDefault(ctx context.Context) string {
	value := resolver.data.GetLabelDefault()
	return value
}

func (resolver *notifierResolver) LabelKey(ctx context.Context) string {
	value := resolver.data.GetLabelKey()
	return value
}

func (resolver *notifierResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func (resolver *notifierResolver) Pagerduty(ctx context.Context) (*pagerDutyResolver, error) {
	value := resolver.data.GetPagerduty()
	return resolver.root.wrapPagerDuty(value, true, nil)
}

func (resolver *notifierResolver) Splunk(ctx context.Context) (*splunkResolver, error) {
	value := resolver.data.GetSplunk()
	return resolver.root.wrapSplunk(value, true, nil)
}

func (resolver *notifierResolver) Sumologic(ctx context.Context) (*sumoLogicResolver, error) {
	value := resolver.data.GetSumologic()
	return resolver.root.wrapSumoLogic(value, true, nil)
}

func (resolver *notifierResolver) Syslog(ctx context.Context) (*syslogResolver, error) {
	value := resolver.data.GetSyslog()
	return resolver.root.wrapSyslog(value, true, nil)
}

func (resolver *notifierResolver) Type(ctx context.Context) string {
	value := resolver.data.GetType()
	return value
}

func (resolver *notifierResolver) UiEndpoint(ctx context.Context) string {
	value := resolver.data.GetUiEndpoint()
	return value
}

type notifierConfigResolver struct {
	resolver interface{}
}

func (resolver *notifierResolver) Config() *notifierConfigResolver {
	if val := resolver.data.GetJira(); val != nil {
		return &notifierConfigResolver{
			resolver: &jiraResolver{root: resolver.root, data: val},
		}
	}
	if val := resolver.data.GetEmail(); val != nil {
		return &notifierConfigResolver{
			resolver: &emailResolver{root: resolver.root, data: val},
		}
	}
	if val := resolver.data.GetCscc(); val != nil {
		return &notifierConfigResolver{
			resolver: &cSCCResolver{root: resolver.root, data: val},
		}
	}
	if val := resolver.data.GetSplunk(); val != nil {
		return &notifierConfigResolver{
			resolver: &splunkResolver{root: resolver.root, data: val},
		}
	}
	if val := resolver.data.GetPagerduty(); val != nil {
		return &notifierConfigResolver{
			resolver: &pagerDutyResolver{root: resolver.root, data: val},
		}
	}
	if val := resolver.data.GetGeneric(); val != nil {
		return &notifierConfigResolver{
			resolver: &genericResolver{root: resolver.root, data: val},
		}
	}
	if val := resolver.data.GetSumologic(); val != nil {
		return &notifierConfigResolver{
			resolver: &sumoLogicResolver{root: resolver.root, data: val},
		}
	}
	if val := resolver.data.GetAwsSecurityHub(); val != nil {
		return &notifierConfigResolver{
			resolver: &aWSSecurityHubResolver{root: resolver.root, data: val},
		}
	}
	if val := resolver.data.GetSyslog(); val != nil {
		return &notifierConfigResolver{
			resolver: &syslogResolver{root: resolver.root, data: val},
		}
	}
	return nil
}

func (resolver *notifierConfigResolver) ToJira() (*jiraResolver, bool) {
	res, ok := resolver.resolver.(*jiraResolver)
	return res, ok
}

func (resolver *notifierConfigResolver) ToEmail() (*emailResolver, bool) {
	res, ok := resolver.resolver.(*emailResolver)
	return res, ok
}

func (resolver *notifierConfigResolver) ToCSCC() (*cSCCResolver, bool) {
	res, ok := resolver.resolver.(*cSCCResolver)
	return res, ok
}

func (resolver *notifierConfigResolver) ToSplunk() (*splunkResolver, bool) {
	res, ok := resolver.resolver.(*splunkResolver)
	return res, ok
}

func (resolver *notifierConfigResolver) ToPagerDuty() (*pagerDutyResolver, bool) {
	res, ok := resolver.resolver.(*pagerDutyResolver)
	return res, ok
}

func (resolver *notifierConfigResolver) ToGeneric() (*genericResolver, bool) {
	res, ok := resolver.resolver.(*genericResolver)
	return res, ok
}

func (resolver *notifierConfigResolver) ToSumoLogic() (*sumoLogicResolver, bool) {
	res, ok := resolver.resolver.(*sumoLogicResolver)
	return res, ok
}

func (resolver *notifierConfigResolver) ToAWSSecurityHub() (*aWSSecurityHubResolver, bool) {
	res, ok := resolver.resolver.(*aWSSecurityHubResolver)
	return res, ok
}

func (resolver *notifierConfigResolver) ToSyslog() (*syslogResolver, bool) {
	res, ok := resolver.resolver.(*syslogResolver)
	return res, ok
}

type numericalPolicyResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.NumericalPolicy
}

func (resolver *Resolver) wrapNumericalPolicy(value *storage.NumericalPolicy, ok bool, err error) (*numericalPolicyResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &numericalPolicyResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapNumericalPolicies(values []*storage.NumericalPolicy, err error) ([]*numericalPolicyResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*numericalPolicyResolver, len(values))
	for i, v := range values {
		output[i] = &numericalPolicyResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *numericalPolicyResolver) Op(ctx context.Context) string {
	value := resolver.data.GetOp()
	return value.String()
}

func (resolver *numericalPolicyResolver) Value(ctx context.Context) float64 {
	value := resolver.data.GetValue()
	return float64(value)
}

type orchestratorMetadataResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.OrchestratorMetadata
}

func (resolver *Resolver) wrapOrchestratorMetadata(value *storage.OrchestratorMetadata, ok bool, err error) (*orchestratorMetadataResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &orchestratorMetadataResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapOrchestratorMetadatas(values []*storage.OrchestratorMetadata, err error) ([]*orchestratorMetadataResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*orchestratorMetadataResolver, len(values))
	for i, v := range values {
		output[i] = &orchestratorMetadataResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *orchestratorMetadataResolver) ApiVersions(ctx context.Context) []string {
	value := resolver.data.GetApiVersions()
	return value
}

func (resolver *orchestratorMetadataResolver) BuildDate(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetBuildDate()
	return timestamp(value)
}

func (resolver *orchestratorMetadataResolver) Version(ctx context.Context) string {
	value := resolver.data.GetVersion()
	return value
}

type pagerDutyResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.PagerDuty
}

func (resolver *Resolver) wrapPagerDuty(value *storage.PagerDuty, ok bool, err error) (*pagerDutyResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &pagerDutyResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapPagerDuties(values []*storage.PagerDuty, err error) ([]*pagerDutyResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*pagerDutyResolver, len(values))
	for i, v := range values {
		output[i] = &pagerDutyResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *pagerDutyResolver) ApiKey(ctx context.Context) string {
	value := resolver.data.GetApiKey()
	return value
}

func toPermissionLevel(value *string) storage.PermissionLevel {
	if value != nil {
		return storage.PermissionLevel(storage.PermissionLevel_value[*value])
	}
	return storage.PermissionLevel(0)
}

func toPermissionLevels(values *[]string) []storage.PermissionLevel {
	if values == nil {
		return nil
	}
	output := make([]storage.PermissionLevel, len(*values))
	for i, v := range *values {
		output[i] = toPermissionLevel(&v)
	}
	return output
}

type permissionPolicyResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.PermissionPolicy
}

func (resolver *Resolver) wrapPermissionPolicy(value *storage.PermissionPolicy, ok bool, err error) (*permissionPolicyResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &permissionPolicyResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapPermissionPolicies(values []*storage.PermissionPolicy, err error) ([]*permissionPolicyResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*permissionPolicyResolver, len(values))
	for i, v := range values {
		output[i] = &permissionPolicyResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *permissionPolicyResolver) PermissionLevel(ctx context.Context) string {
	value := resolver.data.GetPermissionLevel()
	return value.String()
}

type permissionSetResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.PermissionSet
}

func (resolver *Resolver) wrapPermissionSet(value *storage.PermissionSet, ok bool, err error) (*permissionSetResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &permissionSetResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapPermissionSets(values []*storage.PermissionSet, err error) ([]*permissionSetResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*permissionSetResolver, len(values))
	for i, v := range values {
		output[i] = &permissionSetResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *permissionSetResolver) Description(ctx context.Context) string {
	value := resolver.data.GetDescription()
	return value
}

func (resolver *permissionSetResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *permissionSetResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

type podResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Pod
}

func (resolver *Resolver) wrapPod(value *storage.Pod, ok bool, err error) (*podResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &podResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapPods(values []*storage.Pod, err error) ([]*podResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*podResolver, len(values))
	for i, v := range values {
		output[i] = &podResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *podResolver) ClusterId(ctx context.Context) string {
	value := resolver.data.GetClusterId()
	return value
}

func (resolver *podResolver) DeploymentId(ctx context.Context) string {
	value := resolver.data.GetDeploymentId()
	return value
}

func (resolver *podResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *podResolver) LiveInstances(ctx context.Context) ([]*containerInstanceResolver, error) {
	value := resolver.data.GetLiveInstances()
	return resolver.root.wrapContainerInstances(value, nil)
}

func (resolver *podResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func (resolver *podResolver) Namespace(ctx context.Context) string {
	value := resolver.data.GetNamespace()
	return value
}

func (resolver *podResolver) Started(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetStarted()
	return timestamp(value)
}

func (resolver *podResolver) TerminatedInstances(ctx context.Context) ([]*pod_ContainerInstanceListResolver, error) {
	value := resolver.data.GetTerminatedInstances()
	return resolver.root.wrapPod_ContainerInstanceLists(value, nil)
}

type pod_ContainerInstanceListResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Pod_ContainerInstanceList
}

func (resolver *Resolver) wrapPod_ContainerInstanceList(value *storage.Pod_ContainerInstanceList, ok bool, err error) (*pod_ContainerInstanceListResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &pod_ContainerInstanceListResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapPod_ContainerInstanceLists(values []*storage.Pod_ContainerInstanceList, err error) ([]*pod_ContainerInstanceListResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*pod_ContainerInstanceListResolver, len(values))
	for i, v := range values {
		output[i] = &pod_ContainerInstanceListResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *pod_ContainerInstanceListResolver) Instances(ctx context.Context) ([]*containerInstanceResolver, error) {
	value := resolver.data.GetInstances()
	return resolver.root.wrapContainerInstances(value, nil)
}

type policyResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Policy
}

func (resolver *Resolver) wrapPolicy(value *storage.Policy, ok bool, err error) (*policyResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &policyResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapPolicies(values []*storage.Policy, err error) ([]*policyResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*policyResolver, len(values))
	for i, v := range values {
		output[i] = &policyResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *policyResolver) Categories(ctx context.Context) []string {
	value := resolver.data.GetCategories()
	return value
}

func (resolver *policyResolver) CriteriaLocked(ctx context.Context) bool {
	value := resolver.data.GetCriteriaLocked()
	return value
}

func (resolver *policyResolver) Description(ctx context.Context) string {
	value := resolver.data.GetDescription()
	return value
}

func (resolver *policyResolver) Disabled(ctx context.Context) bool {
	value := resolver.data.GetDisabled()
	return value
}

func (resolver *policyResolver) EnforcementActions(ctx context.Context) []string {
	value := resolver.data.GetEnforcementActions()
	return stringSlice(value)
}

func (resolver *policyResolver) EventSource(ctx context.Context) string {
	value := resolver.data.GetEventSource()
	return value.String()
}

func (resolver *policyResolver) Exclusions(ctx context.Context) ([]*exclusionResolver, error) {
	value := resolver.data.GetExclusions()
	return resolver.root.wrapExclusions(value, nil)
}

func (resolver *policyResolver) Fields(ctx context.Context) (*policyFieldsResolver, error) {
	value := resolver.data.GetFields()
	return resolver.root.wrapPolicyFields(value, true, nil)
}

func (resolver *policyResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *policyResolver) IsDefault(ctx context.Context) bool {
	value := resolver.data.GetIsDefault()
	return value
}

func (resolver *policyResolver) LastUpdated(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetLastUpdated()
	return timestamp(value)
}

func (resolver *policyResolver) LifecycleStages(ctx context.Context) []string {
	value := resolver.data.GetLifecycleStages()
	return stringSlice(value)
}

func (resolver *policyResolver) MitreAttackVectors(ctx context.Context) ([]*policy_MitreAttackVectorsResolver, error) {
	value := resolver.data.GetMitreAttackVectors()
	return resolver.root.wrapPolicy_MitreAttackVectorses(value, nil)
}

func (resolver *policyResolver) MitreVectorsLocked(ctx context.Context) bool {
	value := resolver.data.GetMitreVectorsLocked()
	return value
}

func (resolver *policyResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func (resolver *policyResolver) Notifiers(ctx context.Context) []string {
	value := resolver.data.GetNotifiers()
	return value
}

func (resolver *policyResolver) PolicySections(ctx context.Context) ([]*policySectionResolver, error) {
	value := resolver.data.GetPolicySections()
	return resolver.root.wrapPolicySections(value, nil)
}

func (resolver *policyResolver) PolicyVersion(ctx context.Context) string {
	value := resolver.data.GetPolicyVersion()
	return value
}

func (resolver *policyResolver) Rationale(ctx context.Context) string {
	value := resolver.data.GetRationale()
	return value
}

func (resolver *policyResolver) Remediation(ctx context.Context) string {
	value := resolver.data.GetRemediation()
	return value
}

func (resolver *policyResolver) SORTEnforcement(ctx context.Context) bool {
	value := resolver.data.GetSORTEnforcement()
	return value
}

func (resolver *policyResolver) SORTLifecycleStage(ctx context.Context) string {
	value := resolver.data.GetSORTLifecycleStage()
	return value
}

func (resolver *policyResolver) SORTName(ctx context.Context) string {
	value := resolver.data.GetSORTName()
	return value
}

func (resolver *policyResolver) Scope(ctx context.Context) ([]*scopeResolver, error) {
	value := resolver.data.GetScope()
	return resolver.root.wrapScopes(value, nil)
}

func (resolver *policyResolver) Severity(ctx context.Context) string {
	value := resolver.data.GetSeverity()
	return value.String()
}

type policyFieldsResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.PolicyFields
}

func (resolver *Resolver) wrapPolicyFields(value *storage.PolicyFields, ok bool, err error) (*policyFieldsResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &policyFieldsResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapPolicyFieldses(values []*storage.PolicyFields, err error) ([]*policyFieldsResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*policyFieldsResolver, len(values))
	for i, v := range values {
		output[i] = &policyFieldsResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *policyFieldsResolver) AddCapabilities(ctx context.Context) []string {
	value := resolver.data.GetAddCapabilities()
	return value
}

func (resolver *policyFieldsResolver) Args(ctx context.Context) string {
	value := resolver.data.GetArgs()
	return value
}

func (resolver *policyFieldsResolver) Command(ctx context.Context) string {
	value := resolver.data.GetCommand()
	return value
}

func (resolver *policyFieldsResolver) Component(ctx context.Context) (*componentResolver, error) {
	value := resolver.data.GetComponent()
	return resolver.root.wrapComponent(value, true, nil)
}

func (resolver *policyFieldsResolver) ContainerResourcePolicy(ctx context.Context) (*resourcePolicyResolver, error) {
	value := resolver.data.GetContainerResourcePolicy()
	return resolver.root.wrapResourcePolicy(value, true, nil)
}

func (resolver *policyFieldsResolver) Cve(ctx context.Context) string {
	value := resolver.data.GetCve()
	return value
}

func (resolver *policyFieldsResolver) Cvss(ctx context.Context) (*numericalPolicyResolver, error) {
	value := resolver.data.GetCvss()
	return resolver.root.wrapNumericalPolicy(value, true, nil)
}

func (resolver *policyFieldsResolver) Directory(ctx context.Context) string {
	value := resolver.data.GetDirectory()
	return value
}

func (resolver *policyFieldsResolver) DisallowedAnnotation(ctx context.Context) (*keyValuePolicyResolver, error) {
	value := resolver.data.GetDisallowedAnnotation()
	return resolver.root.wrapKeyValuePolicy(value, true, nil)
}

func (resolver *policyFieldsResolver) DisallowedImageLabel(ctx context.Context) (*keyValuePolicyResolver, error) {
	value := resolver.data.GetDisallowedImageLabel()
	return resolver.root.wrapKeyValuePolicy(value, true, nil)
}

func (resolver *policyFieldsResolver) DropCapabilities(ctx context.Context) []string {
	value := resolver.data.GetDropCapabilities()
	return value
}

func (resolver *policyFieldsResolver) Env(ctx context.Context) (*keyValuePolicyResolver, error) {
	value := resolver.data.GetEnv()
	return resolver.root.wrapKeyValuePolicy(value, true, nil)
}

func (resolver *policyFieldsResolver) FixedBy(ctx context.Context) string {
	value := resolver.data.GetFixedBy()
	return value
}

func (resolver *policyFieldsResolver) HostMountPolicy(ctx context.Context) (*hostMountPolicyResolver, error) {
	value := resolver.data.GetHostMountPolicy()
	return resolver.root.wrapHostMountPolicy(value, true, nil)
}

func (resolver *policyFieldsResolver) ImageName(ctx context.Context) (*imageNamePolicyResolver, error) {
	value := resolver.data.GetImageName()
	return resolver.root.wrapImageNamePolicy(value, true, nil)
}

func (resolver *policyFieldsResolver) LineRule(ctx context.Context) (*dockerfileLineRuleFieldResolver, error) {
	value := resolver.data.GetLineRule()
	return resolver.root.wrapDockerfileLineRuleField(value, true, nil)
}

func (resolver *policyFieldsResolver) PermissionPolicy(ctx context.Context) (*permissionPolicyResolver, error) {
	value := resolver.data.GetPermissionPolicy()
	return resolver.root.wrapPermissionPolicy(value, true, nil)
}

func (resolver *policyFieldsResolver) PortExposurePolicy(ctx context.Context) (*portExposurePolicyResolver, error) {
	value := resolver.data.GetPortExposurePolicy()
	return resolver.root.wrapPortExposurePolicy(value, true, nil)
}

func (resolver *policyFieldsResolver) PortPolicy(ctx context.Context) (*portPolicyResolver, error) {
	value := resolver.data.GetPortPolicy()
	return resolver.root.wrapPortPolicy(value, true, nil)
}

func (resolver *policyFieldsResolver) ProcessPolicy(ctx context.Context) (*processPolicyResolver, error) {
	value := resolver.data.GetProcessPolicy()
	return resolver.root.wrapProcessPolicy(value, true, nil)
}

func (resolver *policyFieldsResolver) RequiredAnnotation(ctx context.Context) (*keyValuePolicyResolver, error) {
	value := resolver.data.GetRequiredAnnotation()
	return resolver.root.wrapKeyValuePolicy(value, true, nil)
}

func (resolver *policyFieldsResolver) RequiredImageLabel(ctx context.Context) (*keyValuePolicyResolver, error) {
	value := resolver.data.GetRequiredImageLabel()
	return resolver.root.wrapKeyValuePolicy(value, true, nil)
}

func (resolver *policyFieldsResolver) RequiredLabel(ctx context.Context) (*keyValuePolicyResolver, error) {
	value := resolver.data.GetRequiredLabel()
	return resolver.root.wrapKeyValuePolicy(value, true, nil)
}

func (resolver *policyFieldsResolver) User(ctx context.Context) string {
	value := resolver.data.GetUser()
	return value
}

func (resolver *policyFieldsResolver) VolumePolicy(ctx context.Context) (*volumePolicyResolver, error) {
	value := resolver.data.GetVolumePolicy()
	return resolver.root.wrapVolumePolicy(value, true, nil)
}

type policyGroupResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.PolicyGroup
}

func (resolver *Resolver) wrapPolicyGroup(value *storage.PolicyGroup, ok bool, err error) (*policyGroupResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &policyGroupResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapPolicyGroups(values []*storage.PolicyGroup, err error) ([]*policyGroupResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*policyGroupResolver, len(values))
	for i, v := range values {
		output[i] = &policyGroupResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *policyGroupResolver) BooleanOperator(ctx context.Context) string {
	value := resolver.data.GetBooleanOperator()
	return value.String()
}

func (resolver *policyGroupResolver) FieldName(ctx context.Context) string {
	value := resolver.data.GetFieldName()
	return value
}

func (resolver *policyGroupResolver) Negate(ctx context.Context) bool {
	value := resolver.data.GetNegate()
	return value
}

func (resolver *policyGroupResolver) Values(ctx context.Context) ([]*policyValueResolver, error) {
	value := resolver.data.GetValues()
	return resolver.root.wrapPolicyValues(value, nil)
}

type policyRuleResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.PolicyRule
}

func (resolver *Resolver) wrapPolicyRule(value *storage.PolicyRule, ok bool, err error) (*policyRuleResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &policyRuleResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapPolicyRules(values []*storage.PolicyRule, err error) ([]*policyRuleResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*policyRuleResolver, len(values))
	for i, v := range values {
		output[i] = &policyRuleResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *policyRuleResolver) ApiGroups(ctx context.Context) []string {
	value := resolver.data.GetApiGroups()
	return value
}

func (resolver *policyRuleResolver) NonResourceUrls(ctx context.Context) []string {
	value := resolver.data.GetNonResourceUrls()
	return value
}

func (resolver *policyRuleResolver) ResourceNames(ctx context.Context) []string {
	value := resolver.data.GetResourceNames()
	return value
}

func (resolver *policyRuleResolver) Resources(ctx context.Context) []string {
	value := resolver.data.GetResources()
	return value
}

func (resolver *policyRuleResolver) Verbs(ctx context.Context) []string {
	value := resolver.data.GetVerbs()
	return value
}

type policySectionResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.PolicySection
}

func (resolver *Resolver) wrapPolicySection(value *storage.PolicySection, ok bool, err error) (*policySectionResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &policySectionResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapPolicySections(values []*storage.PolicySection, err error) ([]*policySectionResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*policySectionResolver, len(values))
	for i, v := range values {
		output[i] = &policySectionResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *policySectionResolver) PolicyGroups(ctx context.Context) ([]*policyGroupResolver, error) {
	value := resolver.data.GetPolicyGroups()
	return resolver.root.wrapPolicyGroups(value, nil)
}

func (resolver *policySectionResolver) SectionName(ctx context.Context) string {
	value := resolver.data.GetSectionName()
	return value
}

type policyValueResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.PolicyValue
}

func (resolver *Resolver) wrapPolicyValue(value *storage.PolicyValue, ok bool, err error) (*policyValueResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &policyValueResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapPolicyValues(values []*storage.PolicyValue, err error) ([]*policyValueResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*policyValueResolver, len(values))
	for i, v := range values {
		output[i] = &policyValueResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *policyValueResolver) Value(ctx context.Context) string {
	value := resolver.data.GetValue()
	return value
}

type policy_MitreAttackVectorsResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Policy_MitreAttackVectors
}

func (resolver *Resolver) wrapPolicy_MitreAttackVectors(value *storage.Policy_MitreAttackVectors, ok bool, err error) (*policy_MitreAttackVectorsResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &policy_MitreAttackVectorsResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapPolicy_MitreAttackVectorses(values []*storage.Policy_MitreAttackVectors, err error) ([]*policy_MitreAttackVectorsResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*policy_MitreAttackVectorsResolver, len(values))
	for i, v := range values {
		output[i] = &policy_MitreAttackVectorsResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *policy_MitreAttackVectorsResolver) Tactic(ctx context.Context) string {
	value := resolver.data.GetTactic()
	return value
}

func (resolver *policy_MitreAttackVectorsResolver) Techniques(ctx context.Context) []string {
	value := resolver.data.GetTechniques()
	return value
}

type portConfigResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.PortConfig
}

func (resolver *Resolver) wrapPortConfig(value *storage.PortConfig, ok bool, err error) (*portConfigResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &portConfigResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapPortConfigs(values []*storage.PortConfig, err error) ([]*portConfigResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*portConfigResolver, len(values))
	for i, v := range values {
		output[i] = &portConfigResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *portConfigResolver) ContainerPort(ctx context.Context) int32 {
	value := resolver.data.GetContainerPort()
	return value
}

func (resolver *portConfigResolver) ExposedPort(ctx context.Context) int32 {
	value := resolver.data.GetExposedPort()
	return value
}

func (resolver *portConfigResolver) Exposure(ctx context.Context) string {
	value := resolver.data.GetExposure()
	return value.String()
}

func (resolver *portConfigResolver) ExposureInfos(ctx context.Context) ([]*portConfig_ExposureInfoResolver, error) {
	value := resolver.data.GetExposureInfos()
	return resolver.root.wrapPortConfig_ExposureInfos(value, nil)
}

func (resolver *portConfigResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func (resolver *portConfigResolver) Protocol(ctx context.Context) string {
	value := resolver.data.GetProtocol()
	return value
}

type portConfig_ExposureInfoResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.PortConfig_ExposureInfo
}

func (resolver *Resolver) wrapPortConfig_ExposureInfo(value *storage.PortConfig_ExposureInfo, ok bool, err error) (*portConfig_ExposureInfoResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &portConfig_ExposureInfoResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapPortConfig_ExposureInfos(values []*storage.PortConfig_ExposureInfo, err error) ([]*portConfig_ExposureInfoResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*portConfig_ExposureInfoResolver, len(values))
	for i, v := range values {
		output[i] = &portConfig_ExposureInfoResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *portConfig_ExposureInfoResolver) ExternalHostnames(ctx context.Context) []string {
	value := resolver.data.GetExternalHostnames()
	return value
}

func (resolver *portConfig_ExposureInfoResolver) ExternalIps(ctx context.Context) []string {
	value := resolver.data.GetExternalIps()
	return value
}

func (resolver *portConfig_ExposureInfoResolver) Level(ctx context.Context) string {
	value := resolver.data.GetLevel()
	return value.String()
}

func (resolver *portConfig_ExposureInfoResolver) NodePort(ctx context.Context) int32 {
	value := resolver.data.GetNodePort()
	return value
}

func (resolver *portConfig_ExposureInfoResolver) ServiceClusterIp(ctx context.Context) string {
	value := resolver.data.GetServiceClusterIp()
	return value
}

func (resolver *portConfig_ExposureInfoResolver) ServiceId(ctx context.Context) string {
	value := resolver.data.GetServiceId()
	return value
}

func (resolver *portConfig_ExposureInfoResolver) ServiceName(ctx context.Context) string {
	value := resolver.data.GetServiceName()
	return value
}

func (resolver *portConfig_ExposureInfoResolver) ServicePort(ctx context.Context) int32 {
	value := resolver.data.GetServicePort()
	return value
}

func toPortConfig_ExposureLevel(value *string) storage.PortConfig_ExposureLevel {
	if value != nil {
		return storage.PortConfig_ExposureLevel(storage.PortConfig_ExposureLevel_value[*value])
	}
	return storage.PortConfig_ExposureLevel(0)
}

func toPortConfig_ExposureLevels(values *[]string) []storage.PortConfig_ExposureLevel {
	if values == nil {
		return nil
	}
	output := make([]storage.PortConfig_ExposureLevel, len(*values))
	for i, v := range *values {
		output[i] = toPortConfig_ExposureLevel(&v)
	}
	return output
}

type portExposurePolicyResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.PortExposurePolicy
}

func (resolver *Resolver) wrapPortExposurePolicy(value *storage.PortExposurePolicy, ok bool, err error) (*portExposurePolicyResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &portExposurePolicyResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapPortExposurePolicies(values []*storage.PortExposurePolicy, err error) ([]*portExposurePolicyResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*portExposurePolicyResolver, len(values))
	for i, v := range values {
		output[i] = &portExposurePolicyResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *portExposurePolicyResolver) ExposureLevels(ctx context.Context) []string {
	value := resolver.data.GetExposureLevels()
	return stringSlice(value)
}

type portPolicyResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.PortPolicy
}

func (resolver *Resolver) wrapPortPolicy(value *storage.PortPolicy, ok bool, err error) (*portPolicyResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &portPolicyResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapPortPolicies(values []*storage.PortPolicy, err error) ([]*portPolicyResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*portPolicyResolver, len(values))
	for i, v := range values {
		output[i] = &portPolicyResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *portPolicyResolver) Port(ctx context.Context) int32 {
	value := resolver.data.GetPort()
	return value
}

func (resolver *portPolicyResolver) Protocol(ctx context.Context) string {
	value := resolver.data.GetProtocol()
	return value
}

type processGroupResolver struct {
	ctx  context.Context
	root *Resolver
	data *v1.ProcessGroup
}

func (resolver *Resolver) wrapProcessGroup(value *v1.ProcessGroup, ok bool, err error) (*processGroupResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &processGroupResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapProcessGroups(values []*v1.ProcessGroup, err error) ([]*processGroupResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*processGroupResolver, len(values))
	for i, v := range values {
		output[i] = &processGroupResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *processGroupResolver) Args(ctx context.Context) string {
	value := resolver.data.GetArgs()
	return value
}

func (resolver *processGroupResolver) Signals(ctx context.Context) ([]*processIndicatorResolver, error) {
	value := resolver.data.GetSignals()
	return resolver.root.wrapProcessIndicators(value, nil)
}

type processIndicatorResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ProcessIndicator
}

func (resolver *Resolver) wrapProcessIndicator(value *storage.ProcessIndicator, ok bool, err error) (*processIndicatorResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &processIndicatorResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapProcessIndicators(values []*storage.ProcessIndicator, err error) ([]*processIndicatorResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*processIndicatorResolver, len(values))
	for i, v := range values {
		output[i] = &processIndicatorResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *processIndicatorResolver) ClusterId(ctx context.Context) string {
	value := resolver.data.GetClusterId()
	return value
}

func (resolver *processIndicatorResolver) ContainerName(ctx context.Context) string {
	value := resolver.data.GetContainerName()
	return value
}

func (resolver *processIndicatorResolver) ContainerStartTime(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetContainerStartTime()
	return timestamp(value)
}

func (resolver *processIndicatorResolver) DeploymentId(ctx context.Context) string {
	value := resolver.data.GetDeploymentId()
	return value
}

func (resolver *processIndicatorResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *processIndicatorResolver) ImageId(ctx context.Context) string {
	value := resolver.data.GetImageId()
	return value
}

func (resolver *processIndicatorResolver) Namespace(ctx context.Context) string {
	value := resolver.data.GetNamespace()
	return value
}

func (resolver *processIndicatorResolver) PodId(ctx context.Context) string {
	value := resolver.data.GetPodId()
	return value
}

func (resolver *processIndicatorResolver) PodUid(ctx context.Context) string {
	value := resolver.data.GetPodUid()
	return value
}

func (resolver *processIndicatorResolver) Signal(ctx context.Context) (*processSignalResolver, error) {
	value := resolver.data.GetSignal()
	return resolver.root.wrapProcessSignal(value, true, nil)
}

type processNameGroupResolver struct {
	ctx  context.Context
	root *Resolver
	data *v1.ProcessNameGroup
}

func (resolver *Resolver) wrapProcessNameGroup(value *v1.ProcessNameGroup, ok bool, err error) (*processNameGroupResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &processNameGroupResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapProcessNameGroups(values []*v1.ProcessNameGroup, err error) ([]*processNameGroupResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*processNameGroupResolver, len(values))
	for i, v := range values {
		output[i] = &processNameGroupResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *processNameGroupResolver) Groups(ctx context.Context) ([]*processGroupResolver, error) {
	value := resolver.data.GetGroups()
	return resolver.root.wrapProcessGroups(value, nil)
}

func (resolver *processNameGroupResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func (resolver *processNameGroupResolver) TimesExecuted(ctx context.Context) int32 {
	value := resolver.data.GetTimesExecuted()
	return int32(value)
}

type processPolicyResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ProcessPolicy
}

func (resolver *Resolver) wrapProcessPolicy(value *storage.ProcessPolicy, ok bool, err error) (*processPolicyResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &processPolicyResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapProcessPolicies(values []*storage.ProcessPolicy, err error) ([]*processPolicyResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*processPolicyResolver, len(values))
	for i, v := range values {
		output[i] = &processPolicyResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *processPolicyResolver) Ancestor(ctx context.Context) string {
	value := resolver.data.GetAncestor()
	return value
}

func (resolver *processPolicyResolver) Args(ctx context.Context) string {
	value := resolver.data.GetArgs()
	return value
}

func (resolver *processPolicyResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func (resolver *processPolicyResolver) Uid(ctx context.Context) string {
	value := resolver.data.GetUid()
	return value
}

type processSignalResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ProcessSignal
}

func (resolver *Resolver) wrapProcessSignal(value *storage.ProcessSignal, ok bool, err error) (*processSignalResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &processSignalResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapProcessSignals(values []*storage.ProcessSignal, err error) ([]*processSignalResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*processSignalResolver, len(values))
	for i, v := range values {
		output[i] = &processSignalResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *processSignalResolver) Args(ctx context.Context) string {
	value := resolver.data.GetArgs()
	return value
}

func (resolver *processSignalResolver) ContainerId(ctx context.Context) string {
	value := resolver.data.GetContainerId()
	return value
}

func (resolver *processSignalResolver) ExecFilePath(ctx context.Context) string {
	value := resolver.data.GetExecFilePath()
	return value
}

func (resolver *processSignalResolver) Gid(ctx context.Context) int32 {
	value := resolver.data.GetGid()
	return int32(value)
}

func (resolver *processSignalResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *processSignalResolver) Lineage(ctx context.Context) []string {
	value := resolver.data.GetLineage()
	return value
}

func (resolver *processSignalResolver) LineageInfo(ctx context.Context) ([]*processSignal_LineageInfoResolver, error) {
	value := resolver.data.GetLineageInfo()
	return resolver.root.wrapProcessSignal_LineageInfos(value, nil)
}

func (resolver *processSignalResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func (resolver *processSignalResolver) Pid(ctx context.Context) int32 {
	value := resolver.data.GetPid()
	return int32(value)
}

func (resolver *processSignalResolver) Scraped(ctx context.Context) bool {
	value := resolver.data.GetScraped()
	return value
}

func (resolver *processSignalResolver) Time(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetTime()
	return timestamp(value)
}

func (resolver *processSignalResolver) Uid(ctx context.Context) int32 {
	value := resolver.data.GetUid()
	return int32(value)
}

type processSignal_LineageInfoResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ProcessSignal_LineageInfo
}

func (resolver *Resolver) wrapProcessSignal_LineageInfo(value *storage.ProcessSignal_LineageInfo, ok bool, err error) (*processSignal_LineageInfoResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &processSignal_LineageInfoResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapProcessSignal_LineageInfos(values []*storage.ProcessSignal_LineageInfo, err error) ([]*processSignal_LineageInfoResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*processSignal_LineageInfoResolver, len(values))
	for i, v := range values {
		output[i] = &processSignal_LineageInfoResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *processSignal_LineageInfoResolver) ParentExecFilePath(ctx context.Context) string {
	value := resolver.data.GetParentExecFilePath()
	return value
}

func (resolver *processSignal_LineageInfoResolver) ParentUid(ctx context.Context) int32 {
	value := resolver.data.GetParentUid()
	return int32(value)
}

type providerMetadataResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ProviderMetadata
}

func (resolver *Resolver) wrapProviderMetadata(value *storage.ProviderMetadata, ok bool, err error) (*providerMetadataResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &providerMetadataResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapProviderMetadatas(values []*storage.ProviderMetadata, err error) ([]*providerMetadataResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*providerMetadataResolver, len(values))
	for i, v := range values {
		output[i] = &providerMetadataResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *providerMetadataResolver) Aws(ctx context.Context) (*aWSProviderMetadataResolver, error) {
	value := resolver.data.GetAws()
	return resolver.root.wrapAWSProviderMetadata(value, true, nil)
}

func (resolver *providerMetadataResolver) Azure(ctx context.Context) (*azureProviderMetadataResolver, error) {
	value := resolver.data.GetAzure()
	return resolver.root.wrapAzureProviderMetadata(value, true, nil)
}

func (resolver *providerMetadataResolver) Google(ctx context.Context) (*googleProviderMetadataResolver, error) {
	value := resolver.data.GetGoogle()
	return resolver.root.wrapGoogleProviderMetadata(value, true, nil)
}

func (resolver *providerMetadataResolver) Region(ctx context.Context) string {
	value := resolver.data.GetRegion()
	return value
}

func (resolver *providerMetadataResolver) Verified(ctx context.Context) bool {
	value := resolver.data.GetVerified()
	return value
}

func (resolver *providerMetadataResolver) Zone(ctx context.Context) string {
	value := resolver.data.GetZone()
	return value
}

type providerMetadataProviderResolver struct {
	resolver interface{}
}

func (resolver *providerMetadataResolver) Provider() *providerMetadataProviderResolver {
	if val := resolver.data.GetGoogle(); val != nil {
		return &providerMetadataProviderResolver{
			resolver: &googleProviderMetadataResolver{root: resolver.root, data: val},
		}
	}
	if val := resolver.data.GetAws(); val != nil {
		return &providerMetadataProviderResolver{
			resolver: &aWSProviderMetadataResolver{root: resolver.root, data: val},
		}
	}
	if val := resolver.data.GetAzure(); val != nil {
		return &providerMetadataProviderResolver{
			resolver: &azureProviderMetadataResolver{root: resolver.root, data: val},
		}
	}
	return nil
}

func (resolver *providerMetadataProviderResolver) ToGoogleProviderMetadata() (*googleProviderMetadataResolver, bool) {
	res, ok := resolver.resolver.(*googleProviderMetadataResolver)
	return res, ok
}

func (resolver *providerMetadataProviderResolver) ToAWSProviderMetadata() (*aWSProviderMetadataResolver, bool) {
	res, ok := resolver.resolver.(*aWSProviderMetadataResolver)
	return res, ok
}

func (resolver *providerMetadataProviderResolver) ToAzureProviderMetadata() (*azureProviderMetadataResolver, bool) {
	res, ok := resolver.resolver.(*azureProviderMetadataResolver)
	return res, ok
}

type readinessProbeResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ReadinessProbe
}

func (resolver *Resolver) wrapReadinessProbe(value *storage.ReadinessProbe, ok bool, err error) (*readinessProbeResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &readinessProbeResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapReadinessProbes(values []*storage.ReadinessProbe, err error) ([]*readinessProbeResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*readinessProbeResolver, len(values))
	for i, v := range values {
		output[i] = &readinessProbeResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *readinessProbeResolver) Defined(ctx context.Context) bool {
	value := resolver.data.GetDefined()
	return value
}

type requestCommentResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.RequestComment
}

func (resolver *Resolver) wrapRequestComment(value *storage.RequestComment, ok bool, err error) (*requestCommentResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &requestCommentResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapRequestComments(values []*storage.RequestComment, err error) ([]*requestCommentResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*requestCommentResolver, len(values))
	for i, v := range values {
		output[i] = &requestCommentResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *requestCommentResolver) CreatedAt(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetCreatedAt()
	return timestamp(value)
}

func (resolver *requestCommentResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *requestCommentResolver) Message(ctx context.Context) string {
	value := resolver.data.GetMessage()
	return value
}

func (resolver *requestCommentResolver) User(ctx context.Context) (*slimUserResolver, error) {
	value := resolver.data.GetUser()
	return resolver.root.wrapSlimUser(value, true, nil)
}

type resourcePolicyResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ResourcePolicy
}

func (resolver *Resolver) wrapResourcePolicy(value *storage.ResourcePolicy, ok bool, err error) (*resourcePolicyResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &resourcePolicyResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapResourcePolicies(values []*storage.ResourcePolicy, err error) ([]*resourcePolicyResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*resourcePolicyResolver, len(values))
	for i, v := range values {
		output[i] = &resourcePolicyResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *resourcePolicyResolver) CpuResourceLimit(ctx context.Context) (*numericalPolicyResolver, error) {
	value := resolver.data.GetCpuResourceLimit()
	return resolver.root.wrapNumericalPolicy(value, true, nil)
}

func (resolver *resourcePolicyResolver) CpuResourceRequest(ctx context.Context) (*numericalPolicyResolver, error) {
	value := resolver.data.GetCpuResourceRequest()
	return resolver.root.wrapNumericalPolicy(value, true, nil)
}

func (resolver *resourcePolicyResolver) MemoryResourceLimit(ctx context.Context) (*numericalPolicyResolver, error) {
	value := resolver.data.GetMemoryResourceLimit()
	return resolver.root.wrapNumericalPolicy(value, true, nil)
}

func (resolver *resourcePolicyResolver) MemoryResourceRequest(ctx context.Context) (*numericalPolicyResolver, error) {
	value := resolver.data.GetMemoryResourceRequest()
	return resolver.root.wrapNumericalPolicy(value, true, nil)
}

func toResourceType(value *string) storage.ResourceType {
	if value != nil {
		return storage.ResourceType(storage.ResourceType_value[*value])
	}
	return storage.ResourceType(0)
}

func toResourceTypes(values *[]string) []storage.ResourceType {
	if values == nil {
		return nil
	}
	output := make([]storage.ResourceType, len(*values))
	for i, v := range *values {
		output[i] = toResourceType(&v)
	}
	return output
}

type resourcesResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Resources
}

func (resolver *Resolver) wrapResources(value *storage.Resources, ok bool, err error) (*resourcesResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &resourcesResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapResourceses(values []*storage.Resources, err error) ([]*resourcesResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*resourcesResolver, len(values))
	for i, v := range values {
		output[i] = &resourcesResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *resourcesResolver) CpuCoresLimit(ctx context.Context) float64 {
	value := resolver.data.GetCpuCoresLimit()
	return float64(value)
}

func (resolver *resourcesResolver) CpuCoresRequest(ctx context.Context) float64 {
	value := resolver.data.GetCpuCoresRequest()
	return float64(value)
}

func (resolver *resourcesResolver) MemoryMbLimit(ctx context.Context) float64 {
	value := resolver.data.GetMemoryMbLimit()
	return float64(value)
}

func (resolver *resourcesResolver) MemoryMbRequest(ctx context.Context) float64 {
	value := resolver.data.GetMemoryMbRequest()
	return float64(value)
}

type riskResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Risk
}

func (resolver *Resolver) wrapRisk(value *storage.Risk, ok bool, err error) (*riskResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &riskResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapRisks(values []*storage.Risk, err error) ([]*riskResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*riskResolver, len(values))
	for i, v := range values {
		output[i] = &riskResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *riskResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *riskResolver) Results(ctx context.Context) ([]*risk_ResultResolver, error) {
	value := resolver.data.GetResults()
	return resolver.root.wrapRisk_Results(value, nil)
}

func (resolver *riskResolver) Score(ctx context.Context) float64 {
	value := resolver.data.GetScore()
	return float64(value)
}

func (resolver *riskResolver) Subject(ctx context.Context) (*riskSubjectResolver, error) {
	value := resolver.data.GetSubject()
	return resolver.root.wrapRiskSubject(value, true, nil)
}

type riskSubjectResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.RiskSubject
}

func (resolver *Resolver) wrapRiskSubject(value *storage.RiskSubject, ok bool, err error) (*riskSubjectResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &riskSubjectResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapRiskSubjects(values []*storage.RiskSubject, err error) ([]*riskSubjectResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*riskSubjectResolver, len(values))
	for i, v := range values {
		output[i] = &riskSubjectResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *riskSubjectResolver) ClusterId(ctx context.Context) string {
	value := resolver.data.GetClusterId()
	return value
}

func (resolver *riskSubjectResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *riskSubjectResolver) Namespace(ctx context.Context) string {
	value := resolver.data.GetNamespace()
	return value
}

func (resolver *riskSubjectResolver) Type(ctx context.Context) string {
	value := resolver.data.GetType()
	return value.String()
}

func toRiskSubjectType(value *string) storage.RiskSubjectType {
	if value != nil {
		return storage.RiskSubjectType(storage.RiskSubjectType_value[*value])
	}
	return storage.RiskSubjectType(0)
}

func toRiskSubjectTypes(values *[]string) []storage.RiskSubjectType {
	if values == nil {
		return nil
	}
	output := make([]storage.RiskSubjectType, len(*values))
	for i, v := range *values {
		output[i] = toRiskSubjectType(&v)
	}
	return output
}

type risk_ResultResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Risk_Result
}

func (resolver *Resolver) wrapRisk_Result(value *storage.Risk_Result, ok bool, err error) (*risk_ResultResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &risk_ResultResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapRisk_Results(values []*storage.Risk_Result, err error) ([]*risk_ResultResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*risk_ResultResolver, len(values))
	for i, v := range values {
		output[i] = &risk_ResultResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *risk_ResultResolver) Factors(ctx context.Context) ([]*risk_Result_FactorResolver, error) {
	value := resolver.data.GetFactors()
	return resolver.root.wrapRisk_Result_Factors(value, nil)
}

func (resolver *risk_ResultResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func (resolver *risk_ResultResolver) Score(ctx context.Context) float64 {
	value := resolver.data.GetScore()
	return float64(value)
}

type risk_Result_FactorResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Risk_Result_Factor
}

func (resolver *Resolver) wrapRisk_Result_Factor(value *storage.Risk_Result_Factor, ok bool, err error) (*risk_Result_FactorResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &risk_Result_FactorResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapRisk_Result_Factors(values []*storage.Risk_Result_Factor, err error) ([]*risk_Result_FactorResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*risk_Result_FactorResolver, len(values))
	for i, v := range values {
		output[i] = &risk_Result_FactorResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *risk_Result_FactorResolver) Message(ctx context.Context) string {
	value := resolver.data.GetMessage()
	return value
}

func (resolver *risk_Result_FactorResolver) Url(ctx context.Context) string {
	value := resolver.data.GetUrl()
	return value
}

type roleResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Role
}

func (resolver *Resolver) wrapRole(value *storage.Role, ok bool, err error) (*roleResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &roleResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapRoles(values []*storage.Role, err error) ([]*roleResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*roleResolver, len(values))
	for i, v := range values {
		output[i] = &roleResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *roleResolver) AccessScopeId(ctx context.Context) string {
	value := resolver.data.GetAccessScopeId()
	return value
}

func (resolver *roleResolver) Description(ctx context.Context) string {
	value := resolver.data.GetDescription()
	return value
}

func (resolver *roleResolver) GlobalAccess(ctx context.Context) string {
	value := resolver.data.GetGlobalAccess()
	return value.String()
}

func (resolver *roleResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func (resolver *roleResolver) PermissionSetId(ctx context.Context) string {
	value := resolver.data.GetPermissionSetId()
	return value
}

type scopeResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Scope
}

func (resolver *Resolver) wrapScope(value *storage.Scope, ok bool, err error) (*scopeResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &scopeResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapScopes(values []*storage.Scope, err error) ([]*scopeResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*scopeResolver, len(values))
	for i, v := range values {
		output[i] = &scopeResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *scopeResolver) Cluster(ctx context.Context) string {
	value := resolver.data.GetCluster()
	return value
}

func (resolver *scopeResolver) Label(ctx context.Context) (*scope_LabelResolver, error) {
	value := resolver.data.GetLabel()
	return resolver.root.wrapScope_Label(value, true, nil)
}

func (resolver *scopeResolver) Namespace(ctx context.Context) string {
	value := resolver.data.GetNamespace()
	return value
}

type scope_LabelResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Scope_Label
}

func (resolver *Resolver) wrapScope_Label(value *storage.Scope_Label, ok bool, err error) (*scope_LabelResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &scope_LabelResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapScope_Labels(values []*storage.Scope_Label, err error) ([]*scope_LabelResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*scope_LabelResolver, len(values))
	for i, v := range values {
		output[i] = &scope_LabelResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *scope_LabelResolver) Key(ctx context.Context) string {
	value := resolver.data.GetKey()
	return value
}

func (resolver *scope_LabelResolver) Value(ctx context.Context) string {
	value := resolver.data.GetValue()
	return value
}

func toSearchCategory(value *string) v1.SearchCategory {
	if value != nil {
		return v1.SearchCategory(v1.SearchCategory_value[*value])
	}
	return v1.SearchCategory(0)
}

func toSearchCategories(values *[]string) []v1.SearchCategory {
	if values == nil {
		return nil
	}
	output := make([]v1.SearchCategory, len(*values))
	for i, v := range *values {
		output[i] = toSearchCategory(&v)
	}
	return output
}

type searchResultResolver struct {
	ctx  context.Context
	root *Resolver
	data *v1.SearchResult
}

func (resolver *Resolver) wrapSearchResult(value *v1.SearchResult, ok bool, err error) (*searchResultResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &searchResultResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapSearchResults(values []*v1.SearchResult, err error) ([]*searchResultResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*searchResultResolver, len(values))
	for i, v := range values {
		output[i] = &searchResultResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *searchResultResolver) Category(ctx context.Context) string {
	value := resolver.data.GetCategory()
	return value.String()
}

func (resolver *searchResultResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *searchResultResolver) Location(ctx context.Context) string {
	value := resolver.data.GetLocation()
	return value
}

func (resolver *searchResultResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func (resolver *searchResultResolver) Score(ctx context.Context) float64 {
	value := resolver.data.GetScore()
	return value
}

type secretResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Secret
	list *storage.ListSecret
}

func (resolver *Resolver) wrapSecret(value *storage.Secret, ok bool, err error) (*secretResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &secretResolver{root: resolver, data: value, list: nil}, nil
}

func (resolver *Resolver) wrapSecrets(values []*storage.Secret, err error) ([]*secretResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*secretResolver, len(values))
	for i, v := range values {
		output[i] = &secretResolver{root: resolver, data: v, list: nil}
	}
	return output, nil
}

func (resolver *Resolver) wrapListSecrets(values []*storage.ListSecret, err error) ([]*secretResolver, error) {
	if err != nil || values == nil {
		return nil, err
	}
	output := make([]*secretResolver, len(values))
	for i, v := range values {
		output[i] = &secretResolver{root: resolver, data: nil, list: v}
	}
	return output, nil
}

func (resolver *secretResolver) ensureData(ctx context.Context) {
	if resolver.data == nil {
		resolver.data = resolver.root.getSecret(ctx, resolver.list.GetId())
	}
}

func (resolver *secretResolver) Annotations(ctx context.Context) labels {
	resolver.ensureData(ctx)
	value := resolver.data.GetAnnotations()
	return labelsResolver(value)
}

func (resolver *secretResolver) ClusterId(ctx context.Context) string {
	resolver.ensureData(ctx)
	value := resolver.data.GetClusterId()
	return value
}

func (resolver *secretResolver) ClusterName(ctx context.Context) string {
	value := resolver.data.GetClusterName()
	if resolver.data == nil {
		value = resolver.list.GetClusterName()
	}
	return value
}

func (resolver *secretResolver) CreatedAt(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetCreatedAt()
	if resolver.data == nil {
		value = resolver.list.GetCreatedAt()
	}
	return timestamp(value)
}

func (resolver *secretResolver) Files(ctx context.Context) ([]*secretDataFileResolver, error) {
	resolver.ensureData(ctx)
	value := resolver.data.GetFiles()
	return resolver.root.wrapSecretDataFiles(value, nil)
}

func (resolver *secretResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	if resolver.data == nil {
		value = resolver.list.GetId()
	}
	return graphql.ID(value)
}

func (resolver *secretResolver) Labels(ctx context.Context) labels {
	resolver.ensureData(ctx)
	value := resolver.data.GetLabels()
	return labelsResolver(value)
}

func (resolver *secretResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	if resolver.data == nil {
		value = resolver.list.GetName()
	}
	return value
}

func (resolver *secretResolver) Namespace(ctx context.Context) string {
	value := resolver.data.GetNamespace()
	if resolver.data == nil {
		value = resolver.list.GetNamespace()
	}
	return value
}

func (resolver *secretResolver) Relationship(ctx context.Context) (*secretRelationshipResolver, error) {
	resolver.ensureData(ctx)
	value := resolver.data.GetRelationship()
	return resolver.root.wrapSecretRelationship(value, true, nil)
}

func (resolver *secretResolver) Type(ctx context.Context) string {
	resolver.ensureData(ctx)
	value := resolver.data.GetType()
	return value
}

type secretContainerRelationshipResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.SecretContainerRelationship
}

func (resolver *Resolver) wrapSecretContainerRelationship(value *storage.SecretContainerRelationship, ok bool, err error) (*secretContainerRelationshipResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &secretContainerRelationshipResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapSecretContainerRelationships(values []*storage.SecretContainerRelationship, err error) ([]*secretContainerRelationshipResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*secretContainerRelationshipResolver, len(values))
	for i, v := range values {
		output[i] = &secretContainerRelationshipResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *secretContainerRelationshipResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *secretContainerRelationshipResolver) Path(ctx context.Context) string {
	value := resolver.data.GetPath()
	return value
}

type secretDataFileResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.SecretDataFile
}

func (resolver *Resolver) wrapSecretDataFile(value *storage.SecretDataFile, ok bool, err error) (*secretDataFileResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &secretDataFileResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapSecretDataFiles(values []*storage.SecretDataFile, err error) ([]*secretDataFileResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*secretDataFileResolver, len(values))
	for i, v := range values {
		output[i] = &secretDataFileResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *secretDataFileResolver) Cert(ctx context.Context) (*certResolver, error) {
	value := resolver.data.GetCert()
	return resolver.root.wrapCert(value, true, nil)
}

func (resolver *secretDataFileResolver) ImagePullSecret(ctx context.Context) (*imagePullSecretResolver, error) {
	value := resolver.data.GetImagePullSecret()
	return resolver.root.wrapImagePullSecret(value, true, nil)
}

func (resolver *secretDataFileResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func (resolver *secretDataFileResolver) Type(ctx context.Context) string {
	value := resolver.data.GetType()
	return value.String()
}

type secretDataFileMetadataResolver struct {
	resolver interface{}
}

func (resolver *secretDataFileResolver) Metadata() *secretDataFileMetadataResolver {
	if val := resolver.data.GetCert(); val != nil {
		return &secretDataFileMetadataResolver{
			resolver: &certResolver{root: resolver.root, data: val},
		}
	}
	if val := resolver.data.GetImagePullSecret(); val != nil {
		return &secretDataFileMetadataResolver{
			resolver: &imagePullSecretResolver{root: resolver.root, data: val},
		}
	}
	return nil
}

func (resolver *secretDataFileMetadataResolver) ToCert() (*certResolver, bool) {
	res, ok := resolver.resolver.(*certResolver)
	return res, ok
}

func (resolver *secretDataFileMetadataResolver) ToImagePullSecret() (*imagePullSecretResolver, bool) {
	res, ok := resolver.resolver.(*imagePullSecretResolver)
	return res, ok
}

type secretDeploymentRelationshipResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.SecretDeploymentRelationship
}

func (resolver *Resolver) wrapSecretDeploymentRelationship(value *storage.SecretDeploymentRelationship, ok bool, err error) (*secretDeploymentRelationshipResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &secretDeploymentRelationshipResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapSecretDeploymentRelationships(values []*storage.SecretDeploymentRelationship, err error) ([]*secretDeploymentRelationshipResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*secretDeploymentRelationshipResolver, len(values))
	for i, v := range values {
		output[i] = &secretDeploymentRelationshipResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *secretDeploymentRelationshipResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *secretDeploymentRelationshipResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

type secretRelationshipResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.SecretRelationship
}

func (resolver *Resolver) wrapSecretRelationship(value *storage.SecretRelationship, ok bool, err error) (*secretRelationshipResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &secretRelationshipResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapSecretRelationships(values []*storage.SecretRelationship, err error) ([]*secretRelationshipResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*secretRelationshipResolver, len(values))
	for i, v := range values {
		output[i] = &secretRelationshipResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *secretRelationshipResolver) ContainerRelationships(ctx context.Context) ([]*secretContainerRelationshipResolver, error) {
	value := resolver.data.GetContainerRelationships()
	return resolver.root.wrapSecretContainerRelationships(value, nil)
}

func (resolver *secretRelationshipResolver) DeploymentRelationships(ctx context.Context) ([]*secretDeploymentRelationshipResolver, error) {
	value := resolver.data.GetDeploymentRelationships()
	return resolver.root.wrapSecretDeploymentRelationships(value, nil)
}

func (resolver *secretRelationshipResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func toSecretType(value *string) storage.SecretType {
	if value != nil {
		return storage.SecretType(storage.SecretType_value[*value])
	}
	return storage.SecretType(0)
}

func toSecretTypes(values *[]string) []storage.SecretType {
	if values == nil {
		return nil
	}
	output := make([]storage.SecretType, len(*values))
	for i, v := range *values {
		output[i] = toSecretType(&v)
	}
	return output
}

type securityContextResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.SecurityContext
}

func (resolver *Resolver) wrapSecurityContext(value *storage.SecurityContext, ok bool, err error) (*securityContextResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &securityContextResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapSecurityContexts(values []*storage.SecurityContext, err error) ([]*securityContextResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*securityContextResolver, len(values))
	for i, v := range values {
		output[i] = &securityContextResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *securityContextResolver) AddCapabilities(ctx context.Context) []string {
	value := resolver.data.GetAddCapabilities()
	return value
}

func (resolver *securityContextResolver) DropCapabilities(ctx context.Context) []string {
	value := resolver.data.GetDropCapabilities()
	return value
}

func (resolver *securityContextResolver) Privileged(ctx context.Context) bool {
	value := resolver.data.GetPrivileged()
	return value
}

func (resolver *securityContextResolver) ReadOnlyRootFilesystem(ctx context.Context) bool {
	value := resolver.data.GetReadOnlyRootFilesystem()
	return value
}

func (resolver *securityContextResolver) SeccompProfile(ctx context.Context) (*securityContext_SeccompProfileResolver, error) {
	value := resolver.data.GetSeccompProfile()
	return resolver.root.wrapSecurityContext_SeccompProfile(value, true, nil)
}

func (resolver *securityContextResolver) Selinux(ctx context.Context) (*securityContext_SELinuxResolver, error) {
	value := resolver.data.GetSelinux()
	return resolver.root.wrapSecurityContext_SELinux(value, true, nil)
}

type securityContext_SELinuxResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.SecurityContext_SELinux
}

func (resolver *Resolver) wrapSecurityContext_SELinux(value *storage.SecurityContext_SELinux, ok bool, err error) (*securityContext_SELinuxResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &securityContext_SELinuxResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapSecurityContext_SELinuxs(values []*storage.SecurityContext_SELinux, err error) ([]*securityContext_SELinuxResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*securityContext_SELinuxResolver, len(values))
	for i, v := range values {
		output[i] = &securityContext_SELinuxResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *securityContext_SELinuxResolver) Level(ctx context.Context) string {
	value := resolver.data.GetLevel()
	return value
}

func (resolver *securityContext_SELinuxResolver) Role(ctx context.Context) string {
	value := resolver.data.GetRole()
	return value
}

func (resolver *securityContext_SELinuxResolver) Type(ctx context.Context) string {
	value := resolver.data.GetType()
	return value
}

func (resolver *securityContext_SELinuxResolver) User(ctx context.Context) string {
	value := resolver.data.GetUser()
	return value
}

type securityContext_SeccompProfileResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.SecurityContext_SeccompProfile
}

func (resolver *Resolver) wrapSecurityContext_SeccompProfile(value *storage.SecurityContext_SeccompProfile, ok bool, err error) (*securityContext_SeccompProfileResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &securityContext_SeccompProfileResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapSecurityContext_SeccompProfiles(values []*storage.SecurityContext_SeccompProfile, err error) ([]*securityContext_SeccompProfileResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*securityContext_SeccompProfileResolver, len(values))
	for i, v := range values {
		output[i] = &securityContext_SeccompProfileResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *securityContext_SeccompProfileResolver) LocalhostProfile(ctx context.Context) string {
	value := resolver.data.GetLocalhostProfile()
	return value
}

func (resolver *securityContext_SeccompProfileResolver) Type(ctx context.Context) string {
	value := resolver.data.GetType()
	return value.String()
}

func toSecurityContext_SeccompProfile_ProfileType(value *string) storage.SecurityContext_SeccompProfile_ProfileType {
	if value != nil {
		return storage.SecurityContext_SeccompProfile_ProfileType(storage.SecurityContext_SeccompProfile_ProfileType_value[*value])
	}
	return storage.SecurityContext_SeccompProfile_ProfileType(0)
}

func toSecurityContext_SeccompProfile_ProfileTypes(values *[]string) []storage.SecurityContext_SeccompProfile_ProfileType {
	if values == nil {
		return nil
	}
	output := make([]storage.SecurityContext_SeccompProfile_ProfileType, len(*values))
	for i, v := range *values {
		output[i] = toSecurityContext_SeccompProfile_ProfileType(&v)
	}
	return output
}

type sensorDeploymentIdentificationResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.SensorDeploymentIdentification
}

func (resolver *Resolver) wrapSensorDeploymentIdentification(value *storage.SensorDeploymentIdentification, ok bool, err error) (*sensorDeploymentIdentificationResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &sensorDeploymentIdentificationResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapSensorDeploymentIdentifications(values []*storage.SensorDeploymentIdentification, err error) ([]*sensorDeploymentIdentificationResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*sensorDeploymentIdentificationResolver, len(values))
	for i, v := range values {
		output[i] = &sensorDeploymentIdentificationResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *sensorDeploymentIdentificationResolver) AppNamespace(ctx context.Context) string {
	value := resolver.data.GetAppNamespace()
	return value
}

func (resolver *sensorDeploymentIdentificationResolver) AppNamespaceId(ctx context.Context) string {
	value := resolver.data.GetAppNamespaceId()
	return value
}

func (resolver *sensorDeploymentIdentificationResolver) AppServiceaccountId(ctx context.Context) string {
	value := resolver.data.GetAppServiceaccountId()
	return value
}

func (resolver *sensorDeploymentIdentificationResolver) DefaultNamespaceId(ctx context.Context) string {
	value := resolver.data.GetDefaultNamespaceId()
	return value
}

func (resolver *sensorDeploymentIdentificationResolver) K8SNodeName(ctx context.Context) string {
	value := resolver.data.GetK8SNodeName()
	return value
}

func (resolver *sensorDeploymentIdentificationResolver) SystemNamespaceId(ctx context.Context) string {
	value := resolver.data.GetSystemNamespaceId()
	return value
}

type serviceAccountResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.ServiceAccount
}

func (resolver *Resolver) wrapServiceAccount(value *storage.ServiceAccount, ok bool, err error) (*serviceAccountResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &serviceAccountResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapServiceAccounts(values []*storage.ServiceAccount, err error) ([]*serviceAccountResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*serviceAccountResolver, len(values))
	for i, v := range values {
		output[i] = &serviceAccountResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *serviceAccountResolver) Annotations(ctx context.Context) labels {
	value := resolver.data.GetAnnotations()
	return labelsResolver(value)
}

func (resolver *serviceAccountResolver) AutomountToken(ctx context.Context) bool {
	value := resolver.data.GetAutomountToken()
	return value
}

func (resolver *serviceAccountResolver) ClusterId(ctx context.Context) string {
	value := resolver.data.GetClusterId()
	return value
}

func (resolver *serviceAccountResolver) ClusterName(ctx context.Context) string {
	value := resolver.data.GetClusterName()
	return value
}

func (resolver *serviceAccountResolver) CreatedAt(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetCreatedAt()
	return timestamp(value)
}

func (resolver *serviceAccountResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *serviceAccountResolver) ImagePullSecrets(ctx context.Context) []string {
	value := resolver.data.GetImagePullSecrets()
	return value
}

func (resolver *serviceAccountResolver) Labels(ctx context.Context) labels {
	value := resolver.data.GetLabels()
	return labelsResolver(value)
}

func (resolver *serviceAccountResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func (resolver *serviceAccountResolver) Namespace(ctx context.Context) string {
	value := resolver.data.GetNamespace()
	return value
}

func (resolver *serviceAccountResolver) Secrets(ctx context.Context) []string {
	value := resolver.data.GetSecrets()
	return value
}

type setBasedLabelSelectorResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.SetBasedLabelSelector
}

func (resolver *Resolver) wrapSetBasedLabelSelector(value *storage.SetBasedLabelSelector, ok bool, err error) (*setBasedLabelSelectorResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &setBasedLabelSelectorResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapSetBasedLabelSelectors(values []*storage.SetBasedLabelSelector, err error) ([]*setBasedLabelSelectorResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*setBasedLabelSelectorResolver, len(values))
	for i, v := range values {
		output[i] = &setBasedLabelSelectorResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *setBasedLabelSelectorResolver) Requirements(ctx context.Context) ([]*setBasedLabelSelector_RequirementResolver, error) {
	value := resolver.data.GetRequirements()
	return resolver.root.wrapSetBasedLabelSelector_Requirements(value, nil)
}

func toSetBasedLabelSelector_Operator(value *string) storage.SetBasedLabelSelector_Operator {
	if value != nil {
		return storage.SetBasedLabelSelector_Operator(storage.SetBasedLabelSelector_Operator_value[*value])
	}
	return storage.SetBasedLabelSelector_Operator(0)
}

func toSetBasedLabelSelector_Operators(values *[]string) []storage.SetBasedLabelSelector_Operator {
	if values == nil {
		return nil
	}
	output := make([]storage.SetBasedLabelSelector_Operator, len(*values))
	for i, v := range *values {
		output[i] = toSetBasedLabelSelector_Operator(&v)
	}
	return output
}

type setBasedLabelSelector_RequirementResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.SetBasedLabelSelector_Requirement
}

func (resolver *Resolver) wrapSetBasedLabelSelector_Requirement(value *storage.SetBasedLabelSelector_Requirement, ok bool, err error) (*setBasedLabelSelector_RequirementResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &setBasedLabelSelector_RequirementResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapSetBasedLabelSelector_Requirements(values []*storage.SetBasedLabelSelector_Requirement, err error) ([]*setBasedLabelSelector_RequirementResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*setBasedLabelSelector_RequirementResolver, len(values))
	for i, v := range values {
		output[i] = &setBasedLabelSelector_RequirementResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *setBasedLabelSelector_RequirementResolver) Key(ctx context.Context) string {
	value := resolver.data.GetKey()
	return value
}

func (resolver *setBasedLabelSelector_RequirementResolver) Op(ctx context.Context) string {
	value := resolver.data.GetOp()
	return value.String()
}

func (resolver *setBasedLabelSelector_RequirementResolver) Values(ctx context.Context) []string {
	value := resolver.data.GetValues()
	return value
}

func toSeverity(value *string) storage.Severity {
	if value != nil {
		return storage.Severity(storage.Severity_value[*value])
	}
	return storage.Severity(0)
}

func toSeverities(values *[]string) []storage.Severity {
	if values == nil {
		return nil
	}
	output := make([]storage.Severity, len(*values))
	for i, v := range *values {
		output[i] = toSeverity(&v)
	}
	return output
}

type signatureResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Signature
}

func (resolver *Resolver) wrapSignature(value *storage.Signature, ok bool, err error) (*signatureResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &signatureResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapSignatures(values []*storage.Signature, err error) ([]*signatureResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*signatureResolver, len(values))
	for i, v := range values {
		output[i] = &signatureResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *signatureResolver) Cosign(ctx context.Context) (*cosignSignatureResolver, error) {
	value := resolver.data.GetCosign()
	return resolver.root.wrapCosignSignature(value, true, nil)
}

type signatureSignatureResolver struct {
	resolver interface{}
}

func (resolver *signatureResolver) Signature() *signatureSignatureResolver {
	if val := resolver.data.GetCosign(); val != nil {
		return &signatureSignatureResolver{
			resolver: &cosignSignatureResolver{root: resolver.root, data: val},
		}
	}
	return nil
}

func (resolver *signatureSignatureResolver) ToCosignSignature() (*cosignSignatureResolver, bool) {
	res, ok := resolver.resolver.(*cosignSignatureResolver)
	return res, ok
}

type simpleAccessScopeResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.SimpleAccessScope
}

func (resolver *Resolver) wrapSimpleAccessScope(value *storage.SimpleAccessScope, ok bool, err error) (*simpleAccessScopeResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &simpleAccessScopeResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapSimpleAccessScopes(values []*storage.SimpleAccessScope, err error) ([]*simpleAccessScopeResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*simpleAccessScopeResolver, len(values))
	for i, v := range values {
		output[i] = &simpleAccessScopeResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *simpleAccessScopeResolver) Description(ctx context.Context) string {
	value := resolver.data.GetDescription()
	return value
}

func (resolver *simpleAccessScopeResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *simpleAccessScopeResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func (resolver *simpleAccessScopeResolver) Rules(ctx context.Context) (*simpleAccessScope_RulesResolver, error) {
	value := resolver.data.GetRules()
	return resolver.root.wrapSimpleAccessScope_Rules(value, true, nil)
}

type simpleAccessScope_RulesResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.SimpleAccessScope_Rules
}

func (resolver *Resolver) wrapSimpleAccessScope_Rules(value *storage.SimpleAccessScope_Rules, ok bool, err error) (*simpleAccessScope_RulesResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &simpleAccessScope_RulesResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapSimpleAccessScope_Ruleses(values []*storage.SimpleAccessScope_Rules, err error) ([]*simpleAccessScope_RulesResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*simpleAccessScope_RulesResolver, len(values))
	for i, v := range values {
		output[i] = &simpleAccessScope_RulesResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *simpleAccessScope_RulesResolver) ClusterLabelSelectors(ctx context.Context) ([]*setBasedLabelSelectorResolver, error) {
	value := resolver.data.GetClusterLabelSelectors()
	return resolver.root.wrapSetBasedLabelSelectors(value, nil)
}

func (resolver *simpleAccessScope_RulesResolver) IncludedClusters(ctx context.Context) []string {
	value := resolver.data.GetIncludedClusters()
	return value
}

func (resolver *simpleAccessScope_RulesResolver) IncludedNamespaces(ctx context.Context) ([]*simpleAccessScope_Rules_NamespaceResolver, error) {
	value := resolver.data.GetIncludedNamespaces()
	return resolver.root.wrapSimpleAccessScope_Rules_Namespaces(value, nil)
}

func (resolver *simpleAccessScope_RulesResolver) NamespaceLabelSelectors(ctx context.Context) ([]*setBasedLabelSelectorResolver, error) {
	value := resolver.data.GetNamespaceLabelSelectors()
	return resolver.root.wrapSetBasedLabelSelectors(value, nil)
}

type simpleAccessScope_Rules_NamespaceResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.SimpleAccessScope_Rules_Namespace
}

func (resolver *Resolver) wrapSimpleAccessScope_Rules_Namespace(value *storage.SimpleAccessScope_Rules_Namespace, ok bool, err error) (*simpleAccessScope_Rules_NamespaceResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &simpleAccessScope_Rules_NamespaceResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapSimpleAccessScope_Rules_Namespaces(values []*storage.SimpleAccessScope_Rules_Namespace, err error) ([]*simpleAccessScope_Rules_NamespaceResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*simpleAccessScope_Rules_NamespaceResolver, len(values))
	for i, v := range values {
		output[i] = &simpleAccessScope_Rules_NamespaceResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *simpleAccessScope_Rules_NamespaceResolver) ClusterName(ctx context.Context) string {
	value := resolver.data.GetClusterName()
	return value
}

func (resolver *simpleAccessScope_Rules_NamespaceResolver) NamespaceName(ctx context.Context) string {
	value := resolver.data.GetNamespaceName()
	return value
}

type slimUserResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.SlimUser
}

func (resolver *Resolver) wrapSlimUser(value *storage.SlimUser, ok bool, err error) (*slimUserResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &slimUserResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapSlimUsers(values []*storage.SlimUser, err error) ([]*slimUserResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*slimUserResolver, len(values))
	for i, v := range values {
		output[i] = &slimUserResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *slimUserResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *slimUserResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func toSourceType(value *string) storage.SourceType {
	if value != nil {
		return storage.SourceType(storage.SourceType_value[*value])
	}
	return storage.SourceType(0)
}

func toSourceTypes(values *[]string) []storage.SourceType {
	if values == nil {
		return nil
	}
	output := make([]storage.SourceType, len(*values))
	for i, v := range *values {
		output[i] = toSourceType(&v)
	}
	return output
}

type splunkResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Splunk
}

func (resolver *Resolver) wrapSplunk(value *storage.Splunk, ok bool, err error) (*splunkResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &splunkResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapSplunks(values []*storage.Splunk, err error) ([]*splunkResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*splunkResolver, len(values))
	for i, v := range values {
		output[i] = &splunkResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *splunkResolver) AuditLoggingEnabled(ctx context.Context) bool {
	value := resolver.data.GetAuditLoggingEnabled()
	return value
}

func (resolver *splunkResolver) HttpEndpoint(ctx context.Context) string {
	value := resolver.data.GetHttpEndpoint()
	return value
}

func (resolver *splunkResolver) HttpToken(ctx context.Context) string {
	value := resolver.data.GetHttpToken()
	return value
}

func (resolver *splunkResolver) Insecure(ctx context.Context) bool {
	value := resolver.data.GetInsecure()
	return value
}

func (resolver *splunkResolver) SourceTypes(ctx context.Context) labels {
	value := resolver.data.GetSourceTypes()
	return labelsResolver(value)
}

func (resolver *splunkResolver) Truncate(ctx context.Context) int32 {
	value := resolver.data.GetTruncate()
	return int32(value)
}

type staticClusterConfigResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.StaticClusterConfig
}

func (resolver *Resolver) wrapStaticClusterConfig(value *storage.StaticClusterConfig, ok bool, err error) (*staticClusterConfigResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &staticClusterConfigResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapStaticClusterConfigs(values []*storage.StaticClusterConfig, err error) ([]*staticClusterConfigResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*staticClusterConfigResolver, len(values))
	for i, v := range values {
		output[i] = &staticClusterConfigResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *staticClusterConfigResolver) AdmissionController(ctx context.Context) bool {
	value := resolver.data.GetAdmissionController()
	return value
}

func (resolver *staticClusterConfigResolver) AdmissionControllerEvents(ctx context.Context) bool {
	value := resolver.data.GetAdmissionControllerEvents()
	return value
}

func (resolver *staticClusterConfigResolver) AdmissionControllerUpdates(ctx context.Context) bool {
	value := resolver.data.GetAdmissionControllerUpdates()
	return value
}

func (resolver *staticClusterConfigResolver) CentralApiEndpoint(ctx context.Context) string {
	value := resolver.data.GetCentralApiEndpoint()
	return value
}

func (resolver *staticClusterConfigResolver) CollectionMethod(ctx context.Context) string {
	value := resolver.data.GetCollectionMethod()
	return value.String()
}

func (resolver *staticClusterConfigResolver) CollectorImage(ctx context.Context) string {
	value := resolver.data.GetCollectorImage()
	return value
}

func (resolver *staticClusterConfigResolver) MainImage(ctx context.Context) string {
	value := resolver.data.GetMainImage()
	return value
}

func (resolver *staticClusterConfigResolver) SlimCollector(ctx context.Context) bool {
	value := resolver.data.GetSlimCollector()
	return value
}

func (resolver *staticClusterConfigResolver) TolerationsConfig(ctx context.Context) (*tolerationsConfigResolver, error) {
	value := resolver.data.GetTolerationsConfig()
	return resolver.root.wrapTolerationsConfig(value, true, nil)
}

func (resolver *staticClusterConfigResolver) Type(ctx context.Context) string {
	value := resolver.data.GetType()
	return value.String()
}

type subjectResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Subject
}

func (resolver *Resolver) wrapSubject(value *storage.Subject, ok bool, err error) (*subjectResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &subjectResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapSubjects(values []*storage.Subject, err error) ([]*subjectResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*subjectResolver, len(values))
	for i, v := range values {
		output[i] = &subjectResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *subjectResolver) ClusterId(ctx context.Context) string {
	value := resolver.data.GetClusterId()
	return value
}

func (resolver *subjectResolver) ClusterName(ctx context.Context) string {
	value := resolver.data.GetClusterName()
	return value
}

func (resolver *subjectResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *subjectResolver) Kind(ctx context.Context) string {
	value := resolver.data.GetKind()
	return value.String()
}

func (resolver *subjectResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func (resolver *subjectResolver) Namespace(ctx context.Context) string {
	value := resolver.data.GetNamespace()
	return value
}

func toSubjectKind(value *string) storage.SubjectKind {
	if value != nil {
		return storage.SubjectKind(storage.SubjectKind_value[*value])
	}
	return storage.SubjectKind(0)
}

func toSubjectKinds(values *[]string) []storage.SubjectKind {
	if values == nil {
		return nil
	}
	output := make([]storage.SubjectKind, len(*values))
	for i, v := range *values {
		output[i] = toSubjectKind(&v)
	}
	return output
}

type sumoLogicResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.SumoLogic
}

func (resolver *Resolver) wrapSumoLogic(value *storage.SumoLogic, ok bool, err error) (*sumoLogicResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &sumoLogicResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapSumoLogics(values []*storage.SumoLogic, err error) ([]*sumoLogicResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*sumoLogicResolver, len(values))
	for i, v := range values {
		output[i] = &sumoLogicResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *sumoLogicResolver) HttpSourceAddress(ctx context.Context) string {
	value := resolver.data.GetHttpSourceAddress()
	return value
}

func (resolver *sumoLogicResolver) SkipTLSVerify(ctx context.Context) bool {
	value := resolver.data.GetSkipTLSVerify()
	return value
}

type syslogResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Syslog
}

func (resolver *Resolver) wrapSyslog(value *storage.Syslog, ok bool, err error) (*syslogResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &syslogResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapSyslogs(values []*storage.Syslog, err error) ([]*syslogResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*syslogResolver, len(values))
	for i, v := range values {
		output[i] = &syslogResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *syslogResolver) LocalFacility(ctx context.Context) string {
	value := resolver.data.GetLocalFacility()
	return value.String()
}

func (resolver *syslogResolver) TcpConfig(ctx context.Context) (*syslog_TCPConfigResolver, error) {
	value := resolver.data.GetTcpConfig()
	return resolver.root.wrapSyslog_TCPConfig(value, true, nil)
}

type syslogEndpointResolver struct {
	resolver interface{}
}

func (resolver *syslogResolver) Endpoint() *syslogEndpointResolver {
	if val := resolver.data.GetTcpConfig(); val != nil {
		return &syslogEndpointResolver{
			resolver: &syslog_TCPConfigResolver{root: resolver.root, data: val},
		}
	}
	return nil
}

func (resolver *syslogEndpointResolver) ToSyslog_TCPConfig() (*syslog_TCPConfigResolver, bool) {
	res, ok := resolver.resolver.(*syslog_TCPConfigResolver)
	return res, ok
}

func toSyslog_LocalFacility(value *string) storage.Syslog_LocalFacility {
	if value != nil {
		return storage.Syslog_LocalFacility(storage.Syslog_LocalFacility_value[*value])
	}
	return storage.Syslog_LocalFacility(0)
}

func toSyslog_LocalFacilities(values *[]string) []storage.Syslog_LocalFacility {
	if values == nil {
		return nil
	}
	output := make([]storage.Syslog_LocalFacility, len(*values))
	for i, v := range *values {
		output[i] = toSyslog_LocalFacility(&v)
	}
	return output
}

type syslog_TCPConfigResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Syslog_TCPConfig
}

func (resolver *Resolver) wrapSyslog_TCPConfig(value *storage.Syslog_TCPConfig, ok bool, err error) (*syslog_TCPConfigResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &syslog_TCPConfigResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapSyslog_TCPConfigs(values []*storage.Syslog_TCPConfig, err error) ([]*syslog_TCPConfigResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*syslog_TCPConfigResolver, len(values))
	for i, v := range values {
		output[i] = &syslog_TCPConfigResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *syslog_TCPConfigResolver) Hostname(ctx context.Context) string {
	value := resolver.data.GetHostname()
	return value
}

func (resolver *syslog_TCPConfigResolver) Port(ctx context.Context) int32 {
	value := resolver.data.GetPort()
	return value
}

func (resolver *syslog_TCPConfigResolver) SkipTlsVerify(ctx context.Context) bool {
	value := resolver.data.GetSkipTlsVerify()
	return value
}

func (resolver *syslog_TCPConfigResolver) UseTls(ctx context.Context) bool {
	value := resolver.data.GetUseTls()
	return value
}

type taintResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Taint
}

func (resolver *Resolver) wrapTaint(value *storage.Taint, ok bool, err error) (*taintResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &taintResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapTaints(values []*storage.Taint, err error) ([]*taintResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*taintResolver, len(values))
	for i, v := range values {
		output[i] = &taintResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *taintResolver) Key(ctx context.Context) string {
	value := resolver.data.GetKey()
	return value
}

func (resolver *taintResolver) TaintEffect(ctx context.Context) string {
	value := resolver.data.GetTaintEffect()
	return value.String()
}

func (resolver *taintResolver) Value(ctx context.Context) string {
	value := resolver.data.GetValue()
	return value
}

func toTaintEffect(value *string) storage.TaintEffect {
	if value != nil {
		return storage.TaintEffect(storage.TaintEffect_value[*value])
	}
	return storage.TaintEffect(0)
}

func toTaintEffects(values *[]string) []storage.TaintEffect {
	if values == nil {
		return nil
	}
	output := make([]storage.TaintEffect, len(*values))
	for i, v := range *values {
		output[i] = toTaintEffect(&v)
	}
	return output
}

type tokenMetadataResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.TokenMetadata
}

func (resolver *Resolver) wrapTokenMetadata(value *storage.TokenMetadata, ok bool, err error) (*tokenMetadataResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &tokenMetadataResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapTokenMetadatas(values []*storage.TokenMetadata, err error) ([]*tokenMetadataResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*tokenMetadataResolver, len(values))
	for i, v := range values {
		output[i] = &tokenMetadataResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *tokenMetadataResolver) Expiration(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetExpiration()
	return timestamp(value)
}

func (resolver *tokenMetadataResolver) Id(ctx context.Context) graphql.ID {
	value := resolver.data.GetId()
	return graphql.ID(value)
}

func (resolver *tokenMetadataResolver) IssuedAt(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetIssuedAt()
	return timestamp(value)
}

func (resolver *tokenMetadataResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func (resolver *tokenMetadataResolver) Revoked(ctx context.Context) bool {
	value := resolver.data.GetRevoked()
	return value
}

func (resolver *tokenMetadataResolver) Role(ctx context.Context) string {
	value := resolver.data.GetRole()
	return value
}

func (resolver *tokenMetadataResolver) Roles(ctx context.Context) []string {
	value := resolver.data.GetRoles()
	return value
}

type tolerationResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Toleration
}

func (resolver *Resolver) wrapToleration(value *storage.Toleration, ok bool, err error) (*tolerationResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &tolerationResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapTolerations(values []*storage.Toleration, err error) ([]*tolerationResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*tolerationResolver, len(values))
	for i, v := range values {
		output[i] = &tolerationResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *tolerationResolver) Key(ctx context.Context) string {
	value := resolver.data.GetKey()
	return value
}

func (resolver *tolerationResolver) Operator(ctx context.Context) string {
	value := resolver.data.GetOperator()
	return value.String()
}

func (resolver *tolerationResolver) TaintEffect(ctx context.Context) string {
	value := resolver.data.GetTaintEffect()
	return value.String()
}

func (resolver *tolerationResolver) Value(ctx context.Context) string {
	value := resolver.data.GetValue()
	return value
}

func toToleration_Operator(value *string) storage.Toleration_Operator {
	if value != nil {
		return storage.Toleration_Operator(storage.Toleration_Operator_value[*value])
	}
	return storage.Toleration_Operator(0)
}

func toToleration_Operators(values *[]string) []storage.Toleration_Operator {
	if values == nil {
		return nil
	}
	output := make([]storage.Toleration_Operator, len(*values))
	for i, v := range *values {
		output[i] = toToleration_Operator(&v)
	}
	return output
}

type tolerationsConfigResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.TolerationsConfig
}

func (resolver *Resolver) wrapTolerationsConfig(value *storage.TolerationsConfig, ok bool, err error) (*tolerationsConfigResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &tolerationsConfigResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapTolerationsConfigs(values []*storage.TolerationsConfig, err error) ([]*tolerationsConfigResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*tolerationsConfigResolver, len(values))
	for i, v := range values {
		output[i] = &tolerationsConfigResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *tolerationsConfigResolver) Disabled(ctx context.Context) bool {
	value := resolver.data.GetDisabled()
	return value
}

type upgradeProgressResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.UpgradeProgress
}

func (resolver *Resolver) wrapUpgradeProgress(value *storage.UpgradeProgress, ok bool, err error) (*upgradeProgressResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &upgradeProgressResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapUpgradeProgresses(values []*storage.UpgradeProgress, err error) ([]*upgradeProgressResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*upgradeProgressResolver, len(values))
	for i, v := range values {
		output[i] = &upgradeProgressResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *upgradeProgressResolver) Since(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetSince()
	return timestamp(value)
}

func (resolver *upgradeProgressResolver) UpgradeState(ctx context.Context) string {
	value := resolver.data.GetUpgradeState()
	return value.String()
}

func (resolver *upgradeProgressResolver) UpgradeStatusDetail(ctx context.Context) string {
	value := resolver.data.GetUpgradeStatusDetail()
	return value
}

func toUpgradeProgress_UpgradeState(value *string) storage.UpgradeProgress_UpgradeState {
	if value != nil {
		return storage.UpgradeProgress_UpgradeState(storage.UpgradeProgress_UpgradeState_value[*value])
	}
	return storage.UpgradeProgress_UpgradeState(0)
}

func toUpgradeProgress_UpgradeStates(values *[]string) []storage.UpgradeProgress_UpgradeState {
	if values == nil {
		return nil
	}
	output := make([]storage.UpgradeProgress_UpgradeState, len(*values))
	for i, v := range *values {
		output[i] = toUpgradeProgress_UpgradeState(&v)
	}
	return output
}

type v1MetadataResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.V1Metadata
}

func (resolver *Resolver) wrapV1Metadata(value *storage.V1Metadata, ok bool, err error) (*v1MetadataResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &v1MetadataResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapV1Metadatas(values []*storage.V1Metadata, err error) ([]*v1MetadataResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*v1MetadataResolver, len(values))
	for i, v := range values {
		output[i] = &v1MetadataResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *v1MetadataResolver) Author(ctx context.Context) string {
	value := resolver.data.GetAuthor()
	return value
}

func (resolver *v1MetadataResolver) Command(ctx context.Context) []string {
	value := resolver.data.GetCommand()
	return value
}

func (resolver *v1MetadataResolver) Created(ctx context.Context) (*graphql.Time, error) {
	value := resolver.data.GetCreated()
	return timestamp(value)
}

func (resolver *v1MetadataResolver) Digest(ctx context.Context) string {
	value := resolver.data.GetDigest()
	return value
}

func (resolver *v1MetadataResolver) Entrypoint(ctx context.Context) []string {
	value := resolver.data.GetEntrypoint()
	return value
}

func (resolver *v1MetadataResolver) Labels(ctx context.Context) labels {
	value := resolver.data.GetLabels()
	return labelsResolver(value)
}

func (resolver *v1MetadataResolver) Layers(ctx context.Context) ([]*imageLayerResolver, error) {
	value := resolver.data.GetLayers()
	return resolver.root.wrapImageLayers(value, nil)
}

func (resolver *v1MetadataResolver) User(ctx context.Context) string {
	value := resolver.data.GetUser()
	return value
}

func (resolver *v1MetadataResolver) Volumes(ctx context.Context) []string {
	value := resolver.data.GetVolumes()
	return value
}

type v2MetadataResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.V2Metadata
}

func (resolver *Resolver) wrapV2Metadata(value *storage.V2Metadata, ok bool, err error) (*v2MetadataResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &v2MetadataResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapV2Metadatas(values []*storage.V2Metadata, err error) ([]*v2MetadataResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*v2MetadataResolver, len(values))
	for i, v := range values {
		output[i] = &v2MetadataResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *v2MetadataResolver) Digest(ctx context.Context) string {
	value := resolver.data.GetDigest()
	return value
}

func toViolationState(value *string) storage.ViolationState {
	if value != nil {
		return storage.ViolationState(storage.ViolationState_value[*value])
	}
	return storage.ViolationState(0)
}

func toViolationStates(values *[]string) []storage.ViolationState {
	if values == nil {
		return nil
	}
	output := make([]storage.ViolationState, len(*values))
	for i, v := range *values {
		output[i] = toViolationState(&v)
	}
	return output
}

type volumeResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.Volume
}

func (resolver *Resolver) wrapVolume(value *storage.Volume, ok bool, err error) (*volumeResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &volumeResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapVolumes(values []*storage.Volume, err error) ([]*volumeResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*volumeResolver, len(values))
	for i, v := range values {
		output[i] = &volumeResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *volumeResolver) Destination(ctx context.Context) string {
	value := resolver.data.GetDestination()
	return value
}

func (resolver *volumeResolver) MountPropagation(ctx context.Context) string {
	value := resolver.data.GetMountPropagation()
	return value.String()
}

func (resolver *volumeResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func (resolver *volumeResolver) ReadOnly(ctx context.Context) bool {
	value := resolver.data.GetReadOnly()
	return value
}

func (resolver *volumeResolver) Source(ctx context.Context) string {
	value := resolver.data.GetSource()
	return value
}

func (resolver *volumeResolver) Type(ctx context.Context) string {
	value := resolver.data.GetType()
	return value
}

type volumePolicyResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.VolumePolicy
}

func (resolver *Resolver) wrapVolumePolicy(value *storage.VolumePolicy, ok bool, err error) (*volumePolicyResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &volumePolicyResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapVolumePolicies(values []*storage.VolumePolicy, err error) ([]*volumePolicyResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*volumePolicyResolver, len(values))
	for i, v := range values {
		output[i] = &volumePolicyResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *volumePolicyResolver) Destination(ctx context.Context) string {
	value := resolver.data.GetDestination()
	return value
}

func (resolver *volumePolicyResolver) Name(ctx context.Context) string {
	value := resolver.data.GetName()
	return value
}

func (resolver *volumePolicyResolver) Source(ctx context.Context) string {
	value := resolver.data.GetSource()
	return value
}

func (resolver *volumePolicyResolver) Type(ctx context.Context) string {
	value := resolver.data.GetType()
	return value
}

func toVolume_MountPropagation(value *string) storage.Volume_MountPropagation {
	if value != nil {
		return storage.Volume_MountPropagation(storage.Volume_MountPropagation_value[*value])
	}
	return storage.Volume_MountPropagation(0)
}

func toVolume_MountPropagations(values *[]string) []storage.Volume_MountPropagation {
	if values == nil {
		return nil
	}
	output := make([]storage.Volume_MountPropagation, len(*values))
	for i, v := range *values {
		output[i] = toVolume_MountPropagation(&v)
	}
	return output
}

type vulnerabilityRequest_CVEsResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.VulnerabilityRequest_CVEs
}

func (resolver *Resolver) wrapVulnerabilityRequest_CVEs(value *storage.VulnerabilityRequest_CVEs, ok bool, err error) (*vulnerabilityRequest_CVEsResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &vulnerabilityRequest_CVEsResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapVulnerabilityRequest_CVEses(values []*storage.VulnerabilityRequest_CVEs, err error) ([]*vulnerabilityRequest_CVEsResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*vulnerabilityRequest_CVEsResolver, len(values))
	for i, v := range values {
		output[i] = &vulnerabilityRequest_CVEsResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *vulnerabilityRequest_CVEsResolver) Ids(ctx context.Context) []string {
	value := resolver.data.GetIds()
	return value
}

type vulnerabilityRequest_ScopeResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.VulnerabilityRequest_Scope
}

func (resolver *Resolver) wrapVulnerabilityRequest_Scope(value *storage.VulnerabilityRequest_Scope, ok bool, err error) (*vulnerabilityRequest_ScopeResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &vulnerabilityRequest_ScopeResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapVulnerabilityRequest_Scopes(values []*storage.VulnerabilityRequest_Scope, err error) ([]*vulnerabilityRequest_ScopeResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*vulnerabilityRequest_ScopeResolver, len(values))
	for i, v := range values {
		output[i] = &vulnerabilityRequest_ScopeResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *vulnerabilityRequest_ScopeResolver) GlobalScope(ctx context.Context) (*vulnerabilityRequest_Scope_GlobalResolver, error) {
	value := resolver.data.GetGlobalScope()
	return resolver.root.wrapVulnerabilityRequest_Scope_Global(value, true, nil)
}

func (resolver *vulnerabilityRequest_ScopeResolver) ImageScope(ctx context.Context) (*vulnerabilityRequest_Scope_ImageResolver, error) {
	value := resolver.data.GetImageScope()
	return resolver.root.wrapVulnerabilityRequest_Scope_Image(value, true, nil)
}

type vulnerabilityRequest_ScopeInfoResolver struct {
	resolver interface{}
}

func (resolver *vulnerabilityRequest_ScopeResolver) Info() *vulnerabilityRequest_ScopeInfoResolver {
	if val := resolver.data.GetImageScope(); val != nil {
		return &vulnerabilityRequest_ScopeInfoResolver{
			resolver: &vulnerabilityRequest_Scope_ImageResolver{root: resolver.root, data: val},
		}
	}
	if val := resolver.data.GetGlobalScope(); val != nil {
		return &vulnerabilityRequest_ScopeInfoResolver{
			resolver: &vulnerabilityRequest_Scope_GlobalResolver{root: resolver.root, data: val},
		}
	}
	return nil
}

func (resolver *vulnerabilityRequest_ScopeInfoResolver) ToVulnerabilityRequest_Scope_Image() (*vulnerabilityRequest_Scope_ImageResolver, bool) {
	res, ok := resolver.resolver.(*vulnerabilityRequest_Scope_ImageResolver)
	return res, ok
}

func (resolver *vulnerabilityRequest_ScopeInfoResolver) ToVulnerabilityRequest_Scope_Global() (*vulnerabilityRequest_Scope_GlobalResolver, bool) {
	res, ok := resolver.resolver.(*vulnerabilityRequest_Scope_GlobalResolver)
	return res, ok
}

type vulnerabilityRequest_Scope_GlobalResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.VulnerabilityRequest_Scope_Global
}

func (resolver *Resolver) wrapVulnerabilityRequest_Scope_Global(value *storage.VulnerabilityRequest_Scope_Global, ok bool, err error) (*vulnerabilityRequest_Scope_GlobalResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &vulnerabilityRequest_Scope_GlobalResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapVulnerabilityRequest_Scope_Globals(values []*storage.VulnerabilityRequest_Scope_Global, err error) ([]*vulnerabilityRequest_Scope_GlobalResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*vulnerabilityRequest_Scope_GlobalResolver, len(values))
	for i, v := range values {
		output[i] = &vulnerabilityRequest_Scope_GlobalResolver{root: resolver, data: v}
	}
	return output, nil
}

type vulnerabilityRequest_Scope_ImageResolver struct {
	ctx  context.Context
	root *Resolver
	data *storage.VulnerabilityRequest_Scope_Image
}

func (resolver *Resolver) wrapVulnerabilityRequest_Scope_Image(value *storage.VulnerabilityRequest_Scope_Image, ok bool, err error) (*vulnerabilityRequest_Scope_ImageResolver, error) {
	if !ok || err != nil || value == nil {
		return nil, err
	}
	return &vulnerabilityRequest_Scope_ImageResolver{root: resolver, data: value}, nil
}

func (resolver *Resolver) wrapVulnerabilityRequest_Scope_Images(values []*storage.VulnerabilityRequest_Scope_Image, err error) ([]*vulnerabilityRequest_Scope_ImageResolver, error) {
	if err != nil || len(values) == 0 {
		return nil, err
	}
	output := make([]*vulnerabilityRequest_Scope_ImageResolver, len(values))
	for i, v := range values {
		output[i] = &vulnerabilityRequest_Scope_ImageResolver{root: resolver, data: v}
	}
	return output, nil
}

func (resolver *vulnerabilityRequest_Scope_ImageResolver) Registry(ctx context.Context) string {
	value := resolver.data.GetRegistry()
	return value
}

func (resolver *vulnerabilityRequest_Scope_ImageResolver) Remote(ctx context.Context) string {
	value := resolver.data.GetRemote()
	return value
}

func (resolver *vulnerabilityRequest_Scope_ImageResolver) Tag(ctx context.Context) string {
	value := resolver.data.GetTag()
	return value
}

func toVulnerabilitySeverity(value *string) storage.VulnerabilitySeverity {
	if value != nil {
		return storage.VulnerabilitySeverity(storage.VulnerabilitySeverity_value[*value])
	}
	return storage.VulnerabilitySeverity(0)
}

func toVulnerabilitySeverities(values *[]string) []storage.VulnerabilitySeverity {
	if values == nil {
		return nil
	}
	output := make([]storage.VulnerabilitySeverity, len(*values))
	for i, v := range *values {
		output[i] = toVulnerabilitySeverity(&v)
	}
	return output
}

func toVulnerabilityState(value *string) storage.VulnerabilityState {
	if value != nil {
		return storage.VulnerabilityState(storage.VulnerabilityState_value[*value])
	}
	return storage.VulnerabilityState(0)
}

func toVulnerabilityStates(values *[]string) []storage.VulnerabilityState {
	if values == nil {
		return nil
	}
	output := make([]storage.VulnerabilityState, len(*values))
	for i, v := range *values {
		output[i] = toVulnerabilityState(&v)
	}
	return output
}
