// Code generated by MockGen. DO NOT EDIT.
// Source: datastore.go

// Package mocks is a generated GoMock package.
package mocks

import (
	context "context"
	reflect "reflect"

	gomock "github.com/golang/mock/gomock"
	v1 "github.com/stackrox/rox/generated/api/v1"
	storage "github.com/stackrox/rox/generated/storage"
	search "github.com/stackrox/rox/pkg/search"
)

// MockDataStore is a mock of DataStore interface.
type MockDataStore struct {
	ctrl     *gomock.Controller
	recorder *MockDataStoreMockRecorder
}

// MockDataStoreMockRecorder is the mock recorder for MockDataStore.
type MockDataStoreMockRecorder struct {
	mock *MockDataStore
}

// NewMockDataStore creates a new mock instance.
func NewMockDataStore(ctrl *gomock.Controller) *MockDataStore {
	mock := &MockDataStore{ctrl: ctrl}
	mock.recorder = &MockDataStoreMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockDataStore) EXPECT() *MockDataStoreMockRecorder {
	return m.recorder
}

// Count mocks base method.
func (m *MockDataStore) Count(ctx context.Context, q *v1.Query) (int, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Count", ctx, q)
	ret0, _ := ret[0].(int)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Count indicates an expected call of Count.
func (mr *MockDataStoreMockRecorder) Count(ctx, q interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Count", reflect.TypeOf((*MockDataStore)(nil).Count), ctx, q)
}

// CountImages mocks base method.
func (m *MockDataStore) CountImages(ctx context.Context) (int, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CountImages", ctx)
	ret0, _ := ret[0].(int)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CountImages indicates an expected call of CountImages.
func (mr *MockDataStoreMockRecorder) CountImages(ctx interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CountImages", reflect.TypeOf((*MockDataStore)(nil).CountImages), ctx)
}

// DeleteImages mocks base method.
func (m *MockDataStore) DeleteImages(ctx context.Context, ids ...string) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx}
	for _, a := range ids {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "DeleteImages", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteImages indicates an expected call of DeleteImages.
func (mr *MockDataStoreMockRecorder) DeleteImages(ctx interface{}, ids ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx}, ids...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteImages", reflect.TypeOf((*MockDataStore)(nil).DeleteImages), varargs...)
}

// Exists mocks base method.
func (m *MockDataStore) Exists(ctx context.Context, id string) (bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Exists", ctx, id)
	ret0, _ := ret[0].(bool)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Exists indicates an expected call of Exists.
func (mr *MockDataStoreMockRecorder) Exists(ctx, id interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Exists", reflect.TypeOf((*MockDataStore)(nil).Exists), ctx, id)
}

// GetImage mocks base method.
func (m *MockDataStore) GetImage(ctx context.Context, sha string) (*storage.Image, bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetImage", ctx, sha)
	ret0, _ := ret[0].(*storage.Image)
	ret1, _ := ret[1].(bool)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetImage indicates an expected call of GetImage.
func (mr *MockDataStoreMockRecorder) GetImage(ctx, sha interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetImage", reflect.TypeOf((*MockDataStore)(nil).GetImage), ctx, sha)
}

// GetImageMetadata mocks base method.
func (m *MockDataStore) GetImageMetadata(ctx context.Context, id string) (*storage.Image, bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetImageMetadata", ctx, id)
	ret0, _ := ret[0].(*storage.Image)
	ret1, _ := ret[1].(bool)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetImageMetadata indicates an expected call of GetImageMetadata.
func (mr *MockDataStoreMockRecorder) GetImageMetadata(ctx, id interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetImageMetadata", reflect.TypeOf((*MockDataStore)(nil).GetImageMetadata), ctx, id)
}

// GetImagesBatch mocks base method.
func (m *MockDataStore) GetImagesBatch(ctx context.Context, shas []string) ([]*storage.Image, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetImagesBatch", ctx, shas)
	ret0, _ := ret[0].([]*storage.Image)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetImagesBatch indicates an expected call of GetImagesBatch.
func (mr *MockDataStoreMockRecorder) GetImagesBatch(ctx, shas interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetImagesBatch", reflect.TypeOf((*MockDataStore)(nil).GetImagesBatch), ctx, shas)
}

// ListImage mocks base method.
func (m *MockDataStore) ListImage(ctx context.Context, sha string) (*storage.ListImage, bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListImage", ctx, sha)
	ret0, _ := ret[0].(*storage.ListImage)
	ret1, _ := ret[1].(bool)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// ListImage indicates an expected call of ListImage.
func (mr *MockDataStoreMockRecorder) ListImage(ctx, sha interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListImage", reflect.TypeOf((*MockDataStore)(nil).ListImage), ctx, sha)
}

// Search mocks base method.
func (m *MockDataStore) Search(ctx context.Context, q *v1.Query) ([]search.Result, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Search", ctx, q)
	ret0, _ := ret[0].([]search.Result)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Search indicates an expected call of Search.
func (mr *MockDataStoreMockRecorder) Search(ctx, q interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Search", reflect.TypeOf((*MockDataStore)(nil).Search), ctx, q)
}

// SearchImages mocks base method.
func (m *MockDataStore) SearchImages(ctx context.Context, q *v1.Query) ([]*v1.SearchResult, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SearchImages", ctx, q)
	ret0, _ := ret[0].([]*v1.SearchResult)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SearchImages indicates an expected call of SearchImages.
func (mr *MockDataStoreMockRecorder) SearchImages(ctx, q interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SearchImages", reflect.TypeOf((*MockDataStore)(nil).SearchImages), ctx, q)
}

// SearchListImages mocks base method.
func (m *MockDataStore) SearchListImages(ctx context.Context, q *v1.Query) ([]*storage.ListImage, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SearchListImages", ctx, q)
	ret0, _ := ret[0].([]*storage.ListImage)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SearchListImages indicates an expected call of SearchListImages.
func (mr *MockDataStoreMockRecorder) SearchListImages(ctx, q interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SearchListImages", reflect.TypeOf((*MockDataStore)(nil).SearchListImages), ctx, q)
}

// SearchRawImages mocks base method.
func (m *MockDataStore) SearchRawImages(ctx context.Context, q *v1.Query) ([]*storage.Image, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SearchRawImages", ctx, q)
	ret0, _ := ret[0].([]*storage.Image)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SearchRawImages indicates an expected call of SearchRawImages.
func (mr *MockDataStoreMockRecorder) SearchRawImages(ctx, q interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SearchRawImages", reflect.TypeOf((*MockDataStore)(nil).SearchRawImages), ctx, q)
}

// UpsertImage mocks base method.
func (m *MockDataStore) UpsertImage(ctx context.Context, image *storage.Image) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpsertImage", ctx, image)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpsertImage indicates an expected call of UpsertImage.
func (mr *MockDataStoreMockRecorder) UpsertImage(ctx, image interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpsertImage", reflect.TypeOf((*MockDataStore)(nil).UpsertImage), ctx, image)
}
