// Code generated by blevebindings generator. DO NOT EDIT.

package index

import (
	"bytes"
	bleve "github.com/blevesearch/bleve"
	mappings "github.com/stackrox/rox/central/imagecomponentedge/mappings"
	metrics "github.com/stackrox/rox/central/metrics"
	v1 "github.com/stackrox/rox/generated/api/v1"
	storage "github.com/stackrox/rox/generated/storage"
	batcher "github.com/stackrox/rox/pkg/batcher"
	ops "github.com/stackrox/rox/pkg/metrics"
	search "github.com/stackrox/rox/pkg/search"
	blevesearch "github.com/stackrox/rox/pkg/search/blevesearch"
	"time"
)

const batchSize = 5000

const resourceName = "ImageComponentEdge"

type indexerImpl struct {
	index bleve.Index
}

type imageComponentEdgeWrapper struct {
	*storage.ImageComponentEdge `json:"image_component_edge"`
	Type                        string `json:"type"`
}

func (b *indexerImpl) AddImageComponentEdge(imagecomponentedge *storage.ImageComponentEdge) error {
	defer metrics.SetIndexOperationDurationTime(time.Now(), ops.Add, "ImageComponentEdge")
	if err := b.index.Index(imagecomponentedge.GetId(), &imageComponentEdgeWrapper{
		ImageComponentEdge: imagecomponentedge,
		Type:               v1.SearchCategory_IMAGE_COMPONENT_EDGE.String(),
	}); err != nil {
		return err
	}
	return nil
}

func (b *indexerImpl) AddImageComponentEdges(imagecomponentedges []*storage.ImageComponentEdge) error {
	defer metrics.SetIndexOperationDurationTime(time.Now(), ops.AddMany, "ImageComponentEdge")
	batchManager := batcher.New(len(imagecomponentedges), batchSize)
	for {
		start, end, ok := batchManager.Next()
		if !ok {
			break
		}
		if err := b.processBatch(imagecomponentedges[start:end]); err != nil {
			return err
		}
	}
	return nil
}

func (b *indexerImpl) processBatch(imagecomponentedges []*storage.ImageComponentEdge) error {
	batch := b.index.NewBatch()
	for _, imagecomponentedge := range imagecomponentedges {
		if err := batch.Index(imagecomponentedge.GetId(), &imageComponentEdgeWrapper{
			ImageComponentEdge: imagecomponentedge,
			Type:               v1.SearchCategory_IMAGE_COMPONENT_EDGE.String(),
		}); err != nil {
			return err
		}
	}
	return b.index.Batch(batch)
}

func (b *indexerImpl) Count(q *v1.Query, opts ...blevesearch.SearchOption) (int, error) {
	defer metrics.SetIndexOperationDurationTime(time.Now(), ops.Count, "ImageComponentEdge")
	return blevesearch.RunCountRequest(v1.SearchCategory_IMAGE_COMPONENT_EDGE, q, b.index, mappings.OptionsMap, opts...)
}

func (b *indexerImpl) DeleteImageComponentEdge(id string) error {
	defer metrics.SetIndexOperationDurationTime(time.Now(), ops.Remove, "ImageComponentEdge")
	if err := b.index.Delete(id); err != nil {
		return err
	}
	return nil
}

func (b *indexerImpl) DeleteImageComponentEdges(ids []string) error {
	defer metrics.SetIndexOperationDurationTime(time.Now(), ops.RemoveMany, "ImageComponentEdge")
	batch := b.index.NewBatch()
	for _, id := range ids {
		batch.Delete(id)
	}
	if err := b.index.Batch(batch); err != nil {
		return err
	}
	return nil
}

func (b *indexerImpl) MarkInitialIndexingComplete() error {
	return b.index.SetInternal([]byte(resourceName), []byte("old"))
}

func (b *indexerImpl) NeedsInitialIndexing() (bool, error) {
	data, err := b.index.GetInternal([]byte(resourceName))
	if err != nil {
		return false, err
	}
	return !bytes.Equal([]byte("old"), data), nil
}

func (b *indexerImpl) Search(q *v1.Query, opts ...blevesearch.SearchOption) ([]search.Result, error) {
	defer metrics.SetIndexOperationDurationTime(time.Now(), ops.Search, "ImageComponentEdge")
	return blevesearch.RunSearchRequest(v1.SearchCategory_IMAGE_COMPONENT_EDGE, q, b.index, mappings.OptionsMap, opts...)
}
