package datastore

import (
	clusterIndexer "github.com/stackrox/rox/central/cluster/index"
	componentCVEEdgeIndexer "github.com/stackrox/rox/central/componentcveedge/index"
	cveIndexer "github.com/stackrox/rox/central/cve/index"
	deploymentIndexer "github.com/stackrox/rox/central/deployment/index"
	globaldb "github.com/stackrox/rox/central/globaldb/dackbox"
	"github.com/stackrox/rox/central/globalindex"
	imageIndexer "github.com/stackrox/rox/central/image/index"
	componentIndexer "github.com/stackrox/rox/central/imagecomponent/index"
	imageComponentEdgeIndexer "github.com/stackrox/rox/central/imagecomponentedge/index"
	imageCVEEdgeIndexer "github.com/stackrox/rox/central/imagecveedge/index"
	"github.com/stackrox/rox/central/imagecveedge/search"
	"github.com/stackrox/rox/central/imagecveedge/store/dackbox"
	"github.com/stackrox/rox/pkg/features"
	"github.com/stackrox/rox/pkg/sync"
)

var (
	once sync.Once

	ad DataStore
)

func initialize() {
	storage := dackbox.New(globaldb.GetGlobalDackBox(), globaldb.GetKeyFence())
	var searcher search.Searcher
	if features.VulnRiskManagement.Enabled() {
		searcher = search.New(storage, cveIndexer.New(globalindex.GetGlobalIndex()),
			imageCVEEdgeIndexer.New(globalindex.GetGlobalIndex()),
			componentCVEEdgeIndexer.New(globalindex.GetGlobalIndex()),
			componentIndexer.New(globalindex.GetGlobalIndex()),
			imageComponentEdgeIndexer.New(globalindex.GetGlobalIndex()),
			imageIndexer.New(globalindex.GetGlobalIndex()),
			deploymentIndexer.New(globalindex.GetGlobalIndex(), globalindex.GetProcessIndex()),
			clusterIndexer.New(globalindex.GetGlobalIndex()))
	}
	ad = New(globaldb.GetGlobalDackBox(), storage, searcher)
}

// Singleton provides the interface for non-service external interaction.
func Singleton() DataStore {
	once.Do(initialize)
	return ad
}
