package store

import (
	"github.com/gogo/protobuf/types"
	"github.com/stackrox/rox/generated/storage"
	"github.com/stackrox/rox/pkg/timestamp"
)

// FlowStore stores all of the flows for a single cluster.
//go:generate mockgen-wrapper
type FlowStore interface {
	GetAllFlows(since *types.Timestamp) ([]*storage.NetworkFlow, types.Timestamp, error)
	GetMatchingFlows(pred func(*storage.NetworkFlowProperties) bool, since *types.Timestamp) ([]*storage.NetworkFlow, types.Timestamp, error)

	UpsertFlows(flows []*storage.NetworkFlow, lastUpdateTS timestamp.MicroTS) error
	RemoveFlow(props *storage.NetworkFlowProperties) error

	RemoveFlowsForDeployment(id string) error
	RemoveMatchingFlows(keyMatchFn func(props *storage.NetworkFlowProperties) bool, valueMatchFn func(flow *storage.NetworkFlow) bool) error
}
