package common

import "github.com/stackrox/rox/generated/storage"

var (
	// MatchAll is a match all regex
	MatchAll = ".*"
)

// VulnRequestParams contains all the supported parameters for vuln request workflow.
type VulnRequestParams struct {
	Comment string
	Expiry  *storage.RequestExpiry
}

// VulnReqScope represents a image scope object.
type VulnReqScope struct {
	// Vulnerability requests are created with concrete values for below instead of image full name.
	// We do not prefer deconstruction from full name since it can lead to errors. For example, image name with digest.

	Registry string
	Remote   string
	Tag      string
}
