package searcher

import (
	"context"

	"github.com/stackrox/rox/central/vulnerabilityrequest/datastore/internal/store"
	"github.com/stackrox/rox/central/vulnerabilityrequest/index"
	v1 "github.com/stackrox/rox/generated/api/v1"
	"github.com/stackrox/rox/generated/storage"
	"github.com/stackrox/rox/pkg/logging"
	"github.com/stackrox/rox/pkg/search"
)

var (
	log = logging.LoggerForModule()
)

// Searcher provides search functionality on existing VulnerabilityRequest.
//go:generate mockgen-wrapper
type Searcher interface {
	Count(ctx context.Context, query *v1.Query) (int, error)
	Search(ctx context.Context, query *v1.Query) ([]search.Result, error)
	SearchRequests(context.Context, *v1.Query) ([]*v1.SearchResult, error)
	SearchRawRequests(ctx context.Context, query *v1.Query) ([]*storage.VulnerabilityRequest, error)
}

// New returns a new instance of Searcher for the given storage and index.
func New(store store.Store, indexer index.Indexer) Searcher {
	return &searcherImpl{
		store:    store,
		indexer:  indexer,
		searcher: formatSearcher(indexer),
	}
}
