package store

import (
	"context"

	"github.com/stackrox/rox/generated/storage"
)

// Store provides access and update functions for vulnerability watch requests.
//go:generate mockgen-wrapper
type Store interface {
	Count(ctx context.Context) (int, error)
	Exists(ctx context.Context, id string) (bool, error)
	Walk(context.Context, func(req *storage.VulnerabilityRequest) error) error

	GetIDs(ctx context.Context) ([]string, error)
	Get(ctx context.Context, id string) (*storage.VulnerabilityRequest, bool, error)
	GetMany(ctx context.Context, ids []string) ([]*storage.VulnerabilityRequest, []int, error)

	Upsert(ctx context.Context, req *storage.VulnerabilityRequest) error
	Delete(ctx context.Context, id string) error
	DeleteMany(ctx context.Context, ids []string) error
}
