package datastore

import (
	"github.com/stackrox/rox/central/globaldb"
	"github.com/stackrox/rox/central/globalindex"
	"github.com/stackrox/rox/central/vulnerabilityrequest/cache"
	"github.com/stackrox/rox/central/vulnerabilityrequest/datastore/internal/searcher"
	"github.com/stackrox/rox/central/vulnerabilityrequest/datastore/internal/store/rocksdb"
	"github.com/stackrox/rox/central/vulnerabilityrequest/index"
	"github.com/stackrox/rox/pkg/features"
	"github.com/stackrox/rox/pkg/logging"
	"github.com/stackrox/rox/pkg/sync"
)

var (
	once sync.Once

	ds DataStore

	log = logging.LoggerForModule()
)

func initialize() {
	storage := rocksdb.New(globaldb.GetRocksDB())
	indexer := index.New(globalindex.GetGlobalTmpIndex())
	var err error
	ds, err = New(storage, indexer, searcher.New(storage, indexer),
		cache.PendingReqsCacheSingleton(), cache.ActiveReqsCacheSingleton())
	if err != nil {
		log.Panicf("Failed to initialize vulnerability requests datastore: %s", err)
	}
}

// Singleton provides the interface for non-service external interaction.
func Singleton() DataStore {
	if !features.VulnRiskManagement.Enabled() {
		return nil
	}
	once.Do(initialize)
	return ds
}
