// Code generated by blevebindings generator. DO NOT EDIT.

package index

import (
	"bytes"
	bleve "github.com/blevesearch/bleve"
	metrics "github.com/stackrox/rox/central/metrics"
	mappings "github.com/stackrox/rox/central/vulnerabilityrequest/mappings"
	v1 "github.com/stackrox/rox/generated/api/v1"
	storage "github.com/stackrox/rox/generated/storage"
	batcher "github.com/stackrox/rox/pkg/batcher"
	ops "github.com/stackrox/rox/pkg/metrics"
	search "github.com/stackrox/rox/pkg/search"
	blevesearch "github.com/stackrox/rox/pkg/search/blevesearch"
	"time"
)

const batchSize = 5000

const resourceName = "VulnerabilityRequest"

type indexerImpl struct {
	index bleve.Index
}

type vulnerabilityRequestWrapper struct {
	*storage.VulnerabilityRequest `json:"vulnerability_request"`
	Type                          string `json:"type"`
}

func (b *indexerImpl) AddVulnerabilityRequest(vulnerabilityrequest *storage.VulnerabilityRequest) error {
	defer metrics.SetIndexOperationDurationTime(time.Now(), ops.Add, "VulnerabilityRequest")
	if err := b.index.Index(vulnerabilityrequest.GetId(), &vulnerabilityRequestWrapper{
		Type:                 v1.SearchCategory_VULN_REQUEST.String(),
		VulnerabilityRequest: vulnerabilityrequest,
	}); err != nil {
		return err
	}
	return nil
}

func (b *indexerImpl) AddVulnerabilityRequests(vulnerabilityrequests []*storage.VulnerabilityRequest) error {
	defer metrics.SetIndexOperationDurationTime(time.Now(), ops.AddMany, "VulnerabilityRequest")
	batchManager := batcher.New(len(vulnerabilityrequests), batchSize)
	for {
		start, end, ok := batchManager.Next()
		if !ok {
			break
		}
		if err := b.processBatch(vulnerabilityrequests[start:end]); err != nil {
			return err
		}
	}
	return nil
}

func (b *indexerImpl) processBatch(vulnerabilityrequests []*storage.VulnerabilityRequest) error {
	batch := b.index.NewBatch()
	for _, vulnerabilityrequest := range vulnerabilityrequests {
		if err := batch.Index(vulnerabilityrequest.GetId(), &vulnerabilityRequestWrapper{
			Type:                 v1.SearchCategory_VULN_REQUEST.String(),
			VulnerabilityRequest: vulnerabilityrequest,
		}); err != nil {
			return err
		}
	}
	return b.index.Batch(batch)
}

func (b *indexerImpl) Count(q *v1.Query, opts ...blevesearch.SearchOption) (int, error) {
	defer metrics.SetIndexOperationDurationTime(time.Now(), ops.Count, "VulnerabilityRequest")
	return blevesearch.RunCountRequest(v1.SearchCategory_VULN_REQUEST, q, b.index, mappings.OptionsMap, opts...)
}

func (b *indexerImpl) DeleteVulnerabilityRequest(id string) error {
	defer metrics.SetIndexOperationDurationTime(time.Now(), ops.Remove, "VulnerabilityRequest")
	if err := b.index.Delete(id); err != nil {
		return err
	}
	return nil
}

func (b *indexerImpl) DeleteVulnerabilityRequests(ids []string) error {
	defer metrics.SetIndexOperationDurationTime(time.Now(), ops.RemoveMany, "VulnerabilityRequest")
	batch := b.index.NewBatch()
	for _, id := range ids {
		batch.Delete(id)
	}
	if err := b.index.Batch(batch); err != nil {
		return err
	}
	return nil
}

func (b *indexerImpl) MarkInitialIndexingComplete() error {
	return b.index.SetInternal([]byte(resourceName), []byte("old"))
}

func (b *indexerImpl) NeedsInitialIndexing() (bool, error) {
	data, err := b.index.GetInternal([]byte(resourceName))
	if err != nil {
		return false, err
	}
	return !bytes.Equal([]byte("old"), data), nil
}

func (b *indexerImpl) Search(q *v1.Query, opts ...blevesearch.SearchOption) ([]search.Result, error) {
	defer metrics.SetIndexOperationDurationTime(time.Now(), ops.Search, "VulnerabilityRequest")
	return blevesearch.RunSearchRequest(v1.SearchCategory_VULN_REQUEST, q, b.index, mappings.OptionsMap, opts...)
}
