package querymgr

import (
	"context"

	"github.com/stackrox/rox/central/vulnerabilityrequest/common"
	v1 "github.com/stackrox/rox/generated/api/v1"
	"github.com/stackrox/rox/generated/storage"
)

//go:generate mockgen-wrapper
// VulnReqQueryManager provides functionality to answer derived field queries related to vulnerability requests.
type VulnReqQueryManager interface {
	DeploymentCount(ctx context.Context, requestID string, query *v1.Query) (int, error)
	ImageCount(ctx context.Context, requestID string, query *v1.Query) (int, error)
	Deployments(ctx context.Context, requestID string, query *v1.Query) ([]*storage.Deployment, error)
	Images(ctx context.Context, requestID string, query *v1.Query) ([]*storage.Image, error)
	VulnsWithState(ctx context.Context, scope common.VulnReqScope) (map[string]storage.VulnerabilityState, error)
	EffectiveVulnReq(ctx context.Context, cve string, scope common.VulnReqScope) (*storage.VulnerabilityRequest, error)
}
