package querymgr

import (
	deploymentDataStore "github.com/stackrox/rox/central/deployment/datastore"
	imageDataStore "github.com/stackrox/rox/central/image/datastore"
	"github.com/stackrox/rox/central/vulnerabilityrequest/cache"
	vulnReqDataStore "github.com/stackrox/rox/central/vulnerabilityrequest/datastore"
	"github.com/stackrox/rox/pkg/sync"
)

var (
	once     sync.Once
	instance VulnReqQueryManager
)

func initialize() {
	instance = New(
		deploymentDataStore.Singleton(),
		vulnReqDataStore.Singleton(),
		cache.PendingReqsCacheSingleton(),
		cache.ActiveReqsCacheSingleton(),
		imageDataStore.Singleton(),
	)
}

// New returns new instance of vuln request query manager.
func New(
	deployments deploymentDataStore.DataStore,
	vulnReqs vulnReqDataStore.DataStore,
	pendingVulnReqsCache cache.VulnReqCache,
	activeVulnReqsCache cache.VulnReqCache,
	images imageDataStore.DataStore,
) VulnReqQueryManager {
	return &queryManagerImpl{
		deployments:     deployments,
		images:          images,
		vulnReqs:        vulnReqs,
		pendingReqCache: pendingVulnReqsCache,
		activeReqCache:  activeVulnReqsCache,
	}
}

// Singleton provides the instance of VulnReqQueryManager to query vulnerability requests.
func Singleton() VulnReqQueryManager {
	once.Do(initialize)
	return instance
}
