package requestmgr

import (
	componentCVEEdgeDataStore "github.com/stackrox/rox/central/componentcveedge/datastore"
	cveDataStore "github.com/stackrox/rox/central/cve/datastore"
	deploymentDataStore "github.com/stackrox/rox/central/deployment/datastore"
	imageDataStore "github.com/stackrox/rox/central/image/datastore"
	imageCVEDataStore "github.com/stackrox/rox/central/imagecveedge/datastore"
	"github.com/stackrox/rox/central/reprocessor"
	"github.com/stackrox/rox/central/sensor/service/connection"
	"github.com/stackrox/rox/central/vulnerabilityrequest/cache"
	vulnReqDataStore "github.com/stackrox/rox/central/vulnerabilityrequest/datastore"
	"github.com/stackrox/rox/pkg/concurrency"
	"github.com/stackrox/rox/pkg/env"
	"github.com/stackrox/rox/pkg/features"
	"github.com/stackrox/rox/pkg/logging"
	"github.com/stackrox/rox/pkg/sync"
)

var (
	once     sync.Once
	instance Manager

	log = logging.LoggerForModule()
)

func initialize() {
	instance = New(
		deploymentDataStore.Singleton(),
		vulnReqDataStore.Singleton(),
		cache.PendingReqsCacheSingleton(),
		cache.ActiveReqsCacheSingleton(),
		imageDataStore.Singleton(),
		imageCVEDataStore.Singleton(),
		cveDataStore.Singleton(),
		componentCVEEdgeDataStore.Singleton(),
		connection.ManagerSingleton(),
		reprocessor.Singleton(),
	)
}

// Singleton provides the instance of Manager to use.
func Singleton() Manager {
	if !features.VulnRiskManagement.Enabled() {
		return nil
	}
	once.Do(initialize)
	return instance
}

// New returns an initialized manager, and starts the manager's processing loop in the background.
func New(
	deployments deploymentDataStore.DataStore,
	vulnReqs vulnReqDataStore.DataStore,
	pendingVulnReqsCache cache.VulnReqCache,
	activeVulnReqsCache cache.VulnReqCache,
	images imageDataStore.DataStore,
	imageCVEEdges imageCVEDataStore.DataStore,
	cves cveDataStore.DataStore,
	componentCVEEdges componentCVEEdgeDataStore.DataStore,
	sensorConnMgr connection.Manager,
	reprocessor reprocessor.Loop,
) Manager {
	return &managerImpl{
		deployments:       deployments,
		images:            images,
		imageCVEEdges:     imageCVEEdges,
		cves:              cves,
		componentCVEEdges: componentCVEEdges,
		vulnReqs:          vulnReqs,
		connManager:       sensorConnMgr,
		reprocessor:       reprocessor,
		pendingReqCache:   pendingVulnReqsCache,
		activeReqCache:    activeVulnReqsCache,

		reObserveTimedDeferralsTickerDuration:     env.VulnDeferralTimedReObserveInterval.DurationSetting(),
		reObserveWhenFixedDeferralsTickerDuration: env.VulnDeferralFixableReObserveInterval.DurationSetting(),
		stopSig: concurrency.NewSignal(),
		stopped: concurrency.NewSignal(),
	}
}
