package service

import (
	"context"

	"github.com/stackrox/rox/central/vulnerabilityrequest/datastore"
	"github.com/stackrox/rox/central/vulnerabilityrequest/manager/requestmgr"
	v1 "github.com/stackrox/rox/generated/api/v1"
	"github.com/stackrox/rox/pkg/grpc"
)

// Service provides the interface to the micro-service that serves vulnerability requests data.
type Service interface {
	grpc.APIService

	AuthFuncOverride(ctx context.Context, fullMethodName string) (context.Context, error)

	v1.VulnerabilityRequestServiceServer
}

// New returns a new Service instance using the given DataStore.
func New(datastore datastore.DataStore, manager requestmgr.Manager) Service {
	return &serviceImpl{
		datastore: datastore,
		manager:   manager,
	}
}
