package suppressor

import (
	"github.com/stackrox/rox/central/vulnerabilityrequest/cache"
	"github.com/stackrox/rox/pkg/features"
	"github.com/stackrox/rox/pkg/sync"
)

var (
	once     sync.Once
	instance CVESuppressor
)

func initialize() {
	instance = New(cache.ActiveReqsCacheSingleton())
}

// Singleton provides the instance of CVESuppressor to use.
func Singleton() CVESuppressor {
	if !features.VulnRiskManagement.Enabled() {
		return nil
	}
	once.Do(initialize)
	return instance
}

// New returns an initialized cve suppressor.
func New(cache cache.VulnReqCache) CVESuppressor {
	return &cveSuppressorImpl{
		cache: cache,
	}
}
