// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api/integrations/splunk_service.proto

package integrations

import (
	fmt "fmt"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	storage "github.com/stackrox/rox/generated/storage"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// A new enum is introduced instead of storage.Alert.Violation.Type because
// 1) storage.Alert.Violation.Type does not have an item for PROCESS_EVENT
// 2) default value of storage.Alert.Violation.Type is GENERIC=0 and therefore not serialized to JSON.
type SplunkViolation_ViolationInfo_ViolationType int32

const (
	SplunkViolation_ViolationInfo_UNKNOWN       SplunkViolation_ViolationInfo_ViolationType = 0
	SplunkViolation_ViolationInfo_GENERIC       SplunkViolation_ViolationInfo_ViolationType = 1
	SplunkViolation_ViolationInfo_K8S_EVENT     SplunkViolation_ViolationInfo_ViolationType = 2
	SplunkViolation_ViolationInfo_PROCESS_EVENT SplunkViolation_ViolationInfo_ViolationType = 3
	SplunkViolation_ViolationInfo_NETWORK_FLOW  SplunkViolation_ViolationInfo_ViolationType = 4
)

var SplunkViolation_ViolationInfo_ViolationType_name = map[int32]string{
	0: "UNKNOWN",
	1: "GENERIC",
	2: "K8S_EVENT",
	3: "PROCESS_EVENT",
	4: "NETWORK_FLOW",
}

var SplunkViolation_ViolationInfo_ViolationType_value = map[string]int32{
	"UNKNOWN":       0,
	"GENERIC":       1,
	"K8S_EVENT":     2,
	"PROCESS_EVENT": 3,
	"NETWORK_FLOW":  4,
}

func (x SplunkViolation_ViolationInfo_ViolationType) String() string {
	return proto.EnumName(SplunkViolation_ViolationInfo_ViolationType_name, int32(x))
}

func (SplunkViolation_ViolationInfo_ViolationType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_363fda14f8180d4f, []int{1, 0, 0}
}

// SplunkViolationsResponse is what StackRox Platform returns on the request from Splunk Technology Addon for StackRox.
type SplunkViolationsResponse struct {
	Violations []*SplunkViolation `protobuf:"bytes,1,rep,name=violations,proto3" json:"violations,omitempty"`
	// new_checkpoint sets the checkpoint value for Splunk to use on the next call.
	NewCheckpoint        string   `protobuf:"bytes,6,opt,name=new_checkpoint,json=newCheckpoint,proto3" json:"new_checkpoint,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SplunkViolationsResponse) Reset()         { *m = SplunkViolationsResponse{} }
func (m *SplunkViolationsResponse) String() string { return proto.CompactTextString(m) }
func (*SplunkViolationsResponse) ProtoMessage()    {}
func (*SplunkViolationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_363fda14f8180d4f, []int{0}
}
func (m *SplunkViolationsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SplunkViolationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SplunkViolationsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SplunkViolationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SplunkViolationsResponse.Merge(m, src)
}
func (m *SplunkViolationsResponse) XXX_Size() int {
	return m.Size()
}
func (m *SplunkViolationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SplunkViolationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SplunkViolationsResponse proto.InternalMessageInfo

func (m *SplunkViolationsResponse) GetViolations() []*SplunkViolation {
	if m != nil {
		return m.Violations
	}
	return nil
}

func (m *SplunkViolationsResponse) GetNewCheckpoint() string {
	if m != nil {
		return m.NewCheckpoint
	}
	return ""
}

func (m *SplunkViolationsResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *SplunkViolationsResponse) Clone() *SplunkViolationsResponse {
	if m == nil {
		return nil
	}
	cloned := new(SplunkViolationsResponse)
	*cloned = *m

	if m.Violations != nil {
		cloned.Violations = make([]*SplunkViolation, len(m.Violations))
		for idx, v := range m.Violations {
			cloned.Violations[idx] = v.Clone()
		}
	}
	return cloned
}

// SplunkViolation presents a violation information for Splunk. Essentially, it is a view of data centered around each
// separate violation in storage.Alert structure: storage.Alert.Violation and storage.ProcessIndicator.
// We're not using storage.Alert directly because it will be inconvenient to expose _individual_ violations that way.
// Also, that would unnecessarily couple our Splunk Technology Addon (TA) to internal (storage) data structures of
// StackRox. Given that TA and StackRox Platform are versioned and updated independently, it is safer to work with a
// dedicated data structure for the SackRox-TA API interface, which is this SplunkViolation.
// Note that SplunkViolation still re-uses some definitions from storage where it seemed practical to not reinvent too
// much.
type SplunkViolation struct {
	ViolationInfo *SplunkViolation_ViolationInfo `protobuf:"bytes,1,opt,name=violation_info,json=violationInfo,proto3" json:"violation_info,omitempty"`
	AlertInfo     *SplunkViolation_AlertInfo     `protobuf:"bytes,2,opt,name=alert_info,json=alertInfo,proto3" json:"alert_info,omitempty"`
	ProcessInfo   *SplunkViolation_ProcessInfo   `protobuf:"bytes,3,opt,name=process_info,json=processInfo,proto3" json:"process_info,omitempty"`
	// Types that are valid to be assigned to EntityInfo:
	//	*SplunkViolation_DeploymentInfo_
	//	*SplunkViolation_ResourceInfo_
	EntityInfo isSplunkViolation_EntityInfo `protobuf_oneof:"EntityInfo"`
	PolicyInfo *SplunkViolation_PolicyInfo  `protobuf:"bytes,5,opt,name=policy_info,json=policyInfo,proto3" json:"policy_info,omitempty"`
	// extra details for network violation
	NetworkFlowInfo      *storage.Alert_Violation_NetworkFlowInfo `protobuf:"bytes,6,opt,name=network_flow_info,json=networkFlowInfo,proto3" json:"network_flow_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                 `json:"-"`
	XXX_unrecognized     []byte                                   `json:"-"`
	XXX_sizecache        int32                                    `json:"-"`
}

func (m *SplunkViolation) Reset()         { *m = SplunkViolation{} }
func (m *SplunkViolation) String() string { return proto.CompactTextString(m) }
func (*SplunkViolation) ProtoMessage()    {}
func (*SplunkViolation) Descriptor() ([]byte, []int) {
	return fileDescriptor_363fda14f8180d4f, []int{1}
}
func (m *SplunkViolation) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SplunkViolation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SplunkViolation.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SplunkViolation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SplunkViolation.Merge(m, src)
}
func (m *SplunkViolation) XXX_Size() int {
	return m.Size()
}
func (m *SplunkViolation) XXX_DiscardUnknown() {
	xxx_messageInfo_SplunkViolation.DiscardUnknown(m)
}

var xxx_messageInfo_SplunkViolation proto.InternalMessageInfo

type isSplunkViolation_EntityInfo interface {
	isSplunkViolation_EntityInfo()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isSplunkViolation_EntityInfo
}

type SplunkViolation_DeploymentInfo_ struct {
	DeploymentInfo *SplunkViolation_DeploymentInfo `protobuf:"bytes,4,opt,name=deployment_info,json=deploymentInfo,proto3,oneof" json:"deployment_info,omitempty"`
}
type SplunkViolation_ResourceInfo_ struct {
	ResourceInfo *SplunkViolation_ResourceInfo `protobuf:"bytes,10,opt,name=resource_info,json=resourceInfo,proto3,oneof" json:"resource_info,omitempty"`
}

func (*SplunkViolation_DeploymentInfo_) isSplunkViolation_EntityInfo() {}
func (m *SplunkViolation_DeploymentInfo_) Clone() isSplunkViolation_EntityInfo {
	if m == nil {
		return nil
	}
	cloned := new(SplunkViolation_DeploymentInfo_)
	*cloned = *m

	cloned.DeploymentInfo = m.DeploymentInfo.Clone()
	return cloned
}
func (*SplunkViolation_ResourceInfo_) isSplunkViolation_EntityInfo() {}
func (m *SplunkViolation_ResourceInfo_) Clone() isSplunkViolation_EntityInfo {
	if m == nil {
		return nil
	}
	cloned := new(SplunkViolation_ResourceInfo_)
	*cloned = *m

	cloned.ResourceInfo = m.ResourceInfo.Clone()
	return cloned
}

func (m *SplunkViolation) GetEntityInfo() isSplunkViolation_EntityInfo {
	if m != nil {
		return m.EntityInfo
	}
	return nil
}

func (m *SplunkViolation) GetViolationInfo() *SplunkViolation_ViolationInfo {
	if m != nil {
		return m.ViolationInfo
	}
	return nil
}

func (m *SplunkViolation) GetAlertInfo() *SplunkViolation_AlertInfo {
	if m != nil {
		return m.AlertInfo
	}
	return nil
}

func (m *SplunkViolation) GetProcessInfo() *SplunkViolation_ProcessInfo {
	if m != nil {
		return m.ProcessInfo
	}
	return nil
}

func (m *SplunkViolation) GetDeploymentInfo() *SplunkViolation_DeploymentInfo {
	if x, ok := m.GetEntityInfo().(*SplunkViolation_DeploymentInfo_); ok {
		return x.DeploymentInfo
	}
	return nil
}

func (m *SplunkViolation) GetResourceInfo() *SplunkViolation_ResourceInfo {
	if x, ok := m.GetEntityInfo().(*SplunkViolation_ResourceInfo_); ok {
		return x.ResourceInfo
	}
	return nil
}

func (m *SplunkViolation) GetPolicyInfo() *SplunkViolation_PolicyInfo {
	if m != nil {
		return m.PolicyInfo
	}
	return nil
}

func (m *SplunkViolation) GetNetworkFlowInfo() *storage.Alert_Violation_NetworkFlowInfo {
	if m != nil {
		return m.NetworkFlowInfo
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*SplunkViolation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*SplunkViolation_DeploymentInfo_)(nil),
		(*SplunkViolation_ResourceInfo_)(nil),
	}
}

func (m *SplunkViolation) MessageClone() proto.Message {
	return m.Clone()
}
func (m *SplunkViolation) Clone() *SplunkViolation {
	if m == nil {
		return nil
	}
	cloned := new(SplunkViolation)
	*cloned = *m

	cloned.ViolationInfo = m.ViolationInfo.Clone()
	cloned.AlertInfo = m.AlertInfo.Clone()
	cloned.ProcessInfo = m.ProcessInfo.Clone()
	if m.EntityInfo != nil {
		cloned.EntityInfo = m.EntityInfo.Clone()
	}
	cloned.PolicyInfo = m.PolicyInfo.Clone()
	cloned.NetworkFlowInfo = m.NetworkFlowInfo.Clone()
	return cloned
}

// From storage.Alert.Violation (numbers <100).
type SplunkViolation_ViolationInfo struct {
	// In case of non-Process alerts (k8s and non-runtime), this is surrogate identifier derived from
	// alert_id + crypto_hash(storage.Alert.Violation).
	// In case of Process alerts, this has the same value as ProcessInfo.process_violation_id.
	ViolationId                string                                                `protobuf:"bytes,1,opt,name=violation_id,json=violationId,proto3" json:"violation_id,omitempty"`
	ViolationMessage           string                                                `protobuf:"bytes,2,opt,name=violation_message,json=violationMessage,proto3" json:"violation_message,omitempty"`
	ViolationMessageAttributes []*storage.Alert_Violation_KeyValueAttrs_KeyValueAttr `protobuf:"bytes,3,rep,name=violation_message_attributes,json=violationMessageAttributes,proto3" json:"violation_message_attributes,omitempty"`
	ViolationType              SplunkViolation_ViolationInfo_ViolationType           `protobuf:"varint,4,opt,name=violation_type,json=violationType,proto3,enum=integrations.SplunkViolation_ViolationInfo_ViolationType" json:"violation_type,omitempty"`
	// In case of k8s alerts, this is storage.Alert.Violation.time
	// In case of Process alerts, this is storage.ProcessSignal.process_creation_time
	// In case of other alerts, this is storage.Alert.time
	ViolationTime        *types.Timestamp `protobuf:"bytes,5,opt,name=violation_time,json=violationTime,proto3" json:"violation_time,omitempty"`
	PodId                string           `protobuf:"bytes,102,opt,name=pod_id,json=podId,proto3" json:"pod_id,omitempty"`
	PodUid               string           `protobuf:"bytes,103,opt,name=pod_uid,json=podUid,proto3" json:"pod_uid,omitempty"`
	ContainerName        string           `protobuf:"bytes,104,opt,name=container_name,json=containerName,proto3" json:"container_name,omitempty"`
	ContainerStartTime   *types.Timestamp `protobuf:"bytes,105,opt,name=container_start_time,json=containerStartTime,proto3" json:"container_start_time,omitempty"`
	ContainerId          string           `protobuf:"bytes,106,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *SplunkViolation_ViolationInfo) Reset()         { *m = SplunkViolation_ViolationInfo{} }
func (m *SplunkViolation_ViolationInfo) String() string { return proto.CompactTextString(m) }
func (*SplunkViolation_ViolationInfo) ProtoMessage()    {}
func (*SplunkViolation_ViolationInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_363fda14f8180d4f, []int{1, 0}
}
func (m *SplunkViolation_ViolationInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SplunkViolation_ViolationInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SplunkViolation_ViolationInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SplunkViolation_ViolationInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SplunkViolation_ViolationInfo.Merge(m, src)
}
func (m *SplunkViolation_ViolationInfo) XXX_Size() int {
	return m.Size()
}
func (m *SplunkViolation_ViolationInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_SplunkViolation_ViolationInfo.DiscardUnknown(m)
}

var xxx_messageInfo_SplunkViolation_ViolationInfo proto.InternalMessageInfo

func (m *SplunkViolation_ViolationInfo) GetViolationId() string {
	if m != nil {
		return m.ViolationId
	}
	return ""
}

func (m *SplunkViolation_ViolationInfo) GetViolationMessage() string {
	if m != nil {
		return m.ViolationMessage
	}
	return ""
}

func (m *SplunkViolation_ViolationInfo) GetViolationMessageAttributes() []*storage.Alert_Violation_KeyValueAttrs_KeyValueAttr {
	if m != nil {
		return m.ViolationMessageAttributes
	}
	return nil
}

func (m *SplunkViolation_ViolationInfo) GetViolationType() SplunkViolation_ViolationInfo_ViolationType {
	if m != nil {
		return m.ViolationType
	}
	return SplunkViolation_ViolationInfo_UNKNOWN
}

func (m *SplunkViolation_ViolationInfo) GetViolationTime() *types.Timestamp {
	if m != nil {
		return m.ViolationTime
	}
	return nil
}

func (m *SplunkViolation_ViolationInfo) GetPodId() string {
	if m != nil {
		return m.PodId
	}
	return ""
}

func (m *SplunkViolation_ViolationInfo) GetPodUid() string {
	if m != nil {
		return m.PodUid
	}
	return ""
}

func (m *SplunkViolation_ViolationInfo) GetContainerName() string {
	if m != nil {
		return m.ContainerName
	}
	return ""
}

func (m *SplunkViolation_ViolationInfo) GetContainerStartTime() *types.Timestamp {
	if m != nil {
		return m.ContainerStartTime
	}
	return nil
}

func (m *SplunkViolation_ViolationInfo) GetContainerId() string {
	if m != nil {
		return m.ContainerId
	}
	return ""
}

func (m *SplunkViolation_ViolationInfo) MessageClone() proto.Message {
	return m.Clone()
}
func (m *SplunkViolation_ViolationInfo) Clone() *SplunkViolation_ViolationInfo {
	if m == nil {
		return nil
	}
	cloned := new(SplunkViolation_ViolationInfo)
	*cloned = *m

	if m.ViolationMessageAttributes != nil {
		cloned.ViolationMessageAttributes = make([]*storage.Alert_Violation_KeyValueAttrs_KeyValueAttr, len(m.ViolationMessageAttributes))
		for idx, v := range m.ViolationMessageAttributes {
			cloned.ViolationMessageAttributes[idx] = v.Clone()
		}
	}
	cloned.ViolationTime = m.ViolationTime.Clone()
	cloned.ContainerStartTime = m.ContainerStartTime.Clone()
	return cloned
}

// From storage.Alert
type SplunkViolation_AlertInfo struct {
	AlertId              string                 `protobuf:"bytes,1,opt,name=alert_id,json=alertId,proto3" json:"alert_id,omitempty"`
	LifecycleStage       storage.LifecycleStage `protobuf:"varint,2,opt,name=lifecycle_stage,json=lifecycleStage,proto3,enum=storage.LifecycleStage" json:"lifecycle_stage,omitempty"`
	AlertTags            []string               `protobuf:"bytes,3,rep,name=alert_tags,json=alertTags,proto3" json:"alert_tags,omitempty"`
	AlertFirstOccurred   *types.Timestamp       `protobuf:"bytes,4,opt,name=alert_first_occurred,json=alertFirstOccurred,proto3" json:"alert_first_occurred,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *SplunkViolation_AlertInfo) Reset()         { *m = SplunkViolation_AlertInfo{} }
func (m *SplunkViolation_AlertInfo) String() string { return proto.CompactTextString(m) }
func (*SplunkViolation_AlertInfo) ProtoMessage()    {}
func (*SplunkViolation_AlertInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_363fda14f8180d4f, []int{1, 1}
}
func (m *SplunkViolation_AlertInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SplunkViolation_AlertInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SplunkViolation_AlertInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SplunkViolation_AlertInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SplunkViolation_AlertInfo.Merge(m, src)
}
func (m *SplunkViolation_AlertInfo) XXX_Size() int {
	return m.Size()
}
func (m *SplunkViolation_AlertInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_SplunkViolation_AlertInfo.DiscardUnknown(m)
}

var xxx_messageInfo_SplunkViolation_AlertInfo proto.InternalMessageInfo

func (m *SplunkViolation_AlertInfo) GetAlertId() string {
	if m != nil {
		return m.AlertId
	}
	return ""
}

func (m *SplunkViolation_AlertInfo) GetLifecycleStage() storage.LifecycleStage {
	if m != nil {
		return m.LifecycleStage
	}
	return storage.LifecycleStage_DEPLOY
}

func (m *SplunkViolation_AlertInfo) GetAlertTags() []string {
	if m != nil {
		return m.AlertTags
	}
	return nil
}

func (m *SplunkViolation_AlertInfo) GetAlertFirstOccurred() *types.Timestamp {
	if m != nil {
		return m.AlertFirstOccurred
	}
	return nil
}

func (m *SplunkViolation_AlertInfo) MessageClone() proto.Message {
	return m.Clone()
}
func (m *SplunkViolation_AlertInfo) Clone() *SplunkViolation_AlertInfo {
	if m == nil {
		return nil
	}
	cloned := new(SplunkViolation_AlertInfo)
	*cloned = *m

	if m.AlertTags != nil {
		cloned.AlertTags = make([]string, len(m.AlertTags))
		copy(cloned.AlertTags, m.AlertTags)
	}
	cloned.AlertFirstOccurred = m.AlertFirstOccurred.Clone()
	return cloned
}

// From storage.ProcessIndicator (numbers 1xx) and storage.ProcessSignal (numbers 2xx).
type SplunkViolation_ProcessInfo struct {
	ProcessViolationId  string           `protobuf:"bytes,101,opt,name=process_violation_id,json=processViolationId,proto3" json:"process_violation_id,omitempty"`
	ProcessSignalId     string           `protobuf:"bytes,202,opt,name=process_signal_id,json=processSignalId,proto3" json:"process_signal_id,omitempty"`
	ProcessCreationTime *types.Timestamp `protobuf:"bytes,203,opt,name=process_creation_time,json=processCreationTime,proto3" json:"process_creation_time,omitempty"`
	ProcessName         string           `protobuf:"bytes,204,opt,name=process_name,json=processName,proto3" json:"process_name,omitempty"`
	ProcessArgs         string           `protobuf:"bytes,205,opt,name=process_args,json=processArgs,proto3" json:"process_args,omitempty"`
	ExecFilePath        string           `protobuf:"bytes,206,opt,name=exec_file_path,json=execFilePath,proto3" json:"exec_file_path,omitempty"`
	// UInt32Value is used for pid, process_uid and process_gid instead of plain uint32 to include 0 values on output.
	Pid                  *types.UInt32Value                   `protobuf:"bytes,207,opt,name=pid,proto3" json:"pid,omitempty"`
	ProcessUid           *types.UInt32Value                   `protobuf:"bytes,208,opt,name=process_uid,json=processUid,proto3" json:"process_uid,omitempty"`
	ProcessGid           *types.UInt32Value                   `protobuf:"bytes,209,opt,name=process_gid,json=processGid,proto3" json:"process_gid,omitempty"`
	ProcessLineageInfo   []*storage.ProcessSignal_LineageInfo `protobuf:"bytes,210,rep,name=process_lineage_info,json=processLineageInfo,proto3" json:"process_lineage_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *SplunkViolation_ProcessInfo) Reset()         { *m = SplunkViolation_ProcessInfo{} }
func (m *SplunkViolation_ProcessInfo) String() string { return proto.CompactTextString(m) }
func (*SplunkViolation_ProcessInfo) ProtoMessage()    {}
func (*SplunkViolation_ProcessInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_363fda14f8180d4f, []int{1, 2}
}
func (m *SplunkViolation_ProcessInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SplunkViolation_ProcessInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SplunkViolation_ProcessInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SplunkViolation_ProcessInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SplunkViolation_ProcessInfo.Merge(m, src)
}
func (m *SplunkViolation_ProcessInfo) XXX_Size() int {
	return m.Size()
}
func (m *SplunkViolation_ProcessInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_SplunkViolation_ProcessInfo.DiscardUnknown(m)
}

var xxx_messageInfo_SplunkViolation_ProcessInfo proto.InternalMessageInfo

func (m *SplunkViolation_ProcessInfo) GetProcessViolationId() string {
	if m != nil {
		return m.ProcessViolationId
	}
	return ""
}

func (m *SplunkViolation_ProcessInfo) GetProcessSignalId() string {
	if m != nil {
		return m.ProcessSignalId
	}
	return ""
}

func (m *SplunkViolation_ProcessInfo) GetProcessCreationTime() *types.Timestamp {
	if m != nil {
		return m.ProcessCreationTime
	}
	return nil
}

func (m *SplunkViolation_ProcessInfo) GetProcessName() string {
	if m != nil {
		return m.ProcessName
	}
	return ""
}

func (m *SplunkViolation_ProcessInfo) GetProcessArgs() string {
	if m != nil {
		return m.ProcessArgs
	}
	return ""
}

func (m *SplunkViolation_ProcessInfo) GetExecFilePath() string {
	if m != nil {
		return m.ExecFilePath
	}
	return ""
}

func (m *SplunkViolation_ProcessInfo) GetPid() *types.UInt32Value {
	if m != nil {
		return m.Pid
	}
	return nil
}

func (m *SplunkViolation_ProcessInfo) GetProcessUid() *types.UInt32Value {
	if m != nil {
		return m.ProcessUid
	}
	return nil
}

func (m *SplunkViolation_ProcessInfo) GetProcessGid() *types.UInt32Value {
	if m != nil {
		return m.ProcessGid
	}
	return nil
}

func (m *SplunkViolation_ProcessInfo) GetProcessLineageInfo() []*storage.ProcessSignal_LineageInfo {
	if m != nil {
		return m.ProcessLineageInfo
	}
	return nil
}

func (m *SplunkViolation_ProcessInfo) MessageClone() proto.Message {
	return m.Clone()
}
func (m *SplunkViolation_ProcessInfo) Clone() *SplunkViolation_ProcessInfo {
	if m == nil {
		return nil
	}
	cloned := new(SplunkViolation_ProcessInfo)
	*cloned = *m

	cloned.ProcessCreationTime = m.ProcessCreationTime.Clone()
	cloned.Pid = m.Pid.Clone()
	cloned.ProcessUid = m.ProcessUid.Clone()
	cloned.ProcessGid = m.ProcessGid.Clone()
	if m.ProcessLineageInfo != nil {
		cloned.ProcessLineageInfo = make([]*storage.ProcessSignal_LineageInfo, len(m.ProcessLineageInfo))
		for idx, v := range m.ProcessLineageInfo {
			cloned.ProcessLineageInfo[idx] = v.Clone()
		}
	}
	return cloned
}

// From storage.Alert.Entity: storage.Alert.Deployment (numbers 1xx) and storage.ContainerImage (2xx).
// NOTE: While Deployment in K8S is a resource, we have DeploymentInfo separate from ResourceInfo mainly for
// historical reasons and backwards compatibility. Next time we modify DeploymentInfo/ResourceInfo we should consider
// unifying both and migrating users to ResourceInfo (or even newer object).
type SplunkViolation_DeploymentInfo struct {
	DeploymentId          string                                `protobuf:"bytes,101,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	DeploymentName        string                                `protobuf:"bytes,102,opt,name=deployment_name,json=deploymentName,proto3" json:"deployment_name,omitempty"`
	DeploymentType        string                                `protobuf:"bytes,103,opt,name=deployment_type,json=deploymentType,proto3" json:"deployment_type,omitempty"`
	DeploymentNamespace   string                                `protobuf:"bytes,104,opt,name=deployment_namespace,json=deploymentNamespace,proto3" json:"deployment_namespace,omitempty"`
	DeploymentNamespaceId string                                `protobuf:"bytes,105,opt,name=deployment_namespace_id,json=deploymentNamespaceId,proto3" json:"deployment_namespace_id,omitempty"`
	DeploymentLabels      map[string]string                     `protobuf:"bytes,106,rep,name=deployment_labels,json=deploymentLabels,proto3" json:"deployment_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	ClusterId             string                                `protobuf:"bytes,107,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	ClusterName           string                                `protobuf:"bytes,108,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	DeploymentContainers  []*storage.Alert_Deployment_Container `protobuf:"bytes,109,rep,name=deployment_containers,json=deploymentContainers,proto3" json:"deployment_containers,omitempty"`
	DeploymentAnnotations map[string]string                     `protobuf:"bytes,110,rep,name=deployment_annotations,json=deploymentAnnotations,proto3" json:"deployment_annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	DeploymentImage       *storage.ContainerImage               `protobuf:"bytes,201,opt,name=deployment_image,json=deploymentImage,proto3" json:"deployment_image,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}                              `json:"-"`
	XXX_unrecognized      []byte                                `json:"-"`
	XXX_sizecache         int32                                 `json:"-"`
}

func (m *SplunkViolation_DeploymentInfo) Reset()         { *m = SplunkViolation_DeploymentInfo{} }
func (m *SplunkViolation_DeploymentInfo) String() string { return proto.CompactTextString(m) }
func (*SplunkViolation_DeploymentInfo) ProtoMessage()    {}
func (*SplunkViolation_DeploymentInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_363fda14f8180d4f, []int{1, 3}
}
func (m *SplunkViolation_DeploymentInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SplunkViolation_DeploymentInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SplunkViolation_DeploymentInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SplunkViolation_DeploymentInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SplunkViolation_DeploymentInfo.Merge(m, src)
}
func (m *SplunkViolation_DeploymentInfo) XXX_Size() int {
	return m.Size()
}
func (m *SplunkViolation_DeploymentInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_SplunkViolation_DeploymentInfo.DiscardUnknown(m)
}

var xxx_messageInfo_SplunkViolation_DeploymentInfo proto.InternalMessageInfo

func (m *SplunkViolation_DeploymentInfo) GetDeploymentId() string {
	if m != nil {
		return m.DeploymentId
	}
	return ""
}

func (m *SplunkViolation_DeploymentInfo) GetDeploymentName() string {
	if m != nil {
		return m.DeploymentName
	}
	return ""
}

func (m *SplunkViolation_DeploymentInfo) GetDeploymentType() string {
	if m != nil {
		return m.DeploymentType
	}
	return ""
}

func (m *SplunkViolation_DeploymentInfo) GetDeploymentNamespace() string {
	if m != nil {
		return m.DeploymentNamespace
	}
	return ""
}

func (m *SplunkViolation_DeploymentInfo) GetDeploymentNamespaceId() string {
	if m != nil {
		return m.DeploymentNamespaceId
	}
	return ""
}

func (m *SplunkViolation_DeploymentInfo) GetDeploymentLabels() map[string]string {
	if m != nil {
		return m.DeploymentLabels
	}
	return nil
}

func (m *SplunkViolation_DeploymentInfo) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SplunkViolation_DeploymentInfo) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *SplunkViolation_DeploymentInfo) GetDeploymentContainers() []*storage.Alert_Deployment_Container {
	if m != nil {
		return m.DeploymentContainers
	}
	return nil
}

func (m *SplunkViolation_DeploymentInfo) GetDeploymentAnnotations() map[string]string {
	if m != nil {
		return m.DeploymentAnnotations
	}
	return nil
}

func (m *SplunkViolation_DeploymentInfo) GetDeploymentImage() *storage.ContainerImage {
	if m != nil {
		return m.DeploymentImage
	}
	return nil
}

func (m *SplunkViolation_DeploymentInfo) MessageClone() proto.Message {
	return m.Clone()
}
func (m *SplunkViolation_DeploymentInfo) Clone() *SplunkViolation_DeploymentInfo {
	if m == nil {
		return nil
	}
	cloned := new(SplunkViolation_DeploymentInfo)
	*cloned = *m

	if m.DeploymentLabels != nil {
		cloned.DeploymentLabels = make(map[string]string, len(m.DeploymentLabels))
		for k, v := range m.DeploymentLabels {
			cloned.DeploymentLabels[k] = v
		}
	}
	if m.DeploymentContainers != nil {
		cloned.DeploymentContainers = make([]*storage.Alert_Deployment_Container, len(m.DeploymentContainers))
		for idx, v := range m.DeploymentContainers {
			cloned.DeploymentContainers[idx] = v.Clone()
		}
	}
	if m.DeploymentAnnotations != nil {
		cloned.DeploymentAnnotations = make(map[string]string, len(m.DeploymentAnnotations))
		for k, v := range m.DeploymentAnnotations {
			cloned.DeploymentAnnotations[k] = v
		}
	}
	cloned.DeploymentImage = m.DeploymentImage.Clone()
	return cloned
}

// A trimmed down version of storage.Alert.Resource.
type SplunkViolation_ResourceInfo struct {
	// This is converted from an enum to a string so that it can be properly formatted (capitalized, etc)
	ResourceType         string   `protobuf:"bytes,1,opt,name=resource_type,json=resourceType,proto3" json:"resource_type,omitempty"`
	Name                 string   `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	ClusterId            string   `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	ClusterName          string   `protobuf:"bytes,4,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	Namespace            string   `protobuf:"bytes,5,opt,name=namespace,proto3" json:"namespace,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SplunkViolation_ResourceInfo) Reset()         { *m = SplunkViolation_ResourceInfo{} }
func (m *SplunkViolation_ResourceInfo) String() string { return proto.CompactTextString(m) }
func (*SplunkViolation_ResourceInfo) ProtoMessage()    {}
func (*SplunkViolation_ResourceInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_363fda14f8180d4f, []int{1, 4}
}
func (m *SplunkViolation_ResourceInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SplunkViolation_ResourceInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SplunkViolation_ResourceInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SplunkViolation_ResourceInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SplunkViolation_ResourceInfo.Merge(m, src)
}
func (m *SplunkViolation_ResourceInfo) XXX_Size() int {
	return m.Size()
}
func (m *SplunkViolation_ResourceInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_SplunkViolation_ResourceInfo.DiscardUnknown(m)
}

var xxx_messageInfo_SplunkViolation_ResourceInfo proto.InternalMessageInfo

func (m *SplunkViolation_ResourceInfo) GetResourceType() string {
	if m != nil {
		return m.ResourceType
	}
	return ""
}

func (m *SplunkViolation_ResourceInfo) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SplunkViolation_ResourceInfo) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SplunkViolation_ResourceInfo) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *SplunkViolation_ResourceInfo) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *SplunkViolation_ResourceInfo) MessageClone() proto.Message {
	return m.Clone()
}
func (m *SplunkViolation_ResourceInfo) Clone() *SplunkViolation_ResourceInfo {
	if m == nil {
		return nil
	}
	cloned := new(SplunkViolation_ResourceInfo)
	*cloned = *m

	return cloned
}

// From storage.Policy
type SplunkViolation_PolicyInfo struct {
	PolicyId              string   `protobuf:"bytes,1,opt,name=policy_id,json=policyId,proto3" json:"policy_id,omitempty"`
	PolicyName            string   `protobuf:"bytes,2,opt,name=policy_name,json=policyName,proto3" json:"policy_name,omitempty"`
	PolicyDescription     string   `protobuf:"bytes,3,opt,name=policy_description,json=policyDescription,proto3" json:"policy_description,omitempty"`
	PolicyRationale       string   `protobuf:"bytes,4,opt,name=policy_rationale,json=policyRationale,proto3" json:"policy_rationale,omitempty"`
	PolicyCategories      []string `protobuf:"bytes,5,rep,name=policy_categories,json=policyCategories,proto3" json:"policy_categories,omitempty"`
	PolicyLifecycleStages []string `protobuf:"bytes,6,rep,name=policy_lifecycle_stages,json=policyLifecycleStages,proto3" json:"policy_lifecycle_stages,omitempty"`
	PolicySeverity        string   `protobuf:"bytes,7,opt,name=policy_severity,json=policySeverity,proto3" json:"policy_severity,omitempty"`
	PolicyVersion         string   `protobuf:"bytes,8,opt,name=policy_version,json=policyVersion,proto3" json:"policy_version,omitempty"`
	XXX_NoUnkeyedLiteral  struct{} `json:"-"`
	XXX_unrecognized      []byte   `json:"-"`
	XXX_sizecache         int32    `json:"-"`
}

func (m *SplunkViolation_PolicyInfo) Reset()         { *m = SplunkViolation_PolicyInfo{} }
func (m *SplunkViolation_PolicyInfo) String() string { return proto.CompactTextString(m) }
func (*SplunkViolation_PolicyInfo) ProtoMessage()    {}
func (*SplunkViolation_PolicyInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_363fda14f8180d4f, []int{1, 5}
}
func (m *SplunkViolation_PolicyInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SplunkViolation_PolicyInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SplunkViolation_PolicyInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SplunkViolation_PolicyInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SplunkViolation_PolicyInfo.Merge(m, src)
}
func (m *SplunkViolation_PolicyInfo) XXX_Size() int {
	return m.Size()
}
func (m *SplunkViolation_PolicyInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_SplunkViolation_PolicyInfo.DiscardUnknown(m)
}

var xxx_messageInfo_SplunkViolation_PolicyInfo proto.InternalMessageInfo

func (m *SplunkViolation_PolicyInfo) GetPolicyId() string {
	if m != nil {
		return m.PolicyId
	}
	return ""
}

func (m *SplunkViolation_PolicyInfo) GetPolicyName() string {
	if m != nil {
		return m.PolicyName
	}
	return ""
}

func (m *SplunkViolation_PolicyInfo) GetPolicyDescription() string {
	if m != nil {
		return m.PolicyDescription
	}
	return ""
}

func (m *SplunkViolation_PolicyInfo) GetPolicyRationale() string {
	if m != nil {
		return m.PolicyRationale
	}
	return ""
}

func (m *SplunkViolation_PolicyInfo) GetPolicyCategories() []string {
	if m != nil {
		return m.PolicyCategories
	}
	return nil
}

func (m *SplunkViolation_PolicyInfo) GetPolicyLifecycleStages() []string {
	if m != nil {
		return m.PolicyLifecycleStages
	}
	return nil
}

func (m *SplunkViolation_PolicyInfo) GetPolicySeverity() string {
	if m != nil {
		return m.PolicySeverity
	}
	return ""
}

func (m *SplunkViolation_PolicyInfo) GetPolicyVersion() string {
	if m != nil {
		return m.PolicyVersion
	}
	return ""
}

func (m *SplunkViolation_PolicyInfo) MessageClone() proto.Message {
	return m.Clone()
}
func (m *SplunkViolation_PolicyInfo) Clone() *SplunkViolation_PolicyInfo {
	if m == nil {
		return nil
	}
	cloned := new(SplunkViolation_PolicyInfo)
	*cloned = *m

	if m.PolicyCategories != nil {
		cloned.PolicyCategories = make([]string, len(m.PolicyCategories))
		copy(cloned.PolicyCategories, m.PolicyCategories)
	}
	if m.PolicyLifecycleStages != nil {
		cloned.PolicyLifecycleStages = make([]string, len(m.PolicyLifecycleStages))
		copy(cloned.PolicyLifecycleStages, m.PolicyLifecycleStages)
	}
	return cloned
}

func init() {
	proto.RegisterEnum("integrations.SplunkViolation_ViolationInfo_ViolationType", SplunkViolation_ViolationInfo_ViolationType_name, SplunkViolation_ViolationInfo_ViolationType_value)
	proto.RegisterType((*SplunkViolationsResponse)(nil), "integrations.SplunkViolationsResponse")
	proto.RegisterType((*SplunkViolation)(nil), "integrations.SplunkViolation")
	proto.RegisterType((*SplunkViolation_ViolationInfo)(nil), "integrations.SplunkViolation.ViolationInfo")
	proto.RegisterType((*SplunkViolation_AlertInfo)(nil), "integrations.SplunkViolation.AlertInfo")
	proto.RegisterType((*SplunkViolation_ProcessInfo)(nil), "integrations.SplunkViolation.ProcessInfo")
	proto.RegisterType((*SplunkViolation_DeploymentInfo)(nil), "integrations.SplunkViolation.DeploymentInfo")
	proto.RegisterMapType((map[string]string)(nil), "integrations.SplunkViolation.DeploymentInfo.DeploymentAnnotationsEntry")
	proto.RegisterMapType((map[string]string)(nil), "integrations.SplunkViolation.DeploymentInfo.DeploymentLabelsEntry")
	proto.RegisterType((*SplunkViolation_ResourceInfo)(nil), "integrations.SplunkViolation.ResourceInfo")
	proto.RegisterType((*SplunkViolation_PolicyInfo)(nil), "integrations.SplunkViolation.PolicyInfo")
}

func init() {
	proto.RegisterFile("api/integrations/splunk_service.proto", fileDescriptor_363fda14f8180d4f)
}

var fileDescriptor_363fda14f8180d4f = []byte{
	// 1490 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x57, 0x5d, 0x6f, 0x1b, 0x45,
	0x17, 0xae, 0xf3, 0x59, 0x9f, 0x38, 0x89, 0x33, 0x4d, 0xde, 0xee, 0x6b, 0xda, 0xb4, 0x4d, 0x55,
	0x35, 0xa5, 0xe0, 0x40, 0x2a, 0xa1, 0x82, 0x04, 0x22, 0x71, 0x9d, 0xd6, 0x4a, 0x70, 0xc2, 0xe6,
	0x0b, 0x21, 0x21, 0xb3, 0xd9, 0x1d, 0x3b, 0xd3, 0xac, 0x77, 0x56, 0x33, 0xe3, 0xa4, 0xbe, 0x41,
	0xfc, 0x0c, 0xae, 0xb9, 0xe1, 0x0f, 0xf0, 0x23, 0xf8, 0xa6, 0x80, 0xb8, 0xe0, 0x0e, 0x15, 0x89,
	0xdf, 0x81, 0xe6, 0x63, 0x77, 0x67, 0xdd, 0x36, 0x21, 0xdc, 0x79, 0x9e, 0x73, 0xce, 0xb3, 0x33,
	0x67, 0xce, 0x79, 0xce, 0x18, 0x6e, 0x79, 0x31, 0x59, 0x22, 0x91, 0xc0, 0x1d, 0xe6, 0x09, 0x42,
	0x23, 0xbe, 0xc4, 0xe3, 0xb0, 0x17, 0x1d, 0xb5, 0x38, 0x66, 0xc7, 0xc4, 0xc7, 0xd5, 0x98, 0x51,
	0x41, 0x51, 0xc9, 0x76, 0xa9, 0x5c, 0xeb, 0x50, 0xda, 0x09, 0xf1, 0x92, 0xb2, 0x1d, 0xf4, 0xda,
	0x4b, 0x82, 0x74, 0x31, 0x17, 0x5e, 0x37, 0xd6, 0xee, 0x95, 0xf9, 0x41, 0x87, 0x13, 0xe6, 0xc5,
	0x31, 0x66, 0xdc, 0xd8, 0x2f, 0x71, 0x41, 0x99, 0xd7, 0xc1, 0x4b, 0x5e, 0x88, 0x99, 0x30, 0xa0,
	0x93, 0x80, 0x01, 0x8e, 0x43, 0xda, 0xef, 0xe2, 0x28, 0xb1, 0xcc, 0x26, 0x96, 0x98, 0x86, 0xc4,
	0xef, 0x1b, 0xf4, 0x5a, 0x8a, 0x32, 0xea, 0x63, 0xce, 0x5b, 0x24, 0x0a, 0x88, 0xef, 0x09, 0xca,
	0xb4, 0xc3, 0xc2, 0xe7, 0x05, 0x70, 0xb6, 0xd5, 0x69, 0xf6, 0x08, 0x0d, 0xf5, 0xde, 0x5d, 0xcc,
	0x63, 0x1a, 0x71, 0x8c, 0xde, 0x05, 0x38, 0x4e, 0x51, 0xa7, 0x70, 0x7d, 0x78, 0x71, 0x62, 0xf9,
	0x6a, 0xd5, 0x3e, 0x66, 0x75, 0x20, 0xd6, 0xb5, 0x02, 0xd0, 0x2d, 0x98, 0x8a, 0xf0, 0x49, 0xcb,
	0x3f, 0xc4, 0xfe, 0x51, 0x4c, 0x49, 0x24, 0x9c, 0xb1, 0xeb, 0x85, 0xc5, 0xa2, 0x3b, 0x19, 0xe1,
	0x93, 0x5a, 0x0a, 0x2e, 0xfc, 0x5d, 0x81, 0xe9, 0x01, 0x1a, 0xe4, 0xc2, 0x54, 0x4a, 0xd4, 0x22,
	0x51, 0x9b, 0x3a, 0x85, 0xeb, 0x85, 0xc5, 0x89, 0xe5, 0xbb, 0xa7, 0x7e, 0xbd, 0x9a, 0xfe, 0x6a,
	0x44, 0x6d, 0xea, 0x4e, 0x1e, 0xdb, 0x4b, 0xb4, 0x06, 0xa0, 0x52, 0xa9, 0xf9, 0x86, 0x14, 0xdf,
	0xed, 0xd3, 0xf9, 0x56, 0xa4, 0xbf, 0xe2, 0x2a, 0x7a, 0xc9, 0x4f, 0xb4, 0x01, 0xa5, 0x2c, 0x9b,
	0x6d, 0xea, 0x0c, 0x2b, 0xa6, 0x3b, 0xa7, 0x33, 0x6d, 0xe9, 0x08, 0xc5, 0x35, 0x11, 0x67, 0x0b,
	0xb4, 0x0f, 0xd3, 0xd9, 0x5d, 0x6a, 0xc2, 0x11, 0x45, 0xf8, 0xda, 0xe9, 0x84, 0x0f, 0xd2, 0x20,
	0x49, 0xf3, 0xe8, 0x82, 0x3b, 0x15, 0xe4, 0x10, 0xf4, 0x21, 0x4c, 0x32, 0xcc, 0x69, 0x8f, 0xf9,
	0x58, 0xd3, 0x82, 0xa2, 0x7d, 0xf5, 0x74, 0x5a, 0xd7, 0x84, 0x18, 0xd2, 0x12, 0xb3, 0xd6, 0xa8,
	0x01, 0x13, 0xba, 0xba, 0x34, 0xe1, 0xa8, 0x22, 0x5c, 0x3c, 0xe3, 0xe0, 0x2a, 0x40, 0x9d, 0x1b,
	0xe2, 0xf4, 0x37, 0xda, 0x81, 0x99, 0x08, 0x8b, 0x13, 0xca, 0x8e, 0x5a, 0xed, 0x90, 0x9e, 0x68,
	0xc2, 0x31, 0x43, 0x68, 0x8a, 0x56, 0xa7, 0x3f, 0xbb, 0xd4, 0x6a, 0x53, 0x47, 0xac, 0x85, 0xf4,
	0x44, 0x11, 0x4e, 0x47, 0x79, 0xa0, 0xf2, 0xe5, 0x28, 0x4c, 0xe6, 0x6a, 0x00, 0xdd, 0x80, 0x92,
	0x55, 0x48, 0x81, 0x2a, 0xa3, 0xa2, 0x3b, 0x91, 0x55, 0x46, 0x80, 0xee, 0xc2, 0x4c, 0xe6, 0xd2,
	0xc5, 0x9c, 0x7b, 0x1d, 0xac, 0xca, 0xa3, 0xe8, 0x96, 0x53, 0xc3, 0x07, 0x1a, 0x47, 0x3d, 0xb8,
	0xf2, 0x9c, 0x73, 0xcb, 0x13, 0x82, 0x91, 0x83, 0x9e, 0xc0, 0xdc, 0x19, 0x56, 0x4d, 0x72, 0xef,
	0xa5, 0x47, 0x58, 0xc7, 0xfd, 0x3d, 0x2f, 0xec, 0xe1, 0x15, 0x21, 0x18, 0xcf, 0xad, 0xdc, 0xca,
	0xe0, 0xc7, 0x56, 0x52, 0x5a, 0xf4, 0xa9, 0xdd, 0x0f, 0xa2, 0x1f, 0x63, 0x55, 0x24, 0x53, 0xcb,
	0x6f, 0x9f, 0xa3, 0x1f, 0xb2, 0xd5, 0x4e, 0x3f, 0xc6, 0x56, 0x77, 0xc8, 0x25, 0x5a, 0xc9, 0x7d,
	0x81, 0x74, 0xb1, 0xb9, 0xde, 0x4a, 0x55, 0xeb, 0x54, 0x35, 0xd1, 0xa9, 0xea, 0x4e, 0x22, 0x64,
	0x36, 0x05, 0xe9, 0x62, 0x34, 0x07, 0x63, 0x31, 0x0d, 0x64, 0x96, 0xdb, 0x2a, 0x7b, 0xa3, 0x31,
	0x0d, 0x1a, 0x01, 0xba, 0x0c, 0xe3, 0x12, 0xee, 0x91, 0xc0, 0xe9, 0x28, 0x5c, 0x7a, 0xed, 0x92,
	0x40, 0xea, 0x83, 0x4f, 0x23, 0xe1, 0x91, 0x08, 0xb3, 0x56, 0xe4, 0x75, 0xb1, 0x73, 0xa8, 0xf5,
	0x21, 0x45, 0x9b, 0x5e, 0x17, 0xa3, 0x0d, 0x98, 0xcd, 0xdc, 0xb8, 0xf0, 0x98, 0xd0, 0xfb, 0x23,
	0x67, 0xee, 0x0f, 0xa5, 0x71, 0xdb, 0x32, 0x4c, 0x6d, 0xf2, 0x06, 0x94, 0x32, 0x36, 0x12, 0x38,
	0x8f, 0x75, 0x41, 0xa4, 0x58, 0x23, 0x58, 0xf8, 0xc4, 0x2a, 0x22, 0x95, 0x9b, 0x09, 0x18, 0xdf,
	0x6d, 0xae, 0x37, 0x37, 0xf7, 0x9b, 0xe5, 0x0b, 0x72, 0xf1, 0xb0, 0xde, 0xac, 0xbb, 0x8d, 0x5a,
	0xb9, 0x80, 0x26, 0xa1, 0xb8, 0x7e, 0x7f, 0xbb, 0x55, 0xdf, 0xab, 0x37, 0x77, 0xca, 0x43, 0x68,
	0x06, 0x26, 0xb7, 0xdc, 0xcd, 0x5a, 0x7d, 0x3b, 0x81, 0x86, 0x51, 0x19, 0x4a, 0xcd, 0xfa, 0xce,
	0xfe, 0xa6, 0xbb, 0xde, 0x5a, 0xdb, 0xd8, 0xdc, 0x2f, 0x8f, 0x54, 0x7e, 0x2f, 0x40, 0x31, 0x15,
	0x16, 0xf4, 0x7f, 0xb8, 0x68, 0x54, 0x29, 0x29, 0xce, 0x71, 0x2d, 0x35, 0x01, 0x7a, 0x1f, 0xa6,
	0x43, 0xd2, 0xc6, 0x7e, 0xdf, 0x0f, 0xb1, 0x3c, 0xb8, 0x29, 0xcb, 0xa9, 0xe5, 0xcb, 0x69, 0x79,
	0x6d, 0x24, 0xf6, 0x6d, 0x69, 0x76, 0xa7, 0xc2, 0xdc, 0x1a, 0x5d, 0x4d, 0x24, 0x4f, 0x78, 0x1d,
	0x5d, 0x9b, 0x45, 0xa3, 0x64, 0x3b, 0x5e, 0x87, 0xcb, 0xcc, 0x6a, 0x73, 0x9b, 0x30, 0x2e, 0x5a,
	0xd4, 0xf7, 0x7b, 0x8c, 0xe1, 0xc0, 0x08, 0xd0, 0xa9, 0x99, 0x55, 0x71, 0x6b, 0x32, 0x6c, 0xd3,
	0x44, 0x55, 0xbe, 0x1e, 0x81, 0x09, 0x4b, 0xe6, 0xd0, 0x1b, 0x30, 0x9b, 0xe8, 0x64, 0xae, 0x05,
	0xb1, 0x3a, 0x25, 0x32, 0xb6, 0xbd, 0x7c, 0x27, 0x26, 0x11, 0x9c, 0x74, 0x22, 0x2f, 0x94, 0xee,
	0xdf, 0xe9, 0xac, 0x4c, 0x1b, 0xcb, 0xb6, 0x32, 0x34, 0x02, 0xb4, 0x09, 0x73, 0x89, 0xb3, 0xcf,
	0xb0, 0x55, 0xb7, 0xdf, 0x17, 0xce, 0xdc, 0xfe, 0x25, 0x13, 0x59, 0x33, 0x81, 0xaa, 0x32, 0x16,
	0x32, 0x5d, 0x57, 0xc5, 0xf8, 0x83, 0xd1, 0x0a, 0x03, 0xaa, 0x5a, 0xb4, 0x7c, 0x3c, 0xd6, 0xe1,
	0xce, 0x8f, 0x79, 0x9f, 0x15, 0xd6, 0x51, 0x63, 0x0f, 0x3f, 0xc1, 0x7e, 0xab, 0x4d, 0x42, 0xdc,
	0x8a, 0x3d, 0x71, 0xe8, 0xfc, 0xa4, 0xbd, 0x4a, 0x12, 0x5e, 0x23, 0x21, 0xde, 0xf2, 0xc4, 0x21,
	0x5a, 0x82, 0xe1, 0x98, 0x04, 0xce, 0xcf, 0x7a, 0xb7, 0x57, 0x9e, 0xdb, 0xed, 0x6e, 0x23, 0x12,
	0xf7, 0x96, 0x95, 0x3c, 0xb8, 0xd2, 0x13, 0xbd, 0x07, 0xc9, 0x67, 0x54, 0x2f, 0x3d, 0xfd, 0x37,
	0x81, 0x60, 0x22, 0x76, 0xf3, 0xf1, 0x1d, 0x12, 0x38, 0xbf, 0x9c, 0x27, 0xfe, 0x21, 0x09, 0xd0,
	0x6e, 0x76, 0x9f, 0x21, 0x89, 0xb0, 0x14, 0x3e, 0xa5, 0xda, 0xbf, 0xea, 0x87, 0xc1, 0x42, 0x5a,
	0x94, 0x5b, 0xf6, 0x4d, 0x55, 0x37, 0xb4, 0xaf, 0x12, 0xec, 0xe4, 0xd2, 0x2d, 0xac, 0xf2, 0xdb,
	0x18, 0x4c, 0xe5, 0x87, 0x19, 0xba, 0x09, 0x93, 0xf6, 0x4c, 0x4c, 0x4a, 0xa6, 0x64, 0x4d, 0xb8,
	0x00, 0xdd, 0xce, 0x0d, 0x4e, 0x75, 0x63, 0x5a, 0x76, 0xac, 0x41, 0xa8, 0xee, 0x2c, 0xef, 0xa8,
	0xc4, 0xb3, 0x33, 0xe8, 0xa8, 0xda, 0xfc, 0x4d, 0x98, 0x1d, 0x60, 0xe4, 0xb1, 0xe7, 0x27, 0xaa,
	0x74, 0x29, 0x4f, 0xab, 0x4c, 0xe8, 0x2d, 0xb8, 0xfc, 0xa2, 0x10, 0xb9, 0x67, 0xa2, 0xa2, 0xe6,
	0x5e, 0x10, 0xd5, 0x08, 0x10, 0x85, 0x19, 0x2b, 0x2e, 0xf4, 0x0e, 0x70, 0xc8, 0x9d, 0xc7, 0x2a,
	0x8f, 0xab, 0xe7, 0x99, 0xfb, 0xd6, 0x72, 0x43, 0x91, 0xd4, 0x23, 0xc1, 0xfa, 0x6e, 0x39, 0x18,
	0x80, 0xa5, 0x12, 0xf8, 0x61, 0x8f, 0x0b, 0x2d, 0x7a, 0x47, 0x6a, 0x6f, 0x45, 0x83, 0x34, 0x02,
	0xa5, 0x8a, 0xc6, 0xac, 0x32, 0x19, 0x1a, 0x55, 0xd4, 0x98, 0x4a, 0xe3, 0x47, 0x60, 0x9d, 0xa5,
	0x95, 0xea, 0x25, 0x77, 0xba, 0x6a, 0xdb, 0x37, 0x07, 0x46, 0x5e, 0xb6, 0xb1, 0x6a, 0x2d, 0xf1,
	0x75, 0xad, 0xfc, 0xa6, 0x20, 0x47, 0x9f, 0xc1, 0xff, 0x2c, 0x66, 0x2f, 0x8a, 0xa8, 0x30, 0x4f,
	0xce, 0x48, 0x51, 0x3f, 0xfc, 0x8f, 0x19, 0x59, 0xc9, 0x98, 0x74, 0x5a, 0xac, 0x03, 0x58, 0x36,
	0x54, 0x83, 0xb2, 0x5d, 0x6e, 0x5d, 0x29, 0xb4, 0xdf, 0xea, 0xee, 0xc8, 0x94, 0x36, 0xdd, 0x6f,
	0x43, 0xda, 0x5d, 0xab, 0xa4, 0x14, 0x50, 0xa9, 0xc1, 0xdc, 0x0b, 0xef, 0x02, 0x95, 0x61, 0xf8,
	0x08, 0xf7, 0x8d, 0xb6, 0xcb, 0x9f, 0x68, 0x16, 0x46, 0x8f, 0x65, 0x77, 0x99, 0x47, 0x86, 0x5e,
	0xbc, 0x33, 0x74, 0xbf, 0x50, 0x79, 0x04, 0x95, 0x97, 0x6f, 0xff, 0x5c, 0x4c, 0x5f, 0x15, 0xa0,
	0x64, 0xbf, 0xe5, 0x64, 0x4f, 0xa5, 0xcf, 0x41, 0xd5, 0x03, 0x46, 0x93, 0x12, 0x50, 0x75, 0x00,
	0x82, 0x11, 0x75, 0xfd, 0x9a, 0x4e, 0xfd, 0x1e, 0xa8, 0x9c, 0xe1, 0xb3, 0x2a, 0x67, 0xe4, 0xf9,
	0xca, 0xb9, 0x02, 0xc5, 0xac, 0x99, 0x46, 0x35, 0x41, 0x0a, 0x54, 0xfe, 0x18, 0x02, 0xc8, 0x1e,
	0x89, 0xe8, 0x15, 0x28, 0x26, 0x6f, 0xcc, 0x64, 0x20, 0x5e, 0x34, 0xef, 0xc6, 0x00, 0x5d, 0x4b,
	0x1f, 0xa0, 0xd6, 0x36, 0xcd, 0xb3, 0x52, 0x7d, 0xea, 0x75, 0x40, 0xc6, 0x21, 0xc0, 0xdc, 0x67,
	0x24, 0x96, 0xe9, 0x33, 0x9b, 0x9e, 0xd1, 0x96, 0x07, 0x99, 0x01, 0xdd, 0x81, 0xb2, 0x71, 0xd7,
	0xc5, 0xe5, 0x85, 0xc9, 0x01, 0xa6, 0x35, 0xee, 0x26, 0xb0, 0x9a, 0x4d, 0xda, 0xd5, 0xf7, 0x04,
	0xee, 0x50, 0x46, 0x30, 0x77, 0x46, 0xd5, 0x44, 0x35, 0x1c, 0xb5, 0x14, 0x97, 0xb2, 0x60, 0x9c,
	0x07, 0x06, 0x38, 0x77, 0xc6, 0x54, 0xc8, 0x9c, 0x36, 0xe7, 0xc7, 0x37, 0x97, 0x52, 0x65, 0xe2,
	0x38, 0x3e, 0xc6, 0x8c, 0x88, 0xbe, 0x33, 0xae, 0xa5, 0x4a, 0xc3, 0xdb, 0x06, 0x95, 0x33, 0xc6,
	0x38, 0x1e, 0x63, 0xc6, 0xe5, 0x19, 0x2f, 0xea, 0xa7, 0x93, 0x46, 0xf7, 0x34, 0xb8, 0x5a, 0x02,
	0xa8, 0x47, 0x82, 0x08, 0x95, 0xda, 0xd5, 0xd5, 0x6f, 0x9e, 0xcd, 0x17, 0x9e, 0x3e, 0x9b, 0x2f,
	0xfc, 0xf9, 0x6c, 0xbe, 0xf0, 0xc5, 0x5f, 0xf3, 0x17, 0x60, 0x81, 0xd0, 0x2a, 0x17, 0x9e, 0x7f,
	0xc4, 0xe8, 0x13, 0x3d, 0x00, 0xaa, 0x5e, 0x4c, 0x72, 0xed, 0xf6, 0x71, 0xee, 0x6f, 0xed, 0xc1,
	0x98, 0xf2, 0xba, 0xf7, 0x4f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x51, 0x11, 0xec, 0x68, 0x14, 0x0f,
	0x00, 0x00,
}

func (m *SplunkViolationsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SplunkViolationsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SplunkViolationsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.NewCheckpoint) > 0 {
		i -= len(m.NewCheckpoint)
		copy(dAtA[i:], m.NewCheckpoint)
		i = encodeVarintSplunkService(dAtA, i, uint64(len(m.NewCheckpoint)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.Violations) > 0 {
		for iNdEx := len(m.Violations) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Violations[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintSplunkService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *SplunkViolation) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SplunkViolation) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SplunkViolation) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.EntityInfo != nil {
		{
			size := m.EntityInfo.Size()
			i -= size
			if _, err := m.EntityInfo.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.NetworkFlowInfo != nil {
		{
			size, err := m.NetworkFlowInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSplunkService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.PolicyInfo != nil {
		{
			size, err := m.PolicyInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSplunkService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.ProcessInfo != nil {
		{
			size, err := m.ProcessInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSplunkService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.AlertInfo != nil {
		{
			size, err := m.AlertInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSplunkService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.ViolationInfo != nil {
		{
			size, err := m.ViolationInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSplunkService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SplunkViolation_DeploymentInfo_) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SplunkViolation_DeploymentInfo_) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.DeploymentInfo != nil {
		{
			size, err := m.DeploymentInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSplunkService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	return len(dAtA) - i, nil
}
func (m *SplunkViolation_ResourceInfo_) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SplunkViolation_ResourceInfo_) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ResourceInfo != nil {
		{
			size, err := m.ResourceInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSplunkService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	return len(dAtA) - i, nil
}
func (m *SplunkViolation_ViolationInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SplunkViolation_ViolationInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SplunkViolation_ViolationInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintSplunkService(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xd2
	}
	if m.ContainerStartTime != nil {
		{
			size, err := m.ContainerStartTime.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSplunkService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xca
	}
	if len(m.ContainerName) > 0 {
		i -= len(m.ContainerName)
		copy(dAtA[i:], m.ContainerName)
		i = encodeVarintSplunkService(dAtA, i, uint64(len(m.ContainerName)))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xc2
	}
	if len(m.PodUid) > 0 {
		i -= len(m.PodUid)
		copy(dAtA[i:], m.PodUid)
		i = encodeVarintSplunkService(dAtA, i, uint64(len(m.PodUid)))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xba
	}
	if len(m.PodId) > 0 {
		i -= len(m.PodId)
		copy(dAtA[i:], m.PodId)
		i = encodeVarintSplunkService(dAtA, i, uint64(len(m.PodId)))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xb2
	}
	if m.ViolationTime != nil {
		{
			size, err := m.ViolationTime.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSplunkService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.ViolationType != 0 {
		i = encodeVarintSplunkService(dAtA, i, uint64(m.ViolationType))
		i--
		dAtA[i] = 0x20
	}
	if len(m.ViolationMessageAttributes) > 0 {
		for iNdEx := len(m.ViolationMessageAttributes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ViolationMessageAttributes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintSplunkService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.ViolationMessage) > 0 {
		i -= len(m.ViolationMessage)
		copy(dAtA[i:], m.ViolationMessage)
		i = encodeVarintSplunkService(dAtA, i, uint64(len(m.ViolationMessage)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ViolationId) > 0 {
		i -= len(m.ViolationId)
		copy(dAtA[i:], m.ViolationId)
		i = encodeVarintSplunkService(dAtA, i, uint64(len(m.ViolationId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SplunkViolation_AlertInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SplunkViolation_AlertInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SplunkViolation_AlertInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.AlertFirstOccurred != nil {
		{
			size, err := m.AlertFirstOccurred.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSplunkService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.AlertTags) > 0 {
		for iNdEx := len(m.AlertTags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.AlertTags[iNdEx])
			copy(dAtA[i:], m.AlertTags[iNdEx])
			i = encodeVarintSplunkService(dAtA, i, uint64(len(m.AlertTags[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.LifecycleStage != 0 {
		i = encodeVarintSplunkService(dAtA, i, uint64(m.LifecycleStage))
		i--
		dAtA[i] = 0x10
	}
	if len(m.AlertId) > 0 {
		i -= len(m.AlertId)
		copy(dAtA[i:], m.AlertId)
		i = encodeVarintSplunkService(dAtA, i, uint64(len(m.AlertId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SplunkViolation_ProcessInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SplunkViolation_ProcessInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SplunkViolation_ProcessInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ProcessLineageInfo) > 0 {
		for iNdEx := len(m.ProcessLineageInfo) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ProcessLineageInfo[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintSplunkService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xd
			i--
			dAtA[i] = 0x92
		}
	}
	if m.ProcessGid != nil {
		{
			size, err := m.ProcessGid.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSplunkService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xd
		i--
		dAtA[i] = 0x8a
	}
	if m.ProcessUid != nil {
		{
			size, err := m.ProcessUid.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSplunkService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xd
		i--
		dAtA[i] = 0x82
	}
	if m.Pid != nil {
		{
			size, err := m.Pid.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSplunkService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xc
		i--
		dAtA[i] = 0xfa
	}
	if len(m.ExecFilePath) > 0 {
		i -= len(m.ExecFilePath)
		copy(dAtA[i:], m.ExecFilePath)
		i = encodeVarintSplunkService(dAtA, i, uint64(len(m.ExecFilePath)))
		i--
		dAtA[i] = 0xc
		i--
		dAtA[i] = 0xf2
	}
	if len(m.ProcessArgs) > 0 {
		i -= len(m.ProcessArgs)
		copy(dAtA[i:], m.ProcessArgs)
		i = encodeVarintSplunkService(dAtA, i, uint64(len(m.ProcessArgs)))
		i--
		dAtA[i] = 0xc
		i--
		dAtA[i] = 0xea
	}
	if len(m.ProcessName) > 0 {
		i -= len(m.ProcessName)
		copy(dAtA[i:], m.ProcessName)
		i = encodeVarintSplunkService(dAtA, i, uint64(len(m.ProcessName)))
		i--
		dAtA[i] = 0xc
		i--
		dAtA[i] = 0xe2
	}
	if m.ProcessCreationTime != nil {
		{
			size, err := m.ProcessCreationTime.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSplunkService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xc
		i--
		dAtA[i] = 0xda
	}
	if len(m.ProcessSignalId) > 0 {
		i -= len(m.ProcessSignalId)
		copy(dAtA[i:], m.ProcessSignalId)
		i = encodeVarintSplunkService(dAtA, i, uint64(len(m.ProcessSignalId)))
		i--
		dAtA[i] = 0xc
		i--
		dAtA[i] = 0xd2
	}
	if len(m.ProcessViolationId) > 0 {
		i -= len(m.ProcessViolationId)
		copy(dAtA[i:], m.ProcessViolationId)
		i = encodeVarintSplunkService(dAtA, i, uint64(len(m.ProcessViolationId)))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xaa
	}
	return len(dAtA) - i, nil
}

func (m *SplunkViolation_DeploymentInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SplunkViolation_DeploymentInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SplunkViolation_DeploymentInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.DeploymentImage != nil {
		{
			size, err := m.DeploymentImage.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSplunkService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xc
		i--
		dAtA[i] = 0xca
	}
	if len(m.DeploymentAnnotations) > 0 {
		for k := range m.DeploymentAnnotations {
			v := m.DeploymentAnnotations[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintSplunkService(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintSplunkService(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintSplunkService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x6
			i--
			dAtA[i] = 0xf2
		}
	}
	if len(m.DeploymentContainers) > 0 {
		for iNdEx := len(m.DeploymentContainers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.DeploymentContainers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintSplunkService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x6
			i--
			dAtA[i] = 0xea
		}
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintSplunkService(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xe2
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintSplunkService(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xda
	}
	if len(m.DeploymentLabels) > 0 {
		for k := range m.DeploymentLabels {
			v := m.DeploymentLabels[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintSplunkService(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintSplunkService(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintSplunkService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x6
			i--
			dAtA[i] = 0xd2
		}
	}
	if len(m.DeploymentNamespaceId) > 0 {
		i -= len(m.DeploymentNamespaceId)
		copy(dAtA[i:], m.DeploymentNamespaceId)
		i = encodeVarintSplunkService(dAtA, i, uint64(len(m.DeploymentNamespaceId)))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xca
	}
	if len(m.DeploymentNamespace) > 0 {
		i -= len(m.DeploymentNamespace)
		copy(dAtA[i:], m.DeploymentNamespace)
		i = encodeVarintSplunkService(dAtA, i, uint64(len(m.DeploymentNamespace)))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xc2
	}
	if len(m.DeploymentType) > 0 {
		i -= len(m.DeploymentType)
		copy(dAtA[i:], m.DeploymentType)
		i = encodeVarintSplunkService(dAtA, i, uint64(len(m.DeploymentType)))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xba
	}
	if len(m.DeploymentName) > 0 {
		i -= len(m.DeploymentName)
		copy(dAtA[i:], m.DeploymentName)
		i = encodeVarintSplunkService(dAtA, i, uint64(len(m.DeploymentName)))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xb2
	}
	if len(m.DeploymentId) > 0 {
		i -= len(m.DeploymentId)
		copy(dAtA[i:], m.DeploymentId)
		i = encodeVarintSplunkService(dAtA, i, uint64(len(m.DeploymentId)))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xaa
	}
	return len(dAtA) - i, nil
}

func (m *SplunkViolation_ResourceInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SplunkViolation_ResourceInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SplunkViolation_ResourceInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintSplunkService(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.ClusterName) > 0 {
		i -= len(m.ClusterName)
		copy(dAtA[i:], m.ClusterName)
		i = encodeVarintSplunkService(dAtA, i, uint64(len(m.ClusterName)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintSplunkService(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintSplunkService(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ResourceType) > 0 {
		i -= len(m.ResourceType)
		copy(dAtA[i:], m.ResourceType)
		i = encodeVarintSplunkService(dAtA, i, uint64(len(m.ResourceType)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SplunkViolation_PolicyInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SplunkViolation_PolicyInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SplunkViolation_PolicyInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.PolicyVersion) > 0 {
		i -= len(m.PolicyVersion)
		copy(dAtA[i:], m.PolicyVersion)
		i = encodeVarintSplunkService(dAtA, i, uint64(len(m.PolicyVersion)))
		i--
		dAtA[i] = 0x42
	}
	if len(m.PolicySeverity) > 0 {
		i -= len(m.PolicySeverity)
		copy(dAtA[i:], m.PolicySeverity)
		i = encodeVarintSplunkService(dAtA, i, uint64(len(m.PolicySeverity)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.PolicyLifecycleStages) > 0 {
		for iNdEx := len(m.PolicyLifecycleStages) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.PolicyLifecycleStages[iNdEx])
			copy(dAtA[i:], m.PolicyLifecycleStages[iNdEx])
			i = encodeVarintSplunkService(dAtA, i, uint64(len(m.PolicyLifecycleStages[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.PolicyCategories) > 0 {
		for iNdEx := len(m.PolicyCategories) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.PolicyCategories[iNdEx])
			copy(dAtA[i:], m.PolicyCategories[iNdEx])
			i = encodeVarintSplunkService(dAtA, i, uint64(len(m.PolicyCategories[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.PolicyRationale) > 0 {
		i -= len(m.PolicyRationale)
		copy(dAtA[i:], m.PolicyRationale)
		i = encodeVarintSplunkService(dAtA, i, uint64(len(m.PolicyRationale)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.PolicyDescription) > 0 {
		i -= len(m.PolicyDescription)
		copy(dAtA[i:], m.PolicyDescription)
		i = encodeVarintSplunkService(dAtA, i, uint64(len(m.PolicyDescription)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.PolicyName) > 0 {
		i -= len(m.PolicyName)
		copy(dAtA[i:], m.PolicyName)
		i = encodeVarintSplunkService(dAtA, i, uint64(len(m.PolicyName)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.PolicyId) > 0 {
		i -= len(m.PolicyId)
		copy(dAtA[i:], m.PolicyId)
		i = encodeVarintSplunkService(dAtA, i, uint64(len(m.PolicyId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintSplunkService(dAtA []byte, offset int, v uint64) int {
	offset -= sovSplunkService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *SplunkViolationsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Violations) > 0 {
		for _, e := range m.Violations {
			l = e.Size()
			n += 1 + l + sovSplunkService(uint64(l))
		}
	}
	l = len(m.NewCheckpoint)
	if l > 0 {
		n += 1 + l + sovSplunkService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SplunkViolation) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ViolationInfo != nil {
		l = m.ViolationInfo.Size()
		n += 1 + l + sovSplunkService(uint64(l))
	}
	if m.AlertInfo != nil {
		l = m.AlertInfo.Size()
		n += 1 + l + sovSplunkService(uint64(l))
	}
	if m.ProcessInfo != nil {
		l = m.ProcessInfo.Size()
		n += 1 + l + sovSplunkService(uint64(l))
	}
	if m.EntityInfo != nil {
		n += m.EntityInfo.Size()
	}
	if m.PolicyInfo != nil {
		l = m.PolicyInfo.Size()
		n += 1 + l + sovSplunkService(uint64(l))
	}
	if m.NetworkFlowInfo != nil {
		l = m.NetworkFlowInfo.Size()
		n += 1 + l + sovSplunkService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SplunkViolation_DeploymentInfo_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.DeploymentInfo != nil {
		l = m.DeploymentInfo.Size()
		n += 1 + l + sovSplunkService(uint64(l))
	}
	return n
}
func (m *SplunkViolation_ResourceInfo_) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ResourceInfo != nil {
		l = m.ResourceInfo.Size()
		n += 1 + l + sovSplunkService(uint64(l))
	}
	return n
}
func (m *SplunkViolation_ViolationInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ViolationId)
	if l > 0 {
		n += 1 + l + sovSplunkService(uint64(l))
	}
	l = len(m.ViolationMessage)
	if l > 0 {
		n += 1 + l + sovSplunkService(uint64(l))
	}
	if len(m.ViolationMessageAttributes) > 0 {
		for _, e := range m.ViolationMessageAttributes {
			l = e.Size()
			n += 1 + l + sovSplunkService(uint64(l))
		}
	}
	if m.ViolationType != 0 {
		n += 1 + sovSplunkService(uint64(m.ViolationType))
	}
	if m.ViolationTime != nil {
		l = m.ViolationTime.Size()
		n += 1 + l + sovSplunkService(uint64(l))
	}
	l = len(m.PodId)
	if l > 0 {
		n += 2 + l + sovSplunkService(uint64(l))
	}
	l = len(m.PodUid)
	if l > 0 {
		n += 2 + l + sovSplunkService(uint64(l))
	}
	l = len(m.ContainerName)
	if l > 0 {
		n += 2 + l + sovSplunkService(uint64(l))
	}
	if m.ContainerStartTime != nil {
		l = m.ContainerStartTime.Size()
		n += 2 + l + sovSplunkService(uint64(l))
	}
	l = len(m.ContainerId)
	if l > 0 {
		n += 2 + l + sovSplunkService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SplunkViolation_AlertInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.AlertId)
	if l > 0 {
		n += 1 + l + sovSplunkService(uint64(l))
	}
	if m.LifecycleStage != 0 {
		n += 1 + sovSplunkService(uint64(m.LifecycleStage))
	}
	if len(m.AlertTags) > 0 {
		for _, s := range m.AlertTags {
			l = len(s)
			n += 1 + l + sovSplunkService(uint64(l))
		}
	}
	if m.AlertFirstOccurred != nil {
		l = m.AlertFirstOccurred.Size()
		n += 1 + l + sovSplunkService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SplunkViolation_ProcessInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ProcessViolationId)
	if l > 0 {
		n += 2 + l + sovSplunkService(uint64(l))
	}
	l = len(m.ProcessSignalId)
	if l > 0 {
		n += 2 + l + sovSplunkService(uint64(l))
	}
	if m.ProcessCreationTime != nil {
		l = m.ProcessCreationTime.Size()
		n += 2 + l + sovSplunkService(uint64(l))
	}
	l = len(m.ProcessName)
	if l > 0 {
		n += 2 + l + sovSplunkService(uint64(l))
	}
	l = len(m.ProcessArgs)
	if l > 0 {
		n += 2 + l + sovSplunkService(uint64(l))
	}
	l = len(m.ExecFilePath)
	if l > 0 {
		n += 2 + l + sovSplunkService(uint64(l))
	}
	if m.Pid != nil {
		l = m.Pid.Size()
		n += 2 + l + sovSplunkService(uint64(l))
	}
	if m.ProcessUid != nil {
		l = m.ProcessUid.Size()
		n += 2 + l + sovSplunkService(uint64(l))
	}
	if m.ProcessGid != nil {
		l = m.ProcessGid.Size()
		n += 2 + l + sovSplunkService(uint64(l))
	}
	if len(m.ProcessLineageInfo) > 0 {
		for _, e := range m.ProcessLineageInfo {
			l = e.Size()
			n += 2 + l + sovSplunkService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SplunkViolation_DeploymentInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DeploymentId)
	if l > 0 {
		n += 2 + l + sovSplunkService(uint64(l))
	}
	l = len(m.DeploymentName)
	if l > 0 {
		n += 2 + l + sovSplunkService(uint64(l))
	}
	l = len(m.DeploymentType)
	if l > 0 {
		n += 2 + l + sovSplunkService(uint64(l))
	}
	l = len(m.DeploymentNamespace)
	if l > 0 {
		n += 2 + l + sovSplunkService(uint64(l))
	}
	l = len(m.DeploymentNamespaceId)
	if l > 0 {
		n += 2 + l + sovSplunkService(uint64(l))
	}
	if len(m.DeploymentLabels) > 0 {
		for k, v := range m.DeploymentLabels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovSplunkService(uint64(len(k))) + 1 + len(v) + sovSplunkService(uint64(len(v)))
			n += mapEntrySize + 2 + sovSplunkService(uint64(mapEntrySize))
		}
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 2 + l + sovSplunkService(uint64(l))
	}
	l = len(m.ClusterName)
	if l > 0 {
		n += 2 + l + sovSplunkService(uint64(l))
	}
	if len(m.DeploymentContainers) > 0 {
		for _, e := range m.DeploymentContainers {
			l = e.Size()
			n += 2 + l + sovSplunkService(uint64(l))
		}
	}
	if len(m.DeploymentAnnotations) > 0 {
		for k, v := range m.DeploymentAnnotations {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovSplunkService(uint64(len(k))) + 1 + len(v) + sovSplunkService(uint64(len(v)))
			n += mapEntrySize + 2 + sovSplunkService(uint64(mapEntrySize))
		}
	}
	if m.DeploymentImage != nil {
		l = m.DeploymentImage.Size()
		n += 2 + l + sovSplunkService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SplunkViolation_ResourceInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ResourceType)
	if l > 0 {
		n += 1 + l + sovSplunkService(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovSplunkService(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovSplunkService(uint64(l))
	}
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovSplunkService(uint64(l))
	}
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovSplunkService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SplunkViolation_PolicyInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.PolicyId)
	if l > 0 {
		n += 1 + l + sovSplunkService(uint64(l))
	}
	l = len(m.PolicyName)
	if l > 0 {
		n += 1 + l + sovSplunkService(uint64(l))
	}
	l = len(m.PolicyDescription)
	if l > 0 {
		n += 1 + l + sovSplunkService(uint64(l))
	}
	l = len(m.PolicyRationale)
	if l > 0 {
		n += 1 + l + sovSplunkService(uint64(l))
	}
	if len(m.PolicyCategories) > 0 {
		for _, s := range m.PolicyCategories {
			l = len(s)
			n += 1 + l + sovSplunkService(uint64(l))
		}
	}
	if len(m.PolicyLifecycleStages) > 0 {
		for _, s := range m.PolicyLifecycleStages {
			l = len(s)
			n += 1 + l + sovSplunkService(uint64(l))
		}
	}
	l = len(m.PolicySeverity)
	if l > 0 {
		n += 1 + l + sovSplunkService(uint64(l))
	}
	l = len(m.PolicyVersion)
	if l > 0 {
		n += 1 + l + sovSplunkService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovSplunkService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozSplunkService(x uint64) (n int) {
	return sovSplunkService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *SplunkViolationsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSplunkService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SplunkViolationsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SplunkViolationsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Violations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Violations = append(m.Violations, &SplunkViolation{})
			if err := m.Violations[len(m.Violations)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NewCheckpoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NewCheckpoint = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSplunkService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSplunkService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SplunkViolation) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSplunkService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SplunkViolation: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SplunkViolation: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ViolationInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ViolationInfo == nil {
				m.ViolationInfo = &SplunkViolation_ViolationInfo{}
			}
			if err := m.ViolationInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AlertInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AlertInfo == nil {
				m.AlertInfo = &SplunkViolation_AlertInfo{}
			}
			if err := m.AlertInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProcessInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ProcessInfo == nil {
				m.ProcessInfo = &SplunkViolation_ProcessInfo{}
			}
			if err := m.ProcessInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &SplunkViolation_DeploymentInfo{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.EntityInfo = &SplunkViolation_DeploymentInfo_{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PolicyInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PolicyInfo == nil {
				m.PolicyInfo = &SplunkViolation_PolicyInfo{}
			}
			if err := m.PolicyInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetworkFlowInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NetworkFlowInfo == nil {
				m.NetworkFlowInfo = &storage.Alert_Violation_NetworkFlowInfo{}
			}
			if err := m.NetworkFlowInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &SplunkViolation_ResourceInfo{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.EntityInfo = &SplunkViolation_ResourceInfo_{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSplunkService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSplunkService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SplunkViolation_ViolationInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSplunkService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ViolationInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ViolationInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ViolationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ViolationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ViolationMessage", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ViolationMessage = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ViolationMessageAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ViolationMessageAttributes = append(m.ViolationMessageAttributes, &storage.Alert_Violation_KeyValueAttrs_KeyValueAttr{})
			if err := m.ViolationMessageAttributes[len(m.ViolationMessageAttributes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ViolationType", wireType)
			}
			m.ViolationType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ViolationType |= SplunkViolation_ViolationInfo_ViolationType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ViolationTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ViolationTime == nil {
				m.ViolationTime = &types.Timestamp{}
			}
			if err := m.ViolationTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 102:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PodId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PodId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 103:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PodUid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PodUid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 104:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainerName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 105:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerStartTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ContainerStartTime == nil {
				m.ContainerStartTime = &types.Timestamp{}
			}
			if err := m.ContainerStartTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 106:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainerId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSplunkService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSplunkService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SplunkViolation_AlertInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSplunkService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AlertInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AlertInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AlertId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AlertId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LifecycleStage", wireType)
			}
			m.LifecycleStage = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LifecycleStage |= storage.LifecycleStage(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AlertTags", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AlertTags = append(m.AlertTags, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AlertFirstOccurred", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AlertFirstOccurred == nil {
				m.AlertFirstOccurred = &types.Timestamp{}
			}
			if err := m.AlertFirstOccurred.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSplunkService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSplunkService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SplunkViolation_ProcessInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSplunkService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProcessInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProcessInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 101:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProcessViolationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProcessViolationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 202:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProcessSignalId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProcessSignalId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 203:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProcessCreationTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ProcessCreationTime == nil {
				m.ProcessCreationTime = &types.Timestamp{}
			}
			if err := m.ProcessCreationTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 204:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProcessName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProcessName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 205:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProcessArgs", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProcessArgs = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 206:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecFilePath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExecFilePath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 207:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pid", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Pid == nil {
				m.Pid = &types.UInt32Value{}
			}
			if err := m.Pid.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 208:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProcessUid", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ProcessUid == nil {
				m.ProcessUid = &types.UInt32Value{}
			}
			if err := m.ProcessUid.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 209:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProcessGid", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ProcessGid == nil {
				m.ProcessGid = &types.UInt32Value{}
			}
			if err := m.ProcessGid.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 210:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProcessLineageInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProcessLineageInfo = append(m.ProcessLineageInfo, &storage.ProcessSignal_LineageInfo{})
			if err := m.ProcessLineageInfo[len(m.ProcessLineageInfo)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSplunkService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSplunkService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SplunkViolation_DeploymentInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSplunkService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeploymentInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeploymentInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 101:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 102:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 103:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 104:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentNamespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 105:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentNamespaceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentNamespaceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 106:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentLabels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeploymentLabels == nil {
				m.DeploymentLabels = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowSplunkService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowSplunkService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthSplunkService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthSplunkService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowSplunkService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthSplunkService
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthSplunkService
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipSplunkService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthSplunkService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.DeploymentLabels[mapkey] = mapvalue
			iNdEx = postIndex
		case 107:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 108:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 109:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentContainers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentContainers = append(m.DeploymentContainers, &storage.Alert_Deployment_Container{})
			if err := m.DeploymentContainers[len(m.DeploymentContainers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 110:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentAnnotations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeploymentAnnotations == nil {
				m.DeploymentAnnotations = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowSplunkService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowSplunkService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthSplunkService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthSplunkService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowSplunkService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthSplunkService
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthSplunkService
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipSplunkService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthSplunkService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.DeploymentAnnotations[mapkey] = mapvalue
			iNdEx = postIndex
		case 201:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentImage", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeploymentImage == nil {
				m.DeploymentImage = &storage.ContainerImage{}
			}
			if err := m.DeploymentImage.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSplunkService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSplunkService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SplunkViolation_ResourceInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSplunkService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResourceInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResourceInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResourceType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSplunkService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSplunkService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SplunkViolation_PolicyInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSplunkService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PolicyInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PolicyInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PolicyId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PolicyId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PolicyName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PolicyName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PolicyDescription", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PolicyDescription = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PolicyRationale", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PolicyRationale = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PolicyCategories", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PolicyCategories = append(m.PolicyCategories, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PolicyLifecycleStages", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PolicyLifecycleStages = append(m.PolicyLifecycleStages, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PolicySeverity", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PolicySeverity = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PolicyVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSplunkService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSplunkService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PolicyVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSplunkService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSplunkService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipSplunkService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowSplunkService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSplunkService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthSplunkService
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupSplunkService
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthSplunkService
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthSplunkService        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowSplunkService          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupSplunkService = fmt.Errorf("proto: unexpected end of group")
)
