// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api/v1/api_token_service.proto

package v1

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	storage "github.com/stackrox/rox/generated/storage"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type GenerateTokenRequest struct {
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Role                 string   `protobuf:"bytes,2,opt,name=role,proto3" json:"role,omitempty"` // Deprecated: Do not use.
	Roles                []string `protobuf:"bytes,3,rep,name=roles,proto3" json:"roles,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GenerateTokenRequest) Reset()         { *m = GenerateTokenRequest{} }
func (m *GenerateTokenRequest) String() string { return proto.CompactTextString(m) }
func (*GenerateTokenRequest) ProtoMessage()    {}
func (*GenerateTokenRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5cff1ec89435902, []int{0}
}
func (m *GenerateTokenRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GenerateTokenRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GenerateTokenRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GenerateTokenRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenerateTokenRequest.Merge(m, src)
}
func (m *GenerateTokenRequest) XXX_Size() int {
	return m.Size()
}
func (m *GenerateTokenRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GenerateTokenRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GenerateTokenRequest proto.InternalMessageInfo

func (m *GenerateTokenRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Deprecated: Do not use.
func (m *GenerateTokenRequest) GetRole() string {
	if m != nil {
		return m.Role
	}
	return ""
}

func (m *GenerateTokenRequest) GetRoles() []string {
	if m != nil {
		return m.Roles
	}
	return nil
}

func (m *GenerateTokenRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GenerateTokenRequest) Clone() *GenerateTokenRequest {
	if m == nil {
		return nil
	}
	cloned := new(GenerateTokenRequest)
	*cloned = *m

	if m.Roles != nil {
		cloned.Roles = make([]string, len(m.Roles))
		copy(cloned.Roles, m.Roles)
	}
	return cloned
}

type GenerateTokenResponse struct {
	Token                string                 `protobuf:"bytes,1,opt,name=token,proto3" json:"token,omitempty"`
	Metadata             *storage.TokenMetadata `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *GenerateTokenResponse) Reset()         { *m = GenerateTokenResponse{} }
func (m *GenerateTokenResponse) String() string { return proto.CompactTextString(m) }
func (*GenerateTokenResponse) ProtoMessage()    {}
func (*GenerateTokenResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5cff1ec89435902, []int{1}
}
func (m *GenerateTokenResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GenerateTokenResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GenerateTokenResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GenerateTokenResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenerateTokenResponse.Merge(m, src)
}
func (m *GenerateTokenResponse) XXX_Size() int {
	return m.Size()
}
func (m *GenerateTokenResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GenerateTokenResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GenerateTokenResponse proto.InternalMessageInfo

func (m *GenerateTokenResponse) GetToken() string {
	if m != nil {
		return m.Token
	}
	return ""
}

func (m *GenerateTokenResponse) GetMetadata() *storage.TokenMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *GenerateTokenResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GenerateTokenResponse) Clone() *GenerateTokenResponse {
	if m == nil {
		return nil
	}
	cloned := new(GenerateTokenResponse)
	*cloned = *m

	cloned.Metadata = m.Metadata.Clone()
	return cloned
}

type GetAPITokensRequest struct {
	// Types that are valid to be assigned to RevokedOneof:
	//	*GetAPITokensRequest_Revoked
	RevokedOneof         isGetAPITokensRequest_RevokedOneof `protobuf_oneof:"revoked_oneof"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *GetAPITokensRequest) Reset()         { *m = GetAPITokensRequest{} }
func (m *GetAPITokensRequest) String() string { return proto.CompactTextString(m) }
func (*GetAPITokensRequest) ProtoMessage()    {}
func (*GetAPITokensRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5cff1ec89435902, []int{2}
}
func (m *GetAPITokensRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetAPITokensRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetAPITokensRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetAPITokensRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetAPITokensRequest.Merge(m, src)
}
func (m *GetAPITokensRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetAPITokensRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetAPITokensRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetAPITokensRequest proto.InternalMessageInfo

type isGetAPITokensRequest_RevokedOneof interface {
	isGetAPITokensRequest_RevokedOneof()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isGetAPITokensRequest_RevokedOneof
}

type GetAPITokensRequest_Revoked struct {
	Revoked bool `protobuf:"varint,1,opt,name=revoked,proto3,oneof" json:"revoked,omitempty"`
}

func (*GetAPITokensRequest_Revoked) isGetAPITokensRequest_RevokedOneof() {}
func (m *GetAPITokensRequest_Revoked) Clone() isGetAPITokensRequest_RevokedOneof {
	if m == nil {
		return nil
	}
	cloned := new(GetAPITokensRequest_Revoked)
	*cloned = *m

	return cloned
}

func (m *GetAPITokensRequest) GetRevokedOneof() isGetAPITokensRequest_RevokedOneof {
	if m != nil {
		return m.RevokedOneof
	}
	return nil
}

func (m *GetAPITokensRequest) GetRevoked() bool {
	if x, ok := m.GetRevokedOneof().(*GetAPITokensRequest_Revoked); ok {
		return x.Revoked
	}
	return false
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*GetAPITokensRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*GetAPITokensRequest_Revoked)(nil),
	}
}

func (m *GetAPITokensRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetAPITokensRequest) Clone() *GetAPITokensRequest {
	if m == nil {
		return nil
	}
	cloned := new(GetAPITokensRequest)
	*cloned = *m

	if m.RevokedOneof != nil {
		cloned.RevokedOneof = m.RevokedOneof.Clone()
	}
	return cloned
}

type GetAPITokensResponse struct {
	Tokens               []*storage.TokenMetadata `protobuf:"bytes,1,rep,name=tokens,proto3" json:"tokens,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *GetAPITokensResponse) Reset()         { *m = GetAPITokensResponse{} }
func (m *GetAPITokensResponse) String() string { return proto.CompactTextString(m) }
func (*GetAPITokensResponse) ProtoMessage()    {}
func (*GetAPITokensResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5cff1ec89435902, []int{3}
}
func (m *GetAPITokensResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetAPITokensResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetAPITokensResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetAPITokensResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetAPITokensResponse.Merge(m, src)
}
func (m *GetAPITokensResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetAPITokensResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetAPITokensResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetAPITokensResponse proto.InternalMessageInfo

func (m *GetAPITokensResponse) GetTokens() []*storage.TokenMetadata {
	if m != nil {
		return m.Tokens
	}
	return nil
}

func (m *GetAPITokensResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetAPITokensResponse) Clone() *GetAPITokensResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetAPITokensResponse)
	*cloned = *m

	if m.Tokens != nil {
		cloned.Tokens = make([]*storage.TokenMetadata, len(m.Tokens))
		for idx, v := range m.Tokens {
			cloned.Tokens[idx] = v.Clone()
		}
	}
	return cloned
}

func init() {
	proto.RegisterType((*GenerateTokenRequest)(nil), "v1.GenerateTokenRequest")
	proto.RegisterType((*GenerateTokenResponse)(nil), "v1.GenerateTokenResponse")
	proto.RegisterType((*GetAPITokensRequest)(nil), "v1.GetAPITokensRequest")
	proto.RegisterType((*GetAPITokensResponse)(nil), "v1.GetAPITokensResponse")
}

func init() { proto.RegisterFile("api/v1/api_token_service.proto", fileDescriptor_b5cff1ec89435902) }

var fileDescriptor_b5cff1ec89435902 = []byte{
	// 482 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x7c, 0x92, 0xcf, 0x6e, 0xd3, 0x40,
	0x10, 0xc6, 0x63, 0xa7, 0x94, 0x66, 0x43, 0x14, 0xb4, 0x4d, 0x53, 0xd7, 0x20, 0x2b, 0xf8, 0x54,
	0x71, 0xd8, 0xc8, 0xe1, 0xc6, 0x0d, 0x0b, 0x28, 0x3d, 0x54, 0x42, 0x2e, 0x87, 0x88, 0x4b, 0xb4,
	0x24, 0x83, 0x65, 0xa5, 0xde, 0x31, 0xde, 0xad, 0x45, 0x85, 0xb8, 0xf0, 0x0a, 0x5c, 0x78, 0x24,
	0x8e, 0x48, 0xbc, 0x00, 0x0a, 0x3c, 0x04, 0x47, 0xe4, 0xdd, 0x0d, 0xc4, 0xf4, 0xcf, 0x29, 0xbb,
	0xdf, 0x7e, 0xf9, 0xcd, 0xe7, 0x99, 0x21, 0x01, 0x2f, 0xb2, 0x71, 0x15, 0x8d, 0x79, 0x91, 0xcd,
	0x14, 0x2e, 0x41, 0xcc, 0x24, 0x94, 0x55, 0x36, 0x07, 0x56, 0x94, 0xa8, 0x90, 0xba, 0x55, 0xe4,
	0xdf, 0x4f, 0x11, 0xd3, 0x33, 0xa8, 0x3d, 0x63, 0x2e, 0x04, 0x2a, 0xae, 0x32, 0x14, 0xd2, 0x38,
	0xfc, 0x5d, 0x4b, 0x98, 0x63, 0x9e, 0xa3, 0xb0, 0x22, 0xb5, 0x22, 0xe4, 0x85, 0xba, 0xb0, 0xda,
	0xbe, 0x54, 0x58, 0xf2, 0x14, 0xfe, 0xd5, 0x32, 0x0f, 0xe1, 0x94, 0x0c, 0x8e, 0x40, 0x40, 0xc9,
	0x15, 0xbc, 0xaa, 0xe5, 0x04, 0xde, 0x9d, 0x83, 0x54, 0x94, 0x92, 0x2d, 0xc1, 0x73, 0xf0, 0x9c,
	0x91, 0x73, 0xd8, 0x49, 0xf4, 0x99, 0x0e, 0xc9, 0x56, 0x89, 0x67, 0xe0, 0xb9, 0xb5, 0x16, 0xbb,
	0x9e, 0x93, 0xe8, 0x3b, 0x1d, 0x90, 0x5b, 0xf5, 0xaf, 0xf4, 0xda, 0xa3, 0xf6, 0x61, 0x27, 0x31,
	0x97, 0x90, 0x93, 0xbd, 0xff, 0xc8, 0xb2, 0x40, 0x21, 0xb5, 0x5d, 0x27, 0xb0, 0x6c, 0x73, 0xa1,
	0x13, 0xb2, 0x93, 0x83, 0xe2, 0x0b, 0xae, 0xb8, 0x2e, 0xd0, 0x9d, 0x0c, 0x99, 0x0d, 0xcd, 0xf4,
	0xff, 0x4f, 0xec, 0x6b, 0xf2, 0xd7, 0x17, 0xc6, 0x64, 0xf7, 0x08, 0xd4, 0x93, 0x97, 0xc7, 0xda,
	0x20, 0xd7, 0xd9, 0x7d, 0x72, 0xbb, 0x84, 0x0a, 0x97, 0xb0, 0xd0, 0x25, 0x76, 0x5e, 0xb4, 0x92,
	0xb5, 0x10, 0xf7, 0x49, 0xcf, 0x1e, 0x67, 0x28, 0x00, 0xdf, 0x86, 0xcf, 0xeb, 0x06, 0x6c, 0x32,
	0x6c, 0x4a, 0x46, 0xb6, 0x75, 0x30, 0xe9, 0x39, 0xa3, 0xf6, 0x0d, 0x69, 0xac, 0x6b, 0xf2, 0xdb,
	0x25, 0xfd, 0x35, 0xe5, 0xd4, 0x8c, 0x91, 0x9e, 0x92, 0xee, 0x06, 0x9b, 0xde, 0x65, 0x55, 0xc4,
	0x12, 0x90, 0x78, 0x5e, 0xce, 0x21, 0xbe, 0x38, 0x7e, 0xea, 0x5f, 0x03, 0x0d, 0xfd, 0x4f, 0xdf,
	0x7f, 0x7d, 0x76, 0x07, 0x94, 0xda, 0xf5, 0x30, 0x35, 0xc6, 0x1f, 0xb2, 0xc5, 0x47, 0x3a, 0x25,
	0x77, 0x36, 0x03, 0xd3, 0xfd, 0x9a, 0x7a, 0x45, 0x1b, 0x7c, 0xef, 0xf2, 0x83, 0xf9, 0xb6, 0x70,
	0x4f, 0xe3, 0xfb, 0xb4, 0xd7, 0xc0, 0xd3, 0x94, 0xf4, 0x1a, 0x13, 0xa3, 0x96, 0x70, 0x79, 0x3d,
	0xfc, 0x83, 0x2b, 0x5e, 0x2c, 0xfc, 0x81, 0x86, 0xdf, 0x0b, 0x87, 0xcd, 0xec, 0xa9, 0x35, 0x3f,
	0x76, 0x1e, 0xd2, 0x13, 0xd2, 0x4d, 0xf4, 0x10, 0xae, 0xeb, 0x4b, 0xa7, 0x56, 0x9e, 0xd5, 0xfb,
	0xbb, 0xc6, 0x4d, 0x0e, 0x9a, 0x38, 0x33, 0x44, 0xdd, 0x91, 0x98, 0x7d, 0x5d, 0x05, 0xce, 0xb7,
	0x55, 0xe0, 0xfc, 0x58, 0x05, 0xce, 0x97, 0x9f, 0x41, 0x8b, 0x78, 0x19, 0x32, 0xa9, 0xf8, 0x7c,
	0x59, 0xe2, 0x7b, 0xb3, 0xe8, 0x8c, 0x17, 0x19, 0xab, 0xa2, 0xd7, 0x6e, 0x15, 0x4d, 0x5b, 0x6f,
	0xb6, 0xb5, 0xf6, 0xe8, 0x4f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x6a, 0x34, 0x52, 0x0b, 0x82, 0x03,
	0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// APITokenServiceClient is the client API for APITokenService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConnInterface.NewStream.
type APITokenServiceClient interface {
	// GetAPIToken returns API token metadata for a given id.
	GetAPIToken(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*storage.TokenMetadata, error)
	// GetAPITokens returns all the API tokens.
	GetAPITokens(ctx context.Context, in *GetAPITokensRequest, opts ...grpc.CallOption) (*GetAPITokensResponse, error)
	// GenerateToken generates API token for a given user and role.
	GenerateToken(ctx context.Context, in *GenerateTokenRequest, opts ...grpc.CallOption) (*GenerateTokenResponse, error)
	// RevokeToken removes the API token for a given id.
	RevokeToken(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*Empty, error)
}

type aPITokenServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAPITokenServiceClient(cc grpc.ClientConnInterface) APITokenServiceClient {
	return &aPITokenServiceClient{cc}
}

func (c *aPITokenServiceClient) GetAPIToken(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*storage.TokenMetadata, error) {
	out := new(storage.TokenMetadata)
	err := c.cc.Invoke(ctx, "/v1.APITokenService/GetAPIToken", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPITokenServiceClient) GetAPITokens(ctx context.Context, in *GetAPITokensRequest, opts ...grpc.CallOption) (*GetAPITokensResponse, error) {
	out := new(GetAPITokensResponse)
	err := c.cc.Invoke(ctx, "/v1.APITokenService/GetAPITokens", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPITokenServiceClient) GenerateToken(ctx context.Context, in *GenerateTokenRequest, opts ...grpc.CallOption) (*GenerateTokenResponse, error) {
	out := new(GenerateTokenResponse)
	err := c.cc.Invoke(ctx, "/v1.APITokenService/GenerateToken", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPITokenServiceClient) RevokeToken(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.APITokenService/RevokeToken", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// APITokenServiceServer is the server API for APITokenService service.
type APITokenServiceServer interface {
	// GetAPIToken returns API token metadata for a given id.
	GetAPIToken(context.Context, *ResourceByID) (*storage.TokenMetadata, error)
	// GetAPITokens returns all the API tokens.
	GetAPITokens(context.Context, *GetAPITokensRequest) (*GetAPITokensResponse, error)
	// GenerateToken generates API token for a given user and role.
	GenerateToken(context.Context, *GenerateTokenRequest) (*GenerateTokenResponse, error)
	// RevokeToken removes the API token for a given id.
	RevokeToken(context.Context, *ResourceByID) (*Empty, error)
}

// UnimplementedAPITokenServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAPITokenServiceServer struct {
}

func (*UnimplementedAPITokenServiceServer) GetAPIToken(ctx context.Context, req *ResourceByID) (*storage.TokenMetadata, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAPIToken not implemented")
}
func (*UnimplementedAPITokenServiceServer) GetAPITokens(ctx context.Context, req *GetAPITokensRequest) (*GetAPITokensResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAPITokens not implemented")
}
func (*UnimplementedAPITokenServiceServer) GenerateToken(ctx context.Context, req *GenerateTokenRequest) (*GenerateTokenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateToken not implemented")
}
func (*UnimplementedAPITokenServiceServer) RevokeToken(ctx context.Context, req *ResourceByID) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RevokeToken not implemented")
}

func RegisterAPITokenServiceServer(s *grpc.Server, srv APITokenServiceServer) {
	s.RegisterService(&_APITokenService_serviceDesc, srv)
}

func _APITokenService_GetAPIToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(APITokenServiceServer).GetAPIToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.APITokenService/GetAPIToken",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(APITokenServiceServer).GetAPIToken(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

func _APITokenService_GetAPITokens_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAPITokensRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(APITokenServiceServer).GetAPITokens(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.APITokenService/GetAPITokens",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(APITokenServiceServer).GetAPITokens(ctx, req.(*GetAPITokensRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _APITokenService_GenerateToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(APITokenServiceServer).GenerateToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.APITokenService/GenerateToken",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(APITokenServiceServer).GenerateToken(ctx, req.(*GenerateTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _APITokenService_RevokeToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(APITokenServiceServer).RevokeToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.APITokenService/RevokeToken",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(APITokenServiceServer).RevokeToken(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

var _APITokenService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1.APITokenService",
	HandlerType: (*APITokenServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAPIToken",
			Handler:    _APITokenService_GetAPIToken_Handler,
		},
		{
			MethodName: "GetAPITokens",
			Handler:    _APITokenService_GetAPITokens_Handler,
		},
		{
			MethodName: "GenerateToken",
			Handler:    _APITokenService_GenerateToken_Handler,
		},
		{
			MethodName: "RevokeToken",
			Handler:    _APITokenService_RevokeToken_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/v1/api_token_service.proto",
}

func (m *GenerateTokenRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GenerateTokenRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GenerateTokenRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Roles) > 0 {
		for iNdEx := len(m.Roles) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Roles[iNdEx])
			copy(dAtA[i:], m.Roles[iNdEx])
			i = encodeVarintApiTokenService(dAtA, i, uint64(len(m.Roles[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Role) > 0 {
		i -= len(m.Role)
		copy(dAtA[i:], m.Role)
		i = encodeVarintApiTokenService(dAtA, i, uint64(len(m.Role)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintApiTokenService(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GenerateTokenResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GenerateTokenResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GenerateTokenResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintApiTokenService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Token) > 0 {
		i -= len(m.Token)
		copy(dAtA[i:], m.Token)
		i = encodeVarintApiTokenService(dAtA, i, uint64(len(m.Token)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetAPITokensRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetAPITokensRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetAPITokensRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.RevokedOneof != nil {
		{
			size := m.RevokedOneof.Size()
			i -= size
			if _, err := m.RevokedOneof.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *GetAPITokensRequest_Revoked) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetAPITokensRequest_Revoked) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i--
	if m.Revoked {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x8
	return len(dAtA) - i, nil
}
func (m *GetAPITokensResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetAPITokensResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetAPITokensResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Tokens) > 0 {
		for iNdEx := len(m.Tokens) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Tokens[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintApiTokenService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func encodeVarintApiTokenService(dAtA []byte, offset int, v uint64) int {
	offset -= sovApiTokenService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *GenerateTokenRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovApiTokenService(uint64(l))
	}
	l = len(m.Role)
	if l > 0 {
		n += 1 + l + sovApiTokenService(uint64(l))
	}
	if len(m.Roles) > 0 {
		for _, s := range m.Roles {
			l = len(s)
			n += 1 + l + sovApiTokenService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GenerateTokenResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Token)
	if l > 0 {
		n += 1 + l + sovApiTokenService(uint64(l))
	}
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovApiTokenService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetAPITokensRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RevokedOneof != nil {
		n += m.RevokedOneof.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetAPITokensRequest_Revoked) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 2
	return n
}
func (m *GetAPITokensResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Tokens) > 0 {
		for _, e := range m.Tokens {
			l = e.Size()
			n += 1 + l + sovApiTokenService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovApiTokenService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozApiTokenService(x uint64) (n int) {
	return sovApiTokenService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *GenerateTokenRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApiTokenService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GenerateTokenRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GenerateTokenRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApiTokenService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApiTokenService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApiTokenService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Role", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApiTokenService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApiTokenService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApiTokenService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Role = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Roles", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApiTokenService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApiTokenService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApiTokenService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Roles = append(m.Roles, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApiTokenService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApiTokenService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GenerateTokenResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApiTokenService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GenerateTokenResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GenerateTokenResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Token", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApiTokenService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApiTokenService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthApiTokenService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Token = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApiTokenService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApiTokenService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApiTokenService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &storage.TokenMetadata{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApiTokenService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApiTokenService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetAPITokensRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApiTokenService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetAPITokensRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetAPITokensRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Revoked", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApiTokenService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.RevokedOneof = &GetAPITokensRequest_Revoked{b}
		default:
			iNdEx = preIndex
			skippy, err := skipApiTokenService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApiTokenService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetAPITokensResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApiTokenService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetAPITokensResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetAPITokensResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tokens", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApiTokenService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApiTokenService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthApiTokenService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tokens = append(m.Tokens, &storage.TokenMetadata{})
			if err := m.Tokens[len(m.Tokens)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApiTokenService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthApiTokenService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipApiTokenService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowApiTokenService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowApiTokenService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowApiTokenService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthApiTokenService
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupApiTokenService
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthApiTokenService
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthApiTokenService        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowApiTokenService          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupApiTokenService = fmt.Errorf("proto: unexpected end of group")
)
