// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api/v1/audit.proto

package v1

import (
	fmt "fmt"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	storage "github.com/stackrox/rox/generated/storage"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type Audit_RequestStatus int32

const (
	Audit_UNKNOWN_STATUS    Audit_RequestStatus = 0
	Audit_REQUEST_SUCCEEDED Audit_RequestStatus = 1
	Audit_AUTH_FAILED       Audit_RequestStatus = 2
	Audit_REQUEST_FAILED    Audit_RequestStatus = 3
)

var Audit_RequestStatus_name = map[int32]string{
	0: "UNKNOWN_STATUS",
	1: "REQUEST_SUCCEEDED",
	2: "AUTH_FAILED",
	3: "REQUEST_FAILED",
}

var Audit_RequestStatus_value = map[string]int32{
	"UNKNOWN_STATUS":    0,
	"REQUEST_SUCCEEDED": 1,
	"AUTH_FAILED":       2,
	"REQUEST_FAILED":    3,
}

func (x Audit_RequestStatus) String() string {
	return proto.EnumName(Audit_RequestStatus_name, int32(x))
}

func (Audit_RequestStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_368902fc694e7fed, []int{0, 0}
}

type Audit_Interaction int32

const (
	Audit_UNKNOWN_INTERACTION Audit_Interaction = 0
	Audit_CREATE              Audit_Interaction = 1
	Audit_UPDATE              Audit_Interaction = 2
	Audit_DELETE              Audit_Interaction = 3
)

var Audit_Interaction_name = map[int32]string{
	0: "UNKNOWN_INTERACTION",
	1: "CREATE",
	2: "UPDATE",
	3: "DELETE",
}

var Audit_Interaction_value = map[string]int32{
	"UNKNOWN_INTERACTION": 0,
	"CREATE":              1,
	"UPDATE":              2,
	"DELETE":              3,
}

func (x Audit_Interaction) String() string {
	return proto.EnumName(Audit_Interaction_name, int32(x))
}

func (Audit_Interaction) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_368902fc694e7fed, []int{0, 1}
}

type Audit_AccessMethod int32

const (
	Audit_UNKNOWN_METHOD Audit_AccessMethod = 0
	Audit_CLI            Audit_AccessMethod = 1
	Audit_UI             Audit_AccessMethod = 2
	Audit_API            Audit_AccessMethod = 3
)

var Audit_AccessMethod_name = map[int32]string{
	0: "UNKNOWN_METHOD",
	1: "CLI",
	2: "UI",
	3: "API",
}

var Audit_AccessMethod_value = map[string]int32{
	"UNKNOWN_METHOD": 0,
	"CLI":            1,
	"UI":             2,
	"API":            3,
}

func (x Audit_AccessMethod) String() string {
	return proto.EnumName(Audit_AccessMethod_name, int32(x))
}

func (Audit_AccessMethod) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_368902fc694e7fed, []int{0, 2}
}

type Audit struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Audit) Reset()         { *m = Audit{} }
func (m *Audit) String() string { return proto.CompactTextString(m) }
func (*Audit) ProtoMessage()    {}
func (*Audit) Descriptor() ([]byte, []int) {
	return fileDescriptor_368902fc694e7fed, []int{0}
}
func (m *Audit) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Audit) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Audit.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Audit) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Audit.Merge(m, src)
}
func (m *Audit) XXX_Size() int {
	return m.Size()
}
func (m *Audit) XXX_DiscardUnknown() {
	xxx_messageInfo_Audit.DiscardUnknown(m)
}

var xxx_messageInfo_Audit proto.InternalMessageInfo

func (m *Audit) MessageClone() proto.Message {
	return m.Clone()
}
func (m *Audit) Clone() *Audit {
	if m == nil {
		return nil
	}
	cloned := new(Audit)
	*cloned = *m

	return cloned
}

type Audit_Message struct {
	Time                 *types.Timestamp       `protobuf:"bytes,1,opt,name=time,proto3" json:"time,omitempty"`
	Status               Audit_RequestStatus    `protobuf:"varint,2,opt,name=status,proto3,enum=v1.Audit_RequestStatus" json:"status,omitempty"`
	StatusReason         string                 `protobuf:"bytes,3,opt,name=status_reason,json=statusReason,proto3" json:"status_reason,omitempty"`
	User                 *storage.UserInfo      `protobuf:"bytes,4,opt,name=user,proto3" json:"user,omitempty"`
	Request              *Audit_Message_Request `protobuf:"bytes,5,opt,name=request,proto3" json:"request,omitempty"`
	Method               Audit_AccessMethod     `protobuf:"varint,6,opt,name=method,proto3,enum=v1.Audit_AccessMethod" json:"method,omitempty"`
	Interaction          Audit_Interaction      `protobuf:"varint,7,opt,name=interaction,proto3,enum=v1.Audit_Interaction" json:"interaction,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *Audit_Message) Reset()         { *m = Audit_Message{} }
func (m *Audit_Message) String() string { return proto.CompactTextString(m) }
func (*Audit_Message) ProtoMessage()    {}
func (*Audit_Message) Descriptor() ([]byte, []int) {
	return fileDescriptor_368902fc694e7fed, []int{0, 0}
}
func (m *Audit_Message) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Audit_Message) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Audit_Message.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Audit_Message) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Audit_Message.Merge(m, src)
}
func (m *Audit_Message) XXX_Size() int {
	return m.Size()
}
func (m *Audit_Message) XXX_DiscardUnknown() {
	xxx_messageInfo_Audit_Message.DiscardUnknown(m)
}

var xxx_messageInfo_Audit_Message proto.InternalMessageInfo

func (m *Audit_Message) GetTime() *types.Timestamp {
	if m != nil {
		return m.Time
	}
	return nil
}

func (m *Audit_Message) GetStatus() Audit_RequestStatus {
	if m != nil {
		return m.Status
	}
	return Audit_UNKNOWN_STATUS
}

func (m *Audit_Message) GetStatusReason() string {
	if m != nil {
		return m.StatusReason
	}
	return ""
}

func (m *Audit_Message) GetUser() *storage.UserInfo {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *Audit_Message) GetRequest() *Audit_Message_Request {
	if m != nil {
		return m.Request
	}
	return nil
}

func (m *Audit_Message) GetMethod() Audit_AccessMethod {
	if m != nil {
		return m.Method
	}
	return Audit_UNKNOWN_METHOD
}

func (m *Audit_Message) GetInteraction() Audit_Interaction {
	if m != nil {
		return m.Interaction
	}
	return Audit_UNKNOWN_INTERACTION
}

func (m *Audit_Message) MessageClone() proto.Message {
	return m.Clone()
}
func (m *Audit_Message) Clone() *Audit_Message {
	if m == nil {
		return nil
	}
	cloned := new(Audit_Message)
	*cloned = *m

	cloned.Time = m.Time.Clone()
	cloned.User = m.User.Clone()
	cloned.Request = m.Request.Clone()
	return cloned
}

type Audit_Message_Request struct {
	Endpoint             string     `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	Method               string     `protobuf:"bytes,2,opt,name=method,proto3" json:"method,omitempty"`
	Payload              *types.Any `protobuf:"bytes,3,opt,name=payload,proto3" json:"payload,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *Audit_Message_Request) Reset()         { *m = Audit_Message_Request{} }
func (m *Audit_Message_Request) String() string { return proto.CompactTextString(m) }
func (*Audit_Message_Request) ProtoMessage()    {}
func (*Audit_Message_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_368902fc694e7fed, []int{0, 0, 0}
}
func (m *Audit_Message_Request) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Audit_Message_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Audit_Message_Request.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Audit_Message_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Audit_Message_Request.Merge(m, src)
}
func (m *Audit_Message_Request) XXX_Size() int {
	return m.Size()
}
func (m *Audit_Message_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_Audit_Message_Request.DiscardUnknown(m)
}

var xxx_messageInfo_Audit_Message_Request proto.InternalMessageInfo

func (m *Audit_Message_Request) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

func (m *Audit_Message_Request) GetMethod() string {
	if m != nil {
		return m.Method
	}
	return ""
}

func (m *Audit_Message_Request) GetPayload() *types.Any {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *Audit_Message_Request) MessageClone() proto.Message {
	return m.Clone()
}
func (m *Audit_Message_Request) Clone() *Audit_Message_Request {
	if m == nil {
		return nil
	}
	cloned := new(Audit_Message_Request)
	*cloned = *m

	cloned.Payload = m.Payload.Clone()
	return cloned
}

func init() {
	proto.RegisterEnum("v1.Audit_RequestStatus", Audit_RequestStatus_name, Audit_RequestStatus_value)
	proto.RegisterEnum("v1.Audit_Interaction", Audit_Interaction_name, Audit_Interaction_value)
	proto.RegisterEnum("v1.Audit_AccessMethod", Audit_AccessMethod_name, Audit_AccessMethod_value)
	proto.RegisterType((*Audit)(nil), "v1.Audit")
	proto.RegisterType((*Audit_Message)(nil), "v1.Audit.Message")
	proto.RegisterType((*Audit_Message_Request)(nil), "v1.Audit.Message.Request")
}

func init() { proto.RegisterFile("api/v1/audit.proto", fileDescriptor_368902fc694e7fed) }

var fileDescriptor_368902fc694e7fed = []byte{
	// 545 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x64, 0x91, 0xcf, 0x6e, 0xd3, 0x4a,
	0x14, 0xc6, 0x63, 0xa7, 0x8d, 0x6f, 0x4f, 0xda, 0x5e, 0x77, 0xa0, 0xad, 0xeb, 0x45, 0xa8, 0x82,
	0x90, 0xba, 0x1a, 0x2b, 0xed, 0x82, 0x0d, 0x1b, 0x13, 0x0f, 0xaa, 0xa1, 0x4d, 0xcb, 0xc4, 0x16,
	0x12, 0x9b, 0x68, 0x9a, 0x4c, 0x83, 0x45, 0xe3, 0x31, 0x9e, 0x49, 0x44, 0xdf, 0x84, 0x47, 0x61,
	0xcf, 0x86, 0x25, 0x8f, 0x80, 0xc2, 0x8b, 0x20, 0x8f, 0xed, 0x26, 0xc0, 0xee, 0xcc, 0xf7, 0xfd,
	0xce, 0xdf, 0x01, 0xc4, 0xb2, 0xc4, 0x5b, 0xf4, 0x3c, 0x36, 0x9f, 0x24, 0x0a, 0x67, 0xb9, 0x50,
	0x02, 0x99, 0x8b, 0x9e, 0x8b, 0xa4, 0x12, 0x39, 0x9b, 0x72, 0x6f, 0x2e, 0x79, 0x5e, 0xea, 0xee,
	0xd1, 0x54, 0x88, 0xe9, 0x1d, 0xf7, 0xf4, 0xeb, 0x66, 0x7e, 0xeb, 0xb1, 0xf4, 0xbe, 0xb2, 0x9e,
	0xfc, 0x6d, 0xa9, 0x64, 0xc6, 0xa5, 0x62, 0xb3, 0xac, 0x04, 0xba, 0x5f, 0x37, 0x61, 0xd3, 0x2f,
	0x7a, 0xb8, 0xdf, 0x9a, 0x60, 0x5d, 0x72, 0x29, 0xd9, 0x94, 0x23, 0x0c, 0x1b, 0x05, 0xe8, 0x18,
	0xc7, 0xc6, 0x49, 0xfb, 0xd4, 0xc5, 0x65, 0x15, 0x5c, 0x57, 0xc1, 0x51, 0x5d, 0x85, 0x6a, 0x0e,
	0x79, 0xd0, 0x92, 0x8a, 0xa9, 0xb9, 0x74, 0xcc, 0x63, 0xe3, 0x64, 0xf7, 0xf4, 0x10, 0x2f, 0x7a,
	0x58, 0x97, 0xc5, 0x94, 0x7f, 0x9a, 0x73, 0xa9, 0x86, 0xda, 0xa6, 0x15, 0x86, 0x9e, 0xc2, 0x4e,
	0x19, 0x8d, 0x72, 0xce, 0xa4, 0x48, 0x9d, 0xe6, 0xb1, 0x71, 0xb2, 0x45, 0xb7, 0x4b, 0x91, 0x6a,
	0x0d, 0x3d, 0x83, 0x8d, 0x62, 0x4b, 0x67, 0x43, 0x4f, 0xb1, 0x87, 0xab, 0xd5, 0x71, 0x2c, 0x79,
	0x1e, 0xa6, 0xb7, 0x82, 0x6a, 0x1b, 0x9d, 0x81, 0x95, 0x97, 0x4d, 0x9c, 0x4d, 0x4d, 0x1e, 0xad,
	0xba, 0x57, 0x0b, 0xd5, 0x53, 0xd0, 0x9a, 0x44, 0x18, 0x5a, 0x33, 0xae, 0x3e, 0x88, 0x89, 0xd3,
	0xd2, 0x13, 0x1f, 0xac, 0x72, 0xfc, 0xf1, 0x98, 0x4b, 0x79, 0xa9, 0x5d, 0x5a, 0x51, 0xe8, 0x39,
	0xb4, 0x93, 0x54, 0xf1, 0x9c, 0x8d, 0x55, 0x22, 0x52, 0xc7, 0xd2, 0x49, 0xfb, 0xab, 0xa4, 0x70,
	0x65, 0xd2, 0x75, 0xd2, 0x9d, 0x81, 0x55, 0x35, 0x47, 0x2e, 0xfc, 0xc7, 0xd3, 0x49, 0x26, 0x92,
	0x54, 0xe9, 0xcb, 0x6e, 0xd1, 0x87, 0x37, 0x3a, 0x78, 0x98, 0xc7, 0xd4, 0x4e, 0xdd, 0x17, 0x83,
	0x95, 0xb1, 0xfb, 0x3b, 0xc1, 0x26, 0xfa, 0x44, 0xed, 0xd3, 0xc7, 0xff, 0x7c, 0x86, 0x9f, 0xde,
	0xd3, 0x1a, 0xea, 0x8e, 0x60, 0xe7, 0x8f, 0x8b, 0x23, 0x04, 0xbb, 0xf1, 0xe0, 0xcd, 0xe0, 0xea,
	0xdd, 0x60, 0x34, 0x8c, 0xfc, 0x28, 0x1e, 0xda, 0x0d, 0xb4, 0x0f, 0x7b, 0x94, 0xbc, 0x8d, 0xc9,
	0x30, 0x1a, 0x0d, 0xe3, 0x7e, 0x9f, 0x90, 0x80, 0x04, 0xb6, 0x81, 0xfe, 0x87, 0xb6, 0x1f, 0x47,
	0xe7, 0xa3, 0x57, 0x7e, 0x78, 0x41, 0x02, 0xdb, 0x2c, 0x72, 0x6b, 0xae, 0xd2, 0x9a, 0xdd, 0xd7,
	0xd0, 0x5e, 0xdb, 0x15, 0x1d, 0xc2, 0xa3, 0xba, 0x7c, 0x38, 0x88, 0x08, 0xf5, 0xfb, 0x51, 0x78,
	0x35, 0xb0, 0x1b, 0x08, 0xa0, 0xd5, 0xa7, 0xc4, 0x8f, 0x88, 0x6d, 0x14, 0x71, 0x7c, 0x1d, 0x14,
	0xb1, 0x59, 0xc4, 0x01, 0xb9, 0x20, 0x11, 0xb1, 0x9b, 0xdd, 0x17, 0xb0, 0xbd, 0x7e, 0xec, 0xf5,
	0x59, 0x2f, 0x49, 0x74, 0x7e, 0x15, 0xd8, 0x0d, 0x64, 0x41, 0xb3, 0x7f, 0x11, 0xda, 0x06, 0x6a,
	0x81, 0x19, 0x87, 0xb6, 0x59, 0x08, 0xfe, 0x75, 0x68, 0x37, 0x5f, 0xe2, 0xef, 0xcb, 0x8e, 0xf1,
	0x63, 0xd9, 0x31, 0x7e, 0x2e, 0x3b, 0xc6, 0x97, 0x5f, 0x9d, 0x06, 0x38, 0x89, 0xc0, 0x52, 0xb1,
	0xf1, 0xc7, 0x5c, 0x7c, 0x2e, 0xef, 0x83, 0x59, 0x96, 0xe0, 0x45, 0xef, 0xbd, 0xb9, 0xe8, 0xdd,
	0xb4, 0xb4, 0x72, 0xf6, 0x3b, 0x00, 0x00, 0xff, 0xff, 0xe3, 0xea, 0x70, 0xa7, 0x5b, 0x03, 0x00,
	0x00,
}

func (m *Audit) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Audit) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Audit) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *Audit_Message) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Audit_Message) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Audit_Message) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Interaction != 0 {
		i = encodeVarintAudit(dAtA, i, uint64(m.Interaction))
		i--
		dAtA[i] = 0x38
	}
	if m.Method != 0 {
		i = encodeVarintAudit(dAtA, i, uint64(m.Method))
		i--
		dAtA[i] = 0x30
	}
	if m.Request != nil {
		{
			size, err := m.Request.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAudit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.User != nil {
		{
			size, err := m.User.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAudit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.StatusReason) > 0 {
		i -= len(m.StatusReason)
		copy(dAtA[i:], m.StatusReason)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.StatusReason)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Status != 0 {
		i = encodeVarintAudit(dAtA, i, uint64(m.Status))
		i--
		dAtA[i] = 0x10
	}
	if m.Time != nil {
		{
			size, err := m.Time.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAudit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Audit_Message_Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Audit_Message_Request) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Audit_Message_Request) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Payload != nil {
		{
			size, err := m.Payload.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAudit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Method) > 0 {
		i -= len(m.Method)
		copy(dAtA[i:], m.Method)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.Method)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Endpoint) > 0 {
		i -= len(m.Endpoint)
		copy(dAtA[i:], m.Endpoint)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.Endpoint)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintAudit(dAtA []byte, offset int, v uint64) int {
	offset -= sovAudit(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Audit) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Audit_Message) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Time != nil {
		l = m.Time.Size()
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.Status != 0 {
		n += 1 + sovAudit(uint64(m.Status))
	}
	l = len(m.StatusReason)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.User != nil {
		l = m.User.Size()
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.Request != nil {
		l = m.Request.Size()
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.Method != 0 {
		n += 1 + sovAudit(uint64(m.Method))
	}
	if m.Interaction != 0 {
		n += 1 + sovAudit(uint64(m.Interaction))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Audit_Message_Request) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Endpoint)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.Method)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.Payload != nil {
		l = m.Payload.Size()
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovAudit(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozAudit(x uint64) (n int) {
	return sovAudit(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Audit) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Audit: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Audit: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Audit_Message) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Message: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Message: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Time", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Time == nil {
				m.Time = &types.Timestamp{}
			}
			if err := m.Time.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= Audit_RequestStatus(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StatusReason", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StatusReason = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field User", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.User == nil {
				m.User = &storage.UserInfo{}
			}
			if err := m.User.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Request", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Request == nil {
				m.Request = &Audit_Message_Request{}
			}
			if err := m.Request.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Method", wireType)
			}
			m.Method = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Method |= Audit_AccessMethod(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Interaction", wireType)
			}
			m.Interaction = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Interaction |= Audit_Interaction(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Audit_Message_Request) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Endpoint = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Method", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Method = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Payload", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Payload == nil {
				m.Payload = &types.Any{}
			}
			if err := m.Payload.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipAudit(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthAudit
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupAudit
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthAudit
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthAudit        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowAudit          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupAudit = fmt.Errorf("proto: unexpected end of group")
)
