// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api/v1/backup_service.proto

package v1

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	storage "github.com/stackrox/rox/generated/storage"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type GetExternalBackupsResponse struct {
	ExternalBackups      []*storage.ExternalBackup `protobuf:"bytes,1,rep,name=external_backups,json=externalBackups,proto3" json:"external_backups,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *GetExternalBackupsResponse) Reset()         { *m = GetExternalBackupsResponse{} }
func (m *GetExternalBackupsResponse) String() string { return proto.CompactTextString(m) }
func (*GetExternalBackupsResponse) ProtoMessage()    {}
func (*GetExternalBackupsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_87b5f012147a9d12, []int{0}
}
func (m *GetExternalBackupsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetExternalBackupsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetExternalBackupsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetExternalBackupsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetExternalBackupsResponse.Merge(m, src)
}
func (m *GetExternalBackupsResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetExternalBackupsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetExternalBackupsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetExternalBackupsResponse proto.InternalMessageInfo

func (m *GetExternalBackupsResponse) GetExternalBackups() []*storage.ExternalBackup {
	if m != nil {
		return m.ExternalBackups
	}
	return nil
}

func (m *GetExternalBackupsResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetExternalBackupsResponse) Clone() *GetExternalBackupsResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetExternalBackupsResponse)
	*cloned = *m

	if m.ExternalBackups != nil {
		cloned.ExternalBackups = make([]*storage.ExternalBackup, len(m.ExternalBackups))
		for idx, v := range m.ExternalBackups {
			cloned.ExternalBackups[idx] = v.Clone()
		}
	}
	return cloned
}

type UpdateExternalBackupRequest struct {
	ExternalBackup *storage.ExternalBackup `protobuf:"bytes,1,opt,name=external_backup,json=externalBackup,proto3" json:"external_backup,omitempty"`
	// When false, use the stored credentials of an existing external backup configuration given its ID.
	UpdatePassword       bool     `protobuf:"varint,2,opt,name=update_password,json=updatePassword,proto3" json:"update_password,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateExternalBackupRequest) Reset()         { *m = UpdateExternalBackupRequest{} }
func (m *UpdateExternalBackupRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateExternalBackupRequest) ProtoMessage()    {}
func (*UpdateExternalBackupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_87b5f012147a9d12, []int{1}
}
func (m *UpdateExternalBackupRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpdateExternalBackupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UpdateExternalBackupRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UpdateExternalBackupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateExternalBackupRequest.Merge(m, src)
}
func (m *UpdateExternalBackupRequest) XXX_Size() int {
	return m.Size()
}
func (m *UpdateExternalBackupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateExternalBackupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateExternalBackupRequest proto.InternalMessageInfo

func (m *UpdateExternalBackupRequest) GetExternalBackup() *storage.ExternalBackup {
	if m != nil {
		return m.ExternalBackup
	}
	return nil
}

func (m *UpdateExternalBackupRequest) GetUpdatePassword() bool {
	if m != nil {
		return m.UpdatePassword
	}
	return false
}

func (m *UpdateExternalBackupRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *UpdateExternalBackupRequest) Clone() *UpdateExternalBackupRequest {
	if m == nil {
		return nil
	}
	cloned := new(UpdateExternalBackupRequest)
	*cloned = *m

	cloned.ExternalBackup = m.ExternalBackup.Clone()
	return cloned
}

func init() {
	proto.RegisterType((*GetExternalBackupsResponse)(nil), "v1.GetExternalBackupsResponse")
	proto.RegisterType((*UpdateExternalBackupRequest)(nil), "v1.UpdateExternalBackupRequest")
}

func init() { proto.RegisterFile("api/v1/backup_service.proto", fileDescriptor_87b5f012147a9d12) }

var fileDescriptor_87b5f012147a9d12 = []byte{
	// 523 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x94, 0x4f, 0x6b, 0xd4, 0x40,
	0x18, 0xc6, 0x3b, 0x2b, 0xf8, 0x67, 0x84, 0x6e, 0x3b, 0xed, 0x62, 0xcc, 0xda, 0x18, 0x22, 0xe2,
	0xb2, 0x62, 0x42, 0xb6, 0xb7, 0x9e, 0x64, 0x69, 0x11, 0x6f, 0xcb, 0xda, 0x8a, 0x88, 0xb2, 0x9d,
	0x26, 0xaf, 0x21, 0x76, 0x37, 0x13, 0x33, 0x93, 0xd8, 0x22, 0x5e, 0x04, 0xc1, 0xbb, 0x17, 0xbf,
	0x89, 0x5f, 0xc1, 0xa3, 0xe0, 0x17, 0x90, 0xd5, 0x0f, 0x22, 0x99, 0x8c, 0xd8, 0x4d, 0x33, 0x45,
	0xed, 0x2d, 0xbc, 0xef, 0xcc, 0xf3, 0x9b, 0xf7, 0x79, 0x32, 0x83, 0xbb, 0x34, 0x8d, 0xbd, 0xc2,
	0xf7, 0x0e, 0x68, 0x70, 0x98, 0xa7, 0x13, 0x0e, 0x59, 0x11, 0x07, 0xe0, 0xa6, 0x19, 0x13, 0x8c,
	0xb4, 0x0a, 0xdf, 0xbc, 0x11, 0x31, 0x16, 0x4d, 0xc1, 0x2b, 0xd7, 0xd1, 0x24, 0x61, 0x82, 0x8a,
	0x98, 0x25, 0xbc, 0x5a, 0x61, 0xae, 0xa9, 0xed, 0x01, 0x9b, 0xcd, 0x58, 0xa2, 0x8a, 0x44, 0x15,
	0x61, 0x96, 0x8a, 0x63, 0x55, 0xdb, 0xe0, 0x82, 0x65, 0x34, 0x02, 0x0f, 0x8e, 0x04, 0x64, 0x09,
	0x9d, 0x4e, 0x2a, 0x62, 0xd5, 0x76, 0xf6, 0xb1, 0xf9, 0x00, 0xc4, 0x8e, 0xea, 0x0d, 0x65, 0x8b,
	0x8f, 0x81, 0xa7, 0x2c, 0xe1, 0x40, 0x86, 0x78, 0xa5, 0xb6, 0x8d, 0x1b, 0xc8, 0xbe, 0xd0, 0xbb,
	0x3a, 0xb8, 0xe6, 0x2a, 0x5d, 0x77, 0x71, 0xef, 0xb8, 0x0d, 0x8b, 0x5a, 0xce, 0x07, 0x84, 0xbb,
	0x7b, 0x69, 0x48, 0x05, 0xd4, 0x56, 0xc2, 0xab, 0x1c, 0xb8, 0x20, 0xf7, 0x71, 0xbb, 0xc6, 0x30,
	0x90, 0x8d, 0xce, 0x42, 0x2c, 0x2f, 0x22, 0xc8, 0x1d, 0xdc, 0xce, 0x25, 0x60, 0x92, 0x52, 0xce,
	0x5f, 0xb3, 0x2c, 0x34, 0x5a, 0x36, 0xea, 0x5d, 0x1e, 0x2f, 0x57, 0xe5, 0x91, 0xaa, 0x0e, 0x3e,
	0x5f, 0xc2, 0x9d, 0x45, 0xad, 0x47, 0x95, 0xed, 0x64, 0x1f, 0xaf, 0x9e, 0xb2, 0x81, 0xac, 0xb8,
	0x85, 0xef, 0x8e, 0x81, 0xb3, 0x3c, 0x0b, 0x60, 0x78, 0xfc, 0x70, 0xdb, 0xd4, 0x1d, 0xc9, 0xb1,
	0xdf, 0x7d, 0xfb, 0xf9, 0xb1, 0x65, 0x12, 0x43, 0xda, 0xaf, 0x7a, 0xca, 0x31, 0xef, 0x4d, 0x1c,
	0xbe, 0x25, 0xcf, 0x30, 0x39, 0x6d, 0x34, 0xb9, 0x52, 0x22, 0x76, 0xca, 0xb8, 0x4c, 0xab, 0xfc,
	0xd4, 0x67, 0xe1, 0x74, 0x25, 0xa2, 0x43, 0xd6, 0x1a, 0x10, 0xe4, 0x05, 0x26, 0x23, 0xc6, 0xeb,
	0x03, 0xe8, 0x8e, 0xab, 0x9f, 0xc3, 0x92, 0x10, 0xc3, 0x69, 0x82, 0x6c, 0xa1, 0x3e, 0x79, 0x89,
	0x57, 0x47, 0xf9, 0xf9, 0x31, 0xb7, 0x24, 0x66, 0xc3, 0xd4, 0xda, 0x55, 0xb2, 0x9e, 0x63, 0xb2,
	0x0b, 0x7f, 0x3f, 0xd3, 0x1f, 0x2b, 0x7f, 0xcb, 0x3b, 0x8d, 0xf2, 0x02, 0xb8, 0x28, 0xe5, 0xf7,
	0xf0, 0xfa, 0x36, 0x4c, 0xa1, 0xfe, 0x5b, 0x36, 0xa4, 0x7e, 0x42, 0x59, 0xe5, 0xdc, 0xd7, 0xe7,
	0xfc, 0x18, 0x77, 0x76, 0xb3, 0x38, 0x8a, 0x20, 0xfb, 0x0f, 0x5d, 0x47, 0xaf, 0xfb, 0x1e, 0xe1,
	0xf5, 0xa6, 0x6b, 0x44, 0x6e, 0x96, 0x2a, 0x67, 0x5c, 0x30, 0x7d, 0x0a, 0x9b, 0x12, 0x7a, 0x6f,
	0xd0, 0x6b, 0x84, 0xd6, 0xdf, 0x0b, 0x95, 0x8a, 0xc0, 0xd7, 0xcb, 0x54, 0x2a, 0x60, 0xf8, 0xaf,
	0x67, 0x39, 0x31, 0xf2, 0x5d, 0x49, 0xbf, 0xed, 0xd8, 0xba, 0x90, 0xbc, 0xea, 0xf6, 0x86, 0x5b,
	0xa8, 0x3f, 0x74, 0xbf, 0xcc, 0x2d, 0xf4, 0x75, 0x6e, 0xa1, 0xef, 0x73, 0x0b, 0x7d, 0xfa, 0x61,
	0x2d, 0x61, 0x23, 0x66, 0x2e, 0x17, 0x34, 0x38, 0xcc, 0xd8, 0x51, 0xf5, 0x96, 0xb9, 0x34, 0x8d,
	0xdd, 0xc2, 0x7f, 0xda, 0x2a, 0xfc, 0x27, 0x4b, 0x07, 0x17, 0x65, 0x6d, 0xf3, 0x57, 0x00, 0x00,
	0x00, 0xff, 0xff, 0xa4, 0xc9, 0x07, 0x28, 0x68, 0x05, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ExternalBackupServiceClient is the client API for ExternalBackupService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConnInterface.NewStream.
type ExternalBackupServiceClient interface {
	// GetExternalBackup returns the external backup configuration given its ID.
	GetExternalBackup(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*storage.ExternalBackup, error)
	// GetExternalBackups returns all external backup configurations.
	GetExternalBackups(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*GetExternalBackupsResponse, error)
	// PostExternalBackup creates an external backup configuration.
	PostExternalBackup(ctx context.Context, in *storage.ExternalBackup, opts ...grpc.CallOption) (*storage.ExternalBackup, error)
	// PutExternalBackup modifies a given external backup, without using stored credential reconciliation.
	PutExternalBackup(ctx context.Context, in *storage.ExternalBackup, opts ...grpc.CallOption) (*storage.ExternalBackup, error)
	// TestExternalBackup tests an external backup configuration.
	TestExternalBackup(ctx context.Context, in *storage.ExternalBackup, opts ...grpc.CallOption) (*Empty, error)
	// DeleteExternalBackup removes an external backup configuration given its ID.
	DeleteExternalBackup(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*Empty, error)
	// TriggerExternalBackup initiates an external backup for the given configuration.
	TriggerExternalBackup(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*Empty, error)
	// UpdateExternalBackup modifies a given external backup, with optional stored credential reconciliation.
	UpdateExternalBackup(ctx context.Context, in *UpdateExternalBackupRequest, opts ...grpc.CallOption) (*storage.ExternalBackup, error)
	// TestUpdatedExternalBackup checks if the given external backup is correctly configured, with optional stored credential reconciliation.
	TestUpdatedExternalBackup(ctx context.Context, in *UpdateExternalBackupRequest, opts ...grpc.CallOption) (*Empty, error)
}

type externalBackupServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewExternalBackupServiceClient(cc grpc.ClientConnInterface) ExternalBackupServiceClient {
	return &externalBackupServiceClient{cc}
}

func (c *externalBackupServiceClient) GetExternalBackup(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*storage.ExternalBackup, error) {
	out := new(storage.ExternalBackup)
	err := c.cc.Invoke(ctx, "/v1.ExternalBackupService/GetExternalBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *externalBackupServiceClient) GetExternalBackups(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*GetExternalBackupsResponse, error) {
	out := new(GetExternalBackupsResponse)
	err := c.cc.Invoke(ctx, "/v1.ExternalBackupService/GetExternalBackups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *externalBackupServiceClient) PostExternalBackup(ctx context.Context, in *storage.ExternalBackup, opts ...grpc.CallOption) (*storage.ExternalBackup, error) {
	out := new(storage.ExternalBackup)
	err := c.cc.Invoke(ctx, "/v1.ExternalBackupService/PostExternalBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *externalBackupServiceClient) PutExternalBackup(ctx context.Context, in *storage.ExternalBackup, opts ...grpc.CallOption) (*storage.ExternalBackup, error) {
	out := new(storage.ExternalBackup)
	err := c.cc.Invoke(ctx, "/v1.ExternalBackupService/PutExternalBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *externalBackupServiceClient) TestExternalBackup(ctx context.Context, in *storage.ExternalBackup, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.ExternalBackupService/TestExternalBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *externalBackupServiceClient) DeleteExternalBackup(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.ExternalBackupService/DeleteExternalBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *externalBackupServiceClient) TriggerExternalBackup(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.ExternalBackupService/TriggerExternalBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *externalBackupServiceClient) UpdateExternalBackup(ctx context.Context, in *UpdateExternalBackupRequest, opts ...grpc.CallOption) (*storage.ExternalBackup, error) {
	out := new(storage.ExternalBackup)
	err := c.cc.Invoke(ctx, "/v1.ExternalBackupService/UpdateExternalBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *externalBackupServiceClient) TestUpdatedExternalBackup(ctx context.Context, in *UpdateExternalBackupRequest, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.ExternalBackupService/TestUpdatedExternalBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ExternalBackupServiceServer is the server API for ExternalBackupService service.
type ExternalBackupServiceServer interface {
	// GetExternalBackup returns the external backup configuration given its ID.
	GetExternalBackup(context.Context, *ResourceByID) (*storage.ExternalBackup, error)
	// GetExternalBackups returns all external backup configurations.
	GetExternalBackups(context.Context, *Empty) (*GetExternalBackupsResponse, error)
	// PostExternalBackup creates an external backup configuration.
	PostExternalBackup(context.Context, *storage.ExternalBackup) (*storage.ExternalBackup, error)
	// PutExternalBackup modifies a given external backup, without using stored credential reconciliation.
	PutExternalBackup(context.Context, *storage.ExternalBackup) (*storage.ExternalBackup, error)
	// TestExternalBackup tests an external backup configuration.
	TestExternalBackup(context.Context, *storage.ExternalBackup) (*Empty, error)
	// DeleteExternalBackup removes an external backup configuration given its ID.
	DeleteExternalBackup(context.Context, *ResourceByID) (*Empty, error)
	// TriggerExternalBackup initiates an external backup for the given configuration.
	TriggerExternalBackup(context.Context, *ResourceByID) (*Empty, error)
	// UpdateExternalBackup modifies a given external backup, with optional stored credential reconciliation.
	UpdateExternalBackup(context.Context, *UpdateExternalBackupRequest) (*storage.ExternalBackup, error)
	// TestUpdatedExternalBackup checks if the given external backup is correctly configured, with optional stored credential reconciliation.
	TestUpdatedExternalBackup(context.Context, *UpdateExternalBackupRequest) (*Empty, error)
}

// UnimplementedExternalBackupServiceServer can be embedded to have forward compatible implementations.
type UnimplementedExternalBackupServiceServer struct {
}

func (*UnimplementedExternalBackupServiceServer) GetExternalBackup(ctx context.Context, req *ResourceByID) (*storage.ExternalBackup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetExternalBackup not implemented")
}
func (*UnimplementedExternalBackupServiceServer) GetExternalBackups(ctx context.Context, req *Empty) (*GetExternalBackupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetExternalBackups not implemented")
}
func (*UnimplementedExternalBackupServiceServer) PostExternalBackup(ctx context.Context, req *storage.ExternalBackup) (*storage.ExternalBackup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PostExternalBackup not implemented")
}
func (*UnimplementedExternalBackupServiceServer) PutExternalBackup(ctx context.Context, req *storage.ExternalBackup) (*storage.ExternalBackup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PutExternalBackup not implemented")
}
func (*UnimplementedExternalBackupServiceServer) TestExternalBackup(ctx context.Context, req *storage.ExternalBackup) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestExternalBackup not implemented")
}
func (*UnimplementedExternalBackupServiceServer) DeleteExternalBackup(ctx context.Context, req *ResourceByID) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteExternalBackup not implemented")
}
func (*UnimplementedExternalBackupServiceServer) TriggerExternalBackup(ctx context.Context, req *ResourceByID) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TriggerExternalBackup not implemented")
}
func (*UnimplementedExternalBackupServiceServer) UpdateExternalBackup(ctx context.Context, req *UpdateExternalBackupRequest) (*storage.ExternalBackup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateExternalBackup not implemented")
}
func (*UnimplementedExternalBackupServiceServer) TestUpdatedExternalBackup(ctx context.Context, req *UpdateExternalBackupRequest) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestUpdatedExternalBackup not implemented")
}

func RegisterExternalBackupServiceServer(s *grpc.Server, srv ExternalBackupServiceServer) {
	s.RegisterService(&_ExternalBackupService_serviceDesc, srv)
}

func _ExternalBackupService_GetExternalBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExternalBackupServiceServer).GetExternalBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ExternalBackupService/GetExternalBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExternalBackupServiceServer).GetExternalBackup(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExternalBackupService_GetExternalBackups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExternalBackupServiceServer).GetExternalBackups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ExternalBackupService/GetExternalBackups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExternalBackupServiceServer).GetExternalBackups(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExternalBackupService_PostExternalBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(storage.ExternalBackup)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExternalBackupServiceServer).PostExternalBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ExternalBackupService/PostExternalBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExternalBackupServiceServer).PostExternalBackup(ctx, req.(*storage.ExternalBackup))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExternalBackupService_PutExternalBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(storage.ExternalBackup)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExternalBackupServiceServer).PutExternalBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ExternalBackupService/PutExternalBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExternalBackupServiceServer).PutExternalBackup(ctx, req.(*storage.ExternalBackup))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExternalBackupService_TestExternalBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(storage.ExternalBackup)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExternalBackupServiceServer).TestExternalBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ExternalBackupService/TestExternalBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExternalBackupServiceServer).TestExternalBackup(ctx, req.(*storage.ExternalBackup))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExternalBackupService_DeleteExternalBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExternalBackupServiceServer).DeleteExternalBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ExternalBackupService/DeleteExternalBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExternalBackupServiceServer).DeleteExternalBackup(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExternalBackupService_TriggerExternalBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExternalBackupServiceServer).TriggerExternalBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ExternalBackupService/TriggerExternalBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExternalBackupServiceServer).TriggerExternalBackup(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExternalBackupService_UpdateExternalBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateExternalBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExternalBackupServiceServer).UpdateExternalBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ExternalBackupService/UpdateExternalBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExternalBackupServiceServer).UpdateExternalBackup(ctx, req.(*UpdateExternalBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExternalBackupService_TestUpdatedExternalBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateExternalBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExternalBackupServiceServer).TestUpdatedExternalBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ExternalBackupService/TestUpdatedExternalBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExternalBackupServiceServer).TestUpdatedExternalBackup(ctx, req.(*UpdateExternalBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ExternalBackupService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1.ExternalBackupService",
	HandlerType: (*ExternalBackupServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetExternalBackup",
			Handler:    _ExternalBackupService_GetExternalBackup_Handler,
		},
		{
			MethodName: "GetExternalBackups",
			Handler:    _ExternalBackupService_GetExternalBackups_Handler,
		},
		{
			MethodName: "PostExternalBackup",
			Handler:    _ExternalBackupService_PostExternalBackup_Handler,
		},
		{
			MethodName: "PutExternalBackup",
			Handler:    _ExternalBackupService_PutExternalBackup_Handler,
		},
		{
			MethodName: "TestExternalBackup",
			Handler:    _ExternalBackupService_TestExternalBackup_Handler,
		},
		{
			MethodName: "DeleteExternalBackup",
			Handler:    _ExternalBackupService_DeleteExternalBackup_Handler,
		},
		{
			MethodName: "TriggerExternalBackup",
			Handler:    _ExternalBackupService_TriggerExternalBackup_Handler,
		},
		{
			MethodName: "UpdateExternalBackup",
			Handler:    _ExternalBackupService_UpdateExternalBackup_Handler,
		},
		{
			MethodName: "TestUpdatedExternalBackup",
			Handler:    _ExternalBackupService_TestUpdatedExternalBackup_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/v1/backup_service.proto",
}

func (m *GetExternalBackupsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetExternalBackupsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetExternalBackupsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ExternalBackups) > 0 {
		for iNdEx := len(m.ExternalBackups) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ExternalBackups[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintBackupService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *UpdateExternalBackupRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpdateExternalBackupRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UpdateExternalBackupRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.UpdatePassword {
		i--
		if m.UpdatePassword {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if m.ExternalBackup != nil {
		{
			size, err := m.ExternalBackup.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintBackupService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintBackupService(dAtA []byte, offset int, v uint64) int {
	offset -= sovBackupService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *GetExternalBackupsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ExternalBackups) > 0 {
		for _, e := range m.ExternalBackups {
			l = e.Size()
			n += 1 + l + sovBackupService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *UpdateExternalBackupRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ExternalBackup != nil {
		l = m.ExternalBackup.Size()
		n += 1 + l + sovBackupService(uint64(l))
	}
	if m.UpdatePassword {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovBackupService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozBackupService(x uint64) (n int) {
	return sovBackupService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *GetExternalBackupsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackupService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetExternalBackupsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetExternalBackupsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExternalBackups", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackupService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackupService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBackupService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExternalBackups = append(m.ExternalBackups, &storage.ExternalBackup{})
			if err := m.ExternalBackups[len(m.ExternalBackups)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBackupService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthBackupService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateExternalBackupRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackupService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateExternalBackupRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateExternalBackupRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExternalBackup", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackupService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackupService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBackupService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExternalBackup == nil {
				m.ExternalBackup = &storage.ExternalBackup{}
			}
			if err := m.ExternalBackup.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpdatePassword", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackupService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UpdatePassword = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipBackupService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthBackupService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipBackupService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowBackupService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowBackupService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowBackupService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthBackupService
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupBackupService
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthBackupService
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthBackupService        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowBackupService          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupBackupService = fmt.Errorf("proto: unexpected end of group")
)
