// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api/v1/central_health_service.proto

package v1

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type GetUpgradeStatusResponse struct {
	UpgradeStatus        *CentralUpgradeStatus `protobuf:"bytes,1,opt,name=upgradeStatus,proto3" json:"upgradeStatus,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *GetUpgradeStatusResponse) Reset()         { *m = GetUpgradeStatusResponse{} }
func (m *GetUpgradeStatusResponse) String() string { return proto.CompactTextString(m) }
func (*GetUpgradeStatusResponse) ProtoMessage()    {}
func (*GetUpgradeStatusResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6e4bd547a0084fea, []int{0}
}
func (m *GetUpgradeStatusResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetUpgradeStatusResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetUpgradeStatusResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetUpgradeStatusResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetUpgradeStatusResponse.Merge(m, src)
}
func (m *GetUpgradeStatusResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetUpgradeStatusResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetUpgradeStatusResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetUpgradeStatusResponse proto.InternalMessageInfo

func (m *GetUpgradeStatusResponse) GetUpgradeStatus() *CentralUpgradeStatus {
	if m != nil {
		return m.UpgradeStatus
	}
	return nil
}

func (m *GetUpgradeStatusResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetUpgradeStatusResponse) Clone() *GetUpgradeStatusResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetUpgradeStatusResponse)
	*cloned = *m

	cloned.UpgradeStatus = m.UpgradeStatus.Clone()
	return cloned
}

type CentralUpgradeStatus struct {
	// Current Central Version
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// The version of previous replica in Central. This is the version we can force rollback to.
	ForceRollbackTo string `protobuf:"bytes,2,opt,name=force_rollback_to,json=forceRollbackTo,proto3" json:"force_rollback_to,omitempty"`
	// If true, we can rollback to the current version if an upgrade failed.
	CanRollbackAfterUpgrade bool `protobuf:"varint,3,opt,name=can_rollback_after_upgrade,json=canRollbackAfterUpgrade,proto3" json:"can_rollback_after_upgrade,omitempty"`
	// Current disk space stats for upgrade
	SpaceRequiredForRollbackAfterUpgrade  int64    `protobuf:"varint,4,opt,name=space_required_for_rollback_after_upgrade,json=spaceRequiredForRollbackAfterUpgrade,proto3" json:"space_required_for_rollback_after_upgrade,omitempty"`
	SpaceAvailableForRollbackAfterUpgrade int64    `protobuf:"varint,5,opt,name=space_available_for_rollback_after_upgrade,json=spaceAvailableForRollbackAfterUpgrade,proto3" json:"space_available_for_rollback_after_upgrade,omitempty"`
	XXX_NoUnkeyedLiteral                  struct{} `json:"-"`
	XXX_unrecognized                      []byte   `json:"-"`
	XXX_sizecache                         int32    `json:"-"`
}

func (m *CentralUpgradeStatus) Reset()         { *m = CentralUpgradeStatus{} }
func (m *CentralUpgradeStatus) String() string { return proto.CompactTextString(m) }
func (*CentralUpgradeStatus) ProtoMessage()    {}
func (*CentralUpgradeStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_6e4bd547a0084fea, []int{1}
}
func (m *CentralUpgradeStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CentralUpgradeStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CentralUpgradeStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CentralUpgradeStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CentralUpgradeStatus.Merge(m, src)
}
func (m *CentralUpgradeStatus) XXX_Size() int {
	return m.Size()
}
func (m *CentralUpgradeStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_CentralUpgradeStatus.DiscardUnknown(m)
}

var xxx_messageInfo_CentralUpgradeStatus proto.InternalMessageInfo

func (m *CentralUpgradeStatus) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *CentralUpgradeStatus) GetForceRollbackTo() string {
	if m != nil {
		return m.ForceRollbackTo
	}
	return ""
}

func (m *CentralUpgradeStatus) GetCanRollbackAfterUpgrade() bool {
	if m != nil {
		return m.CanRollbackAfterUpgrade
	}
	return false
}

func (m *CentralUpgradeStatus) GetSpaceRequiredForRollbackAfterUpgrade() int64 {
	if m != nil {
		return m.SpaceRequiredForRollbackAfterUpgrade
	}
	return 0
}

func (m *CentralUpgradeStatus) GetSpaceAvailableForRollbackAfterUpgrade() int64 {
	if m != nil {
		return m.SpaceAvailableForRollbackAfterUpgrade
	}
	return 0
}

func (m *CentralUpgradeStatus) MessageClone() proto.Message {
	return m.Clone()
}
func (m *CentralUpgradeStatus) Clone() *CentralUpgradeStatus {
	if m == nil {
		return nil
	}
	cloned := new(CentralUpgradeStatus)
	*cloned = *m

	return cloned
}

func init() {
	proto.RegisterType((*GetUpgradeStatusResponse)(nil), "v1.GetUpgradeStatusResponse")
	proto.RegisterType((*CentralUpgradeStatus)(nil), "v1.CentralUpgradeStatus")
}

func init() {
	proto.RegisterFile("api/v1/central_health_service.proto", fileDescriptor_6e4bd547a0084fea)
}

var fileDescriptor_6e4bd547a0084fea = []byte{
	// 407 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x7c, 0x92, 0xcf, 0xaa, 0xd3, 0x40,
	0x14, 0xc6, 0x6f, 0x72, 0xfd, 0x77, 0x47, 0x44, 0x1d, 0x04, 0x43, 0xb8, 0xc4, 0x5a, 0x15, 0xeb,
	0x5d, 0x24, 0xa4, 0x2e, 0x05, 0xa1, 0x8a, 0x7f, 0xd6, 0xa9, 0xa2, 0x76, 0x13, 0x4e, 0xd3, 0xd3,
	0x76, 0x68, 0x9c, 0x13, 0x67, 0xa6, 0x83, 0x82, 0x2b, 0x5f, 0xc1, 0x8d, 0x8f, 0xe4, 0x46, 0x10,
	0x7c, 0x01, 0xa9, 0x3e, 0x88, 0x64, 0x92, 0x6a, 0x2b, 0xed, 0xdd, 0x25, 0xe7, 0x7c, 0xdf, 0x2f,
	0x87, 0x7c, 0x1f, 0xbb, 0x05, 0x95, 0x48, 0x6c, 0x9a, 0x14, 0x28, 0x8d, 0x82, 0x32, 0x9f, 0x23,
	0x94, 0x66, 0x9e, 0x6b, 0x54, 0x56, 0x14, 0x18, 0x57, 0x8a, 0x0c, 0x71, 0xdf, 0xa6, 0xe1, 0xf1,
	0x8c, 0x68, 0x56, 0x62, 0x52, 0xeb, 0x41, 0x4a, 0x32, 0x60, 0x04, 0x49, 0xdd, 0x28, 0x42, 0xde,
	0x62, 0xf0, 0x6d, 0x65, 0x3e, 0x34, 0xb3, 0xee, 0x88, 0x05, 0xcf, 0xd0, 0xbc, 0xac, 0x66, 0x0a,
	0x26, 0x38, 0x34, 0x60, 0x96, 0x3a, 0x43, 0x5d, 0x91, 0xd4, 0xc8, 0x1f, 0xb2, 0x4b, 0xcb, 0xcd,
	0x45, 0xe0, 0x75, 0xbc, 0xde, 0xc5, 0x7e, 0x10, 0xdb, 0x34, 0x7e, 0xdc, 0x9c, 0xb2, 0x6d, 0xdc,
	0x96, 0x77, 0xbf, 0xf9, 0xec, 0xda, 0x2e, 0x1d, 0x0f, 0xd8, 0x79, 0x8b, 0x4a, 0x0b, 0x92, 0x0e,
	0x79, 0x94, 0xad, 0x5f, 0xf9, 0x09, 0xbb, 0x3a, 0x25, 0x55, 0x60, 0xae, 0xa8, 0x2c, 0xc7, 0x50,
	0x2c, 0x72, 0x43, 0x81, 0xef, 0x34, 0x97, 0xdd, 0x22, 0x6b, 0xe7, 0x2f, 0x88, 0x3f, 0x60, 0x61,
	0x01, 0xf2, 0x9f, 0x12, 0xa6, 0x06, 0x55, 0xde, 0x9e, 0x10, 0x1c, 0x76, 0xbc, 0xde, 0x85, 0xec,
	0x7a, 0x01, 0x72, 0x6d, 0x19, 0xd4, 0xfb, 0xf6, 0x10, 0xfe, 0x8a, 0xdd, 0xd3, 0x15, 0xd4, 0x1f,
	0xc2, 0x77, 0x4b, 0xa1, 0x70, 0x92, 0x4f, 0x49, 0xed, 0x63, 0x9d, 0xe9, 0x78, 0xbd, 0xc3, 0xec,
	0xb6, 0x33, 0x64, 0xad, 0xfe, 0x29, 0xa9, 0x9d, 0xe0, 0x37, 0xec, 0xa4, 0x01, 0x83, 0x05, 0x51,
	0xc2, 0xb8, 0xc4, 0xd3, 0xc8, 0x67, 0x1d, 0xf9, 0x8e, 0x73, 0x0c, 0xd6, 0x86, 0x3d, 0xe8, 0xfe,
	0xc7, 0xbf, 0xbf, 0xf3, 0xb9, 0x2b, 0xc0, 0xb0, 0xc9, 0x9f, 0x4f, 0xd8, 0x95, 0xff, 0x33, 0xe4,
	0x47, 0x75, 0x48, 0x4f, 0xea, 0xa0, 0xc3, 0xe3, 0xfa, 0x71, 0x5f, 0xc8, 0xdd, 0xbb, 0x9f, 0x7e,
	0xfc, 0xfe, 0xec, 0xdf, 0xe4, 0x37, 0x36, 0x0a, 0xd6, 0xf4, 0x2b, 0x69, 0x8f, 0xd4, 0xce, 0xf0,
	0x28, 0xfe, 0xba, 0x8a, 0xbc, 0xef, 0xab, 0xc8, 0xfb, 0xb9, 0x8a, 0xbc, 0x2f, 0xbf, 0xa2, 0x03,
	0x16, 0x08, 0x8a, 0xb5, 0x81, 0x62, 0xa1, 0xe8, 0x7d, 0x53, 0xa7, 0x18, 0x2a, 0x11, 0xdb, 0x74,
	0xe4, 0xdb, 0xf4, 0xf5, 0xc1, 0xf8, 0x9c, 0x9b, 0xdd, 0xff, 0x13, 0x00, 0x00, 0xff, 0xff, 0x36,
	0x35, 0x2b, 0x1d, 0xbf, 0x02, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CentralHealthServiceClient is the client API for CentralHealthService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConnInterface.NewStream.
type CentralHealthServiceClient interface {
	GetUpgradeStatus(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*GetUpgradeStatusResponse, error)
}

type centralHealthServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCentralHealthServiceClient(cc grpc.ClientConnInterface) CentralHealthServiceClient {
	return &centralHealthServiceClient{cc}
}

func (c *centralHealthServiceClient) GetUpgradeStatus(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*GetUpgradeStatusResponse, error) {
	out := new(GetUpgradeStatusResponse)
	err := c.cc.Invoke(ctx, "/v1.CentralHealthService/GetUpgradeStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CentralHealthServiceServer is the server API for CentralHealthService service.
type CentralHealthServiceServer interface {
	GetUpgradeStatus(context.Context, *Empty) (*GetUpgradeStatusResponse, error)
}

// UnimplementedCentralHealthServiceServer can be embedded to have forward compatible implementations.
type UnimplementedCentralHealthServiceServer struct {
}

func (*UnimplementedCentralHealthServiceServer) GetUpgradeStatus(ctx context.Context, req *Empty) (*GetUpgradeStatusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetUpgradeStatus not implemented")
}

func RegisterCentralHealthServiceServer(s *grpc.Server, srv CentralHealthServiceServer) {
	s.RegisterService(&_CentralHealthService_serviceDesc, srv)
}

func _CentralHealthService_GetUpgradeStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CentralHealthServiceServer).GetUpgradeStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.CentralHealthService/GetUpgradeStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CentralHealthServiceServer).GetUpgradeStatus(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

var _CentralHealthService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1.CentralHealthService",
	HandlerType: (*CentralHealthServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetUpgradeStatus",
			Handler:    _CentralHealthService_GetUpgradeStatus_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/v1/central_health_service.proto",
}

func (m *GetUpgradeStatusResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetUpgradeStatusResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetUpgradeStatusResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.UpgradeStatus != nil {
		{
			size, err := m.UpgradeStatus.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintCentralHealthService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CentralUpgradeStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CentralUpgradeStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CentralUpgradeStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.SpaceAvailableForRollbackAfterUpgrade != 0 {
		i = encodeVarintCentralHealthService(dAtA, i, uint64(m.SpaceAvailableForRollbackAfterUpgrade))
		i--
		dAtA[i] = 0x28
	}
	if m.SpaceRequiredForRollbackAfterUpgrade != 0 {
		i = encodeVarintCentralHealthService(dAtA, i, uint64(m.SpaceRequiredForRollbackAfterUpgrade))
		i--
		dAtA[i] = 0x20
	}
	if m.CanRollbackAfterUpgrade {
		i--
		if m.CanRollbackAfterUpgrade {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.ForceRollbackTo) > 0 {
		i -= len(m.ForceRollbackTo)
		copy(dAtA[i:], m.ForceRollbackTo)
		i = encodeVarintCentralHealthService(dAtA, i, uint64(len(m.ForceRollbackTo)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Version) > 0 {
		i -= len(m.Version)
		copy(dAtA[i:], m.Version)
		i = encodeVarintCentralHealthService(dAtA, i, uint64(len(m.Version)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintCentralHealthService(dAtA []byte, offset int, v uint64) int {
	offset -= sovCentralHealthService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *GetUpgradeStatusResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.UpgradeStatus != nil {
		l = m.UpgradeStatus.Size()
		n += 1 + l + sovCentralHealthService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CentralUpgradeStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovCentralHealthService(uint64(l))
	}
	l = len(m.ForceRollbackTo)
	if l > 0 {
		n += 1 + l + sovCentralHealthService(uint64(l))
	}
	if m.CanRollbackAfterUpgrade {
		n += 2
	}
	if m.SpaceRequiredForRollbackAfterUpgrade != 0 {
		n += 1 + sovCentralHealthService(uint64(m.SpaceRequiredForRollbackAfterUpgrade))
	}
	if m.SpaceAvailableForRollbackAfterUpgrade != 0 {
		n += 1 + sovCentralHealthService(uint64(m.SpaceAvailableForRollbackAfterUpgrade))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovCentralHealthService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozCentralHealthService(x uint64) (n int) {
	return sovCentralHealthService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *GetUpgradeStatusResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCentralHealthService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetUpgradeStatusResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetUpgradeStatusResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpgradeStatus", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCentralHealthService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCentralHealthService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCentralHealthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UpgradeStatus == nil {
				m.UpgradeStatus = &CentralUpgradeStatus{}
			}
			if err := m.UpgradeStatus.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCentralHealthService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthCentralHealthService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CentralUpgradeStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCentralHealthService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CentralUpgradeStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CentralUpgradeStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCentralHealthService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCentralHealthService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCentralHealthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForceRollbackTo", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCentralHealthService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCentralHealthService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCentralHealthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ForceRollbackTo = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CanRollbackAfterUpgrade", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCentralHealthService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.CanRollbackAfterUpgrade = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpaceRequiredForRollbackAfterUpgrade", wireType)
			}
			m.SpaceRequiredForRollbackAfterUpgrade = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCentralHealthService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SpaceRequiredForRollbackAfterUpgrade |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpaceAvailableForRollbackAfterUpgrade", wireType)
			}
			m.SpaceAvailableForRollbackAfterUpgrade = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCentralHealthService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SpaceAvailableForRollbackAfterUpgrade |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipCentralHealthService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthCentralHealthService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipCentralHealthService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowCentralHealthService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCentralHealthService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCentralHealthService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthCentralHealthService
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupCentralHealthService
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthCentralHealthService
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthCentralHealthService        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowCentralHealthService          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupCentralHealthService = fmt.Errorf("proto: unexpected end of group")
)
