// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api/v1/cluster_service.proto

package v1

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	storage "github.com/stackrox/rox/generated/storage"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type DeploymentFormat int32

const (
	DeploymentFormat_KUBECTL     DeploymentFormat = 0
	DeploymentFormat_HELM        DeploymentFormat = 1
	DeploymentFormat_HELM_VALUES DeploymentFormat = 2
)

var DeploymentFormat_name = map[int32]string{
	0: "KUBECTL",
	1: "HELM",
	2: "HELM_VALUES",
}

var DeploymentFormat_value = map[string]int32{
	"KUBECTL":     0,
	"HELM":        1,
	"HELM_VALUES": 2,
}

func (x DeploymentFormat) String() string {
	return proto.EnumName(DeploymentFormat_name, int32(x))
}

func (DeploymentFormat) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e08f99f642c8548a, []int{0}
}

type LoadBalancerType int32

const (
	LoadBalancerType_NONE          LoadBalancerType = 0
	LoadBalancerType_LOAD_BALANCER LoadBalancerType = 1
	LoadBalancerType_NODE_PORT     LoadBalancerType = 2
	LoadBalancerType_ROUTE         LoadBalancerType = 3
)

var LoadBalancerType_name = map[int32]string{
	0: "NONE",
	1: "LOAD_BALANCER",
	2: "NODE_PORT",
	3: "ROUTE",
}

var LoadBalancerType_value = map[string]int32{
	"NONE":          0,
	"LOAD_BALANCER": 1,
	"NODE_PORT":     2,
	"ROUTE":         3,
}

func (x LoadBalancerType) String() string {
	return proto.EnumName(LoadBalancerType_name, int32(x))
}

func (LoadBalancerType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e08f99f642c8548a, []int{1}
}

type ClusterResponse struct {
	Cluster              *storage.Cluster `protobuf:"bytes,1,opt,name=cluster,proto3" json:"cluster,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ClusterResponse) Reset()         { *m = ClusterResponse{} }
func (m *ClusterResponse) String() string { return proto.CompactTextString(m) }
func (*ClusterResponse) ProtoMessage()    {}
func (*ClusterResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_e08f99f642c8548a, []int{0}
}
func (m *ClusterResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ClusterResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ClusterResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ClusterResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterResponse.Merge(m, src)
}
func (m *ClusterResponse) XXX_Size() int {
	return m.Size()
}
func (m *ClusterResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterResponse proto.InternalMessageInfo

func (m *ClusterResponse) GetCluster() *storage.Cluster {
	if m != nil {
		return m.Cluster
	}
	return nil
}

func (m *ClusterResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ClusterResponse) Clone() *ClusterResponse {
	if m == nil {
		return nil
	}
	cloned := new(ClusterResponse)
	*cloned = *m

	cloned.Cluster = m.Cluster.Clone()
	return cloned
}

type ClusterDefaultsResponse struct {
	MainImageRepository      string   `protobuf:"bytes,1,opt,name=main_image_repository,json=mainImageRepository,proto3" json:"main_image_repository,omitempty"`
	CollectorImageRepository string   `protobuf:"bytes,2,opt,name=collector_image_repository,json=collectorImageRepository,proto3" json:"collector_image_repository,omitempty"`
	KernelSupportAvailable   bool     `protobuf:"varint,3,opt,name=kernel_support_available,json=kernelSupportAvailable,proto3" json:"kernel_support_available,omitempty"`
	XXX_NoUnkeyedLiteral     struct{} `json:"-"`
	XXX_unrecognized         []byte   `json:"-"`
	XXX_sizecache            int32    `json:"-"`
}

func (m *ClusterDefaultsResponse) Reset()         { *m = ClusterDefaultsResponse{} }
func (m *ClusterDefaultsResponse) String() string { return proto.CompactTextString(m) }
func (*ClusterDefaultsResponse) ProtoMessage()    {}
func (*ClusterDefaultsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_e08f99f642c8548a, []int{1}
}
func (m *ClusterDefaultsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ClusterDefaultsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ClusterDefaultsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ClusterDefaultsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterDefaultsResponse.Merge(m, src)
}
func (m *ClusterDefaultsResponse) XXX_Size() int {
	return m.Size()
}
func (m *ClusterDefaultsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterDefaultsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterDefaultsResponse proto.InternalMessageInfo

func (m *ClusterDefaultsResponse) GetMainImageRepository() string {
	if m != nil {
		return m.MainImageRepository
	}
	return ""
}

func (m *ClusterDefaultsResponse) GetCollectorImageRepository() string {
	if m != nil {
		return m.CollectorImageRepository
	}
	return ""
}

func (m *ClusterDefaultsResponse) GetKernelSupportAvailable() bool {
	if m != nil {
		return m.KernelSupportAvailable
	}
	return false
}

func (m *ClusterDefaultsResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ClusterDefaultsResponse) Clone() *ClusterDefaultsResponse {
	if m == nil {
		return nil
	}
	cloned := new(ClusterDefaultsResponse)
	*cloned = *m

	return cloned
}

type ClustersList struct {
	Clusters             []*storage.Cluster `protobuf:"bytes,1,rep,name=clusters,proto3" json:"clusters,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *ClustersList) Reset()         { *m = ClustersList{} }
func (m *ClustersList) String() string { return proto.CompactTextString(m) }
func (*ClustersList) ProtoMessage()    {}
func (*ClustersList) Descriptor() ([]byte, []int) {
	return fileDescriptor_e08f99f642c8548a, []int{2}
}
func (m *ClustersList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ClustersList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ClustersList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ClustersList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClustersList.Merge(m, src)
}
func (m *ClustersList) XXX_Size() int {
	return m.Size()
}
func (m *ClustersList) XXX_DiscardUnknown() {
	xxx_messageInfo_ClustersList.DiscardUnknown(m)
}

var xxx_messageInfo_ClustersList proto.InternalMessageInfo

func (m *ClustersList) GetClusters() []*storage.Cluster {
	if m != nil {
		return m.Clusters
	}
	return nil
}

func (m *ClustersList) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ClustersList) Clone() *ClustersList {
	if m == nil {
		return nil
	}
	cloned := new(ClustersList)
	*cloned = *m

	if m.Clusters != nil {
		cloned.Clusters = make([]*storage.Cluster, len(m.Clusters))
		for idx, v := range m.Clusters {
			cloned.Clusters[idx] = v.Clone()
		}
	}
	return cloned
}

type GetClustersRequest struct {
	Query                string   `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetClustersRequest) Reset()         { *m = GetClustersRequest{} }
func (m *GetClustersRequest) String() string { return proto.CompactTextString(m) }
func (*GetClustersRequest) ProtoMessage()    {}
func (*GetClustersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e08f99f642c8548a, []int{3}
}
func (m *GetClustersRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetClustersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetClustersRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetClustersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetClustersRequest.Merge(m, src)
}
func (m *GetClustersRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetClustersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetClustersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetClustersRequest proto.InternalMessageInfo

func (m *GetClustersRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *GetClustersRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetClustersRequest) Clone() *GetClustersRequest {
	if m == nil {
		return nil
	}
	cloned := new(GetClustersRequest)
	*cloned = *m

	return cloned
}

// Deprecated: Do not use.
type KernelSupportAvailableResponse struct {
	KernelSupportAvailable bool     `protobuf:"varint,1,opt,name=kernel_support_available,json=kernelSupportAvailable,proto3" json:"kernel_support_available,omitempty"`
	XXX_NoUnkeyedLiteral   struct{} `json:"-"`
	XXX_unrecognized       []byte   `json:"-"`
	XXX_sizecache          int32    `json:"-"`
}

func (m *KernelSupportAvailableResponse) Reset()         { *m = KernelSupportAvailableResponse{} }
func (m *KernelSupportAvailableResponse) String() string { return proto.CompactTextString(m) }
func (*KernelSupportAvailableResponse) ProtoMessage()    {}
func (*KernelSupportAvailableResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_e08f99f642c8548a, []int{4}
}
func (m *KernelSupportAvailableResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *KernelSupportAvailableResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_KernelSupportAvailableResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *KernelSupportAvailableResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KernelSupportAvailableResponse.Merge(m, src)
}
func (m *KernelSupportAvailableResponse) XXX_Size() int {
	return m.Size()
}
func (m *KernelSupportAvailableResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_KernelSupportAvailableResponse.DiscardUnknown(m)
}

var xxx_messageInfo_KernelSupportAvailableResponse proto.InternalMessageInfo

func (m *KernelSupportAvailableResponse) GetKernelSupportAvailable() bool {
	if m != nil {
		return m.KernelSupportAvailable
	}
	return false
}

func (m *KernelSupportAvailableResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *KernelSupportAvailableResponse) Clone() *KernelSupportAvailableResponse {
	if m == nil {
		return nil
	}
	cloned := new(KernelSupportAvailableResponse)
	*cloned = *m

	return cloned
}

func init() {
	proto.RegisterEnum("v1.DeploymentFormat", DeploymentFormat_name, DeploymentFormat_value)
	proto.RegisterEnum("v1.LoadBalancerType", LoadBalancerType_name, LoadBalancerType_value)
	proto.RegisterType((*ClusterResponse)(nil), "v1.ClusterResponse")
	proto.RegisterType((*ClusterDefaultsResponse)(nil), "v1.ClusterDefaultsResponse")
	proto.RegisterType((*ClustersList)(nil), "v1.ClustersList")
	proto.RegisterType((*GetClustersRequest)(nil), "v1.GetClustersRequest")
	proto.RegisterType((*KernelSupportAvailableResponse)(nil), "v1.KernelSupportAvailableResponse")
}

func init() { proto.RegisterFile("api/v1/cluster_service.proto", fileDescriptor_e08f99f642c8548a) }

var fileDescriptor_e08f99f642c8548a = []byte{
	// 704 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x54, 0x4f, 0x4f, 0x13, 0x5f,
	0x14, 0xed, 0x1b, 0xe0, 0x07, 0x7d, 0x85, 0x1f, 0xc3, 0x2b, 0x7f, 0x4a, 0x25, 0x0d, 0x99, 0x15,
	0x56, 0x3b, 0x4d, 0xd1, 0x85, 0x21, 0xb8, 0x68, 0xe9, 0x88, 0x84, 0xd2, 0xe2, 0x50, 0x8c, 0x61,
	0xe1, 0xe4, 0x51, 0xae, 0xcd, 0x84, 0xe9, 0xbc, 0x61, 0xde, 0xeb, 0xc4, 0xc6, 0x98, 0x18, 0x57,
	0xee, 0xdd, 0xf8, 0x85, 0x4c, 0x5c, 0x9a, 0xf8, 0x05, 0x0c, 0xfa, 0x29, 0x5c, 0x99, 0xf9, 0xcb,
	0x08, 0x95, 0xc4, 0xdd, 0xcc, 0xb9, 0xe7, 0x9e, 0x7b, 0xcf, 0x7d, 0xf7, 0x3d, 0xbc, 0x46, 0x1d,
	0xb3, 0xea, 0xd5, 0xaa, 0x3d, 0x6b, 0xc8, 0x05, 0xb8, 0x06, 0x07, 0xd7, 0x33, 0x7b, 0xa0, 0x3a,
	0x2e, 0x13, 0x8c, 0x48, 0x5e, 0xad, 0xb8, 0xd6, 0x67, 0xac, 0x6f, 0x41, 0xd5, 0x27, 0x52, 0xdb,
	0x66, 0x82, 0x0a, 0x93, 0xd9, 0x3c, 0x64, 0x14, 0xf3, 0x71, 0x3e, 0x1b, 0x0c, 0x98, 0x1d, 0x81,
	0x24, 0x02, 0x61, 0xe0, 0x88, 0x51, 0x84, 0x2d, 0x71, 0xc1, 0x5c, 0xda, 0x87, 0xb8, 0x52, 0x08,
	0x2b, 0x8f, 0xf1, 0xfc, 0x4e, 0x08, 0xe8, 0xc0, 0x1d, 0x66, 0x73, 0x20, 0x65, 0x3c, 0x1d, 0x71,
	0x0a, 0x68, 0x1d, 0x6d, 0xe4, 0x36, 0x65, 0x35, 0xca, 0x55, 0x63, 0x6a, 0x4c, 0x50, 0x3e, 0x23,
	0xbc, 0x12, 0x81, 0x4d, 0x78, 0x45, 0x87, 0x96, 0xe0, 0x89, 0xce, 0x26, 0x5e, 0x1a, 0x50, 0xd3,
	0x36, 0xcc, 0x01, 0xed, 0x83, 0xe1, 0x82, 0xc3, 0xb8, 0x29, 0x98, 0x3b, 0x0a, 0x54, 0xb3, 0x7a,
	0xde, 0x0f, 0xee, 0xf9, 0x31, 0x3d, 0x09, 0x91, 0x6d, 0x5c, 0xec, 0x31, 0xcb, 0x82, 0x9e, 0x60,
	0xee, 0xcd, 0x44, 0x29, 0x48, 0x2c, 0x24, 0x8c, 0xeb, 0xd9, 0x8f, 0x70, 0xe1, 0x1c, 0x5c, 0x1b,
	0x2c, 0x83, 0x0f, 0x1d, 0x87, 0xb9, 0xc2, 0xa0, 0x1e, 0x35, 0x2d, 0x7a, 0x6a, 0x41, 0x61, 0x62,
	0x1d, 0x6d, 0xcc, 0xe8, 0xcb, 0x61, 0xfc, 0x28, 0x0c, 0xd7, 0xe3, 0xa8, 0xb2, 0x8d, 0x67, 0x23,
	0x1b, 0xbc, 0x65, 0x72, 0x41, 0xee, 0xe3, 0x99, 0xc8, 0x22, 0x2f, 0xa0, 0xf5, 0x89, 0xb1, 0x43,
	0x48, 0x18, 0x4a, 0x19, 0x93, 0x5d, 0x10, 0xb1, 0x80, 0x0e, 0x17, 0x43, 0xe0, 0x82, 0x2c, 0xe2,
	0xa9, 0x8b, 0x21, 0x24, 0x7e, 0xc3, 0x1f, 0xe5, 0x25, 0x2e, 0xed, 0x8f, 0xed, 0x21, 0x99, 0xdb,
	0x6d, 0x2e, 0xd0, 0x6d, 0x2e, 0xb6, 0xa4, 0x02, 0x2a, 0x6f, 0x61, 0xb9, 0x09, 0x8e, 0xc5, 0x46,
	0x03, 0xb0, 0xc5, 0x13, 0xe6, 0x0e, 0xa8, 0x20, 0x39, 0x3c, 0xbd, 0x7f, 0xdc, 0xd0, 0x76, 0xba,
	0x2d, 0x39, 0x43, 0x66, 0xf0, 0xe4, 0x53, 0xad, 0x75, 0x20, 0x23, 0x32, 0x8f, 0x73, 0xfe, 0x97,
	0xf1, 0xbc, 0xde, 0x3a, 0xd6, 0x8e, 0x64, 0xa9, 0xbc, 0x87, 0xe5, 0x16, 0xa3, 0x67, 0x0d, 0x6a,
	0x51, 0xbb, 0x07, 0x6e, 0x77, 0xe4, 0x80, 0x4f, 0x6f, 0x77, 0xda, 0x9a, 0x9c, 0x21, 0x0b, 0x78,
	0xae, 0xd5, 0xa9, 0x37, 0x8d, 0x46, 0xbd, 0x55, 0x6f, 0xef, 0x68, 0xba, 0x8c, 0xc8, 0x1c, 0xce,
	0xb6, 0x3b, 0x4d, 0xcd, 0x38, 0xec, 0xe8, 0x5d, 0x59, 0x22, 0x59, 0x3c, 0xa5, 0x77, 0x8e, 0xbb,
	0x9a, 0x3c, 0xb1, 0xf9, 0x6b, 0x32, 0x59, 0x2c, 0x7e, 0x14, 0xee, 0x34, 0x39, 0xc0, 0xb9, 0xd4,
	0x98, 0xc8, 0xb2, 0xea, 0xd5, 0xd4, 0x9b, 0x73, 0x2b, 0xca, 0x3e, 0x9e, 0x3e, 0x0d, 0x65, 0xf1,
	0xfd, 0xb7, 0x9f, 0x1f, 0xa5, 0xff, 0xc9, 0x6c, 0xea, 0xa6, 0x70, 0xd2, 0xc6, 0xf8, 0x2a, 0x9b,
	0x04, 0x59, 0x3a, 0x70, 0x36, 0x74, 0x7b, 0xd0, 0x18, 0xed, 0x35, 0x8b, 0xf9, 0x94, 0x4e, 0x3c,
	0x5c, 0x65, 0x35, 0x90, 0xca, 0x93, 0x85, 0xb4, 0x54, 0xf5, 0x8d, 0x79, 0xf6, 0xd6, 0x6f, 0xef,
	0x90, 0xf1, 0x94, 0xe0, 0xb5, 0x03, 0x1f, 0x2f, 0xb8, 0x12, 0x08, 0x2e, 0x28, 0x7f, 0xf4, 0xb6,
	0x85, 0xca, 0xe4, 0x19, 0xc6, 0x87, 0xc3, 0x7f, 0x55, 0x5b, 0x0b, 0xd4, 0x96, 0x8b, 0x37, 0xdb,
	0xf3, 0x25, 0x77, 0xf1, 0x5c, 0x13, 0x2c, 0x10, 0xf0, 0x77, 0xd3, 0x59, 0x1f, 0xd1, 0xfc, 0x7b,
	0x1f, 0x5b, 0x2d, 0x8f, 0xb1, 0xfa, 0x0e, 0xe1, 0xd5, 0x5d, 0x10, 0xe3, 0x17, 0x91, 0x5c, 0x69,
	0x14, 0x15, 0xff, 0xf3, 0xf6, 0x7d, 0x55, 0x1e, 0x06, 0x75, 0xee, 0x91, 0xbb, 0xe9, 0x3a, 0x15,
	0xb0, 0xbd, 0x6a, 0xb8, 0xa6, 0x95, 0x68, 0x8d, 0x2b, 0xc9, 0x1a, 0x7f, 0x90, 0x10, 0x39, 0x49,
	0xdf, 0x99, 0xf8, 0xed, 0x48, 0x97, 0xbe, 0x93, 0x9a, 0xcf, 0xf5, 0xb7, 0x25, 0x9e, 0x13, 0x59,
	0x4c, 0xd5, 0xac, 0x9c, 0x45, 0xac, 0x86, 0xfa, 0xe5, 0xb2, 0x84, 0xbe, 0x5e, 0x96, 0xd0, 0xf7,
	0xcb, 0x12, 0xfa, 0xf4, 0xa3, 0x94, 0xc1, 0x05, 0x93, 0xa9, 0x5c, 0xd0, 0xde, 0xb9, 0xcb, 0x5e,
	0x87, 0x2f, 0x9f, 0x4a, 0x1d, 0x53, 0xf5, 0x6a, 0x27, 0x92, 0x57, 0x7b, 0x91, 0x39, 0xfd, 0x2f,
	0xc0, 0x1e, 0xfc, 0x0e, 0x00, 0x00, 0xff, 0xff, 0xed, 0xe4, 0xa5, 0xba, 0x8f, 0x05, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ClustersServiceClient is the client API for ClustersService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConnInterface.NewStream.
type ClustersServiceClient interface {
	GetClusters(ctx context.Context, in *GetClustersRequest, opts ...grpc.CallOption) (*ClustersList, error)
	GetCluster(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*ClusterResponse, error)
	PostCluster(ctx context.Context, in *storage.Cluster, opts ...grpc.CallOption) (*ClusterResponse, error)
	PutCluster(ctx context.Context, in *storage.Cluster, opts ...grpc.CallOption) (*ClusterResponse, error)
	DeleteCluster(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*Empty, error)
	// GetKernelSupportAvailable is deprecated in favor of GetClusterDefaults.
	GetKernelSupportAvailable(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*KernelSupportAvailableResponse, error)
	GetClusterDefaults(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*ClusterDefaultsResponse, error)
}

type clustersServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewClustersServiceClient(cc grpc.ClientConnInterface) ClustersServiceClient {
	return &clustersServiceClient{cc}
}

func (c *clustersServiceClient) GetClusters(ctx context.Context, in *GetClustersRequest, opts ...grpc.CallOption) (*ClustersList, error) {
	out := new(ClustersList)
	err := c.cc.Invoke(ctx, "/v1.ClustersService/GetClusters", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clustersServiceClient) GetCluster(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*ClusterResponse, error) {
	out := new(ClusterResponse)
	err := c.cc.Invoke(ctx, "/v1.ClustersService/GetCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clustersServiceClient) PostCluster(ctx context.Context, in *storage.Cluster, opts ...grpc.CallOption) (*ClusterResponse, error) {
	out := new(ClusterResponse)
	err := c.cc.Invoke(ctx, "/v1.ClustersService/PostCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clustersServiceClient) PutCluster(ctx context.Context, in *storage.Cluster, opts ...grpc.CallOption) (*ClusterResponse, error) {
	out := new(ClusterResponse)
	err := c.cc.Invoke(ctx, "/v1.ClustersService/PutCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clustersServiceClient) DeleteCluster(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.ClustersService/DeleteCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *clustersServiceClient) GetKernelSupportAvailable(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*KernelSupportAvailableResponse, error) {
	out := new(KernelSupportAvailableResponse)
	err := c.cc.Invoke(ctx, "/v1.ClustersService/GetKernelSupportAvailable", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clustersServiceClient) GetClusterDefaults(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*ClusterDefaultsResponse, error) {
	out := new(ClusterDefaultsResponse)
	err := c.cc.Invoke(ctx, "/v1.ClustersService/GetClusterDefaults", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ClustersServiceServer is the server API for ClustersService service.
type ClustersServiceServer interface {
	GetClusters(context.Context, *GetClustersRequest) (*ClustersList, error)
	GetCluster(context.Context, *ResourceByID) (*ClusterResponse, error)
	PostCluster(context.Context, *storage.Cluster) (*ClusterResponse, error)
	PutCluster(context.Context, *storage.Cluster) (*ClusterResponse, error)
	DeleteCluster(context.Context, *ResourceByID) (*Empty, error)
	// GetKernelSupportAvailable is deprecated in favor of GetClusterDefaults.
	GetKernelSupportAvailable(context.Context, *Empty) (*KernelSupportAvailableResponse, error)
	GetClusterDefaults(context.Context, *Empty) (*ClusterDefaultsResponse, error)
}

// UnimplementedClustersServiceServer can be embedded to have forward compatible implementations.
type UnimplementedClustersServiceServer struct {
}

func (*UnimplementedClustersServiceServer) GetClusters(ctx context.Context, req *GetClustersRequest) (*ClustersList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetClusters not implemented")
}
func (*UnimplementedClustersServiceServer) GetCluster(ctx context.Context, req *ResourceByID) (*ClusterResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCluster not implemented")
}
func (*UnimplementedClustersServiceServer) PostCluster(ctx context.Context, req *storage.Cluster) (*ClusterResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PostCluster not implemented")
}
func (*UnimplementedClustersServiceServer) PutCluster(ctx context.Context, req *storage.Cluster) (*ClusterResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PutCluster not implemented")
}
func (*UnimplementedClustersServiceServer) DeleteCluster(ctx context.Context, req *ResourceByID) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCluster not implemented")
}
func (*UnimplementedClustersServiceServer) GetKernelSupportAvailable(ctx context.Context, req *Empty) (*KernelSupportAvailableResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetKernelSupportAvailable not implemented")
}
func (*UnimplementedClustersServiceServer) GetClusterDefaults(ctx context.Context, req *Empty) (*ClusterDefaultsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetClusterDefaults not implemented")
}

func RegisterClustersServiceServer(s *grpc.Server, srv ClustersServiceServer) {
	s.RegisterService(&_ClustersService_serviceDesc, srv)
}

func _ClustersService_GetClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClustersServiceServer).GetClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ClustersService/GetClusters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClustersServiceServer).GetClusters(ctx, req.(*GetClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClustersService_GetCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClustersServiceServer).GetCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ClustersService/GetCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClustersServiceServer).GetCluster(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClustersService_PostCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(storage.Cluster)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClustersServiceServer).PostCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ClustersService/PostCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClustersServiceServer).PostCluster(ctx, req.(*storage.Cluster))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClustersService_PutCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(storage.Cluster)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClustersServiceServer).PutCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ClustersService/PutCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClustersServiceServer).PutCluster(ctx, req.(*storage.Cluster))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClustersService_DeleteCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClustersServiceServer).DeleteCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ClustersService/DeleteCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClustersServiceServer).DeleteCluster(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClustersService_GetKernelSupportAvailable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClustersServiceServer).GetKernelSupportAvailable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ClustersService/GetKernelSupportAvailable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClustersServiceServer).GetKernelSupportAvailable(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClustersService_GetClusterDefaults_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClustersServiceServer).GetClusterDefaults(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ClustersService/GetClusterDefaults",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClustersServiceServer).GetClusterDefaults(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

var _ClustersService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1.ClustersService",
	HandlerType: (*ClustersServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetClusters",
			Handler:    _ClustersService_GetClusters_Handler,
		},
		{
			MethodName: "GetCluster",
			Handler:    _ClustersService_GetCluster_Handler,
		},
		{
			MethodName: "PostCluster",
			Handler:    _ClustersService_PostCluster_Handler,
		},
		{
			MethodName: "PutCluster",
			Handler:    _ClustersService_PutCluster_Handler,
		},
		{
			MethodName: "DeleteCluster",
			Handler:    _ClustersService_DeleteCluster_Handler,
		},
		{
			MethodName: "GetKernelSupportAvailable",
			Handler:    _ClustersService_GetKernelSupportAvailable_Handler,
		},
		{
			MethodName: "GetClusterDefaults",
			Handler:    _ClustersService_GetClusterDefaults_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/v1/cluster_service.proto",
}

func (m *ClusterResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClusterResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ClusterResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Cluster != nil {
		{
			size, err := m.Cluster.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintClusterService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ClusterDefaultsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClusterDefaultsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ClusterDefaultsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.KernelSupportAvailable {
		i--
		if m.KernelSupportAvailable {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.CollectorImageRepository) > 0 {
		i -= len(m.CollectorImageRepository)
		copy(dAtA[i:], m.CollectorImageRepository)
		i = encodeVarintClusterService(dAtA, i, uint64(len(m.CollectorImageRepository)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.MainImageRepository) > 0 {
		i -= len(m.MainImageRepository)
		copy(dAtA[i:], m.MainImageRepository)
		i = encodeVarintClusterService(dAtA, i, uint64(len(m.MainImageRepository)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ClustersList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClustersList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ClustersList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Clusters) > 0 {
		for iNdEx := len(m.Clusters) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Clusters[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintClusterService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *GetClustersRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetClustersRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetClustersRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Query) > 0 {
		i -= len(m.Query)
		copy(dAtA[i:], m.Query)
		i = encodeVarintClusterService(dAtA, i, uint64(len(m.Query)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *KernelSupportAvailableResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *KernelSupportAvailableResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *KernelSupportAvailableResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.KernelSupportAvailable {
		i--
		if m.KernelSupportAvailable {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintClusterService(dAtA []byte, offset int, v uint64) int {
	offset -= sovClusterService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ClusterResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Cluster != nil {
		l = m.Cluster.Size()
		n += 1 + l + sovClusterService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ClusterDefaultsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.MainImageRepository)
	if l > 0 {
		n += 1 + l + sovClusterService(uint64(l))
	}
	l = len(m.CollectorImageRepository)
	if l > 0 {
		n += 1 + l + sovClusterService(uint64(l))
	}
	if m.KernelSupportAvailable {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ClustersList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Clusters) > 0 {
		for _, e := range m.Clusters {
			l = e.Size()
			n += 1 + l + sovClusterService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetClustersRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Query)
	if l > 0 {
		n += 1 + l + sovClusterService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *KernelSupportAvailableResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.KernelSupportAvailable {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovClusterService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozClusterService(x uint64) (n int) {
	return sovClusterService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ClusterResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClusterService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClusterResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClusterResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cluster", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClusterService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClusterService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthClusterService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Cluster == nil {
				m.Cluster = &storage.Cluster{}
			}
			if err := m.Cluster.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipClusterService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthClusterService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClusterDefaultsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClusterService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClusterDefaultsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClusterDefaultsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MainImageRepository", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClusterService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClusterService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthClusterService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MainImageRepository = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CollectorImageRepository", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClusterService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClusterService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthClusterService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CollectorImageRepository = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KernelSupportAvailable", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClusterService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.KernelSupportAvailable = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipClusterService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthClusterService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClustersList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClusterService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClustersList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClustersList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Clusters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClusterService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClusterService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthClusterService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Clusters = append(m.Clusters, &storage.Cluster{})
			if err := m.Clusters[len(m.Clusters)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipClusterService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthClusterService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetClustersRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClusterService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetClustersRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetClustersRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClusterService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClusterService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthClusterService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Query = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipClusterService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthClusterService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *KernelSupportAvailableResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClusterService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: KernelSupportAvailableResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: KernelSupportAvailableResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KernelSupportAvailable", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClusterService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.KernelSupportAvailable = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipClusterService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthClusterService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipClusterService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowClusterService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowClusterService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowClusterService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthClusterService
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupClusterService
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthClusterService
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthClusterService        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowClusterService          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupClusterService = fmt.Errorf("proto: unexpected end of group")
)
