// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api/v1/compliance_management_service.proto

package v1

import (
	context "context"
	fmt "fmt"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	storage "github.com/stackrox/rox/generated/storage"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type ComplianceRun_State int32

const (
	ComplianceRun_INVALID          ComplianceRun_State = 0
	ComplianceRun_READY            ComplianceRun_State = 1
	ComplianceRun_STARTED          ComplianceRun_State = 2
	ComplianceRun_WAIT_FOR_DATA    ComplianceRun_State = 3
	ComplianceRun_EVALUTING_CHECKS ComplianceRun_State = 4
	ComplianceRun_FINISHED         ComplianceRun_State = 5
)

var ComplianceRun_State_name = map[int32]string{
	0: "INVALID",
	1: "READY",
	2: "STARTED",
	3: "WAIT_FOR_DATA",
	4: "EVALUTING_CHECKS",
	5: "FINISHED",
}

var ComplianceRun_State_value = map[string]int32{
	"INVALID":          0,
	"READY":            1,
	"STARTED":          2,
	"WAIT_FOR_DATA":    3,
	"EVALUTING_CHECKS": 4,
	"FINISHED":         5,
}

func (x ComplianceRun_State) String() string {
	return proto.EnumName(ComplianceRun_State_name, int32(x))
}

func (ComplianceRun_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_3a9dc9df4e5c8461, []int{11, 0}
}

type ComplianceRunScheduleInfo struct {
	Schedule             *storage.ComplianceRunSchedule `protobuf:"bytes,1,opt,name=schedule,proto3" json:"schedule,omitempty"`
	LastRun              *ComplianceRun                 `protobuf:"bytes,2,opt,name=last_run,json=lastRun,proto3" json:"last_run,omitempty"`
	LastCompletedRun     *ComplianceRun                 `protobuf:"bytes,3,opt,name=last_completed_run,json=lastCompletedRun,proto3" json:"last_completed_run,omitempty"`
	NextRunTime          *types.Timestamp               `protobuf:"bytes,4,opt,name=next_run_time,json=nextRunTime,proto3" json:"next_run_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *ComplianceRunScheduleInfo) Reset()         { *m = ComplianceRunScheduleInfo{} }
func (m *ComplianceRunScheduleInfo) String() string { return proto.CompactTextString(m) }
func (*ComplianceRunScheduleInfo) ProtoMessage()    {}
func (*ComplianceRunScheduleInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_3a9dc9df4e5c8461, []int{0}
}
func (m *ComplianceRunScheduleInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ComplianceRunScheduleInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ComplianceRunScheduleInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ComplianceRunScheduleInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ComplianceRunScheduleInfo.Merge(m, src)
}
func (m *ComplianceRunScheduleInfo) XXX_Size() int {
	return m.Size()
}
func (m *ComplianceRunScheduleInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ComplianceRunScheduleInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ComplianceRunScheduleInfo proto.InternalMessageInfo

func (m *ComplianceRunScheduleInfo) GetSchedule() *storage.ComplianceRunSchedule {
	if m != nil {
		return m.Schedule
	}
	return nil
}

func (m *ComplianceRunScheduleInfo) GetLastRun() *ComplianceRun {
	if m != nil {
		return m.LastRun
	}
	return nil
}

func (m *ComplianceRunScheduleInfo) GetLastCompletedRun() *ComplianceRun {
	if m != nil {
		return m.LastCompletedRun
	}
	return nil
}

func (m *ComplianceRunScheduleInfo) GetNextRunTime() *types.Timestamp {
	if m != nil {
		return m.NextRunTime
	}
	return nil
}

func (m *ComplianceRunScheduleInfo) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ComplianceRunScheduleInfo) Clone() *ComplianceRunScheduleInfo {
	if m == nil {
		return nil
	}
	cloned := new(ComplianceRunScheduleInfo)
	*cloned = *m

	cloned.Schedule = m.Schedule.Clone()
	cloned.LastRun = m.LastRun.Clone()
	cloned.LastCompletedRun = m.LastCompletedRun.Clone()
	cloned.NextRunTime = m.NextRunTime.Clone()
	return cloned
}

type GetComplianceRunSchedulesRequest struct {
	// Types that are valid to be assigned to ClusterIdOpt:
	//	*GetComplianceRunSchedulesRequest_ClusterId
	ClusterIdOpt isGetComplianceRunSchedulesRequest_ClusterIdOpt `protobuf_oneof:"cluster_id_opt"`
	// Types that are valid to be assigned to StandardIdOpt:
	//	*GetComplianceRunSchedulesRequest_StandardId
	StandardIdOpt isGetComplianceRunSchedulesRequest_StandardIdOpt `protobuf_oneof:"standard_id_opt"`
	// Types that are valid to be assigned to SuspendedOpt:
	//	*GetComplianceRunSchedulesRequest_Suspended
	SuspendedOpt         isGetComplianceRunSchedulesRequest_SuspendedOpt `protobuf_oneof:"suspended_opt"`
	XXX_NoUnkeyedLiteral struct{}                                        `json:"-"`
	XXX_unrecognized     []byte                                          `json:"-"`
	XXX_sizecache        int32                                           `json:"-"`
}

func (m *GetComplianceRunSchedulesRequest) Reset()         { *m = GetComplianceRunSchedulesRequest{} }
func (m *GetComplianceRunSchedulesRequest) String() string { return proto.CompactTextString(m) }
func (*GetComplianceRunSchedulesRequest) ProtoMessage()    {}
func (*GetComplianceRunSchedulesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3a9dc9df4e5c8461, []int{1}
}
func (m *GetComplianceRunSchedulesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetComplianceRunSchedulesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetComplianceRunSchedulesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetComplianceRunSchedulesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetComplianceRunSchedulesRequest.Merge(m, src)
}
func (m *GetComplianceRunSchedulesRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetComplianceRunSchedulesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetComplianceRunSchedulesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetComplianceRunSchedulesRequest proto.InternalMessageInfo

type isGetComplianceRunSchedulesRequest_ClusterIdOpt interface {
	isGetComplianceRunSchedulesRequest_ClusterIdOpt()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isGetComplianceRunSchedulesRequest_ClusterIdOpt
}
type isGetComplianceRunSchedulesRequest_StandardIdOpt interface {
	isGetComplianceRunSchedulesRequest_StandardIdOpt()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isGetComplianceRunSchedulesRequest_StandardIdOpt
}
type isGetComplianceRunSchedulesRequest_SuspendedOpt interface {
	isGetComplianceRunSchedulesRequest_SuspendedOpt()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isGetComplianceRunSchedulesRequest_SuspendedOpt
}

type GetComplianceRunSchedulesRequest_ClusterId struct {
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3,oneof" json:"cluster_id,omitempty"`
}
type GetComplianceRunSchedulesRequest_StandardId struct {
	StandardId string `protobuf:"bytes,2,opt,name=standard_id,json=standardId,proto3,oneof" json:"standard_id,omitempty"`
}
type GetComplianceRunSchedulesRequest_Suspended struct {
	Suspended bool `protobuf:"varint,3,opt,name=suspended,proto3,oneof" json:"suspended,omitempty"`
}

func (*GetComplianceRunSchedulesRequest_ClusterId) isGetComplianceRunSchedulesRequest_ClusterIdOpt() {
}
func (m *GetComplianceRunSchedulesRequest_ClusterId) Clone() isGetComplianceRunSchedulesRequest_ClusterIdOpt {
	if m == nil {
		return nil
	}
	cloned := new(GetComplianceRunSchedulesRequest_ClusterId)
	*cloned = *m

	return cloned
}
func (*GetComplianceRunSchedulesRequest_StandardId) isGetComplianceRunSchedulesRequest_StandardIdOpt() {
}
func (m *GetComplianceRunSchedulesRequest_StandardId) Clone() isGetComplianceRunSchedulesRequest_StandardIdOpt {
	if m == nil {
		return nil
	}
	cloned := new(GetComplianceRunSchedulesRequest_StandardId)
	*cloned = *m

	return cloned
}
func (*GetComplianceRunSchedulesRequest_Suspended) isGetComplianceRunSchedulesRequest_SuspendedOpt() {
}
func (m *GetComplianceRunSchedulesRequest_Suspended) Clone() isGetComplianceRunSchedulesRequest_SuspendedOpt {
	if m == nil {
		return nil
	}
	cloned := new(GetComplianceRunSchedulesRequest_Suspended)
	*cloned = *m

	return cloned
}

func (m *GetComplianceRunSchedulesRequest) GetClusterIdOpt() isGetComplianceRunSchedulesRequest_ClusterIdOpt {
	if m != nil {
		return m.ClusterIdOpt
	}
	return nil
}
func (m *GetComplianceRunSchedulesRequest) GetStandardIdOpt() isGetComplianceRunSchedulesRequest_StandardIdOpt {
	if m != nil {
		return m.StandardIdOpt
	}
	return nil
}
func (m *GetComplianceRunSchedulesRequest) GetSuspendedOpt() isGetComplianceRunSchedulesRequest_SuspendedOpt {
	if m != nil {
		return m.SuspendedOpt
	}
	return nil
}

func (m *GetComplianceRunSchedulesRequest) GetClusterId() string {
	if x, ok := m.GetClusterIdOpt().(*GetComplianceRunSchedulesRequest_ClusterId); ok {
		return x.ClusterId
	}
	return ""
}

func (m *GetComplianceRunSchedulesRequest) GetStandardId() string {
	if x, ok := m.GetStandardIdOpt().(*GetComplianceRunSchedulesRequest_StandardId); ok {
		return x.StandardId
	}
	return ""
}

func (m *GetComplianceRunSchedulesRequest) GetSuspended() bool {
	if x, ok := m.GetSuspendedOpt().(*GetComplianceRunSchedulesRequest_Suspended); ok {
		return x.Suspended
	}
	return false
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*GetComplianceRunSchedulesRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*GetComplianceRunSchedulesRequest_ClusterId)(nil),
		(*GetComplianceRunSchedulesRequest_StandardId)(nil),
		(*GetComplianceRunSchedulesRequest_Suspended)(nil),
	}
}

func (m *GetComplianceRunSchedulesRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetComplianceRunSchedulesRequest) Clone() *GetComplianceRunSchedulesRequest {
	if m == nil {
		return nil
	}
	cloned := new(GetComplianceRunSchedulesRequest)
	*cloned = *m

	if m.ClusterIdOpt != nil {
		cloned.ClusterIdOpt = m.ClusterIdOpt.Clone()
	}
	if m.StandardIdOpt != nil {
		cloned.StandardIdOpt = m.StandardIdOpt.Clone()
	}
	if m.SuspendedOpt != nil {
		cloned.SuspendedOpt = m.SuspendedOpt.Clone()
	}
	return cloned
}

type GetComplianceRunSchedulesResponse struct {
	Schedules            []*ComplianceRunScheduleInfo `protobuf:"bytes,1,rep,name=schedules,proto3" json:"schedules,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *GetComplianceRunSchedulesResponse) Reset()         { *m = GetComplianceRunSchedulesResponse{} }
func (m *GetComplianceRunSchedulesResponse) String() string { return proto.CompactTextString(m) }
func (*GetComplianceRunSchedulesResponse) ProtoMessage()    {}
func (*GetComplianceRunSchedulesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3a9dc9df4e5c8461, []int{2}
}
func (m *GetComplianceRunSchedulesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetComplianceRunSchedulesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetComplianceRunSchedulesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetComplianceRunSchedulesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetComplianceRunSchedulesResponse.Merge(m, src)
}
func (m *GetComplianceRunSchedulesResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetComplianceRunSchedulesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetComplianceRunSchedulesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetComplianceRunSchedulesResponse proto.InternalMessageInfo

func (m *GetComplianceRunSchedulesResponse) GetSchedules() []*ComplianceRunScheduleInfo {
	if m != nil {
		return m.Schedules
	}
	return nil
}

func (m *GetComplianceRunSchedulesResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetComplianceRunSchedulesResponse) Clone() *GetComplianceRunSchedulesResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetComplianceRunSchedulesResponse)
	*cloned = *m

	if m.Schedules != nil {
		cloned.Schedules = make([]*ComplianceRunScheduleInfo, len(m.Schedules))
		for idx, v := range m.Schedules {
			cloned.Schedules[idx] = v.Clone()
		}
	}
	return cloned
}

type AddComplianceRunScheduleRequest struct {
	ScheduleSpec         *storage.ComplianceRunSchedule `protobuf:"bytes,1,opt,name=schedule_spec,json=scheduleSpec,proto3" json:"schedule_spec,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *AddComplianceRunScheduleRequest) Reset()         { *m = AddComplianceRunScheduleRequest{} }
func (m *AddComplianceRunScheduleRequest) String() string { return proto.CompactTextString(m) }
func (*AddComplianceRunScheduleRequest) ProtoMessage()    {}
func (*AddComplianceRunScheduleRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3a9dc9df4e5c8461, []int{3}
}
func (m *AddComplianceRunScheduleRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AddComplianceRunScheduleRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AddComplianceRunScheduleRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AddComplianceRunScheduleRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddComplianceRunScheduleRequest.Merge(m, src)
}
func (m *AddComplianceRunScheduleRequest) XXX_Size() int {
	return m.Size()
}
func (m *AddComplianceRunScheduleRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AddComplianceRunScheduleRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AddComplianceRunScheduleRequest proto.InternalMessageInfo

func (m *AddComplianceRunScheduleRequest) GetScheduleSpec() *storage.ComplianceRunSchedule {
	if m != nil {
		return m.ScheduleSpec
	}
	return nil
}

func (m *AddComplianceRunScheduleRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *AddComplianceRunScheduleRequest) Clone() *AddComplianceRunScheduleRequest {
	if m == nil {
		return nil
	}
	cloned := new(AddComplianceRunScheduleRequest)
	*cloned = *m

	cloned.ScheduleSpec = m.ScheduleSpec.Clone()
	return cloned
}

type AddComplianceRunScheduleResponse struct {
	AddedSchedule        *ComplianceRunScheduleInfo `protobuf:"bytes,1,opt,name=added_schedule,json=addedSchedule,proto3" json:"added_schedule,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *AddComplianceRunScheduleResponse) Reset()         { *m = AddComplianceRunScheduleResponse{} }
func (m *AddComplianceRunScheduleResponse) String() string { return proto.CompactTextString(m) }
func (*AddComplianceRunScheduleResponse) ProtoMessage()    {}
func (*AddComplianceRunScheduleResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3a9dc9df4e5c8461, []int{4}
}
func (m *AddComplianceRunScheduleResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AddComplianceRunScheduleResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AddComplianceRunScheduleResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AddComplianceRunScheduleResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddComplianceRunScheduleResponse.Merge(m, src)
}
func (m *AddComplianceRunScheduleResponse) XXX_Size() int {
	return m.Size()
}
func (m *AddComplianceRunScheduleResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AddComplianceRunScheduleResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AddComplianceRunScheduleResponse proto.InternalMessageInfo

func (m *AddComplianceRunScheduleResponse) GetAddedSchedule() *ComplianceRunScheduleInfo {
	if m != nil {
		return m.AddedSchedule
	}
	return nil
}

func (m *AddComplianceRunScheduleResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *AddComplianceRunScheduleResponse) Clone() *AddComplianceRunScheduleResponse {
	if m == nil {
		return nil
	}
	cloned := new(AddComplianceRunScheduleResponse)
	*cloned = *m

	cloned.AddedSchedule = m.AddedSchedule.Clone()
	return cloned
}

type UpdateComplianceRunScheduleRequest struct {
	ScheduleId           string                         `protobuf:"bytes,1,opt,name=schedule_id,json=scheduleId,proto3" json:"schedule_id,omitempty"`
	UpdatedSpec          *storage.ComplianceRunSchedule `protobuf:"bytes,2,opt,name=updated_spec,json=updatedSpec,proto3" json:"updated_spec,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *UpdateComplianceRunScheduleRequest) Reset()         { *m = UpdateComplianceRunScheduleRequest{} }
func (m *UpdateComplianceRunScheduleRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateComplianceRunScheduleRequest) ProtoMessage()    {}
func (*UpdateComplianceRunScheduleRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3a9dc9df4e5c8461, []int{5}
}
func (m *UpdateComplianceRunScheduleRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpdateComplianceRunScheduleRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UpdateComplianceRunScheduleRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UpdateComplianceRunScheduleRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateComplianceRunScheduleRequest.Merge(m, src)
}
func (m *UpdateComplianceRunScheduleRequest) XXX_Size() int {
	return m.Size()
}
func (m *UpdateComplianceRunScheduleRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateComplianceRunScheduleRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateComplianceRunScheduleRequest proto.InternalMessageInfo

func (m *UpdateComplianceRunScheduleRequest) GetScheduleId() string {
	if m != nil {
		return m.ScheduleId
	}
	return ""
}

func (m *UpdateComplianceRunScheduleRequest) GetUpdatedSpec() *storage.ComplianceRunSchedule {
	if m != nil {
		return m.UpdatedSpec
	}
	return nil
}

func (m *UpdateComplianceRunScheduleRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *UpdateComplianceRunScheduleRequest) Clone() *UpdateComplianceRunScheduleRequest {
	if m == nil {
		return nil
	}
	cloned := new(UpdateComplianceRunScheduleRequest)
	*cloned = *m

	cloned.UpdatedSpec = m.UpdatedSpec.Clone()
	return cloned
}

type UpdateComplianceRunScheduleResponse struct {
	UpdatedSchedule      *ComplianceRunScheduleInfo `protobuf:"bytes,1,opt,name=updated_schedule,json=updatedSchedule,proto3" json:"updated_schedule,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *UpdateComplianceRunScheduleResponse) Reset()         { *m = UpdateComplianceRunScheduleResponse{} }
func (m *UpdateComplianceRunScheduleResponse) String() string { return proto.CompactTextString(m) }
func (*UpdateComplianceRunScheduleResponse) ProtoMessage()    {}
func (*UpdateComplianceRunScheduleResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3a9dc9df4e5c8461, []int{6}
}
func (m *UpdateComplianceRunScheduleResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpdateComplianceRunScheduleResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UpdateComplianceRunScheduleResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UpdateComplianceRunScheduleResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateComplianceRunScheduleResponse.Merge(m, src)
}
func (m *UpdateComplianceRunScheduleResponse) XXX_Size() int {
	return m.Size()
}
func (m *UpdateComplianceRunScheduleResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateComplianceRunScheduleResponse.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateComplianceRunScheduleResponse proto.InternalMessageInfo

func (m *UpdateComplianceRunScheduleResponse) GetUpdatedSchedule() *ComplianceRunScheduleInfo {
	if m != nil {
		return m.UpdatedSchedule
	}
	return nil
}

func (m *UpdateComplianceRunScheduleResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *UpdateComplianceRunScheduleResponse) Clone() *UpdateComplianceRunScheduleResponse {
	if m == nil {
		return nil
	}
	cloned := new(UpdateComplianceRunScheduleResponse)
	*cloned = *m

	cloned.UpdatedSchedule = m.UpdatedSchedule.Clone()
	return cloned
}

type DeleteComplianceRunScheduleRequest struct {
	ScheduleId           string   `protobuf:"bytes,1,opt,name=schedule_id,json=scheduleId,proto3" json:"schedule_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteComplianceRunScheduleRequest) Reset()         { *m = DeleteComplianceRunScheduleRequest{} }
func (m *DeleteComplianceRunScheduleRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteComplianceRunScheduleRequest) ProtoMessage()    {}
func (*DeleteComplianceRunScheduleRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3a9dc9df4e5c8461, []int{7}
}
func (m *DeleteComplianceRunScheduleRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeleteComplianceRunScheduleRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeleteComplianceRunScheduleRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeleteComplianceRunScheduleRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteComplianceRunScheduleRequest.Merge(m, src)
}
func (m *DeleteComplianceRunScheduleRequest) XXX_Size() int {
	return m.Size()
}
func (m *DeleteComplianceRunScheduleRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteComplianceRunScheduleRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteComplianceRunScheduleRequest proto.InternalMessageInfo

func (m *DeleteComplianceRunScheduleRequest) GetScheduleId() string {
	if m != nil {
		return m.ScheduleId
	}
	return ""
}

func (m *DeleteComplianceRunScheduleRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *DeleteComplianceRunScheduleRequest) Clone() *DeleteComplianceRunScheduleRequest {
	if m == nil {
		return nil
	}
	cloned := new(DeleteComplianceRunScheduleRequest)
	*cloned = *m

	return cloned
}

type ComplianceRunSelection struct {
	// The ID of the cluster. "*" means "all clusters".
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// The ID of the compliance standard. "*" means "all standards".
	StandardId           string   `protobuf:"bytes,2,opt,name=standard_id,json=standardId,proto3" json:"standard_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ComplianceRunSelection) Reset()         { *m = ComplianceRunSelection{} }
func (m *ComplianceRunSelection) String() string { return proto.CompactTextString(m) }
func (*ComplianceRunSelection) ProtoMessage()    {}
func (*ComplianceRunSelection) Descriptor() ([]byte, []int) {
	return fileDescriptor_3a9dc9df4e5c8461, []int{8}
}
func (m *ComplianceRunSelection) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ComplianceRunSelection) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ComplianceRunSelection.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ComplianceRunSelection) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ComplianceRunSelection.Merge(m, src)
}
func (m *ComplianceRunSelection) XXX_Size() int {
	return m.Size()
}
func (m *ComplianceRunSelection) XXX_DiscardUnknown() {
	xxx_messageInfo_ComplianceRunSelection.DiscardUnknown(m)
}

var xxx_messageInfo_ComplianceRunSelection proto.InternalMessageInfo

func (m *ComplianceRunSelection) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ComplianceRunSelection) GetStandardId() string {
	if m != nil {
		return m.StandardId
	}
	return ""
}

func (m *ComplianceRunSelection) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ComplianceRunSelection) Clone() *ComplianceRunSelection {
	if m == nil {
		return nil
	}
	cloned := new(ComplianceRunSelection)
	*cloned = *m

	return cloned
}

type GetActiveComplianceRunsRequest struct {
	Selection            *ComplianceRunSelection `protobuf:"bytes,1,opt,name=selection,proto3" json:"selection,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *GetActiveComplianceRunsRequest) Reset()         { *m = GetActiveComplianceRunsRequest{} }
func (m *GetActiveComplianceRunsRequest) String() string { return proto.CompactTextString(m) }
func (*GetActiveComplianceRunsRequest) ProtoMessage()    {}
func (*GetActiveComplianceRunsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3a9dc9df4e5c8461, []int{9}
}
func (m *GetActiveComplianceRunsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetActiveComplianceRunsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetActiveComplianceRunsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetActiveComplianceRunsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetActiveComplianceRunsRequest.Merge(m, src)
}
func (m *GetActiveComplianceRunsRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetActiveComplianceRunsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetActiveComplianceRunsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetActiveComplianceRunsRequest proto.InternalMessageInfo

func (m *GetActiveComplianceRunsRequest) GetSelection() *ComplianceRunSelection {
	if m != nil {
		return m.Selection
	}
	return nil
}

func (m *GetActiveComplianceRunsRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetActiveComplianceRunsRequest) Clone() *GetActiveComplianceRunsRequest {
	if m == nil {
		return nil
	}
	cloned := new(GetActiveComplianceRunsRequest)
	*cloned = *m

	cloned.Selection = m.Selection.Clone()
	return cloned
}

type GetActiveComplianceRunsResponse struct {
	ActiveRuns           []*ComplianceRun `protobuf:"bytes,1,rep,name=active_runs,json=activeRuns,proto3" json:"active_runs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *GetActiveComplianceRunsResponse) Reset()         { *m = GetActiveComplianceRunsResponse{} }
func (m *GetActiveComplianceRunsResponse) String() string { return proto.CompactTextString(m) }
func (*GetActiveComplianceRunsResponse) ProtoMessage()    {}
func (*GetActiveComplianceRunsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3a9dc9df4e5c8461, []int{10}
}
func (m *GetActiveComplianceRunsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetActiveComplianceRunsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetActiveComplianceRunsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetActiveComplianceRunsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetActiveComplianceRunsResponse.Merge(m, src)
}
func (m *GetActiveComplianceRunsResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetActiveComplianceRunsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetActiveComplianceRunsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetActiveComplianceRunsResponse proto.InternalMessageInfo

func (m *GetActiveComplianceRunsResponse) GetActiveRuns() []*ComplianceRun {
	if m != nil {
		return m.ActiveRuns
	}
	return nil
}

func (m *GetActiveComplianceRunsResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetActiveComplianceRunsResponse) Clone() *GetActiveComplianceRunsResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetActiveComplianceRunsResponse)
	*cloned = *m

	if m.ActiveRuns != nil {
		cloned.ActiveRuns = make([]*ComplianceRun, len(m.ActiveRuns))
		for idx, v := range m.ActiveRuns {
			cloned.ActiveRuns[idx] = v.Clone()
		}
	}
	return cloned
}

type ComplianceRun struct {
	Id                   string              `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	ClusterId            string              `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	StandardId           string              `protobuf:"bytes,3,opt,name=standard_id,json=standardId,proto3" json:"standard_id,omitempty"`
	ScheduleId           string              `protobuf:"bytes,4,opt,name=schedule_id,json=scheduleId,proto3" json:"schedule_id,omitempty"`
	StartTime            *types.Timestamp    `protobuf:"bytes,5,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	FinishTime           *types.Timestamp    `protobuf:"bytes,6,opt,name=finish_time,json=finishTime,proto3" json:"finish_time,omitempty"`
	State                ComplianceRun_State `protobuf:"varint,7,opt,name=state,proto3,enum=v1.ComplianceRun_State" json:"state,omitempty"`
	ErrorMessage         string              `protobuf:"bytes,8,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *ComplianceRun) Reset()         { *m = ComplianceRun{} }
func (m *ComplianceRun) String() string { return proto.CompactTextString(m) }
func (*ComplianceRun) ProtoMessage()    {}
func (*ComplianceRun) Descriptor() ([]byte, []int) {
	return fileDescriptor_3a9dc9df4e5c8461, []int{11}
}
func (m *ComplianceRun) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ComplianceRun) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ComplianceRun.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ComplianceRun) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ComplianceRun.Merge(m, src)
}
func (m *ComplianceRun) XXX_Size() int {
	return m.Size()
}
func (m *ComplianceRun) XXX_DiscardUnknown() {
	xxx_messageInfo_ComplianceRun.DiscardUnknown(m)
}

var xxx_messageInfo_ComplianceRun proto.InternalMessageInfo

func (m *ComplianceRun) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ComplianceRun) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ComplianceRun) GetStandardId() string {
	if m != nil {
		return m.StandardId
	}
	return ""
}

func (m *ComplianceRun) GetScheduleId() string {
	if m != nil {
		return m.ScheduleId
	}
	return ""
}

func (m *ComplianceRun) GetStartTime() *types.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *ComplianceRun) GetFinishTime() *types.Timestamp {
	if m != nil {
		return m.FinishTime
	}
	return nil
}

func (m *ComplianceRun) GetState() ComplianceRun_State {
	if m != nil {
		return m.State
	}
	return ComplianceRun_INVALID
}

func (m *ComplianceRun) GetErrorMessage() string {
	if m != nil {
		return m.ErrorMessage
	}
	return ""
}

func (m *ComplianceRun) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ComplianceRun) Clone() *ComplianceRun {
	if m == nil {
		return nil
	}
	cloned := new(ComplianceRun)
	*cloned = *m

	cloned.StartTime = m.StartTime.Clone()
	cloned.FinishTime = m.FinishTime.Clone()
	return cloned
}

type GetRecentComplianceRunsRequest struct {
	// Types that are valid to be assigned to ClusterIdOpt:
	//	*GetRecentComplianceRunsRequest_ClusterId
	ClusterIdOpt isGetRecentComplianceRunsRequest_ClusterIdOpt `protobuf_oneof:"cluster_id_opt"`
	// Types that are valid to be assigned to StandardIdOpt:
	//	*GetRecentComplianceRunsRequest_StandardId
	StandardIdOpt        isGetRecentComplianceRunsRequest_StandardIdOpt `protobuf_oneof:"standard_id_opt"`
	Since                *types.Timestamp                               `protobuf:"bytes,3,opt,name=since,proto3" json:"since,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                       `json:"-"`
	XXX_unrecognized     []byte                                         `json:"-"`
	XXX_sizecache        int32                                          `json:"-"`
}

func (m *GetRecentComplianceRunsRequest) Reset()         { *m = GetRecentComplianceRunsRequest{} }
func (m *GetRecentComplianceRunsRequest) String() string { return proto.CompactTextString(m) }
func (*GetRecentComplianceRunsRequest) ProtoMessage()    {}
func (*GetRecentComplianceRunsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3a9dc9df4e5c8461, []int{12}
}
func (m *GetRecentComplianceRunsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetRecentComplianceRunsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetRecentComplianceRunsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetRecentComplianceRunsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetRecentComplianceRunsRequest.Merge(m, src)
}
func (m *GetRecentComplianceRunsRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetRecentComplianceRunsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetRecentComplianceRunsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetRecentComplianceRunsRequest proto.InternalMessageInfo

type isGetRecentComplianceRunsRequest_ClusterIdOpt interface {
	isGetRecentComplianceRunsRequest_ClusterIdOpt()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isGetRecentComplianceRunsRequest_ClusterIdOpt
}
type isGetRecentComplianceRunsRequest_StandardIdOpt interface {
	isGetRecentComplianceRunsRequest_StandardIdOpt()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isGetRecentComplianceRunsRequest_StandardIdOpt
}

type GetRecentComplianceRunsRequest_ClusterId struct {
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3,oneof" json:"cluster_id,omitempty"`
}
type GetRecentComplianceRunsRequest_StandardId struct {
	StandardId string `protobuf:"bytes,2,opt,name=standard_id,json=standardId,proto3,oneof" json:"standard_id,omitempty"`
}

func (*GetRecentComplianceRunsRequest_ClusterId) isGetRecentComplianceRunsRequest_ClusterIdOpt() {}
func (m *GetRecentComplianceRunsRequest_ClusterId) Clone() isGetRecentComplianceRunsRequest_ClusterIdOpt {
	if m == nil {
		return nil
	}
	cloned := new(GetRecentComplianceRunsRequest_ClusterId)
	*cloned = *m

	return cloned
}
func (*GetRecentComplianceRunsRequest_StandardId) isGetRecentComplianceRunsRequest_StandardIdOpt() {}
func (m *GetRecentComplianceRunsRequest_StandardId) Clone() isGetRecentComplianceRunsRequest_StandardIdOpt {
	if m == nil {
		return nil
	}
	cloned := new(GetRecentComplianceRunsRequest_StandardId)
	*cloned = *m

	return cloned
}

func (m *GetRecentComplianceRunsRequest) GetClusterIdOpt() isGetRecentComplianceRunsRequest_ClusterIdOpt {
	if m != nil {
		return m.ClusterIdOpt
	}
	return nil
}
func (m *GetRecentComplianceRunsRequest) GetStandardIdOpt() isGetRecentComplianceRunsRequest_StandardIdOpt {
	if m != nil {
		return m.StandardIdOpt
	}
	return nil
}

func (m *GetRecentComplianceRunsRequest) GetClusterId() string {
	if x, ok := m.GetClusterIdOpt().(*GetRecentComplianceRunsRequest_ClusterId); ok {
		return x.ClusterId
	}
	return ""
}

func (m *GetRecentComplianceRunsRequest) GetStandardId() string {
	if x, ok := m.GetStandardIdOpt().(*GetRecentComplianceRunsRequest_StandardId); ok {
		return x.StandardId
	}
	return ""
}

func (m *GetRecentComplianceRunsRequest) GetSince() *types.Timestamp {
	if m != nil {
		return m.Since
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*GetRecentComplianceRunsRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*GetRecentComplianceRunsRequest_ClusterId)(nil),
		(*GetRecentComplianceRunsRequest_StandardId)(nil),
	}
}

func (m *GetRecentComplianceRunsRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetRecentComplianceRunsRequest) Clone() *GetRecentComplianceRunsRequest {
	if m == nil {
		return nil
	}
	cloned := new(GetRecentComplianceRunsRequest)
	*cloned = *m

	if m.ClusterIdOpt != nil {
		cloned.ClusterIdOpt = m.ClusterIdOpt.Clone()
	}
	if m.StandardIdOpt != nil {
		cloned.StandardIdOpt = m.StandardIdOpt.Clone()
	}
	cloned.Since = m.Since.Clone()
	return cloned
}

type GetRecentComplianceRunsResponse struct {
	ComplianceRuns       []*ComplianceRun `protobuf:"bytes,1,rep,name=compliance_runs,json=complianceRuns,proto3" json:"compliance_runs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *GetRecentComplianceRunsResponse) Reset()         { *m = GetRecentComplianceRunsResponse{} }
func (m *GetRecentComplianceRunsResponse) String() string { return proto.CompactTextString(m) }
func (*GetRecentComplianceRunsResponse) ProtoMessage()    {}
func (*GetRecentComplianceRunsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3a9dc9df4e5c8461, []int{13}
}
func (m *GetRecentComplianceRunsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetRecentComplianceRunsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetRecentComplianceRunsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetRecentComplianceRunsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetRecentComplianceRunsResponse.Merge(m, src)
}
func (m *GetRecentComplianceRunsResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetRecentComplianceRunsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetRecentComplianceRunsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetRecentComplianceRunsResponse proto.InternalMessageInfo

func (m *GetRecentComplianceRunsResponse) GetComplianceRuns() []*ComplianceRun {
	if m != nil {
		return m.ComplianceRuns
	}
	return nil
}

func (m *GetRecentComplianceRunsResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetRecentComplianceRunsResponse) Clone() *GetRecentComplianceRunsResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetRecentComplianceRunsResponse)
	*cloned = *m

	if m.ComplianceRuns != nil {
		cloned.ComplianceRuns = make([]*ComplianceRun, len(m.ComplianceRuns))
		for idx, v := range m.ComplianceRuns {
			cloned.ComplianceRuns[idx] = v.Clone()
		}
	}
	return cloned
}

type TriggerComplianceRunRequest struct {
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	StandardId           string   `protobuf:"bytes,2,opt,name=standard_id,json=standardId,proto3" json:"standard_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TriggerComplianceRunRequest) Reset()         { *m = TriggerComplianceRunRequest{} }
func (m *TriggerComplianceRunRequest) String() string { return proto.CompactTextString(m) }
func (*TriggerComplianceRunRequest) ProtoMessage()    {}
func (*TriggerComplianceRunRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3a9dc9df4e5c8461, []int{14}
}
func (m *TriggerComplianceRunRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TriggerComplianceRunRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TriggerComplianceRunRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TriggerComplianceRunRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TriggerComplianceRunRequest.Merge(m, src)
}
func (m *TriggerComplianceRunRequest) XXX_Size() int {
	return m.Size()
}
func (m *TriggerComplianceRunRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_TriggerComplianceRunRequest.DiscardUnknown(m)
}

var xxx_messageInfo_TriggerComplianceRunRequest proto.InternalMessageInfo

func (m *TriggerComplianceRunRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *TriggerComplianceRunRequest) GetStandardId() string {
	if m != nil {
		return m.StandardId
	}
	return ""
}

func (m *TriggerComplianceRunRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *TriggerComplianceRunRequest) Clone() *TriggerComplianceRunRequest {
	if m == nil {
		return nil
	}
	cloned := new(TriggerComplianceRunRequest)
	*cloned = *m

	return cloned
}

type TriggerComplianceRunResponse struct {
	StartedRun           *ComplianceRun `protobuf:"bytes,1,opt,name=started_run,json=startedRun,proto3" json:"started_run,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *TriggerComplianceRunResponse) Reset()         { *m = TriggerComplianceRunResponse{} }
func (m *TriggerComplianceRunResponse) String() string { return proto.CompactTextString(m) }
func (*TriggerComplianceRunResponse) ProtoMessage()    {}
func (*TriggerComplianceRunResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3a9dc9df4e5c8461, []int{15}
}
func (m *TriggerComplianceRunResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TriggerComplianceRunResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TriggerComplianceRunResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TriggerComplianceRunResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TriggerComplianceRunResponse.Merge(m, src)
}
func (m *TriggerComplianceRunResponse) XXX_Size() int {
	return m.Size()
}
func (m *TriggerComplianceRunResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_TriggerComplianceRunResponse.DiscardUnknown(m)
}

var xxx_messageInfo_TriggerComplianceRunResponse proto.InternalMessageInfo

func (m *TriggerComplianceRunResponse) GetStartedRun() *ComplianceRun {
	if m != nil {
		return m.StartedRun
	}
	return nil
}

func (m *TriggerComplianceRunResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *TriggerComplianceRunResponse) Clone() *TriggerComplianceRunResponse {
	if m == nil {
		return nil
	}
	cloned := new(TriggerComplianceRunResponse)
	*cloned = *m

	cloned.StartedRun = m.StartedRun.Clone()
	return cloned
}

type TriggerComplianceRunsRequest struct {
	Selection            *ComplianceRunSelection `protobuf:"bytes,1,opt,name=selection,proto3" json:"selection,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *TriggerComplianceRunsRequest) Reset()         { *m = TriggerComplianceRunsRequest{} }
func (m *TriggerComplianceRunsRequest) String() string { return proto.CompactTextString(m) }
func (*TriggerComplianceRunsRequest) ProtoMessage()    {}
func (*TriggerComplianceRunsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3a9dc9df4e5c8461, []int{16}
}
func (m *TriggerComplianceRunsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TriggerComplianceRunsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TriggerComplianceRunsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TriggerComplianceRunsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TriggerComplianceRunsRequest.Merge(m, src)
}
func (m *TriggerComplianceRunsRequest) XXX_Size() int {
	return m.Size()
}
func (m *TriggerComplianceRunsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_TriggerComplianceRunsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_TriggerComplianceRunsRequest proto.InternalMessageInfo

func (m *TriggerComplianceRunsRequest) GetSelection() *ComplianceRunSelection {
	if m != nil {
		return m.Selection
	}
	return nil
}

func (m *TriggerComplianceRunsRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *TriggerComplianceRunsRequest) Clone() *TriggerComplianceRunsRequest {
	if m == nil {
		return nil
	}
	cloned := new(TriggerComplianceRunsRequest)
	*cloned = *m

	cloned.Selection = m.Selection.Clone()
	return cloned
}

type TriggerComplianceRunsResponse struct {
	StartedRuns          []*ComplianceRun `protobuf:"bytes,1,rep,name=started_runs,json=startedRuns,proto3" json:"started_runs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *TriggerComplianceRunsResponse) Reset()         { *m = TriggerComplianceRunsResponse{} }
func (m *TriggerComplianceRunsResponse) String() string { return proto.CompactTextString(m) }
func (*TriggerComplianceRunsResponse) ProtoMessage()    {}
func (*TriggerComplianceRunsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3a9dc9df4e5c8461, []int{17}
}
func (m *TriggerComplianceRunsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TriggerComplianceRunsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TriggerComplianceRunsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TriggerComplianceRunsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TriggerComplianceRunsResponse.Merge(m, src)
}
func (m *TriggerComplianceRunsResponse) XXX_Size() int {
	return m.Size()
}
func (m *TriggerComplianceRunsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_TriggerComplianceRunsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_TriggerComplianceRunsResponse proto.InternalMessageInfo

func (m *TriggerComplianceRunsResponse) GetStartedRuns() []*ComplianceRun {
	if m != nil {
		return m.StartedRuns
	}
	return nil
}

func (m *TriggerComplianceRunsResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *TriggerComplianceRunsResponse) Clone() *TriggerComplianceRunsResponse {
	if m == nil {
		return nil
	}
	cloned := new(TriggerComplianceRunsResponse)
	*cloned = *m

	if m.StartedRuns != nil {
		cloned.StartedRuns = make([]*ComplianceRun, len(m.StartedRuns))
		for idx, v := range m.StartedRuns {
			cloned.StartedRuns[idx] = v.Clone()
		}
	}
	return cloned
}

type GetComplianceRunStatusesRequest struct {
	RunIds               []string `protobuf:"bytes,1,rep,name=run_ids,json=runIds,proto3" json:"run_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetComplianceRunStatusesRequest) Reset()         { *m = GetComplianceRunStatusesRequest{} }
func (m *GetComplianceRunStatusesRequest) String() string { return proto.CompactTextString(m) }
func (*GetComplianceRunStatusesRequest) ProtoMessage()    {}
func (*GetComplianceRunStatusesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3a9dc9df4e5c8461, []int{18}
}
func (m *GetComplianceRunStatusesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetComplianceRunStatusesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetComplianceRunStatusesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetComplianceRunStatusesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetComplianceRunStatusesRequest.Merge(m, src)
}
func (m *GetComplianceRunStatusesRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetComplianceRunStatusesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetComplianceRunStatusesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetComplianceRunStatusesRequest proto.InternalMessageInfo

func (m *GetComplianceRunStatusesRequest) GetRunIds() []string {
	if m != nil {
		return m.RunIds
	}
	return nil
}

func (m *GetComplianceRunStatusesRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetComplianceRunStatusesRequest) Clone() *GetComplianceRunStatusesRequest {
	if m == nil {
		return nil
	}
	cloned := new(GetComplianceRunStatusesRequest)
	*cloned = *m

	if m.RunIds != nil {
		cloned.RunIds = make([]string, len(m.RunIds))
		copy(cloned.RunIds, m.RunIds)
	}
	return cloned
}

type GetComplianceRunStatusesResponse struct {
	InvalidRunIds        []string         `protobuf:"bytes,1,rep,name=invalid_run_ids,json=invalidRunIds,proto3" json:"invalid_run_ids,omitempty"`
	Runs                 []*ComplianceRun `protobuf:"bytes,2,rep,name=runs,proto3" json:"runs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *GetComplianceRunStatusesResponse) Reset()         { *m = GetComplianceRunStatusesResponse{} }
func (m *GetComplianceRunStatusesResponse) String() string { return proto.CompactTextString(m) }
func (*GetComplianceRunStatusesResponse) ProtoMessage()    {}
func (*GetComplianceRunStatusesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3a9dc9df4e5c8461, []int{19}
}
func (m *GetComplianceRunStatusesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetComplianceRunStatusesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetComplianceRunStatusesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetComplianceRunStatusesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetComplianceRunStatusesResponse.Merge(m, src)
}
func (m *GetComplianceRunStatusesResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetComplianceRunStatusesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetComplianceRunStatusesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetComplianceRunStatusesResponse proto.InternalMessageInfo

func (m *GetComplianceRunStatusesResponse) GetInvalidRunIds() []string {
	if m != nil {
		return m.InvalidRunIds
	}
	return nil
}

func (m *GetComplianceRunStatusesResponse) GetRuns() []*ComplianceRun {
	if m != nil {
		return m.Runs
	}
	return nil
}

func (m *GetComplianceRunStatusesResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetComplianceRunStatusesResponse) Clone() *GetComplianceRunStatusesResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetComplianceRunStatusesResponse)
	*cloned = *m

	if m.InvalidRunIds != nil {
		cloned.InvalidRunIds = make([]string, len(m.InvalidRunIds))
		copy(cloned.InvalidRunIds, m.InvalidRunIds)
	}
	if m.Runs != nil {
		cloned.Runs = make([]*ComplianceRun, len(m.Runs))
		for idx, v := range m.Runs {
			cloned.Runs[idx] = v.Clone()
		}
	}
	return cloned
}

func init() {
	proto.RegisterEnum("v1.ComplianceRun_State", ComplianceRun_State_name, ComplianceRun_State_value)
	proto.RegisterType((*ComplianceRunScheduleInfo)(nil), "v1.ComplianceRunScheduleInfo")
	proto.RegisterType((*GetComplianceRunSchedulesRequest)(nil), "v1.GetComplianceRunSchedulesRequest")
	proto.RegisterType((*GetComplianceRunSchedulesResponse)(nil), "v1.GetComplianceRunSchedulesResponse")
	proto.RegisterType((*AddComplianceRunScheduleRequest)(nil), "v1.AddComplianceRunScheduleRequest")
	proto.RegisterType((*AddComplianceRunScheduleResponse)(nil), "v1.AddComplianceRunScheduleResponse")
	proto.RegisterType((*UpdateComplianceRunScheduleRequest)(nil), "v1.UpdateComplianceRunScheduleRequest")
	proto.RegisterType((*UpdateComplianceRunScheduleResponse)(nil), "v1.UpdateComplianceRunScheduleResponse")
	proto.RegisterType((*DeleteComplianceRunScheduleRequest)(nil), "v1.DeleteComplianceRunScheduleRequest")
	proto.RegisterType((*ComplianceRunSelection)(nil), "v1.ComplianceRunSelection")
	proto.RegisterType((*GetActiveComplianceRunsRequest)(nil), "v1.GetActiveComplianceRunsRequest")
	proto.RegisterType((*GetActiveComplianceRunsResponse)(nil), "v1.GetActiveComplianceRunsResponse")
	proto.RegisterType((*ComplianceRun)(nil), "v1.ComplianceRun")
	proto.RegisterType((*GetRecentComplianceRunsRequest)(nil), "v1.GetRecentComplianceRunsRequest")
	proto.RegisterType((*GetRecentComplianceRunsResponse)(nil), "v1.GetRecentComplianceRunsResponse")
	proto.RegisterType((*TriggerComplianceRunRequest)(nil), "v1.TriggerComplianceRunRequest")
	proto.RegisterType((*TriggerComplianceRunResponse)(nil), "v1.TriggerComplianceRunResponse")
	proto.RegisterType((*TriggerComplianceRunsRequest)(nil), "v1.TriggerComplianceRunsRequest")
	proto.RegisterType((*TriggerComplianceRunsResponse)(nil), "v1.TriggerComplianceRunsResponse")
	proto.RegisterType((*GetComplianceRunStatusesRequest)(nil), "v1.GetComplianceRunStatusesRequest")
	proto.RegisterType((*GetComplianceRunStatusesResponse)(nil), "v1.GetComplianceRunStatusesResponse")
}

func init() {
	proto.RegisterFile("api/v1/compliance_management_service.proto", fileDescriptor_3a9dc9df4e5c8461)
}

var fileDescriptor_3a9dc9df4e5c8461 = []byte{
	// 1130 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x56, 0xcf, 0x6e, 0xdb, 0xc6,
	0x13, 0x36, 0x29, 0x2b, 0xb6, 0x46, 0x96, 0xac, 0x2c, 0x7e, 0xf8, 0x45, 0x55, 0x62, 0x49, 0x5e,
	0x27, 0x81, 0x11, 0xa4, 0x74, 0xed, 0xf6, 0xd0, 0x3a, 0x40, 0x0b, 0xd9, 0x52, 0x6c, 0xa1, 0x89,
	0x0b, 0xac, 0xe4, 0xd4, 0x0d, 0x10, 0xa8, 0x0c, 0xb9, 0x96, 0x89, 0x4a, 0x24, 0xc3, 0x5d, 0x0a,
	0x39, 0x14, 0x28, 0xd0, 0x43, 0xd1, 0x9e, 0x7b, 0xe9, 0x23, 0xf4, 0xda, 0x73, 0xfb, 0x00, 0x3d,
	0x16, 0xe8, 0x0b, 0x14, 0x6e, 0x1f, 0xa4, 0xd8, 0xe5, 0x52, 0x7f, 0x6c, 0x8a, 0x76, 0x91, 0x1c,
	0x39, 0xfb, 0x7d, 0x33, 0xf3, 0xcd, 0xce, 0x2c, 0x07, 0x1e, 0x98, 0xbe, 0xb3, 0x35, 0xda, 0xde,
	0xb2, 0xbc, 0xa1, 0x3f, 0x70, 0x4c, 0xd7, 0xa2, 0xbd, 0xa1, 0xe9, 0x9a, 0x7d, 0x3a, 0xa4, 0x2e,
	0xef, 0x31, 0x1a, 0x8c, 0x1c, 0x8b, 0x1a, 0x7e, 0xe0, 0x71, 0x0f, 0xe9, 0xa3, 0xed, 0xca, 0x9d,
	0xbe, 0xe7, 0xf5, 0x07, 0x74, 0x4b, 0xd0, 0x4c, 0xd7, 0xf5, 0xb8, 0xc9, 0x1d, 0xcf, 0x65, 0x11,
	0xa2, 0x52, 0x53, 0xa7, 0xf2, 0xeb, 0x65, 0x78, 0xba, 0xc5, 0x9d, 0x21, 0x65, 0xdc, 0x1c, 0xfa,
	0x0a, 0xb0, 0xc1, 0xb8, 0x17, 0x98, 0x7d, 0x9a, 0x1c, 0x2f, 0x02, 0xe1, 0xef, 0x74, 0x78, 0x67,
	0x7f, 0x7c, 0x4e, 0x42, 0xb7, 0x63, 0x9d, 0x51, 0x3b, 0x1c, 0xd0, 0xb6, 0x7b, 0xea, 0xa1, 0x5d,
	0x58, 0x66, 0xea, 0xbb, 0xac, 0xd5, 0xb5, 0xcd, 0xfc, 0x4e, 0xd5, 0x50, 0x5e, 0x8d, 0x44, 0x16,
	0x19, 0xe3, 0xd1, 0x43, 0x58, 0x1e, 0x98, 0x8c, 0xf7, 0x82, 0xd0, 0x2d, 0xeb, 0x92, 0x7b, 0xd3,
	0x18, 0x6d, 0xcf, 0xd2, 0xc8, 0x92, 0x80, 0x90, 0xd0, 0x45, 0x9f, 0x00, 0x92, 0x68, 0x99, 0x2b,
	0xe5, 0xd4, 0x96, 0xbc, 0xcc, 0x3c, 0x5e, 0x49, 0x80, 0xf7, 0x63, 0xac, 0x70, 0xf0, 0x31, 0x14,
	0x5c, 0xfa, 0x5a, 0x86, 0xeb, 0x89, 0x4a, 0x94, 0x17, 0x25, 0xb7, 0x62, 0x44, 0x65, 0x32, 0xe2,
	0x32, 0x19, 0xdd, 0xb8, 0x4c, 0x24, 0x2f, 0x08, 0x24, 0x74, 0x85, 0x05, 0xff, 0xa6, 0x41, 0xfd,
	0x80, 0xf2, 0x44, 0x55, 0x8c, 0xd0, 0x57, 0x21, 0x65, 0x1c, 0xd5, 0x00, 0xac, 0x41, 0xc8, 0x38,
	0x0d, 0x7a, 0x8e, 0x2d, 0x2b, 0x92, 0x3b, 0x5c, 0x20, 0x39, 0x65, 0x6b, 0xdb, 0x68, 0x1d, 0xf2,
	0x8c, 0x9b, 0xae, 0x6d, 0x06, 0xb6, 0x40, 0xe8, 0x12, 0xa1, 0x11, 0x88, 0x8d, 0x6d, 0x1b, 0x55,
	0x21, 0xc7, 0x42, 0xe6, 0x53, 0xd7, 0xa6, 0xb6, 0x14, 0xb8, 0x7c, 0xa8, 0x93, 0x89, 0x69, 0xaf,
	0x04, 0xc5, 0x49, 0x8c, 0x9e, 0xe7, 0xf3, 0xbd, 0x9b, 0xb0, 0x3a, 0xe5, 0x54, 0x9a, 0x56, 0xa1,
	0x30, 0x66, 0x08, 0x03, 0xfe, 0x12, 0xd6, 0x53, 0xb2, 0x67, 0xbe, 0xe7, 0x32, 0x8a, 0x1e, 0x41,
	0x2e, 0xbe, 0x1e, 0x56, 0xd6, 0xea, 0x99, 0xcd, 0xfc, 0xce, 0xda, 0xa5, 0xda, 0x4e, 0x37, 0x00,
	0x99, 0xe0, 0xf1, 0x29, 0xd4, 0x1a, 0xb6, 0x9d, 0x7c, 0xeb, 0xaa, 0x3c, 0xfb, 0x50, 0x88, 0xf1,
	0x3d, 0xe6, 0x53, 0xeb, 0x9a, 0x3d, 0xb3, 0x12, 0x93, 0x3a, 0x3e, 0xb5, 0xf0, 0x19, 0xd4, 0xe7,
	0xc7, 0x51, 0x42, 0x9a, 0x50, 0x34, 0x6d, 0x21, 0xfd, 0x42, 0x77, 0x5e, 0xa1, 0xa6, 0x20, 0x49,
	0xb1, 0x09, 0x7f, 0xaf, 0x01, 0x3e, 0xf6, 0x6d, 0x93, 0xd3, 0x54, 0x55, 0x35, 0xc8, 0x8f, 0x55,
	0xc5, 0xb7, 0x4e, 0x20, 0x36, 0xb5, 0x6d, 0xd4, 0x80, 0x95, 0x50, 0xba, 0xb1, 0x23, 0xd5, 0xfa,
	0xb5, 0x54, 0xe7, 0x15, 0x47, 0x8a, 0xf6, 0x60, 0x23, 0x35, 0x13, 0xa5, 0xfb, 0x10, 0x4a, 0xe3,
	0x48, 0xff, 0x49, 0xf9, 0x6a, 0x1c, 0x2c, 0xd6, 0xde, 0x02, 0xdc, 0xa4, 0x62, 0x78, 0xde, 0x48,
	0x3a, 0x3e, 0x81, 0xff, 0xcf, 0x3a, 0xa0, 0x03, 0x6a, 0x89, 0x57, 0x0a, 0xad, 0x5d, 0x1e, 0x95,
	0xe9, 0x41, 0xa9, 0x25, 0x0c, 0xca, 0xf4, 0x98, 0xe0, 0xe7, 0x50, 0x3d, 0xa0, 0xbc, 0x61, 0x71,
	0x67, 0x34, 0x9b, 0xe3, 0x78, 0x18, 0x3f, 0x84, 0x1c, 0x8b, 0xc3, 0xa9, 0x2a, 0x54, 0x2e, 0x57,
	0x21, 0x46, 0x90, 0x09, 0x18, 0x1f, 0x43, 0x6d, 0xae, 0x6f, 0x55, 0xe9, 0x1d, 0xc8, 0x9b, 0xf2,
	0x5c, 0x3c, 0x28, 0xf1, 0xb0, 0x24, 0x3c, 0x44, 0x10, 0xa1, 0x04, 0x17, 0xff, 0x92, 0x81, 0xc2,
	0xcc, 0x29, 0x2a, 0x82, 0x3e, 0x16, 0xaf, 0x3b, 0xf6, 0x85, 0xa2, 0xe8, 0x57, 0x14, 0x25, 0x73,
	0xb1, 0x28, 0x17, 0xef, 0x63, 0xf1, 0x52, 0x2b, 0x7e, 0x04, 0x02, 0x1e, 0xf0, 0xe8, 0x09, 0xcc,
	0x5e, 0xf9, 0x04, 0xe6, 0x24, 0x5a, 0x7c, 0xa3, 0x47, 0x90, 0x3f, 0x75, 0x5c, 0x87, 0x9d, 0x45,
	0xdc, 0x1b, 0x57, 0x72, 0x21, 0x82, 0x4b, 0xf2, 0xbb, 0x90, 0x65, 0xdc, 0xe4, 0xb4, 0xbc, 0x54,
	0xd7, 0x36, 0x8b, 0x3b, 0xb7, 0x2e, 0x15, 0xca, 0xe8, 0x88, 0x63, 0x12, 0xa1, 0xd0, 0x06, 0x14,
	0x68, 0x10, 0x78, 0x41, 0x6f, 0x48, 0x19, 0x33, 0xfb, 0xb4, 0xbc, 0x2c, 0x95, 0xac, 0x48, 0xe3,
	0xd3, 0xc8, 0x86, 0x2d, 0xc8, 0x4a, 0x12, 0xca, 0xc3, 0x52, 0xfb, 0xe8, 0x59, 0xe3, 0x49, 0xbb,
	0x59, 0x5a, 0x40, 0x39, 0xc8, 0x92, 0x56, 0xa3, 0xf9, 0x45, 0x49, 0x13, 0xf6, 0x4e, 0xb7, 0x41,
	0xba, 0xad, 0x66, 0x49, 0x47, 0x37, 0xa1, 0xf0, 0x79, 0xa3, 0xdd, 0xed, 0x3d, 0xfe, 0x8c, 0xf4,
	0x9a, 0x8d, 0x6e, 0xa3, 0x94, 0x41, 0xff, 0x83, 0x52, 0xeb, 0x59, 0xe3, 0xc9, 0x71, 0xb7, 0x7d,
	0x74, 0xd0, 0xdb, 0x3f, 0x6c, 0xed, 0x7f, 0xda, 0x29, 0x2d, 0xa2, 0x15, 0x58, 0x7e, 0xdc, 0x3e,
	0x6a, 0x77, 0x0e, 0x5b, 0xcd, 0x52, 0x16, 0xff, 0xaa, 0xc9, 0x3e, 0x23, 0xd4, 0xa2, 0x2e, 0x4f,
	0xee, 0xb3, 0xb7, 0xf1, 0xe8, 0xbf, 0x07, 0x59, 0xe6, 0xb8, 0x16, 0x55, 0x7f, 0xb4, 0xb4, 0xb2,
	0x46, 0xc0, 0x6b, 0xfd, 0x06, 0xf0, 0x0b, 0xd9, 0xc8, 0xc9, 0xc9, 0xab, 0x46, 0xde, 0x85, 0xd5,
	0xa9, 0xff, 0x7f, 0x7a, 0x33, 0x17, 0xad, 0x19, 0x1f, 0xf8, 0x05, 0xdc, 0xee, 0x06, 0x4e, 0xbf,
	0x4f, 0x83, 0x59, 0x9c, 0x2a, 0xcc, 0x9b, 0x8e, 0x38, 0x81, 0x3b, 0xc9, 0xee, 0x27, 0x33, 0x28,
	0xdb, 0x53, 0x2d, 0x03, 0xda, 0xbc, 0x65, 0x00, 0x14, 0x8a, 0x84, 0x2e, 0x3e, 0x49, 0xf6, 0xf9,
	0x56, 0x1e, 0x8d, 0xb5, 0x39, 0x9e, 0x55, 0xba, 0x1f, 0xc0, 0xca, 0x54, 0xba, 0x29, 0x65, 0xce,
	0x4f, 0xf2, 0x65, 0x78, 0x57, 0x5e, 0xe1, 0x6c, 0x78, 0x6e, 0xf2, 0x90, 0x4d, 0xb6, 0x8e, 0x5b,
	0xb0, 0x24, 0xb6, 0x1a, 0xc7, 0x8e, 0x7c, 0xe6, 0xc8, 0x8d, 0x20, 0x74, 0xdb, 0x36, 0xc3, 0xaf,
	0x12, 0x56, 0x96, 0x31, 0x57, 0x65, 0x75, 0x1f, 0x56, 0x1d, 0x77, 0x64, 0x0e, 0x1c, 0x99, 0xd5,
	0x94, 0x93, 0x82, 0x32, 0x13, 0xe9, 0x0b, 0xdd, 0x83, 0x45, 0x99, 0xb5, 0x3e, 0x2f, 0x6b, 0x79,
	0xbc, 0xf3, 0x73, 0x06, 0x6e, 0x4f, 0xec, 0x4f, 0xc7, 0xeb, 0x64, 0x27, 0xda, 0x5e, 0xd1, 0x37,
	0x50, 0x18, 0x77, 0xa4, 0xd0, 0x87, 0xb0, 0xf0, 0x94, 0x3e, 0x61, 0x95, 0x8d, 0x54, 0x4c, 0x24,
	0x04, 0xdf, 0xfb, 0xf6, 0xcf, 0x7f, 0x7e, 0xd4, 0x6b, 0x68, 0x6d, 0x76, 0x85, 0x9e, 0xa4, 0xb0,
	0x25, 0x12, 0x44, 0x5f, 0x43, 0x5e, 0x5d, 0x93, 0x0c, 0x5f, 0x17, 0xae, 0xd3, 0x3a, 0xa2, 0xb2,
	0x9e, 0x82, 0x50, 0xa1, 0x37, 0x65, 0x68, 0x8c, 0x2f, 0x84, 0x1e, 0xce, 0x86, 0xde, 0xd5, 0x1e,
	0xa0, 0x1f, 0x34, 0x28, 0x0a, 0x21, 0x93, 0x8b, 0x40, 0xb1, 0xb8, 0xb4, 0x2b, 0xae, 0xdc, 0x4d,
	0x07, 0xa9, 0x3c, 0x1e, 0xca, 0x3c, 0xee, 0xa3, 0xbb, 0xa9, 0x79, 0x28, 0xd6, 0x9e, 0xf1, 0xfb,
	0x79, 0x55, 0xfb, 0xe3, 0xbc, 0xaa, 0xfd, 0x75, 0x5e, 0xd5, 0x7e, 0xfa, 0xbb, 0xba, 0x00, 0x65,
	0xc7, 0x33, 0x18, 0x37, 0xad, 0xaf, 0x02, 0xef, 0x75, 0xf4, 0xf4, 0x18, 0xa6, 0xef, 0x18, 0xa3,
	0xed, 0xe7, 0xfa, 0x68, 0xfb, 0x64, 0xe1, 0xe5, 0x0d, 0x69, 0x7b, 0xff, 0xdf, 0x00, 0x00, 0x00,
	0xff, 0xff, 0xb2, 0x10, 0x9f, 0xaf, 0xa9, 0x0c, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ComplianceManagementServiceClient is the client API for ComplianceManagementService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConnInterface.NewStream.
type ComplianceManagementServiceClient interface {
	GetRecentRuns(ctx context.Context, in *GetRecentComplianceRunsRequest, opts ...grpc.CallOption) (*GetRecentComplianceRunsResponse, error)
	TriggerRuns(ctx context.Context, in *TriggerComplianceRunsRequest, opts ...grpc.CallOption) (*TriggerComplianceRunsResponse, error)
	GetRunStatuses(ctx context.Context, in *GetComplianceRunStatusesRequest, opts ...grpc.CallOption) (*GetComplianceRunStatusesResponse, error)
}

type complianceManagementServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewComplianceManagementServiceClient(cc grpc.ClientConnInterface) ComplianceManagementServiceClient {
	return &complianceManagementServiceClient{cc}
}

func (c *complianceManagementServiceClient) GetRecentRuns(ctx context.Context, in *GetRecentComplianceRunsRequest, opts ...grpc.CallOption) (*GetRecentComplianceRunsResponse, error) {
	out := new(GetRecentComplianceRunsResponse)
	err := c.cc.Invoke(ctx, "/v1.ComplianceManagementService/GetRecentRuns", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *complianceManagementServiceClient) TriggerRuns(ctx context.Context, in *TriggerComplianceRunsRequest, opts ...grpc.CallOption) (*TriggerComplianceRunsResponse, error) {
	out := new(TriggerComplianceRunsResponse)
	err := c.cc.Invoke(ctx, "/v1.ComplianceManagementService/TriggerRuns", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *complianceManagementServiceClient) GetRunStatuses(ctx context.Context, in *GetComplianceRunStatusesRequest, opts ...grpc.CallOption) (*GetComplianceRunStatusesResponse, error) {
	out := new(GetComplianceRunStatusesResponse)
	err := c.cc.Invoke(ctx, "/v1.ComplianceManagementService/GetRunStatuses", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ComplianceManagementServiceServer is the server API for ComplianceManagementService service.
type ComplianceManagementServiceServer interface {
	GetRecentRuns(context.Context, *GetRecentComplianceRunsRequest) (*GetRecentComplianceRunsResponse, error)
	TriggerRuns(context.Context, *TriggerComplianceRunsRequest) (*TriggerComplianceRunsResponse, error)
	GetRunStatuses(context.Context, *GetComplianceRunStatusesRequest) (*GetComplianceRunStatusesResponse, error)
}

// UnimplementedComplianceManagementServiceServer can be embedded to have forward compatible implementations.
type UnimplementedComplianceManagementServiceServer struct {
}

func (*UnimplementedComplianceManagementServiceServer) GetRecentRuns(ctx context.Context, req *GetRecentComplianceRunsRequest) (*GetRecentComplianceRunsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRecentRuns not implemented")
}
func (*UnimplementedComplianceManagementServiceServer) TriggerRuns(ctx context.Context, req *TriggerComplianceRunsRequest) (*TriggerComplianceRunsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TriggerRuns not implemented")
}
func (*UnimplementedComplianceManagementServiceServer) GetRunStatuses(ctx context.Context, req *GetComplianceRunStatusesRequest) (*GetComplianceRunStatusesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRunStatuses not implemented")
}

func RegisterComplianceManagementServiceServer(s *grpc.Server, srv ComplianceManagementServiceServer) {
	s.RegisterService(&_ComplianceManagementService_serviceDesc, srv)
}

func _ComplianceManagementService_GetRecentRuns_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRecentComplianceRunsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ComplianceManagementServiceServer).GetRecentRuns(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ComplianceManagementService/GetRecentRuns",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ComplianceManagementServiceServer).GetRecentRuns(ctx, req.(*GetRecentComplianceRunsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ComplianceManagementService_TriggerRuns_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TriggerComplianceRunsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ComplianceManagementServiceServer).TriggerRuns(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ComplianceManagementService/TriggerRuns",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ComplianceManagementServiceServer).TriggerRuns(ctx, req.(*TriggerComplianceRunsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ComplianceManagementService_GetRunStatuses_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetComplianceRunStatusesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ComplianceManagementServiceServer).GetRunStatuses(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ComplianceManagementService/GetRunStatuses",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ComplianceManagementServiceServer).GetRunStatuses(ctx, req.(*GetComplianceRunStatusesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ComplianceManagementService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1.ComplianceManagementService",
	HandlerType: (*ComplianceManagementServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetRecentRuns",
			Handler:    _ComplianceManagementService_GetRecentRuns_Handler,
		},
		{
			MethodName: "TriggerRuns",
			Handler:    _ComplianceManagementService_TriggerRuns_Handler,
		},
		{
			MethodName: "GetRunStatuses",
			Handler:    _ComplianceManagementService_GetRunStatuses_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/v1/compliance_management_service.proto",
}

func (m *ComplianceRunScheduleInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ComplianceRunScheduleInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ComplianceRunScheduleInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.NextRunTime != nil {
		{
			size, err := m.NextRunTime.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintComplianceManagementService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.LastCompletedRun != nil {
		{
			size, err := m.LastCompletedRun.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintComplianceManagementService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.LastRun != nil {
		{
			size, err := m.LastRun.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintComplianceManagementService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Schedule != nil {
		{
			size, err := m.Schedule.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintComplianceManagementService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetComplianceRunSchedulesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetComplianceRunSchedulesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetComplianceRunSchedulesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.SuspendedOpt != nil {
		{
			size := m.SuspendedOpt.Size()
			i -= size
			if _, err := m.SuspendedOpt.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.StandardIdOpt != nil {
		{
			size := m.StandardIdOpt.Size()
			i -= size
			if _, err := m.StandardIdOpt.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.ClusterIdOpt != nil {
		{
			size := m.ClusterIdOpt.Size()
			i -= size
			if _, err := m.ClusterIdOpt.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *GetComplianceRunSchedulesRequest_ClusterId) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetComplianceRunSchedulesRequest_ClusterId) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.ClusterId)
	copy(dAtA[i:], m.ClusterId)
	i = encodeVarintComplianceManagementService(dAtA, i, uint64(len(m.ClusterId)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}
func (m *GetComplianceRunSchedulesRequest_StandardId) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetComplianceRunSchedulesRequest_StandardId) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.StandardId)
	copy(dAtA[i:], m.StandardId)
	i = encodeVarintComplianceManagementService(dAtA, i, uint64(len(m.StandardId)))
	i--
	dAtA[i] = 0x12
	return len(dAtA) - i, nil
}
func (m *GetComplianceRunSchedulesRequest_Suspended) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetComplianceRunSchedulesRequest_Suspended) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i--
	if m.Suspended {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x18
	return len(dAtA) - i, nil
}
func (m *GetComplianceRunSchedulesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetComplianceRunSchedulesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetComplianceRunSchedulesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Schedules) > 0 {
		for iNdEx := len(m.Schedules) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Schedules[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintComplianceManagementService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *AddComplianceRunScheduleRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AddComplianceRunScheduleRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AddComplianceRunScheduleRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ScheduleSpec != nil {
		{
			size, err := m.ScheduleSpec.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintComplianceManagementService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AddComplianceRunScheduleResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AddComplianceRunScheduleResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AddComplianceRunScheduleResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.AddedSchedule != nil {
		{
			size, err := m.AddedSchedule.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintComplianceManagementService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *UpdateComplianceRunScheduleRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpdateComplianceRunScheduleRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UpdateComplianceRunScheduleRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.UpdatedSpec != nil {
		{
			size, err := m.UpdatedSpec.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintComplianceManagementService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.ScheduleId) > 0 {
		i -= len(m.ScheduleId)
		copy(dAtA[i:], m.ScheduleId)
		i = encodeVarintComplianceManagementService(dAtA, i, uint64(len(m.ScheduleId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *UpdateComplianceRunScheduleResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpdateComplianceRunScheduleResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UpdateComplianceRunScheduleResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.UpdatedSchedule != nil {
		{
			size, err := m.UpdatedSchedule.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintComplianceManagementService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DeleteComplianceRunScheduleRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeleteComplianceRunScheduleRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeleteComplianceRunScheduleRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ScheduleId) > 0 {
		i -= len(m.ScheduleId)
		copy(dAtA[i:], m.ScheduleId)
		i = encodeVarintComplianceManagementService(dAtA, i, uint64(len(m.ScheduleId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ComplianceRunSelection) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ComplianceRunSelection) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ComplianceRunSelection) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.StandardId) > 0 {
		i -= len(m.StandardId)
		copy(dAtA[i:], m.StandardId)
		i = encodeVarintComplianceManagementService(dAtA, i, uint64(len(m.StandardId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintComplianceManagementService(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetActiveComplianceRunsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetActiveComplianceRunsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetActiveComplianceRunsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Selection != nil {
		{
			size, err := m.Selection.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintComplianceManagementService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetActiveComplianceRunsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetActiveComplianceRunsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetActiveComplianceRunsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ActiveRuns) > 0 {
		for iNdEx := len(m.ActiveRuns) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ActiveRuns[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintComplianceManagementService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ComplianceRun) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ComplianceRun) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ComplianceRun) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ErrorMessage) > 0 {
		i -= len(m.ErrorMessage)
		copy(dAtA[i:], m.ErrorMessage)
		i = encodeVarintComplianceManagementService(dAtA, i, uint64(len(m.ErrorMessage)))
		i--
		dAtA[i] = 0x42
	}
	if m.State != 0 {
		i = encodeVarintComplianceManagementService(dAtA, i, uint64(m.State))
		i--
		dAtA[i] = 0x38
	}
	if m.FinishTime != nil {
		{
			size, err := m.FinishTime.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintComplianceManagementService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.StartTime != nil {
		{
			size, err := m.StartTime.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintComplianceManagementService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if len(m.ScheduleId) > 0 {
		i -= len(m.ScheduleId)
		copy(dAtA[i:], m.ScheduleId)
		i = encodeVarintComplianceManagementService(dAtA, i, uint64(len(m.ScheduleId)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.StandardId) > 0 {
		i -= len(m.StandardId)
		copy(dAtA[i:], m.StandardId)
		i = encodeVarintComplianceManagementService(dAtA, i, uint64(len(m.StandardId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintComplianceManagementService(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintComplianceManagementService(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetRecentComplianceRunsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetRecentComplianceRunsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetRecentComplianceRunsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Since != nil {
		{
			size, err := m.Since.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintComplianceManagementService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.StandardIdOpt != nil {
		{
			size := m.StandardIdOpt.Size()
			i -= size
			if _, err := m.StandardIdOpt.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.ClusterIdOpt != nil {
		{
			size := m.ClusterIdOpt.Size()
			i -= size
			if _, err := m.ClusterIdOpt.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *GetRecentComplianceRunsRequest_ClusterId) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetRecentComplianceRunsRequest_ClusterId) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.ClusterId)
	copy(dAtA[i:], m.ClusterId)
	i = encodeVarintComplianceManagementService(dAtA, i, uint64(len(m.ClusterId)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}
func (m *GetRecentComplianceRunsRequest_StandardId) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetRecentComplianceRunsRequest_StandardId) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.StandardId)
	copy(dAtA[i:], m.StandardId)
	i = encodeVarintComplianceManagementService(dAtA, i, uint64(len(m.StandardId)))
	i--
	dAtA[i] = 0x12
	return len(dAtA) - i, nil
}
func (m *GetRecentComplianceRunsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetRecentComplianceRunsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetRecentComplianceRunsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ComplianceRuns) > 0 {
		for iNdEx := len(m.ComplianceRuns) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ComplianceRuns[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintComplianceManagementService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *TriggerComplianceRunRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TriggerComplianceRunRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TriggerComplianceRunRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.StandardId) > 0 {
		i -= len(m.StandardId)
		copy(dAtA[i:], m.StandardId)
		i = encodeVarintComplianceManagementService(dAtA, i, uint64(len(m.StandardId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintComplianceManagementService(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *TriggerComplianceRunResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TriggerComplianceRunResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TriggerComplianceRunResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.StartedRun != nil {
		{
			size, err := m.StartedRun.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintComplianceManagementService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *TriggerComplianceRunsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TriggerComplianceRunsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TriggerComplianceRunsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Selection != nil {
		{
			size, err := m.Selection.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintComplianceManagementService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *TriggerComplianceRunsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TriggerComplianceRunsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TriggerComplianceRunsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.StartedRuns) > 0 {
		for iNdEx := len(m.StartedRuns) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.StartedRuns[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintComplianceManagementService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *GetComplianceRunStatusesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetComplianceRunStatusesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetComplianceRunStatusesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.RunIds) > 0 {
		for iNdEx := len(m.RunIds) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.RunIds[iNdEx])
			copy(dAtA[i:], m.RunIds[iNdEx])
			i = encodeVarintComplianceManagementService(dAtA, i, uint64(len(m.RunIds[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *GetComplianceRunStatusesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetComplianceRunStatusesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetComplianceRunStatusesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Runs) > 0 {
		for iNdEx := len(m.Runs) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Runs[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintComplianceManagementService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.InvalidRunIds) > 0 {
		for iNdEx := len(m.InvalidRunIds) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.InvalidRunIds[iNdEx])
			copy(dAtA[i:], m.InvalidRunIds[iNdEx])
			i = encodeVarintComplianceManagementService(dAtA, i, uint64(len(m.InvalidRunIds[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func encodeVarintComplianceManagementService(dAtA []byte, offset int, v uint64) int {
	offset -= sovComplianceManagementService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ComplianceRunScheduleInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Schedule != nil {
		l = m.Schedule.Size()
		n += 1 + l + sovComplianceManagementService(uint64(l))
	}
	if m.LastRun != nil {
		l = m.LastRun.Size()
		n += 1 + l + sovComplianceManagementService(uint64(l))
	}
	if m.LastCompletedRun != nil {
		l = m.LastCompletedRun.Size()
		n += 1 + l + sovComplianceManagementService(uint64(l))
	}
	if m.NextRunTime != nil {
		l = m.NextRunTime.Size()
		n += 1 + l + sovComplianceManagementService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetComplianceRunSchedulesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ClusterIdOpt != nil {
		n += m.ClusterIdOpt.Size()
	}
	if m.StandardIdOpt != nil {
		n += m.StandardIdOpt.Size()
	}
	if m.SuspendedOpt != nil {
		n += m.SuspendedOpt.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetComplianceRunSchedulesRequest_ClusterId) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterId)
	n += 1 + l + sovComplianceManagementService(uint64(l))
	return n
}
func (m *GetComplianceRunSchedulesRequest_StandardId) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.StandardId)
	n += 1 + l + sovComplianceManagementService(uint64(l))
	return n
}
func (m *GetComplianceRunSchedulesRequest_Suspended) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 2
	return n
}
func (m *GetComplianceRunSchedulesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Schedules) > 0 {
		for _, e := range m.Schedules {
			l = e.Size()
			n += 1 + l + sovComplianceManagementService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AddComplianceRunScheduleRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ScheduleSpec != nil {
		l = m.ScheduleSpec.Size()
		n += 1 + l + sovComplianceManagementService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AddComplianceRunScheduleResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AddedSchedule != nil {
		l = m.AddedSchedule.Size()
		n += 1 + l + sovComplianceManagementService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *UpdateComplianceRunScheduleRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ScheduleId)
	if l > 0 {
		n += 1 + l + sovComplianceManagementService(uint64(l))
	}
	if m.UpdatedSpec != nil {
		l = m.UpdatedSpec.Size()
		n += 1 + l + sovComplianceManagementService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *UpdateComplianceRunScheduleResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.UpdatedSchedule != nil {
		l = m.UpdatedSchedule.Size()
		n += 1 + l + sovComplianceManagementService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeleteComplianceRunScheduleRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ScheduleId)
	if l > 0 {
		n += 1 + l + sovComplianceManagementService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ComplianceRunSelection) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovComplianceManagementService(uint64(l))
	}
	l = len(m.StandardId)
	if l > 0 {
		n += 1 + l + sovComplianceManagementService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetActiveComplianceRunsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Selection != nil {
		l = m.Selection.Size()
		n += 1 + l + sovComplianceManagementService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetActiveComplianceRunsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ActiveRuns) > 0 {
		for _, e := range m.ActiveRuns {
			l = e.Size()
			n += 1 + l + sovComplianceManagementService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ComplianceRun) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovComplianceManagementService(uint64(l))
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovComplianceManagementService(uint64(l))
	}
	l = len(m.StandardId)
	if l > 0 {
		n += 1 + l + sovComplianceManagementService(uint64(l))
	}
	l = len(m.ScheduleId)
	if l > 0 {
		n += 1 + l + sovComplianceManagementService(uint64(l))
	}
	if m.StartTime != nil {
		l = m.StartTime.Size()
		n += 1 + l + sovComplianceManagementService(uint64(l))
	}
	if m.FinishTime != nil {
		l = m.FinishTime.Size()
		n += 1 + l + sovComplianceManagementService(uint64(l))
	}
	if m.State != 0 {
		n += 1 + sovComplianceManagementService(uint64(m.State))
	}
	l = len(m.ErrorMessage)
	if l > 0 {
		n += 1 + l + sovComplianceManagementService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetRecentComplianceRunsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ClusterIdOpt != nil {
		n += m.ClusterIdOpt.Size()
	}
	if m.StandardIdOpt != nil {
		n += m.StandardIdOpt.Size()
	}
	if m.Since != nil {
		l = m.Since.Size()
		n += 1 + l + sovComplianceManagementService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetRecentComplianceRunsRequest_ClusterId) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterId)
	n += 1 + l + sovComplianceManagementService(uint64(l))
	return n
}
func (m *GetRecentComplianceRunsRequest_StandardId) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.StandardId)
	n += 1 + l + sovComplianceManagementService(uint64(l))
	return n
}
func (m *GetRecentComplianceRunsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ComplianceRuns) > 0 {
		for _, e := range m.ComplianceRuns {
			l = e.Size()
			n += 1 + l + sovComplianceManagementService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TriggerComplianceRunRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovComplianceManagementService(uint64(l))
	}
	l = len(m.StandardId)
	if l > 0 {
		n += 1 + l + sovComplianceManagementService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TriggerComplianceRunResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.StartedRun != nil {
		l = m.StartedRun.Size()
		n += 1 + l + sovComplianceManagementService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TriggerComplianceRunsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Selection != nil {
		l = m.Selection.Size()
		n += 1 + l + sovComplianceManagementService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TriggerComplianceRunsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.StartedRuns) > 0 {
		for _, e := range m.StartedRuns {
			l = e.Size()
			n += 1 + l + sovComplianceManagementService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetComplianceRunStatusesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.RunIds) > 0 {
		for _, s := range m.RunIds {
			l = len(s)
			n += 1 + l + sovComplianceManagementService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetComplianceRunStatusesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.InvalidRunIds) > 0 {
		for _, s := range m.InvalidRunIds {
			l = len(s)
			n += 1 + l + sovComplianceManagementService(uint64(l))
		}
	}
	if len(m.Runs) > 0 {
		for _, e := range m.Runs {
			l = e.Size()
			n += 1 + l + sovComplianceManagementService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovComplianceManagementService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozComplianceManagementService(x uint64) (n int) {
	return sovComplianceManagementService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ComplianceRunScheduleInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowComplianceManagementService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ComplianceRunScheduleInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ComplianceRunScheduleInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Schedule", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Schedule == nil {
				m.Schedule = &storage.ComplianceRunSchedule{}
			}
			if err := m.Schedule.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastRun", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastRun == nil {
				m.LastRun = &ComplianceRun{}
			}
			if err := m.LastRun.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastCompletedRun", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastCompletedRun == nil {
				m.LastCompletedRun = &ComplianceRun{}
			}
			if err := m.LastCompletedRun.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextRunTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NextRunTime == nil {
				m.NextRunTime = &types.Timestamp{}
			}
			if err := m.NextRunTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipComplianceManagementService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetComplianceRunSchedulesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowComplianceManagementService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetComplianceRunSchedulesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetComplianceRunSchedulesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterIdOpt = &GetComplianceRunSchedulesRequest_ClusterId{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StandardId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StandardIdOpt = &GetComplianceRunSchedulesRequest_StandardId{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Suspended", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.SuspendedOpt = &GetComplianceRunSchedulesRequest_Suspended{b}
		default:
			iNdEx = preIndex
			skippy, err := skipComplianceManagementService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetComplianceRunSchedulesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowComplianceManagementService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetComplianceRunSchedulesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetComplianceRunSchedulesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Schedules", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Schedules = append(m.Schedules, &ComplianceRunScheduleInfo{})
			if err := m.Schedules[len(m.Schedules)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipComplianceManagementService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AddComplianceRunScheduleRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowComplianceManagementService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AddComplianceRunScheduleRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AddComplianceRunScheduleRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduleSpec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ScheduleSpec == nil {
				m.ScheduleSpec = &storage.ComplianceRunSchedule{}
			}
			if err := m.ScheduleSpec.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipComplianceManagementService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AddComplianceRunScheduleResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowComplianceManagementService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AddComplianceRunScheduleResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AddComplianceRunScheduleResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AddedSchedule", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AddedSchedule == nil {
				m.AddedSchedule = &ComplianceRunScheduleInfo{}
			}
			if err := m.AddedSchedule.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipComplianceManagementService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateComplianceRunScheduleRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowComplianceManagementService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateComplianceRunScheduleRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateComplianceRunScheduleRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduleId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ScheduleId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpdatedSpec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UpdatedSpec == nil {
				m.UpdatedSpec = &storage.ComplianceRunSchedule{}
			}
			if err := m.UpdatedSpec.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipComplianceManagementService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateComplianceRunScheduleResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowComplianceManagementService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateComplianceRunScheduleResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateComplianceRunScheduleResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpdatedSchedule", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UpdatedSchedule == nil {
				m.UpdatedSchedule = &ComplianceRunScheduleInfo{}
			}
			if err := m.UpdatedSchedule.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipComplianceManagementService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeleteComplianceRunScheduleRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowComplianceManagementService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeleteComplianceRunScheduleRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeleteComplianceRunScheduleRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduleId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ScheduleId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipComplianceManagementService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ComplianceRunSelection) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowComplianceManagementService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ComplianceRunSelection: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ComplianceRunSelection: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StandardId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StandardId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipComplianceManagementService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetActiveComplianceRunsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowComplianceManagementService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetActiveComplianceRunsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetActiveComplianceRunsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Selection", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Selection == nil {
				m.Selection = &ComplianceRunSelection{}
			}
			if err := m.Selection.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipComplianceManagementService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetActiveComplianceRunsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowComplianceManagementService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetActiveComplianceRunsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetActiveComplianceRunsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ActiveRuns", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ActiveRuns = append(m.ActiveRuns, &ComplianceRun{})
			if err := m.ActiveRuns[len(m.ActiveRuns)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipComplianceManagementService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ComplianceRun) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowComplianceManagementService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ComplianceRun: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ComplianceRun: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StandardId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StandardId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduleId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ScheduleId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartTime == nil {
				m.StartTime = &types.Timestamp{}
			}
			if err := m.StartTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FinishTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FinishTime == nil {
				m.FinishTime = &types.Timestamp{}
			}
			if err := m.FinishTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= ComplianceRun_State(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorMessage", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ErrorMessage = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipComplianceManagementService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetRecentComplianceRunsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowComplianceManagementService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetRecentComplianceRunsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetRecentComplianceRunsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterIdOpt = &GetRecentComplianceRunsRequest_ClusterId{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StandardId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StandardIdOpt = &GetRecentComplianceRunsRequest_StandardId{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Since", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Since == nil {
				m.Since = &types.Timestamp{}
			}
			if err := m.Since.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipComplianceManagementService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetRecentComplianceRunsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowComplianceManagementService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetRecentComplianceRunsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetRecentComplianceRunsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ComplianceRuns", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ComplianceRuns = append(m.ComplianceRuns, &ComplianceRun{})
			if err := m.ComplianceRuns[len(m.ComplianceRuns)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipComplianceManagementService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TriggerComplianceRunRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowComplianceManagementService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TriggerComplianceRunRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TriggerComplianceRunRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StandardId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StandardId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipComplianceManagementService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TriggerComplianceRunResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowComplianceManagementService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TriggerComplianceRunResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TriggerComplianceRunResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartedRun", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartedRun == nil {
				m.StartedRun = &ComplianceRun{}
			}
			if err := m.StartedRun.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipComplianceManagementService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TriggerComplianceRunsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowComplianceManagementService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TriggerComplianceRunsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TriggerComplianceRunsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Selection", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Selection == nil {
				m.Selection = &ComplianceRunSelection{}
			}
			if err := m.Selection.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipComplianceManagementService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TriggerComplianceRunsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowComplianceManagementService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TriggerComplianceRunsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TriggerComplianceRunsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartedRuns", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartedRuns = append(m.StartedRuns, &ComplianceRun{})
			if err := m.StartedRuns[len(m.StartedRuns)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipComplianceManagementService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetComplianceRunStatusesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowComplianceManagementService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetComplianceRunStatusesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetComplianceRunStatusesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunIds", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RunIds = append(m.RunIds, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipComplianceManagementService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetComplianceRunStatusesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowComplianceManagementService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetComplianceRunStatusesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetComplianceRunStatusesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InvalidRunIds", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.InvalidRunIds = append(m.InvalidRunIds, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Runs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Runs = append(m.Runs, &ComplianceRun{})
			if err := m.Runs[len(m.Runs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipComplianceManagementService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthComplianceManagementService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipComplianceManagementService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowComplianceManagementService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowComplianceManagementService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthComplianceManagementService
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupComplianceManagementService
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthComplianceManagementService
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthComplianceManagementService        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowComplianceManagementService          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupComplianceManagementService = fmt.Errorf("proto: unexpected end of group")
)
