// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api/v1/config_service.proto

package v1

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	storage "github.com/stackrox/rox/generated/storage"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type PutConfigRequest struct {
	Config               *storage.Config `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *PutConfigRequest) Reset()         { *m = PutConfigRequest{} }
func (m *PutConfigRequest) String() string { return proto.CompactTextString(m) }
func (*PutConfigRequest) ProtoMessage()    {}
func (*PutConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_266c60d3cc05a407, []int{0}
}
func (m *PutConfigRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PutConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PutConfigRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PutConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PutConfigRequest.Merge(m, src)
}
func (m *PutConfigRequest) XXX_Size() int {
	return m.Size()
}
func (m *PutConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PutConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PutConfigRequest proto.InternalMessageInfo

func (m *PutConfigRequest) GetConfig() *storage.Config {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *PutConfigRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *PutConfigRequest) Clone() *PutConfigRequest {
	if m == nil {
		return nil
	}
	cloned := new(PutConfigRequest)
	*cloned = *m

	cloned.Config = m.Config.Clone()
	return cloned
}

func init() {
	proto.RegisterType((*PutConfigRequest)(nil), "v1.PutConfigRequest")
}

func init() { proto.RegisterFile("api/v1/config_service.proto", fileDescriptor_266c60d3cc05a407) }

var fileDescriptor_266c60d3cc05a407 = []byte{
	// 326 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x64, 0x91, 0xc1, 0x4a, 0xeb, 0x40,
	0x14, 0x86, 0x3b, 0x59, 0x14, 0x3a, 0xf7, 0x4a, 0xeb, 0xb1, 0x95, 0x1a, 0x25, 0x48, 0x36, 0x8a,
	0x8b, 0x09, 0xa9, 0x3b, 0xbb, 0x53, 0xa4, 0xb8, 0x91, 0xaa, 0x1b, 0x71, 0x23, 0xd3, 0x30, 0x86,
	0xc1, 0x9a, 0x89, 0xc9, 0x74, 0xd0, 0xad, 0xaf, 0xe0, 0xc6, 0x67, 0xf1, 0x09, 0x5c, 0x0a, 0xbe,
	0x80, 0x44, 0x1f, 0x44, 0x32, 0x33, 0x34, 0xa1, 0xd9, 0xfe, 0xf3, 0xfd, 0x1f, 0xe7, 0x9c, 0xc1,
	0xdb, 0x34, 0xe5, 0x81, 0x0a, 0x83, 0x48, 0x24, 0x77, 0x3c, 0xbe, 0xcd, 0x59, 0xa6, 0x78, 0xc4,
	0x48, 0x9a, 0x09, 0x29, 0xc0, 0x51, 0xa1, 0xbb, 0x13, 0x0b, 0x11, 0xcf, 0x59, 0x50, 0x72, 0x34,
	0x49, 0x84, 0xa4, 0x92, 0x8b, 0x24, 0x37, 0x84, 0x0b, 0xb6, 0xce, 0x1e, 0x52, 0xf9, 0x6c, 0xb3,
	0x7e, 0x2e, 0x45, 0x46, 0x63, 0x66, 0x9d, 0x26, 0xf5, 0xc7, 0xb8, 0x37, 0x5d, 0xc8, 0x13, 0x1d,
	0x5d, 0xb2, 0xc7, 0x05, 0xcb, 0x25, 0xec, 0xe1, 0xb6, 0x61, 0x86, 0x68, 0x17, 0xed, 0xff, 0x1b,
	0x75, 0x89, 0xad, 0x12, 0xcb, 0xd9, 0xe7, 0xd1, 0xbb, 0x83, 0xd7, 0x4c, 0x74, 0x65, 0x06, 0x84,
	0x73, 0xdc, 0x9d, 0x30, 0x39, 0x5d, 0xcc, 0xe6, 0x3c, 0x32, 0x2f, 0xd0, 0x21, 0x2a, 0x24, 0xa7,
	0xe5, 0x20, 0xee, 0x60, 0x29, 0xaa, 0x13, 0xfe, 0xd6, 0xcb, 0xd7, 0xef, 0xab, 0xb3, 0x01, 0xeb,
	0xd5, 0xc6, 0x41, 0xaa, 0x01, 0xb8, 0xc0, 0xbd, 0xd2, 0x97, 0x71, 0x45, 0x25, 0x6b, 0x0a, 0x37,
	0x2b, 0x61, 0x1d, 0xf1, 0x5d, 0x6d, 0xec, 0x03, 0xd4, 0x8d, 0x86, 0x80, 0x31, 0xee, 0x4c, 0x98,
	0x6c, 0xba, 0x56, 0xb7, 0xf4, 0x41, 0x4b, 0xfe, 0x03, 0xae, 0x24, 0x70, 0x86, 0x3b, 0xcb, 0x73,
	0x41, 0xbf, 0x2c, 0xaf, 0x5e, 0xaf, 0xe9, 0x19, 0x68, 0x4f, 0xd7, 0xad, 0x79, 0x8e, 0xd0, 0xc1,
	0x31, 0xf9, 0x28, 0x3c, 0xf4, 0x59, 0x78, 0xe8, 0xbb, 0xf0, 0xd0, 0xdb, 0x8f, 0xd7, 0xc2, 0x43,
	0x2e, 0x48, 0x2e, 0x69, 0x74, 0x9f, 0x89, 0x27, 0xf3, 0x3d, 0x84, 0xa6, 0x9c, 0xa8, 0xf0, 0xc6,
	0x51, 0xe1, 0x75, 0x6b, 0xd6, 0xd6, 0xd9, 0xe1, 0x5f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xbc, 0x14,
	0xab, 0x79, 0x1d, 0x02, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ConfigServiceClient is the client API for ConfigService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConnInterface.NewStream.
type ConfigServiceClient interface {
	GetPublicConfig(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*storage.PublicConfig, error)
	GetPrivateConfig(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*storage.PrivateConfig, error)
	GetConfig(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*storage.Config, error)
	PutConfig(ctx context.Context, in *PutConfigRequest, opts ...grpc.CallOption) (*storage.Config, error)
}

type configServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewConfigServiceClient(cc grpc.ClientConnInterface) ConfigServiceClient {
	return &configServiceClient{cc}
}

func (c *configServiceClient) GetPublicConfig(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*storage.PublicConfig, error) {
	out := new(storage.PublicConfig)
	err := c.cc.Invoke(ctx, "/v1.ConfigService/GetPublicConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceClient) GetPrivateConfig(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*storage.PrivateConfig, error) {
	out := new(storage.PrivateConfig)
	err := c.cc.Invoke(ctx, "/v1.ConfigService/GetPrivateConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceClient) GetConfig(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*storage.Config, error) {
	out := new(storage.Config)
	err := c.cc.Invoke(ctx, "/v1.ConfigService/GetConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceClient) PutConfig(ctx context.Context, in *PutConfigRequest, opts ...grpc.CallOption) (*storage.Config, error) {
	out := new(storage.Config)
	err := c.cc.Invoke(ctx, "/v1.ConfigService/PutConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ConfigServiceServer is the server API for ConfigService service.
type ConfigServiceServer interface {
	GetPublicConfig(context.Context, *Empty) (*storage.PublicConfig, error)
	GetPrivateConfig(context.Context, *Empty) (*storage.PrivateConfig, error)
	GetConfig(context.Context, *Empty) (*storage.Config, error)
	PutConfig(context.Context, *PutConfigRequest) (*storage.Config, error)
}

// UnimplementedConfigServiceServer can be embedded to have forward compatible implementations.
type UnimplementedConfigServiceServer struct {
}

func (*UnimplementedConfigServiceServer) GetPublicConfig(ctx context.Context, req *Empty) (*storage.PublicConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPublicConfig not implemented")
}
func (*UnimplementedConfigServiceServer) GetPrivateConfig(ctx context.Context, req *Empty) (*storage.PrivateConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPrivateConfig not implemented")
}
func (*UnimplementedConfigServiceServer) GetConfig(ctx context.Context, req *Empty) (*storage.Config, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConfig not implemented")
}
func (*UnimplementedConfigServiceServer) PutConfig(ctx context.Context, req *PutConfigRequest) (*storage.Config, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PutConfig not implemented")
}

func RegisterConfigServiceServer(s *grpc.Server, srv ConfigServiceServer) {
	s.RegisterService(&_ConfigService_serviceDesc, srv)
}

func _ConfigService_GetPublicConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceServer).GetPublicConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ConfigService/GetPublicConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceServer).GetPublicConfig(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigService_GetPrivateConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceServer).GetPrivateConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ConfigService/GetPrivateConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceServer).GetPrivateConfig(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigService_GetConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceServer).GetConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ConfigService/GetConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceServer).GetConfig(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigService_PutConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PutConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceServer).PutConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ConfigService/PutConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceServer).PutConfig(ctx, req.(*PutConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ConfigService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1.ConfigService",
	HandlerType: (*ConfigServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetPublicConfig",
			Handler:    _ConfigService_GetPublicConfig_Handler,
		},
		{
			MethodName: "GetPrivateConfig",
			Handler:    _ConfigService_GetPrivateConfig_Handler,
		},
		{
			MethodName: "GetConfig",
			Handler:    _ConfigService_GetConfig_Handler,
		},
		{
			MethodName: "PutConfig",
			Handler:    _ConfigService_PutConfig_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/v1/config_service.proto",
}

func (m *PutConfigRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PutConfigRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PutConfigRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Config != nil {
		{
			size, err := m.Config.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConfigService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintConfigService(dAtA []byte, offset int, v uint64) int {
	offset -= sovConfigService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *PutConfigRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Config != nil {
		l = m.Config.Size()
		n += 1 + l + sovConfigService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovConfigService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozConfigService(x uint64) (n int) {
	return sovConfigService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *PutConfigRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfigService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PutConfigRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PutConfigRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Config", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfigService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfigService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfigService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Config == nil {
				m.Config = &storage.Config{}
			}
			if err := m.Config.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfigService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConfigService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipConfigService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowConfigService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConfigService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConfigService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthConfigService
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupConfigService
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthConfigService
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthConfigService        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowConfigService          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupConfigService = fmt.Errorf("proto: unexpected end of group")
)
