// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api/v1/cve_service.proto

package v1

import (
	context "context"
	fmt "fmt"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type SuppressCVERequest struct {
	Ids                  []string        `protobuf:"bytes,1,rep,name=ids,proto3" json:"ids,omitempty"`
	Duration             *types.Duration `protobuf:"bytes,3,opt,name=duration,proto3" json:"duration,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *SuppressCVERequest) Reset()         { *m = SuppressCVERequest{} }
func (m *SuppressCVERequest) String() string { return proto.CompactTextString(m) }
func (*SuppressCVERequest) ProtoMessage()    {}
func (*SuppressCVERequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_257c48a61826e50f, []int{0}
}
func (m *SuppressCVERequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SuppressCVERequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SuppressCVERequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SuppressCVERequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SuppressCVERequest.Merge(m, src)
}
func (m *SuppressCVERequest) XXX_Size() int {
	return m.Size()
}
func (m *SuppressCVERequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SuppressCVERequest.DiscardUnknown(m)
}

var xxx_messageInfo_SuppressCVERequest proto.InternalMessageInfo

func (m *SuppressCVERequest) GetIds() []string {
	if m != nil {
		return m.Ids
	}
	return nil
}

func (m *SuppressCVERequest) GetDuration() *types.Duration {
	if m != nil {
		return m.Duration
	}
	return nil
}

func (m *SuppressCVERequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *SuppressCVERequest) Clone() *SuppressCVERequest {
	if m == nil {
		return nil
	}
	cloned := new(SuppressCVERequest)
	*cloned = *m

	if m.Ids != nil {
		cloned.Ids = make([]string, len(m.Ids))
		copy(cloned.Ids, m.Ids)
	}
	cloned.Duration = m.Duration.Clone()
	return cloned
}

type UnsuppressCVERequest struct {
	Ids                  []string `protobuf:"bytes,1,rep,name=ids,proto3" json:"ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UnsuppressCVERequest) Reset()         { *m = UnsuppressCVERequest{} }
func (m *UnsuppressCVERequest) String() string { return proto.CompactTextString(m) }
func (*UnsuppressCVERequest) ProtoMessage()    {}
func (*UnsuppressCVERequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_257c48a61826e50f, []int{1}
}
func (m *UnsuppressCVERequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UnsuppressCVERequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UnsuppressCVERequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UnsuppressCVERequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UnsuppressCVERequest.Merge(m, src)
}
func (m *UnsuppressCVERequest) XXX_Size() int {
	return m.Size()
}
func (m *UnsuppressCVERequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UnsuppressCVERequest.DiscardUnknown(m)
}

var xxx_messageInfo_UnsuppressCVERequest proto.InternalMessageInfo

func (m *UnsuppressCVERequest) GetIds() []string {
	if m != nil {
		return m.Ids
	}
	return nil
}

func (m *UnsuppressCVERequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *UnsuppressCVERequest) Clone() *UnsuppressCVERequest {
	if m == nil {
		return nil
	}
	cloned := new(UnsuppressCVERequest)
	*cloned = *m

	if m.Ids != nil {
		cloned.Ids = make([]string, len(m.Ids))
		copy(cloned.Ids, m.Ids)
	}
	return cloned
}

func init() {
	proto.RegisterType((*SuppressCVERequest)(nil), "v1.SuppressCVERequest")
	proto.RegisterType((*UnsuppressCVERequest)(nil), "v1.UnsuppressCVERequest")
}

func init() { proto.RegisterFile("api/v1/cve_service.proto", fileDescriptor_257c48a61826e50f) }

var fileDescriptor_257c48a61826e50f = []byte{
	// 320 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe2, 0x92, 0x48, 0x2c, 0xc8, 0xd4,
	0x2f, 0x33, 0xd4, 0x4f, 0x2e, 0x4b, 0x8d, 0x2f, 0x4e, 0x2d, 0x2a, 0xcb, 0x4c, 0x4e, 0xd5, 0x2b,
	0x28, 0xca, 0x2f, 0xc9, 0x17, 0x62, 0x2a, 0x33, 0x94, 0x92, 0x49, 0xcf, 0xcf, 0x4f, 0xcf, 0x49,
	0xd5, 0x07, 0x29, 0x4a, 0xcc, 0xcb, 0xcb, 0x2f, 0x49, 0x2c, 0xc9, 0xcc, 0xcf, 0x2b, 0x86, 0xa8,
	0x90, 0x92, 0x83, 0xca, 0x82, 0x79, 0x49, 0xa5, 0x69, 0xfa, 0x29, 0xa5, 0x45, 0x60, 0x05, 0x50,
	0x79, 0x21, 0xa8, 0xd9, 0xa9, 0xb9, 0x05, 0x25, 0x95, 0x10, 0x31, 0xa5, 0x64, 0x2e, 0xa1, 0xe0,
	0xd2, 0x82, 0x82, 0xa2, 0xd4, 0xe2, 0x62, 0xe7, 0x30, 0xd7, 0xa0, 0xd4, 0xc2, 0xd2, 0xd4, 0xe2,
	0x12, 0x21, 0x01, 0x2e, 0xe6, 0xcc, 0x94, 0x62, 0x09, 0x46, 0x05, 0x66, 0x0d, 0xce, 0x20, 0x10,
	0x53, 0xc8, 0x94, 0x8b, 0x03, 0x66, 0x9a, 0x04, 0xb3, 0x02, 0xa3, 0x06, 0xb7, 0x91, 0xa4, 0x1e,
	0xc4, 0x3a, 0x3d, 0x98, 0x75, 0x7a, 0x2e, 0x50, 0x05, 0x41, 0x70, 0xa5, 0x5e, 0x2c, 0x1c, 0x4c,
	0x02, 0xcc, 0x4a, 0x1a, 0x5c, 0x22, 0xa1, 0x79, 0xc5, 0x44, 0x58, 0x63, 0xb4, 0x85, 0x91, 0x8b,
	0xcb, 0x39, 0xcc, 0x35, 0x18, 0xe2, 0x73, 0x21, 0x7f, 0x2e, 0x1e, 0x24, 0xd7, 0x15, 0x0b, 0x89,
	0xe9, 0x95, 0x19, 0xea, 0x61, 0xba, 0x57, 0x8a, 0x13, 0x24, 0xee, 0x0a, 0xf2, 0x96, 0x92, 0x4c,
	0xd3, 0xe5, 0x27, 0x93, 0x99, 0xc4, 0x8c, 0x04, 0xa1, 0xa1, 0x58, 0xac, 0x0f, 0xb3, 0xd8, 0x8a,
	0x51, 0x4b, 0x28, 0x94, 0x8b, 0x0f, 0xc5, 0x25, 0xc5, 0x42, 0x12, 0x20, 0xad, 0xd8, 0x5c, 0x87,
	0x6c, 0xa8, 0x1c, 0xd8, 0x50, 0x09, 0x23, 0x61, 0xb8, 0xa1, 0xa5, 0x79, 0x48, 0xc6, 0x3a, 0xe9,
	0x9d, 0x78, 0x24, 0xc7, 0x78, 0xe1, 0x91, 0x1c, 0xe3, 0x83, 0x47, 0x72, 0x8c, 0x33, 0x1e, 0xcb,
	0x31, 0x70, 0x49, 0x64, 0xe6, 0xeb, 0x15, 0x97, 0x24, 0x26, 0x67, 0x17, 0xe5, 0x57, 0x40, 0x42,
	0x48, 0x2f, 0xb1, 0x20, 0x53, 0xaf, 0xcc, 0x30, 0x8a, 0xa9, 0xcc, 0x30, 0x82, 0x21, 0x89, 0x0d,
	0x2c, 0x66, 0x0c, 0x08, 0x00, 0x00, 0xff, 0xff, 0x7f, 0xab, 0x26, 0xc2, 0xf0, 0x01, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CVEServiceClient is the client API for CVEService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConnInterface.NewStream.
type CVEServiceClient interface {
	// SuppressCVE suppresses cves.
	SuppressCVEs(ctx context.Context, in *SuppressCVERequest, opts ...grpc.CallOption) (*Empty, error)
	// UnsuppressCVE unsuppresse    s cves.
	UnsuppressCVEs(ctx context.Context, in *UnsuppressCVERequest, opts ...grpc.CallOption) (*Empty, error)
}

type cVEServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCVEServiceClient(cc grpc.ClientConnInterface) CVEServiceClient {
	return &cVEServiceClient{cc}
}

func (c *cVEServiceClient) SuppressCVEs(ctx context.Context, in *SuppressCVERequest, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.CVEService/SuppressCVEs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cVEServiceClient) UnsuppressCVEs(ctx context.Context, in *UnsuppressCVERequest, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.CVEService/UnsuppressCVEs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CVEServiceServer is the server API for CVEService service.
type CVEServiceServer interface {
	// SuppressCVE suppresses cves.
	SuppressCVEs(context.Context, *SuppressCVERequest) (*Empty, error)
	// UnsuppressCVE unsuppresse    s cves.
	UnsuppressCVEs(context.Context, *UnsuppressCVERequest) (*Empty, error)
}

// UnimplementedCVEServiceServer can be embedded to have forward compatible implementations.
type UnimplementedCVEServiceServer struct {
}

func (*UnimplementedCVEServiceServer) SuppressCVEs(ctx context.Context, req *SuppressCVERequest) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SuppressCVEs not implemented")
}
func (*UnimplementedCVEServiceServer) UnsuppressCVEs(ctx context.Context, req *UnsuppressCVERequest) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UnsuppressCVEs not implemented")
}

func RegisterCVEServiceServer(s *grpc.Server, srv CVEServiceServer) {
	s.RegisterService(&_CVEService_serviceDesc, srv)
}

func _CVEService_SuppressCVEs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SuppressCVERequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CVEServiceServer).SuppressCVEs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.CVEService/SuppressCVEs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CVEServiceServer).SuppressCVEs(ctx, req.(*SuppressCVERequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CVEService_UnsuppressCVEs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UnsuppressCVERequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CVEServiceServer).UnsuppressCVEs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.CVEService/UnsuppressCVEs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CVEServiceServer).UnsuppressCVEs(ctx, req.(*UnsuppressCVERequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CVEService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1.CVEService",
	HandlerType: (*CVEServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SuppressCVEs",
			Handler:    _CVEService_SuppressCVEs_Handler,
		},
		{
			MethodName: "UnsuppressCVEs",
			Handler:    _CVEService_UnsuppressCVEs_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/v1/cve_service.proto",
}

func (m *SuppressCVERequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SuppressCVERequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SuppressCVERequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Duration != nil {
		{
			size, err := m.Duration.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintCveService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Ids) > 0 {
		for iNdEx := len(m.Ids) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Ids[iNdEx])
			copy(dAtA[i:], m.Ids[iNdEx])
			i = encodeVarintCveService(dAtA, i, uint64(len(m.Ids[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *UnsuppressCVERequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UnsuppressCVERequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UnsuppressCVERequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Ids) > 0 {
		for iNdEx := len(m.Ids) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Ids[iNdEx])
			copy(dAtA[i:], m.Ids[iNdEx])
			i = encodeVarintCveService(dAtA, i, uint64(len(m.Ids[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func encodeVarintCveService(dAtA []byte, offset int, v uint64) int {
	offset -= sovCveService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *SuppressCVERequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Ids) > 0 {
		for _, s := range m.Ids {
			l = len(s)
			n += 1 + l + sovCveService(uint64(l))
		}
	}
	if m.Duration != nil {
		l = m.Duration.Size()
		n += 1 + l + sovCveService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *UnsuppressCVERequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Ids) > 0 {
		for _, s := range m.Ids {
			l = len(s)
			n += 1 + l + sovCveService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovCveService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozCveService(x uint64) (n int) {
	return sovCveService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *SuppressCVERequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCveService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SuppressCVERequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SuppressCVERequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ids", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCveService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCveService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCveService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ids = append(m.Ids, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Duration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCveService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCveService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCveService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Duration == nil {
				m.Duration = &types.Duration{}
			}
			if err := m.Duration.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCveService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthCveService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UnsuppressCVERequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCveService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UnsuppressCVERequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UnsuppressCVERequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ids", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCveService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCveService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCveService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ids = append(m.Ids, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCveService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthCveService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipCveService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowCveService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCveService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCveService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthCveService
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupCveService
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthCveService
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthCveService        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowCveService          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupCveService = fmt.Errorf("proto: unexpected end of group")
)
