// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api/v1/db_service.proto

package v1

import (
	context "context"
	encoding_binary "encoding/binary"
	fmt "fmt"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type DBRestoreProcessStatus_State int32

const (
	DBRestoreProcessStatus_UNKNOWN     DBRestoreProcessStatus_State = 0
	DBRestoreProcessStatus_NOT_STARTED DBRestoreProcessStatus_State = 1
	DBRestoreProcessStatus_IN_PROGRESS DBRestoreProcessStatus_State = 2
	DBRestoreProcessStatus_PAUSED      DBRestoreProcessStatus_State = 3
	DBRestoreProcessStatus_COMPLETED   DBRestoreProcessStatus_State = 4
)

var DBRestoreProcessStatus_State_name = map[int32]string{
	0: "UNKNOWN",
	1: "NOT_STARTED",
	2: "IN_PROGRESS",
	3: "PAUSED",
	4: "COMPLETED",
}

var DBRestoreProcessStatus_State_value = map[string]int32{
	"UNKNOWN":     0,
	"NOT_STARTED": 1,
	"IN_PROGRESS": 2,
	"PAUSED":      3,
	"COMPLETED":   4,
}

func (x DBRestoreProcessStatus_State) String() string {
	return proto.EnumName(DBRestoreProcessStatus_State_name, int32(x))
}

func (DBRestoreProcessStatus_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_2ae290324bc1c2e8, []int{2, 0}
}

// The encoding of the file data in the restore body, usually for compression purposes.
type DBExportManifest_EncodingType int32

const (
	DBExportManifest_UNKNOWN       DBExportManifest_EncodingType = 0
	DBExportManifest_UNCOMPREESSED DBExportManifest_EncodingType = 1
	DBExportManifest_DEFLATED      DBExportManifest_EncodingType = 2
)

var DBExportManifest_EncodingType_name = map[int32]string{
	0: "UNKNOWN",
	1: "UNCOMPREESSED",
	2: "DEFLATED",
}

var DBExportManifest_EncodingType_value = map[string]int32{
	"UNKNOWN":       0,
	"UNCOMPREESSED": 1,
	"DEFLATED":      2,
}

func (x DBExportManifest_EncodingType) String() string {
	return proto.EnumName(DBExportManifest_EncodingType_name, int32(x))
}

func (DBExportManifest_EncodingType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_2ae290324bc1c2e8, []int{3, 0}
}

type DBRestoreRequestHeader struct {
	// The name of the database export format. Mandatory.
	FormatName string `protobuf:"bytes,1,opt,name=format_name,json=formatName,proto3" json:"format_name,omitempty"`
	// A manifest of all the files in the restore data. The remainder of a restore request body (without the header),
	// independent of the export format, is always a concatenation of all encoded file data, with no separators in
	// between (determined purely by the order and sizes listed in the manifest).
	Manifest *DBExportManifest `protobuf:"bytes,2,opt,name=manifest,proto3" json:"manifest,omitempty"`
	// Information about the local file with which the restore was initiated. Optional.
	LocalFile            *DBRestoreRequestHeader_LocalFileInfo `protobuf:"bytes,3,opt,name=local_file,json=localFile,proto3" json:"local_file,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                              `json:"-"`
	XXX_unrecognized     []byte                                `json:"-"`
	XXX_sizecache        int32                                 `json:"-"`
}

func (m *DBRestoreRequestHeader) Reset()         { *m = DBRestoreRequestHeader{} }
func (m *DBRestoreRequestHeader) String() string { return proto.CompactTextString(m) }
func (*DBRestoreRequestHeader) ProtoMessage()    {}
func (*DBRestoreRequestHeader) Descriptor() ([]byte, []int) {
	return fileDescriptor_2ae290324bc1c2e8, []int{0}
}
func (m *DBRestoreRequestHeader) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DBRestoreRequestHeader) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DBRestoreRequestHeader.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DBRestoreRequestHeader) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DBRestoreRequestHeader.Merge(m, src)
}
func (m *DBRestoreRequestHeader) XXX_Size() int {
	return m.Size()
}
func (m *DBRestoreRequestHeader) XXX_DiscardUnknown() {
	xxx_messageInfo_DBRestoreRequestHeader.DiscardUnknown(m)
}

var xxx_messageInfo_DBRestoreRequestHeader proto.InternalMessageInfo

func (m *DBRestoreRequestHeader) GetFormatName() string {
	if m != nil {
		return m.FormatName
	}
	return ""
}

func (m *DBRestoreRequestHeader) GetManifest() *DBExportManifest {
	if m != nil {
		return m.Manifest
	}
	return nil
}

func (m *DBRestoreRequestHeader) GetLocalFile() *DBRestoreRequestHeader_LocalFileInfo {
	if m != nil {
		return m.LocalFile
	}
	return nil
}

func (m *DBRestoreRequestHeader) MessageClone() proto.Message {
	return m.Clone()
}
func (m *DBRestoreRequestHeader) Clone() *DBRestoreRequestHeader {
	if m == nil {
		return nil
	}
	cloned := new(DBRestoreRequestHeader)
	*cloned = *m

	cloned.Manifest = m.Manifest.Clone()
	cloned.LocalFile = m.LocalFile.Clone()
	return cloned
}

// LocalFileInfo provides information about the file on the local machine of the user initiating the restore
// process, in order to provide information to other users about ongoing restore processes.
type DBRestoreRequestHeader_LocalFileInfo struct {
	// The full path of the file.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// The size of the file, in bytes. 0 if unknown.
	BytesSize            int64    `protobuf:"varint,2,opt,name=bytes_size,json=bytesSize,proto3" json:"bytes_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DBRestoreRequestHeader_LocalFileInfo) Reset()         { *m = DBRestoreRequestHeader_LocalFileInfo{} }
func (m *DBRestoreRequestHeader_LocalFileInfo) String() string { return proto.CompactTextString(m) }
func (*DBRestoreRequestHeader_LocalFileInfo) ProtoMessage()    {}
func (*DBRestoreRequestHeader_LocalFileInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_2ae290324bc1c2e8, []int{0, 0}
}
func (m *DBRestoreRequestHeader_LocalFileInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DBRestoreRequestHeader_LocalFileInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DBRestoreRequestHeader_LocalFileInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DBRestoreRequestHeader_LocalFileInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DBRestoreRequestHeader_LocalFileInfo.Merge(m, src)
}
func (m *DBRestoreRequestHeader_LocalFileInfo) XXX_Size() int {
	return m.Size()
}
func (m *DBRestoreRequestHeader_LocalFileInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_DBRestoreRequestHeader_LocalFileInfo.DiscardUnknown(m)
}

var xxx_messageInfo_DBRestoreRequestHeader_LocalFileInfo proto.InternalMessageInfo

func (m *DBRestoreRequestHeader_LocalFileInfo) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *DBRestoreRequestHeader_LocalFileInfo) GetBytesSize() int64 {
	if m != nil {
		return m.BytesSize
	}
	return 0
}

func (m *DBRestoreRequestHeader_LocalFileInfo) MessageClone() proto.Message {
	return m.Clone()
}
func (m *DBRestoreRequestHeader_LocalFileInfo) Clone() *DBRestoreRequestHeader_LocalFileInfo {
	if m == nil {
		return nil
	}
	cloned := new(DBRestoreRequestHeader_LocalFileInfo)
	*cloned = *m

	return cloned
}

// The metadata of an ongoing or completed restore process. This is the *static* metadata, which will not change
// (i.e., it is not a status).
type DBRestoreProcessMetadata struct {
	// An ID identifying the restore process. Auto-assigned.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The header with which the restore was initiated.
	Header *DBRestoreRequestHeader `protobuf:"bytes,2,opt,name=header,proto3" json:"header,omitempty"`
	// The time at which the restore process was started.
	StartTime *types.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The user who initiated the database restore process.
	InitiatingUserName   string   `protobuf:"bytes,4,opt,name=initiating_user_name,json=initiatingUserName,proto3" json:"initiating_user_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DBRestoreProcessMetadata) Reset()         { *m = DBRestoreProcessMetadata{} }
func (m *DBRestoreProcessMetadata) String() string { return proto.CompactTextString(m) }
func (*DBRestoreProcessMetadata) ProtoMessage()    {}
func (*DBRestoreProcessMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_2ae290324bc1c2e8, []int{1}
}
func (m *DBRestoreProcessMetadata) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DBRestoreProcessMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DBRestoreProcessMetadata.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DBRestoreProcessMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DBRestoreProcessMetadata.Merge(m, src)
}
func (m *DBRestoreProcessMetadata) XXX_Size() int {
	return m.Size()
}
func (m *DBRestoreProcessMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DBRestoreProcessMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DBRestoreProcessMetadata proto.InternalMessageInfo

func (m *DBRestoreProcessMetadata) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *DBRestoreProcessMetadata) GetHeader() *DBRestoreRequestHeader {
	if m != nil {
		return m.Header
	}
	return nil
}

func (m *DBRestoreProcessMetadata) GetStartTime() *types.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *DBRestoreProcessMetadata) GetInitiatingUserName() string {
	if m != nil {
		return m.InitiatingUserName
	}
	return ""
}

func (m *DBRestoreProcessMetadata) MessageClone() proto.Message {
	return m.Clone()
}
func (m *DBRestoreProcessMetadata) Clone() *DBRestoreProcessMetadata {
	if m == nil {
		return nil
	}
	cloned := new(DBRestoreProcessMetadata)
	*cloned = *m

	cloned.Header = m.Header.Clone()
	cloned.StartTime = m.StartTime.Clone()
	return cloned
}

type DBRestoreProcessStatus struct {
	Metadata             *DBRestoreProcessMetadata          `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	AttemptId            string                             `protobuf:"bytes,2,opt,name=attempt_id,json=attemptId,proto3" json:"attempt_id,omitempty"`
	State                DBRestoreProcessStatus_State       `protobuf:"varint,3,opt,name=state,proto3,enum=v1.DBRestoreProcessStatus_State" json:"state,omitempty"`
	ResumeInfo           *DBRestoreProcessStatus_ResumeInfo `protobuf:"bytes,4,opt,name=resume_info,json=resumeInfo,proto3" json:"resume_info,omitempty"`
	Error                string                             `protobuf:"bytes,5,opt,name=error,proto3" json:"error,omitempty"`
	BytesRead            int64                              `protobuf:"varint,6,opt,name=bytes_read,json=bytesRead,proto3" json:"bytes_read,omitempty"`
	FilesProcessed       int64                              `protobuf:"varint,7,opt,name=files_processed,json=filesProcessed,proto3" json:"files_processed,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *DBRestoreProcessStatus) Reset()         { *m = DBRestoreProcessStatus{} }
func (m *DBRestoreProcessStatus) String() string { return proto.CompactTextString(m) }
func (*DBRestoreProcessStatus) ProtoMessage()    {}
func (*DBRestoreProcessStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_2ae290324bc1c2e8, []int{2}
}
func (m *DBRestoreProcessStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DBRestoreProcessStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DBRestoreProcessStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DBRestoreProcessStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DBRestoreProcessStatus.Merge(m, src)
}
func (m *DBRestoreProcessStatus) XXX_Size() int {
	return m.Size()
}
func (m *DBRestoreProcessStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_DBRestoreProcessStatus.DiscardUnknown(m)
}

var xxx_messageInfo_DBRestoreProcessStatus proto.InternalMessageInfo

func (m *DBRestoreProcessStatus) GetMetadata() *DBRestoreProcessMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *DBRestoreProcessStatus) GetAttemptId() string {
	if m != nil {
		return m.AttemptId
	}
	return ""
}

func (m *DBRestoreProcessStatus) GetState() DBRestoreProcessStatus_State {
	if m != nil {
		return m.State
	}
	return DBRestoreProcessStatus_UNKNOWN
}

func (m *DBRestoreProcessStatus) GetResumeInfo() *DBRestoreProcessStatus_ResumeInfo {
	if m != nil {
		return m.ResumeInfo
	}
	return nil
}

func (m *DBRestoreProcessStatus) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *DBRestoreProcessStatus) GetBytesRead() int64 {
	if m != nil {
		return m.BytesRead
	}
	return 0
}

func (m *DBRestoreProcessStatus) GetFilesProcessed() int64 {
	if m != nil {
		return m.FilesProcessed
	}
	return 0
}

func (m *DBRestoreProcessStatus) MessageClone() proto.Message {
	return m.Clone()
}
func (m *DBRestoreProcessStatus) Clone() *DBRestoreProcessStatus {
	if m == nil {
		return nil
	}
	cloned := new(DBRestoreProcessStatus)
	*cloned = *m

	cloned.Metadata = m.Metadata.Clone()
	cloned.ResumeInfo = m.ResumeInfo.Clone()
	return cloned
}

type DBRestoreProcessStatus_ResumeInfo struct {
	Pos                  int64    `protobuf:"varint,1,opt,name=pos,proto3" json:"pos,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DBRestoreProcessStatus_ResumeInfo) Reset()         { *m = DBRestoreProcessStatus_ResumeInfo{} }
func (m *DBRestoreProcessStatus_ResumeInfo) String() string { return proto.CompactTextString(m) }
func (*DBRestoreProcessStatus_ResumeInfo) ProtoMessage()    {}
func (*DBRestoreProcessStatus_ResumeInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_2ae290324bc1c2e8, []int{2, 0}
}
func (m *DBRestoreProcessStatus_ResumeInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DBRestoreProcessStatus_ResumeInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DBRestoreProcessStatus_ResumeInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DBRestoreProcessStatus_ResumeInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DBRestoreProcessStatus_ResumeInfo.Merge(m, src)
}
func (m *DBRestoreProcessStatus_ResumeInfo) XXX_Size() int {
	return m.Size()
}
func (m *DBRestoreProcessStatus_ResumeInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_DBRestoreProcessStatus_ResumeInfo.DiscardUnknown(m)
}

var xxx_messageInfo_DBRestoreProcessStatus_ResumeInfo proto.InternalMessageInfo

func (m *DBRestoreProcessStatus_ResumeInfo) GetPos() int64 {
	if m != nil {
		return m.Pos
	}
	return 0
}

func (m *DBRestoreProcessStatus_ResumeInfo) MessageClone() proto.Message {
	return m.Clone()
}
func (m *DBRestoreProcessStatus_ResumeInfo) Clone() *DBRestoreProcessStatus_ResumeInfo {
	if m == nil {
		return nil
	}
	cloned := new(DBRestoreProcessStatus_ResumeInfo)
	*cloned = *m

	return cloned
}

// A DB export manifest describes the file contents of a restore request. To prevent data loss, a manifest is always
// interpreted as binding, i.e., the server must ensure that it will read and make use of every file listed in the
// manifest, otherwise it must reject the request.
type DBExportManifest struct {
	Files                []*DBExportManifest_File `protobuf:"bytes,1,rep,name=files,proto3" json:"files,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *DBExportManifest) Reset()         { *m = DBExportManifest{} }
func (m *DBExportManifest) String() string { return proto.CompactTextString(m) }
func (*DBExportManifest) ProtoMessage()    {}
func (*DBExportManifest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2ae290324bc1c2e8, []int{3}
}
func (m *DBExportManifest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DBExportManifest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DBExportManifest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DBExportManifest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DBExportManifest.Merge(m, src)
}
func (m *DBExportManifest) XXX_Size() int {
	return m.Size()
}
func (m *DBExportManifest) XXX_DiscardUnknown() {
	xxx_messageInfo_DBExportManifest.DiscardUnknown(m)
}

var xxx_messageInfo_DBExportManifest proto.InternalMessageInfo

func (m *DBExportManifest) GetFiles() []*DBExportManifest_File {
	if m != nil {
		return m.Files
	}
	return nil
}

func (m *DBExportManifest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *DBExportManifest) Clone() *DBExportManifest {
	if m == nil {
		return nil
	}
	cloned := new(DBExportManifest)
	*cloned = *m

	if m.Files != nil {
		cloned.Files = make([]*DBExportManifest_File, len(m.Files))
		for idx, v := range m.Files {
			cloned.Files[idx] = v.Clone()
		}
	}
	return cloned
}

// A single file in the restore body.
type DBExportManifest_File struct {
	// The name of the file. This may or may not be a (relative) file path and up to the server to interpret.
	// For databases exported as ZIP files, this is the path relative to the root of the archive.
	Name        string                        `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Encoding    DBExportManifest_EncodingType `protobuf:"varint,2,opt,name=encoding,proto3,enum=v1.DBExportManifest_EncodingType" json:"encoding,omitempty"`
	EncodedSize int64                         `protobuf:"varint,3,opt,name=encoded_size,json=encodedSize,proto3" json:"encoded_size,omitempty"`
	DecodedSize int64                         `protobuf:"varint,4,opt,name=decoded_size,json=decodedSize,proto3" json:"decoded_size,omitempty"`
	// The CRC32 (IEEE) checksum of the decoded(!) data.
	DecodedCrc32         uint32   `protobuf:"fixed32,5,opt,name=decoded_crc32,json=decodedCrc32,proto3" json:"decoded_crc32,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DBExportManifest_File) Reset()         { *m = DBExportManifest_File{} }
func (m *DBExportManifest_File) String() string { return proto.CompactTextString(m) }
func (*DBExportManifest_File) ProtoMessage()    {}
func (*DBExportManifest_File) Descriptor() ([]byte, []int) {
	return fileDescriptor_2ae290324bc1c2e8, []int{3, 0}
}
func (m *DBExportManifest_File) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DBExportManifest_File) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DBExportManifest_File.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DBExportManifest_File) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DBExportManifest_File.Merge(m, src)
}
func (m *DBExportManifest_File) XXX_Size() int {
	return m.Size()
}
func (m *DBExportManifest_File) XXX_DiscardUnknown() {
	xxx_messageInfo_DBExportManifest_File.DiscardUnknown(m)
}

var xxx_messageInfo_DBExportManifest_File proto.InternalMessageInfo

func (m *DBExportManifest_File) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DBExportManifest_File) GetEncoding() DBExportManifest_EncodingType {
	if m != nil {
		return m.Encoding
	}
	return DBExportManifest_UNKNOWN
}

func (m *DBExportManifest_File) GetEncodedSize() int64 {
	if m != nil {
		return m.EncodedSize
	}
	return 0
}

func (m *DBExportManifest_File) GetDecodedSize() int64 {
	if m != nil {
		return m.DecodedSize
	}
	return 0
}

func (m *DBExportManifest_File) GetDecodedCrc32() uint32 {
	if m != nil {
		return m.DecodedCrc32
	}
	return 0
}

func (m *DBExportManifest_File) MessageClone() proto.Message {
	return m.Clone()
}
func (m *DBExportManifest_File) Clone() *DBExportManifest_File {
	if m == nil {
		return nil
	}
	cloned := new(DBExportManifest_File)
	*cloned = *m

	return cloned
}

// DBExportFormat describes a format (= a collection of files) for the database export.
type DBExportFormat struct {
	FormatName           string                 `protobuf:"bytes,1,opt,name=format_name,json=formatName,proto3" json:"format_name,omitempty"`
	Files                []*DBExportFormat_File `protobuf:"bytes,2,rep,name=files,proto3" json:"files,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *DBExportFormat) Reset()         { *m = DBExportFormat{} }
func (m *DBExportFormat) String() string { return proto.CompactTextString(m) }
func (*DBExportFormat) ProtoMessage()    {}
func (*DBExportFormat) Descriptor() ([]byte, []int) {
	return fileDescriptor_2ae290324bc1c2e8, []int{4}
}
func (m *DBExportFormat) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DBExportFormat) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DBExportFormat.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DBExportFormat) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DBExportFormat.Merge(m, src)
}
func (m *DBExportFormat) XXX_Size() int {
	return m.Size()
}
func (m *DBExportFormat) XXX_DiscardUnknown() {
	xxx_messageInfo_DBExportFormat.DiscardUnknown(m)
}

var xxx_messageInfo_DBExportFormat proto.InternalMessageInfo

func (m *DBExportFormat) GetFormatName() string {
	if m != nil {
		return m.FormatName
	}
	return ""
}

func (m *DBExportFormat) GetFiles() []*DBExportFormat_File {
	if m != nil {
		return m.Files
	}
	return nil
}

func (m *DBExportFormat) MessageClone() proto.Message {
	return m.Clone()
}
func (m *DBExportFormat) Clone() *DBExportFormat {
	if m == nil {
		return nil
	}
	cloned := new(DBExportFormat)
	*cloned = *m

	if m.Files != nil {
		cloned.Files = make([]*DBExportFormat_File, len(m.Files))
		for idx, v := range m.Files {
			cloned.Files[idx] = v.Clone()
		}
	}
	return cloned
}

type DBExportFormat_File struct {
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Optional             bool     `protobuf:"varint,2,opt,name=optional,proto3" json:"optional,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DBExportFormat_File) Reset()         { *m = DBExportFormat_File{} }
func (m *DBExportFormat_File) String() string { return proto.CompactTextString(m) }
func (*DBExportFormat_File) ProtoMessage()    {}
func (*DBExportFormat_File) Descriptor() ([]byte, []int) {
	return fileDescriptor_2ae290324bc1c2e8, []int{4, 0}
}
func (m *DBExportFormat_File) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DBExportFormat_File) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DBExportFormat_File.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DBExportFormat_File) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DBExportFormat_File.Merge(m, src)
}
func (m *DBExportFormat_File) XXX_Size() int {
	return m.Size()
}
func (m *DBExportFormat_File) XXX_DiscardUnknown() {
	xxx_messageInfo_DBExportFormat_File.DiscardUnknown(m)
}

var xxx_messageInfo_DBExportFormat_File proto.InternalMessageInfo

func (m *DBExportFormat_File) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DBExportFormat_File) GetOptional() bool {
	if m != nil {
		return m.Optional
	}
	return false
}

func (m *DBExportFormat_File) MessageClone() proto.Message {
	return m.Clone()
}
func (m *DBExportFormat_File) Clone() *DBExportFormat_File {
	if m == nil {
		return nil
	}
	cloned := new(DBExportFormat_File)
	*cloned = *m

	return cloned
}

type GetDBExportCapabilitiesResponse struct {
	Formats              []*DBExportFormat               `protobuf:"bytes,1,rep,name=formats,proto3" json:"formats,omitempty"`
	SupportedEncodings   []DBExportManifest_EncodingType `protobuf:"varint,2,rep,packed,name=supported_encodings,json=supportedEncodings,proto3,enum=v1.DBExportManifest_EncodingType" json:"supported_encodings,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *GetDBExportCapabilitiesResponse) Reset()         { *m = GetDBExportCapabilitiesResponse{} }
func (m *GetDBExportCapabilitiesResponse) String() string { return proto.CompactTextString(m) }
func (*GetDBExportCapabilitiesResponse) ProtoMessage()    {}
func (*GetDBExportCapabilitiesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_2ae290324bc1c2e8, []int{5}
}
func (m *GetDBExportCapabilitiesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetDBExportCapabilitiesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetDBExportCapabilitiesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetDBExportCapabilitiesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDBExportCapabilitiesResponse.Merge(m, src)
}
func (m *GetDBExportCapabilitiesResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetDBExportCapabilitiesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDBExportCapabilitiesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetDBExportCapabilitiesResponse proto.InternalMessageInfo

func (m *GetDBExportCapabilitiesResponse) GetFormats() []*DBExportFormat {
	if m != nil {
		return m.Formats
	}
	return nil
}

func (m *GetDBExportCapabilitiesResponse) GetSupportedEncodings() []DBExportManifest_EncodingType {
	if m != nil {
		return m.SupportedEncodings
	}
	return nil
}

func (m *GetDBExportCapabilitiesResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetDBExportCapabilitiesResponse) Clone() *GetDBExportCapabilitiesResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetDBExportCapabilitiesResponse)
	*cloned = *m

	if m.Formats != nil {
		cloned.Formats = make([]*DBExportFormat, len(m.Formats))
		for idx, v := range m.Formats {
			cloned.Formats[idx] = v.Clone()
		}
	}
	if m.SupportedEncodings != nil {
		cloned.SupportedEncodings = make([]DBExportManifest_EncodingType, len(m.SupportedEncodings))
		copy(cloned.SupportedEncodings, m.SupportedEncodings)
	}
	return cloned
}

type GetActiveDBRestoreProcessResponse struct {
	ActiveStatus         *DBRestoreProcessStatus `protobuf:"bytes,1,opt,name=active_status,json=activeStatus,proto3" json:"active_status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *GetActiveDBRestoreProcessResponse) Reset()         { *m = GetActiveDBRestoreProcessResponse{} }
func (m *GetActiveDBRestoreProcessResponse) String() string { return proto.CompactTextString(m) }
func (*GetActiveDBRestoreProcessResponse) ProtoMessage()    {}
func (*GetActiveDBRestoreProcessResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_2ae290324bc1c2e8, []int{6}
}
func (m *GetActiveDBRestoreProcessResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetActiveDBRestoreProcessResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetActiveDBRestoreProcessResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetActiveDBRestoreProcessResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetActiveDBRestoreProcessResponse.Merge(m, src)
}
func (m *GetActiveDBRestoreProcessResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetActiveDBRestoreProcessResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetActiveDBRestoreProcessResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetActiveDBRestoreProcessResponse proto.InternalMessageInfo

func (m *GetActiveDBRestoreProcessResponse) GetActiveStatus() *DBRestoreProcessStatus {
	if m != nil {
		return m.ActiveStatus
	}
	return nil
}

func (m *GetActiveDBRestoreProcessResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetActiveDBRestoreProcessResponse) Clone() *GetActiveDBRestoreProcessResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetActiveDBRestoreProcessResponse)
	*cloned = *m

	cloned.ActiveStatus = m.ActiveStatus.Clone()
	return cloned
}

type InterruptDBRestoreProcessRequest struct {
	ProcessId            string   `protobuf:"bytes,1,opt,name=process_id,json=processId,proto3" json:"process_id,omitempty"`
	AttemptId            string   `protobuf:"bytes,2,opt,name=attempt_id,json=attemptId,proto3" json:"attempt_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *InterruptDBRestoreProcessRequest) Reset()         { *m = InterruptDBRestoreProcessRequest{} }
func (m *InterruptDBRestoreProcessRequest) String() string { return proto.CompactTextString(m) }
func (*InterruptDBRestoreProcessRequest) ProtoMessage()    {}
func (*InterruptDBRestoreProcessRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2ae290324bc1c2e8, []int{7}
}
func (m *InterruptDBRestoreProcessRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *InterruptDBRestoreProcessRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_InterruptDBRestoreProcessRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *InterruptDBRestoreProcessRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InterruptDBRestoreProcessRequest.Merge(m, src)
}
func (m *InterruptDBRestoreProcessRequest) XXX_Size() int {
	return m.Size()
}
func (m *InterruptDBRestoreProcessRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_InterruptDBRestoreProcessRequest.DiscardUnknown(m)
}

var xxx_messageInfo_InterruptDBRestoreProcessRequest proto.InternalMessageInfo

func (m *InterruptDBRestoreProcessRequest) GetProcessId() string {
	if m != nil {
		return m.ProcessId
	}
	return ""
}

func (m *InterruptDBRestoreProcessRequest) GetAttemptId() string {
	if m != nil {
		return m.AttemptId
	}
	return ""
}

func (m *InterruptDBRestoreProcessRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *InterruptDBRestoreProcessRequest) Clone() *InterruptDBRestoreProcessRequest {
	if m == nil {
		return nil
	}
	cloned := new(InterruptDBRestoreProcessRequest)
	*cloned = *m

	return cloned
}

type InterruptDBRestoreProcessResponse struct {
	ResumeInfo           *DBRestoreProcessStatus_ResumeInfo `protobuf:"bytes,1,opt,name=resume_info,json=resumeInfo,proto3" json:"resume_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *InterruptDBRestoreProcessResponse) Reset()         { *m = InterruptDBRestoreProcessResponse{} }
func (m *InterruptDBRestoreProcessResponse) String() string { return proto.CompactTextString(m) }
func (*InterruptDBRestoreProcessResponse) ProtoMessage()    {}
func (*InterruptDBRestoreProcessResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_2ae290324bc1c2e8, []int{8}
}
func (m *InterruptDBRestoreProcessResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *InterruptDBRestoreProcessResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_InterruptDBRestoreProcessResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *InterruptDBRestoreProcessResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InterruptDBRestoreProcessResponse.Merge(m, src)
}
func (m *InterruptDBRestoreProcessResponse) XXX_Size() int {
	return m.Size()
}
func (m *InterruptDBRestoreProcessResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_InterruptDBRestoreProcessResponse.DiscardUnknown(m)
}

var xxx_messageInfo_InterruptDBRestoreProcessResponse proto.InternalMessageInfo

func (m *InterruptDBRestoreProcessResponse) GetResumeInfo() *DBRestoreProcessStatus_ResumeInfo {
	if m != nil {
		return m.ResumeInfo
	}
	return nil
}

func (m *InterruptDBRestoreProcessResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *InterruptDBRestoreProcessResponse) Clone() *InterruptDBRestoreProcessResponse {
	if m == nil {
		return nil
	}
	cloned := new(InterruptDBRestoreProcessResponse)
	*cloned = *m

	cloned.ResumeInfo = m.ResumeInfo.Clone()
	return cloned
}

func init() {
	proto.RegisterEnum("v1.DBRestoreProcessStatus_State", DBRestoreProcessStatus_State_name, DBRestoreProcessStatus_State_value)
	proto.RegisterEnum("v1.DBExportManifest_EncodingType", DBExportManifest_EncodingType_name, DBExportManifest_EncodingType_value)
	proto.RegisterType((*DBRestoreRequestHeader)(nil), "v1.DBRestoreRequestHeader")
	proto.RegisterType((*DBRestoreRequestHeader_LocalFileInfo)(nil), "v1.DBRestoreRequestHeader.LocalFileInfo")
	proto.RegisterType((*DBRestoreProcessMetadata)(nil), "v1.DBRestoreProcessMetadata")
	proto.RegisterType((*DBRestoreProcessStatus)(nil), "v1.DBRestoreProcessStatus")
	proto.RegisterType((*DBRestoreProcessStatus_ResumeInfo)(nil), "v1.DBRestoreProcessStatus.ResumeInfo")
	proto.RegisterType((*DBExportManifest)(nil), "v1.DBExportManifest")
	proto.RegisterType((*DBExportManifest_File)(nil), "v1.DBExportManifest.File")
	proto.RegisterType((*DBExportFormat)(nil), "v1.DBExportFormat")
	proto.RegisterType((*DBExportFormat_File)(nil), "v1.DBExportFormat.File")
	proto.RegisterType((*GetDBExportCapabilitiesResponse)(nil), "v1.GetDBExportCapabilitiesResponse")
	proto.RegisterType((*GetActiveDBRestoreProcessResponse)(nil), "v1.GetActiveDBRestoreProcessResponse")
	proto.RegisterType((*InterruptDBRestoreProcessRequest)(nil), "v1.InterruptDBRestoreProcessRequest")
	proto.RegisterType((*InterruptDBRestoreProcessResponse)(nil), "v1.InterruptDBRestoreProcessResponse")
}

func init() { proto.RegisterFile("api/v1/db_service.proto", fileDescriptor_2ae290324bc1c2e8) }

var fileDescriptor_2ae290324bc1c2e8 = []byte{
	// 1141 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x56, 0xdd, 0x6e, 0x1b, 0x45,
	0x14, 0xee, 0xda, 0xf9, 0xb1, 0x8f, 0x13, 0xd7, 0x9d, 0xa4, 0x8d, 0x6b, 0x4a, 0x9a, 0x6c, 0xa9,
	0x88, 0x10, 0xac, 0x6b, 0x57, 0xaa, 0xa8, 0x04, 0x42, 0x71, 0xec, 0x04, 0x8b, 0xd6, 0x31, 0xe3,
	0x44, 0x20, 0x6e, 0x96, 0xf1, 0xee, 0x38, 0x1d, 0xd5, 0xde, 0x5d, 0x76, 0xc6, 0x56, 0xd3, 0xaa,
	0x37, 0xbc, 0x02, 0x37, 0xbd, 0x45, 0xbc, 0x09, 0xe2, 0xa2, 0x82, 0x1b, 0x24, 0x5e, 0x00, 0x15,
	0x1e, 0x82, 0x4b, 0x34, 0x3f, 0xeb, 0xbf, 0xa4, 0x09, 0xe2, 0xca, 0x33, 0x67, 0xbe, 0x33, 0xe7,
	0x3b, 0xe7, 0x9b, 0x73, 0xd6, 0xb0, 0x41, 0x22, 0x56, 0x1e, 0x55, 0xca, 0x7e, 0xd7, 0xe5, 0x34,
	0x1e, 0x31, 0x8f, 0x3a, 0x51, 0x1c, 0x8a, 0x10, 0xa5, 0x46, 0x95, 0xd2, 0xad, 0x93, 0x30, 0x3c,
	0xe9, 0xd3, 0xb2, 0xc4, 0x90, 0x20, 0x08, 0x05, 0x11, 0x2c, 0x0c, 0xb8, 0x46, 0x94, 0x90, 0x71,
	0xa5, 0x83, 0x48, 0x9c, 0x1a, 0xdb, 0x9a, 0xb1, 0x79, 0xe1, 0x60, 0x10, 0x06, 0xc6, 0x78, 0xdb,
	0x5c, 0xa3, 0x76, 0xdd, 0x61, 0xaf, 0x2c, 0xd8, 0x80, 0x72, 0x41, 0x06, 0x91, 0x06, 0xd8, 0xff,
	0x58, 0x70, 0xa3, 0x5e, 0xc3, 0x94, 0x8b, 0x30, 0xa6, 0x98, 0x7e, 0x37, 0xa4, 0x5c, 0x7c, 0x4e,
	0x89, 0x4f, 0x63, 0x74, 0x1b, 0x72, 0xbd, 0x30, 0x1e, 0x10, 0xe1, 0x06, 0x64, 0x40, 0x8b, 0xd6,
	0x96, 0xb5, 0x93, 0xc5, 0xa0, 0x4d, 0x2d, 0x32, 0xa0, 0xe8, 0x1e, 0x64, 0x06, 0x24, 0x60, 0x3d,
	0xca, 0x45, 0x31, 0xb5, 0x65, 0xed, 0xe4, 0xaa, 0xeb, 0xce, 0xa8, 0xe2, 0xd4, 0x6b, 0x8d, 0x67,
	0x51, 0x18, 0x8b, 0xc7, 0xe6, 0x0c, 0x8f, 0x51, 0xe8, 0x00, 0xa0, 0x1f, 0x7a, 0xa4, 0xef, 0xf6,
	0x58, 0x9f, 0x16, 0xd3, 0xca, 0x67, 0x47, 0xfb, 0x9c, 0x47, 0xc1, 0x79, 0x24, 0xc1, 0xfb, 0xac,
	0x4f, 0x9b, 0x41, 0x2f, 0xc4, 0xd9, 0x7e, 0xb2, 0x2d, 0xd5, 0x60, 0x75, 0xe6, 0x0c, 0x21, 0x58,
	0x88, 0x88, 0x78, 0x62, 0x58, 0xaa, 0x35, 0x7a, 0x17, 0xa0, 0x7b, 0x2a, 0x28, 0x77, 0x39, 0x7b,
	0x4e, 0x15, 0xc3, 0x34, 0xce, 0x2a, 0x4b, 0x87, 0x3d, 0xa7, 0xf6, 0x6f, 0x16, 0x14, 0xc7, 0x71,
	0xdb, 0x71, 0xe8, 0x51, 0xce, 0x1f, 0x53, 0x41, 0x7c, 0x22, 0x08, 0xca, 0x43, 0x8a, 0xf9, 0xe6,
	0xb6, 0x14, 0xf3, 0x51, 0x15, 0x96, 0x9e, 0x28, 0x4e, 0x26, 0xd3, 0xd2, 0xdb, 0x59, 0x63, 0x83,
	0x44, 0x0f, 0x01, 0xb8, 0x20, 0xb1, 0x70, 0x65, 0xd1, 0x4d, 0xb6, 0x25, 0x47, 0x2b, 0xe2, 0x24,
	0x8a, 0x38, 0x47, 0x89, 0x22, 0x38, 0xab, 0xd0, 0x72, 0x8f, 0xee, 0xc1, 0x3a, 0x0b, 0x98, 0x60,
	0x44, 0xb0, 0xe0, 0xc4, 0x1d, 0x72, 0x1a, 0x6b, 0x11, 0x16, 0x14, 0x21, 0x34, 0x39, 0x3b, 0xe6,
	0x34, 0x96, 0x62, 0xd8, 0x3f, 0xa7, 0xa7, 0x84, 0x34, 0xd9, 0x74, 0x04, 0x11, 0x43, 0x8e, 0x3e,
	0x86, 0xcc, 0xc0, 0xe4, 0xa5, 0x32, 0xca, 0x55, 0x6f, 0xcd, 0xb0, 0x9f, 0xcb, 0x1d, 0x8f, 0xd1,
	0xb2, 0x82, 0x44, 0x08, 0xf9, 0xca, 0x5c, 0xe6, 0xab, 0xcc, 0xb3, 0x38, 0x6b, 0x2c, 0x4d, 0x1f,
	0x3d, 0x80, 0x45, 0x2e, 0x88, 0xd0, 0xb9, 0xe5, 0xab, 0x5b, 0xe7, 0xdd, 0xaa, 0x39, 0x38, 0xf2,
	0x87, 0x62, 0x0d, 0x47, 0xfb, 0x90, 0x8b, 0x29, 0x1f, 0x0e, 0xa8, 0xcb, 0x82, 0x5e, 0xa8, 0x92,
	0xca, 0x55, 0xef, 0x5e, 0xe0, 0x8d, 0x15, 0x5a, 0x3d, 0x02, 0x88, 0xc7, 0x6b, 0xb4, 0x0e, 0x8b,
	0x34, 0x8e, 0xc3, 0xb8, 0xb8, 0xa8, 0x98, 0xe9, 0xcd, 0x44, 0xf6, 0x98, 0x12, 0xbf, 0xb8, 0x34,
	0x25, 0x3b, 0xa6, 0xc4, 0x47, 0xef, 0xc3, 0x55, 0xf9, 0xfa, 0xb8, 0x1b, 0xe9, 0x10, 0xd4, 0x2f,
	0x2e, 0x2b, 0x4c, 0x5e, 0x99, 0xdb, 0x89, 0xb5, 0xb4, 0x09, 0x30, 0x89, 0x8b, 0x0a, 0x90, 0x8e,
	0x42, 0xae, 0xea, 0x97, 0xc6, 0x72, 0x69, 0x7f, 0x09, 0x8b, 0x2a, 0x2b, 0x94, 0x83, 0xe5, 0xe3,
	0xd6, 0x17, 0xad, 0xc3, 0xaf, 0x5a, 0x85, 0x2b, 0xe8, 0x2a, 0xe4, 0x5a, 0x87, 0x47, 0x6e, 0xe7,
	0x68, 0x17, 0x1f, 0x35, 0xea, 0x05, 0x4b, 0x1a, 0x9a, 0x2d, 0xb7, 0x8d, 0x0f, 0x0f, 0x70, 0xa3,
	0xd3, 0x29, 0xa4, 0x10, 0xc0, 0x52, 0x7b, 0xf7, 0xb8, 0xd3, 0xa8, 0x17, 0xd2, 0x68, 0x15, 0xb2,
	0x7b, 0x87, 0x8f, 0xdb, 0x8f, 0x1a, 0x12, 0xbb, 0x60, 0xbf, 0x4e, 0x41, 0x61, 0xbe, 0x7d, 0x50,
	0x19, 0x16, 0x15, 0xb3, 0xa2, 0xb5, 0x95, 0xde, 0xc9, 0x55, 0x6f, 0x9e, 0xd7, 0x63, 0x8e, 0x6c,
	0x04, 0xac, 0x71, 0xa5, 0x5f, 0x2c, 0x58, 0x90, 0x7b, 0xd9, 0x14, 0x53, 0xad, 0xab, 0xd6, 0xe8,
	0x53, 0xc8, 0xd0, 0xc0, 0x0b, 0x7d, 0x16, 0x9c, 0x28, 0x41, 0xf3, 0xd5, 0xed, 0x73, 0x2f, 0x6c,
	0x18, 0xd0, 0xd1, 0x69, 0x44, 0xf1, 0xd8, 0x05, 0x6d, 0xc3, 0x8a, 0x5a, 0x53, 0x5f, 0x77, 0x55,
	0x5a, 0xd5, 0x23, 0x67, 0x6c, 0xb2, 0xaf, 0x24, 0xc4, 0xa7, 0x53, 0x90, 0x05, 0x0d, 0x31, 0x36,
	0x05, 0xb9, 0x03, 0xab, 0x09, 0xc4, 0x8b, 0xbd, 0xfb, 0x55, 0x25, 0xe0, 0x32, 0x4e, 0xfc, 0xf6,
	0xa4, 0xcd, 0xfe, 0x04, 0x56, 0xa6, 0x49, 0xcc, 0x96, 0xf9, 0x1a, 0xac, 0x1e, 0xb7, 0x64, 0xe9,
	0x70, 0xa3, 0xd1, 0xe9, 0xa8, 0x42, 0xaf, 0x40, 0xa6, 0xde, 0xd8, 0x7f, 0xb4, 0x2b, 0x4b, 0x99,
	0xb2, 0x5f, 0x59, 0x90, 0x4f, 0x92, 0xda, 0x57, 0x33, 0xeb, 0xf2, 0x81, 0xf6, 0x51, 0x52, 0xe9,
	0x94, 0xaa, 0xf4, 0xc6, 0x74, 0x61, 0xf4, 0x1d, 0x33, 0x75, 0x7e, 0x70, 0x41, 0x99, 0x4b, 0x90,
	0x09, 0x23, 0x39, 0xb2, 0x49, 0x5f, 0x95, 0x39, 0x83, 0xc7, 0x7b, 0xfb, 0x27, 0x0b, 0x6e, 0x1f,
	0x50, 0x91, 0xdc, 0xbc, 0x47, 0x22, 0xd2, 0x65, 0x7d, 0x26, 0x98, 0x7c, 0xa1, 0x3c, 0x0a, 0x03,
	0x4e, 0xd1, 0x87, 0xb0, 0xac, 0x89, 0x25, 0xb2, 0xa3, 0xb3, 0x64, 0x70, 0x02, 0x41, 0x18, 0xd6,
	0xf8, 0x30, 0x92, 0x27, 0xd4, 0x77, 0x13, 0xad, 0x74, 0x1a, 0xff, 0x49, 0x5f, 0x34, 0xf6, 0x4e,
	0xcc, 0xdc, 0xf6, 0x61, 0xfb, 0x80, 0x8a, 0x5d, 0x4f, 0xb0, 0x11, 0x9d, 0x6f, 0xcb, 0x31, 0xcd,
	0xcf, 0x60, 0x95, 0x28, 0x84, 0xcb, 0x55, 0xa7, 0x9a, 0xf9, 0x52, 0x7a, 0x7b, 0x2f, 0xe3, 0x15,
	0xed, 0xa0, 0x77, 0xf6, 0xb7, 0xb0, 0xd5, 0x0c, 0x04, 0x8d, 0xe3, 0x61, 0x24, 0xce, 0x46, 0x51,
	0x53, 0x55, 0x36, 0xb4, 0xe9, 0x55, 0x77, 0x3c, 0x93, 0xb3, 0xc6, 0xd2, 0xf4, 0x2f, 0x19, 0x52,
	0xf6, 0x53, 0xd8, 0xbe, 0x20, 0x82, 0xc9, 0x63, 0x6e, 0x22, 0x59, 0xff, 0x73, 0x22, 0x55, 0x7f,
	0x4d, 0x43, 0xb6, 0x5e, 0xeb, 0xe8, 0xcf, 0x39, 0xea, 0xc2, 0xf5, 0x03, 0x2a, 0xce, 0xaa, 0x8c,
	0xb2, 0xf2, 0xe6, 0x86, 0xfc, 0x78, 0x97, 0xee, 0xc8, 0xe5, 0x25, 0xaf, 0xc1, 0xbe, 0xf9, 0xfd,
	0x1f, 0x7f, 0xff, 0x90, 0x5a, 0x43, 0xd7, 0xf4, 0xff, 0x85, 0x32, 0x55, 0x50, 0x8f, 0x44, 0x1c,
	0x79, 0xb0, 0x31, 0x96, 0x69, 0x96, 0xe9, 0x74, 0x94, 0xbb, 0x26, 0xca, 0xc5, 0x72, 0xda, 0x37,
	0x54, 0x9c, 0x02, 0xca, 0x9b, 0x38, 0xb1, 0x86, 0xa1, 0x1f, 0x2d, 0xd8, 0x18, 0x17, 0x71, 0x2e,
	0xca, 0x7b, 0xf2, 0xea, 0xcb, 0x34, 0xd4, 0x04, 0x2e, 0xd5, 0xc1, 0x7e, 0xa8, 0x08, 0xdc, 0xb7,
	0x2b, 0x86, 0x00, 0x4b, 0x3c, 0x0c, 0x93, 0xf2, 0x8b, 0xc9, 0x4b, 0x78, 0x59, 0x7e, 0x31, 0xd1,
	0xfd, 0x25, 0x6a, 0xc3, 0xfa, 0x1e, 0x09, 0x3c, 0xda, 0x9f, 0xe3, 0x57, 0x90, 0x91, 0x31, 0xe5,
	0xe1, 0x30, 0xf6, 0x68, 0xed, 0xb4, 0x59, 0x2f, 0x4d, 0xea, 0x62, 0xbf, 0xa3, 0xe2, 0x5d, 0xff,
	0x60, 0x6d, 0x36, 0xe1, 0xf2, 0x0b, 0xe6, 0xbf, 0xac, 0x39, 0xaf, 0xdf, 0x6c, 0x5a, 0xbf, 0xbf,
	0xd9, 0xb4, 0xfe, 0x7c, 0xb3, 0x69, 0xbd, 0xfa, 0x6b, 0xf3, 0x0a, 0x14, 0x59, 0xe8, 0x70, 0x41,
	0xbc, 0xa7, 0x71, 0xf8, 0x4c, 0x7f, 0xc1, 0x1d, 0x12, 0x31, 0x67, 0x54, 0xf9, 0x26, 0x35, 0xaa,
	0x7c, 0x7d, 0xa5, 0xbb, 0xa4, 0x6c, 0xf7, 0xff, 0x0d, 0x00, 0x00, 0xff, 0xff, 0x2d, 0x4b, 0x9e,
	0x2d, 0xdb, 0x09, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DBServiceClient is the client API for DBService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConnInterface.NewStream.
type DBServiceClient interface {
	GetExportCapabilities(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*GetDBExportCapabilitiesResponse, error)
	GetActiveRestoreProcess(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*GetActiveDBRestoreProcessResponse, error)
	InterruptRestoreProcess(ctx context.Context, in *InterruptDBRestoreProcessRequest, opts ...grpc.CallOption) (*InterruptDBRestoreProcessResponse, error)
	CancelRestoreProcess(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*Empty, error)
}

type dBServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDBServiceClient(cc grpc.ClientConnInterface) DBServiceClient {
	return &dBServiceClient{cc}
}

func (c *dBServiceClient) GetExportCapabilities(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*GetDBExportCapabilitiesResponse, error) {
	out := new(GetDBExportCapabilitiesResponse)
	err := c.cc.Invoke(ctx, "/v1.DBService/GetExportCapabilities", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dBServiceClient) GetActiveRestoreProcess(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*GetActiveDBRestoreProcessResponse, error) {
	out := new(GetActiveDBRestoreProcessResponse)
	err := c.cc.Invoke(ctx, "/v1.DBService/GetActiveRestoreProcess", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dBServiceClient) InterruptRestoreProcess(ctx context.Context, in *InterruptDBRestoreProcessRequest, opts ...grpc.CallOption) (*InterruptDBRestoreProcessResponse, error) {
	out := new(InterruptDBRestoreProcessResponse)
	err := c.cc.Invoke(ctx, "/v1.DBService/InterruptRestoreProcess", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dBServiceClient) CancelRestoreProcess(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.DBService/CancelRestoreProcess", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DBServiceServer is the server API for DBService service.
type DBServiceServer interface {
	GetExportCapabilities(context.Context, *Empty) (*GetDBExportCapabilitiesResponse, error)
	GetActiveRestoreProcess(context.Context, *Empty) (*GetActiveDBRestoreProcessResponse, error)
	InterruptRestoreProcess(context.Context, *InterruptDBRestoreProcessRequest) (*InterruptDBRestoreProcessResponse, error)
	CancelRestoreProcess(context.Context, *ResourceByID) (*Empty, error)
}

// UnimplementedDBServiceServer can be embedded to have forward compatible implementations.
type UnimplementedDBServiceServer struct {
}

func (*UnimplementedDBServiceServer) GetExportCapabilities(ctx context.Context, req *Empty) (*GetDBExportCapabilitiesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetExportCapabilities not implemented")
}
func (*UnimplementedDBServiceServer) GetActiveRestoreProcess(ctx context.Context, req *Empty) (*GetActiveDBRestoreProcessResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetActiveRestoreProcess not implemented")
}
func (*UnimplementedDBServiceServer) InterruptRestoreProcess(ctx context.Context, req *InterruptDBRestoreProcessRequest) (*InterruptDBRestoreProcessResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InterruptRestoreProcess not implemented")
}
func (*UnimplementedDBServiceServer) CancelRestoreProcess(ctx context.Context, req *ResourceByID) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelRestoreProcess not implemented")
}

func RegisterDBServiceServer(s *grpc.Server, srv DBServiceServer) {
	s.RegisterService(&_DBService_serviceDesc, srv)
}

func _DBService_GetExportCapabilities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DBServiceServer).GetExportCapabilities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.DBService/GetExportCapabilities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DBServiceServer).GetExportCapabilities(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _DBService_GetActiveRestoreProcess_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DBServiceServer).GetActiveRestoreProcess(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.DBService/GetActiveRestoreProcess",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DBServiceServer).GetActiveRestoreProcess(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _DBService_InterruptRestoreProcess_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InterruptDBRestoreProcessRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DBServiceServer).InterruptRestoreProcess(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.DBService/InterruptRestoreProcess",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DBServiceServer).InterruptRestoreProcess(ctx, req.(*InterruptDBRestoreProcessRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DBService_CancelRestoreProcess_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DBServiceServer).CancelRestoreProcess(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.DBService/CancelRestoreProcess",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DBServiceServer).CancelRestoreProcess(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

var _DBService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1.DBService",
	HandlerType: (*DBServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetExportCapabilities",
			Handler:    _DBService_GetExportCapabilities_Handler,
		},
		{
			MethodName: "GetActiveRestoreProcess",
			Handler:    _DBService_GetActiveRestoreProcess_Handler,
		},
		{
			MethodName: "InterruptRestoreProcess",
			Handler:    _DBService_InterruptRestoreProcess_Handler,
		},
		{
			MethodName: "CancelRestoreProcess",
			Handler:    _DBService_CancelRestoreProcess_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/v1/db_service.proto",
}

func (m *DBRestoreRequestHeader) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DBRestoreRequestHeader) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DBRestoreRequestHeader) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.LocalFile != nil {
		{
			size, err := m.LocalFile.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDbService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Manifest != nil {
		{
			size, err := m.Manifest.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDbService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.FormatName) > 0 {
		i -= len(m.FormatName)
		copy(dAtA[i:], m.FormatName)
		i = encodeVarintDbService(dAtA, i, uint64(len(m.FormatName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DBRestoreRequestHeader_LocalFileInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DBRestoreRequestHeader_LocalFileInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DBRestoreRequestHeader_LocalFileInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.BytesSize != 0 {
		i = encodeVarintDbService(dAtA, i, uint64(m.BytesSize))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Path) > 0 {
		i -= len(m.Path)
		copy(dAtA[i:], m.Path)
		i = encodeVarintDbService(dAtA, i, uint64(len(m.Path)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DBRestoreProcessMetadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DBRestoreProcessMetadata) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DBRestoreProcessMetadata) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.InitiatingUserName) > 0 {
		i -= len(m.InitiatingUserName)
		copy(dAtA[i:], m.InitiatingUserName)
		i = encodeVarintDbService(dAtA, i, uint64(len(m.InitiatingUserName)))
		i--
		dAtA[i] = 0x22
	}
	if m.StartTime != nil {
		{
			size, err := m.StartTime.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDbService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Header != nil {
		{
			size, err := m.Header.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDbService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintDbService(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DBRestoreProcessStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DBRestoreProcessStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DBRestoreProcessStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.FilesProcessed != 0 {
		i = encodeVarintDbService(dAtA, i, uint64(m.FilesProcessed))
		i--
		dAtA[i] = 0x38
	}
	if m.BytesRead != 0 {
		i = encodeVarintDbService(dAtA, i, uint64(m.BytesRead))
		i--
		dAtA[i] = 0x30
	}
	if len(m.Error) > 0 {
		i -= len(m.Error)
		copy(dAtA[i:], m.Error)
		i = encodeVarintDbService(dAtA, i, uint64(len(m.Error)))
		i--
		dAtA[i] = 0x2a
	}
	if m.ResumeInfo != nil {
		{
			size, err := m.ResumeInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDbService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.State != 0 {
		i = encodeVarintDbService(dAtA, i, uint64(m.State))
		i--
		dAtA[i] = 0x18
	}
	if len(m.AttemptId) > 0 {
		i -= len(m.AttemptId)
		copy(dAtA[i:], m.AttemptId)
		i = encodeVarintDbService(dAtA, i, uint64(len(m.AttemptId)))
		i--
		dAtA[i] = 0x12
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDbService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DBRestoreProcessStatus_ResumeInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DBRestoreProcessStatus_ResumeInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DBRestoreProcessStatus_ResumeInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Pos != 0 {
		i = encodeVarintDbService(dAtA, i, uint64(m.Pos))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *DBExportManifest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DBExportManifest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DBExportManifest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Files) > 0 {
		for iNdEx := len(m.Files) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Files[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintDbService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *DBExportManifest_File) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DBExportManifest_File) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DBExportManifest_File) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.DecodedCrc32 != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(m.DecodedCrc32))
		i--
		dAtA[i] = 0x2d
	}
	if m.DecodedSize != 0 {
		i = encodeVarintDbService(dAtA, i, uint64(m.DecodedSize))
		i--
		dAtA[i] = 0x20
	}
	if m.EncodedSize != 0 {
		i = encodeVarintDbService(dAtA, i, uint64(m.EncodedSize))
		i--
		dAtA[i] = 0x18
	}
	if m.Encoding != 0 {
		i = encodeVarintDbService(dAtA, i, uint64(m.Encoding))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintDbService(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DBExportFormat) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DBExportFormat) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DBExportFormat) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Files) > 0 {
		for iNdEx := len(m.Files) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Files[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintDbService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.FormatName) > 0 {
		i -= len(m.FormatName)
		copy(dAtA[i:], m.FormatName)
		i = encodeVarintDbService(dAtA, i, uint64(len(m.FormatName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DBExportFormat_File) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DBExportFormat_File) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DBExportFormat_File) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Optional {
		i--
		if m.Optional {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintDbService(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetDBExportCapabilitiesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetDBExportCapabilitiesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetDBExportCapabilitiesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.SupportedEncodings) > 0 {
		dAtA8 := make([]byte, len(m.SupportedEncodings)*10)
		var j7 int
		for _, num := range m.SupportedEncodings {
			for num >= 1<<7 {
				dAtA8[j7] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j7++
			}
			dAtA8[j7] = uint8(num)
			j7++
		}
		i -= j7
		copy(dAtA[i:], dAtA8[:j7])
		i = encodeVarintDbService(dAtA, i, uint64(j7))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Formats) > 0 {
		for iNdEx := len(m.Formats) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Formats[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintDbService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *GetActiveDBRestoreProcessResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetActiveDBRestoreProcessResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetActiveDBRestoreProcessResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ActiveStatus != nil {
		{
			size, err := m.ActiveStatus.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDbService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *InterruptDBRestoreProcessRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InterruptDBRestoreProcessRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *InterruptDBRestoreProcessRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.AttemptId) > 0 {
		i -= len(m.AttemptId)
		copy(dAtA[i:], m.AttemptId)
		i = encodeVarintDbService(dAtA, i, uint64(len(m.AttemptId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ProcessId) > 0 {
		i -= len(m.ProcessId)
		copy(dAtA[i:], m.ProcessId)
		i = encodeVarintDbService(dAtA, i, uint64(len(m.ProcessId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *InterruptDBRestoreProcessResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InterruptDBRestoreProcessResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *InterruptDBRestoreProcessResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ResumeInfo != nil {
		{
			size, err := m.ResumeInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDbService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintDbService(dAtA []byte, offset int, v uint64) int {
	offset -= sovDbService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *DBRestoreRequestHeader) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.FormatName)
	if l > 0 {
		n += 1 + l + sovDbService(uint64(l))
	}
	if m.Manifest != nil {
		l = m.Manifest.Size()
		n += 1 + l + sovDbService(uint64(l))
	}
	if m.LocalFile != nil {
		l = m.LocalFile.Size()
		n += 1 + l + sovDbService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DBRestoreRequestHeader_LocalFileInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovDbService(uint64(l))
	}
	if m.BytesSize != 0 {
		n += 1 + sovDbService(uint64(m.BytesSize))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DBRestoreProcessMetadata) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovDbService(uint64(l))
	}
	if m.Header != nil {
		l = m.Header.Size()
		n += 1 + l + sovDbService(uint64(l))
	}
	if m.StartTime != nil {
		l = m.StartTime.Size()
		n += 1 + l + sovDbService(uint64(l))
	}
	l = len(m.InitiatingUserName)
	if l > 0 {
		n += 1 + l + sovDbService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DBRestoreProcessStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovDbService(uint64(l))
	}
	l = len(m.AttemptId)
	if l > 0 {
		n += 1 + l + sovDbService(uint64(l))
	}
	if m.State != 0 {
		n += 1 + sovDbService(uint64(m.State))
	}
	if m.ResumeInfo != nil {
		l = m.ResumeInfo.Size()
		n += 1 + l + sovDbService(uint64(l))
	}
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovDbService(uint64(l))
	}
	if m.BytesRead != 0 {
		n += 1 + sovDbService(uint64(m.BytesRead))
	}
	if m.FilesProcessed != 0 {
		n += 1 + sovDbService(uint64(m.FilesProcessed))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DBRestoreProcessStatus_ResumeInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Pos != 0 {
		n += 1 + sovDbService(uint64(m.Pos))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DBExportManifest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Files) > 0 {
		for _, e := range m.Files {
			l = e.Size()
			n += 1 + l + sovDbService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DBExportManifest_File) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovDbService(uint64(l))
	}
	if m.Encoding != 0 {
		n += 1 + sovDbService(uint64(m.Encoding))
	}
	if m.EncodedSize != 0 {
		n += 1 + sovDbService(uint64(m.EncodedSize))
	}
	if m.DecodedSize != 0 {
		n += 1 + sovDbService(uint64(m.DecodedSize))
	}
	if m.DecodedCrc32 != 0 {
		n += 5
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DBExportFormat) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.FormatName)
	if l > 0 {
		n += 1 + l + sovDbService(uint64(l))
	}
	if len(m.Files) > 0 {
		for _, e := range m.Files {
			l = e.Size()
			n += 1 + l + sovDbService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DBExportFormat_File) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovDbService(uint64(l))
	}
	if m.Optional {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetDBExportCapabilitiesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Formats) > 0 {
		for _, e := range m.Formats {
			l = e.Size()
			n += 1 + l + sovDbService(uint64(l))
		}
	}
	if len(m.SupportedEncodings) > 0 {
		l = 0
		for _, e := range m.SupportedEncodings {
			l += sovDbService(uint64(e))
		}
		n += 1 + sovDbService(uint64(l)) + l
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetActiveDBRestoreProcessResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ActiveStatus != nil {
		l = m.ActiveStatus.Size()
		n += 1 + l + sovDbService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *InterruptDBRestoreProcessRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ProcessId)
	if l > 0 {
		n += 1 + l + sovDbService(uint64(l))
	}
	l = len(m.AttemptId)
	if l > 0 {
		n += 1 + l + sovDbService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *InterruptDBRestoreProcessResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ResumeInfo != nil {
		l = m.ResumeInfo.Size()
		n += 1 + l + sovDbService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovDbService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozDbService(x uint64) (n int) {
	return sovDbService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *DBRestoreRequestHeader) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDbService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DBRestoreRequestHeader: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DBRestoreRequestHeader: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FormatName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDbService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDbService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDbService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FormatName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Manifest", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDbService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDbService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDbService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Manifest == nil {
				m.Manifest = &DBExportManifest{}
			}
			if err := m.Manifest.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalFile", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDbService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDbService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDbService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LocalFile == nil {
				m.LocalFile = &DBRestoreRequestHeader_LocalFileInfo{}
			}
			if err := m.LocalFile.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDbService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDbService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DBRestoreRequestHeader_LocalFileInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDbService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LocalFileInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LocalFileInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDbService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDbService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDbService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BytesSize", wireType)
			}
			m.BytesSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDbService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BytesSize |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipDbService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDbService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DBRestoreProcessMetadata) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDbService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DBRestoreProcessMetadata: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DBRestoreProcessMetadata: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDbService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDbService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDbService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Header", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDbService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDbService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDbService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Header == nil {
				m.Header = &DBRestoreRequestHeader{}
			}
			if err := m.Header.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDbService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDbService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDbService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartTime == nil {
				m.StartTime = &types.Timestamp{}
			}
			if err := m.StartTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitiatingUserName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDbService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDbService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDbService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.InitiatingUserName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDbService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDbService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DBRestoreProcessStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDbService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DBRestoreProcessStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DBRestoreProcessStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDbService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDbService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDbService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &DBRestoreProcessMetadata{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AttemptId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDbService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDbService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDbService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AttemptId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDbService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= DBRestoreProcessStatus_State(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResumeInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDbService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDbService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDbService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResumeInfo == nil {
				m.ResumeInfo = &DBRestoreProcessStatus_ResumeInfo{}
			}
			if err := m.ResumeInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDbService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDbService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDbService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BytesRead", wireType)
			}
			m.BytesRead = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDbService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BytesRead |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FilesProcessed", wireType)
			}
			m.FilesProcessed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDbService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FilesProcessed |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipDbService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDbService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DBRestoreProcessStatus_ResumeInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDbService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResumeInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResumeInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pos", wireType)
			}
			m.Pos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDbService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Pos |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipDbService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDbService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DBExportManifest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDbService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DBExportManifest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DBExportManifest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Files", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDbService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDbService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDbService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Files = append(m.Files, &DBExportManifest_File{})
			if err := m.Files[len(m.Files)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDbService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDbService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DBExportManifest_File) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDbService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: File: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: File: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDbService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDbService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDbService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Encoding", wireType)
			}
			m.Encoding = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDbService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Encoding |= DBExportManifest_EncodingType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EncodedSize", wireType)
			}
			m.EncodedSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDbService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EncodedSize |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DecodedSize", wireType)
			}
			m.DecodedSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDbService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DecodedSize |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field DecodedCrc32", wireType)
			}
			m.DecodedCrc32 = 0
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			m.DecodedCrc32 = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
		default:
			iNdEx = preIndex
			skippy, err := skipDbService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDbService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DBExportFormat) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDbService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DBExportFormat: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DBExportFormat: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FormatName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDbService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDbService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDbService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FormatName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Files", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDbService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDbService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDbService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Files = append(m.Files, &DBExportFormat_File{})
			if err := m.Files[len(m.Files)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDbService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDbService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DBExportFormat_File) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDbService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: File: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: File: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDbService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDbService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDbService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Optional", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDbService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Optional = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipDbService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDbService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetDBExportCapabilitiesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDbService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetDBExportCapabilitiesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetDBExportCapabilitiesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Formats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDbService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDbService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDbService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Formats = append(m.Formats, &DBExportFormat{})
			if err := m.Formats[len(m.Formats)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType == 0 {
				var v DBExportManifest_EncodingType
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowDbService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= DBExportManifest_EncodingType(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.SupportedEncodings = append(m.SupportedEncodings, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowDbService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthDbService
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthDbService
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				if elementCount != 0 && len(m.SupportedEncodings) == 0 {
					m.SupportedEncodings = make([]DBExportManifest_EncodingType, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v DBExportManifest_EncodingType
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowDbService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= DBExportManifest_EncodingType(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.SupportedEncodings = append(m.SupportedEncodings, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field SupportedEncodings", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipDbService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDbService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetActiveDBRestoreProcessResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDbService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetActiveDBRestoreProcessResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetActiveDBRestoreProcessResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ActiveStatus", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDbService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDbService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDbService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ActiveStatus == nil {
				m.ActiveStatus = &DBRestoreProcessStatus{}
			}
			if err := m.ActiveStatus.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDbService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDbService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InterruptDBRestoreProcessRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDbService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InterruptDBRestoreProcessRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InterruptDBRestoreProcessRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProcessId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDbService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDbService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDbService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProcessId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AttemptId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDbService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDbService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDbService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AttemptId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDbService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDbService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InterruptDBRestoreProcessResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDbService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InterruptDBRestoreProcessResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InterruptDBRestoreProcessResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResumeInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDbService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDbService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDbService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResumeInfo == nil {
				m.ResumeInfo = &DBRestoreProcessStatus_ResumeInfo{}
			}
			if err := m.ResumeInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDbService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDbService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipDbService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowDbService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowDbService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowDbService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthDbService
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupDbService
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthDbService
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthDbService        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowDbService          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupDbService = fmt.Errorf("proto: unexpected end of group")
)
