// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api/v1/deployment_service.proto

package v1

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	storage "github.com/stackrox/rox/generated/storage"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type DeploymentLabelsResponse struct {
	Labels               map[string]*DeploymentLabelsResponse_LabelValues `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Values               []string                                         `protobuf:"bytes,2,rep,name=values,proto3" json:"values,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                         `json:"-"`
	XXX_unrecognized     []byte                                           `json:"-"`
	XXX_sizecache        int32                                            `json:"-"`
}

func (m *DeploymentLabelsResponse) Reset()         { *m = DeploymentLabelsResponse{} }
func (m *DeploymentLabelsResponse) String() string { return proto.CompactTextString(m) }
func (*DeploymentLabelsResponse) ProtoMessage()    {}
func (*DeploymentLabelsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_081153b22511ab60, []int{0}
}
func (m *DeploymentLabelsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeploymentLabelsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeploymentLabelsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeploymentLabelsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeploymentLabelsResponse.Merge(m, src)
}
func (m *DeploymentLabelsResponse) XXX_Size() int {
	return m.Size()
}
func (m *DeploymentLabelsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DeploymentLabelsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DeploymentLabelsResponse proto.InternalMessageInfo

func (m *DeploymentLabelsResponse) GetLabels() map[string]*DeploymentLabelsResponse_LabelValues {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *DeploymentLabelsResponse) GetValues() []string {
	if m != nil {
		return m.Values
	}
	return nil
}

func (m *DeploymentLabelsResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *DeploymentLabelsResponse) Clone() *DeploymentLabelsResponse {
	if m == nil {
		return nil
	}
	cloned := new(DeploymentLabelsResponse)
	*cloned = *m

	if m.Labels != nil {
		cloned.Labels = make(map[string]*DeploymentLabelsResponse_LabelValues, len(m.Labels))
		for k, v := range m.Labels {
			cloned.Labels[k] = v.Clone()
		}
	}
	if m.Values != nil {
		cloned.Values = make([]string, len(m.Values))
		copy(cloned.Values, m.Values)
	}
	return cloned
}

type DeploymentLabelsResponse_LabelValues struct {
	Values               []string `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeploymentLabelsResponse_LabelValues) Reset()         { *m = DeploymentLabelsResponse_LabelValues{} }
func (m *DeploymentLabelsResponse_LabelValues) String() string { return proto.CompactTextString(m) }
func (*DeploymentLabelsResponse_LabelValues) ProtoMessage()    {}
func (*DeploymentLabelsResponse_LabelValues) Descriptor() ([]byte, []int) {
	return fileDescriptor_081153b22511ab60, []int{0, 0}
}
func (m *DeploymentLabelsResponse_LabelValues) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeploymentLabelsResponse_LabelValues) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeploymentLabelsResponse_LabelValues.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeploymentLabelsResponse_LabelValues) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeploymentLabelsResponse_LabelValues.Merge(m, src)
}
func (m *DeploymentLabelsResponse_LabelValues) XXX_Size() int {
	return m.Size()
}
func (m *DeploymentLabelsResponse_LabelValues) XXX_DiscardUnknown() {
	xxx_messageInfo_DeploymentLabelsResponse_LabelValues.DiscardUnknown(m)
}

var xxx_messageInfo_DeploymentLabelsResponse_LabelValues proto.InternalMessageInfo

func (m *DeploymentLabelsResponse_LabelValues) GetValues() []string {
	if m != nil {
		return m.Values
	}
	return nil
}

func (m *DeploymentLabelsResponse_LabelValues) MessageClone() proto.Message {
	return m.Clone()
}
func (m *DeploymentLabelsResponse_LabelValues) Clone() *DeploymentLabelsResponse_LabelValues {
	if m == nil {
		return nil
	}
	cloned := new(DeploymentLabelsResponse_LabelValues)
	*cloned = *m

	if m.Values != nil {
		cloned.Values = make([]string, len(m.Values))
		copy(cloned.Values, m.Values)
	}
	return cloned
}

type ListDeploymentsResponse struct {
	Deployments          []*storage.ListDeployment `protobuf:"bytes,1,rep,name=deployments,proto3" json:"deployments,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *ListDeploymentsResponse) Reset()         { *m = ListDeploymentsResponse{} }
func (m *ListDeploymentsResponse) String() string { return proto.CompactTextString(m) }
func (*ListDeploymentsResponse) ProtoMessage()    {}
func (*ListDeploymentsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_081153b22511ab60, []int{1}
}
func (m *ListDeploymentsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListDeploymentsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListDeploymentsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListDeploymentsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDeploymentsResponse.Merge(m, src)
}
func (m *ListDeploymentsResponse) XXX_Size() int {
	return m.Size()
}
func (m *ListDeploymentsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDeploymentsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListDeploymentsResponse proto.InternalMessageInfo

func (m *ListDeploymentsResponse) GetDeployments() []*storage.ListDeployment {
	if m != nil {
		return m.Deployments
	}
	return nil
}

func (m *ListDeploymentsResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ListDeploymentsResponse) Clone() *ListDeploymentsResponse {
	if m == nil {
		return nil
	}
	cloned := new(ListDeploymentsResponse)
	*cloned = *m

	if m.Deployments != nil {
		cloned.Deployments = make([]*storage.ListDeployment, len(m.Deployments))
		for idx, v := range m.Deployments {
			cloned.Deployments[idx] = v.Clone()
		}
	}
	return cloned
}

type CountDeploymentsResponse struct {
	Count                int32    `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CountDeploymentsResponse) Reset()         { *m = CountDeploymentsResponse{} }
func (m *CountDeploymentsResponse) String() string { return proto.CompactTextString(m) }
func (*CountDeploymentsResponse) ProtoMessage()    {}
func (*CountDeploymentsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_081153b22511ab60, []int{2}
}
func (m *CountDeploymentsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CountDeploymentsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CountDeploymentsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CountDeploymentsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CountDeploymentsResponse.Merge(m, src)
}
func (m *CountDeploymentsResponse) XXX_Size() int {
	return m.Size()
}
func (m *CountDeploymentsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CountDeploymentsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CountDeploymentsResponse proto.InternalMessageInfo

func (m *CountDeploymentsResponse) GetCount() int32 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *CountDeploymentsResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *CountDeploymentsResponse) Clone() *CountDeploymentsResponse {
	if m == nil {
		return nil
	}
	cloned := new(CountDeploymentsResponse)
	*cloned = *m

	return cloned
}

type ListDeploymentsWithProcessInfoResponse struct {
	Deployments          []*ListDeploymentsWithProcessInfoResponse_DeploymentWithProcessInfo `protobuf:"bytes,1,rep,name=deployments,proto3" json:"deployments,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                                            `json:"-"`
	XXX_unrecognized     []byte                                                              `json:"-"`
	XXX_sizecache        int32                                                               `json:"-"`
}

func (m *ListDeploymentsWithProcessInfoResponse) Reset() {
	*m = ListDeploymentsWithProcessInfoResponse{}
}
func (m *ListDeploymentsWithProcessInfoResponse) String() string { return proto.CompactTextString(m) }
func (*ListDeploymentsWithProcessInfoResponse) ProtoMessage()    {}
func (*ListDeploymentsWithProcessInfoResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_081153b22511ab60, []int{3}
}
func (m *ListDeploymentsWithProcessInfoResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListDeploymentsWithProcessInfoResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListDeploymentsWithProcessInfoResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListDeploymentsWithProcessInfoResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDeploymentsWithProcessInfoResponse.Merge(m, src)
}
func (m *ListDeploymentsWithProcessInfoResponse) XXX_Size() int {
	return m.Size()
}
func (m *ListDeploymentsWithProcessInfoResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDeploymentsWithProcessInfoResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListDeploymentsWithProcessInfoResponse proto.InternalMessageInfo

func (m *ListDeploymentsWithProcessInfoResponse) GetDeployments() []*ListDeploymentsWithProcessInfoResponse_DeploymentWithProcessInfo {
	if m != nil {
		return m.Deployments
	}
	return nil
}

func (m *ListDeploymentsWithProcessInfoResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ListDeploymentsWithProcessInfoResponse) Clone() *ListDeploymentsWithProcessInfoResponse {
	if m == nil {
		return nil
	}
	cloned := new(ListDeploymentsWithProcessInfoResponse)
	*cloned = *m

	if m.Deployments != nil {
		cloned.Deployments = make([]*ListDeploymentsWithProcessInfoResponse_DeploymentWithProcessInfo, len(m.Deployments))
		for idx, v := range m.Deployments {
			cloned.Deployments[idx] = v.Clone()
		}
	}
	return cloned
}

type ListDeploymentsWithProcessInfoResponse_DeploymentWithProcessInfo struct {
	Deployment           *storage.ListDeployment                   `protobuf:"bytes,1,opt,name=deployment,proto3" json:"deployment,omitempty"`
	WhitelistStatuses    []*storage.ContainerNameAndBaselineStatus `protobuf:"bytes,2,rep,name=whitelist_statuses,json=whitelistStatuses,proto3" json:"whitelist_statuses,omitempty"` // Deprecated: Do not use.
	BaselineStatuses     []*storage.ContainerNameAndBaselineStatus `protobuf:"bytes,3,rep,name=baseline_statuses,json=baselineStatuses,proto3" json:"baseline_statuses,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                  `json:"-"`
	XXX_unrecognized     []byte                                    `json:"-"`
	XXX_sizecache        int32                                     `json:"-"`
}

func (m *ListDeploymentsWithProcessInfoResponse_DeploymentWithProcessInfo) Reset() {
	*m = ListDeploymentsWithProcessInfoResponse_DeploymentWithProcessInfo{}
}
func (m *ListDeploymentsWithProcessInfoResponse_DeploymentWithProcessInfo) String() string {
	return proto.CompactTextString(m)
}
func (*ListDeploymentsWithProcessInfoResponse_DeploymentWithProcessInfo) ProtoMessage() {}
func (*ListDeploymentsWithProcessInfoResponse_DeploymentWithProcessInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_081153b22511ab60, []int{3, 0}
}
func (m *ListDeploymentsWithProcessInfoResponse_DeploymentWithProcessInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListDeploymentsWithProcessInfoResponse_DeploymentWithProcessInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListDeploymentsWithProcessInfoResponse_DeploymentWithProcessInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListDeploymentsWithProcessInfoResponse_DeploymentWithProcessInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDeploymentsWithProcessInfoResponse_DeploymentWithProcessInfo.Merge(m, src)
}
func (m *ListDeploymentsWithProcessInfoResponse_DeploymentWithProcessInfo) XXX_Size() int {
	return m.Size()
}
func (m *ListDeploymentsWithProcessInfoResponse_DeploymentWithProcessInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDeploymentsWithProcessInfoResponse_DeploymentWithProcessInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ListDeploymentsWithProcessInfoResponse_DeploymentWithProcessInfo proto.InternalMessageInfo

func (m *ListDeploymentsWithProcessInfoResponse_DeploymentWithProcessInfo) GetDeployment() *storage.ListDeployment {
	if m != nil {
		return m.Deployment
	}
	return nil
}

// Deprecated: Do not use.
func (m *ListDeploymentsWithProcessInfoResponse_DeploymentWithProcessInfo) GetWhitelistStatuses() []*storage.ContainerNameAndBaselineStatus {
	if m != nil {
		return m.WhitelistStatuses
	}
	return nil
}

func (m *ListDeploymentsWithProcessInfoResponse_DeploymentWithProcessInfo) GetBaselineStatuses() []*storage.ContainerNameAndBaselineStatus {
	if m != nil {
		return m.BaselineStatuses
	}
	return nil
}

func (m *ListDeploymentsWithProcessInfoResponse_DeploymentWithProcessInfo) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ListDeploymentsWithProcessInfoResponse_DeploymentWithProcessInfo) Clone() *ListDeploymentsWithProcessInfoResponse_DeploymentWithProcessInfo {
	if m == nil {
		return nil
	}
	cloned := new(ListDeploymentsWithProcessInfoResponse_DeploymentWithProcessInfo)
	*cloned = *m

	cloned.Deployment = m.Deployment.Clone()
	if m.WhitelistStatuses != nil {
		cloned.WhitelistStatuses = make([]*storage.ContainerNameAndBaselineStatus, len(m.WhitelistStatuses))
		for idx, v := range m.WhitelistStatuses {
			cloned.WhitelistStatuses[idx] = v.Clone()
		}
	}
	if m.BaselineStatuses != nil {
		cloned.BaselineStatuses = make([]*storage.ContainerNameAndBaselineStatus, len(m.BaselineStatuses))
		for idx, v := range m.BaselineStatuses {
			cloned.BaselineStatuses[idx] = v.Clone()
		}
	}
	return cloned
}

type GetDeploymentWithRiskResponse struct {
	Deployment           *storage.Deployment `protobuf:"bytes,1,opt,name=deployment,proto3" json:"deployment,omitempty"`
	Risk                 *storage.Risk       `protobuf:"bytes,2,opt,name=risk,proto3" json:"risk,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *GetDeploymentWithRiskResponse) Reset()         { *m = GetDeploymentWithRiskResponse{} }
func (m *GetDeploymentWithRiskResponse) String() string { return proto.CompactTextString(m) }
func (*GetDeploymentWithRiskResponse) ProtoMessage()    {}
func (*GetDeploymentWithRiskResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_081153b22511ab60, []int{4}
}
func (m *GetDeploymentWithRiskResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetDeploymentWithRiskResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetDeploymentWithRiskResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetDeploymentWithRiskResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDeploymentWithRiskResponse.Merge(m, src)
}
func (m *GetDeploymentWithRiskResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetDeploymentWithRiskResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDeploymentWithRiskResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetDeploymentWithRiskResponse proto.InternalMessageInfo

func (m *GetDeploymentWithRiskResponse) GetDeployment() *storage.Deployment {
	if m != nil {
		return m.Deployment
	}
	return nil
}

func (m *GetDeploymentWithRiskResponse) GetRisk() *storage.Risk {
	if m != nil {
		return m.Risk
	}
	return nil
}

func (m *GetDeploymentWithRiskResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetDeploymentWithRiskResponse) Clone() *GetDeploymentWithRiskResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetDeploymentWithRiskResponse)
	*cloned = *m

	cloned.Deployment = m.Deployment.Clone()
	cloned.Risk = m.Risk.Clone()
	return cloned
}

func init() {
	proto.RegisterType((*DeploymentLabelsResponse)(nil), "v1.DeploymentLabelsResponse")
	proto.RegisterMapType((map[string]*DeploymentLabelsResponse_LabelValues)(nil), "v1.DeploymentLabelsResponse.LabelsEntry")
	proto.RegisterType((*DeploymentLabelsResponse_LabelValues)(nil), "v1.DeploymentLabelsResponse.LabelValues")
	proto.RegisterType((*ListDeploymentsResponse)(nil), "v1.ListDeploymentsResponse")
	proto.RegisterType((*CountDeploymentsResponse)(nil), "v1.CountDeploymentsResponse")
	proto.RegisterType((*ListDeploymentsWithProcessInfoResponse)(nil), "v1.ListDeploymentsWithProcessInfoResponse")
	proto.RegisterType((*ListDeploymentsWithProcessInfoResponse_DeploymentWithProcessInfo)(nil), "v1.ListDeploymentsWithProcessInfoResponse.DeploymentWithProcessInfo")
	proto.RegisterType((*GetDeploymentWithRiskResponse)(nil), "v1.GetDeploymentWithRiskResponse")
}

func init() { proto.RegisterFile("api/v1/deployment_service.proto", fileDescriptor_081153b22511ab60) }

var fileDescriptor_081153b22511ab60 = []byte{
	// 737 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x55, 0xcd, 0x4e, 0xdb, 0x4a,
	0x14, 0xc6, 0x0e, 0x20, 0x65, 0x72, 0x11, 0xc9, 0xc0, 0x05, 0xdf, 0x90, 0x6b, 0x82, 0x75, 0x2f,
	0x44, 0x5d, 0x38, 0x0d, 0x2c, 0xfa, 0xb3, 0xa8, 0xda, 0x00, 0x42, 0x48, 0xa8, 0x6a, 0x0d, 0xfd,
	0x11, 0x6a, 0x85, 0x26, 0xce, 0x40, 0x46, 0x71, 0x3c, 0x96, 0x67, 0xe2, 0x34, 0xaa, 0x2a, 0x55,
	0x2c, 0xfa, 0x02, 0xdd, 0xb4, 0x6f, 0xd4, 0x65, 0xa5, 0xbe, 0x40, 0x45, 0xfb, 0x0c, 0x5d, 0x57,
	0x1e, 0x4f, 0x9c, 0xd8, 0x72, 0x10, 0xdd, 0xe5, 0x9c, 0xf9, 0xce, 0xf7, 0xcd, 0xf9, 0x3c, 0xe7,
	0x04, 0xac, 0x23, 0x8f, 0xd4, 0x83, 0x46, 0xbd, 0x8d, 0x3d, 0x87, 0x0e, 0x7b, 0xd8, 0xe5, 0x67,
	0x0c, 0xfb, 0x01, 0xb1, 0xb1, 0xe9, 0xf9, 0x94, 0x53, 0xa8, 0x06, 0x8d, 0x72, 0xe5, 0x82, 0xd2,
	0x0b, 0x07, 0xd7, 0x43, 0x2c, 0x72, 0x5d, 0xca, 0x11, 0x27, 0xd4, 0x65, 0x11, 0xa2, 0xbc, 0x24,
	0x29, 0x6c, 0xda, 0xeb, 0x51, 0x57, 0x26, 0xd7, 0x64, 0x92, 0x61, 0xe4, 0xdb, 0x9d, 0x24, 0x67,
	0x19, 0xca, 0x43, 0xdc, 0xf3, 0xf8, 0x50, 0xe6, 0x34, 0xc6, 0xa9, 0x8f, 0x2e, 0xf0, 0xc4, 0x4d,
	0x46, 0xe8, 0xd1, 0x89, 0x4f, 0x58, 0x57, 0xe6, 0xf4, 0x51, 0xce, 0xf3, 0xa9, 0x8d, 0x19, 0x3b,
	0x6b, 0x21, 0x86, 0x1d, 0xe2, 0x4a, 0x05, 0xe3, 0xbd, 0x0a, 0xb4, 0xbd, 0x98, 0xe8, 0x08, 0xb5,
	0xb0, 0xc3, 0x2c, 0xcc, 0x3c, 0xea, 0x32, 0x0c, 0x1f, 0x82, 0x79, 0x47, 0x64, 0x34, 0xa5, 0x9a,
	0xab, 0x15, 0xb6, 0x6b, 0x66, 0xd0, 0x30, 0xa7, 0xa1, 0xcd, 0x28, 0xdc, 0x77, 0xb9, 0x3f, 0xb4,
	0x64, 0x1d, 0x5c, 0x01, 0xf3, 0x01, 0x72, 0xfa, 0x98, 0x69, 0x6a, 0x35, 0x57, 0xcb, 0x5b, 0x32,
	0x2a, 0xff, 0x0f, 0x0a, 0x02, 0xfe, 0x5c, 0x84, 0x13, 0x30, 0x25, 0x01, 0xb3, 0x25, 0x2c, 0x62,
	0x85, 0x45, 0x90, 0xeb, 0xe2, 0xa1, 0xa6, 0x54, 0x95, 0x5a, 0xde, 0x0a, 0x7f, 0xc2, 0x07, 0x60,
	0x4e, 0x40, 0x35, 0xb5, 0xaa, 0xdc, 0xec, 0x82, 0x91, 0xa2, 0x15, 0x95, 0xdd, 0x57, 0xef, 0x2a,
	0xc6, 0x09, 0x58, 0x3d, 0x22, 0x8c, 0x8f, 0xcb, 0xc6, 0x06, 0xdc, 0x03, 0x85, 0xb1, 0xcb, 0x23,
	0x17, 0x56, 0x4d, 0xe9, 0xa9, 0x99, 0x2c, 0xb3, 0x26, 0xb1, 0xc6, 0x6d, 0xa0, 0xed, 0xd2, 0xbe,
	0x9b, 0x49, 0xbb, 0x0c, 0xe6, 0xec, 0xf0, 0x4c, 0x74, 0x32, 0x67, 0x45, 0x81, 0xf1, 0x39, 0x07,
	0x36, 0x53, 0x17, 0x79, 0x41, 0x78, 0xe7, 0x49, 0xf4, 0xe1, 0x0e, 0xdd, 0x73, 0x1a, 0x13, 0x9c,
	0x67, 0xdd, 0x6b, 0x2f, 0x6c, 0xfe, 0x66, 0x04, 0x13, 0x1e, 0xa5, 0x11, 0x93, 0xc4, 0xe5, 0x0f,
	0x2a, 0xf8, 0x67, 0x2a, 0x14, 0xde, 0x01, 0x60, 0x0c, 0x16, 0xbd, 0x5c, 0x63, 0xce, 0x04, 0x14,
	0x9e, 0x02, 0x38, 0xe8, 0x10, 0x8e, 0x1d, 0xc2, 0xf8, 0x19, 0xe3, 0x88, 0xf7, 0x99, 0x7c, 0x21,
	0x85, 0xed, 0xad, 0x98, 0x60, 0x97, 0xba, 0x1c, 0x11, 0x17, 0xfb, 0x8f, 0x51, 0x0f, 0x3f, 0x72,
	0xdb, 0x4d, 0xf9, 0x72, 0x8f, 0x45, 0x41, 0x53, 0xd5, 0x14, 0xab, 0x14, 0xd3, 0x1c, 0x4b, 0x16,
	0x78, 0x02, 0x4a, 0xa3, 0x27, 0x3e, 0xa6, 0xce, 0xfd, 0x11, 0xb5, 0x55, 0x6c, 0x25, 0x62, 0xcc,
	0x8c, 0x01, 0xf8, 0xf7, 0x00, 0xf3, 0xa4, 0x15, 0x16, 0x61, 0xdd, 0xf8, 0x8b, 0xec, 0x64, 0x78,
	0xb1, 0x14, 0xeb, 0x4d, 0xf1, 0x61, 0x03, 0xcc, 0x86, 0xa3, 0x2a, 0x1f, 0xef, 0x42, 0x0c, 0x17,
	0xcc, 0xe2, 0x68, 0xfb, 0xd7, 0x2c, 0x28, 0x8d, 0xab, 0x8f, 0xa3, 0xed, 0x00, 0x4f, 0xc0, 0x42,
	0xe2, 0x3a, 0xb0, 0x18, 0x7e, 0x7b, 0x0b, 0x33, 0xda, 0xf7, 0x6d, 0xdc, 0x1c, 0x1e, 0xee, 0x95,
	0xb3, 0xc4, 0x8d, 0xca, 0xe5, 0xb7, 0x9f, 0x1f, 0xd5, 0x15, 0xb8, 0x9c, 0xdc, 0x64, 0xac, 0xfe,
	0x96, 0xb4, 0xdf, 0x41, 0x1f, 0xfc, 0x9d, 0xd9, 0x64, 0x06, 0xfb, 0x46, 0x98, 0xb9, 0xd6, 0x11,
	0xe3, 0x3f, 0xa1, 0xa5, 0xc3, 0x4a, 0x4a, 0x6b, 0x40, 0x78, 0x27, 0x6c, 0x2d, 0xd2, 0x7c, 0x05,
	0x8a, 0xe9, 0x31, 0x81, 0x7f, 0x09, 0x39, 0x34, 0x78, 0xda, 0xc7, 0xfe, 0xb0, 0x5c, 0x09, 0xa3,
	0x69, 0xa3, 0x34, 0xb5, 0x23, 0x31, 0x52, 0xf0, 0x19, 0x58, 0x4c, 0x0d, 0x44, 0x8a, 0x7c, 0x2d,
	0x63, 0x66, 0x62, 0xee, 0x55, 0xc1, 0x5d, 0x82, 0x8b, 0x29, 0x6e, 0x78, 0xa9, 0x00, 0xfd, 0xfa,
	0x41, 0x4b, 0xc9, 0xdc, 0xba, 0xf9, 0x68, 0x1a, 0x9b, 0x42, 0xb5, 0x0a, 0xf5, 0x0c, 0xdf, 0xe4,
	0x12, 0x27, 0xa1, 0xc2, 0x6b, 0x90, 0x3f, 0xc0, 0x72, 0xc5, 0xc1, 0x7c, 0x28, 0xb0, 0x1f, 0xfe,
	0x4b, 0x44, 0x7e, 0x4d, 0xdb, 0x81, 0xc6, 0x96, 0x60, 0xdf, 0x80, 0xeb, 0xe9, 0x17, 0xd0, 0xc3,
	0x1c, 0xb5, 0x11, 0x47, 0xf5, 0x68, 0x73, 0x37, 0xcd, 0x2f, 0x57, 0xba, 0xf2, 0xf5, 0x4a, 0x57,
	0xbe, 0x5f, 0xe9, 0xca, 0xa7, 0x1f, 0xfa, 0x0c, 0xd0, 0x08, 0x35, 0x19, 0x47, 0x76, 0xd7, 0xa7,
	0x6f, 0xa2, 0x7f, 0x0f, 0x13, 0x79, 0xc4, 0x0c, 0x1a, 0xa7, 0x6a, 0xd0, 0x78, 0x39, 0xd3, 0x9a,
	0x17, 0xb9, 0x9d, 0xdf, 0x01, 0x00, 0x00, 0xff, 0xff, 0x25, 0xc5, 0xc2, 0xd1, 0x2a, 0x07, 0x00,
	0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DeploymentServiceClient is the client API for DeploymentService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConnInterface.NewStream.
type DeploymentServiceClient interface {
	// GetDeployment returns a deployment given its ID.
	GetDeployment(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*storage.Deployment, error)
	// GetDeploymentWithRisk returns a deployment and its risk given its ID.
	GetDeploymentWithRisk(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*GetDeploymentWithRiskResponse, error)
	// CountDeployments returns the number of deployments.
	CountDeployments(ctx context.Context, in *RawQuery, opts ...grpc.CallOption) (*CountDeploymentsResponse, error)
	// ListDeployments returns the list of deployments.
	ListDeployments(ctx context.Context, in *RawQuery, opts ...grpc.CallOption) (*ListDeploymentsResponse, error)
	// ListDeploymentsWithProcessInfo returns the list of deployments with process information.
	ListDeploymentsWithProcessInfo(ctx context.Context, in *RawQuery, opts ...grpc.CallOption) (*ListDeploymentsWithProcessInfoResponse, error)
	// GetLabels returns the labels used by deployments.
	GetLabels(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*DeploymentLabelsResponse, error)
}

type deploymentServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDeploymentServiceClient(cc grpc.ClientConnInterface) DeploymentServiceClient {
	return &deploymentServiceClient{cc}
}

func (c *deploymentServiceClient) GetDeployment(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*storage.Deployment, error) {
	out := new(storage.Deployment)
	err := c.cc.Invoke(ctx, "/v1.DeploymentService/GetDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deploymentServiceClient) GetDeploymentWithRisk(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*GetDeploymentWithRiskResponse, error) {
	out := new(GetDeploymentWithRiskResponse)
	err := c.cc.Invoke(ctx, "/v1.DeploymentService/GetDeploymentWithRisk", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deploymentServiceClient) CountDeployments(ctx context.Context, in *RawQuery, opts ...grpc.CallOption) (*CountDeploymentsResponse, error) {
	out := new(CountDeploymentsResponse)
	err := c.cc.Invoke(ctx, "/v1.DeploymentService/CountDeployments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deploymentServiceClient) ListDeployments(ctx context.Context, in *RawQuery, opts ...grpc.CallOption) (*ListDeploymentsResponse, error) {
	out := new(ListDeploymentsResponse)
	err := c.cc.Invoke(ctx, "/v1.DeploymentService/ListDeployments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deploymentServiceClient) ListDeploymentsWithProcessInfo(ctx context.Context, in *RawQuery, opts ...grpc.CallOption) (*ListDeploymentsWithProcessInfoResponse, error) {
	out := new(ListDeploymentsWithProcessInfoResponse)
	err := c.cc.Invoke(ctx, "/v1.DeploymentService/ListDeploymentsWithProcessInfo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deploymentServiceClient) GetLabels(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*DeploymentLabelsResponse, error) {
	out := new(DeploymentLabelsResponse)
	err := c.cc.Invoke(ctx, "/v1.DeploymentService/GetLabels", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DeploymentServiceServer is the server API for DeploymentService service.
type DeploymentServiceServer interface {
	// GetDeployment returns a deployment given its ID.
	GetDeployment(context.Context, *ResourceByID) (*storage.Deployment, error)
	// GetDeploymentWithRisk returns a deployment and its risk given its ID.
	GetDeploymentWithRisk(context.Context, *ResourceByID) (*GetDeploymentWithRiskResponse, error)
	// CountDeployments returns the number of deployments.
	CountDeployments(context.Context, *RawQuery) (*CountDeploymentsResponse, error)
	// ListDeployments returns the list of deployments.
	ListDeployments(context.Context, *RawQuery) (*ListDeploymentsResponse, error)
	// ListDeploymentsWithProcessInfo returns the list of deployments with process information.
	ListDeploymentsWithProcessInfo(context.Context, *RawQuery) (*ListDeploymentsWithProcessInfoResponse, error)
	// GetLabels returns the labels used by deployments.
	GetLabels(context.Context, *Empty) (*DeploymentLabelsResponse, error)
}

// UnimplementedDeploymentServiceServer can be embedded to have forward compatible implementations.
type UnimplementedDeploymentServiceServer struct {
}

func (*UnimplementedDeploymentServiceServer) GetDeployment(ctx context.Context, req *ResourceByID) (*storage.Deployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDeployment not implemented")
}
func (*UnimplementedDeploymentServiceServer) GetDeploymentWithRisk(ctx context.Context, req *ResourceByID) (*GetDeploymentWithRiskResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDeploymentWithRisk not implemented")
}
func (*UnimplementedDeploymentServiceServer) CountDeployments(ctx context.Context, req *RawQuery) (*CountDeploymentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CountDeployments not implemented")
}
func (*UnimplementedDeploymentServiceServer) ListDeployments(ctx context.Context, req *RawQuery) (*ListDeploymentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDeployments not implemented")
}
func (*UnimplementedDeploymentServiceServer) ListDeploymentsWithProcessInfo(ctx context.Context, req *RawQuery) (*ListDeploymentsWithProcessInfoResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDeploymentsWithProcessInfo not implemented")
}
func (*UnimplementedDeploymentServiceServer) GetLabels(ctx context.Context, req *Empty) (*DeploymentLabelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLabels not implemented")
}

func RegisterDeploymentServiceServer(s *grpc.Server, srv DeploymentServiceServer) {
	s.RegisterService(&_DeploymentService_serviceDesc, srv)
}

func _DeploymentService_GetDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeploymentServiceServer).GetDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.DeploymentService/GetDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeploymentServiceServer).GetDeployment(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeploymentService_GetDeploymentWithRisk_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeploymentServiceServer).GetDeploymentWithRisk(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.DeploymentService/GetDeploymentWithRisk",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeploymentServiceServer).GetDeploymentWithRisk(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeploymentService_CountDeployments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RawQuery)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeploymentServiceServer).CountDeployments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.DeploymentService/CountDeployments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeploymentServiceServer).CountDeployments(ctx, req.(*RawQuery))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeploymentService_ListDeployments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RawQuery)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeploymentServiceServer).ListDeployments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.DeploymentService/ListDeployments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeploymentServiceServer).ListDeployments(ctx, req.(*RawQuery))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeploymentService_ListDeploymentsWithProcessInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RawQuery)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeploymentServiceServer).ListDeploymentsWithProcessInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.DeploymentService/ListDeploymentsWithProcessInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeploymentServiceServer).ListDeploymentsWithProcessInfo(ctx, req.(*RawQuery))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeploymentService_GetLabels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeploymentServiceServer).GetLabels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.DeploymentService/GetLabels",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeploymentServiceServer).GetLabels(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

var _DeploymentService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1.DeploymentService",
	HandlerType: (*DeploymentServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetDeployment",
			Handler:    _DeploymentService_GetDeployment_Handler,
		},
		{
			MethodName: "GetDeploymentWithRisk",
			Handler:    _DeploymentService_GetDeploymentWithRisk_Handler,
		},
		{
			MethodName: "CountDeployments",
			Handler:    _DeploymentService_CountDeployments_Handler,
		},
		{
			MethodName: "ListDeployments",
			Handler:    _DeploymentService_ListDeployments_Handler,
		},
		{
			MethodName: "ListDeploymentsWithProcessInfo",
			Handler:    _DeploymentService_ListDeploymentsWithProcessInfo_Handler,
		},
		{
			MethodName: "GetLabels",
			Handler:    _DeploymentService_GetLabels_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/v1/deployment_service.proto",
}

func (m *DeploymentLabelsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeploymentLabelsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeploymentLabelsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Values) > 0 {
		for iNdEx := len(m.Values) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Values[iNdEx])
			copy(dAtA[i:], m.Values[iNdEx])
			i = encodeVarintDeploymentService(dAtA, i, uint64(len(m.Values[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Labels) > 0 {
		for k := range m.Labels {
			v := m.Labels[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintDeploymentService(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintDeploymentService(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintDeploymentService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *DeploymentLabelsResponse_LabelValues) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeploymentLabelsResponse_LabelValues) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeploymentLabelsResponse_LabelValues) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Values) > 0 {
		for iNdEx := len(m.Values) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Values[iNdEx])
			copy(dAtA[i:], m.Values[iNdEx])
			i = encodeVarintDeploymentService(dAtA, i, uint64(len(m.Values[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ListDeploymentsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListDeploymentsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListDeploymentsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Deployments) > 0 {
		for iNdEx := len(m.Deployments) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Deployments[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintDeploymentService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *CountDeploymentsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CountDeploymentsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CountDeploymentsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Count != 0 {
		i = encodeVarintDeploymentService(dAtA, i, uint64(m.Count))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ListDeploymentsWithProcessInfoResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListDeploymentsWithProcessInfoResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListDeploymentsWithProcessInfoResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Deployments) > 0 {
		for iNdEx := len(m.Deployments) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Deployments[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintDeploymentService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ListDeploymentsWithProcessInfoResponse_DeploymentWithProcessInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListDeploymentsWithProcessInfoResponse_DeploymentWithProcessInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListDeploymentsWithProcessInfoResponse_DeploymentWithProcessInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.BaselineStatuses) > 0 {
		for iNdEx := len(m.BaselineStatuses) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.BaselineStatuses[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintDeploymentService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.WhitelistStatuses) > 0 {
		for iNdEx := len(m.WhitelistStatuses) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.WhitelistStatuses[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintDeploymentService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Deployment != nil {
		{
			size, err := m.Deployment.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDeploymentService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetDeploymentWithRiskResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetDeploymentWithRiskResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetDeploymentWithRiskResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Risk != nil {
		{
			size, err := m.Risk.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDeploymentService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Deployment != nil {
		{
			size, err := m.Deployment.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDeploymentService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintDeploymentService(dAtA []byte, offset int, v uint64) int {
	offset -= sovDeploymentService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *DeploymentLabelsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Labels) > 0 {
		for k, v := range m.Labels {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovDeploymentService(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovDeploymentService(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovDeploymentService(uint64(mapEntrySize))
		}
	}
	if len(m.Values) > 0 {
		for _, s := range m.Values {
			l = len(s)
			n += 1 + l + sovDeploymentService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeploymentLabelsResponse_LabelValues) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Values) > 0 {
		for _, s := range m.Values {
			l = len(s)
			n += 1 + l + sovDeploymentService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListDeploymentsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Deployments) > 0 {
		for _, e := range m.Deployments {
			l = e.Size()
			n += 1 + l + sovDeploymentService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CountDeploymentsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Count != 0 {
		n += 1 + sovDeploymentService(uint64(m.Count))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListDeploymentsWithProcessInfoResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Deployments) > 0 {
		for _, e := range m.Deployments {
			l = e.Size()
			n += 1 + l + sovDeploymentService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListDeploymentsWithProcessInfoResponse_DeploymentWithProcessInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Deployment != nil {
		l = m.Deployment.Size()
		n += 1 + l + sovDeploymentService(uint64(l))
	}
	if len(m.WhitelistStatuses) > 0 {
		for _, e := range m.WhitelistStatuses {
			l = e.Size()
			n += 1 + l + sovDeploymentService(uint64(l))
		}
	}
	if len(m.BaselineStatuses) > 0 {
		for _, e := range m.BaselineStatuses {
			l = e.Size()
			n += 1 + l + sovDeploymentService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetDeploymentWithRiskResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Deployment != nil {
		l = m.Deployment.Size()
		n += 1 + l + sovDeploymentService(uint64(l))
	}
	if m.Risk != nil {
		l = m.Risk.Size()
		n += 1 + l + sovDeploymentService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovDeploymentService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozDeploymentService(x uint64) (n int) {
	return sovDeploymentService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *DeploymentLabelsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDeploymentService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeploymentLabelsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeploymentLabelsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDeploymentService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDeploymentService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDeploymentService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Labels == nil {
				m.Labels = make(map[string]*DeploymentLabelsResponse_LabelValues)
			}
			var mapkey string
			var mapvalue *DeploymentLabelsResponse_LabelValues
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowDeploymentService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowDeploymentService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthDeploymentService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthDeploymentService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowDeploymentService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthDeploymentService
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthDeploymentService
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &DeploymentLabelsResponse_LabelValues{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipDeploymentService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthDeploymentService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Labels[mapkey] = mapvalue
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDeploymentService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDeploymentService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDeploymentService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Values = append(m.Values, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDeploymentService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDeploymentService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeploymentLabelsResponse_LabelValues) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDeploymentService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LabelValues: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LabelValues: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDeploymentService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDeploymentService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDeploymentService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Values = append(m.Values, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDeploymentService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDeploymentService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListDeploymentsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDeploymentService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListDeploymentsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListDeploymentsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Deployments", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDeploymentService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDeploymentService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDeploymentService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Deployments = append(m.Deployments, &storage.ListDeployment{})
			if err := m.Deployments[len(m.Deployments)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDeploymentService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDeploymentService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CountDeploymentsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDeploymentService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CountDeploymentsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CountDeploymentsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Count", wireType)
			}
			m.Count = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDeploymentService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Count |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipDeploymentService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDeploymentService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListDeploymentsWithProcessInfoResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDeploymentService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListDeploymentsWithProcessInfoResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListDeploymentsWithProcessInfoResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Deployments", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDeploymentService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDeploymentService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDeploymentService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Deployments = append(m.Deployments, &ListDeploymentsWithProcessInfoResponse_DeploymentWithProcessInfo{})
			if err := m.Deployments[len(m.Deployments)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDeploymentService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDeploymentService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListDeploymentsWithProcessInfoResponse_DeploymentWithProcessInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDeploymentService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeploymentWithProcessInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeploymentWithProcessInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Deployment", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDeploymentService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDeploymentService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDeploymentService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Deployment == nil {
				m.Deployment = &storage.ListDeployment{}
			}
			if err := m.Deployment.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WhitelistStatuses", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDeploymentService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDeploymentService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDeploymentService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WhitelistStatuses = append(m.WhitelistStatuses, &storage.ContainerNameAndBaselineStatus{})
			if err := m.WhitelistStatuses[len(m.WhitelistStatuses)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BaselineStatuses", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDeploymentService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDeploymentService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDeploymentService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BaselineStatuses = append(m.BaselineStatuses, &storage.ContainerNameAndBaselineStatus{})
			if err := m.BaselineStatuses[len(m.BaselineStatuses)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDeploymentService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDeploymentService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetDeploymentWithRiskResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDeploymentService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetDeploymentWithRiskResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetDeploymentWithRiskResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Deployment", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDeploymentService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDeploymentService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDeploymentService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Deployment == nil {
				m.Deployment = &storage.Deployment{}
			}
			if err := m.Deployment.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Risk", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDeploymentService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDeploymentService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDeploymentService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Risk == nil {
				m.Risk = &storage.Risk{}
			}
			if err := m.Risk.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDeploymentService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDeploymentService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipDeploymentService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowDeploymentService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowDeploymentService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowDeploymentService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthDeploymentService
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupDeploymentService
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthDeploymentService
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthDeploymentService        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowDeploymentService          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupDeploymentService = fmt.Errorf("proto: unexpected end of group")
)
