// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api/v1/detection_service.proto

package v1

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	storage "github.com/stackrox/rox/generated/storage"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type BuildDetectionRequest struct {
	// Types that are valid to be assigned to Resource:
	//	*BuildDetectionRequest_Image
	//	*BuildDetectionRequest_ImageName
	Resource             isBuildDetectionRequest_Resource `protobuf_oneof:"Resource"`
	NoExternalMetadata   bool                             `protobuf:"varint,2,opt,name=no_external_metadata,json=noExternalMetadata,proto3" json:"no_external_metadata,omitempty"`
	SendNotifications    bool                             `protobuf:"varint,4,opt,name=send_notifications,json=sendNotifications,proto3" json:"send_notifications,omitempty"`
	PolicyCategories     []string                         `protobuf:"bytes,5,rep,name=policy_categories,json=policyCategories,proto3" json:"policy_categories,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_unrecognized     []byte                           `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *BuildDetectionRequest) Reset()         { *m = BuildDetectionRequest{} }
func (m *BuildDetectionRequest) String() string { return proto.CompactTextString(m) }
func (*BuildDetectionRequest) ProtoMessage()    {}
func (*BuildDetectionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_19377923b2f3baac, []int{0}
}
func (m *BuildDetectionRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BuildDetectionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BuildDetectionRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *BuildDetectionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildDetectionRequest.Merge(m, src)
}
func (m *BuildDetectionRequest) XXX_Size() int {
	return m.Size()
}
func (m *BuildDetectionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildDetectionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BuildDetectionRequest proto.InternalMessageInfo

type isBuildDetectionRequest_Resource interface {
	isBuildDetectionRequest_Resource()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isBuildDetectionRequest_Resource
}

type BuildDetectionRequest_Image struct {
	Image *storage.ContainerImage `protobuf:"bytes,1,opt,name=image,proto3,oneof" json:"image,omitempty"`
}
type BuildDetectionRequest_ImageName struct {
	ImageName string `protobuf:"bytes,3,opt,name=image_name,json=imageName,proto3,oneof" json:"image_name,omitempty"`
}

func (*BuildDetectionRequest_Image) isBuildDetectionRequest_Resource() {}
func (m *BuildDetectionRequest_Image) Clone() isBuildDetectionRequest_Resource {
	if m == nil {
		return nil
	}
	cloned := new(BuildDetectionRequest_Image)
	*cloned = *m

	cloned.Image = m.Image.Clone()
	return cloned
}
func (*BuildDetectionRequest_ImageName) isBuildDetectionRequest_Resource() {}
func (m *BuildDetectionRequest_ImageName) Clone() isBuildDetectionRequest_Resource {
	if m == nil {
		return nil
	}
	cloned := new(BuildDetectionRequest_ImageName)
	*cloned = *m

	return cloned
}

func (m *BuildDetectionRequest) GetResource() isBuildDetectionRequest_Resource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *BuildDetectionRequest) GetImage() *storage.ContainerImage {
	if x, ok := m.GetResource().(*BuildDetectionRequest_Image); ok {
		return x.Image
	}
	return nil
}

func (m *BuildDetectionRequest) GetImageName() string {
	if x, ok := m.GetResource().(*BuildDetectionRequest_ImageName); ok {
		return x.ImageName
	}
	return ""
}

func (m *BuildDetectionRequest) GetNoExternalMetadata() bool {
	if m != nil {
		return m.NoExternalMetadata
	}
	return false
}

func (m *BuildDetectionRequest) GetSendNotifications() bool {
	if m != nil {
		return m.SendNotifications
	}
	return false
}

func (m *BuildDetectionRequest) GetPolicyCategories() []string {
	if m != nil {
		return m.PolicyCategories
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*BuildDetectionRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*BuildDetectionRequest_Image)(nil),
		(*BuildDetectionRequest_ImageName)(nil),
	}
}

func (m *BuildDetectionRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *BuildDetectionRequest) Clone() *BuildDetectionRequest {
	if m == nil {
		return nil
	}
	cloned := new(BuildDetectionRequest)
	*cloned = *m

	if m.Resource != nil {
		cloned.Resource = m.Resource.Clone()
	}
	if m.PolicyCategories != nil {
		cloned.PolicyCategories = make([]string, len(m.PolicyCategories))
		copy(cloned.PolicyCategories, m.PolicyCategories)
	}
	return cloned
}

type BuildDetectionResponse struct {
	Alerts               []*storage.Alert `protobuf:"bytes,1,rep,name=alerts,proto3" json:"alerts,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *BuildDetectionResponse) Reset()         { *m = BuildDetectionResponse{} }
func (m *BuildDetectionResponse) String() string { return proto.CompactTextString(m) }
func (*BuildDetectionResponse) ProtoMessage()    {}
func (*BuildDetectionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_19377923b2f3baac, []int{1}
}
func (m *BuildDetectionResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BuildDetectionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BuildDetectionResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *BuildDetectionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildDetectionResponse.Merge(m, src)
}
func (m *BuildDetectionResponse) XXX_Size() int {
	return m.Size()
}
func (m *BuildDetectionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildDetectionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BuildDetectionResponse proto.InternalMessageInfo

func (m *BuildDetectionResponse) GetAlerts() []*storage.Alert {
	if m != nil {
		return m.Alerts
	}
	return nil
}

func (m *BuildDetectionResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *BuildDetectionResponse) Clone() *BuildDetectionResponse {
	if m == nil {
		return nil
	}
	cloned := new(BuildDetectionResponse)
	*cloned = *m

	if m.Alerts != nil {
		cloned.Alerts = make([]*storage.Alert, len(m.Alerts))
		for idx, v := range m.Alerts {
			cloned.Alerts[idx] = v.Clone()
		}
	}
	return cloned
}

type DeployDetectionRequest struct {
	// Types that are valid to be assigned to Resource:
	//	*DeployDetectionRequest_Deployment
	Resource             isDeployDetectionRequest_Resource `protobuf_oneof:"Resource"`
	NoExternalMetadata   bool                              `protobuf:"varint,2,opt,name=no_external_metadata,json=noExternalMetadata,proto3" json:"no_external_metadata,omitempty"`
	EnforcementOnly      bool                              `protobuf:"varint,3,opt,name=enforcement_only,json=enforcementOnly,proto3" json:"enforcement_only,omitempty"`
	ClusterId            string                            `protobuf:"bytes,4,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *DeployDetectionRequest) Reset()         { *m = DeployDetectionRequest{} }
func (m *DeployDetectionRequest) String() string { return proto.CompactTextString(m) }
func (*DeployDetectionRequest) ProtoMessage()    {}
func (*DeployDetectionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_19377923b2f3baac, []int{2}
}
func (m *DeployDetectionRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeployDetectionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeployDetectionRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeployDetectionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeployDetectionRequest.Merge(m, src)
}
func (m *DeployDetectionRequest) XXX_Size() int {
	return m.Size()
}
func (m *DeployDetectionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeployDetectionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeployDetectionRequest proto.InternalMessageInfo

type isDeployDetectionRequest_Resource interface {
	isDeployDetectionRequest_Resource()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isDeployDetectionRequest_Resource
}

type DeployDetectionRequest_Deployment struct {
	Deployment *storage.Deployment `protobuf:"bytes,1,opt,name=deployment,proto3,oneof" json:"deployment,omitempty"`
}

func (*DeployDetectionRequest_Deployment) isDeployDetectionRequest_Resource() {}
func (m *DeployDetectionRequest_Deployment) Clone() isDeployDetectionRequest_Resource {
	if m == nil {
		return nil
	}
	cloned := new(DeployDetectionRequest_Deployment)
	*cloned = *m

	cloned.Deployment = m.Deployment.Clone()
	return cloned
}

func (m *DeployDetectionRequest) GetResource() isDeployDetectionRequest_Resource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *DeployDetectionRequest) GetDeployment() *storage.Deployment {
	if x, ok := m.GetResource().(*DeployDetectionRequest_Deployment); ok {
		return x.Deployment
	}
	return nil
}

func (m *DeployDetectionRequest) GetNoExternalMetadata() bool {
	if m != nil {
		return m.NoExternalMetadata
	}
	return false
}

func (m *DeployDetectionRequest) GetEnforcementOnly() bool {
	if m != nil {
		return m.EnforcementOnly
	}
	return false
}

func (m *DeployDetectionRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*DeployDetectionRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*DeployDetectionRequest_Deployment)(nil),
	}
}

func (m *DeployDetectionRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *DeployDetectionRequest) Clone() *DeployDetectionRequest {
	if m == nil {
		return nil
	}
	cloned := new(DeployDetectionRequest)
	*cloned = *m

	if m.Resource != nil {
		cloned.Resource = m.Resource.Clone()
	}
	return cloned
}

type DeployYAMLDetectionRequest struct {
	Yaml                 string   `protobuf:"bytes,1,opt,name=yaml,proto3" json:"yaml,omitempty"`
	NoExternalMetadata   bool     `protobuf:"varint,2,opt,name=no_external_metadata,json=noExternalMetadata,proto3" json:"no_external_metadata,omitempty"`
	EnforcementOnly      bool     `protobuf:"varint,3,opt,name=enforcement_only,json=enforcementOnly,proto3" json:"enforcement_only,omitempty"`
	PolicyCategories     []string `protobuf:"bytes,4,rep,name=policy_categories,json=policyCategories,proto3" json:"policy_categories,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeployYAMLDetectionRequest) Reset()         { *m = DeployYAMLDetectionRequest{} }
func (m *DeployYAMLDetectionRequest) String() string { return proto.CompactTextString(m) }
func (*DeployYAMLDetectionRequest) ProtoMessage()    {}
func (*DeployYAMLDetectionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_19377923b2f3baac, []int{3}
}
func (m *DeployYAMLDetectionRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeployYAMLDetectionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeployYAMLDetectionRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeployYAMLDetectionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeployYAMLDetectionRequest.Merge(m, src)
}
func (m *DeployYAMLDetectionRequest) XXX_Size() int {
	return m.Size()
}
func (m *DeployYAMLDetectionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeployYAMLDetectionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeployYAMLDetectionRequest proto.InternalMessageInfo

func (m *DeployYAMLDetectionRequest) GetYaml() string {
	if m != nil {
		return m.Yaml
	}
	return ""
}

func (m *DeployYAMLDetectionRequest) GetNoExternalMetadata() bool {
	if m != nil {
		return m.NoExternalMetadata
	}
	return false
}

func (m *DeployYAMLDetectionRequest) GetEnforcementOnly() bool {
	if m != nil {
		return m.EnforcementOnly
	}
	return false
}

func (m *DeployYAMLDetectionRequest) GetPolicyCategories() []string {
	if m != nil {
		return m.PolicyCategories
	}
	return nil
}

func (m *DeployYAMLDetectionRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *DeployYAMLDetectionRequest) Clone() *DeployYAMLDetectionRequest {
	if m == nil {
		return nil
	}
	cloned := new(DeployYAMLDetectionRequest)
	*cloned = *m

	if m.PolicyCategories != nil {
		cloned.PolicyCategories = make([]string, len(m.PolicyCategories))
		copy(cloned.PolicyCategories, m.PolicyCategories)
	}
	return cloned
}

type DeployDetectionResponse struct {
	Runs                 []*DeployDetectionResponse_Run `protobuf:"bytes,1,rep,name=runs,proto3" json:"runs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *DeployDetectionResponse) Reset()         { *m = DeployDetectionResponse{} }
func (m *DeployDetectionResponse) String() string { return proto.CompactTextString(m) }
func (*DeployDetectionResponse) ProtoMessage()    {}
func (*DeployDetectionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_19377923b2f3baac, []int{4}
}
func (m *DeployDetectionResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeployDetectionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeployDetectionResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeployDetectionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeployDetectionResponse.Merge(m, src)
}
func (m *DeployDetectionResponse) XXX_Size() int {
	return m.Size()
}
func (m *DeployDetectionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DeployDetectionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DeployDetectionResponse proto.InternalMessageInfo

func (m *DeployDetectionResponse) GetRuns() []*DeployDetectionResponse_Run {
	if m != nil {
		return m.Runs
	}
	return nil
}

func (m *DeployDetectionResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *DeployDetectionResponse) Clone() *DeployDetectionResponse {
	if m == nil {
		return nil
	}
	cloned := new(DeployDetectionResponse)
	*cloned = *m

	if m.Runs != nil {
		cloned.Runs = make([]*DeployDetectionResponse_Run, len(m.Runs))
		for idx, v := range m.Runs {
			cloned.Runs[idx] = v.Clone()
		}
	}
	return cloned
}

type DeployDetectionResponse_Run struct {
	Name                 string           `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Type                 string           `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	Alerts               []*storage.Alert `protobuf:"bytes,3,rep,name=alerts,proto3" json:"alerts,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *DeployDetectionResponse_Run) Reset()         { *m = DeployDetectionResponse_Run{} }
func (m *DeployDetectionResponse_Run) String() string { return proto.CompactTextString(m) }
func (*DeployDetectionResponse_Run) ProtoMessage()    {}
func (*DeployDetectionResponse_Run) Descriptor() ([]byte, []int) {
	return fileDescriptor_19377923b2f3baac, []int{4, 0}
}
func (m *DeployDetectionResponse_Run) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeployDetectionResponse_Run) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeployDetectionResponse_Run.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeployDetectionResponse_Run) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeployDetectionResponse_Run.Merge(m, src)
}
func (m *DeployDetectionResponse_Run) XXX_Size() int {
	return m.Size()
}
func (m *DeployDetectionResponse_Run) XXX_DiscardUnknown() {
	xxx_messageInfo_DeployDetectionResponse_Run.DiscardUnknown(m)
}

var xxx_messageInfo_DeployDetectionResponse_Run proto.InternalMessageInfo

func (m *DeployDetectionResponse_Run) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DeployDetectionResponse_Run) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *DeployDetectionResponse_Run) GetAlerts() []*storage.Alert {
	if m != nil {
		return m.Alerts
	}
	return nil
}

func (m *DeployDetectionResponse_Run) MessageClone() proto.Message {
	return m.Clone()
}
func (m *DeployDetectionResponse_Run) Clone() *DeployDetectionResponse_Run {
	if m == nil {
		return nil
	}
	cloned := new(DeployDetectionResponse_Run)
	*cloned = *m

	if m.Alerts != nil {
		cloned.Alerts = make([]*storage.Alert, len(m.Alerts))
		for idx, v := range m.Alerts {
			cloned.Alerts[idx] = v.Clone()
		}
	}
	return cloned
}

func init() {
	proto.RegisterType((*BuildDetectionRequest)(nil), "v1.BuildDetectionRequest")
	proto.RegisterType((*BuildDetectionResponse)(nil), "v1.BuildDetectionResponse")
	proto.RegisterType((*DeployDetectionRequest)(nil), "v1.DeployDetectionRequest")
	proto.RegisterType((*DeployYAMLDetectionRequest)(nil), "v1.DeployYAMLDetectionRequest")
	proto.RegisterType((*DeployDetectionResponse)(nil), "v1.DeployDetectionResponse")
	proto.RegisterType((*DeployDetectionResponse_Run)(nil), "v1.DeployDetectionResponse.Run")
}

func init() { proto.RegisterFile("api/v1/detection_service.proto", fileDescriptor_19377923b2f3baac) }

var fileDescriptor_19377923b2f3baac = []byte{
	// 661 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x54, 0xcd, 0x6e, 0xd3, 0x4a,
	0x18, 0x8d, 0x93, 0xb4, 0xaa, 0xa7, 0xd2, 0x6d, 0x3a, 0xbd, 0x4d, 0x7d, 0xdd, 0xde, 0x34, 0x78,
	0x81, 0x42, 0x11, 0x36, 0x69, 0xc5, 0xa6, 0x2b, 0xfa, 0x03, 0x6a, 0x25, 0x5a, 0xa4, 0x01, 0x24,
	0x60, 0x63, 0x4d, 0xed, 0xaf, 0xd1, 0x08, 0x7b, 0xc6, 0xd8, 0xe3, 0xa8, 0x61, 0x09, 0x8f, 0xc0,
	0x86, 0x17, 0xe0, 0x25, 0x78, 0x02, 0x96, 0x48, 0x2c, 0xd8, 0x56, 0x85, 0x07, 0x41, 0x33, 0x76,
	0xd2, 0xd0, 0x84, 0x2e, 0x90, 0xd8, 0x8d, 0xce, 0x39, 0x9a, 0x33, 0xdf, 0xf9, 0x8e, 0x8d, 0x5a,
	0x34, 0x61, 0x5e, 0xbf, 0xeb, 0x85, 0x20, 0x21, 0x90, 0x4c, 0x70, 0x3f, 0x83, 0xb4, 0xcf, 0x02,
	0x70, 0x93, 0x54, 0x48, 0x81, 0xab, 0xfd, 0xae, 0xbd, 0xd6, 0x13, 0xa2, 0x17, 0x81, 0xa7, 0xa4,
	0x94, 0x73, 0x21, 0xa9, 0x12, 0x66, 0x85, 0xc2, 0x5e, 0xca, 0xa4, 0x48, 0x69, 0x0f, 0x3c, 0x1a,
	0x41, 0x2a, 0x4b, 0xd0, 0x1a, 0x82, 0x21, 0x24, 0x91, 0x18, 0xc4, 0xc0, 0x4b, 0xc6, 0x79, 0x57,
	0x45, 0xcb, 0xbb, 0x39, 0x8b, 0xc2, 0xfd, 0xa1, 0x23, 0x81, 0xd7, 0x39, 0x64, 0x12, 0x7b, 0x68,
	0x86, 0xc5, 0xb4, 0x07, 0x96, 0xd1, 0x36, 0x3a, 0xf3, 0x9b, 0x2b, 0x6e, 0x79, 0x87, 0xbb, 0x27,
	0xb8, 0xa4, 0x8c, 0x43, 0x7a, 0xa8, 0xe8, 0x83, 0x0a, 0x29, 0x74, 0x78, 0x1d, 0x21, 0x7d, 0xf0,
	0x39, 0x8d, 0xc1, 0xaa, 0xb5, 0x8d, 0x8e, 0x79, 0x50, 0x21, 0xa6, 0xc6, 0x8e, 0x69, 0x0c, 0xf8,
	0x2e, 0xfa, 0x97, 0x0b, 0x1f, 0xce, 0x24, 0xa4, 0x9c, 0x46, 0x7e, 0x0c, 0x92, 0x86, 0x54, 0x52,
	0xab, 0xda, 0x36, 0x3a, 0x73, 0x04, 0x73, 0xf1, 0xa0, 0xa4, 0x8e, 0x4a, 0x06, 0xdf, 0x41, 0x38,
	0x03, 0x1e, 0xfa, 0x5c, 0x48, 0x76, 0xca, 0x82, 0x62, 0x50, 0xab, 0xae, 0xf5, 0x8b, 0x8a, 0x39,
	0x1e, 0x27, 0xf0, 0x6d, 0xb4, 0x98, 0x88, 0x88, 0x05, 0x03, 0x3f, 0xa0, 0x12, 0x7a, 0x22, 0x65,
	0x90, 0x59, 0x33, 0xed, 0x5a, 0xc7, 0x24, 0x8d, 0x82, 0xd8, 0x1b, 0xe1, 0xbb, 0x08, 0xcd, 0x11,
	0xc8, 0x44, 0x9e, 0x06, 0xe0, 0xdc, 0x47, 0xcd, 0xab, 0x21, 0x64, 0x89, 0xe0, 0x19, 0xe0, 0x9b,
	0x68, 0x56, 0x07, 0x99, 0x59, 0x46, 0xbb, 0xd6, 0x99, 0xdf, 0xfc, 0x67, 0x14, 0xc3, 0x8e, 0x82,
	0x49, 0xc9, 0x3a, 0xdf, 0x0c, 0xd4, 0xdc, 0xd7, 0xe1, 0x4e, 0x04, 0x79, 0x0f, 0xa1, 0xcb, 0xd8,
	0xcb, 0x34, 0x97, 0x46, 0xd7, 0xec, 0x8f, 0xa8, 0x83, 0x0a, 0x19, 0x13, 0xfe, 0x41, 0x5a, 0xb7,
	0x50, 0x03, 0xf8, 0xa9, 0x48, 0x03, 0x50, 0x17, 0xf8, 0x82, 0x47, 0x03, 0xbd, 0x86, 0x39, 0xb2,
	0x30, 0x86, 0x3f, 0xe6, 0xd1, 0x00, 0xff, 0x8f, 0x50, 0x10, 0xe5, 0x99, 0x84, 0xd4, 0x67, 0xa1,
	0x0e, 0xd4, 0x24, 0x66, 0x89, 0x1c, 0x86, 0xbf, 0x64, 0xf3, 0xc9, 0x40, 0x76, 0xf1, 0xc8, 0x17,
	0x3b, 0x47, 0x8f, 0x26, 0xa6, 0xc3, 0xa8, 0x3e, 0xa0, 0x71, 0xa4, 0xe7, 0x32, 0x89, 0x3e, 0xff,
	0xdd, 0xa7, 0x4f, 0x5d, 0x72, 0x7d, 0xfa, 0x92, 0x9d, 0x8f, 0x06, 0x5a, 0x99, 0x58, 0x4b, 0xb9,
	0xda, 0x2d, 0x54, 0x4f, 0x73, 0x3e, 0x5c, 0xec, 0xba, 0xdb, 0xef, 0xba, 0xbf, 0x91, 0xba, 0x24,
	0xe7, 0x44, 0x8b, 0xed, 0x67, 0xa8, 0x46, 0x72, 0xae, 0xa6, 0xd6, 0x2d, 0x2f, 0xa7, 0x56, 0x67,
	0x85, 0xc9, 0x41, 0x02, 0x7a, 0x4a, 0x93, 0xe8, 0xf3, 0x58, 0x7d, 0x6a, 0xd7, 0xd5, 0x67, 0xf3,
	0xbc, 0x8a, 0x1a, 0x23, 0xdb, 0x27, 0xc5, 0x27, 0x8f, 0x01, 0x2d, 0x14, 0x98, 0xee, 0xe6, 0x53,
	0x16, 0x03, 0xfe, 0x4f, 0xbd, 0x72, 0xea, 0xf7, 0x6a, 0xdb, 0xd3, 0xa8, 0xe2, 0xfd, 0xce, 0xea,
	0xdb, 0xaf, 0x3f, 0xde, 0x57, 0x97, 0x9d, 0xc6, 0xe5, 0xbf, 0xc5, 0x3b, 0x51, 0xd2, 0x6d, 0x63,
	0x03, 0xb3, 0xa1, 0x75, 0x31, 0xbd, 0xf6, 0xb1, 0xa7, 0xa6, 0x51, 0x18, 0xad, 0x5e, 0x93, 0x94,
	0xb3, 0xa6, 0x9d, 0x9a, 0xce, 0xe2, 0x98, 0x53, 0x51, 0x6a, 0x65, 0xf5, 0x06, 0x59, 0x57, 0xad,
	0x1e, 0xa6, 0x22, 0x56, 0xc5, 0xc2, 0xad, 0xcb, 0x6b, 0xa7, 0x15, 0xed, 0x7a, 0xdb, 0x1b, 0xda,
	0x76, 0xd5, 0x69, 0x4e, 0xd8, 0x7a, 0xaa, 0x91, 0xdb, 0xc6, 0xc6, 0xae, 0xfb, 0xf9, 0xa2, 0x65,
	0x7c, 0xb9, 0x68, 0x19, 0xe7, 0x17, 0x2d, 0xe3, 0xc3, 0xf7, 0x56, 0x05, 0x59, 0x4c, 0xb8, 0x99,
	0xa4, 0xc1, 0xab, 0x54, 0x9c, 0x15, 0xbf, 0x43, 0x97, 0x26, 0xcc, 0xed, 0x77, 0x5f, 0x56, 0xfb,
	0xdd, 0xe7, 0x95, 0x93, 0x59, 0x8d, 0x6d, 0xfd, 0x0c, 0x00, 0x00, 0xff, 0xff, 0xb9, 0x57, 0xae,
	0xf2, 0x95, 0x05, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DetectionServiceClient is the client API for DetectionService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConnInterface.NewStream.
type DetectionServiceClient interface {
	// DetectBuildTime checks if any images violate build time policies.
	DetectBuildTime(ctx context.Context, in *BuildDetectionRequest, opts ...grpc.CallOption) (*BuildDetectionResponse, error)
	// DetectDeployTime checks if any deployments violate deploy time policies.
	DetectDeployTime(ctx context.Context, in *DeployDetectionRequest, opts ...grpc.CallOption) (*DeployDetectionResponse, error)
	// DetectDeployTimeFromYAML checks if the given deployment yaml violates any deploy time policies.
	DetectDeployTimeFromYAML(ctx context.Context, in *DeployYAMLDetectionRequest, opts ...grpc.CallOption) (*DeployDetectionResponse, error)
}

type detectionServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDetectionServiceClient(cc grpc.ClientConnInterface) DetectionServiceClient {
	return &detectionServiceClient{cc}
}

func (c *detectionServiceClient) DetectBuildTime(ctx context.Context, in *BuildDetectionRequest, opts ...grpc.CallOption) (*BuildDetectionResponse, error) {
	out := new(BuildDetectionResponse)
	err := c.cc.Invoke(ctx, "/v1.DetectionService/DetectBuildTime", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *detectionServiceClient) DetectDeployTime(ctx context.Context, in *DeployDetectionRequest, opts ...grpc.CallOption) (*DeployDetectionResponse, error) {
	out := new(DeployDetectionResponse)
	err := c.cc.Invoke(ctx, "/v1.DetectionService/DetectDeployTime", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *detectionServiceClient) DetectDeployTimeFromYAML(ctx context.Context, in *DeployYAMLDetectionRequest, opts ...grpc.CallOption) (*DeployDetectionResponse, error) {
	out := new(DeployDetectionResponse)
	err := c.cc.Invoke(ctx, "/v1.DetectionService/DetectDeployTimeFromYAML", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DetectionServiceServer is the server API for DetectionService service.
type DetectionServiceServer interface {
	// DetectBuildTime checks if any images violate build time policies.
	DetectBuildTime(context.Context, *BuildDetectionRequest) (*BuildDetectionResponse, error)
	// DetectDeployTime checks if any deployments violate deploy time policies.
	DetectDeployTime(context.Context, *DeployDetectionRequest) (*DeployDetectionResponse, error)
	// DetectDeployTimeFromYAML checks if the given deployment yaml violates any deploy time policies.
	DetectDeployTimeFromYAML(context.Context, *DeployYAMLDetectionRequest) (*DeployDetectionResponse, error)
}

// UnimplementedDetectionServiceServer can be embedded to have forward compatible implementations.
type UnimplementedDetectionServiceServer struct {
}

func (*UnimplementedDetectionServiceServer) DetectBuildTime(ctx context.Context, req *BuildDetectionRequest) (*BuildDetectionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DetectBuildTime not implemented")
}
func (*UnimplementedDetectionServiceServer) DetectDeployTime(ctx context.Context, req *DeployDetectionRequest) (*DeployDetectionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DetectDeployTime not implemented")
}
func (*UnimplementedDetectionServiceServer) DetectDeployTimeFromYAML(ctx context.Context, req *DeployYAMLDetectionRequest) (*DeployDetectionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DetectDeployTimeFromYAML not implemented")
}

func RegisterDetectionServiceServer(s *grpc.Server, srv DetectionServiceServer) {
	s.RegisterService(&_DetectionService_serviceDesc, srv)
}

func _DetectionService_DetectBuildTime_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BuildDetectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DetectionServiceServer).DetectBuildTime(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.DetectionService/DetectBuildTime",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DetectionServiceServer).DetectBuildTime(ctx, req.(*BuildDetectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DetectionService_DetectDeployTime_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeployDetectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DetectionServiceServer).DetectDeployTime(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.DetectionService/DetectDeployTime",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DetectionServiceServer).DetectDeployTime(ctx, req.(*DeployDetectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DetectionService_DetectDeployTimeFromYAML_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeployYAMLDetectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DetectionServiceServer).DetectDeployTimeFromYAML(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.DetectionService/DetectDeployTimeFromYAML",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DetectionServiceServer).DetectDeployTimeFromYAML(ctx, req.(*DeployYAMLDetectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DetectionService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1.DetectionService",
	HandlerType: (*DetectionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "DetectBuildTime",
			Handler:    _DetectionService_DetectBuildTime_Handler,
		},
		{
			MethodName: "DetectDeployTime",
			Handler:    _DetectionService_DetectDeployTime_Handler,
		},
		{
			MethodName: "DetectDeployTimeFromYAML",
			Handler:    _DetectionService_DetectDeployTimeFromYAML_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/v1/detection_service.proto",
}

func (m *BuildDetectionRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BuildDetectionRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *BuildDetectionRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.PolicyCategories) > 0 {
		for iNdEx := len(m.PolicyCategories) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.PolicyCategories[iNdEx])
			copy(dAtA[i:], m.PolicyCategories[iNdEx])
			i = encodeVarintDetectionService(dAtA, i, uint64(len(m.PolicyCategories[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.SendNotifications {
		i--
		if m.SendNotifications {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.Resource != nil {
		{
			size := m.Resource.Size()
			i -= size
			if _, err := m.Resource.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.NoExternalMetadata {
		i--
		if m.NoExternalMetadata {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	return len(dAtA) - i, nil
}

func (m *BuildDetectionRequest_Image) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *BuildDetectionRequest_Image) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Image != nil {
		{
			size, err := m.Image.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDetectionService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *BuildDetectionRequest_ImageName) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *BuildDetectionRequest_ImageName) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.ImageName)
	copy(dAtA[i:], m.ImageName)
	i = encodeVarintDetectionService(dAtA, i, uint64(len(m.ImageName)))
	i--
	dAtA[i] = 0x1a
	return len(dAtA) - i, nil
}
func (m *BuildDetectionResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BuildDetectionResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *BuildDetectionResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Alerts) > 0 {
		for iNdEx := len(m.Alerts) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Alerts[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintDetectionService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *DeployDetectionRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeployDetectionRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeployDetectionRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintDetectionService(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0x22
	}
	if m.EnforcementOnly {
		i--
		if m.EnforcementOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.NoExternalMetadata {
		i--
		if m.NoExternalMetadata {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if m.Resource != nil {
		{
			size := m.Resource.Size()
			i -= size
			if _, err := m.Resource.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *DeployDetectionRequest_Deployment) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeployDetectionRequest_Deployment) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Deployment != nil {
		{
			size, err := m.Deployment.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDetectionService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *DeployYAMLDetectionRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeployYAMLDetectionRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeployYAMLDetectionRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.PolicyCategories) > 0 {
		for iNdEx := len(m.PolicyCategories) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.PolicyCategories[iNdEx])
			copy(dAtA[i:], m.PolicyCategories[iNdEx])
			i = encodeVarintDetectionService(dAtA, i, uint64(len(m.PolicyCategories[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if m.EnforcementOnly {
		i--
		if m.EnforcementOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.NoExternalMetadata {
		i--
		if m.NoExternalMetadata {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.Yaml) > 0 {
		i -= len(m.Yaml)
		copy(dAtA[i:], m.Yaml)
		i = encodeVarintDetectionService(dAtA, i, uint64(len(m.Yaml)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DeployDetectionResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeployDetectionResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeployDetectionResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Runs) > 0 {
		for iNdEx := len(m.Runs) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Runs[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintDetectionService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *DeployDetectionResponse_Run) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeployDetectionResponse_Run) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeployDetectionResponse_Run) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Alerts) > 0 {
		for iNdEx := len(m.Alerts) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Alerts[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintDetectionService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintDetectionService(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintDetectionService(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintDetectionService(dAtA []byte, offset int, v uint64) int {
	offset -= sovDetectionService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *BuildDetectionRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Resource != nil {
		n += m.Resource.Size()
	}
	if m.NoExternalMetadata {
		n += 2
	}
	if m.SendNotifications {
		n += 2
	}
	if len(m.PolicyCategories) > 0 {
		for _, s := range m.PolicyCategories {
			l = len(s)
			n += 1 + l + sovDetectionService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *BuildDetectionRequest_Image) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Image != nil {
		l = m.Image.Size()
		n += 1 + l + sovDetectionService(uint64(l))
	}
	return n
}
func (m *BuildDetectionRequest_ImageName) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ImageName)
	n += 1 + l + sovDetectionService(uint64(l))
	return n
}
func (m *BuildDetectionResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Alerts) > 0 {
		for _, e := range m.Alerts {
			l = e.Size()
			n += 1 + l + sovDetectionService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeployDetectionRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Resource != nil {
		n += m.Resource.Size()
	}
	if m.NoExternalMetadata {
		n += 2
	}
	if m.EnforcementOnly {
		n += 2
	}
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovDetectionService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeployDetectionRequest_Deployment) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Deployment != nil {
		l = m.Deployment.Size()
		n += 1 + l + sovDetectionService(uint64(l))
	}
	return n
}
func (m *DeployYAMLDetectionRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Yaml)
	if l > 0 {
		n += 1 + l + sovDetectionService(uint64(l))
	}
	if m.NoExternalMetadata {
		n += 2
	}
	if m.EnforcementOnly {
		n += 2
	}
	if len(m.PolicyCategories) > 0 {
		for _, s := range m.PolicyCategories {
			l = len(s)
			n += 1 + l + sovDetectionService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeployDetectionResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Runs) > 0 {
		for _, e := range m.Runs {
			l = e.Size()
			n += 1 + l + sovDetectionService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeployDetectionResponse_Run) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovDetectionService(uint64(l))
	}
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovDetectionService(uint64(l))
	}
	if len(m.Alerts) > 0 {
		for _, e := range m.Alerts {
			l = e.Size()
			n += 1 + l + sovDetectionService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovDetectionService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozDetectionService(x uint64) (n int) {
	return sovDetectionService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *BuildDetectionRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDetectionService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BuildDetectionRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BuildDetectionRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Image", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDetectionService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDetectionService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDetectionService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &storage.ContainerImage{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &BuildDetectionRequest_Image{v}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NoExternalMetadata", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDetectionService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NoExternalMetadata = bool(v != 0)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ImageName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDetectionService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDetectionService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDetectionService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Resource = &BuildDetectionRequest_ImageName{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SendNotifications", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDetectionService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SendNotifications = bool(v != 0)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PolicyCategories", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDetectionService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDetectionService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDetectionService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PolicyCategories = append(m.PolicyCategories, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDetectionService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDetectionService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BuildDetectionResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDetectionService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BuildDetectionResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BuildDetectionResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Alerts", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDetectionService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDetectionService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDetectionService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Alerts = append(m.Alerts, &storage.Alert{})
			if err := m.Alerts[len(m.Alerts)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDetectionService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDetectionService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeployDetectionRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDetectionService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeployDetectionRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeployDetectionRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Deployment", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDetectionService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDetectionService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDetectionService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &storage.Deployment{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Resource = &DeployDetectionRequest_Deployment{v}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NoExternalMetadata", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDetectionService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NoExternalMetadata = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnforcementOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDetectionService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.EnforcementOnly = bool(v != 0)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDetectionService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDetectionService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDetectionService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDetectionService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDetectionService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeployYAMLDetectionRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDetectionService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeployYAMLDetectionRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeployYAMLDetectionRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Yaml", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDetectionService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDetectionService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDetectionService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Yaml = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NoExternalMetadata", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDetectionService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NoExternalMetadata = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnforcementOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDetectionService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.EnforcementOnly = bool(v != 0)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PolicyCategories", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDetectionService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDetectionService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDetectionService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PolicyCategories = append(m.PolicyCategories, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDetectionService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDetectionService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeployDetectionResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDetectionService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeployDetectionResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeployDetectionResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Runs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDetectionService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDetectionService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDetectionService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Runs = append(m.Runs, &DeployDetectionResponse_Run{})
			if err := m.Runs[len(m.Runs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDetectionService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDetectionService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeployDetectionResponse_Run) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDetectionService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Run: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Run: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDetectionService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDetectionService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDetectionService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDetectionService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDetectionService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDetectionService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Alerts", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDetectionService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDetectionService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDetectionService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Alerts = append(m.Alerts, &storage.Alert{})
			if err := m.Alerts[len(m.Alerts)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDetectionService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDetectionService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipDetectionService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowDetectionService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowDetectionService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowDetectionService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthDetectionService
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupDetectionService
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthDetectionService
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthDetectionService        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowDetectionService          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupDetectionService = fmt.Errorf("proto: unexpected end of group")
)
