// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api/v1/group_service.proto

package v1

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	storage "github.com/stackrox/rox/generated/storage"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type GetGroupsRequest struct {
	// Types that are valid to be assigned to AuthProviderIdOpt:
	//	*GetGroupsRequest_AuthProviderId
	AuthProviderIdOpt isGetGroupsRequest_AuthProviderIdOpt `protobuf_oneof:"auth_provider_id_opt"`
	// Types that are valid to be assigned to KeyOpt:
	//	*GetGroupsRequest_Key
	KeyOpt isGetGroupsRequest_KeyOpt `protobuf_oneof:"key_opt"`
	// Types that are valid to be assigned to ValueOpt:
	//	*GetGroupsRequest_Value
	ValueOpt             isGetGroupsRequest_ValueOpt `protobuf_oneof:"value_opt"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *GetGroupsRequest) Reset()         { *m = GetGroupsRequest{} }
func (m *GetGroupsRequest) String() string { return proto.CompactTextString(m) }
func (*GetGroupsRequest) ProtoMessage()    {}
func (*GetGroupsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f3629ea30e241992, []int{0}
}
func (m *GetGroupsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetGroupsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetGroupsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetGroupsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetGroupsRequest.Merge(m, src)
}
func (m *GetGroupsRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetGroupsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetGroupsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetGroupsRequest proto.InternalMessageInfo

type isGetGroupsRequest_AuthProviderIdOpt interface {
	isGetGroupsRequest_AuthProviderIdOpt()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isGetGroupsRequest_AuthProviderIdOpt
}
type isGetGroupsRequest_KeyOpt interface {
	isGetGroupsRequest_KeyOpt()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isGetGroupsRequest_KeyOpt
}
type isGetGroupsRequest_ValueOpt interface {
	isGetGroupsRequest_ValueOpt()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isGetGroupsRequest_ValueOpt
}

type GetGroupsRequest_AuthProviderId struct {
	AuthProviderId string `protobuf:"bytes,1,opt,name=auth_provider_id,json=authProviderId,proto3,oneof" json:"auth_provider_id,omitempty"`
}
type GetGroupsRequest_Key struct {
	Key string `protobuf:"bytes,2,opt,name=key,proto3,oneof" json:"key,omitempty"`
}
type GetGroupsRequest_Value struct {
	Value string `protobuf:"bytes,3,opt,name=value,proto3,oneof" json:"value,omitempty"`
}

func (*GetGroupsRequest_AuthProviderId) isGetGroupsRequest_AuthProviderIdOpt() {}
func (m *GetGroupsRequest_AuthProviderId) Clone() isGetGroupsRequest_AuthProviderIdOpt {
	if m == nil {
		return nil
	}
	cloned := new(GetGroupsRequest_AuthProviderId)
	*cloned = *m

	return cloned
}
func (*GetGroupsRequest_Key) isGetGroupsRequest_KeyOpt() {}
func (m *GetGroupsRequest_Key) Clone() isGetGroupsRequest_KeyOpt {
	if m == nil {
		return nil
	}
	cloned := new(GetGroupsRequest_Key)
	*cloned = *m

	return cloned
}
func (*GetGroupsRequest_Value) isGetGroupsRequest_ValueOpt() {}
func (m *GetGroupsRequest_Value) Clone() isGetGroupsRequest_ValueOpt {
	if m == nil {
		return nil
	}
	cloned := new(GetGroupsRequest_Value)
	*cloned = *m

	return cloned
}

func (m *GetGroupsRequest) GetAuthProviderIdOpt() isGetGroupsRequest_AuthProviderIdOpt {
	if m != nil {
		return m.AuthProviderIdOpt
	}
	return nil
}
func (m *GetGroupsRequest) GetKeyOpt() isGetGroupsRequest_KeyOpt {
	if m != nil {
		return m.KeyOpt
	}
	return nil
}
func (m *GetGroupsRequest) GetValueOpt() isGetGroupsRequest_ValueOpt {
	if m != nil {
		return m.ValueOpt
	}
	return nil
}

func (m *GetGroupsRequest) GetAuthProviderId() string {
	if x, ok := m.GetAuthProviderIdOpt().(*GetGroupsRequest_AuthProviderId); ok {
		return x.AuthProviderId
	}
	return ""
}

func (m *GetGroupsRequest) GetKey() string {
	if x, ok := m.GetKeyOpt().(*GetGroupsRequest_Key); ok {
		return x.Key
	}
	return ""
}

func (m *GetGroupsRequest) GetValue() string {
	if x, ok := m.GetValueOpt().(*GetGroupsRequest_Value); ok {
		return x.Value
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*GetGroupsRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*GetGroupsRequest_AuthProviderId)(nil),
		(*GetGroupsRequest_Key)(nil),
		(*GetGroupsRequest_Value)(nil),
	}
}

func (m *GetGroupsRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetGroupsRequest) Clone() *GetGroupsRequest {
	if m == nil {
		return nil
	}
	cloned := new(GetGroupsRequest)
	*cloned = *m

	if m.AuthProviderIdOpt != nil {
		cloned.AuthProviderIdOpt = m.AuthProviderIdOpt.Clone()
	}
	if m.KeyOpt != nil {
		cloned.KeyOpt = m.KeyOpt.Clone()
	}
	if m.ValueOpt != nil {
		cloned.ValueOpt = m.ValueOpt.Clone()
	}
	return cloned
}

// API for updating Groups and getting users.
// Next Available Tag: 2
type GetGroupsResponse struct {
	Groups               []*storage.Group `protobuf:"bytes,1,rep,name=groups,proto3" json:"groups,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *GetGroupsResponse) Reset()         { *m = GetGroupsResponse{} }
func (m *GetGroupsResponse) String() string { return proto.CompactTextString(m) }
func (*GetGroupsResponse) ProtoMessage()    {}
func (*GetGroupsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f3629ea30e241992, []int{1}
}
func (m *GetGroupsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetGroupsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetGroupsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetGroupsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetGroupsResponse.Merge(m, src)
}
func (m *GetGroupsResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetGroupsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetGroupsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetGroupsResponse proto.InternalMessageInfo

func (m *GetGroupsResponse) GetGroups() []*storage.Group {
	if m != nil {
		return m.Groups
	}
	return nil
}

func (m *GetGroupsResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetGroupsResponse) Clone() *GetGroupsResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetGroupsResponse)
	*cloned = *m

	if m.Groups != nil {
		cloned.Groups = make([]*storage.Group, len(m.Groups))
		for idx, v := range m.Groups {
			cloned.Groups[idx] = v.Clone()
		}
	}
	return cloned
}

// GroupBatchUpdateRequest is an in transaction batch update to the groups present.
// Next Available Tag: 3
type GroupBatchUpdateRequest struct {
	// Previous groups are the groups expected to be present in the store.
	// Performs a diff on the GroupProperties present in previous_groups and required_groups:
	// 1) if in previous_groups but not required_groups, it gets deleted.
	// 2) if in previous_groups and required_groups, it gets updated.
	// 3) if not in previous_groups but in required_groups, it gets added.
	PreviousGroups []*storage.Group `protobuf:"bytes,1,rep,name=previous_groups,json=previousGroups,proto3" json:"previous_groups,omitempty"`
	// Required groups are the groups we want to mutate the previous groups into.
	RequiredGroups       []*storage.Group `protobuf:"bytes,2,rep,name=required_groups,json=requiredGroups,proto3" json:"required_groups,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *GroupBatchUpdateRequest) Reset()         { *m = GroupBatchUpdateRequest{} }
func (m *GroupBatchUpdateRequest) String() string { return proto.CompactTextString(m) }
func (*GroupBatchUpdateRequest) ProtoMessage()    {}
func (*GroupBatchUpdateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f3629ea30e241992, []int{2}
}
func (m *GroupBatchUpdateRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GroupBatchUpdateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GroupBatchUpdateRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GroupBatchUpdateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupBatchUpdateRequest.Merge(m, src)
}
func (m *GroupBatchUpdateRequest) XXX_Size() int {
	return m.Size()
}
func (m *GroupBatchUpdateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupBatchUpdateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GroupBatchUpdateRequest proto.InternalMessageInfo

func (m *GroupBatchUpdateRequest) GetPreviousGroups() []*storage.Group {
	if m != nil {
		return m.PreviousGroups
	}
	return nil
}

func (m *GroupBatchUpdateRequest) GetRequiredGroups() []*storage.Group {
	if m != nil {
		return m.RequiredGroups
	}
	return nil
}

func (m *GroupBatchUpdateRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GroupBatchUpdateRequest) Clone() *GroupBatchUpdateRequest {
	if m == nil {
		return nil
	}
	cloned := new(GroupBatchUpdateRequest)
	*cloned = *m

	if m.PreviousGroups != nil {
		cloned.PreviousGroups = make([]*storage.Group, len(m.PreviousGroups))
		for idx, v := range m.PreviousGroups {
			cloned.PreviousGroups[idx] = v.Clone()
		}
	}
	if m.RequiredGroups != nil {
		cloned.RequiredGroups = make([]*storage.Group, len(m.RequiredGroups))
		for idx, v := range m.RequiredGroups {
			cloned.RequiredGroups[idx] = v.Clone()
		}
	}
	return cloned
}

func init() {
	proto.RegisterType((*GetGroupsRequest)(nil), "v1.GetGroupsRequest")
	proto.RegisterType((*GetGroupsResponse)(nil), "v1.GetGroupsResponse")
	proto.RegisterType((*GroupBatchUpdateRequest)(nil), "v1.GroupBatchUpdateRequest")
}

func init() { proto.RegisterFile("api/v1/group_service.proto", fileDescriptor_f3629ea30e241992) }

var fileDescriptor_f3629ea30e241992 = []byte{
	// 506 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x93, 0x4f, 0x8b, 0x13, 0x4d,
	0x10, 0xc6, 0xd3, 0x13, 0xde, 0x7d, 0x9d, 0x9a, 0x25, 0xd9, 0x6d, 0xb3, 0xeb, 0x30, 0x4a, 0x58,
	0xe6, 0x20, 0x4b, 0x0e, 0x13, 0xb2, 0x1e, 0x04, 0x3d, 0x08, 0xf1, 0x4f, 0x14, 0x3c, 0xac, 0x11,
	0x41, 0xbc, 0x84, 0xde, 0xa4, 0xc8, 0x36, 0x89, 0xe9, 0xde, 0xee, 0x9e, 0xc1, 0x5c, 0xbd, 0x7a,
	0xf4, 0x22, 0x7e, 0x1c, 0x4f, 0x1e, 0x05, 0xbf, 0x80, 0x44, 0x3f, 0x88, 0x4c, 0xf7, 0x4c, 0x1c,
	0x87, 0x55, 0xbc, 0x4d, 0x3f, 0xf5, 0xd4, 0x2f, 0x4f, 0x55, 0x77, 0x20, 0x62, 0x92, 0xf7, 0xb3,
	0x41, 0x7f, 0xae, 0x44, 0x2a, 0x27, 0x1a, 0x55, 0xc6, 0xa7, 0x98, 0x48, 0x25, 0x8c, 0xa0, 0x5e,
	0x36, 0x88, 0x6e, 0xcc, 0x85, 0x98, 0x2f, 0xb1, 0x9f, 0xdb, 0xd8, 0x6a, 0x25, 0x0c, 0x33, 0x5c,
	0xac, 0xb4, 0x73, 0x44, 0xb4, 0xe8, 0xc6, 0xd7, 0xd2, 0xac, 0x0b, 0xed, 0xaa, 0x36, 0x42, 0xb1,
	0x39, 0x3a, 0xa4, 0x13, 0xe3, 0x8f, 0x04, 0xf6, 0x46, 0x68, 0x46, 0xb9, 0xa4, 0xc7, 0x78, 0x91,
	0xa2, 0x36, 0xb4, 0x07, 0x7b, 0x2c, 0x35, 0xe7, 0x13, 0xa9, 0x44, 0xc6, 0x67, 0xa8, 0x26, 0x7c,
	0x16, 0x92, 0x23, 0x72, 0xec, 0x3f, 0x6e, 0x8c, 0x5b, 0x79, 0xe5, 0xb4, 0x28, 0x3c, 0x99, 0x51,
	0x0a, 0xcd, 0x05, 0xae, 0x43, 0xcf, 0x96, 0xc9, 0x38, 0x3f, 0xd0, 0x43, 0xf8, 0x2f, 0x63, 0xcb,
	0x14, 0xc3, 0xa6, 0x55, 0xbd, 0xb1, 0x3b, 0x0e, 0x0f, 0xa1, 0x53, 0xe7, 0x4e, 0x84, 0x34, 0x43,
	0x1f, 0xfe, 0x5f, 0xe0, 0xda, 0x7e, 0x06, 0xe0, 0x5b, 0x6f, 0x7e, 0x88, 0xef, 0xc2, 0x7e, 0x25,
	0x9b, 0x96, 0x62, 0xa5, 0x91, 0xde, 0x84, 0x1d, 0x3b, 0x80, 0x0e, 0xc9, 0x51, 0xf3, 0x38, 0x38,
	0x69, 0x25, 0xc5, 0x5c, 0x89, 0x35, 0x8e, 0x8b, 0x6a, 0xfc, 0x8e, 0xc0, 0x35, 0xab, 0x0c, 0x99,
	0x99, 0x9e, 0xbf, 0x90, 0x33, 0x66, 0xb0, 0x1c, 0xf0, 0x36, 0xb4, 0xa5, 0xc2, 0x8c, 0x8b, 0x54,
	0x4f, 0xfe, 0x0a, 0x6b, 0x95, 0x36, 0x17, 0x22, 0x6f, 0x54, 0x78, 0x91, 0x72, 0x85, 0xb3, 0xb2,
	0xd1, 0xbb, 0xbc, 0xb1, 0xb4, 0xb9, 0xc6, 0x93, 0x4f, 0x4d, 0xd8, 0xb5, 0x9f, 0xcf, 0xdd, 0x4d,
	0xd2, 0xa7, 0xe0, 0x6f, 0x67, 0xa3, 0x9d, 0x24, 0x1b, 0x24, 0xf5, 0x6b, 0x88, 0x0e, 0x6a, 0xaa,
	0x5b, 0x40, 0x4c, 0xdf, 0x7e, 0xfd, 0xf1, 0xde, 0xdb, 0xa5, 0xb0, 0x7d, 0x1e, 0x9a, 0x8e, 0xe0,
	0x4a, 0x69, 0xa4, 0xe1, 0xef, 0x51, 0x4e, 0x95, 0x90, 0xa8, 0x0c, 0x47, 0x1d, 0xd5, 0x42, 0xc6,
	0xfb, 0x96, 0x14, 0x50, 0x7f, 0x4b, 0xa2, 0xcf, 0x20, 0xa8, 0xec, 0x8b, 0x5e, 0xb7, 0x11, 0x2e,
	0xdf, 0x62, 0xe4, 0xe7, 0xc5, 0x87, 0xf9, 0x0b, 0x8b, 0x23, 0x4b, 0xea, 0xc4, 0xed, 0x5f, 0x99,
	0xce, 0xf2, 0x86, 0x3b, 0xa4, 0x47, 0xef, 0x41, 0x70, 0x5f, 0x21, 0x33, 0xe8, 0xe2, 0xd5, 0x42,
	0x54, 0x29, 0x07, 0x96, 0xd2, 0x8e, 0x2b, 0x93, 0x15, 0x00, 0xf7, 0xc3, 0xff, 0x0a, 0x88, 0x6a,
	0x80, 0x47, 0x10, 0x3c, 0xc0, 0x25, 0x96, 0x80, 0x3f, 0x2f, 0xa8, 0x82, 0x2a, 0xb6, 0xdc, 0xab,
	0xa0, 0x86, 0xc9, 0xe7, 0x4d, 0x97, 0x7c, 0xd9, 0x74, 0xc9, 0xb7, 0x4d, 0x97, 0x7c, 0xf8, 0xde,
	0x6d, 0x40, 0xc8, 0x45, 0xa2, 0x0d, 0x9b, 0x2e, 0x94, 0x78, 0xe3, 0xfe, 0x51, 0x09, 0x93, 0x3c,
	0xc9, 0x06, 0xaf, 0xbc, 0x6c, 0xf0, 0xb2, 0x71, 0xb6, 0x63, 0xb5, 0x5b, 0x3f, 0x03, 0x00, 0x00,
	0xff, 0xff, 0x86, 0x06, 0xf5, 0x0b, 0xce, 0x03, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// GroupServiceClient is the client API for GroupService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConnInterface.NewStream.
type GroupServiceClient interface {
	GetGroups(ctx context.Context, in *GetGroupsRequest, opts ...grpc.CallOption) (*GetGroupsResponse, error)
	GetGroup(ctx context.Context, in *storage.GroupProperties, opts ...grpc.CallOption) (*storage.Group, error)
	BatchUpdate(ctx context.Context, in *GroupBatchUpdateRequest, opts ...grpc.CallOption) (*Empty, error)
	CreateGroup(ctx context.Context, in *storage.Group, opts ...grpc.CallOption) (*Empty, error)
	UpdateGroup(ctx context.Context, in *storage.Group, opts ...grpc.CallOption) (*Empty, error)
	DeleteGroup(ctx context.Context, in *storage.GroupProperties, opts ...grpc.CallOption) (*Empty, error)
}

type groupServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewGroupServiceClient(cc grpc.ClientConnInterface) GroupServiceClient {
	return &groupServiceClient{cc}
}

func (c *groupServiceClient) GetGroups(ctx context.Context, in *GetGroupsRequest, opts ...grpc.CallOption) (*GetGroupsResponse, error) {
	out := new(GetGroupsResponse)
	err := c.cc.Invoke(ctx, "/v1.GroupService/GetGroups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupServiceClient) GetGroup(ctx context.Context, in *storage.GroupProperties, opts ...grpc.CallOption) (*storage.Group, error) {
	out := new(storage.Group)
	err := c.cc.Invoke(ctx, "/v1.GroupService/GetGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupServiceClient) BatchUpdate(ctx context.Context, in *GroupBatchUpdateRequest, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.GroupService/BatchUpdate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupServiceClient) CreateGroup(ctx context.Context, in *storage.Group, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.GroupService/CreateGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupServiceClient) UpdateGroup(ctx context.Context, in *storage.Group, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.GroupService/UpdateGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupServiceClient) DeleteGroup(ctx context.Context, in *storage.GroupProperties, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.GroupService/DeleteGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// GroupServiceServer is the server API for GroupService service.
type GroupServiceServer interface {
	GetGroups(context.Context, *GetGroupsRequest) (*GetGroupsResponse, error)
	GetGroup(context.Context, *storage.GroupProperties) (*storage.Group, error)
	BatchUpdate(context.Context, *GroupBatchUpdateRequest) (*Empty, error)
	CreateGroup(context.Context, *storage.Group) (*Empty, error)
	UpdateGroup(context.Context, *storage.Group) (*Empty, error)
	DeleteGroup(context.Context, *storage.GroupProperties) (*Empty, error)
}

// UnimplementedGroupServiceServer can be embedded to have forward compatible implementations.
type UnimplementedGroupServiceServer struct {
}

func (*UnimplementedGroupServiceServer) GetGroups(ctx context.Context, req *GetGroupsRequest) (*GetGroupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGroups not implemented")
}
func (*UnimplementedGroupServiceServer) GetGroup(ctx context.Context, req *storage.GroupProperties) (*storage.Group, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGroup not implemented")
}
func (*UnimplementedGroupServiceServer) BatchUpdate(ctx context.Context, req *GroupBatchUpdateRequest) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchUpdate not implemented")
}
func (*UnimplementedGroupServiceServer) CreateGroup(ctx context.Context, req *storage.Group) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateGroup not implemented")
}
func (*UnimplementedGroupServiceServer) UpdateGroup(ctx context.Context, req *storage.Group) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateGroup not implemented")
}
func (*UnimplementedGroupServiceServer) DeleteGroup(ctx context.Context, req *storage.GroupProperties) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteGroup not implemented")
}

func RegisterGroupServiceServer(s *grpc.Server, srv GroupServiceServer) {
	s.RegisterService(&_GroupService_serviceDesc, srv)
}

func _GroupService_GetGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServiceServer).GetGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.GroupService/GetGroups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServiceServer).GetGroups(ctx, req.(*GetGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GroupService_GetGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(storage.GroupProperties)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServiceServer).GetGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.GroupService/GetGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServiceServer).GetGroup(ctx, req.(*storage.GroupProperties))
	}
	return interceptor(ctx, in, info, handler)
}

func _GroupService_BatchUpdate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GroupBatchUpdateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServiceServer).BatchUpdate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.GroupService/BatchUpdate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServiceServer).BatchUpdate(ctx, req.(*GroupBatchUpdateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GroupService_CreateGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(storage.Group)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServiceServer).CreateGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.GroupService/CreateGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServiceServer).CreateGroup(ctx, req.(*storage.Group))
	}
	return interceptor(ctx, in, info, handler)
}

func _GroupService_UpdateGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(storage.Group)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServiceServer).UpdateGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.GroupService/UpdateGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServiceServer).UpdateGroup(ctx, req.(*storage.Group))
	}
	return interceptor(ctx, in, info, handler)
}

func _GroupService_DeleteGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(storage.GroupProperties)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServiceServer).DeleteGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.GroupService/DeleteGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServiceServer).DeleteGroup(ctx, req.(*storage.GroupProperties))
	}
	return interceptor(ctx, in, info, handler)
}

var _GroupService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1.GroupService",
	HandlerType: (*GroupServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetGroups",
			Handler:    _GroupService_GetGroups_Handler,
		},
		{
			MethodName: "GetGroup",
			Handler:    _GroupService_GetGroup_Handler,
		},
		{
			MethodName: "BatchUpdate",
			Handler:    _GroupService_BatchUpdate_Handler,
		},
		{
			MethodName: "CreateGroup",
			Handler:    _GroupService_CreateGroup_Handler,
		},
		{
			MethodName: "UpdateGroup",
			Handler:    _GroupService_UpdateGroup_Handler,
		},
		{
			MethodName: "DeleteGroup",
			Handler:    _GroupService_DeleteGroup_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/v1/group_service.proto",
}

func (m *GetGroupsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetGroupsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetGroupsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ValueOpt != nil {
		{
			size := m.ValueOpt.Size()
			i -= size
			if _, err := m.ValueOpt.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.KeyOpt != nil {
		{
			size := m.KeyOpt.Size()
			i -= size
			if _, err := m.KeyOpt.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.AuthProviderIdOpt != nil {
		{
			size := m.AuthProviderIdOpt.Size()
			i -= size
			if _, err := m.AuthProviderIdOpt.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *GetGroupsRequest_AuthProviderId) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetGroupsRequest_AuthProviderId) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.AuthProviderId)
	copy(dAtA[i:], m.AuthProviderId)
	i = encodeVarintGroupService(dAtA, i, uint64(len(m.AuthProviderId)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}
func (m *GetGroupsRequest_Key) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetGroupsRequest_Key) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.Key)
	copy(dAtA[i:], m.Key)
	i = encodeVarintGroupService(dAtA, i, uint64(len(m.Key)))
	i--
	dAtA[i] = 0x12
	return len(dAtA) - i, nil
}
func (m *GetGroupsRequest_Value) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetGroupsRequest_Value) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.Value)
	copy(dAtA[i:], m.Value)
	i = encodeVarintGroupService(dAtA, i, uint64(len(m.Value)))
	i--
	dAtA[i] = 0x1a
	return len(dAtA) - i, nil
}
func (m *GetGroupsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetGroupsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetGroupsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Groups) > 0 {
		for iNdEx := len(m.Groups) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Groups[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGroupService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *GroupBatchUpdateRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GroupBatchUpdateRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GroupBatchUpdateRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.RequiredGroups) > 0 {
		for iNdEx := len(m.RequiredGroups) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.RequiredGroups[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGroupService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.PreviousGroups) > 0 {
		for iNdEx := len(m.PreviousGroups) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.PreviousGroups[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGroupService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func encodeVarintGroupService(dAtA []byte, offset int, v uint64) int {
	offset -= sovGroupService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *GetGroupsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AuthProviderIdOpt != nil {
		n += m.AuthProviderIdOpt.Size()
	}
	if m.KeyOpt != nil {
		n += m.KeyOpt.Size()
	}
	if m.ValueOpt != nil {
		n += m.ValueOpt.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetGroupsRequest_AuthProviderId) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.AuthProviderId)
	n += 1 + l + sovGroupService(uint64(l))
	return n
}
func (m *GetGroupsRequest_Key) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Key)
	n += 1 + l + sovGroupService(uint64(l))
	return n
}
func (m *GetGroupsRequest_Value) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Value)
	n += 1 + l + sovGroupService(uint64(l))
	return n
}
func (m *GetGroupsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Groups) > 0 {
		for _, e := range m.Groups {
			l = e.Size()
			n += 1 + l + sovGroupService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GroupBatchUpdateRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.PreviousGroups) > 0 {
		for _, e := range m.PreviousGroups {
			l = e.Size()
			n += 1 + l + sovGroupService(uint64(l))
		}
	}
	if len(m.RequiredGroups) > 0 {
		for _, e := range m.RequiredGroups {
			l = e.Size()
			n += 1 + l + sovGroupService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovGroupService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozGroupService(x uint64) (n int) {
	return sovGroupService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *GetGroupsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGroupService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetGroupsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetGroupsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AuthProviderId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGroupService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGroupService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGroupService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AuthProviderIdOpt = &GetGroupsRequest_AuthProviderId{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGroupService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGroupService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGroupService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.KeyOpt = &GetGroupsRequest_Key{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGroupService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGroupService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGroupService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ValueOpt = &GetGroupsRequest_Value{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGroupService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGroupService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetGroupsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGroupService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetGroupsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetGroupsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Groups", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGroupService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGroupService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGroupService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Groups = append(m.Groups, &storage.Group{})
			if err := m.Groups[len(m.Groups)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGroupService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGroupService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GroupBatchUpdateRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGroupService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GroupBatchUpdateRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GroupBatchUpdateRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PreviousGroups", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGroupService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGroupService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGroupService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PreviousGroups = append(m.PreviousGroups, &storage.Group{})
			if err := m.PreviousGroups[len(m.PreviousGroups)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequiredGroups", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGroupService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGroupService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGroupService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequiredGroups = append(m.RequiredGroups, &storage.Group{})
			if err := m.RequiredGroups[len(m.RequiredGroups)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGroupService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGroupService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipGroupService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowGroupService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGroupService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGroupService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthGroupService
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupGroupService
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthGroupService
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthGroupService        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowGroupService          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupGroupService = fmt.Errorf("proto: unexpected end of group")
)
