// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api/v1/image_integration_service.proto

package v1

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	storage "github.com/stackrox/rox/generated/storage"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type GetImageIntegrationsRequest struct {
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Cluster              string   `protobuf:"bytes,2,opt,name=cluster,proto3" json:"cluster,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetImageIntegrationsRequest) Reset()         { *m = GetImageIntegrationsRequest{} }
func (m *GetImageIntegrationsRequest) String() string { return proto.CompactTextString(m) }
func (*GetImageIntegrationsRequest) ProtoMessage()    {}
func (*GetImageIntegrationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_263887791ba1d8ff, []int{0}
}
func (m *GetImageIntegrationsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetImageIntegrationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetImageIntegrationsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetImageIntegrationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetImageIntegrationsRequest.Merge(m, src)
}
func (m *GetImageIntegrationsRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetImageIntegrationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetImageIntegrationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetImageIntegrationsRequest proto.InternalMessageInfo

func (m *GetImageIntegrationsRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetImageIntegrationsRequest) GetCluster() string {
	if m != nil {
		return m.Cluster
	}
	return ""
}

func (m *GetImageIntegrationsRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetImageIntegrationsRequest) Clone() *GetImageIntegrationsRequest {
	if m == nil {
		return nil
	}
	cloned := new(GetImageIntegrationsRequest)
	*cloned = *m

	return cloned
}

type GetImageIntegrationsResponse struct {
	Integrations         []*storage.ImageIntegration `protobuf:"bytes,1,rep,name=integrations,proto3" json:"integrations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *GetImageIntegrationsResponse) Reset()         { *m = GetImageIntegrationsResponse{} }
func (m *GetImageIntegrationsResponse) String() string { return proto.CompactTextString(m) }
func (*GetImageIntegrationsResponse) ProtoMessage()    {}
func (*GetImageIntegrationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_263887791ba1d8ff, []int{1}
}
func (m *GetImageIntegrationsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetImageIntegrationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetImageIntegrationsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetImageIntegrationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetImageIntegrationsResponse.Merge(m, src)
}
func (m *GetImageIntegrationsResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetImageIntegrationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetImageIntegrationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetImageIntegrationsResponse proto.InternalMessageInfo

func (m *GetImageIntegrationsResponse) GetIntegrations() []*storage.ImageIntegration {
	if m != nil {
		return m.Integrations
	}
	return nil
}

func (m *GetImageIntegrationsResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetImageIntegrationsResponse) Clone() *GetImageIntegrationsResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetImageIntegrationsResponse)
	*cloned = *m

	if m.Integrations != nil {
		cloned.Integrations = make([]*storage.ImageIntegration, len(m.Integrations))
		for idx, v := range m.Integrations {
			cloned.Integrations[idx] = v.Clone()
		}
	}
	return cloned
}

type UpdateImageIntegrationRequest struct {
	Config *storage.ImageIntegration `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// When false, use the stored credentials of an existing image integration given its ID.
	UpdatePassword       bool     `protobuf:"varint,2,opt,name=updatePassword,proto3" json:"updatePassword,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateImageIntegrationRequest) Reset()         { *m = UpdateImageIntegrationRequest{} }
func (m *UpdateImageIntegrationRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateImageIntegrationRequest) ProtoMessage()    {}
func (*UpdateImageIntegrationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_263887791ba1d8ff, []int{2}
}
func (m *UpdateImageIntegrationRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpdateImageIntegrationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UpdateImageIntegrationRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UpdateImageIntegrationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateImageIntegrationRequest.Merge(m, src)
}
func (m *UpdateImageIntegrationRequest) XXX_Size() int {
	return m.Size()
}
func (m *UpdateImageIntegrationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateImageIntegrationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateImageIntegrationRequest proto.InternalMessageInfo

func (m *UpdateImageIntegrationRequest) GetConfig() *storage.ImageIntegration {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *UpdateImageIntegrationRequest) GetUpdatePassword() bool {
	if m != nil {
		return m.UpdatePassword
	}
	return false
}

func (m *UpdateImageIntegrationRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *UpdateImageIntegrationRequest) Clone() *UpdateImageIntegrationRequest {
	if m == nil {
		return nil
	}
	cloned := new(UpdateImageIntegrationRequest)
	*cloned = *m

	cloned.Config = m.Config.Clone()
	return cloned
}

func init() {
	proto.RegisterType((*GetImageIntegrationsRequest)(nil), "v1.GetImageIntegrationsRequest")
	proto.RegisterType((*GetImageIntegrationsResponse)(nil), "v1.GetImageIntegrationsResponse")
	proto.RegisterType((*UpdateImageIntegrationRequest)(nil), "v1.UpdateImageIntegrationRequest")
}

func init() {
	proto.RegisterFile("api/v1/image_integration_service.proto", fileDescriptor_263887791ba1d8ff)
}

var fileDescriptor_263887791ba1d8ff = []byte{
	// 531 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x94, 0xc1, 0x6e, 0xd3, 0x40,
	0x10, 0x86, 0xeb, 0x80, 0x5a, 0x3a, 0x20, 0x84, 0xb6, 0xa1, 0x0d, 0x6e, 0x9a, 0xa4, 0x2b, 0x11,
	0xaa, 0x08, 0x36, 0x72, 0xb8, 0x55, 0xe2, 0x52, 0x15, 0xa1, 0x88, 0x4b, 0x64, 0x40, 0x02, 0x24,
	0x54, 0x6d, 0xed, 0xa9, 0x65, 0x11, 0x7b, 0x8d, 0x77, 0x6d, 0xda, 0x22, 0x0e, 0xf0, 0x0a, 0x5c,
	0x78, 0x24, 0x8e, 0x48, 0xbc, 0x00, 0x0a, 0x3c, 0x08, 0xf2, 0xda, 0x40, 0x48, 0x6c, 0x4b, 0xa8,
	0xb7, 0x64, 0x76, 0xf6, 0xff, 0xe6, 0x9f, 0x9d, 0x31, 0xf4, 0x79, 0xe4, 0x0f, 0x53, 0x6b, 0xe8,
	0x07, 0xdc, 0xc3, 0x23, 0x3f, 0x54, 0xe8, 0xc5, 0x5c, 0xf9, 0x22, 0x3c, 0x92, 0x18, 0xa7, 0xbe,
	0x83, 0x2c, 0x8a, 0x85, 0x12, 0xa4, 0x91, 0x5a, 0x66, 0xdb, 0x13, 0xc2, 0x9b, 0xe2, 0x30, 0xbb,
	0xc2, 0xc3, 0x50, 0x28, 0x9d, 0x28, 0xf3, 0x0c, 0x73, 0xa3, 0x50, 0x72, 0x44, 0x10, 0x88, 0xb0,
	0x08, 0x92, 0x22, 0x88, 0x41, 0xa4, 0xce, 0x8a, 0x58, 0x57, 0x2a, 0x11, 0x73, 0x0f, 0x97, 0x99,
	0x79, 0x02, 0x7d, 0x0c, 0xdb, 0x8f, 0x50, 0x8d, 0xb3, 0xd3, 0xf1, 0xdf, 0x43, 0x69, 0xe3, 0x9b,
	0x04, 0xa5, 0x22, 0x04, 0x2e, 0x87, 0x3c, 0xc0, 0x96, 0xd1, 0x33, 0xf6, 0xd6, 0x6d, 0xfd, 0x9b,
	0xb4, 0x60, 0xcd, 0x99, 0x26, 0x52, 0x61, 0xdc, 0x6a, 0xe8, 0xf0, 0xef, 0xbf, 0xf4, 0x15, 0xb4,
	0xcb, 0xc5, 0x64, 0x24, 0x42, 0x89, 0xe4, 0x01, 0x5c, 0x9b, 0xab, 0x40, 0xb6, 0x8c, 0xde, 0xa5,
	0xbd, 0xab, 0xa3, 0x5b, 0xac, 0x28, 0x92, 0x2d, 0xde, 0xb4, 0xff, 0x49, 0xa7, 0xe7, 0xb0, 0xf3,
	0x2c, 0x72, 0xb9, 0xc2, 0xa5, 0xbc, 0xa2, 0x5a, 0x0b, 0x56, 0x1d, 0x11, 0x9e, 0xf8, 0x9e, 0xae,
	0xb7, 0x56, 0xb9, 0x48, 0x24, 0x7d, 0xb8, 0x9e, 0x68, 0xcd, 0x09, 0x97, 0xf2, 0xad, 0x88, 0x5d,
	0xed, 0xe9, 0x8a, 0xbd, 0x10, 0x1d, 0x7d, 0x58, 0x83, 0xad, 0x45, 0x91, 0x27, 0xf9, 0xab, 0x91,
	0x13, 0xd8, 0x28, 0xb1, 0x4d, 0x6e, 0xb0, 0xd4, 0x62, 0x36, 0x4a, 0x91, 0xc4, 0x0e, 0x1e, 0x9c,
	0x8d, 0x0f, 0xcd, 0xea, 0x7a, 0x28, 0xfd, 0xf8, 0xed, 0xe7, 0xa7, 0x46, 0x9b, 0x98, 0x7f, 0x06,
	0x64, 0xde, 0xfa, 0xf0, 0x9d, 0xef, 0xbe, 0x27, 0xa7, 0xd0, 0x2c, 0x6b, 0x2f, 0xe9, 0x66, 0xa0,
	0x9a, 0x57, 0x34, 0x7b, 0xd5, 0x09, 0xf9, 0xcb, 0xd0, 0x1d, 0x8d, 0xdf, 0x22, 0x37, 0x4b, 0xf1,
	0x24, 0x84, 0xe6, 0x44, 0xc8, 0x65, 0x8b, 0xd5, 0x86, 0xea, 0xbc, 0xf6, 0x34, 0xcc, 0xa4, 0xe5,
	0xb0, 0x7d, 0x63, 0x40, 0x8e, 0x61, 0x63, 0x92, 0xfc, 0x17, 0x6e, 0x3d, 0xb3, 0xf8, 0x30, 0x9b,
	0x7c, 0x7a, 0x5b, 0xcb, 0x77, 0xcd, 0x9a, 0x56, 0x66, 0x0c, 0x07, 0x9a, 0x4f, 0x51, 0x5e, 0x10,
	0x42, 0x2b, 0x20, 0x0a, 0xa5, 0xca, 0x20, 0x2f, 0x60, 0xf3, 0x10, 0xa7, 0xb8, 0x3c, 0xb2, 0x25,
	0xd3, 0x31, 0xa7, 0x5e, 0x4c, 0xc3, 0xa0, 0x6e, 0x1a, 0x14, 0x6c, 0x96, 0x6f, 0x03, 0xd9, 0xcd,
	0x84, 0x6a, 0x37, 0x65, 0x9e, 0x75, 0x57, 0xb3, 0xfa, 0xa3, 0xdd, 0x0a, 0x56, 0xbe, 0x28, 0xac,
	0xe8, 0xda, 0x39, 0x6c, 0x67, 0x5d, 0xcb, 0xd5, 0xdd, 0x0b, 0xa2, 0xef, 0x69, 0xf4, 0x1d, 0x4a,
	0xab, 0x9b, 0x38, 0xcc, 0xf7, 0xd0, 0xdd, 0x37, 0x06, 0x07, 0xec, 0xcb, 0xac, 0x63, 0x7c, 0x9d,
	0x75, 0x8c, 0xef, 0xb3, 0x8e, 0xf1, 0xf9, 0x47, 0x67, 0x05, 0x5a, 0xbe, 0x60, 0x52, 0x71, 0xe7,
	0x75, 0x2c, 0x4e, 0xf3, 0x0f, 0x1a, 0xe3, 0x91, 0xcf, 0x52, 0xeb, 0x65, 0x23, 0xb5, 0x9e, 0xaf,
	0x1c, 0xaf, 0xea, 0xd8, 0xfd, 0x5f, 0x01, 0x00, 0x00, 0xff, 0xff, 0x33, 0x3f, 0x69, 0x41, 0x7a,
	0x05, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ImageIntegrationServiceClient is the client API for ImageIntegrationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConnInterface.NewStream.
type ImageIntegrationServiceClient interface {
	// GetImageIntegration returns the image integration given its ID.
	GetImageIntegration(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*storage.ImageIntegration, error)
	// GetImageIntegrations returns all image integrations that match the request filters.
	GetImageIntegrations(ctx context.Context, in *GetImageIntegrationsRequest, opts ...grpc.CallOption) (*GetImageIntegrationsResponse, error)
	// PostImageIntegration creates a image integration.
	PostImageIntegration(ctx context.Context, in *storage.ImageIntegration, opts ...grpc.CallOption) (*storage.ImageIntegration, error)
	// PutImageIntegration modifies a given image integration, without using stored credential reconciliation.
	PutImageIntegration(ctx context.Context, in *storage.ImageIntegration, opts ...grpc.CallOption) (*Empty, error)
	// TestImageIntegration checks if the given image integration is correctly configured, without using stored credential reconciliation.
	TestImageIntegration(ctx context.Context, in *storage.ImageIntegration, opts ...grpc.CallOption) (*Empty, error)
	// DeleteImageIntegration removes a image integration given its ID.
	DeleteImageIntegration(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*Empty, error)
	// UpdateImageIntegration modifies a given image integration, with optional stored credential reconciliation.
	UpdateImageIntegration(ctx context.Context, in *UpdateImageIntegrationRequest, opts ...grpc.CallOption) (*Empty, error)
	// TestUpdatedImageIntegration checks if the given image integration is correctly configured, with optional stored credential reconciliation.
	TestUpdatedImageIntegration(ctx context.Context, in *UpdateImageIntegrationRequest, opts ...grpc.CallOption) (*Empty, error)
}

type imageIntegrationServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewImageIntegrationServiceClient(cc grpc.ClientConnInterface) ImageIntegrationServiceClient {
	return &imageIntegrationServiceClient{cc}
}

func (c *imageIntegrationServiceClient) GetImageIntegration(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*storage.ImageIntegration, error) {
	out := new(storage.ImageIntegration)
	err := c.cc.Invoke(ctx, "/v1.ImageIntegrationService/GetImageIntegration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageIntegrationServiceClient) GetImageIntegrations(ctx context.Context, in *GetImageIntegrationsRequest, opts ...grpc.CallOption) (*GetImageIntegrationsResponse, error) {
	out := new(GetImageIntegrationsResponse)
	err := c.cc.Invoke(ctx, "/v1.ImageIntegrationService/GetImageIntegrations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageIntegrationServiceClient) PostImageIntegration(ctx context.Context, in *storage.ImageIntegration, opts ...grpc.CallOption) (*storage.ImageIntegration, error) {
	out := new(storage.ImageIntegration)
	err := c.cc.Invoke(ctx, "/v1.ImageIntegrationService/PostImageIntegration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageIntegrationServiceClient) PutImageIntegration(ctx context.Context, in *storage.ImageIntegration, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.ImageIntegrationService/PutImageIntegration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageIntegrationServiceClient) TestImageIntegration(ctx context.Context, in *storage.ImageIntegration, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.ImageIntegrationService/TestImageIntegration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageIntegrationServiceClient) DeleteImageIntegration(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.ImageIntegrationService/DeleteImageIntegration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageIntegrationServiceClient) UpdateImageIntegration(ctx context.Context, in *UpdateImageIntegrationRequest, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.ImageIntegrationService/UpdateImageIntegration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageIntegrationServiceClient) TestUpdatedImageIntegration(ctx context.Context, in *UpdateImageIntegrationRequest, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.ImageIntegrationService/TestUpdatedImageIntegration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ImageIntegrationServiceServer is the server API for ImageIntegrationService service.
type ImageIntegrationServiceServer interface {
	// GetImageIntegration returns the image integration given its ID.
	GetImageIntegration(context.Context, *ResourceByID) (*storage.ImageIntegration, error)
	// GetImageIntegrations returns all image integrations that match the request filters.
	GetImageIntegrations(context.Context, *GetImageIntegrationsRequest) (*GetImageIntegrationsResponse, error)
	// PostImageIntegration creates a image integration.
	PostImageIntegration(context.Context, *storage.ImageIntegration) (*storage.ImageIntegration, error)
	// PutImageIntegration modifies a given image integration, without using stored credential reconciliation.
	PutImageIntegration(context.Context, *storage.ImageIntegration) (*Empty, error)
	// TestImageIntegration checks if the given image integration is correctly configured, without using stored credential reconciliation.
	TestImageIntegration(context.Context, *storage.ImageIntegration) (*Empty, error)
	// DeleteImageIntegration removes a image integration given its ID.
	DeleteImageIntegration(context.Context, *ResourceByID) (*Empty, error)
	// UpdateImageIntegration modifies a given image integration, with optional stored credential reconciliation.
	UpdateImageIntegration(context.Context, *UpdateImageIntegrationRequest) (*Empty, error)
	// TestUpdatedImageIntegration checks if the given image integration is correctly configured, with optional stored credential reconciliation.
	TestUpdatedImageIntegration(context.Context, *UpdateImageIntegrationRequest) (*Empty, error)
}

// UnimplementedImageIntegrationServiceServer can be embedded to have forward compatible implementations.
type UnimplementedImageIntegrationServiceServer struct {
}

func (*UnimplementedImageIntegrationServiceServer) GetImageIntegration(ctx context.Context, req *ResourceByID) (*storage.ImageIntegration, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetImageIntegration not implemented")
}
func (*UnimplementedImageIntegrationServiceServer) GetImageIntegrations(ctx context.Context, req *GetImageIntegrationsRequest) (*GetImageIntegrationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetImageIntegrations not implemented")
}
func (*UnimplementedImageIntegrationServiceServer) PostImageIntegration(ctx context.Context, req *storage.ImageIntegration) (*storage.ImageIntegration, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PostImageIntegration not implemented")
}
func (*UnimplementedImageIntegrationServiceServer) PutImageIntegration(ctx context.Context, req *storage.ImageIntegration) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PutImageIntegration not implemented")
}
func (*UnimplementedImageIntegrationServiceServer) TestImageIntegration(ctx context.Context, req *storage.ImageIntegration) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestImageIntegration not implemented")
}
func (*UnimplementedImageIntegrationServiceServer) DeleteImageIntegration(ctx context.Context, req *ResourceByID) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteImageIntegration not implemented")
}
func (*UnimplementedImageIntegrationServiceServer) UpdateImageIntegration(ctx context.Context, req *UpdateImageIntegrationRequest) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateImageIntegration not implemented")
}
func (*UnimplementedImageIntegrationServiceServer) TestUpdatedImageIntegration(ctx context.Context, req *UpdateImageIntegrationRequest) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestUpdatedImageIntegration not implemented")
}

func RegisterImageIntegrationServiceServer(s *grpc.Server, srv ImageIntegrationServiceServer) {
	s.RegisterService(&_ImageIntegrationService_serviceDesc, srv)
}

func _ImageIntegrationService_GetImageIntegration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageIntegrationServiceServer).GetImageIntegration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ImageIntegrationService/GetImageIntegration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageIntegrationServiceServer).GetImageIntegration(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageIntegrationService_GetImageIntegrations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetImageIntegrationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageIntegrationServiceServer).GetImageIntegrations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ImageIntegrationService/GetImageIntegrations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageIntegrationServiceServer).GetImageIntegrations(ctx, req.(*GetImageIntegrationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageIntegrationService_PostImageIntegration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(storage.ImageIntegration)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageIntegrationServiceServer).PostImageIntegration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ImageIntegrationService/PostImageIntegration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageIntegrationServiceServer).PostImageIntegration(ctx, req.(*storage.ImageIntegration))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageIntegrationService_PutImageIntegration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(storage.ImageIntegration)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageIntegrationServiceServer).PutImageIntegration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ImageIntegrationService/PutImageIntegration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageIntegrationServiceServer).PutImageIntegration(ctx, req.(*storage.ImageIntegration))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageIntegrationService_TestImageIntegration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(storage.ImageIntegration)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageIntegrationServiceServer).TestImageIntegration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ImageIntegrationService/TestImageIntegration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageIntegrationServiceServer).TestImageIntegration(ctx, req.(*storage.ImageIntegration))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageIntegrationService_DeleteImageIntegration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageIntegrationServiceServer).DeleteImageIntegration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ImageIntegrationService/DeleteImageIntegration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageIntegrationServiceServer).DeleteImageIntegration(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageIntegrationService_UpdateImageIntegration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateImageIntegrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageIntegrationServiceServer).UpdateImageIntegration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ImageIntegrationService/UpdateImageIntegration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageIntegrationServiceServer).UpdateImageIntegration(ctx, req.(*UpdateImageIntegrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageIntegrationService_TestUpdatedImageIntegration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateImageIntegrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageIntegrationServiceServer).TestUpdatedImageIntegration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ImageIntegrationService/TestUpdatedImageIntegration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageIntegrationServiceServer).TestUpdatedImageIntegration(ctx, req.(*UpdateImageIntegrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ImageIntegrationService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1.ImageIntegrationService",
	HandlerType: (*ImageIntegrationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetImageIntegration",
			Handler:    _ImageIntegrationService_GetImageIntegration_Handler,
		},
		{
			MethodName: "GetImageIntegrations",
			Handler:    _ImageIntegrationService_GetImageIntegrations_Handler,
		},
		{
			MethodName: "PostImageIntegration",
			Handler:    _ImageIntegrationService_PostImageIntegration_Handler,
		},
		{
			MethodName: "PutImageIntegration",
			Handler:    _ImageIntegrationService_PutImageIntegration_Handler,
		},
		{
			MethodName: "TestImageIntegration",
			Handler:    _ImageIntegrationService_TestImageIntegration_Handler,
		},
		{
			MethodName: "DeleteImageIntegration",
			Handler:    _ImageIntegrationService_DeleteImageIntegration_Handler,
		},
		{
			MethodName: "UpdateImageIntegration",
			Handler:    _ImageIntegrationService_UpdateImageIntegration_Handler,
		},
		{
			MethodName: "TestUpdatedImageIntegration",
			Handler:    _ImageIntegrationService_TestUpdatedImageIntegration_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/v1/image_integration_service.proto",
}

func (m *GetImageIntegrationsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetImageIntegrationsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetImageIntegrationsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Cluster) > 0 {
		i -= len(m.Cluster)
		copy(dAtA[i:], m.Cluster)
		i = encodeVarintImageIntegrationService(dAtA, i, uint64(len(m.Cluster)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintImageIntegrationService(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetImageIntegrationsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetImageIntegrationsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetImageIntegrationsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Integrations) > 0 {
		for iNdEx := len(m.Integrations) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Integrations[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintImageIntegrationService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *UpdateImageIntegrationRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpdateImageIntegrationRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UpdateImageIntegrationRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.UpdatePassword {
		i--
		if m.UpdatePassword {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if m.Config != nil {
		{
			size, err := m.Config.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintImageIntegrationService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintImageIntegrationService(dAtA []byte, offset int, v uint64) int {
	offset -= sovImageIntegrationService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *GetImageIntegrationsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovImageIntegrationService(uint64(l))
	}
	l = len(m.Cluster)
	if l > 0 {
		n += 1 + l + sovImageIntegrationService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetImageIntegrationsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Integrations) > 0 {
		for _, e := range m.Integrations {
			l = e.Size()
			n += 1 + l + sovImageIntegrationService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *UpdateImageIntegrationRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Config != nil {
		l = m.Config.Size()
		n += 1 + l + sovImageIntegrationService(uint64(l))
	}
	if m.UpdatePassword {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovImageIntegrationService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozImageIntegrationService(x uint64) (n int) {
	return sovImageIntegrationService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *GetImageIntegrationsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImageIntegrationService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetImageIntegrationsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetImageIntegrationsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegrationService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageIntegrationService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegrationService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegrationService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageIntegrationService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegrationService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipImageIntegrationService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImageIntegrationService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetImageIntegrationsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImageIntegrationService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetImageIntegrationsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetImageIntegrationsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Integrations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegrationService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImageIntegrationService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegrationService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Integrations = append(m.Integrations, &storage.ImageIntegration{})
			if err := m.Integrations[len(m.Integrations)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipImageIntegrationService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImageIntegrationService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateImageIntegrationRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImageIntegrationService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateImageIntegrationRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateImageIntegrationRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Config", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegrationService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImageIntegrationService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImageIntegrationService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Config == nil {
				m.Config = &storage.ImageIntegration{}
			}
			if err := m.Config.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpdatePassword", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageIntegrationService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UpdatePassword = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipImageIntegrationService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImageIntegrationService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipImageIntegrationService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowImageIntegrationService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowImageIntegrationService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowImageIntegrationService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthImageIntegrationService
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupImageIntegrationService
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthImageIntegrationService
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthImageIntegrationService        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowImageIntegrationService          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupImageIntegrationService = fmt.Errorf("proto: unexpected end of group")
)
