// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api/v1/image_service.proto

package v1

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	storage "github.com/stackrox/rox/generated/storage"
	v1 "github.com/stackrox/scanner/generated/scanner/api/v1"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type WatchImageResponse_ErrorType int32

const (
	WatchImageResponse_NO_ERROR             WatchImageResponse_ErrorType = 0
	WatchImageResponse_INVALID_IMAGE_NAME   WatchImageResponse_ErrorType = 1
	WatchImageResponse_NO_VALID_INTEGRATION WatchImageResponse_ErrorType = 2
	WatchImageResponse_SCAN_FAILED          WatchImageResponse_ErrorType = 3
)

var WatchImageResponse_ErrorType_name = map[int32]string{
	0: "NO_ERROR",
	1: "INVALID_IMAGE_NAME",
	2: "NO_VALID_INTEGRATION",
	3: "SCAN_FAILED",
}

var WatchImageResponse_ErrorType_value = map[string]int32{
	"NO_ERROR":             0,
	"INVALID_IMAGE_NAME":   1,
	"NO_VALID_INTEGRATION": 2,
	"SCAN_FAILED":          3,
}

func (x WatchImageResponse_ErrorType) String() string {
	return proto.EnumName(WatchImageResponse_ErrorType_name, int32(x))
}

func (WatchImageResponse_ErrorType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b4306cfe43028263, []int{10, 0}
}

type GetImageRequest struct {
	Id                   string   `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	IncludeSnoozed       bool     `protobuf:"varint,2,opt,name=include_snoozed,json=includeSnoozed,proto3" json:"include_snoozed,omitempty"`
	StripDescription     bool     `protobuf:"varint,3,opt,name=strip_description,json=stripDescription,proto3" json:"strip_description,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetImageRequest) Reset()         { *m = GetImageRequest{} }
func (m *GetImageRequest) String() string { return proto.CompactTextString(m) }
func (*GetImageRequest) ProtoMessage()    {}
func (*GetImageRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b4306cfe43028263, []int{0}
}
func (m *GetImageRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetImageRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetImageRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetImageRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetImageRequest.Merge(m, src)
}
func (m *GetImageRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetImageRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetImageRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetImageRequest proto.InternalMessageInfo

func (m *GetImageRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *GetImageRequest) GetIncludeSnoozed() bool {
	if m != nil {
		return m.IncludeSnoozed
	}
	return false
}

func (m *GetImageRequest) GetStripDescription() bool {
	if m != nil {
		return m.StripDescription
	}
	return false
}

func (m *GetImageRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetImageRequest) Clone() *GetImageRequest {
	if m == nil {
		return nil
	}
	cloned := new(GetImageRequest)
	*cloned = *m

	return cloned
}

type ListImagesResponse struct {
	Images               []*storage.ListImage `protobuf:"bytes,1,rep,name=images,proto3" json:"images,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ListImagesResponse) Reset()         { *m = ListImagesResponse{} }
func (m *ListImagesResponse) String() string { return proto.CompactTextString(m) }
func (*ListImagesResponse) ProtoMessage()    {}
func (*ListImagesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b4306cfe43028263, []int{1}
}
func (m *ListImagesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListImagesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListImagesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListImagesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListImagesResponse.Merge(m, src)
}
func (m *ListImagesResponse) XXX_Size() int {
	return m.Size()
}
func (m *ListImagesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListImagesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListImagesResponse proto.InternalMessageInfo

func (m *ListImagesResponse) GetImages() []*storage.ListImage {
	if m != nil {
		return m.Images
	}
	return nil
}

func (m *ListImagesResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ListImagesResponse) Clone() *ListImagesResponse {
	if m == nil {
		return nil
	}
	cloned := new(ListImagesResponse)
	*cloned = *m

	if m.Images != nil {
		cloned.Images = make([]*storage.ListImage, len(m.Images))
		for idx, v := range m.Images {
			cloned.Images[idx] = v.Clone()
		}
	}
	return cloned
}

type CountImagesResponse struct {
	Count                int32    `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CountImagesResponse) Reset()         { *m = CountImagesResponse{} }
func (m *CountImagesResponse) String() string { return proto.CompactTextString(m) }
func (*CountImagesResponse) ProtoMessage()    {}
func (*CountImagesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b4306cfe43028263, []int{2}
}
func (m *CountImagesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CountImagesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CountImagesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CountImagesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CountImagesResponse.Merge(m, src)
}
func (m *CountImagesResponse) XXX_Size() int {
	return m.Size()
}
func (m *CountImagesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CountImagesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CountImagesResponse proto.InternalMessageInfo

func (m *CountImagesResponse) GetCount() int32 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *CountImagesResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *CountImagesResponse) Clone() *CountImagesResponse {
	if m == nil {
		return nil
	}
	cloned := new(CountImagesResponse)
	*cloned = *m

	return cloned
}

type ScanImageRequest struct {
	ImageName            string   `protobuf:"bytes,1,opt,name=image_name,json=imageName,proto3" json:"image_name,omitempty"`
	Force                bool     `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
	IncludeSnoozed       bool     `protobuf:"varint,3,opt,name=include_snoozed,json=includeSnoozed,proto3" json:"include_snoozed,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ScanImageRequest) Reset()         { *m = ScanImageRequest{} }
func (m *ScanImageRequest) String() string { return proto.CompactTextString(m) }
func (*ScanImageRequest) ProtoMessage()    {}
func (*ScanImageRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b4306cfe43028263, []int{3}
}
func (m *ScanImageRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ScanImageRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ScanImageRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ScanImageRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScanImageRequest.Merge(m, src)
}
func (m *ScanImageRequest) XXX_Size() int {
	return m.Size()
}
func (m *ScanImageRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ScanImageRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ScanImageRequest proto.InternalMessageInfo

func (m *ScanImageRequest) GetImageName() string {
	if m != nil {
		return m.ImageName
	}
	return ""
}

func (m *ScanImageRequest) GetForce() bool {
	if m != nil {
		return m.Force
	}
	return false
}

func (m *ScanImageRequest) GetIncludeSnoozed() bool {
	if m != nil {
		return m.IncludeSnoozed
	}
	return false
}

func (m *ScanImageRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ScanImageRequest) Clone() *ScanImageRequest {
	if m == nil {
		return nil
	}
	cloned := new(ScanImageRequest)
	*cloned = *m

	return cloned
}

type ScanImageInternalRequest struct {
	Image                *storage.ContainerImage `protobuf:"bytes,1,opt,name=image,proto3" json:"image,omitempty"`
	CachedOnly           bool                    `protobuf:"varint,3,opt,name=cached_only,json=cachedOnly,proto3" json:"cached_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *ScanImageInternalRequest) Reset()         { *m = ScanImageInternalRequest{} }
func (m *ScanImageInternalRequest) String() string { return proto.CompactTextString(m) }
func (*ScanImageInternalRequest) ProtoMessage()    {}
func (*ScanImageInternalRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b4306cfe43028263, []int{4}
}
func (m *ScanImageInternalRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ScanImageInternalRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ScanImageInternalRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ScanImageInternalRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScanImageInternalRequest.Merge(m, src)
}
func (m *ScanImageInternalRequest) XXX_Size() int {
	return m.Size()
}
func (m *ScanImageInternalRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ScanImageInternalRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ScanImageInternalRequest proto.InternalMessageInfo

func (m *ScanImageInternalRequest) GetImage() *storage.ContainerImage {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *ScanImageInternalRequest) GetCachedOnly() bool {
	if m != nil {
		return m.CachedOnly
	}
	return false
}

func (m *ScanImageInternalRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ScanImageInternalRequest) Clone() *ScanImageInternalRequest {
	if m == nil {
		return nil
	}
	cloned := new(ScanImageInternalRequest)
	*cloned = *m

	cloned.Image = m.Image.Clone()
	return cloned
}

type ScanImageInternalResponse struct {
	Image                *storage.Image `protobuf:"bytes,1,opt,name=image,proto3" json:"image,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *ScanImageInternalResponse) Reset()         { *m = ScanImageInternalResponse{} }
func (m *ScanImageInternalResponse) String() string { return proto.CompactTextString(m) }
func (*ScanImageInternalResponse) ProtoMessage()    {}
func (*ScanImageInternalResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b4306cfe43028263, []int{5}
}
func (m *ScanImageInternalResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ScanImageInternalResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ScanImageInternalResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ScanImageInternalResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScanImageInternalResponse.Merge(m, src)
}
func (m *ScanImageInternalResponse) XXX_Size() int {
	return m.Size()
}
func (m *ScanImageInternalResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ScanImageInternalResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ScanImageInternalResponse proto.InternalMessageInfo

func (m *ScanImageInternalResponse) GetImage() *storage.Image {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *ScanImageInternalResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ScanImageInternalResponse) Clone() *ScanImageInternalResponse {
	if m == nil {
		return nil
	}
	cloned := new(ScanImageInternalResponse)
	*cloned = *m

	cloned.Image = m.Image.Clone()
	return cloned
}

type GetImageVulnerabilitiesInternalRequest struct {
	ImageId              string                 `protobuf:"bytes,1,opt,name=image_id,json=imageId,proto3" json:"image_id,omitempty"`
	ImageName            *storage.ImageName     `protobuf:"bytes,2,opt,name=image_name,json=imageName,proto3" json:"image_name,omitempty"`
	Metadata             *storage.ImageMetadata `protobuf:"bytes,3,opt,name=metadata,proto3" json:"metadata,omitempty"`
	IsClusterLocal       bool                   `protobuf:"varint,6,opt,name=is_cluster_local,json=isClusterLocal,proto3" json:"is_cluster_local,omitempty"`
	Components           *v1.Components         `protobuf:"bytes,4,opt,name=components,proto3" json:"components,omitempty"`
	Notes                []v1.Note              `protobuf:"varint,5,rep,packed,name=notes,proto3,enum=scannerV1.Note" json:"notes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *GetImageVulnerabilitiesInternalRequest) Reset() {
	*m = GetImageVulnerabilitiesInternalRequest{}
}
func (m *GetImageVulnerabilitiesInternalRequest) String() string { return proto.CompactTextString(m) }
func (*GetImageVulnerabilitiesInternalRequest) ProtoMessage()    {}
func (*GetImageVulnerabilitiesInternalRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b4306cfe43028263, []int{6}
}
func (m *GetImageVulnerabilitiesInternalRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetImageVulnerabilitiesInternalRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetImageVulnerabilitiesInternalRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetImageVulnerabilitiesInternalRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetImageVulnerabilitiesInternalRequest.Merge(m, src)
}
func (m *GetImageVulnerabilitiesInternalRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetImageVulnerabilitiesInternalRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetImageVulnerabilitiesInternalRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetImageVulnerabilitiesInternalRequest proto.InternalMessageInfo

func (m *GetImageVulnerabilitiesInternalRequest) GetImageId() string {
	if m != nil {
		return m.ImageId
	}
	return ""
}

func (m *GetImageVulnerabilitiesInternalRequest) GetImageName() *storage.ImageName {
	if m != nil {
		return m.ImageName
	}
	return nil
}

func (m *GetImageVulnerabilitiesInternalRequest) GetMetadata() *storage.ImageMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *GetImageVulnerabilitiesInternalRequest) GetIsClusterLocal() bool {
	if m != nil {
		return m.IsClusterLocal
	}
	return false
}

func (m *GetImageVulnerabilitiesInternalRequest) GetComponents() *v1.Components {
	if m != nil {
		return m.Components
	}
	return nil
}

func (m *GetImageVulnerabilitiesInternalRequest) GetNotes() []v1.Note {
	if m != nil {
		return m.Notes
	}
	return nil
}

func (m *GetImageVulnerabilitiesInternalRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetImageVulnerabilitiesInternalRequest) Clone() *GetImageVulnerabilitiesInternalRequest {
	if m == nil {
		return nil
	}
	cloned := new(GetImageVulnerabilitiesInternalRequest)
	*cloned = *m

	cloned.ImageName = m.ImageName.Clone()
	cloned.Metadata = m.Metadata.Clone()
	cloned.Components = m.Components.Clone()
	if m.Notes != nil {
		cloned.Notes = make([]v1.Note, len(m.Notes))
		copy(cloned.Notes, m.Notes)
	}
	return cloned
}

type DeleteImagesRequest struct {
	Query                *RawQuery `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	Confirm              bool      `protobuf:"varint,2,opt,name=confirm,proto3" json:"confirm,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *DeleteImagesRequest) Reset()         { *m = DeleteImagesRequest{} }
func (m *DeleteImagesRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteImagesRequest) ProtoMessage()    {}
func (*DeleteImagesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b4306cfe43028263, []int{7}
}
func (m *DeleteImagesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeleteImagesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeleteImagesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeleteImagesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteImagesRequest.Merge(m, src)
}
func (m *DeleteImagesRequest) XXX_Size() int {
	return m.Size()
}
func (m *DeleteImagesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteImagesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteImagesRequest proto.InternalMessageInfo

func (m *DeleteImagesRequest) GetQuery() *RawQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *DeleteImagesRequest) GetConfirm() bool {
	if m != nil {
		return m.Confirm
	}
	return false
}

func (m *DeleteImagesRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *DeleteImagesRequest) Clone() *DeleteImagesRequest {
	if m == nil {
		return nil
	}
	cloned := new(DeleteImagesRequest)
	*cloned = *m

	cloned.Query = m.Query.Clone()
	return cloned
}

type DeleteImagesResponse struct {
	NumDeleted           uint32   `protobuf:"varint,1,opt,name=num_deleted,json=numDeleted,proto3" json:"num_deleted,omitempty"`
	DryRun               bool     `protobuf:"varint,2,opt,name=dry_run,json=dryRun,proto3" json:"dry_run,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteImagesResponse) Reset()         { *m = DeleteImagesResponse{} }
func (m *DeleteImagesResponse) String() string { return proto.CompactTextString(m) }
func (*DeleteImagesResponse) ProtoMessage()    {}
func (*DeleteImagesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b4306cfe43028263, []int{8}
}
func (m *DeleteImagesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeleteImagesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeleteImagesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeleteImagesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteImagesResponse.Merge(m, src)
}
func (m *DeleteImagesResponse) XXX_Size() int {
	return m.Size()
}
func (m *DeleteImagesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteImagesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteImagesResponse proto.InternalMessageInfo

func (m *DeleteImagesResponse) GetNumDeleted() uint32 {
	if m != nil {
		return m.NumDeleted
	}
	return 0
}

func (m *DeleteImagesResponse) GetDryRun() bool {
	if m != nil {
		return m.DryRun
	}
	return false
}

func (m *DeleteImagesResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *DeleteImagesResponse) Clone() *DeleteImagesResponse {
	if m == nil {
		return nil
	}
	cloned := new(DeleteImagesResponse)
	*cloned = *m

	return cloned
}

type WatchImageRequest struct {
	// The name of the image.
	// This must be fully qualified, including a tag,
	// but must NOT include a SHA.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WatchImageRequest) Reset()         { *m = WatchImageRequest{} }
func (m *WatchImageRequest) String() string { return proto.CompactTextString(m) }
func (*WatchImageRequest) ProtoMessage()    {}
func (*WatchImageRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b4306cfe43028263, []int{9}
}
func (m *WatchImageRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WatchImageRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WatchImageRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WatchImageRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WatchImageRequest.Merge(m, src)
}
func (m *WatchImageRequest) XXX_Size() int {
	return m.Size()
}
func (m *WatchImageRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_WatchImageRequest.DiscardUnknown(m)
}

var xxx_messageInfo_WatchImageRequest proto.InternalMessageInfo

func (m *WatchImageRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *WatchImageRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *WatchImageRequest) Clone() *WatchImageRequest {
	if m == nil {
		return nil
	}
	cloned := new(WatchImageRequest)
	*cloned = *m

	return cloned
}

type WatchImageResponse struct {
	// If the image was scanned successfully, this returns the normalized name of the image.
	// This depends on what we get from the registry.
	// For example, "docker.io/wordpress:latest" -> "docker.io/library/wordpress:latest"
	NormalizedName string                       `protobuf:"bytes,1,opt,name=normalized_name,json=normalizedName,proto3" json:"normalized_name,omitempty"`
	ErrorType      WatchImageResponse_ErrorType `protobuf:"varint,2,opt,name=error_type,json=errorType,proto3,enum=v1.WatchImageResponse_ErrorType" json:"error_type,omitempty"`
	// Only set if error_type is NOT equal to "NO_ERROR".
	ErrorMessage         string   `protobuf:"bytes,3,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WatchImageResponse) Reset()         { *m = WatchImageResponse{} }
func (m *WatchImageResponse) String() string { return proto.CompactTextString(m) }
func (*WatchImageResponse) ProtoMessage()    {}
func (*WatchImageResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b4306cfe43028263, []int{10}
}
func (m *WatchImageResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WatchImageResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WatchImageResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WatchImageResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WatchImageResponse.Merge(m, src)
}
func (m *WatchImageResponse) XXX_Size() int {
	return m.Size()
}
func (m *WatchImageResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_WatchImageResponse.DiscardUnknown(m)
}

var xxx_messageInfo_WatchImageResponse proto.InternalMessageInfo

func (m *WatchImageResponse) GetNormalizedName() string {
	if m != nil {
		return m.NormalizedName
	}
	return ""
}

func (m *WatchImageResponse) GetErrorType() WatchImageResponse_ErrorType {
	if m != nil {
		return m.ErrorType
	}
	return WatchImageResponse_NO_ERROR
}

func (m *WatchImageResponse) GetErrorMessage() string {
	if m != nil {
		return m.ErrorMessage
	}
	return ""
}

func (m *WatchImageResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *WatchImageResponse) Clone() *WatchImageResponse {
	if m == nil {
		return nil
	}
	cloned := new(WatchImageResponse)
	*cloned = *m

	return cloned
}

type UnwatchImageRequest struct {
	// The name of the image to unwatch.
	// Should match the name of a previously watched image.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UnwatchImageRequest) Reset()         { *m = UnwatchImageRequest{} }
func (m *UnwatchImageRequest) String() string { return proto.CompactTextString(m) }
func (*UnwatchImageRequest) ProtoMessage()    {}
func (*UnwatchImageRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b4306cfe43028263, []int{11}
}
func (m *UnwatchImageRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UnwatchImageRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UnwatchImageRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UnwatchImageRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UnwatchImageRequest.Merge(m, src)
}
func (m *UnwatchImageRequest) XXX_Size() int {
	return m.Size()
}
func (m *UnwatchImageRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UnwatchImageRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UnwatchImageRequest proto.InternalMessageInfo

func (m *UnwatchImageRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UnwatchImageRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *UnwatchImageRequest) Clone() *UnwatchImageRequest {
	if m == nil {
		return nil
	}
	cloned := new(UnwatchImageRequest)
	*cloned = *m

	return cloned
}

type GetWatchedImagesResponse struct {
	WatchedImages        []*storage.WatchedImage `protobuf:"bytes,1,rep,name=watched_images,json=watchedImages,proto3" json:"watched_images,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *GetWatchedImagesResponse) Reset()         { *m = GetWatchedImagesResponse{} }
func (m *GetWatchedImagesResponse) String() string { return proto.CompactTextString(m) }
func (*GetWatchedImagesResponse) ProtoMessage()    {}
func (*GetWatchedImagesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b4306cfe43028263, []int{12}
}
func (m *GetWatchedImagesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetWatchedImagesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetWatchedImagesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetWatchedImagesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetWatchedImagesResponse.Merge(m, src)
}
func (m *GetWatchedImagesResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetWatchedImagesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetWatchedImagesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetWatchedImagesResponse proto.InternalMessageInfo

func (m *GetWatchedImagesResponse) GetWatchedImages() []*storage.WatchedImage {
	if m != nil {
		return m.WatchedImages
	}
	return nil
}

func (m *GetWatchedImagesResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetWatchedImagesResponse) Clone() *GetWatchedImagesResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetWatchedImagesResponse)
	*cloned = *m

	if m.WatchedImages != nil {
		cloned.WatchedImages = make([]*storage.WatchedImage, len(m.WatchedImages))
		for idx, v := range m.WatchedImages {
			cloned.WatchedImages[idx] = v.Clone()
		}
	}
	return cloned
}

// ScanImageInternalResponseDetails contains proto messages that are added to details
// when returning errors from the ScanImageInternal endpoint.
type ScanImageInternalResponseDetails struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ScanImageInternalResponseDetails) Reset()         { *m = ScanImageInternalResponseDetails{} }
func (m *ScanImageInternalResponseDetails) String() string { return proto.CompactTextString(m) }
func (*ScanImageInternalResponseDetails) ProtoMessage()    {}
func (*ScanImageInternalResponseDetails) Descriptor() ([]byte, []int) {
	return fileDescriptor_b4306cfe43028263, []int{13}
}
func (m *ScanImageInternalResponseDetails) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ScanImageInternalResponseDetails) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ScanImageInternalResponseDetails.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ScanImageInternalResponseDetails) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScanImageInternalResponseDetails.Merge(m, src)
}
func (m *ScanImageInternalResponseDetails) XXX_Size() int {
	return m.Size()
}
func (m *ScanImageInternalResponseDetails) XXX_DiscardUnknown() {
	xxx_messageInfo_ScanImageInternalResponseDetails.DiscardUnknown(m)
}

var xxx_messageInfo_ScanImageInternalResponseDetails proto.InternalMessageInfo

func (m *ScanImageInternalResponseDetails) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ScanImageInternalResponseDetails) Clone() *ScanImageInternalResponseDetails {
	if m == nil {
		return nil
	}
	cloned := new(ScanImageInternalResponseDetails)
	*cloned = *m

	return cloned
}

// TooManyParallelScans tells sensor that there are too many parallel scans, and that it will need to
// retry later.
type ScanImageInternalResponseDetails_TooManyParallelScans struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ScanImageInternalResponseDetails_TooManyParallelScans) Reset() {
	*m = ScanImageInternalResponseDetails_TooManyParallelScans{}
}
func (m *ScanImageInternalResponseDetails_TooManyParallelScans) String() string {
	return proto.CompactTextString(m)
}
func (*ScanImageInternalResponseDetails_TooManyParallelScans) ProtoMessage() {}
func (*ScanImageInternalResponseDetails_TooManyParallelScans) Descriptor() ([]byte, []int) {
	return fileDescriptor_b4306cfe43028263, []int{13, 0}
}
func (m *ScanImageInternalResponseDetails_TooManyParallelScans) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ScanImageInternalResponseDetails_TooManyParallelScans) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ScanImageInternalResponseDetails_TooManyParallelScans.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ScanImageInternalResponseDetails_TooManyParallelScans) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScanImageInternalResponseDetails_TooManyParallelScans.Merge(m, src)
}
func (m *ScanImageInternalResponseDetails_TooManyParallelScans) XXX_Size() int {
	return m.Size()
}
func (m *ScanImageInternalResponseDetails_TooManyParallelScans) XXX_DiscardUnknown() {
	xxx_messageInfo_ScanImageInternalResponseDetails_TooManyParallelScans.DiscardUnknown(m)
}

var xxx_messageInfo_ScanImageInternalResponseDetails_TooManyParallelScans proto.InternalMessageInfo

func (m *ScanImageInternalResponseDetails_TooManyParallelScans) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ScanImageInternalResponseDetails_TooManyParallelScans) Clone() *ScanImageInternalResponseDetails_TooManyParallelScans {
	if m == nil {
		return nil
	}
	cloned := new(ScanImageInternalResponseDetails_TooManyParallelScans)
	*cloned = *m

	return cloned
}

func init() {
	proto.RegisterEnum("v1.WatchImageResponse_ErrorType", WatchImageResponse_ErrorType_name, WatchImageResponse_ErrorType_value)
	proto.RegisterType((*GetImageRequest)(nil), "v1.GetImageRequest")
	proto.RegisterType((*ListImagesResponse)(nil), "v1.ListImagesResponse")
	proto.RegisterType((*CountImagesResponse)(nil), "v1.CountImagesResponse")
	proto.RegisterType((*ScanImageRequest)(nil), "v1.ScanImageRequest")
	proto.RegisterType((*ScanImageInternalRequest)(nil), "v1.ScanImageInternalRequest")
	proto.RegisterType((*ScanImageInternalResponse)(nil), "v1.ScanImageInternalResponse")
	proto.RegisterType((*GetImageVulnerabilitiesInternalRequest)(nil), "v1.GetImageVulnerabilitiesInternalRequest")
	proto.RegisterType((*DeleteImagesRequest)(nil), "v1.DeleteImagesRequest")
	proto.RegisterType((*DeleteImagesResponse)(nil), "v1.DeleteImagesResponse")
	proto.RegisterType((*WatchImageRequest)(nil), "v1.WatchImageRequest")
	proto.RegisterType((*WatchImageResponse)(nil), "v1.WatchImageResponse")
	proto.RegisterType((*UnwatchImageRequest)(nil), "v1.UnwatchImageRequest")
	proto.RegisterType((*GetWatchedImagesResponse)(nil), "v1.GetWatchedImagesResponse")
	proto.RegisterType((*ScanImageInternalResponseDetails)(nil), "v1.ScanImageInternalResponseDetails")
	proto.RegisterType((*ScanImageInternalResponseDetails_TooManyParallelScans)(nil), "v1.ScanImageInternalResponseDetails.TooManyParallelScans")
}

func init() { proto.RegisterFile("api/v1/image_service.proto", fileDescriptor_b4306cfe43028263) }

var fileDescriptor_b4306cfe43028263 = []byte{
	// 1201 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x56, 0xdd, 0x6e, 0x1b, 0x45,
	0x14, 0xae, 0xed, 0xe6, 0xef, 0xd8, 0x75, 0x9c, 0x49, 0x9a, 0x6c, 0xdc, 0x34, 0x89, 0xb6, 0x40,
	0x43, 0x2a, 0x1c, 0xd9, 0x88, 0x9b, 0x0a, 0x09, 0x4c, 0xe2, 0x06, 0xa3, 0xd8, 0x29, 0x9b, 0x34,
	0x14, 0x54, 0x69, 0x35, 0xdd, 0x9d, 0xa6, 0x2b, 0xd6, 0x33, 0xdb, 0x99, 0xb1, 0x83, 0x8b, 0xb8,
	0x80, 0x57, 0xe0, 0x86, 0xe7, 0x40, 0xe2, 0x1d, 0xb8, 0x44, 0xe2, 0x05, 0x50, 0xe0, 0x41, 0xd0,
	0xce, 0x8c, 0xd7, 0xbb, 0xb6, 0x4b, 0xb9, 0xdb, 0x39, 0x3f, 0xdf, 0x99, 0xf3, 0x9d, 0x9f, 0x59,
	0xa8, 0xe2, 0x28, 0x38, 0x18, 0xd4, 0x0f, 0x82, 0x1e, 0xbe, 0x24, 0xae, 0x20, 0x7c, 0x10, 0x78,
	0xa4, 0x16, 0x71, 0x26, 0x19, 0xca, 0x0f, 0xea, 0xd5, 0xad, 0x4b, 0xc6, 0x2e, 0x43, 0x72, 0x10,
	0x9b, 0x61, 0x4a, 0x99, 0xc4, 0x32, 0x60, 0x54, 0x68, 0x8b, 0xea, 0x1d, 0xe3, 0x2d, 0x08, 0xe6,
	0xde, 0xcb, 0xac, 0x7b, 0x15, 0x19, 0x25, 0xe9, 0x45, 0x72, 0x68, 0x64, 0xdb, 0xc2, 0xc3, 0x94,
	0x12, 0x7e, 0x60, 0x74, 0x1e, 0xeb, 0x45, 0x8c, 0x12, 0x2a, 0x8d, 0x7e, 0x73, 0x42, 0x4f, 0x99,
	0x1c, 0xc1, 0xad, 0x0a, 0xc9, 0x38, 0xbe, 0x24, 0xfa, 0xaa, 0x46, 0x68, 0x8d, 0x84, 0x3e, 0x89,
	0x42, 0x36, 0xec, 0x25, 0x48, 0xf6, 0x15, 0x2c, 0x1f, 0x13, 0xd9, 0x8e, 0x6d, 0x1d, 0xf2, 0xaa,
	0x4f, 0x84, 0x44, 0x65, 0xc8, 0x07, 0xbe, 0x95, 0xdb, 0xcd, 0xed, 0x2d, 0x39, 0xf9, 0xc0, 0x47,
	0xf7, 0x61, 0x39, 0xa0, 0x5e, 0xd8, 0xf7, 0x89, 0x2b, 0x28, 0x63, 0xaf, 0x89, 0x6f, 0xe5, 0x77,
	0x73, 0x7b, 0x8b, 0x4e, 0xd9, 0x88, 0xcf, 0xb4, 0x14, 0x3d, 0x80, 0x15, 0x21, 0x79, 0x10, 0xb9,
	0x3e, 0x11, 0x1e, 0x0f, 0xa2, 0x98, 0x02, 0xab, 0xa0, 0x4c, 0x2b, 0x4a, 0x71, 0x34, 0x96, 0xdb,
	0x9f, 0x02, 0x3a, 0x09, 0x84, 0x8e, 0x2c, 0x1c, 0x22, 0x22, 0x46, 0x05, 0x41, 0xfb, 0x30, 0xaf,
	0xee, 0x2d, 0xac, 0xdc, 0x6e, 0x61, 0xaf, 0xd8, 0x40, 0x35, 0x73, 0xf3, 0x5a, 0x62, 0xec, 0x18,
	0x0b, 0xfb, 0x01, 0xac, 0x1e, 0xb2, 0x3e, 0x9d, 0x84, 0x58, 0x83, 0x39, 0x2f, 0x16, 0xab, 0x0c,
	0xe6, 0x1c, 0x7d, 0xb0, 0x23, 0xa8, 0x9c, 0x79, 0x98, 0x66, 0x12, 0xbd, 0x0b, 0xa0, 0xeb, 0x49,
	0x71, 0x8f, 0x98, 0x84, 0x97, 0x94, 0xa4, 0x8b, 0x7b, 0x0a, 0xe8, 0x05, 0xe3, 0x1e, 0x31, 0xd9,
	0xea, 0xc3, 0x2c, 0x36, 0x0a, 0xb3, 0xd8, 0xb0, 0x23, 0xb0, 0x92, 0x88, 0x6d, 0x2a, 0x09, 0xa7,
	0x38, 0x1c, 0x45, 0xfe, 0x00, 0xe6, 0x54, 0x1c, 0x15, 0xb4, 0xd8, 0xd8, 0x48, 0xb2, 0x3c, 0x64,
	0x54, 0xe2, 0x80, 0x12, 0xae, 0x2f, 0xaa, 0xad, 0xd0, 0x0e, 0x14, 0x3d, 0xec, 0xbd, 0x24, 0xbe,
	0xcb, 0x68, 0x38, 0x34, 0xf1, 0x40, 0x8b, 0x4e, 0x69, 0x38, 0xfc, 0xe2, 0xe6, 0x62, 0xbe, 0x52,
	0xb0, 0x9b, 0xb0, 0x39, 0x23, 0xa2, 0xa1, 0xe5, 0x9d, 0x6c, 0xc8, 0x72, 0x12, 0x32, 0x1d, 0xc9,
	0xfe, 0x35, 0x0f, 0xef, 0x8d, 0xfa, 0xe1, 0xa2, 0x1f, 0x52, 0xc2, 0xf1, 0xf3, 0x20, 0x0c, 0x64,
	0x40, 0xc4, 0x64, 0x0e, 0x9b, 0xb0, 0xa8, 0xd9, 0x4b, 0x9a, 0x65, 0x41, 0x9d, 0xdb, 0x3e, 0xaa,
	0x67, 0x88, 0xcd, 0xab, 0x80, 0x28, 0x1b, 0x30, 0x66, 0x38, 0x4d, 0x76, 0x03, 0x16, 0x7b, 0x44,
	0x62, 0x1f, 0x4b, 0xac, 0xf2, 0x2b, 0x36, 0xd6, 0xb3, 0x0e, 0x1d, 0xa3, 0x75, 0x12, 0x3b, 0xb4,
	0x07, 0x95, 0x40, 0xb8, 0x5e, 0xd8, 0x17, 0x92, 0x70, 0x37, 0x64, 0x1e, 0x0e, 0xad, 0x79, 0x53,
	0x0b, 0x71, 0xa8, 0xc5, 0x27, 0xb1, 0x14, 0x7d, 0x04, 0x90, 0x8c, 0x90, 0xb0, 0x6e, 0x2a, 0xfc,
	0xdb, 0x35, 0x33, 0x44, 0x17, 0xf5, 0xda, 0x61, 0xa2, 0x74, 0x52, 0x86, 0xe8, 0x5d, 0x98, 0x8b,
	0x27, 0x4b, 0x58, 0x73, 0xbb, 0x85, 0xbd, 0x72, 0x63, 0x39, 0xe5, 0xd1, 0x65, 0x92, 0x38, 0x5a,
	0x6b, 0x9f, 0xc1, 0xea, 0x11, 0x09, 0x89, 0x24, 0xa3, 0x4e, 0xd4, 0x04, 0xd9, 0x30, 0xf7, 0xaa,
	0x4f, 0xf8, 0xd0, 0x30, 0x5e, 0xaa, 0x0d, 0xea, 0x35, 0x07, 0x5f, 0x7d, 0x19, 0xcb, 0x1c, 0xad,
	0x42, 0x16, 0x2c, 0x78, 0x8c, 0xbe, 0x08, 0x78, 0xcf, 0x74, 0xd9, 0xe8, 0x68, 0x3f, 0x86, 0xb5,
	0x2c, 0xa8, 0xa9, 0xe3, 0x0e, 0x14, 0x69, 0xbf, 0xe7, 0xfa, 0x4a, 0xa7, 0x99, 0xbf, 0xe5, 0x00,
	0xed, 0xf7, 0xb4, 0xb5, 0x8f, 0x36, 0x60, 0xc1, 0xe7, 0x43, 0x97, 0xf7, 0xa9, 0x81, 0x9c, 0xf7,
	0xf9, 0xd0, 0xe9, 0x53, 0xfb, 0x3e, 0xac, 0x7c, 0x85, 0xa5, 0xf7, 0x32, 0x33, 0x03, 0x08, 0x6e,
	0xa6, 0xba, 0x5f, 0x7d, 0xdb, 0x3f, 0xe6, 0x01, 0xa5, 0x2d, 0x4d, 0xe4, 0xfb, 0xb0, 0x4c, 0x19,
	0xef, 0xe1, 0x30, 0x78, 0x4d, 0xfc, 0xf4, 0xcc, 0x94, 0xc7, 0x62, 0x55, 0xcb, 0x4f, 0x00, 0x08,
	0xe7, 0x8c, 0xbb, 0x72, 0x18, 0xe9, 0xf2, 0x97, 0x1b, 0xbb, 0x71, 0xf6, 0xd3, 0xa0, 0xb5, 0x56,
	0x6c, 0x78, 0x3e, 0x8c, 0x88, 0xb3, 0x44, 0x46, 0x9f, 0xe8, 0x1e, 0xdc, 0xd2, 0x00, 0x3d, 0x22,
	0x44, 0xdc, 0xb3, 0x05, 0x15, 0xa7, 0xa4, 0x84, 0x1d, 0x2d, 0xb3, 0x9f, 0xc1, 0x52, 0xe2, 0x8c,
	0x4a, 0xb0, 0xd8, 0x3d, 0x75, 0x5b, 0x8e, 0x73, 0xea, 0x54, 0x6e, 0xa0, 0x75, 0x40, 0xed, 0xee,
	0x45, 0xf3, 0xa4, 0x7d, 0xe4, 0xb6, 0x3b, 0xcd, 0xe3, 0x96, 0xdb, 0x6d, 0x76, 0x5a, 0x95, 0x1c,
	0xb2, 0x60, 0xad, 0x7b, 0xea, 0x1a, 0x45, 0xf7, 0xbc, 0x75, 0xec, 0x34, 0xcf, 0xdb, 0xa7, 0xdd,
	0x4a, 0x1e, 0x2d, 0x43, 0xf1, 0xec, 0xb0, 0xd9, 0x75, 0x1f, 0x35, 0xdb, 0x27, 0xad, 0xa3, 0x4a,
	0xc1, 0x7e, 0x1f, 0x56, 0x9f, 0xd0, 0xab, 0xff, 0x45, 0xd7, 0x53, 0xb0, 0x8e, 0x89, 0x54, 0xb9,
	0x11, 0x7f, 0xa2, 0x5a, 0x1f, 0x43, 0xf9, 0x4a, 0x2b, 0xdc, 0xcc, 0x5e, 0xbb, 0x9d, 0x34, 0x77,
	0xda, 0xcf, 0xb9, 0x75, 0x95, 0x46, 0xb1, 0x1f, 0xc2, 0xee, 0x1b, 0x07, 0xfa, 0x88, 0x48, 0x1c,
	0x84, 0xa2, 0xba, 0x0e, 0x6b, 0xe7, 0x8c, 0x75, 0x30, 0x1d, 0x3e, 0xc6, 0x1c, 0x87, 0x21, 0x09,
	0x63, 0x17, 0xd1, 0xf8, 0x6d, 0x01, 0x4a, 0xca, 0xf1, 0x4c, 0xbf, 0x36, 0xe8, 0x73, 0x58, 0x1c,
	0x4d, 0x36, 0x5a, 0x8d, 0xab, 0x31, 0xb1, 0xf7, 0xab, 0x13, 0x2b, 0xc1, 0xde, 0xf8, 0xe9, 0xcf,
	0x7f, 0x7e, 0xce, 0xaf, 0xa0, 0xe5, 0xe4, 0xe1, 0x13, 0x07, 0xdf, 0x07, 0xfe, 0x0f, 0xa8, 0x03,
	0xc5, 0xd4, 0xe2, 0x45, 0x99, 0xc6, 0xae, 0x6e, 0xc4, 0xa7, 0x19, 0x7b, 0x79, 0x16, 0x9c, 0x5a,
	0xcd, 0xe8, 0x11, 0xc0, 0xf8, 0x25, 0x98, 0x40, 0x5b, 0x8f, 0x4f, 0xd3, 0xef, 0x84, 0x8d, 0x14,
	0x58, 0x09, 0xc1, 0x18, 0x0c, 0x75, 0x60, 0x29, 0x61, 0x0b, 0xad, 0xc5, 0x8e, 0x93, 0x1b, 0x7f,
	0x2a, 0xc5, 0xaa, 0x82, 0x59, 0xb3, 0xd3, 0x29, 0xc6, 0x33, 0xfe, 0x30, 0xb7, 0x8f, 0x1e, 0xc3,
	0xca, 0x14, 0xf9, 0x68, 0x2b, 0x03, 0x3b, 0xb1, 0x12, 0xab, 0x77, 0xdf, 0xa0, 0x35, 0xcd, 0x10,
	0xc2, 0xce, 0x5b, 0x76, 0x2b, 0xda, 0x4f, 0x17, 0xe6, 0xbf, 0x17, 0xf0, 0xdb, 0xa2, 0x3d, 0x83,
	0x9d, 0x36, 0x1d, 0xe0, 0x30, 0xf0, 0xb1, 0x24, 0xb1, 0x59, 0x93, 0xfa, 0x0e, 0xb9, 0x0c, 0x84,
	0xe4, 0xc3, 0xc3, 0xf8, 0xe9, 0x10, 0x68, 0x29, 0x46, 0x68, 0xc5, 0xff, 0x1d, 0xd5, 0xf1, 0xa7,
	0x7d, 0x4f, 0x91, 0x72, 0x17, 0xdd, 0x49, 0x91, 0xa2, 0xde, 0x9a, 0x83, 0x20, 0xc1, 0x43, 0x4f,
	0xa0, 0x94, 0x5e, 0x4f, 0x48, 0x95, 0x7d, 0xc6, 0x16, 0xac, 0x5a, 0xd3, 0x8a, 0x6c, 0x0d, 0xf7,
	0xd3, 0x35, 0xfc, 0x1a, 0x60, 0xbc, 0x24, 0xd0, 0xed, 0xc9, 0xa5, 0xa1, 0x21, 0xd7, 0x67, 0xef,
	0x12, 0x7b, 0x4b, 0x01, 0xae, 0xdb, 0x2b, 0x31, 0xa0, 0x99, 0x24, 0x8d, 0x1b, 0xd7, 0xb3, 0x03,
	0xa5, 0xf4, 0x44, 0xeb, 0x1b, 0xcf, 0x98, 0xf1, 0x34, 0x15, 0x9b, 0x0a, 0x71, 0x75, 0x7f, 0x1a,
	0x11, 0x5d, 0x40, 0x65, 0x72, 0xea, 0xd3, 0x7c, 0x6e, 0x99, 0x42, 0xce, 0x5c, 0x0b, 0x23, 0x5c,
	0x34, 0x8d, 0xfb, 0x59, 0xed, 0xf7, 0xeb, 0xed, 0xdc, 0x1f, 0xd7, 0xdb, 0xb9, 0xbf, 0xae, 0xb7,
	0x73, 0xbf, 0xfc, 0xbd, 0x7d, 0x03, 0xac, 0x80, 0xd5, 0x84, 0xc4, 0xde, 0xb7, 0x9c, 0x7d, 0xa7,
	0xff, 0xda, 0x6a, 0x38, 0x0a, 0x6a, 0x83, 0xfa, 0x37, 0xf9, 0x41, 0xfd, 0xe9, 0x8d, 0xe7, 0xf3,
	0x4a, 0xf6, 0xe1, 0xbf, 0x01, 0x00, 0x00, 0xff, 0xff, 0x3e, 0x58, 0x4f, 0x2f, 0xa4, 0x0a, 0x00,
	0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ImageServiceClient is the client API for ImageService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConnInterface.NewStream.
type ImageServiceClient interface {
	// GetImage returns the image given its ID.
	GetImage(ctx context.Context, in *GetImageRequest, opts ...grpc.CallOption) (*storage.Image, error)
	// ListImages returns all the images.
	CountImages(ctx context.Context, in *RawQuery, opts ...grpc.CallOption) (*CountImagesResponse, error)
	// ListImages returns all the images.
	ListImages(ctx context.Context, in *RawQuery, opts ...grpc.CallOption) (*ListImagesResponse, error)
	// ScanImage scans a single image and returns the result
	ScanImage(ctx context.Context, in *ScanImageRequest, opts ...grpc.CallOption) (*storage.Image, error)
	// ScanImageInternal is used solely by the Sensor and Admission Controller to send scan requests
	ScanImageInternal(ctx context.Context, in *ScanImageInternalRequest, opts ...grpc.CallOption) (*ScanImageInternalResponse, error)
	// GetImageVulnerabilities is used solely by the Sensor to send vulnerability matching requests.
	GetImageVulnerabilitiesInternal(ctx context.Context, in *GetImageVulnerabilitiesInternalRequest, opts ...grpc.CallOption) (*ScanImageInternalResponse, error)
	// InvalidateScanAndRegistryCaches removes the image metadata cache.
	InvalidateScanAndRegistryCaches(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*Empty, error)
	// DeleteImage removes the images based on a query
	DeleteImages(ctx context.Context, in *DeleteImagesRequest, opts ...grpc.CallOption) (*DeleteImagesResponse, error)
	// WatchImage marks an image name as to be watched.
	WatchImage(ctx context.Context, in *WatchImageRequest, opts ...grpc.CallOption) (*WatchImageResponse, error)
	// UnwatchImage marks an image name to no longer be watched.
	// It returns successfully if the image is no longer being watched
	// after the call, irrespective of whether the image was already being watched.
	UnwatchImage(ctx context.Context, in *UnwatchImageRequest, opts ...grpc.CallOption) (*Empty, error)
	// GetWatchedImages returns the list of image names that are currently
	// being watched.
	GetWatchedImages(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*GetWatchedImagesResponse, error)
}

type imageServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewImageServiceClient(cc grpc.ClientConnInterface) ImageServiceClient {
	return &imageServiceClient{cc}
}

func (c *imageServiceClient) GetImage(ctx context.Context, in *GetImageRequest, opts ...grpc.CallOption) (*storage.Image, error) {
	out := new(storage.Image)
	err := c.cc.Invoke(ctx, "/v1.ImageService/GetImage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageServiceClient) CountImages(ctx context.Context, in *RawQuery, opts ...grpc.CallOption) (*CountImagesResponse, error) {
	out := new(CountImagesResponse)
	err := c.cc.Invoke(ctx, "/v1.ImageService/CountImages", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageServiceClient) ListImages(ctx context.Context, in *RawQuery, opts ...grpc.CallOption) (*ListImagesResponse, error) {
	out := new(ListImagesResponse)
	err := c.cc.Invoke(ctx, "/v1.ImageService/ListImages", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageServiceClient) ScanImage(ctx context.Context, in *ScanImageRequest, opts ...grpc.CallOption) (*storage.Image, error) {
	out := new(storage.Image)
	err := c.cc.Invoke(ctx, "/v1.ImageService/ScanImage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageServiceClient) ScanImageInternal(ctx context.Context, in *ScanImageInternalRequest, opts ...grpc.CallOption) (*ScanImageInternalResponse, error) {
	out := new(ScanImageInternalResponse)
	err := c.cc.Invoke(ctx, "/v1.ImageService/ScanImageInternal", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageServiceClient) GetImageVulnerabilitiesInternal(ctx context.Context, in *GetImageVulnerabilitiesInternalRequest, opts ...grpc.CallOption) (*ScanImageInternalResponse, error) {
	out := new(ScanImageInternalResponse)
	err := c.cc.Invoke(ctx, "/v1.ImageService/GetImageVulnerabilitiesInternal", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageServiceClient) InvalidateScanAndRegistryCaches(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.ImageService/InvalidateScanAndRegistryCaches", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageServiceClient) DeleteImages(ctx context.Context, in *DeleteImagesRequest, opts ...grpc.CallOption) (*DeleteImagesResponse, error) {
	out := new(DeleteImagesResponse)
	err := c.cc.Invoke(ctx, "/v1.ImageService/DeleteImages", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageServiceClient) WatchImage(ctx context.Context, in *WatchImageRequest, opts ...grpc.CallOption) (*WatchImageResponse, error) {
	out := new(WatchImageResponse)
	err := c.cc.Invoke(ctx, "/v1.ImageService/WatchImage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageServiceClient) UnwatchImage(ctx context.Context, in *UnwatchImageRequest, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.ImageService/UnwatchImage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageServiceClient) GetWatchedImages(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*GetWatchedImagesResponse, error) {
	out := new(GetWatchedImagesResponse)
	err := c.cc.Invoke(ctx, "/v1.ImageService/GetWatchedImages", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ImageServiceServer is the server API for ImageService service.
type ImageServiceServer interface {
	// GetImage returns the image given its ID.
	GetImage(context.Context, *GetImageRequest) (*storage.Image, error)
	// ListImages returns all the images.
	CountImages(context.Context, *RawQuery) (*CountImagesResponse, error)
	// ListImages returns all the images.
	ListImages(context.Context, *RawQuery) (*ListImagesResponse, error)
	// ScanImage scans a single image and returns the result
	ScanImage(context.Context, *ScanImageRequest) (*storage.Image, error)
	// ScanImageInternal is used solely by the Sensor and Admission Controller to send scan requests
	ScanImageInternal(context.Context, *ScanImageInternalRequest) (*ScanImageInternalResponse, error)
	// GetImageVulnerabilities is used solely by the Sensor to send vulnerability matching requests.
	GetImageVulnerabilitiesInternal(context.Context, *GetImageVulnerabilitiesInternalRequest) (*ScanImageInternalResponse, error)
	// InvalidateScanAndRegistryCaches removes the image metadata cache.
	InvalidateScanAndRegistryCaches(context.Context, *Empty) (*Empty, error)
	// DeleteImage removes the images based on a query
	DeleteImages(context.Context, *DeleteImagesRequest) (*DeleteImagesResponse, error)
	// WatchImage marks an image name as to be watched.
	WatchImage(context.Context, *WatchImageRequest) (*WatchImageResponse, error)
	// UnwatchImage marks an image name to no longer be watched.
	// It returns successfully if the image is no longer being watched
	// after the call, irrespective of whether the image was already being watched.
	UnwatchImage(context.Context, *UnwatchImageRequest) (*Empty, error)
	// GetWatchedImages returns the list of image names that are currently
	// being watched.
	GetWatchedImages(context.Context, *Empty) (*GetWatchedImagesResponse, error)
}

// UnimplementedImageServiceServer can be embedded to have forward compatible implementations.
type UnimplementedImageServiceServer struct {
}

func (*UnimplementedImageServiceServer) GetImage(ctx context.Context, req *GetImageRequest) (*storage.Image, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetImage not implemented")
}
func (*UnimplementedImageServiceServer) CountImages(ctx context.Context, req *RawQuery) (*CountImagesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CountImages not implemented")
}
func (*UnimplementedImageServiceServer) ListImages(ctx context.Context, req *RawQuery) (*ListImagesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListImages not implemented")
}
func (*UnimplementedImageServiceServer) ScanImage(ctx context.Context, req *ScanImageRequest) (*storage.Image, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ScanImage not implemented")
}
func (*UnimplementedImageServiceServer) ScanImageInternal(ctx context.Context, req *ScanImageInternalRequest) (*ScanImageInternalResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ScanImageInternal not implemented")
}
func (*UnimplementedImageServiceServer) GetImageVulnerabilitiesInternal(ctx context.Context, req *GetImageVulnerabilitiesInternalRequest) (*ScanImageInternalResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetImageVulnerabilitiesInternal not implemented")
}
func (*UnimplementedImageServiceServer) InvalidateScanAndRegistryCaches(ctx context.Context, req *Empty) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InvalidateScanAndRegistryCaches not implemented")
}
func (*UnimplementedImageServiceServer) DeleteImages(ctx context.Context, req *DeleteImagesRequest) (*DeleteImagesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteImages not implemented")
}
func (*UnimplementedImageServiceServer) WatchImage(ctx context.Context, req *WatchImageRequest) (*WatchImageResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method WatchImage not implemented")
}
func (*UnimplementedImageServiceServer) UnwatchImage(ctx context.Context, req *UnwatchImageRequest) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UnwatchImage not implemented")
}
func (*UnimplementedImageServiceServer) GetWatchedImages(ctx context.Context, req *Empty) (*GetWatchedImagesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetWatchedImages not implemented")
}

func RegisterImageServiceServer(s *grpc.Server, srv ImageServiceServer) {
	s.RegisterService(&_ImageService_serviceDesc, srv)
}

func _ImageService_GetImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageServiceServer).GetImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ImageService/GetImage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageServiceServer).GetImage(ctx, req.(*GetImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageService_CountImages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RawQuery)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageServiceServer).CountImages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ImageService/CountImages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageServiceServer).CountImages(ctx, req.(*RawQuery))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageService_ListImages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RawQuery)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageServiceServer).ListImages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ImageService/ListImages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageServiceServer).ListImages(ctx, req.(*RawQuery))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageService_ScanImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ScanImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageServiceServer).ScanImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ImageService/ScanImage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageServiceServer).ScanImage(ctx, req.(*ScanImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageService_ScanImageInternal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ScanImageInternalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageServiceServer).ScanImageInternal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ImageService/ScanImageInternal",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageServiceServer).ScanImageInternal(ctx, req.(*ScanImageInternalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageService_GetImageVulnerabilitiesInternal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetImageVulnerabilitiesInternalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageServiceServer).GetImageVulnerabilitiesInternal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ImageService/GetImageVulnerabilitiesInternal",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageServiceServer).GetImageVulnerabilitiesInternal(ctx, req.(*GetImageVulnerabilitiesInternalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageService_InvalidateScanAndRegistryCaches_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageServiceServer).InvalidateScanAndRegistryCaches(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ImageService/InvalidateScanAndRegistryCaches",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageServiceServer).InvalidateScanAndRegistryCaches(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageService_DeleteImages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteImagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageServiceServer).DeleteImages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ImageService/DeleteImages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageServiceServer).DeleteImages(ctx, req.(*DeleteImagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageService_WatchImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WatchImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageServiceServer).WatchImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ImageService/WatchImage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageServiceServer).WatchImage(ctx, req.(*WatchImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageService_UnwatchImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UnwatchImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageServiceServer).UnwatchImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ImageService/UnwatchImage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageServiceServer).UnwatchImage(ctx, req.(*UnwatchImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageService_GetWatchedImages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageServiceServer).GetWatchedImages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ImageService/GetWatchedImages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageServiceServer).GetWatchedImages(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

var _ImageService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1.ImageService",
	HandlerType: (*ImageServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetImage",
			Handler:    _ImageService_GetImage_Handler,
		},
		{
			MethodName: "CountImages",
			Handler:    _ImageService_CountImages_Handler,
		},
		{
			MethodName: "ListImages",
			Handler:    _ImageService_ListImages_Handler,
		},
		{
			MethodName: "ScanImage",
			Handler:    _ImageService_ScanImage_Handler,
		},
		{
			MethodName: "ScanImageInternal",
			Handler:    _ImageService_ScanImageInternal_Handler,
		},
		{
			MethodName: "GetImageVulnerabilitiesInternal",
			Handler:    _ImageService_GetImageVulnerabilitiesInternal_Handler,
		},
		{
			MethodName: "InvalidateScanAndRegistryCaches",
			Handler:    _ImageService_InvalidateScanAndRegistryCaches_Handler,
		},
		{
			MethodName: "DeleteImages",
			Handler:    _ImageService_DeleteImages_Handler,
		},
		{
			MethodName: "WatchImage",
			Handler:    _ImageService_WatchImage_Handler,
		},
		{
			MethodName: "UnwatchImage",
			Handler:    _ImageService_UnwatchImage_Handler,
		},
		{
			MethodName: "GetWatchedImages",
			Handler:    _ImageService_GetWatchedImages_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/v1/image_service.proto",
}

func (m *GetImageRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetImageRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetImageRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.StripDescription {
		i--
		if m.StripDescription {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.IncludeSnoozed {
		i--
		if m.IncludeSnoozed {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintImageService(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ListImagesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListImagesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListImagesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Images) > 0 {
		for iNdEx := len(m.Images) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Images[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintImageService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *CountImagesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CountImagesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CountImagesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Count != 0 {
		i = encodeVarintImageService(dAtA, i, uint64(m.Count))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ScanImageRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ScanImageRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScanImageRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.IncludeSnoozed {
		i--
		if m.IncludeSnoozed {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.Force {
		i--
		if m.Force {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.ImageName) > 0 {
		i -= len(m.ImageName)
		copy(dAtA[i:], m.ImageName)
		i = encodeVarintImageService(dAtA, i, uint64(len(m.ImageName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ScanImageInternalRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ScanImageInternalRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScanImageInternalRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.CachedOnly {
		i--
		if m.CachedOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.Image != nil {
		{
			size, err := m.Image.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintImageService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ScanImageInternalResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ScanImageInternalResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScanImageInternalResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Image != nil {
		{
			size, err := m.Image.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintImageService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetImageVulnerabilitiesInternalRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetImageVulnerabilitiesInternalRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetImageVulnerabilitiesInternalRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.IsClusterLocal {
		i--
		if m.IsClusterLocal {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if len(m.Notes) > 0 {
		dAtA4 := make([]byte, len(m.Notes)*10)
		var j3 int
		for _, num := range m.Notes {
			for num >= 1<<7 {
				dAtA4[j3] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j3++
			}
			dAtA4[j3] = uint8(num)
			j3++
		}
		i -= j3
		copy(dAtA[i:], dAtA4[:j3])
		i = encodeVarintImageService(dAtA, i, uint64(j3))
		i--
		dAtA[i] = 0x2a
	}
	if m.Components != nil {
		{
			size, err := m.Components.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintImageService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintImageService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.ImageName != nil {
		{
			size, err := m.ImageName.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintImageService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.ImageId) > 0 {
		i -= len(m.ImageId)
		copy(dAtA[i:], m.ImageId)
		i = encodeVarintImageService(dAtA, i, uint64(len(m.ImageId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DeleteImagesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeleteImagesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeleteImagesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Confirm {
		i--
		if m.Confirm {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if m.Query != nil {
		{
			size, err := m.Query.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintImageService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DeleteImagesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeleteImagesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeleteImagesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.DryRun {
		i--
		if m.DryRun {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if m.NumDeleted != 0 {
		i = encodeVarintImageService(dAtA, i, uint64(m.NumDeleted))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *WatchImageRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WatchImageRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WatchImageRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintImageService(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *WatchImageResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WatchImageResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WatchImageResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ErrorMessage) > 0 {
		i -= len(m.ErrorMessage)
		copy(dAtA[i:], m.ErrorMessage)
		i = encodeVarintImageService(dAtA, i, uint64(len(m.ErrorMessage)))
		i--
		dAtA[i] = 0x1a
	}
	if m.ErrorType != 0 {
		i = encodeVarintImageService(dAtA, i, uint64(m.ErrorType))
		i--
		dAtA[i] = 0x10
	}
	if len(m.NormalizedName) > 0 {
		i -= len(m.NormalizedName)
		copy(dAtA[i:], m.NormalizedName)
		i = encodeVarintImageService(dAtA, i, uint64(len(m.NormalizedName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *UnwatchImageRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UnwatchImageRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UnwatchImageRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintImageService(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetWatchedImagesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetWatchedImagesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetWatchedImagesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.WatchedImages) > 0 {
		for iNdEx := len(m.WatchedImages) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.WatchedImages[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintImageService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ScanImageInternalResponseDetails) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ScanImageInternalResponseDetails) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScanImageInternalResponseDetails) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *ScanImageInternalResponseDetails_TooManyParallelScans) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ScanImageInternalResponseDetails_TooManyParallelScans) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScanImageInternalResponseDetails_TooManyParallelScans) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func encodeVarintImageService(dAtA []byte, offset int, v uint64) int {
	offset -= sovImageService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *GetImageRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovImageService(uint64(l))
	}
	if m.IncludeSnoozed {
		n += 2
	}
	if m.StripDescription {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListImagesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Images) > 0 {
		for _, e := range m.Images {
			l = e.Size()
			n += 1 + l + sovImageService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CountImagesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Count != 0 {
		n += 1 + sovImageService(uint64(m.Count))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ScanImageRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ImageName)
	if l > 0 {
		n += 1 + l + sovImageService(uint64(l))
	}
	if m.Force {
		n += 2
	}
	if m.IncludeSnoozed {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ScanImageInternalRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Image != nil {
		l = m.Image.Size()
		n += 1 + l + sovImageService(uint64(l))
	}
	if m.CachedOnly {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ScanImageInternalResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Image != nil {
		l = m.Image.Size()
		n += 1 + l + sovImageService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetImageVulnerabilitiesInternalRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ImageId)
	if l > 0 {
		n += 1 + l + sovImageService(uint64(l))
	}
	if m.ImageName != nil {
		l = m.ImageName.Size()
		n += 1 + l + sovImageService(uint64(l))
	}
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovImageService(uint64(l))
	}
	if m.Components != nil {
		l = m.Components.Size()
		n += 1 + l + sovImageService(uint64(l))
	}
	if len(m.Notes) > 0 {
		l = 0
		for _, e := range m.Notes {
			l += sovImageService(uint64(e))
		}
		n += 1 + sovImageService(uint64(l)) + l
	}
	if m.IsClusterLocal {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeleteImagesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Query != nil {
		l = m.Query.Size()
		n += 1 + l + sovImageService(uint64(l))
	}
	if m.Confirm {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeleteImagesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.NumDeleted != 0 {
		n += 1 + sovImageService(uint64(m.NumDeleted))
	}
	if m.DryRun {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *WatchImageRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovImageService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *WatchImageResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NormalizedName)
	if l > 0 {
		n += 1 + l + sovImageService(uint64(l))
	}
	if m.ErrorType != 0 {
		n += 1 + sovImageService(uint64(m.ErrorType))
	}
	l = len(m.ErrorMessage)
	if l > 0 {
		n += 1 + l + sovImageService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *UnwatchImageRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovImageService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetWatchedImagesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.WatchedImages) > 0 {
		for _, e := range m.WatchedImages {
			l = e.Size()
			n += 1 + l + sovImageService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ScanImageInternalResponseDetails) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ScanImageInternalResponseDetails_TooManyParallelScans) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovImageService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozImageService(x uint64) (n int) {
	return sovImageService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *GetImageRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImageService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetImageRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetImageRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IncludeSnoozed", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IncludeSnoozed = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StripDescription", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.StripDescription = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipImageService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImageService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListImagesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImageService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListImagesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListImagesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Images", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImageService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImageService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Images = append(m.Images, &storage.ListImage{})
			if err := m.Images[len(m.Images)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipImageService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImageService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CountImagesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImageService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CountImagesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CountImagesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Count", wireType)
			}
			m.Count = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Count |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipImageService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImageService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ScanImageRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImageService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ScanImageRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ScanImageRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ImageName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ImageName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Force", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Force = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IncludeSnoozed", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IncludeSnoozed = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipImageService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImageService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ScanImageInternalRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImageService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ScanImageInternalRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ScanImageInternalRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Image", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImageService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImageService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Image == nil {
				m.Image = &storage.ContainerImage{}
			}
			if err := m.Image.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CachedOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.CachedOnly = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipImageService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImageService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ScanImageInternalResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImageService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ScanImageInternalResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ScanImageInternalResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Image", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImageService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImageService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Image == nil {
				m.Image = &storage.Image{}
			}
			if err := m.Image.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipImageService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImageService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetImageVulnerabilitiesInternalRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImageService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetImageVulnerabilitiesInternalRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetImageVulnerabilitiesInternalRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ImageId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ImageId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ImageName", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImageService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImageService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ImageName == nil {
				m.ImageName = &storage.ImageName{}
			}
			if err := m.ImageName.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImageService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImageService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &storage.ImageMetadata{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Components", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImageService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImageService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Components == nil {
				m.Components = &v1.Components{}
			}
			if err := m.Components.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType == 0 {
				var v v1.Note
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowImageService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= v1.Note(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Notes = append(m.Notes, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowImageService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthImageService
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthImageService
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				if elementCount != 0 && len(m.Notes) == 0 {
					m.Notes = make([]v1.Note, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v v1.Note
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowImageService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= v1.Note(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Notes = append(m.Notes, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Notes", wireType)
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsClusterLocal", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsClusterLocal = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipImageService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImageService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeleteImagesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImageService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeleteImagesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeleteImagesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImageService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImageService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Query == nil {
				m.Query = &RawQuery{}
			}
			if err := m.Query.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Confirm", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Confirm = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipImageService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImageService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeleteImagesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImageService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeleteImagesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeleteImagesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumDeleted", wireType)
			}
			m.NumDeleted = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumDeleted |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DryRun", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DryRun = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipImageService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImageService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WatchImageRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImageService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WatchImageRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WatchImageRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipImageService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImageService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WatchImageResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImageService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WatchImageResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WatchImageResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NormalizedName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NormalizedName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorType", wireType)
			}
			m.ErrorType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ErrorType |= WatchImageResponse_ErrorType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorMessage", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ErrorMessage = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipImageService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImageService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UnwatchImageRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImageService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UnwatchImageRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UnwatchImageRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthImageService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthImageService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipImageService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImageService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetWatchedImagesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImageService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetWatchedImagesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetWatchedImagesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WatchedImages", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowImageService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthImageService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthImageService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WatchedImages = append(m.WatchedImages, &storage.WatchedImage{})
			if err := m.WatchedImages[len(m.WatchedImages)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipImageService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImageService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ScanImageInternalResponseDetails) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImageService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ScanImageInternalResponseDetails: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ScanImageInternalResponseDetails: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipImageService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImageService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ScanImageInternalResponseDetails_TooManyParallelScans) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowImageService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TooManyParallelScans: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TooManyParallelScans: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipImageService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthImageService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipImageService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowImageService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowImageService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowImageService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthImageService
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupImageService
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthImageService
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthImageService        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowImageService          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupImageService = fmt.Errorf("proto: unexpected end of group")
)
