// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api/v1/integration_health_service.proto

package v1

import (
	context "context"
	fmt "fmt"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	storage "github.com/stackrox/rox/generated/storage"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type GetIntegrationHealthResponse struct {
	IntegrationHealth    []*storage.IntegrationHealth `protobuf:"bytes,1,rep,name=integrationHealth,proto3" json:"integrationHealth,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *GetIntegrationHealthResponse) Reset()         { *m = GetIntegrationHealthResponse{} }
func (m *GetIntegrationHealthResponse) String() string { return proto.CompactTextString(m) }
func (*GetIntegrationHealthResponse) ProtoMessage()    {}
func (*GetIntegrationHealthResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_4c40da462e693fb8, []int{0}
}
func (m *GetIntegrationHealthResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetIntegrationHealthResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetIntegrationHealthResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetIntegrationHealthResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetIntegrationHealthResponse.Merge(m, src)
}
func (m *GetIntegrationHealthResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetIntegrationHealthResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetIntegrationHealthResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetIntegrationHealthResponse proto.InternalMessageInfo

func (m *GetIntegrationHealthResponse) GetIntegrationHealth() []*storage.IntegrationHealth {
	if m != nil {
		return m.IntegrationHealth
	}
	return nil
}

func (m *GetIntegrationHealthResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetIntegrationHealthResponse) Clone() *GetIntegrationHealthResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetIntegrationHealthResponse)
	*cloned = *m

	if m.IntegrationHealth != nil {
		cloned.IntegrationHealth = make([]*storage.IntegrationHealth, len(m.IntegrationHealth))
		for idx, v := range m.IntegrationHealth {
			cloned.IntegrationHealth[idx] = v.Clone()
		}
	}
	return cloned
}

type VulnDefinitionsInfo struct {
	LastUpdatedTimestamp *types.Timestamp `protobuf:"bytes,1,opt,name=last_updated_timestamp,json=lastUpdatedTimestamp,proto3" json:"last_updated_timestamp,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *VulnDefinitionsInfo) Reset()         { *m = VulnDefinitionsInfo{} }
func (m *VulnDefinitionsInfo) String() string { return proto.CompactTextString(m) }
func (*VulnDefinitionsInfo) ProtoMessage()    {}
func (*VulnDefinitionsInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_4c40da462e693fb8, []int{1}
}
func (m *VulnDefinitionsInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VulnDefinitionsInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VulnDefinitionsInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VulnDefinitionsInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VulnDefinitionsInfo.Merge(m, src)
}
func (m *VulnDefinitionsInfo) XXX_Size() int {
	return m.Size()
}
func (m *VulnDefinitionsInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_VulnDefinitionsInfo.DiscardUnknown(m)
}

var xxx_messageInfo_VulnDefinitionsInfo proto.InternalMessageInfo

func (m *VulnDefinitionsInfo) GetLastUpdatedTimestamp() *types.Timestamp {
	if m != nil {
		return m.LastUpdatedTimestamp
	}
	return nil
}

func (m *VulnDefinitionsInfo) MessageClone() proto.Message {
	return m.Clone()
}
func (m *VulnDefinitionsInfo) Clone() *VulnDefinitionsInfo {
	if m == nil {
		return nil
	}
	cloned := new(VulnDefinitionsInfo)
	*cloned = *m

	cloned.LastUpdatedTimestamp = m.LastUpdatedTimestamp.Clone()
	return cloned
}

func init() {
	proto.RegisterType((*GetIntegrationHealthResponse)(nil), "v1.GetIntegrationHealthResponse")
	proto.RegisterType((*VulnDefinitionsInfo)(nil), "v1.VulnDefinitionsInfo")
}

func init() {
	proto.RegisterFile("api/v1/integration_health_service.proto", fileDescriptor_4c40da462e693fb8)
}

var fileDescriptor_4c40da462e693fb8 = []byte{
	// 430 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x92, 0xdf, 0x6a, 0xd4, 0x40,
	0x14, 0xc6, 0xcd, 0x16, 0x04, 0x47, 0x2f, 0x74, 0x2c, 0x35, 0x84, 0x92, 0xc6, 0x05, 0x89, 0x5e,
	0x38, 0x21, 0xf5, 0x0d, 0x8a, 0x92, 0xf6, 0x46, 0x4a, 0xfd, 0x83, 0x78, 0x13, 0x66, 0x37, 0x27,
	0xd9, 0x61, 0x93, 0x99, 0x21, 0x73, 0x12, 0xea, 0xad, 0xaf, 0xe0, 0x8d, 0x8f, 0xe4, 0xa5, 0xd0,
	0x17, 0x90, 0xd5, 0x07, 0x91, 0x4c, 0xd2, 0xed, 0xd2, 0x0d, 0xca, 0xde, 0x0d, 0x67, 0xbe, 0xef,
	0xfc, 0xce, 0xf9, 0x66, 0x48, 0xc8, 0xb5, 0x88, 0xda, 0x38, 0x12, 0x12, 0xa1, 0xa8, 0x39, 0x0a,
	0x25, 0xd3, 0x05, 0xf0, 0x12, 0x17, 0xa9, 0x81, 0xba, 0x15, 0x73, 0x60, 0xba, 0x56, 0xa8, 0xe8,
	0xa4, 0x8d, 0xbd, 0xa3, 0x42, 0xa9, 0xa2, 0x84, 0xc8, 0x56, 0x66, 0x4d, 0x1e, 0xa1, 0xa8, 0xc0,
	0x20, 0xaf, 0x74, 0x2f, 0xf2, 0x0e, 0x07, 0x41, 0xd7, 0x94, 0x4b, 0xa9, 0xd0, 0x36, 0x34, 0xc3,
	0x6d, 0x60, 0x50, 0xd5, 0xbc, 0x80, 0x11, 0xd8, 0xa0, 0xa0, 0xc3, 0x34, 0x50, 0x69, 0xfc, 0xd2,
	0xd7, 0xa6, 0x0b, 0x72, 0x98, 0x00, 0x9e, 0xdd, 0x58, 0x4e, 0xad, 0xe3, 0x02, 0x8c, 0x56, 0xd2,
	0x00, 0x3d, 0x25, 0x8f, 0xc4, 0xed, 0x4b, 0xd7, 0x09, 0xf6, 0x9e, 0xdf, 0x3f, 0xf6, 0xd8, 0x40,
	0x64, 0xdb, 0xf6, 0x6d, 0xd3, 0xb4, 0x20, 0x8f, 0x3f, 0x36, 0xa5, 0x7c, 0x0d, 0xb9, 0x90, 0xc2,
	0x0e, 0x7e, 0x26, 0x73, 0x45, 0xcf, 0xc9, 0x41, 0xc9, 0x0d, 0xa6, 0x8d, 0xce, 0x38, 0x42, 0x96,
	0xae, 0x97, 0x76, 0x9d, 0xc0, 0xb1, 0x94, 0x7e, 0x6b, 0x76, 0x1d, 0x0b, 0x7b, 0x7f, 0xad, 0xb8,
	0xd8, 0xef, 0x9c, 0x1f, 0x7a, 0xe3, 0xba, 0x7a, 0x7c, 0xb5, 0x47, 0xdc, 0xad, 0x89, 0xde, 0xf5,
	0x71, 0x53, 0x24, 0xfb, 0xdd, 0xbe, 0x15, 0x2f, 0x60, 0x43, 0x63, 0xe8, 0x3d, 0xd6, 0xc6, 0xec,
	0x4d, 0x17, 0x8c, 0x17, 0x74, 0xc7, 0x7f, 0x85, 0x32, 0x8d, 0xbe, 0x5e, 0xfd, 0xf9, 0x36, 0x79,
	0x41, 0xc3, 0x5b, 0x6f, 0xdb, 0xa7, 0x1d, 0x89, 0xae, 0xbb, 0xd8, 0xec, 0x9e, 0x91, 0x07, 0x09,
	0xe0, 0x5b, 0x85, 0x22, 0x17, 0x50, 0xef, 0x48, 0x0b, 0x2d, 0xed, 0x29, 0x3d, 0x1a, 0xa7, 0xc9,
	0x75, 0x57, 0x49, 0x1e, 0x26, 0x80, 0x27, 0x7c, 0xbe, 0x6c, 0xf4, 0x79, 0xd9, 0x14, 0x62, 0xd7,
	0xbd, 0x5e, 0x5a, 0x52, 0x48, 0x9f, 0x8d, 0x93, 0xe0, 0x12, 0xa1, 0x96, 0xbc, 0x9c, 0x59, 0x82,
	0xa1, 0x4b, 0x72, 0x90, 0x00, 0x8e, 0x3d, 0xea, 0x06, 0xf5, 0x49, 0x77, 0x1c, 0xd1, 0xfc, 0x0f,
	0xd6, 0x36, 0xa5, 0xcc, 0x6e, 0x2c, 0x27, 0xec, 0xc7, 0xca, 0x77, 0x7e, 0xae, 0x7c, 0xe7, 0xd7,
	0xca, 0x77, 0xbe, 0xff, 0xf6, 0xef, 0x10, 0x57, 0x28, 0x66, 0x90, 0xcf, 0x97, 0xb5, 0xba, 0xec,
	0x7f, 0x07, 0xe3, 0x5a, 0xb0, 0x36, 0xfe, 0x3c, 0x69, 0xe3, 0x4f, 0xce, 0xec, 0xae, 0xad, 0xbd,
	0xfa, 0x1b, 0x00, 0x00, 0xff, 0xff, 0xa7, 0xec, 0x94, 0x4e, 0x85, 0x03, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// IntegrationHealthServiceClient is the client API for IntegrationHealthService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConnInterface.NewStream.
type IntegrationHealthServiceClient interface {
	GetImageIntegrations(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*GetIntegrationHealthResponse, error)
	GetNotifiers(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*GetIntegrationHealthResponse, error)
	GetBackupPlugins(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*GetIntegrationHealthResponse, error)
	GetVulnDefinitionsInfo(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*VulnDefinitionsInfo, error)
}

type integrationHealthServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewIntegrationHealthServiceClient(cc grpc.ClientConnInterface) IntegrationHealthServiceClient {
	return &integrationHealthServiceClient{cc}
}

func (c *integrationHealthServiceClient) GetImageIntegrations(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*GetIntegrationHealthResponse, error) {
	out := new(GetIntegrationHealthResponse)
	err := c.cc.Invoke(ctx, "/v1.IntegrationHealthService/GetImageIntegrations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *integrationHealthServiceClient) GetNotifiers(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*GetIntegrationHealthResponse, error) {
	out := new(GetIntegrationHealthResponse)
	err := c.cc.Invoke(ctx, "/v1.IntegrationHealthService/GetNotifiers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *integrationHealthServiceClient) GetBackupPlugins(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*GetIntegrationHealthResponse, error) {
	out := new(GetIntegrationHealthResponse)
	err := c.cc.Invoke(ctx, "/v1.IntegrationHealthService/GetBackupPlugins", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *integrationHealthServiceClient) GetVulnDefinitionsInfo(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*VulnDefinitionsInfo, error) {
	out := new(VulnDefinitionsInfo)
	err := c.cc.Invoke(ctx, "/v1.IntegrationHealthService/GetVulnDefinitionsInfo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// IntegrationHealthServiceServer is the server API for IntegrationHealthService service.
type IntegrationHealthServiceServer interface {
	GetImageIntegrations(context.Context, *Empty) (*GetIntegrationHealthResponse, error)
	GetNotifiers(context.Context, *Empty) (*GetIntegrationHealthResponse, error)
	GetBackupPlugins(context.Context, *Empty) (*GetIntegrationHealthResponse, error)
	GetVulnDefinitionsInfo(context.Context, *Empty) (*VulnDefinitionsInfo, error)
}

// UnimplementedIntegrationHealthServiceServer can be embedded to have forward compatible implementations.
type UnimplementedIntegrationHealthServiceServer struct {
}

func (*UnimplementedIntegrationHealthServiceServer) GetImageIntegrations(ctx context.Context, req *Empty) (*GetIntegrationHealthResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetImageIntegrations not implemented")
}
func (*UnimplementedIntegrationHealthServiceServer) GetNotifiers(ctx context.Context, req *Empty) (*GetIntegrationHealthResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNotifiers not implemented")
}
func (*UnimplementedIntegrationHealthServiceServer) GetBackupPlugins(ctx context.Context, req *Empty) (*GetIntegrationHealthResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBackupPlugins not implemented")
}
func (*UnimplementedIntegrationHealthServiceServer) GetVulnDefinitionsInfo(ctx context.Context, req *Empty) (*VulnDefinitionsInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVulnDefinitionsInfo not implemented")
}

func RegisterIntegrationHealthServiceServer(s *grpc.Server, srv IntegrationHealthServiceServer) {
	s.RegisterService(&_IntegrationHealthService_serviceDesc, srv)
}

func _IntegrationHealthService_GetImageIntegrations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntegrationHealthServiceServer).GetImageIntegrations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.IntegrationHealthService/GetImageIntegrations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntegrationHealthServiceServer).GetImageIntegrations(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _IntegrationHealthService_GetNotifiers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntegrationHealthServiceServer).GetNotifiers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.IntegrationHealthService/GetNotifiers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntegrationHealthServiceServer).GetNotifiers(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _IntegrationHealthService_GetBackupPlugins_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntegrationHealthServiceServer).GetBackupPlugins(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.IntegrationHealthService/GetBackupPlugins",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntegrationHealthServiceServer).GetBackupPlugins(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _IntegrationHealthService_GetVulnDefinitionsInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntegrationHealthServiceServer).GetVulnDefinitionsInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.IntegrationHealthService/GetVulnDefinitionsInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntegrationHealthServiceServer).GetVulnDefinitionsInfo(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

var _IntegrationHealthService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1.IntegrationHealthService",
	HandlerType: (*IntegrationHealthServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetImageIntegrations",
			Handler:    _IntegrationHealthService_GetImageIntegrations_Handler,
		},
		{
			MethodName: "GetNotifiers",
			Handler:    _IntegrationHealthService_GetNotifiers_Handler,
		},
		{
			MethodName: "GetBackupPlugins",
			Handler:    _IntegrationHealthService_GetBackupPlugins_Handler,
		},
		{
			MethodName: "GetVulnDefinitionsInfo",
			Handler:    _IntegrationHealthService_GetVulnDefinitionsInfo_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/v1/integration_health_service.proto",
}

func (m *GetIntegrationHealthResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetIntegrationHealthResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetIntegrationHealthResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.IntegrationHealth) > 0 {
		for iNdEx := len(m.IntegrationHealth) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.IntegrationHealth[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintIntegrationHealthService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *VulnDefinitionsInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VulnDefinitionsInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *VulnDefinitionsInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.LastUpdatedTimestamp != nil {
		{
			size, err := m.LastUpdatedTimestamp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIntegrationHealthService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintIntegrationHealthService(dAtA []byte, offset int, v uint64) int {
	offset -= sovIntegrationHealthService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *GetIntegrationHealthResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.IntegrationHealth) > 0 {
		for _, e := range m.IntegrationHealth {
			l = e.Size()
			n += 1 + l + sovIntegrationHealthService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *VulnDefinitionsInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.LastUpdatedTimestamp != nil {
		l = m.LastUpdatedTimestamp.Size()
		n += 1 + l + sovIntegrationHealthService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovIntegrationHealthService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozIntegrationHealthService(x uint64) (n int) {
	return sovIntegrationHealthService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *GetIntegrationHealthResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIntegrationHealthService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetIntegrationHealthResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetIntegrationHealthResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntegrationHealth", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntegrationHealthService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIntegrationHealthService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIntegrationHealthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IntegrationHealth = append(m.IntegrationHealth, &storage.IntegrationHealth{})
			if err := m.IntegrationHealth[len(m.IntegrationHealth)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIntegrationHealthService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthIntegrationHealthService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *VulnDefinitionsInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIntegrationHealthService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: VulnDefinitionsInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: VulnDefinitionsInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastUpdatedTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIntegrationHealthService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIntegrationHealthService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIntegrationHealthService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastUpdatedTimestamp == nil {
				m.LastUpdatedTimestamp = &types.Timestamp{}
			}
			if err := m.LastUpdatedTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIntegrationHealthService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthIntegrationHealthService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipIntegrationHealthService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowIntegrationHealthService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowIntegrationHealthService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowIntegrationHealthService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthIntegrationHealthService
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupIntegrationHealthService
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthIntegrationHealthService
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthIntegrationHealthService        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowIntegrationHealthService          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupIntegrationHealthService = fmt.Errorf("proto: unexpected end of group")
)
