// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api/v1/license_service.proto

package v1

import (
	context "context"
	fmt "fmt"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	license "github.com/stackrox/rox/generated/shared/license"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type LicenseInfo_Status int32

const (
	LicenseInfo_UNKNOWN       LicenseInfo_Status = 0
	LicenseInfo_VALID         LicenseInfo_Status = 1
	LicenseInfo_REVOKED       LicenseInfo_Status = 2
	LicenseInfo_NOT_YET_VALID LicenseInfo_Status = 3
	LicenseInfo_EXPIRED       LicenseInfo_Status = 4
	LicenseInfo_OTHER         LicenseInfo_Status = 5
)

var LicenseInfo_Status_name = map[int32]string{
	0: "UNKNOWN",
	1: "VALID",
	2: "REVOKED",
	3: "NOT_YET_VALID",
	4: "EXPIRED",
	5: "OTHER",
}

var LicenseInfo_Status_value = map[string]int32{
	"UNKNOWN":       0,
	"VALID":         1,
	"REVOKED":       2,
	"NOT_YET_VALID": 3,
	"EXPIRED":       4,
	"OTHER":         5,
}

func (x LicenseInfo_Status) String() string {
	return proto.EnumName(LicenseInfo_Status_name, int32(x))
}

func (LicenseInfo_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_23d7efbed72c86a6, []int{0, 0}
}

type LicenseInfo struct {
	License              *license.License   `protobuf:"bytes,1,opt,name=license,proto3" json:"license,omitempty"`
	Status               LicenseInfo_Status `protobuf:"varint,2,opt,name=status,proto3,enum=v1.LicenseInfo_Status" json:"status,omitempty"`
	StatusReason         string             `protobuf:"bytes,3,opt,name=status_reason,json=statusReason,proto3" json:"status_reason,omitempty"`
	Active               bool               `protobuf:"varint,4,opt,name=active,proto3" json:"active,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *LicenseInfo) Reset()         { *m = LicenseInfo{} }
func (m *LicenseInfo) String() string { return proto.CompactTextString(m) }
func (*LicenseInfo) ProtoMessage()    {}
func (*LicenseInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_23d7efbed72c86a6, []int{0}
}
func (m *LicenseInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LicenseInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LicenseInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LicenseInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LicenseInfo.Merge(m, src)
}
func (m *LicenseInfo) XXX_Size() int {
	return m.Size()
}
func (m *LicenseInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_LicenseInfo.DiscardUnknown(m)
}

var xxx_messageInfo_LicenseInfo proto.InternalMessageInfo

func (m *LicenseInfo) GetLicense() *license.License {
	if m != nil {
		return m.License
	}
	return nil
}

func (m *LicenseInfo) GetStatus() LicenseInfo_Status {
	if m != nil {
		return m.Status
	}
	return LicenseInfo_UNKNOWN
}

func (m *LicenseInfo) GetStatusReason() string {
	if m != nil {
		return m.StatusReason
	}
	return ""
}

func (m *LicenseInfo) GetActive() bool {
	if m != nil {
		return m.Active
	}
	return false
}

func (m *LicenseInfo) MessageClone() proto.Message {
	return m.Clone()
}
func (m *LicenseInfo) Clone() *LicenseInfo {
	if m == nil {
		return nil
	}
	cloned := new(LicenseInfo)
	*cloned = *m

	cloned.License = m.License.Clone()
	return cloned
}

type AddLicenseRequest struct {
	LicenseKey string `protobuf:"bytes,1,opt,name=license_key,json=licenseKey,proto3" json:"license_key,omitempty"`
	// Indicates whether the license represented by this key should be made the active license.
	Activate             bool     `protobuf:"varint,2,opt,name=activate,proto3" json:"activate,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AddLicenseRequest) Reset()         { *m = AddLicenseRequest{} }
func (m *AddLicenseRequest) String() string { return proto.CompactTextString(m) }
func (*AddLicenseRequest) ProtoMessage()    {}
func (*AddLicenseRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_23d7efbed72c86a6, []int{1}
}
func (m *AddLicenseRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AddLicenseRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AddLicenseRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AddLicenseRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddLicenseRequest.Merge(m, src)
}
func (m *AddLicenseRequest) XXX_Size() int {
	return m.Size()
}
func (m *AddLicenseRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AddLicenseRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AddLicenseRequest proto.InternalMessageInfo

func (m *AddLicenseRequest) GetLicenseKey() string {
	if m != nil {
		return m.LicenseKey
	}
	return ""
}

func (m *AddLicenseRequest) GetActivate() bool {
	if m != nil {
		return m.Activate
	}
	return false
}

func (m *AddLicenseRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *AddLicenseRequest) Clone() *AddLicenseRequest {
	if m == nil {
		return nil
	}
	cloned := new(AddLicenseRequest)
	*cloned = *m

	return cloned
}

type AddLicenseResponse struct {
	License *LicenseInfo `protobuf:"bytes,1,opt,name=license,proto3" json:"license,omitempty"`
	// Indicates whether or not the license was accepted by the product. Only licenses which are either valid or
	// not yet valid will be accepted. Note that we prefer this over a GRPC error, as it might be helpful to show the,
	// e.g., contact information from the decoded blob.
	Accepted             bool     `protobuf:"varint,2,opt,name=accepted,proto3" json:"accepted,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AddLicenseResponse) Reset()         { *m = AddLicenseResponse{} }
func (m *AddLicenseResponse) String() string { return proto.CompactTextString(m) }
func (*AddLicenseResponse) ProtoMessage()    {}
func (*AddLicenseResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_23d7efbed72c86a6, []int{2}
}
func (m *AddLicenseResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AddLicenseResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AddLicenseResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AddLicenseResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddLicenseResponse.Merge(m, src)
}
func (m *AddLicenseResponse) XXX_Size() int {
	return m.Size()
}
func (m *AddLicenseResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AddLicenseResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AddLicenseResponse proto.InternalMessageInfo

func (m *AddLicenseResponse) GetLicense() *LicenseInfo {
	if m != nil {
		return m.License
	}
	return nil
}

func (m *AddLicenseResponse) GetAccepted() bool {
	if m != nil {
		return m.Accepted
	}
	return false
}

func (m *AddLicenseResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *AddLicenseResponse) Clone() *AddLicenseResponse {
	if m == nil {
		return nil
	}
	cloned := new(AddLicenseResponse)
	*cloned = *m

	cloned.License = m.License.Clone()
	return cloned
}

type GetLicensesRequest struct {
	// Types that are valid to be assigned to ActiveOpt:
	//	*GetLicensesRequest_Active
	ActiveOpt            isGetLicensesRequest_ActiveOpt `protobuf_oneof:"active_opt"`
	Statuses             []LicenseInfo_Status           `protobuf:"varint,2,rep,packed,name=statuses,proto3,enum=v1.LicenseInfo_Status" json:"statuses,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *GetLicensesRequest) Reset()         { *m = GetLicensesRequest{} }
func (m *GetLicensesRequest) String() string { return proto.CompactTextString(m) }
func (*GetLicensesRequest) ProtoMessage()    {}
func (*GetLicensesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_23d7efbed72c86a6, []int{3}
}
func (m *GetLicensesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetLicensesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetLicensesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetLicensesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetLicensesRequest.Merge(m, src)
}
func (m *GetLicensesRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetLicensesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetLicensesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetLicensesRequest proto.InternalMessageInfo

type isGetLicensesRequest_ActiveOpt interface {
	isGetLicensesRequest_ActiveOpt()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isGetLicensesRequest_ActiveOpt
}

type GetLicensesRequest_Active struct {
	Active bool `protobuf:"varint,1,opt,name=active,proto3,oneof" json:"active,omitempty"`
}

func (*GetLicensesRequest_Active) isGetLicensesRequest_ActiveOpt() {}
func (m *GetLicensesRequest_Active) Clone() isGetLicensesRequest_ActiveOpt {
	if m == nil {
		return nil
	}
	cloned := new(GetLicensesRequest_Active)
	*cloned = *m

	return cloned
}

func (m *GetLicensesRequest) GetActiveOpt() isGetLicensesRequest_ActiveOpt {
	if m != nil {
		return m.ActiveOpt
	}
	return nil
}

func (m *GetLicensesRequest) GetActive() bool {
	if x, ok := m.GetActiveOpt().(*GetLicensesRequest_Active); ok {
		return x.Active
	}
	return false
}

func (m *GetLicensesRequest) GetStatuses() []LicenseInfo_Status {
	if m != nil {
		return m.Statuses
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*GetLicensesRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*GetLicensesRequest_Active)(nil),
	}
}

func (m *GetLicensesRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetLicensesRequest) Clone() *GetLicensesRequest {
	if m == nil {
		return nil
	}
	cloned := new(GetLicensesRequest)
	*cloned = *m

	if m.ActiveOpt != nil {
		cloned.ActiveOpt = m.ActiveOpt.Clone()
	}
	if m.Statuses != nil {
		cloned.Statuses = make([]LicenseInfo_Status, len(m.Statuses))
		copy(cloned.Statuses, m.Statuses)
	}
	return cloned
}

type GetLicensesResponse struct {
	Licenses             []*LicenseInfo `protobuf:"bytes,1,rep,name=licenses,proto3" json:"licenses,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *GetLicensesResponse) Reset()         { *m = GetLicensesResponse{} }
func (m *GetLicensesResponse) String() string { return proto.CompactTextString(m) }
func (*GetLicensesResponse) ProtoMessage()    {}
func (*GetLicensesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_23d7efbed72c86a6, []int{4}
}
func (m *GetLicensesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetLicensesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetLicensesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetLicensesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetLicensesResponse.Merge(m, src)
}
func (m *GetLicensesResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetLicensesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetLicensesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetLicensesResponse proto.InternalMessageInfo

func (m *GetLicensesResponse) GetLicenses() []*LicenseInfo {
	if m != nil {
		return m.Licenses
	}
	return nil
}

func (m *GetLicensesResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetLicensesResponse) Clone() *GetLicensesResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetLicensesResponse)
	*cloned = *m

	if m.Licenses != nil {
		cloned.Licenses = make([]*LicenseInfo, len(m.Licenses))
		for idx, v := range m.Licenses {
			cloned.Licenses[idx] = v.Clone()
		}
	}
	return cloned
}

type GetActiveLicenseExpirationResponse struct {
	ExpirationTime       *types.Timestamp `protobuf:"bytes,1,opt,name=expiration_time,json=expirationTime,proto3" json:"expiration_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *GetActiveLicenseExpirationResponse) Reset()         { *m = GetActiveLicenseExpirationResponse{} }
func (m *GetActiveLicenseExpirationResponse) String() string { return proto.CompactTextString(m) }
func (*GetActiveLicenseExpirationResponse) ProtoMessage()    {}
func (*GetActiveLicenseExpirationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_23d7efbed72c86a6, []int{5}
}
func (m *GetActiveLicenseExpirationResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetActiveLicenseExpirationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetActiveLicenseExpirationResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetActiveLicenseExpirationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetActiveLicenseExpirationResponse.Merge(m, src)
}
func (m *GetActiveLicenseExpirationResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetActiveLicenseExpirationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetActiveLicenseExpirationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetActiveLicenseExpirationResponse proto.InternalMessageInfo

func (m *GetActiveLicenseExpirationResponse) GetExpirationTime() *types.Timestamp {
	if m != nil {
		return m.ExpirationTime
	}
	return nil
}

func (m *GetActiveLicenseExpirationResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetActiveLicenseExpirationResponse) Clone() *GetActiveLicenseExpirationResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetActiveLicenseExpirationResponse)
	*cloned = *m

	cloned.ExpirationTime = m.ExpirationTime.Clone()
	return cloned
}

type GetActiveLicenseKeyResponse struct {
	LicenseKey           string   `protobuf:"bytes,1,opt,name=license_key,json=licenseKey,proto3" json:"license_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetActiveLicenseKeyResponse) Reset()         { *m = GetActiveLicenseKeyResponse{} }
func (m *GetActiveLicenseKeyResponse) String() string { return proto.CompactTextString(m) }
func (*GetActiveLicenseKeyResponse) ProtoMessage()    {}
func (*GetActiveLicenseKeyResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_23d7efbed72c86a6, []int{6}
}
func (m *GetActiveLicenseKeyResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetActiveLicenseKeyResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetActiveLicenseKeyResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetActiveLicenseKeyResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetActiveLicenseKeyResponse.Merge(m, src)
}
func (m *GetActiveLicenseKeyResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetActiveLicenseKeyResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetActiveLicenseKeyResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetActiveLicenseKeyResponse proto.InternalMessageInfo

func (m *GetActiveLicenseKeyResponse) GetLicenseKey() string {
	if m != nil {
		return m.LicenseKey
	}
	return ""
}

func (m *GetActiveLicenseKeyResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetActiveLicenseKeyResponse) Clone() *GetActiveLicenseKeyResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetActiveLicenseKeyResponse)
	*cloned = *m

	return cloned
}

func init() {
	proto.RegisterEnum("v1.LicenseInfo_Status", LicenseInfo_Status_name, LicenseInfo_Status_value)
	proto.RegisterType((*LicenseInfo)(nil), "v1.LicenseInfo")
	proto.RegisterType((*AddLicenseRequest)(nil), "v1.AddLicenseRequest")
	proto.RegisterType((*AddLicenseResponse)(nil), "v1.AddLicenseResponse")
	proto.RegisterType((*GetLicensesRequest)(nil), "v1.GetLicensesRequest")
	proto.RegisterType((*GetLicensesResponse)(nil), "v1.GetLicensesResponse")
	proto.RegisterType((*GetActiveLicenseExpirationResponse)(nil), "v1.GetActiveLicenseExpirationResponse")
	proto.RegisterType((*GetActiveLicenseKeyResponse)(nil), "v1.GetActiveLicenseKeyResponse")
}

func init() { proto.RegisterFile("api/v1/license_service.proto", fileDescriptor_23d7efbed72c86a6) }

var fileDescriptor_23d7efbed72c86a6 = []byte{
	// 680 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x84, 0x54, 0x5d, 0x4f, 0x13, 0x41,
	0x14, 0xed, 0xb6, 0x50, 0xda, 0x5b, 0x3e, 0x96, 0x21, 0x94, 0x65, 0x21, 0x6d, 0xb3, 0x26, 0xa6,
	0x62, 0x32, 0x4d, 0xeb, 0x9b, 0x0f, 0x26, 0x20, 0x1b, 0x20, 0x25, 0x2d, 0x59, 0x2a, 0x16, 0x7d,
	0x68, 0x86, 0x76, 0xc0, 0x0d, 0xd0, 0x5d, 0x3b, 0xc3, 0x86, 0xbe, 0x19, 0xff, 0x82, 0x2f, 0xc6,
	0x5f, 0xe4, 0xa3, 0x89, 0x7f, 0xc0, 0xa0, 0x3f, 0xc4, 0xec, 0xcc, 0xec, 0xf6, 0x03, 0x94, 0x27,
	0x98, 0x33, 0xe7, 0x9e, 0x33, 0xf7, 0xdc, 0xbb, 0x85, 0x4d, 0xe2, 0xbb, 0x95, 0xa0, 0x5a, 0xb9,
	0x72, 0xbb, 0xb4, 0xcf, 0x68, 0x87, 0xd1, 0x41, 0xe0, 0x76, 0x29, 0xf6, 0x07, 0x1e, 0xf7, 0x50,
	0x32, 0xa8, 0x9a, 0x9b, 0x17, 0x9e, 0x77, 0x71, 0x45, 0x2b, 0x21, 0x91, 0xf4, 0xfb, 0x1e, 0x27,
	0xdc, 0xf5, 0xfa, 0x4c, 0x32, 0xcc, 0xa2, 0xba, 0x15, 0xa7, 0xb3, 0x9b, 0xf3, 0x0a, 0x77, 0xaf,
	0x29, 0xe3, 0xe4, 0xda, 0x57, 0x84, 0x4d, 0xf6, 0x81, 0x0c, 0x68, 0x2f, 0x32, 0x88, 0xfe, 0xaa,
	0x5b, 0xa4, 0xec, 0xe9, 0xb5, 0xcf, 0x87, 0x12, 0xb3, 0x3e, 0x25, 0x21, 0x77, 0x28, 0x59, 0x07,
	0xfd, 0x73, 0x0f, 0x6d, 0xc1, 0x9c, 0x2a, 0x32, 0xb4, 0x92, 0x56, 0xce, 0xd5, 0x74, 0x1c, 0x89,
	0x28, 0x9a, 0x13, 0x11, 0x10, 0x86, 0x34, 0xe3, 0x84, 0xdf, 0x30, 0x23, 0x59, 0xd2, 0xca, 0x8b,
	0xb5, 0x3c, 0x0e, 0xaa, 0x78, 0x4c, 0x0c, 0x1f, 0x8b, 0x5b, 0x47, 0xb1, 0xd0, 0x13, 0x58, 0x90,
	0xff, 0x75, 0x06, 0x94, 0x30, 0xaf, 0x6f, 0xa4, 0x4a, 0x5a, 0x39, 0xeb, 0xcc, 0x4b, 0xd0, 0x11,
	0x18, 0xca, 0x43, 0x9a, 0x74, 0xb9, 0x1b, 0x50, 0x63, 0xa6, 0xa4, 0x95, 0x33, 0x8e, 0x3a, 0x59,
	0x6d, 0x48, 0x4b, 0x39, 0x94, 0x83, 0xb9, 0x37, 0x8d, 0x7a, 0xa3, 0xf9, 0xb6, 0xa1, 0x27, 0x50,
	0x16, 0x66, 0x4f, 0xb6, 0x0f, 0x0f, 0x76, 0x75, 0x2d, 0xc4, 0x1d, 0xfb, 0xa4, 0x59, 0xb7, 0x77,
	0xf5, 0x24, 0x5a, 0x86, 0x85, 0x46, 0xb3, 0xd5, 0x39, 0xb5, 0x5b, 0x1d, 0x79, 0x9f, 0x0a, 0xef,
	0xed, 0xf6, 0xd1, 0x81, 0x63, 0xef, 0xea, 0x33, 0x61, 0x5d, 0xb3, 0xb5, 0x6f, 0x3b, 0xfa, 0xac,
	0x75, 0x04, 0xcb, 0xdb, 0xbd, 0x5e, 0xd4, 0x1d, 0xfd, 0x78, 0x43, 0x19, 0x47, 0x45, 0xc8, 0x45,
	0x53, 0xba, 0xa4, 0x43, 0x91, 0x45, 0xd6, 0x01, 0x05, 0xd5, 0xe9, 0x10, 0x99, 0x90, 0x11, 0x2f,
	0x23, 0x9c, 0x8a, 0xf6, 0x33, 0x4e, 0x7c, 0xb6, 0xde, 0x03, 0x1a, 0x57, 0x64, 0xbe, 0x17, 0xc6,
	0xf5, 0x6c, 0x3a, 0xda, 0xa5, 0xa9, 0xbc, 0x46, 0xc9, 0x0a, 0xf1, 0x2e, 0xf5, 0x39, 0xed, 0x8d,
	0xc4, 0xe5, 0xd9, 0xf2, 0x01, 0xed, 0x51, 0xae, 0xca, 0x58, 0xf4, 0x5e, 0x23, 0x8e, 0x2d, 0xd4,
	0xce, 0xec, 0x27, 0xa2, 0xe0, 0x50, 0x0d, 0x32, 0x32, 0x60, 0x1a, 0xce, 0x29, 0xf5, 0x9f, 0x39,
	0xc5, 0xbc, 0x9d, 0x79, 0x00, 0x59, 0xdd, 0xf1, 0x7c, 0x6e, 0xed, 0xc0, 0xca, 0x84, 0xa3, 0xea,
	0xe7, 0x39, 0x64, 0xd4, 0x7b, 0x99, 0xa1, 0x95, 0x52, 0x0f, 0x35, 0x14, 0x13, 0x2c, 0x17, 0xac,
	0x3d, 0xca, 0xb7, 0x85, 0xa8, 0x62, 0xd8, 0xb7, 0xbe, 0x3b, 0x10, 0xfb, 0x1d, 0x4b, 0xbe, 0x86,
	0x25, 0x1a, 0xa3, 0x9d, 0x70, 0xbb, 0x55, 0x54, 0x26, 0x96, 0xab, 0x8f, 0xa3, 0xd5, 0xc7, 0xad,
	0x68, 0xf5, 0x9d, 0xc5, 0x51, 0x49, 0x08, 0x5a, 0xaf, 0x60, 0x63, 0xda, 0xaa, 0x4e, 0x87, 0xb1,
	0xc7, 0x63, 0x93, 0xad, 0x7d, 0x4b, 0xc1, 0xa2, 0xaa, 0x3b, 0x96, 0x1f, 0x28, 0x3a, 0x85, 0xdc,
	0x58, 0x02, 0x48, 0x04, 0x78, 0x7f, 0x08, 0xe6, 0xda, 0x3d, 0x5c, 0x7a, 0x5a, 0xeb, 0x9f, 0x7f,
	0xfe, 0xf9, 0x92, 0x5c, 0x41, 0xcb, 0x63, 0x5f, 0x3f, 0xab, 0x5c, 0xb9, 0x8c, 0xa3, 0x36, 0xc0,
	0x68, 0x57, 0xd0, 0x6a, 0xa8, 0x70, 0x6f, 0x1b, 0xcd, 0xfc, 0x34, 0xac, 0x74, 0x37, 0x84, 0xee,
	0xaa, 0xa5, 0x4f, 0xe8, 0x92, 0x5e, 0xef, 0xa5, 0xb6, 0x85, 0x7c, 0x30, 0xff, 0x1d, 0x39, 0xca,
	0x86, 0x92, 0x76, 0xf8, 0x4b, 0x60, 0x3e, 0x55, 0xcf, 0x7e, 0x64, 0x3a, 0x56, 0x51, 0xb8, 0xad,
	0xa3, 0xb5, 0x09, 0xb7, 0x51, 0xfa, 0x88, 0x88, 0x45, 0x99, 0x4e, 0x7e, 0xdc, 0xaa, 0xf8, 0x90,
	0xd5, 0xd8, 0x74, 0xac, 0x82, 0xf0, 0x30, 0x50, 0x7e, 0xb2, 0x23, 0x41, 0xbf, 0xa4, 0xc3, 0x1d,
	0xfc, 0xfd, 0xae, 0xa0, 0xfd, 0xb8, 0x2b, 0x68, 0xbf, 0xee, 0x0a, 0xda, 0xd7, 0xdf, 0x85, 0x04,
	0x18, 0xae, 0x87, 0x19, 0x27, 0xdd, 0xcb, 0x81, 0x77, 0x2b, 0xd7, 0x03, 0x13, 0xdf, 0xc5, 0x41,
	0xf5, 0x5d, 0x32, 0xa8, 0xb6, 0x13, 0x67, 0x69, 0x81, 0xbd, 0xf8, 0x1b, 0x00, 0x00, 0xff, 0xff,
	0x7d, 0xbd, 0xa3, 0x75, 0x7d, 0x05, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// LicenseServiceClient is the client API for LicenseService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConnInterface.NewStream.
type LicenseServiceClient interface {
	GetLicenses(ctx context.Context, in *GetLicensesRequest, opts ...grpc.CallOption) (*GetLicensesResponse, error)
	AddLicense(ctx context.Context, in *AddLicenseRequest, opts ...grpc.CallOption) (*AddLicenseResponse, error)
	GetActiveLicenseExpiration(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*GetActiveLicenseExpirationResponse, error)
	GetActiveLicenseKey(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*GetActiveLicenseKeyResponse, error)
}

type licenseServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewLicenseServiceClient(cc grpc.ClientConnInterface) LicenseServiceClient {
	return &licenseServiceClient{cc}
}

func (c *licenseServiceClient) GetLicenses(ctx context.Context, in *GetLicensesRequest, opts ...grpc.CallOption) (*GetLicensesResponse, error) {
	out := new(GetLicensesResponse)
	err := c.cc.Invoke(ctx, "/v1.LicenseService/GetLicenses", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *licenseServiceClient) AddLicense(ctx context.Context, in *AddLicenseRequest, opts ...grpc.CallOption) (*AddLicenseResponse, error) {
	out := new(AddLicenseResponse)
	err := c.cc.Invoke(ctx, "/v1.LicenseService/AddLicense", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *licenseServiceClient) GetActiveLicenseExpiration(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*GetActiveLicenseExpirationResponse, error) {
	out := new(GetActiveLicenseExpirationResponse)
	err := c.cc.Invoke(ctx, "/v1.LicenseService/GetActiveLicenseExpiration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *licenseServiceClient) GetActiveLicenseKey(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*GetActiveLicenseKeyResponse, error) {
	out := new(GetActiveLicenseKeyResponse)
	err := c.cc.Invoke(ctx, "/v1.LicenseService/GetActiveLicenseKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// LicenseServiceServer is the server API for LicenseService service.
type LicenseServiceServer interface {
	GetLicenses(context.Context, *GetLicensesRequest) (*GetLicensesResponse, error)
	AddLicense(context.Context, *AddLicenseRequest) (*AddLicenseResponse, error)
	GetActiveLicenseExpiration(context.Context, *Empty) (*GetActiveLicenseExpirationResponse, error)
	GetActiveLicenseKey(context.Context, *Empty) (*GetActiveLicenseKeyResponse, error)
}

// UnimplementedLicenseServiceServer can be embedded to have forward compatible implementations.
type UnimplementedLicenseServiceServer struct {
}

func (*UnimplementedLicenseServiceServer) GetLicenses(ctx context.Context, req *GetLicensesRequest) (*GetLicensesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLicenses not implemented")
}
func (*UnimplementedLicenseServiceServer) AddLicense(ctx context.Context, req *AddLicenseRequest) (*AddLicenseResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddLicense not implemented")
}
func (*UnimplementedLicenseServiceServer) GetActiveLicenseExpiration(ctx context.Context, req *Empty) (*GetActiveLicenseExpirationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetActiveLicenseExpiration not implemented")
}
func (*UnimplementedLicenseServiceServer) GetActiveLicenseKey(ctx context.Context, req *Empty) (*GetActiveLicenseKeyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetActiveLicenseKey not implemented")
}

func RegisterLicenseServiceServer(s *grpc.Server, srv LicenseServiceServer) {
	s.RegisterService(&_LicenseService_serviceDesc, srv)
}

func _LicenseService_GetLicenses_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLicensesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LicenseServiceServer).GetLicenses(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.LicenseService/GetLicenses",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LicenseServiceServer).GetLicenses(ctx, req.(*GetLicensesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LicenseService_AddLicense_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddLicenseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LicenseServiceServer).AddLicense(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.LicenseService/AddLicense",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LicenseServiceServer).AddLicense(ctx, req.(*AddLicenseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LicenseService_GetActiveLicenseExpiration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LicenseServiceServer).GetActiveLicenseExpiration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.LicenseService/GetActiveLicenseExpiration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LicenseServiceServer).GetActiveLicenseExpiration(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _LicenseService_GetActiveLicenseKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LicenseServiceServer).GetActiveLicenseKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.LicenseService/GetActiveLicenseKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LicenseServiceServer).GetActiveLicenseKey(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

var _LicenseService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1.LicenseService",
	HandlerType: (*LicenseServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetLicenses",
			Handler:    _LicenseService_GetLicenses_Handler,
		},
		{
			MethodName: "AddLicense",
			Handler:    _LicenseService_AddLicense_Handler,
		},
		{
			MethodName: "GetActiveLicenseExpiration",
			Handler:    _LicenseService_GetActiveLicenseExpiration_Handler,
		},
		{
			MethodName: "GetActiveLicenseKey",
			Handler:    _LicenseService_GetActiveLicenseKey_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/v1/license_service.proto",
}

func (m *LicenseInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LicenseInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LicenseInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Active {
		i--
		if m.Active {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.StatusReason) > 0 {
		i -= len(m.StatusReason)
		copy(dAtA[i:], m.StatusReason)
		i = encodeVarintLicenseService(dAtA, i, uint64(len(m.StatusReason)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Status != 0 {
		i = encodeVarintLicenseService(dAtA, i, uint64(m.Status))
		i--
		dAtA[i] = 0x10
	}
	if m.License != nil {
		{
			size, err := m.License.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintLicenseService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AddLicenseRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AddLicenseRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AddLicenseRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Activate {
		i--
		if m.Activate {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.LicenseKey) > 0 {
		i -= len(m.LicenseKey)
		copy(dAtA[i:], m.LicenseKey)
		i = encodeVarintLicenseService(dAtA, i, uint64(len(m.LicenseKey)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AddLicenseResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AddLicenseResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AddLicenseResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Accepted {
		i--
		if m.Accepted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if m.License != nil {
		{
			size, err := m.License.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintLicenseService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetLicensesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetLicensesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetLicensesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Statuses) > 0 {
		dAtA4 := make([]byte, len(m.Statuses)*10)
		var j3 int
		for _, num := range m.Statuses {
			for num >= 1<<7 {
				dAtA4[j3] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j3++
			}
			dAtA4[j3] = uint8(num)
			j3++
		}
		i -= j3
		copy(dAtA[i:], dAtA4[:j3])
		i = encodeVarintLicenseService(dAtA, i, uint64(j3))
		i--
		dAtA[i] = 0x12
	}
	if m.ActiveOpt != nil {
		{
			size := m.ActiveOpt.Size()
			i -= size
			if _, err := m.ActiveOpt.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *GetLicensesRequest_Active) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetLicensesRequest_Active) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i--
	if m.Active {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i--
	dAtA[i] = 0x8
	return len(dAtA) - i, nil
}
func (m *GetLicensesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetLicensesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetLicensesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Licenses) > 0 {
		for iNdEx := len(m.Licenses) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Licenses[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintLicenseService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *GetActiveLicenseExpirationResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetActiveLicenseExpirationResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetActiveLicenseExpirationResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ExpirationTime != nil {
		{
			size, err := m.ExpirationTime.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintLicenseService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetActiveLicenseKeyResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetActiveLicenseKeyResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetActiveLicenseKeyResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.LicenseKey) > 0 {
		i -= len(m.LicenseKey)
		copy(dAtA[i:], m.LicenseKey)
		i = encodeVarintLicenseService(dAtA, i, uint64(len(m.LicenseKey)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintLicenseService(dAtA []byte, offset int, v uint64) int {
	offset -= sovLicenseService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *LicenseInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.License != nil {
		l = m.License.Size()
		n += 1 + l + sovLicenseService(uint64(l))
	}
	if m.Status != 0 {
		n += 1 + sovLicenseService(uint64(m.Status))
	}
	l = len(m.StatusReason)
	if l > 0 {
		n += 1 + l + sovLicenseService(uint64(l))
	}
	if m.Active {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AddLicenseRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.LicenseKey)
	if l > 0 {
		n += 1 + l + sovLicenseService(uint64(l))
	}
	if m.Activate {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AddLicenseResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.License != nil {
		l = m.License.Size()
		n += 1 + l + sovLicenseService(uint64(l))
	}
	if m.Accepted {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetLicensesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ActiveOpt != nil {
		n += m.ActiveOpt.Size()
	}
	if len(m.Statuses) > 0 {
		l = 0
		for _, e := range m.Statuses {
			l += sovLicenseService(uint64(e))
		}
		n += 1 + sovLicenseService(uint64(l)) + l
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetLicensesRequest_Active) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 2
	return n
}
func (m *GetLicensesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Licenses) > 0 {
		for _, e := range m.Licenses {
			l = e.Size()
			n += 1 + l + sovLicenseService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetActiveLicenseExpirationResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ExpirationTime != nil {
		l = m.ExpirationTime.Size()
		n += 1 + l + sovLicenseService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetActiveLicenseKeyResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.LicenseKey)
	if l > 0 {
		n += 1 + l + sovLicenseService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovLicenseService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozLicenseService(x uint64) (n int) {
	return sovLicenseService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *LicenseInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLicenseService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LicenseInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LicenseInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field License", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLicenseService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLicenseService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLicenseService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.License == nil {
				m.License = &license.License{}
			}
			if err := m.License.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLicenseService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= LicenseInfo_Status(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StatusReason", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLicenseService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLicenseService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLicenseService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StatusReason = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Active", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLicenseService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Active = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipLicenseService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthLicenseService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AddLicenseRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLicenseService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AddLicenseRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AddLicenseRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LicenseKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLicenseService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLicenseService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLicenseService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LicenseKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Activate", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLicenseService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Activate = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipLicenseService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthLicenseService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AddLicenseResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLicenseService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AddLicenseResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AddLicenseResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field License", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLicenseService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLicenseService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLicenseService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.License == nil {
				m.License = &LicenseInfo{}
			}
			if err := m.License.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Accepted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLicenseService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Accepted = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipLicenseService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthLicenseService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetLicensesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLicenseService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetLicensesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetLicensesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Active", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLicenseService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.ActiveOpt = &GetLicensesRequest_Active{b}
		case 2:
			if wireType == 0 {
				var v LicenseInfo_Status
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowLicenseService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= LicenseInfo_Status(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Statuses = append(m.Statuses, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowLicenseService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthLicenseService
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthLicenseService
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				if elementCount != 0 && len(m.Statuses) == 0 {
					m.Statuses = make([]LicenseInfo_Status, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v LicenseInfo_Status
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowLicenseService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= LicenseInfo_Status(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Statuses = append(m.Statuses, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Statuses", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipLicenseService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthLicenseService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetLicensesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLicenseService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetLicensesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetLicensesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Licenses", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLicenseService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLicenseService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLicenseService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Licenses = append(m.Licenses, &LicenseInfo{})
			if err := m.Licenses[len(m.Licenses)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipLicenseService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthLicenseService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetActiveLicenseExpirationResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLicenseService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetActiveLicenseExpirationResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetActiveLicenseExpirationResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExpirationTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLicenseService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLicenseService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthLicenseService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExpirationTime == nil {
				m.ExpirationTime = &types.Timestamp{}
			}
			if err := m.ExpirationTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipLicenseService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthLicenseService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetActiveLicenseKeyResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowLicenseService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetActiveLicenseKeyResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetActiveLicenseKeyResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LicenseKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowLicenseService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthLicenseService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthLicenseService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LicenseKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipLicenseService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthLicenseService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipLicenseService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowLicenseService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowLicenseService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowLicenseService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthLicenseService
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupLicenseService
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthLicenseService
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthLicenseService        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowLicenseService          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupLicenseService = fmt.Errorf("proto: unexpected end of group")
)
