// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api/v1/metadata_service.proto

package v1

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type Metadata_LicenseStatus int32

const (
	Metadata_NONE       Metadata_LicenseStatus = 0 // Deprecated: Do not use.
	Metadata_INVALID    Metadata_LicenseStatus = 1 // Deprecated: Do not use.
	Metadata_EXPIRED    Metadata_LicenseStatus = 2 // Deprecated: Do not use.
	Metadata_RESTARTING Metadata_LicenseStatus = 3 // Deprecated: Do not use.
	Metadata_VALID      Metadata_LicenseStatus = 4
)

var Metadata_LicenseStatus_name = map[int32]string{
	0: "NONE",
	1: "INVALID",
	2: "EXPIRED",
	3: "RESTARTING",
	4: "VALID",
}

var Metadata_LicenseStatus_value = map[string]int32{
	"NONE":       0,
	"INVALID":    1,
	"EXPIRED":    2,
	"RESTARTING": 3,
	"VALID":      4,
}

func (x Metadata_LicenseStatus) String() string {
	return proto.EnumName(Metadata_LicenseStatus_name, int32(x))
}

func (Metadata_LicenseStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1b6865797fbcf5f5, []int{0, 0}
}

type Metadata struct {
	Version      string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	BuildFlavor  string `protobuf:"bytes,2,opt,name=build_flavor,json=buildFlavor,proto3" json:"build_flavor,omitempty"`
	ReleaseBuild bool   `protobuf:"varint,3,opt,name=release_build,json=releaseBuild,proto3" json:"release_build,omitempty"`
	// Do not use this field. It will always contain "VALID"
	LicenseStatus        Metadata_LicenseStatus `protobuf:"varint,4,opt,name=license_status,json=licenseStatus,proto3,enum=v1.Metadata_LicenseStatus" json:"license_status,omitempty"` // Deprecated: Do not use.
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *Metadata) Reset()         { *m = Metadata{} }
func (m *Metadata) String() string { return proto.CompactTextString(m) }
func (*Metadata) ProtoMessage()    {}
func (*Metadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b6865797fbcf5f5, []int{0}
}
func (m *Metadata) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Metadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Metadata.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Metadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metadata.Merge(m, src)
}
func (m *Metadata) XXX_Size() int {
	return m.Size()
}
func (m *Metadata) XXX_DiscardUnknown() {
	xxx_messageInfo_Metadata.DiscardUnknown(m)
}

var xxx_messageInfo_Metadata proto.InternalMessageInfo

func (m *Metadata) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *Metadata) GetBuildFlavor() string {
	if m != nil {
		return m.BuildFlavor
	}
	return ""
}

func (m *Metadata) GetReleaseBuild() bool {
	if m != nil {
		return m.ReleaseBuild
	}
	return false
}

// Deprecated: Do not use.
func (m *Metadata) GetLicenseStatus() Metadata_LicenseStatus {
	if m != nil {
		return m.LicenseStatus
	}
	return Metadata_NONE
}

func (m *Metadata) MessageClone() proto.Message {
	return m.Clone()
}
func (m *Metadata) Clone() *Metadata {
	if m == nil {
		return nil
	}
	cloned := new(Metadata)
	*cloned = *m

	return cloned
}

type TrustInfo struct {
	// holds the certificate chain hold by central
	CertChain [][]byte `protobuf:"bytes,1,rep,name=cert_chain,json=certChain,proto3" json:"cert_chain,omitempty"`
	// sensor challenge string
	SensorChallenge string `protobuf:"bytes,2,opt,name=sensor_challenge,json=sensorChallenge,proto3" json:"sensor_challenge,omitempty"`
	// central challenge string
	CentralChallenge string `protobuf:"bytes,3,opt,name=central_challenge,json=centralChallenge,proto3" json:"central_challenge,omitempty"`
	// additional CA certs configured in central in DER format
	AdditionalCas        [][]byte `protobuf:"bytes,4,rep,name=additional_cas,json=additionalCas,proto3" json:"additional_cas,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TrustInfo) Reset()         { *m = TrustInfo{} }
func (m *TrustInfo) String() string { return proto.CompactTextString(m) }
func (*TrustInfo) ProtoMessage()    {}
func (*TrustInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b6865797fbcf5f5, []int{1}
}
func (m *TrustInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TrustInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TrustInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TrustInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TrustInfo.Merge(m, src)
}
func (m *TrustInfo) XXX_Size() int {
	return m.Size()
}
func (m *TrustInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_TrustInfo.DiscardUnknown(m)
}

var xxx_messageInfo_TrustInfo proto.InternalMessageInfo

func (m *TrustInfo) GetCertChain() [][]byte {
	if m != nil {
		return m.CertChain
	}
	return nil
}

func (m *TrustInfo) GetSensorChallenge() string {
	if m != nil {
		return m.SensorChallenge
	}
	return ""
}

func (m *TrustInfo) GetCentralChallenge() string {
	if m != nil {
		return m.CentralChallenge
	}
	return ""
}

func (m *TrustInfo) GetAdditionalCas() [][]byte {
	if m != nil {
		return m.AdditionalCas
	}
	return nil
}

func (m *TrustInfo) MessageClone() proto.Message {
	return m.Clone()
}
func (m *TrustInfo) Clone() *TrustInfo {
	if m == nil {
		return nil
	}
	cloned := new(TrustInfo)
	*cloned = *m

	if m.CertChain != nil {
		cloned.CertChain = make([][]byte, len(m.CertChain))
		for idx, v := range m.CertChain {
			cloned.CertChain[idx] = make([]byte, len(v))
			copy(cloned.CertChain[idx], v)
		}
	}
	if m.AdditionalCas != nil {
		cloned.AdditionalCas = make([][]byte, len(m.AdditionalCas))
		for idx, v := range m.AdditionalCas {
			cloned.AdditionalCas[idx] = make([]byte, len(v))
			copy(cloned.AdditionalCas[idx], v)
		}
	}
	return cloned
}

type TLSChallengeResponse struct {
	// signed data which is returned to the caller, is validated against the signature
	TrustInfoSerialized  []byte   `protobuf:"bytes,1,opt,name=trust_info_serialized,json=trustInfoSerialized,proto3" json:"trust_info_serialized,omitempty"`
	Signature            []byte   `protobuf:"bytes,2,opt,name=signature,proto3" json:"signature,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TLSChallengeResponse) Reset()         { *m = TLSChallengeResponse{} }
func (m *TLSChallengeResponse) String() string { return proto.CompactTextString(m) }
func (*TLSChallengeResponse) ProtoMessage()    {}
func (*TLSChallengeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b6865797fbcf5f5, []int{2}
}
func (m *TLSChallengeResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TLSChallengeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TLSChallengeResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TLSChallengeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TLSChallengeResponse.Merge(m, src)
}
func (m *TLSChallengeResponse) XXX_Size() int {
	return m.Size()
}
func (m *TLSChallengeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_TLSChallengeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_TLSChallengeResponse proto.InternalMessageInfo

func (m *TLSChallengeResponse) GetTrustInfoSerialized() []byte {
	if m != nil {
		return m.TrustInfoSerialized
	}
	return nil
}

func (m *TLSChallengeResponse) GetSignature() []byte {
	if m != nil {
		return m.Signature
	}
	return nil
}

func (m *TLSChallengeResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *TLSChallengeResponse) Clone() *TLSChallengeResponse {
	if m == nil {
		return nil
	}
	cloned := new(TLSChallengeResponse)
	*cloned = *m

	if m.TrustInfoSerialized != nil {
		cloned.TrustInfoSerialized = make([]byte, len(m.TrustInfoSerialized))
		copy(cloned.TrustInfoSerialized, m.TrustInfoSerialized)
	}
	if m.Signature != nil {
		cloned.Signature = make([]byte, len(m.Signature))
		copy(cloned.Signature, m.Signature)
	}
	return cloned
}

type TLSChallengeRequest struct {
	// generated challenge token by the service asking for TLS certs
	ChallengeToken       string   `protobuf:"bytes,1,opt,name=challenge_token,json=challengeToken,proto3" json:"challenge_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TLSChallengeRequest) Reset()         { *m = TLSChallengeRequest{} }
func (m *TLSChallengeRequest) String() string { return proto.CompactTextString(m) }
func (*TLSChallengeRequest) ProtoMessage()    {}
func (*TLSChallengeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b6865797fbcf5f5, []int{3}
}
func (m *TLSChallengeRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TLSChallengeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TLSChallengeRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TLSChallengeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TLSChallengeRequest.Merge(m, src)
}
func (m *TLSChallengeRequest) XXX_Size() int {
	return m.Size()
}
func (m *TLSChallengeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_TLSChallengeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_TLSChallengeRequest proto.InternalMessageInfo

func (m *TLSChallengeRequest) GetChallengeToken() string {
	if m != nil {
		return m.ChallengeToken
	}
	return ""
}

func (m *TLSChallengeRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *TLSChallengeRequest) Clone() *TLSChallengeRequest {
	if m == nil {
		return nil
	}
	cloned := new(TLSChallengeRequest)
	*cloned = *m

	return cloned
}

func init() {
	proto.RegisterEnum("v1.Metadata_LicenseStatus", Metadata_LicenseStatus_name, Metadata_LicenseStatus_value)
	proto.RegisterType((*Metadata)(nil), "v1.Metadata")
	proto.RegisterType((*TrustInfo)(nil), "v1.TrustInfo")
	proto.RegisterType((*TLSChallengeResponse)(nil), "v1.TLSChallengeResponse")
	proto.RegisterType((*TLSChallengeRequest)(nil), "v1.TLSChallengeRequest")
}

func init() { proto.RegisterFile("api/v1/metadata_service.proto", fileDescriptor_1b6865797fbcf5f5) }

var fileDescriptor_1b6865797fbcf5f5 = []byte{
	// 584 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x6c, 0x93, 0xdd, 0x6e, 0xd3, 0x30,
	0x14, 0xc7, 0xe7, 0x74, 0xb0, 0xe5, 0x2c, 0x6d, 0x33, 0x6f, 0x88, 0x10, 0x6d, 0xd5, 0x08, 0x42,
	0x14, 0x21, 0x32, 0x75, 0xdc, 0x22, 0xa4, 0x7d, 0x84, 0xa9, 0xd2, 0x28, 0x28, 0xad, 0xd0, 0x84,
	0x10, 0x91, 0x97, 0x7a, 0x9d, 0xb5, 0xcc, 0x2e, 0xb1, 0x1b, 0x01, 0x97, 0xbc, 0xc2, 0x6e, 0x78,
	0x05, 0x2e, 0x78, 0x0f, 0x2e, 0x91, 0x78, 0x01, 0x34, 0x78, 0x10, 0xe4, 0xa4, 0x49, 0x3b, 0xc1,
	0x65, 0x7e, 0xe7, 0x7f, 0x4e, 0xce, 0xc7, 0xdf, 0xb0, 0x49, 0xc6, 0x6c, 0x3b, 0xeb, 0x6c, 0x5f,
	0x50, 0x45, 0x86, 0x44, 0x91, 0x48, 0xd2, 0x34, 0x63, 0x31, 0xf5, 0xc7, 0xa9, 0x50, 0x02, 0x1b,
	0x59, 0xc7, 0xdd, 0x18, 0x09, 0x31, 0x4a, 0xe8, 0xb6, 0x56, 0x12, 0xce, 0x85, 0x22, 0x8a, 0x09,
	0x2e, 0x0b, 0x85, 0x8b, 0xa7, 0x05, 0xe8, 0xc5, 0x58, 0x7d, 0x2c, 0x98, 0x77, 0x69, 0xc0, 0xf2,
	0x8b, 0x69, 0x41, 0xec, 0xc0, 0x52, 0x46, 0x53, 0xc9, 0x04, 0x77, 0xd0, 0x16, 0x6a, 0x9b, 0x61,
	0xf9, 0x89, 0xef, 0x82, 0x75, 0x32, 0x61, 0xc9, 0x30, 0x3a, 0x4d, 0x48, 0x26, 0x52, 0xc7, 0xc8,
	0xc3, 0x2b, 0x39, 0x7b, 0x9e, 0x23, 0x7c, 0x0f, 0xea, 0x29, 0x4d, 0x28, 0x91, 0x34, 0xca, 0xb1,
	0x53, 0xdb, 0x42, 0xed, 0xe5, 0xd0, 0x9a, 0xc2, 0x3d, 0xcd, 0x70, 0x00, 0x8d, 0x84, 0xc5, 0x94,
	0x4b, 0x1a, 0x49, 0x45, 0xd4, 0x44, 0x3a, 0x8b, 0x5b, 0xa8, 0xdd, 0xd8, 0x71, 0xfd, 0xac, 0xe3,
	0x97, 0x7d, 0xf8, 0x47, 0x85, 0xa4, 0x9f, 0x2b, 0xf6, 0x0c, 0x07, 0x85, 0xf5, 0x64, 0x1e, 0x79,
	0xef, 0xa0, 0x7e, 0x4d, 0x83, 0x2d, 0x58, 0xec, 0xbd, 0xec, 0x05, 0xf6, 0x82, 0x6b, 0x2c, 0x23,
	0xdc, 0x84, 0xa5, 0x6e, 0xef, 0xf5, 0xee, 0x51, 0xf7, 0xc0, 0x46, 0x25, 0x08, 0x8e, 0x5f, 0x75,
	0xc3, 0xe0, 0xc0, 0x36, 0x72, 0x80, 0x01, 0xc2, 0xa0, 0x3f, 0xd8, 0x0d, 0x07, 0xdd, 0xde, 0xa1,
	0x5d, 0xcb, 0x99, 0x09, 0x37, 0x8a, 0x9c, 0x45, 0xef, 0x2b, 0x02, 0x73, 0x90, 0x4e, 0xa4, 0xea,
	0xf2, 0x53, 0x81, 0x37, 0x01, 0x62, 0x9a, 0xaa, 0x28, 0x3e, 0x23, 0x4c, 0x6f, 0xa6, 0xd6, 0xb6,
	0x42, 0x53, 0x93, 0x7d, 0x0d, 0xf0, 0x43, 0xb0, 0x25, 0xe5, 0x52, 0xa4, 0x5a, 0x90, 0x24, 0x94,
	0x8f, 0xe8, 0x74, 0x3f, 0xcd, 0x82, 0xef, 0x97, 0x18, 0x3f, 0x82, 0xd5, 0x98, 0x72, 0x95, 0x92,
	0x64, 0x4e, 0x5b, 0xcb, 0xb5, 0xf6, 0x34, 0x30, 0x13, 0xdf, 0x87, 0x06, 0x19, 0x0e, 0x99, 0xbe,
	0xa0, 0xd6, 0x13, 0xbd, 0x2b, 0xfd, 0xeb, 0xfa, 0x8c, 0xee, 0x13, 0xe9, 0x9d, 0xc1, 0xfa, 0xe0,
	0xa8, 0x5f, 0xa5, 0x85, 0x54, 0x8e, 0x05, 0x97, 0x14, 0xef, 0xc0, 0x2d, 0xa5, 0x47, 0x88, 0x18,
	0x3f, 0x15, 0xda, 0x2b, 0x8c, 0x24, 0xec, 0x13, 0x1d, 0xe6, 0xa7, 0xb5, 0xc2, 0x35, 0x55, 0xce,
	0xd7, 0xaf, 0x42, 0x78, 0x03, 0x4c, 0xc9, 0x46, 0x9c, 0xa8, 0x49, 0x5a, 0xcc, 0x60, 0x85, 0x33,
	0xe0, 0x3d, 0x83, 0xb5, 0xeb, 0x7f, 0x7a, 0x3f, 0xa1, 0x52, 0xe1, 0x07, 0xd0, 0xac, 0x86, 0x89,
	0x94, 0x38, 0xa7, 0xa5, 0x7b, 0x1a, 0x15, 0x1e, 0x68, 0xba, 0xf3, 0x0d, 0x41, 0xb3, 0xbc, 0x71,
	0xbf, 0xf0, 0x2e, 0x7e, 0x0a, 0x2b, 0x87, 0x54, 0x55, 0x0e, 0x34, 0xb5, 0x0f, 0x02, 0xed, 0x4f,
	0xd7, 0x9a, 0xb7, 0x84, 0xb7, 0xfe, 0xf9, 0xe7, 0x9f, 0x4b, 0xa3, 0x81, 0xad, 0xf9, 0x17, 0x80,
	0xdf, 0x82, 0x35, 0xdf, 0x11, 0xbe, 0xad, 0x73, 0xfe, 0xd3, 0xa3, 0xeb, 0xfc, 0x1b, 0x28, 0xd6,
	0xe4, 0xdd, 0xc9, 0x0b, 0xaf, 0xe1, 0x55, 0x5d, 0x58, 0x25, 0xf2, 0x71, 0xd5, 0xf4, 0x9e, 0xff,
	0xfd, 0xaa, 0x85, 0x7e, 0x5c, 0xb5, 0xd0, 0xaf, 0xab, 0x16, 0xfa, 0xf2, 0xbb, 0xb5, 0x00, 0x0e,
	0x13, 0xbe, 0x54, 0x24, 0x3e, 0x4f, 0xc5, 0x87, 0xe2, 0x01, 0xf9, 0x64, 0xcc, 0xfc, 0xac, 0xf3,
	0xc6, 0xc8, 0x3a, 0xc7, 0x0b, 0x27, 0x37, 0x73, 0xf6, 0xe4, 0x6f, 0x00, 0x00, 0x00, 0xff, 0xff,
	0x34, 0x72, 0xb8, 0xde, 0xab, 0x03, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// MetadataServiceClient is the client API for MetadataService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConnInterface.NewStream.
type MetadataServiceClient interface {
	GetMetadata(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*Metadata, error)
	TLSChallenge(ctx context.Context, in *TLSChallengeRequest, opts ...grpc.CallOption) (*TLSChallengeResponse, error)
}

type metadataServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewMetadataServiceClient(cc grpc.ClientConnInterface) MetadataServiceClient {
	return &metadataServiceClient{cc}
}

func (c *metadataServiceClient) GetMetadata(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*Metadata, error) {
	out := new(Metadata)
	err := c.cc.Invoke(ctx, "/v1.MetadataService/GetMetadata", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) TLSChallenge(ctx context.Context, in *TLSChallengeRequest, opts ...grpc.CallOption) (*TLSChallengeResponse, error) {
	out := new(TLSChallengeResponse)
	err := c.cc.Invoke(ctx, "/v1.MetadataService/TLSChallenge", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MetadataServiceServer is the server API for MetadataService service.
type MetadataServiceServer interface {
	GetMetadata(context.Context, *Empty) (*Metadata, error)
	TLSChallenge(context.Context, *TLSChallengeRequest) (*TLSChallengeResponse, error)
}

// UnimplementedMetadataServiceServer can be embedded to have forward compatible implementations.
type UnimplementedMetadataServiceServer struct {
}

func (*UnimplementedMetadataServiceServer) GetMetadata(ctx context.Context, req *Empty) (*Metadata, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMetadata not implemented")
}
func (*UnimplementedMetadataServiceServer) TLSChallenge(ctx context.Context, req *TLSChallengeRequest) (*TLSChallengeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TLSChallenge not implemented")
}

func RegisterMetadataServiceServer(s *grpc.Server, srv MetadataServiceServer) {
	s.RegisterService(&_MetadataService_serviceDesc, srv)
}

func _MetadataService_GetMetadata_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).GetMetadata(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.MetadataService/GetMetadata",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).GetMetadata(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_TLSChallenge_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TLSChallengeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).TLSChallenge(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.MetadataService/TLSChallenge",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).TLSChallenge(ctx, req.(*TLSChallengeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _MetadataService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1.MetadataService",
	HandlerType: (*MetadataServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetMetadata",
			Handler:    _MetadataService_GetMetadata_Handler,
		},
		{
			MethodName: "TLSChallenge",
			Handler:    _MetadataService_TLSChallenge_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/v1/metadata_service.proto",
}

func (m *Metadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Metadata) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Metadata) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.LicenseStatus != 0 {
		i = encodeVarintMetadataService(dAtA, i, uint64(m.LicenseStatus))
		i--
		dAtA[i] = 0x20
	}
	if m.ReleaseBuild {
		i--
		if m.ReleaseBuild {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.BuildFlavor) > 0 {
		i -= len(m.BuildFlavor)
		copy(dAtA[i:], m.BuildFlavor)
		i = encodeVarintMetadataService(dAtA, i, uint64(len(m.BuildFlavor)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Version) > 0 {
		i -= len(m.Version)
		copy(dAtA[i:], m.Version)
		i = encodeVarintMetadataService(dAtA, i, uint64(len(m.Version)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *TrustInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TrustInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TrustInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.AdditionalCas) > 0 {
		for iNdEx := len(m.AdditionalCas) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.AdditionalCas[iNdEx])
			copy(dAtA[i:], m.AdditionalCas[iNdEx])
			i = encodeVarintMetadataService(dAtA, i, uint64(len(m.AdditionalCas[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.CentralChallenge) > 0 {
		i -= len(m.CentralChallenge)
		copy(dAtA[i:], m.CentralChallenge)
		i = encodeVarintMetadataService(dAtA, i, uint64(len(m.CentralChallenge)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.SensorChallenge) > 0 {
		i -= len(m.SensorChallenge)
		copy(dAtA[i:], m.SensorChallenge)
		i = encodeVarintMetadataService(dAtA, i, uint64(len(m.SensorChallenge)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.CertChain) > 0 {
		for iNdEx := len(m.CertChain) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.CertChain[iNdEx])
			copy(dAtA[i:], m.CertChain[iNdEx])
			i = encodeVarintMetadataService(dAtA, i, uint64(len(m.CertChain[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *TLSChallengeResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TLSChallengeResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TLSChallengeResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Signature) > 0 {
		i -= len(m.Signature)
		copy(dAtA[i:], m.Signature)
		i = encodeVarintMetadataService(dAtA, i, uint64(len(m.Signature)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.TrustInfoSerialized) > 0 {
		i -= len(m.TrustInfoSerialized)
		copy(dAtA[i:], m.TrustInfoSerialized)
		i = encodeVarintMetadataService(dAtA, i, uint64(len(m.TrustInfoSerialized)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *TLSChallengeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TLSChallengeRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TLSChallengeRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ChallengeToken) > 0 {
		i -= len(m.ChallengeToken)
		copy(dAtA[i:], m.ChallengeToken)
		i = encodeVarintMetadataService(dAtA, i, uint64(len(m.ChallengeToken)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintMetadataService(dAtA []byte, offset int, v uint64) int {
	offset -= sovMetadataService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Metadata) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovMetadataService(uint64(l))
	}
	l = len(m.BuildFlavor)
	if l > 0 {
		n += 1 + l + sovMetadataService(uint64(l))
	}
	if m.ReleaseBuild {
		n += 2
	}
	if m.LicenseStatus != 0 {
		n += 1 + sovMetadataService(uint64(m.LicenseStatus))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TrustInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.CertChain) > 0 {
		for _, b := range m.CertChain {
			l = len(b)
			n += 1 + l + sovMetadataService(uint64(l))
		}
	}
	l = len(m.SensorChallenge)
	if l > 0 {
		n += 1 + l + sovMetadataService(uint64(l))
	}
	l = len(m.CentralChallenge)
	if l > 0 {
		n += 1 + l + sovMetadataService(uint64(l))
	}
	if len(m.AdditionalCas) > 0 {
		for _, b := range m.AdditionalCas {
			l = len(b)
			n += 1 + l + sovMetadataService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TLSChallengeResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.TrustInfoSerialized)
	if l > 0 {
		n += 1 + l + sovMetadataService(uint64(l))
	}
	l = len(m.Signature)
	if l > 0 {
		n += 1 + l + sovMetadataService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TLSChallengeRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ChallengeToken)
	if l > 0 {
		n += 1 + l + sovMetadataService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovMetadataService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozMetadataService(x uint64) (n int) {
	return sovMetadataService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Metadata) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadataService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Metadata: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Metadata: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadataService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetadataService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMetadataService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BuildFlavor", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadataService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetadataService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMetadataService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BuildFlavor = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReleaseBuild", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadataService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ReleaseBuild = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LicenseStatus", wireType)
			}
			m.LicenseStatus = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadataService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LicenseStatus |= Metadata_LicenseStatus(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetadataService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetadataService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TrustInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadataService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TrustInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TrustInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CertChain", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadataService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMetadataService
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthMetadataService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CertChain = append(m.CertChain, make([]byte, postIndex-iNdEx))
			copy(m.CertChain[len(m.CertChain)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SensorChallenge", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadataService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetadataService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMetadataService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SensorChallenge = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CentralChallenge", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadataService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetadataService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMetadataService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CentralChallenge = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdditionalCas", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadataService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMetadataService
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthMetadataService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AdditionalCas = append(m.AdditionalCas, make([]byte, postIndex-iNdEx))
			copy(m.AdditionalCas[len(m.AdditionalCas)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetadataService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetadataService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TLSChallengeResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadataService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TLSChallengeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TLSChallengeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TrustInfoSerialized", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadataService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMetadataService
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthMetadataService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TrustInfoSerialized = append(m.TrustInfoSerialized[:0], dAtA[iNdEx:postIndex]...)
			if m.TrustInfoSerialized == nil {
				m.TrustInfoSerialized = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Signature", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadataService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMetadataService
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthMetadataService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Signature = append(m.Signature[:0], dAtA[iNdEx:postIndex]...)
			if m.Signature == nil {
				m.Signature = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetadataService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetadataService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TLSChallengeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadataService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TLSChallengeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TLSChallengeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChallengeToken", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadataService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetadataService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMetadataService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ChallengeToken = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetadataService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetadataService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipMetadataService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowMetadataService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMetadataService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMetadataService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthMetadataService
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupMetadataService
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthMetadataService
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthMetadataService        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowMetadataService          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupMetadataService = fmt.Errorf("proto: unexpected end of group")
)
