// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api/v1/mitre_service.proto

package v1

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	storage "github.com/stackrox/rox/generated/storage"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type ListMitreAttackVectorsResponse struct {
	MitreAttackVectors   []*storage.MitreAttackVector `protobuf:"bytes,1,rep,name=mitre_attack_vectors,json=mitreAttackVectors,proto3" json:"mitre_attack_vectors,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *ListMitreAttackVectorsResponse) Reset()         { *m = ListMitreAttackVectorsResponse{} }
func (m *ListMitreAttackVectorsResponse) String() string { return proto.CompactTextString(m) }
func (*ListMitreAttackVectorsResponse) ProtoMessage()    {}
func (*ListMitreAttackVectorsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_16da3126c9d20a5c, []int{0}
}
func (m *ListMitreAttackVectorsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListMitreAttackVectorsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListMitreAttackVectorsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListMitreAttackVectorsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListMitreAttackVectorsResponse.Merge(m, src)
}
func (m *ListMitreAttackVectorsResponse) XXX_Size() int {
	return m.Size()
}
func (m *ListMitreAttackVectorsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListMitreAttackVectorsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListMitreAttackVectorsResponse proto.InternalMessageInfo

func (m *ListMitreAttackVectorsResponse) GetMitreAttackVectors() []*storage.MitreAttackVector {
	if m != nil {
		return m.MitreAttackVectors
	}
	return nil
}

func (m *ListMitreAttackVectorsResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ListMitreAttackVectorsResponse) Clone() *ListMitreAttackVectorsResponse {
	if m == nil {
		return nil
	}
	cloned := new(ListMitreAttackVectorsResponse)
	*cloned = *m

	if m.MitreAttackVectors != nil {
		cloned.MitreAttackVectors = make([]*storage.MitreAttackVector, len(m.MitreAttackVectors))
		for idx, v := range m.MitreAttackVectors {
			cloned.MitreAttackVectors[idx] = v.Clone()
		}
	}
	return cloned
}

type GetMitreVectorResponse struct {
	MitreAttackVector    *storage.MitreAttackVector `protobuf:"bytes,1,opt,name=mitre_attack_vector,json=mitreAttackVector,proto3" json:"mitre_attack_vector,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *GetMitreVectorResponse) Reset()         { *m = GetMitreVectorResponse{} }
func (m *GetMitreVectorResponse) String() string { return proto.CompactTextString(m) }
func (*GetMitreVectorResponse) ProtoMessage()    {}
func (*GetMitreVectorResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_16da3126c9d20a5c, []int{1}
}
func (m *GetMitreVectorResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetMitreVectorResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetMitreVectorResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetMitreVectorResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetMitreVectorResponse.Merge(m, src)
}
func (m *GetMitreVectorResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetMitreVectorResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetMitreVectorResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetMitreVectorResponse proto.InternalMessageInfo

func (m *GetMitreVectorResponse) GetMitreAttackVector() *storage.MitreAttackVector {
	if m != nil {
		return m.MitreAttackVector
	}
	return nil
}

func (m *GetMitreVectorResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetMitreVectorResponse) Clone() *GetMitreVectorResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetMitreVectorResponse)
	*cloned = *m

	cloned.MitreAttackVector = m.MitreAttackVector.Clone()
	return cloned
}

func init() {
	proto.RegisterType((*ListMitreAttackVectorsResponse)(nil), "v1.ListMitreAttackVectorsResponse")
	proto.RegisterType((*GetMitreVectorResponse)(nil), "v1.GetMitreVectorResponse")
}

func init() { proto.RegisterFile("api/v1/mitre_service.proto", fileDescriptor_16da3126c9d20a5c) }

var fileDescriptor_16da3126c9d20a5c = []byte{
	// 342 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x84, 0x91, 0xc1, 0x4a, 0xc3, 0x30,
	0x18, 0xc7, 0x97, 0x09, 0x82, 0xf1, 0xa2, 0xd9, 0x18, 0x25, 0x6a, 0x19, 0xf5, 0xe2, 0x29, 0xa5,
	0xf3, 0x09, 0x1c, 0x8a, 0x28, 0xf3, 0x32, 0x41, 0xc4, 0xcb, 0x88, 0x5d, 0x28, 0x41, 0xdb, 0xaf,
	0x24, 0x31, 0x38, 0xc4, 0x8b, 0xaf, 0xe0, 0xc5, 0x47, 0xf2, 0x28, 0xf8, 0x02, 0x32, 0x3d, 0xf8,
	0x18, 0x92, 0xa5, 0x93, 0xc1, 0x8a, 0xde, 0xca, 0x3f, 0xff, 0xfe, 0x7f, 0xdf, 0xf7, 0xff, 0x30,
	0xe5, 0xa5, 0x8c, 0x6d, 0x12, 0xe7, 0xd2, 0x28, 0x31, 0xd2, 0x42, 0x59, 0x99, 0x0a, 0x56, 0x2a,
	0x30, 0x40, 0x9a, 0x36, 0xa1, 0xdb, 0x19, 0x40, 0x76, 0x2b, 0x62, 0x67, 0xe3, 0x45, 0x01, 0x86,
	0x1b, 0x09, 0x85, 0xf6, 0x0e, 0xda, 0xaa, 0xfe, 0x4e, 0x21, 0xcf, 0xa1, 0xa8, 0x44, 0x52, 0x89,
	0x22, 0x2f, 0xcd, 0x64, 0x6e, 0xd4, 0x06, 0x14, 0xcf, 0x84, 0xe7, 0x78, 0x31, 0x2a, 0x70, 0x38,
	0x90, 0xda, 0x9c, 0x39, 0xe9, 0xc0, 0x18, 0x9e, 0xde, 0x5c, 0x88, 0xd4, 0x80, 0xd2, 0x43, 0xa1,
	0x4b, 0x28, 0xb4, 0x20, 0x03, 0xdc, 0xf6, 0x83, 0xf1, 0xd9, 0xf3, 0xc8, 0xfa, 0xf7, 0x00, 0x75,
	0x57, 0xf6, 0xd6, 0x7b, 0x94, 0x55, 0xa9, 0x6c, 0x29, 0x62, 0x48, 0xf2, 0xa5, 0xd4, 0x68, 0x8c,
	0x3b, 0xc7, 0xc2, 0xe3, 0x2a, 0xd7, 0x9c, 0x73, 0x8a, 0x5b, 0x35, 0x9c, 0x00, 0x75, 0xd1, 0x3f,
	0x98, 0xcd, 0x25, 0x4c, 0xef, 0x1b, 0x61, 0xb2, 0x60, 0x3c, 0xf7, 0x95, 0x92, 0x0c, 0x77, 0xea,
	0x97, 0x25, 0x6b, 0xcc, 0x26, 0xec, 0xc8, 0x95, 0x45, 0x23, 0xf7, 0xf9, 0x77, 0x27, 0x51, 0xf8,
	0xf4, 0xfe, 0xf5, 0xdc, 0x0c, 0x48, 0xe7, 0xf7, 0x6c, 0x7e, 0xe8, 0xaa, 0x1b, 0x22, 0x71, 0x7b,
	0xbe, 0xe5, 0x62, 0x00, 0xd9, 0x70, 0xd9, 0x43, 0xa1, 0xe1, 0x4e, 0xa5, 0xa2, 0x3f, 0x39, 0x39,
	0xa4, 0xd4, 0x29, 0xf5, 0x8d, 0x44, 0xbb, 0x33, 0xca, 0x0e, 0xd9, 0xaa, 0xa7, 0xc4, 0x0f, 0x72,
	0xfc, 0xd8, 0x67, 0xaf, 0xd3, 0x10, 0xbd, 0x4d, 0x43, 0xf4, 0x31, 0x0d, 0xd1, 0xcb, 0x67, 0xd8,
	0xc0, 0x81, 0x04, 0xa6, 0x9d, 0x4f, 0xc1, 0xbd, 0xbf, 0x32, 0xe3, 0xa5, 0x64, 0x36, 0xb9, 0x6a,
	0xda, 0xe4, 0xb2, 0x71, 0xbd, 0x3a, 0xd3, 0xf6, 0x7f, 0x02, 0x00, 0x00, 0xff, 0xff, 0x93, 0x37,
	0x7f, 0x23, 0x77, 0x02, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// MitreAttackServiceClient is the client API for MitreAttackService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConnInterface.NewStream.
type MitreAttackServiceClient interface {
	// ListMitreAttackVectors returns all MITRE ATT&CK vectors.
	ListMitreAttackVectors(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*ListMitreAttackVectorsResponse, error)
	// GetMitreAttackVector returns the full MITRE ATT&CK vector for a tactic with all its techniques.
	GetMitreAttackVector(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*GetMitreVectorResponse, error)
}

type mitreAttackServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewMitreAttackServiceClient(cc grpc.ClientConnInterface) MitreAttackServiceClient {
	return &mitreAttackServiceClient{cc}
}

func (c *mitreAttackServiceClient) ListMitreAttackVectors(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*ListMitreAttackVectorsResponse, error) {
	out := new(ListMitreAttackVectorsResponse)
	err := c.cc.Invoke(ctx, "/v1.MitreAttackService/ListMitreAttackVectors", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *mitreAttackServiceClient) GetMitreAttackVector(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*GetMitreVectorResponse, error) {
	out := new(GetMitreVectorResponse)
	err := c.cc.Invoke(ctx, "/v1.MitreAttackService/GetMitreAttackVector", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MitreAttackServiceServer is the server API for MitreAttackService service.
type MitreAttackServiceServer interface {
	// ListMitreAttackVectors returns all MITRE ATT&CK vectors.
	ListMitreAttackVectors(context.Context, *Empty) (*ListMitreAttackVectorsResponse, error)
	// GetMitreAttackVector returns the full MITRE ATT&CK vector for a tactic with all its techniques.
	GetMitreAttackVector(context.Context, *ResourceByID) (*GetMitreVectorResponse, error)
}

// UnimplementedMitreAttackServiceServer can be embedded to have forward compatible implementations.
type UnimplementedMitreAttackServiceServer struct {
}

func (*UnimplementedMitreAttackServiceServer) ListMitreAttackVectors(ctx context.Context, req *Empty) (*ListMitreAttackVectorsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMitreAttackVectors not implemented")
}
func (*UnimplementedMitreAttackServiceServer) GetMitreAttackVector(ctx context.Context, req *ResourceByID) (*GetMitreVectorResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMitreAttackVector not implemented")
}

func RegisterMitreAttackServiceServer(s *grpc.Server, srv MitreAttackServiceServer) {
	s.RegisterService(&_MitreAttackService_serviceDesc, srv)
}

func _MitreAttackService_ListMitreAttackVectors_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MitreAttackServiceServer).ListMitreAttackVectors(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.MitreAttackService/ListMitreAttackVectors",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MitreAttackServiceServer).ListMitreAttackVectors(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _MitreAttackService_GetMitreAttackVector_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MitreAttackServiceServer).GetMitreAttackVector(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.MitreAttackService/GetMitreAttackVector",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MitreAttackServiceServer).GetMitreAttackVector(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

var _MitreAttackService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1.MitreAttackService",
	HandlerType: (*MitreAttackServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListMitreAttackVectors",
			Handler:    _MitreAttackService_ListMitreAttackVectors_Handler,
		},
		{
			MethodName: "GetMitreAttackVector",
			Handler:    _MitreAttackService_GetMitreAttackVector_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/v1/mitre_service.proto",
}

func (m *ListMitreAttackVectorsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListMitreAttackVectorsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListMitreAttackVectorsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.MitreAttackVectors) > 0 {
		for iNdEx := len(m.MitreAttackVectors) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.MitreAttackVectors[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMitreService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *GetMitreVectorResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetMitreVectorResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetMitreVectorResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.MitreAttackVector != nil {
		{
			size, err := m.MitreAttackVector.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMitreService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintMitreService(dAtA []byte, offset int, v uint64) int {
	offset -= sovMitreService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ListMitreAttackVectorsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.MitreAttackVectors) > 0 {
		for _, e := range m.MitreAttackVectors {
			l = e.Size()
			n += 1 + l + sovMitreService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetMitreVectorResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MitreAttackVector != nil {
		l = m.MitreAttackVector.Size()
		n += 1 + l + sovMitreService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovMitreService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozMitreService(x uint64) (n int) {
	return sovMitreService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ListMitreAttackVectorsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMitreService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListMitreAttackVectorsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListMitreAttackVectorsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MitreAttackVectors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMitreService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMitreService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMitreService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MitreAttackVectors = append(m.MitreAttackVectors, &storage.MitreAttackVector{})
			if err := m.MitreAttackVectors[len(m.MitreAttackVectors)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMitreService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMitreService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetMitreVectorResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMitreService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetMitreVectorResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetMitreVectorResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MitreAttackVector", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMitreService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMitreService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMitreService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MitreAttackVector == nil {
				m.MitreAttackVector = &storage.MitreAttackVector{}
			}
			if err := m.MitreAttackVector.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMitreService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMitreService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipMitreService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowMitreService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMitreService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMitreService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthMitreService
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupMitreService
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthMitreService
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthMitreService        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowMitreService          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupMitreService = fmt.Errorf("proto: unexpected end of group")
)
