// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api/v1/namespace_service.proto

package v1

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	storage "github.com/stackrox/rox/generated/storage"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type Namespace struct {
	Metadata             *storage.NamespaceMetadata `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	NumDeployments       int32                      `protobuf:"varint,2,opt,name=num_deployments,json=numDeployments,proto3" json:"num_deployments,omitempty"`
	NumSecrets           int32                      `protobuf:"varint,3,opt,name=num_secrets,json=numSecrets,proto3" json:"num_secrets,omitempty"`
	NumNetworkPolicies   int32                      `protobuf:"varint,4,opt,name=num_network_policies,json=numNetworkPolicies,proto3" json:"num_network_policies,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *Namespace) Reset()         { *m = Namespace{} }
func (m *Namespace) String() string { return proto.CompactTextString(m) }
func (*Namespace) ProtoMessage()    {}
func (*Namespace) Descriptor() ([]byte, []int) {
	return fileDescriptor_a595f584f52ae852, []int{0}
}
func (m *Namespace) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Namespace) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Namespace.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Namespace) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Namespace.Merge(m, src)
}
func (m *Namespace) XXX_Size() int {
	return m.Size()
}
func (m *Namespace) XXX_DiscardUnknown() {
	xxx_messageInfo_Namespace.DiscardUnknown(m)
}

var xxx_messageInfo_Namespace proto.InternalMessageInfo

func (m *Namespace) GetMetadata() *storage.NamespaceMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Namespace) GetNumDeployments() int32 {
	if m != nil {
		return m.NumDeployments
	}
	return 0
}

func (m *Namespace) GetNumSecrets() int32 {
	if m != nil {
		return m.NumSecrets
	}
	return 0
}

func (m *Namespace) GetNumNetworkPolicies() int32 {
	if m != nil {
		return m.NumNetworkPolicies
	}
	return 0
}

func (m *Namespace) MessageClone() proto.Message {
	return m.Clone()
}
func (m *Namespace) Clone() *Namespace {
	if m == nil {
		return nil
	}
	cloned := new(Namespace)
	*cloned = *m

	cloned.Metadata = m.Metadata.Clone()
	return cloned
}

type GetNamespacesResponse struct {
	Namespaces           []*Namespace `protobuf:"bytes,1,rep,name=namespaces,proto3" json:"namespaces,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *GetNamespacesResponse) Reset()         { *m = GetNamespacesResponse{} }
func (m *GetNamespacesResponse) String() string { return proto.CompactTextString(m) }
func (*GetNamespacesResponse) ProtoMessage()    {}
func (*GetNamespacesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a595f584f52ae852, []int{1}
}
func (m *GetNamespacesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetNamespacesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetNamespacesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetNamespacesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetNamespacesResponse.Merge(m, src)
}
func (m *GetNamespacesResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetNamespacesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetNamespacesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetNamespacesResponse proto.InternalMessageInfo

func (m *GetNamespacesResponse) GetNamespaces() []*Namespace {
	if m != nil {
		return m.Namespaces
	}
	return nil
}

func (m *GetNamespacesResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetNamespacesResponse) Clone() *GetNamespacesResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetNamespacesResponse)
	*cloned = *m

	if m.Namespaces != nil {
		cloned.Namespaces = make([]*Namespace, len(m.Namespaces))
		for idx, v := range m.Namespaces {
			cloned.Namespaces[idx] = v.Clone()
		}
	}
	return cloned
}

type GetNamespaceRequest struct {
	Query                *RawQuery `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *GetNamespaceRequest) Reset()         { *m = GetNamespaceRequest{} }
func (m *GetNamespaceRequest) String() string { return proto.CompactTextString(m) }
func (*GetNamespaceRequest) ProtoMessage()    {}
func (*GetNamespaceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a595f584f52ae852, []int{2}
}
func (m *GetNamespaceRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetNamespaceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetNamespaceRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetNamespaceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetNamespaceRequest.Merge(m, src)
}
func (m *GetNamespaceRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetNamespaceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetNamespaceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetNamespaceRequest proto.InternalMessageInfo

func (m *GetNamespaceRequest) GetQuery() *RawQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *GetNamespaceRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetNamespaceRequest) Clone() *GetNamespaceRequest {
	if m == nil {
		return nil
	}
	cloned := new(GetNamespaceRequest)
	*cloned = *m

	cloned.Query = m.Query.Clone()
	return cloned
}

func init() {
	proto.RegisterType((*Namespace)(nil), "v1.Namespace")
	proto.RegisterType((*GetNamespacesResponse)(nil), "v1.GetNamespacesResponse")
	proto.RegisterType((*GetNamespaceRequest)(nil), "v1.GetNamespaceRequest")
}

func init() { proto.RegisterFile("api/v1/namespace_service.proto", fileDescriptor_a595f584f52ae852) }

var fileDescriptor_a595f584f52ae852 = []byte{
	// 444 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x6c, 0x92, 0xcf, 0x6e, 0xd3, 0x40,
	0x10, 0xc6, 0xbb, 0x29, 0x45, 0xb0, 0x69, 0x4b, 0xb4, 0xa1, 0x60, 0x5c, 0x64, 0x22, 0x5f, 0xc8,
	0x05, 0x07, 0x07, 0x09, 0x89, 0x6b, 0x55, 0x81, 0x90, 0xa0, 0x02, 0xf7, 0x82, 0xe0, 0x10, 0x2d,
	0xce, 0x28, 0x58, 0xcd, 0xee, 0xb8, 0x3b, 0x6b, 0x97, 0x08, 0x71, 0xe1, 0x15, 0xb8, 0xf0, 0x32,
	0x88, 0x2b, 0x47, 0x24, 0x5e, 0x00, 0x05, 0x1e, 0x04, 0xf9, 0x4f, 0x5d, 0x1b, 0x71, 0xfd, 0xbe,
	0xdf, 0xf7, 0xed, 0xcc, 0x68, 0xb9, 0x27, 0xd3, 0x64, 0x92, 0x87, 0x13, 0x2d, 0x15, 0x50, 0x2a,
	0x63, 0x98, 0x11, 0x98, 0x3c, 0x89, 0x21, 0x48, 0x0d, 0x5a, 0x14, 0xbd, 0x3c, 0x74, 0x6f, 0x2f,
	0x10, 0x17, 0x4b, 0x98, 0x14, 0xa8, 0xd4, 0x1a, 0xad, 0xb4, 0x09, 0x6a, 0xaa, 0x08, 0x77, 0x58,
	0x37, 0xc4, 0xa8, 0x14, 0xea, 0x5a, 0x1c, 0x91, 0x45, 0x23, 0x17, 0xd0, 0xea, 0x55, 0x60, 0xe5,
	0x5c, 0x5a, 0x59, 0x13, 0xfb, 0x75, 0x8c, 0x40, 0x9a, 0xf8, 0x5d, 0xf7, 0x55, 0xff, 0x1b, 0xe3,
	0x57, 0x8f, 0xce, 0x93, 0xe2, 0x21, 0xbf, 0x72, 0x1e, 0x76, 0xd8, 0x88, 0x8d, 0xfb, 0x53, 0x37,
	0xa8, 0xfb, 0x83, 0x86, 0x7a, 0x5e, 0x13, 0x51, 0xc3, 0x8a, 0xbb, 0xfc, 0x9a, 0xce, 0xd4, 0x6c,
	0x0e, 0xe9, 0x12, 0x57, 0x0a, 0xb4, 0x25, 0xa7, 0x37, 0x62, 0xe3, 0xad, 0x68, 0x57, 0x67, 0xea,
	0xf0, 0x42, 0x15, 0x77, 0x78, 0xbf, 0x00, 0x09, 0x62, 0x03, 0x96, 0x9c, 0xcd, 0x12, 0xe2, 0x3a,
	0x53, 0xc7, 0x95, 0x22, 0xee, 0xf3, 0xeb, 0x05, 0xa0, 0xc1, 0x9e, 0xa1, 0x39, 0x99, 0xa5, 0xb8,
	0x4c, 0xe2, 0x04, 0xc8, 0xb9, 0x54, 0x92, 0x42, 0x67, 0xea, 0xa8, 0xb2, 0x5e, 0xd4, 0x8e, 0xff,
	0x98, 0xef, 0x3d, 0x01, 0xdb, 0x4c, 0x47, 0x11, 0x50, 0x8a, 0x9a, 0x40, 0xdc, 0xe3, 0xbc, 0xb9,
	0x09, 0x39, 0x6c, 0xb4, 0x39, 0xee, 0x4f, 0x77, 0x82, 0x3c, 0xbc, 0xd8, 0x24, 0x6a, 0x01, 0xfe,
	0x23, 0x3e, 0x6c, 0xf7, 0x44, 0x70, 0x9a, 0x01, 0x59, 0xe1, 0xf3, 0xad, 0xd3, 0x0c, 0xcc, 0xaa,
	0xbe, 0xc7, 0x76, 0x51, 0x10, 0xc9, 0xb3, 0x97, 0x85, 0x16, 0x55, 0xd6, 0xf4, 0x2b, 0xe3, 0x83,
	0x26, 0x78, 0x5c, 0xdd, 0x57, 0xbc, 0xe1, 0x3b, 0x9d, 0xb9, 0xc4, 0xcd, 0x22, 0xfa, 0x9f, 0x27,
	0xdc, 0x5b, 0xff, 0x1a, 0xcd, 0x0e, 0xfe, 0x8d, 0x4f, 0x3f, 0xff, 0x7c, 0xee, 0x0d, 0xc4, 0x6e,
	0xe7, 0xe7, 0x90, 0x78, 0xc6, 0xb7, 0xdb, 0x01, 0x31, 0x28, 0xc7, 0x02, 0xc2, 0xcc, 0xc4, 0x70,
	0xb0, 0x7a, 0x7a, 0xe8, 0x76, 0x37, 0xf5, 0xf7, 0xcb, 0xa2, 0x3d, 0x31, 0xec, 0x16, 0x4d, 0x3e,
	0x24, 0xf3, 0x8f, 0x07, 0xc1, 0xf7, 0xb5, 0xc7, 0x7e, 0xac, 0x3d, 0xf6, 0x6b, 0xed, 0xb1, 0x2f,
	0xbf, 0xbd, 0x0d, 0xee, 0x24, 0x18, 0x90, 0x95, 0xf1, 0x89, 0xc1, 0xf7, 0xd5, 0x4f, 0x09, 0x64,
	0x9a, 0x04, 0x79, 0xf8, 0xba, 0x97, 0x87, 0xaf, 0x36, 0xde, 0x5e, 0x2e, 0xb5, 0x07, 0x7f, 0x03,
	0x00, 0x00, 0xff, 0xff, 0x0a, 0x42, 0x84, 0xd5, 0xd5, 0x02, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// NamespaceServiceClient is the client API for NamespaceService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConnInterface.NewStream.
type NamespaceServiceClient interface {
	GetNamespaces(ctx context.Context, in *GetNamespaceRequest, opts ...grpc.CallOption) (*GetNamespacesResponse, error)
	GetNamespace(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*Namespace, error)
}

type namespaceServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewNamespaceServiceClient(cc grpc.ClientConnInterface) NamespaceServiceClient {
	return &namespaceServiceClient{cc}
}

func (c *namespaceServiceClient) GetNamespaces(ctx context.Context, in *GetNamespaceRequest, opts ...grpc.CallOption) (*GetNamespacesResponse, error) {
	out := new(GetNamespacesResponse)
	err := c.cc.Invoke(ctx, "/v1.NamespaceService/GetNamespaces", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *namespaceServiceClient) GetNamespace(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*Namespace, error) {
	out := new(Namespace)
	err := c.cc.Invoke(ctx, "/v1.NamespaceService/GetNamespace", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// NamespaceServiceServer is the server API for NamespaceService service.
type NamespaceServiceServer interface {
	GetNamespaces(context.Context, *GetNamespaceRequest) (*GetNamespacesResponse, error)
	GetNamespace(context.Context, *ResourceByID) (*Namespace, error)
}

// UnimplementedNamespaceServiceServer can be embedded to have forward compatible implementations.
type UnimplementedNamespaceServiceServer struct {
}

func (*UnimplementedNamespaceServiceServer) GetNamespaces(ctx context.Context, req *GetNamespaceRequest) (*GetNamespacesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNamespaces not implemented")
}
func (*UnimplementedNamespaceServiceServer) GetNamespace(ctx context.Context, req *ResourceByID) (*Namespace, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNamespace not implemented")
}

func RegisterNamespaceServiceServer(s *grpc.Server, srv NamespaceServiceServer) {
	s.RegisterService(&_NamespaceService_serviceDesc, srv)
}

func _NamespaceService_GetNamespaces_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNamespaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NamespaceServiceServer).GetNamespaces(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.NamespaceService/GetNamespaces",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NamespaceServiceServer).GetNamespaces(ctx, req.(*GetNamespaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NamespaceService_GetNamespace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NamespaceServiceServer).GetNamespace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.NamespaceService/GetNamespace",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NamespaceServiceServer).GetNamespace(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

var _NamespaceService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1.NamespaceService",
	HandlerType: (*NamespaceServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetNamespaces",
			Handler:    _NamespaceService_GetNamespaces_Handler,
		},
		{
			MethodName: "GetNamespace",
			Handler:    _NamespaceService_GetNamespace_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/v1/namespace_service.proto",
}

func (m *Namespace) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Namespace) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Namespace) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.NumNetworkPolicies != 0 {
		i = encodeVarintNamespaceService(dAtA, i, uint64(m.NumNetworkPolicies))
		i--
		dAtA[i] = 0x20
	}
	if m.NumSecrets != 0 {
		i = encodeVarintNamespaceService(dAtA, i, uint64(m.NumSecrets))
		i--
		dAtA[i] = 0x18
	}
	if m.NumDeployments != 0 {
		i = encodeVarintNamespaceService(dAtA, i, uint64(m.NumDeployments))
		i--
		dAtA[i] = 0x10
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNamespaceService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetNamespacesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetNamespacesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetNamespacesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Namespaces) > 0 {
		for iNdEx := len(m.Namespaces) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Namespaces[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintNamespaceService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *GetNamespaceRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetNamespaceRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetNamespaceRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Query != nil {
		{
			size, err := m.Query.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNamespaceService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintNamespaceService(dAtA []byte, offset int, v uint64) int {
	offset -= sovNamespaceService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Namespace) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovNamespaceService(uint64(l))
	}
	if m.NumDeployments != 0 {
		n += 1 + sovNamespaceService(uint64(m.NumDeployments))
	}
	if m.NumSecrets != 0 {
		n += 1 + sovNamespaceService(uint64(m.NumSecrets))
	}
	if m.NumNetworkPolicies != 0 {
		n += 1 + sovNamespaceService(uint64(m.NumNetworkPolicies))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetNamespacesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Namespaces) > 0 {
		for _, e := range m.Namespaces {
			l = e.Size()
			n += 1 + l + sovNamespaceService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetNamespaceRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Query != nil {
		l = m.Query.Size()
		n += 1 + l + sovNamespaceService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovNamespaceService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozNamespaceService(x uint64) (n int) {
	return sovNamespaceService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Namespace) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNamespaceService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Namespace: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Namespace: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNamespaceService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNamespaceService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNamespaceService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &storage.NamespaceMetadata{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumDeployments", wireType)
			}
			m.NumDeployments = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNamespaceService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumDeployments |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumSecrets", wireType)
			}
			m.NumSecrets = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNamespaceService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumSecrets |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumNetworkPolicies", wireType)
			}
			m.NumNetworkPolicies = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNamespaceService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumNetworkPolicies |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipNamespaceService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNamespaceService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetNamespacesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNamespaceService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetNamespacesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetNamespacesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespaces", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNamespaceService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNamespaceService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNamespaceService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespaces = append(m.Namespaces, &Namespace{})
			if err := m.Namespaces[len(m.Namespaces)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNamespaceService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNamespaceService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetNamespaceRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNamespaceService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetNamespaceRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetNamespaceRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNamespaceService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNamespaceService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNamespaceService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Query == nil {
				m.Query = &RawQuery{}
			}
			if err := m.Query.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNamespaceService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNamespaceService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipNamespaceService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowNamespaceService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowNamespaceService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowNamespaceService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthNamespaceService
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupNamespaceService
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthNamespaceService
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthNamespaceService        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowNamespaceService          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupNamespaceService = fmt.Errorf("proto: unexpected end of group")
)
