// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api/v1/network_baseline_service.proto

package v1

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	storage "github.com/stackrox/rox/generated/storage"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Status of this peer connection. As of now we only have two statuses:
//   - BASELINE: the connection is in the current deployment baseline
//   - ANOMALOUS: the connection is not recognized by the current deployment baseline
type NetworkBaselinePeerStatus_Status int32

const (
	NetworkBaselinePeerStatus_BASELINE  NetworkBaselinePeerStatus_Status = 0
	NetworkBaselinePeerStatus_ANOMALOUS NetworkBaselinePeerStatus_Status = 1
)

var NetworkBaselinePeerStatus_Status_name = map[int32]string{
	0: "BASELINE",
	1: "ANOMALOUS",
}

var NetworkBaselinePeerStatus_Status_value = map[string]int32{
	"BASELINE":  0,
	"ANOMALOUS": 1,
}

func (x NetworkBaselinePeerStatus_Status) String() string {
	return proto.EnumName(NetworkBaselinePeerStatus_Status_name, int32(x))
}

func (NetworkBaselinePeerStatus_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_077bbc20584cb43f, []int{2, 0}
}

type NetworkBaselinePeerEntity struct {
	Id                   string                         `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Type                 storage.NetworkEntityInfo_Type `protobuf:"varint,2,opt,name=type,proto3,enum=storage.NetworkEntityInfo_Type" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *NetworkBaselinePeerEntity) Reset()         { *m = NetworkBaselinePeerEntity{} }
func (m *NetworkBaselinePeerEntity) String() string { return proto.CompactTextString(m) }
func (*NetworkBaselinePeerEntity) ProtoMessage()    {}
func (*NetworkBaselinePeerEntity) Descriptor() ([]byte, []int) {
	return fileDescriptor_077bbc20584cb43f, []int{0}
}
func (m *NetworkBaselinePeerEntity) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkBaselinePeerEntity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkBaselinePeerEntity.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkBaselinePeerEntity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkBaselinePeerEntity.Merge(m, src)
}
func (m *NetworkBaselinePeerEntity) XXX_Size() int {
	return m.Size()
}
func (m *NetworkBaselinePeerEntity) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkBaselinePeerEntity.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkBaselinePeerEntity proto.InternalMessageInfo

func (m *NetworkBaselinePeerEntity) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *NetworkBaselinePeerEntity) GetType() storage.NetworkEntityInfo_Type {
	if m != nil {
		return m.Type
	}
	return storage.NetworkEntityInfo_UNKNOWN_TYPE
}

func (m *NetworkBaselinePeerEntity) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkBaselinePeerEntity) Clone() *NetworkBaselinePeerEntity {
	if m == nil {
		return nil
	}
	cloned := new(NetworkBaselinePeerEntity)
	*cloned = *m

	return cloned
}

type NetworkBaselineStatusPeer struct {
	// The peer entity of the connection. This can be constructed from the
	// entity object of the networkgraph API. Only the ID and type are required.
	Entity *NetworkBaselinePeerEntity `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// The port and protocol of the destination of the given connection.
	Port     uint32             `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	Protocol storage.L4Protocol `protobuf:"varint,3,opt,name=protocol,proto3,enum=storage.L4Protocol" json:"protocol,omitempty"`
	// A boolean representing whether the query is for an ingress or egress
	// connection. This is defined with respect to the current deployment.
	// Thus:
	//   - If the connection in question is in the outEdges of the current deployment,
	//     this should be false.
	//   - If it is in the outEdges of the peer deployment, this
	//     should be true.
	Ingress              bool     `protobuf:"varint,4,opt,name=ingress,proto3" json:"ingress,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NetworkBaselineStatusPeer) Reset()         { *m = NetworkBaselineStatusPeer{} }
func (m *NetworkBaselineStatusPeer) String() string { return proto.CompactTextString(m) }
func (*NetworkBaselineStatusPeer) ProtoMessage()    {}
func (*NetworkBaselineStatusPeer) Descriptor() ([]byte, []int) {
	return fileDescriptor_077bbc20584cb43f, []int{1}
}
func (m *NetworkBaselineStatusPeer) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkBaselineStatusPeer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkBaselineStatusPeer.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkBaselineStatusPeer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkBaselineStatusPeer.Merge(m, src)
}
func (m *NetworkBaselineStatusPeer) XXX_Size() int {
	return m.Size()
}
func (m *NetworkBaselineStatusPeer) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkBaselineStatusPeer.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkBaselineStatusPeer proto.InternalMessageInfo

func (m *NetworkBaselineStatusPeer) GetEntity() *NetworkBaselinePeerEntity {
	if m != nil {
		return m.Entity
	}
	return nil
}

func (m *NetworkBaselineStatusPeer) GetPort() uint32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *NetworkBaselineStatusPeer) GetProtocol() storage.L4Protocol {
	if m != nil {
		return m.Protocol
	}
	return storage.L4Protocol_L4_PROTOCOL_UNKNOWN
}

func (m *NetworkBaselineStatusPeer) GetIngress() bool {
	if m != nil {
		return m.Ingress
	}
	return false
}

func (m *NetworkBaselineStatusPeer) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkBaselineStatusPeer) Clone() *NetworkBaselineStatusPeer {
	if m == nil {
		return nil
	}
	cloned := new(NetworkBaselineStatusPeer)
	*cloned = *m

	cloned.Entity = m.Entity.Clone()
	return cloned
}

type NetworkBaselinePeerStatus struct {
	Peer                 *NetworkBaselineStatusPeer       `protobuf:"bytes,1,opt,name=peer,proto3" json:"peer,omitempty"`
	Status               NetworkBaselinePeerStatus_Status `protobuf:"varint,2,opt,name=status,proto3,enum=v1.NetworkBaselinePeerStatus_Status" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_unrecognized     []byte                           `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *NetworkBaselinePeerStatus) Reset()         { *m = NetworkBaselinePeerStatus{} }
func (m *NetworkBaselinePeerStatus) String() string { return proto.CompactTextString(m) }
func (*NetworkBaselinePeerStatus) ProtoMessage()    {}
func (*NetworkBaselinePeerStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_077bbc20584cb43f, []int{2}
}
func (m *NetworkBaselinePeerStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkBaselinePeerStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkBaselinePeerStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkBaselinePeerStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkBaselinePeerStatus.Merge(m, src)
}
func (m *NetworkBaselinePeerStatus) XXX_Size() int {
	return m.Size()
}
func (m *NetworkBaselinePeerStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkBaselinePeerStatus.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkBaselinePeerStatus proto.InternalMessageInfo

func (m *NetworkBaselinePeerStatus) GetPeer() *NetworkBaselineStatusPeer {
	if m != nil {
		return m.Peer
	}
	return nil
}

func (m *NetworkBaselinePeerStatus) GetStatus() NetworkBaselinePeerStatus_Status {
	if m != nil {
		return m.Status
	}
	return NetworkBaselinePeerStatus_BASELINE
}

func (m *NetworkBaselinePeerStatus) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkBaselinePeerStatus) Clone() *NetworkBaselinePeerStatus {
	if m == nil {
		return nil
	}
	cloned := new(NetworkBaselinePeerStatus)
	*cloned = *m

	cloned.Peer = m.Peer.Clone()
	return cloned
}

type NetworkBaselineStatusRequest struct {
	DeploymentId         string                       `protobuf:"bytes,1,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	Peers                []*NetworkBaselineStatusPeer `protobuf:"bytes,2,rep,name=peers,proto3" json:"peers,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *NetworkBaselineStatusRequest) Reset()         { *m = NetworkBaselineStatusRequest{} }
func (m *NetworkBaselineStatusRequest) String() string { return proto.CompactTextString(m) }
func (*NetworkBaselineStatusRequest) ProtoMessage()    {}
func (*NetworkBaselineStatusRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_077bbc20584cb43f, []int{3}
}
func (m *NetworkBaselineStatusRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkBaselineStatusRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkBaselineStatusRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkBaselineStatusRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkBaselineStatusRequest.Merge(m, src)
}
func (m *NetworkBaselineStatusRequest) XXX_Size() int {
	return m.Size()
}
func (m *NetworkBaselineStatusRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkBaselineStatusRequest.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkBaselineStatusRequest proto.InternalMessageInfo

func (m *NetworkBaselineStatusRequest) GetDeploymentId() string {
	if m != nil {
		return m.DeploymentId
	}
	return ""
}

func (m *NetworkBaselineStatusRequest) GetPeers() []*NetworkBaselineStatusPeer {
	if m != nil {
		return m.Peers
	}
	return nil
}

func (m *NetworkBaselineStatusRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkBaselineStatusRequest) Clone() *NetworkBaselineStatusRequest {
	if m == nil {
		return nil
	}
	cloned := new(NetworkBaselineStatusRequest)
	*cloned = *m

	if m.Peers != nil {
		cloned.Peers = make([]*NetworkBaselineStatusPeer, len(m.Peers))
		for idx, v := range m.Peers {
			cloned.Peers[idx] = v.Clone()
		}
	}
	return cloned
}

type NetworkBaselineStatusResponse struct {
	Statuses             []*NetworkBaselinePeerStatus `protobuf:"bytes,1,rep,name=statuses,proto3" json:"statuses,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *NetworkBaselineStatusResponse) Reset()         { *m = NetworkBaselineStatusResponse{} }
func (m *NetworkBaselineStatusResponse) String() string { return proto.CompactTextString(m) }
func (*NetworkBaselineStatusResponse) ProtoMessage()    {}
func (*NetworkBaselineStatusResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_077bbc20584cb43f, []int{4}
}
func (m *NetworkBaselineStatusResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkBaselineStatusResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkBaselineStatusResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkBaselineStatusResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkBaselineStatusResponse.Merge(m, src)
}
func (m *NetworkBaselineStatusResponse) XXX_Size() int {
	return m.Size()
}
func (m *NetworkBaselineStatusResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkBaselineStatusResponse.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkBaselineStatusResponse proto.InternalMessageInfo

func (m *NetworkBaselineStatusResponse) GetStatuses() []*NetworkBaselinePeerStatus {
	if m != nil {
		return m.Statuses
	}
	return nil
}

func (m *NetworkBaselineStatusResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkBaselineStatusResponse) Clone() *NetworkBaselineStatusResponse {
	if m == nil {
		return nil
	}
	cloned := new(NetworkBaselineStatusResponse)
	*cloned = *m

	if m.Statuses != nil {
		cloned.Statuses = make([]*NetworkBaselinePeerStatus, len(m.Statuses))
		for idx, v := range m.Statuses {
			cloned.Statuses[idx] = v.Clone()
		}
	}
	return cloned
}

type ModifyBaselineStatusForPeersRequest struct {
	DeploymentId         string                       `protobuf:"bytes,1,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	Peers                []*NetworkBaselinePeerStatus `protobuf:"bytes,2,rep,name=peers,proto3" json:"peers,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *ModifyBaselineStatusForPeersRequest) Reset()         { *m = ModifyBaselineStatusForPeersRequest{} }
func (m *ModifyBaselineStatusForPeersRequest) String() string { return proto.CompactTextString(m) }
func (*ModifyBaselineStatusForPeersRequest) ProtoMessage()    {}
func (*ModifyBaselineStatusForPeersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_077bbc20584cb43f, []int{5}
}
func (m *ModifyBaselineStatusForPeersRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ModifyBaselineStatusForPeersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ModifyBaselineStatusForPeersRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ModifyBaselineStatusForPeersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ModifyBaselineStatusForPeersRequest.Merge(m, src)
}
func (m *ModifyBaselineStatusForPeersRequest) XXX_Size() int {
	return m.Size()
}
func (m *ModifyBaselineStatusForPeersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ModifyBaselineStatusForPeersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ModifyBaselineStatusForPeersRequest proto.InternalMessageInfo

func (m *ModifyBaselineStatusForPeersRequest) GetDeploymentId() string {
	if m != nil {
		return m.DeploymentId
	}
	return ""
}

func (m *ModifyBaselineStatusForPeersRequest) GetPeers() []*NetworkBaselinePeerStatus {
	if m != nil {
		return m.Peers
	}
	return nil
}

func (m *ModifyBaselineStatusForPeersRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ModifyBaselineStatusForPeersRequest) Clone() *ModifyBaselineStatusForPeersRequest {
	if m == nil {
		return nil
	}
	cloned := new(ModifyBaselineStatusForPeersRequest)
	*cloned = *m

	if m.Peers != nil {
		cloned.Peers = make([]*NetworkBaselinePeerStatus, len(m.Peers))
		for idx, v := range m.Peers {
			cloned.Peers[idx] = v.Clone()
		}
	}
	return cloned
}

func init() {
	proto.RegisterEnum("v1.NetworkBaselinePeerStatus_Status", NetworkBaselinePeerStatus_Status_name, NetworkBaselinePeerStatus_Status_value)
	proto.RegisterType((*NetworkBaselinePeerEntity)(nil), "v1.NetworkBaselinePeerEntity")
	proto.RegisterType((*NetworkBaselineStatusPeer)(nil), "v1.NetworkBaselineStatusPeer")
	proto.RegisterType((*NetworkBaselinePeerStatus)(nil), "v1.NetworkBaselinePeerStatus")
	proto.RegisterType((*NetworkBaselineStatusRequest)(nil), "v1.NetworkBaselineStatusRequest")
	proto.RegisterType((*NetworkBaselineStatusResponse)(nil), "v1.NetworkBaselineStatusResponse")
	proto.RegisterType((*ModifyBaselineStatusForPeersRequest)(nil), "v1.ModifyBaselineStatusForPeersRequest")
}

func init() {
	proto.RegisterFile("api/v1/network_baseline_service.proto", fileDescriptor_077bbc20584cb43f)
}

var fileDescriptor_077bbc20584cb43f = []byte{
	// 690 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x54, 0x4d, 0x4f, 0x13, 0x4f,
	0x18, 0x67, 0x4a, 0xff, 0xfd, 0x97, 0x11, 0x08, 0x19, 0xa2, 0x59, 0x37, 0x50, 0xea, 0x02, 0xb1,
	0x72, 0xd8, 0x4d, 0x0b, 0x1c, 0x34, 0x5e, 0x68, 0x2c, 0xa6, 0x49, 0x79, 0xc9, 0x22, 0x89, 0x21,
	0x26, 0xb0, 0x6c, 0x87, 0x66, 0xd3, 0xed, 0x3e, 0xeb, 0xce, 0xb4, 0xb0, 0x31, 0xc4, 0xc4, 0x93,
	0x77, 0x2f, 0x9e, 0xfc, 0x0e, 0xc6, 0x2f, 0xe1, 0xd1, 0xc4, 0x2f, 0x60, 0xd0, 0x83, 0x1f, 0xc3,
	0xec, 0xcc, 0x50, 0xde, 0xba, 0x80, 0x89, 0xa7, 0x76, 0x9f, 0xf9, 0x3d, 0xbf, 0x97, 0xe7, 0xc9,
	0x0c, 0x9e, 0x77, 0x42, 0xcf, 0xea, 0x95, 0xad, 0x80, 0xf2, 0x43, 0x88, 0xda, 0xbb, 0xfb, 0x0e,
	0xa3, 0xbe, 0x17, 0xd0, 0x5d, 0x46, 0xa3, 0x9e, 0xe7, 0x52, 0x33, 0x8c, 0x80, 0x03, 0xc9, 0xf4,
	0xca, 0xfa, 0x54, 0x0b, 0xa0, 0xe5, 0x53, 0x2b, 0xe9, 0x70, 0x82, 0x00, 0xb8, 0xc3, 0x3d, 0x08,
	0x98, 0x44, 0xe8, 0x93, 0x8a, 0xc8, 0x85, 0x4e, 0x07, 0x02, 0x55, 0x24, 0xaa, 0x48, 0x3b, 0x21,
	0x8f, 0x55, 0xad, 0xc0, 0x38, 0x44, 0x4e, 0x8b, 0x5e, 0x91, 0x54, 0xe7, 0xfa, 0xe5, 0xf3, 0x03,
	0x1f, 0x0e, 0xe5, 0x99, 0xb1, 0x87, 0xef, 0xaf, 0xcb, 0x6a, 0x55, 0x35, 0x6d, 0x52, 0x1a, 0xd5,
	0x02, 0xee, 0xf1, 0x98, 0x8c, 0xe3, 0x8c, 0xd7, 0xd4, 0x50, 0x11, 0x95, 0x46, 0xec, 0x8c, 0xd7,
	0x24, 0x8b, 0x38, 0xcb, 0xe3, 0x90, 0x6a, 0x99, 0x22, 0x2a, 0x8d, 0x57, 0x66, 0x4c, 0xc5, 0x6b,
	0x2a, 0x06, 0xd9, 0x55, 0x0f, 0x0e, 0xc0, 0x7c, 0x11, 0x87, 0xd4, 0x16, 0x60, 0xe3, 0x33, 0xba,
	0x22, 0xb1, 0xc5, 0x1d, 0xde, 0x65, 0x89, 0x10, 0x59, 0xc6, 0x39, 0x2a, 0xda, 0x84, 0xcc, 0x9d,
	0xca, 0xb4, 0xd9, 0x2b, 0x9b, 0xa9, 0x8e, 0x6c, 0x05, 0x26, 0x04, 0x67, 0x43, 0x88, 0xb8, 0x70,
	0x32, 0x66, 0x8b, 0xff, 0xc4, 0xc2, 0x79, 0x91, 0xc9, 0x05, 0x5f, 0x1b, 0x16, 0x0e, 0x27, 0xfb,
	0x0e, 0x1b, 0x4b, 0x9b, 0xea, 0xc8, 0xee, 0x83, 0x88, 0x86, 0xff, 0xf7, 0x82, 0x56, 0x44, 0x19,
	0xd3, 0xb2, 0x45, 0x54, 0xca, 0xdb, 0xa7, 0x9f, 0xc6, 0x17, 0x34, 0x70, 0x2c, 0xd2, 0x37, 0x29,
	0xe3, 0x6c, 0x48, 0x69, 0x74, 0x8d, 0xe3, 0xb3, 0x80, 0xb6, 0x80, 0x92, 0xa7, 0x38, 0xc7, 0x44,
	0x4d, 0xcd, 0x6e, 0x2e, 0x25, 0xa6, 0x6c, 0x34, 0xe5, 0x8f, 0xad, 0x7a, 0x8c, 0x79, 0x9c, 0x53,
	0xd2, 0xa3, 0x38, 0x5f, 0x5d, 0xd9, 0xaa, 0x35, 0xea, 0xeb, 0xb5, 0x89, 0x21, 0x32, 0x86, 0x47,
	0x56, 0xd6, 0x37, 0xd6, 0x56, 0x1a, 0x1b, 0xdb, 0x5b, 0x13, 0xc8, 0x38, 0xc2, 0x53, 0x03, 0x7d,
	0xd8, 0xf4, 0x75, 0x97, 0x32, 0x4e, 0x66, 0xf1, 0x58, 0x93, 0x86, 0x3e, 0xc4, 0x1d, 0x1a, 0xf0,
	0xdd, 0xfe, 0x66, 0x47, 0xcf, 0x8a, 0xf5, 0x64, 0xc7, 0xff, 0x25, 0x8e, 0x13, 0xa3, 0xc3, 0x37,
	0xa7, 0x93, 0x58, 0x63, 0x07, 0x4f, 0xa7, 0x28, 0xb3, 0x10, 0x02, 0x46, 0xc9, 0x63, 0x9c, 0x97,
	0x59, 0x28, 0xd3, 0x50, 0x2a, 0xf1, 0xd9, 0x04, 0xec, 0x3e, 0xdc, 0x78, 0x8b, 0x67, 0xd7, 0xa0,
	0xe9, 0x1d, 0xc4, 0x17, 0xa9, 0x57, 0x21, 0x4a, 0xe0, 0xff, 0x3c, 0xdc, 0x39, 0x0f, 0x12, 0x5b,
	0xf9, 0x9d, 0xc5, 0xf7, 0x2e, 0xa7, 0x93, 0x57, 0x99, 0x7c, 0x42, 0xb8, 0xf8, 0x9c, 0xf2, 0x81,
	0xd9, 0x57, 0x21, 0x5a, 0xf5, 0xe1, 0x90, 0x91, 0x62, 0xea, 0x08, 0x95, 0x77, 0xfd, 0xc1, 0x35,
	0x08, 0x39, 0x40, 0x63, 0xf9, 0xdd, 0xf7, 0x5f, 0x1f, 0x32, 0x96, 0xb1, 0x70, 0xee, 0x69, 0x39,
	0xbd, 0xe6, 0xd6, 0x9b, 0x0b, 0xc9, 0x8f, 0x2d, 0x39, 0xbb, 0x27, 0x68, 0x81, 0xec, 0x63, 0x72,
	0xd5, 0x1f, 0x99, 0x48, 0xf4, 0x6c, 0xca, 0xa0, 0x1b, 0xb9, 0xb4, 0x1a, 0xd7, 0x9f, 0xe9, 0xda,
	0xe5, 0xbb, 0x7c, 0x8a, 0x35, 0x8a, 0x42, 0x58, 0x27, 0xda, 0x40, 0x61, 0xaf, 0x79, 0x4c, 0xde,
	0x23, 0x3c, 0x75, 0xdd, 0x86, 0xc8, 0xc3, 0x44, 0xee, 0x16, 0x3b, 0xd4, 0x47, 0x12, 0x60, 0x2d,
	0x79, 0xd9, 0x8c, 0x25, 0x21, 0x6b, 0x56, 0x1e, 0xdd, 0x26, 0xaf, 0xd8, 0x53, 0x12, 0xf7, 0x15,
	0x9e, 0x6c, 0x80, 0xdb, 0xbe, 0x39, 0xef, 0x39, 0xa5, 0x92, 0x50, 0x32, 0x2a, 0xd3, 0x69, 0x01,
	0x2d, 0x1f, 0xdc, 0x76, 0xc2, 0xbe, 0x87, 0xef, 0x6e, 0x07, 0xfe, 0xdf, 0xf2, 0x2f, 0x08, 0xfe,
	0xb9, 0xca, 0x4c, 0x2a, 0x7f, 0x37, 0x50, 0x0a, 0x55, 0xf3, 0xeb, 0x49, 0x01, 0x7d, 0x3b, 0x29,
	0xa0, 0x1f, 0x27, 0x05, 0xf4, 0xf1, 0x67, 0x61, 0x08, 0x6b, 0x1e, 0x98, 0x8c, 0x3b, 0x6e, 0x3b,
	0x82, 0x23, 0xf9, 0x64, 0x9b, 0x4e, 0xe8, 0x99, 0xbd, 0xf2, 0x4e, 0xa6, 0x57, 0x7e, 0x39, 0xb4,
	0x9f, 0x13, 0xb5, 0xc5, 0x3f, 0x01, 0x00, 0x00, 0xff, 0xff, 0xd2, 0xd9, 0xd7, 0x47, 0x76, 0x06,
	0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// NetworkBaselineServiceClient is the client API for NetworkBaselineService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConnInterface.NewStream.
type NetworkBaselineServiceClient interface {
	GetNetworkBaselineStatusForFlows(ctx context.Context, in *NetworkBaselineStatusRequest, opts ...grpc.CallOption) (*NetworkBaselineStatusResponse, error)
	GetNetworkBaseline(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*storage.NetworkBaseline, error)
	ModifyBaselineStatusForPeers(ctx context.Context, in *ModifyBaselineStatusForPeersRequest, opts ...grpc.CallOption) (*Empty, error)
	LockNetworkBaseline(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*Empty, error)
	UnlockNetworkBaseline(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*Empty, error)
}

type networkBaselineServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewNetworkBaselineServiceClient(cc grpc.ClientConnInterface) NetworkBaselineServiceClient {
	return &networkBaselineServiceClient{cc}
}

func (c *networkBaselineServiceClient) GetNetworkBaselineStatusForFlows(ctx context.Context, in *NetworkBaselineStatusRequest, opts ...grpc.CallOption) (*NetworkBaselineStatusResponse, error) {
	out := new(NetworkBaselineStatusResponse)
	err := c.cc.Invoke(ctx, "/v1.NetworkBaselineService/GetNetworkBaselineStatusForFlows", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkBaselineServiceClient) GetNetworkBaseline(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*storage.NetworkBaseline, error) {
	out := new(storage.NetworkBaseline)
	err := c.cc.Invoke(ctx, "/v1.NetworkBaselineService/GetNetworkBaseline", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkBaselineServiceClient) ModifyBaselineStatusForPeers(ctx context.Context, in *ModifyBaselineStatusForPeersRequest, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.NetworkBaselineService/ModifyBaselineStatusForPeers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkBaselineServiceClient) LockNetworkBaseline(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.NetworkBaselineService/LockNetworkBaseline", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkBaselineServiceClient) UnlockNetworkBaseline(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.NetworkBaselineService/UnlockNetworkBaseline", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// NetworkBaselineServiceServer is the server API for NetworkBaselineService service.
type NetworkBaselineServiceServer interface {
	GetNetworkBaselineStatusForFlows(context.Context, *NetworkBaselineStatusRequest) (*NetworkBaselineStatusResponse, error)
	GetNetworkBaseline(context.Context, *ResourceByID) (*storage.NetworkBaseline, error)
	ModifyBaselineStatusForPeers(context.Context, *ModifyBaselineStatusForPeersRequest) (*Empty, error)
	LockNetworkBaseline(context.Context, *ResourceByID) (*Empty, error)
	UnlockNetworkBaseline(context.Context, *ResourceByID) (*Empty, error)
}

// UnimplementedNetworkBaselineServiceServer can be embedded to have forward compatible implementations.
type UnimplementedNetworkBaselineServiceServer struct {
}

func (*UnimplementedNetworkBaselineServiceServer) GetNetworkBaselineStatusForFlows(ctx context.Context, req *NetworkBaselineStatusRequest) (*NetworkBaselineStatusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNetworkBaselineStatusForFlows not implemented")
}
func (*UnimplementedNetworkBaselineServiceServer) GetNetworkBaseline(ctx context.Context, req *ResourceByID) (*storage.NetworkBaseline, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNetworkBaseline not implemented")
}
func (*UnimplementedNetworkBaselineServiceServer) ModifyBaselineStatusForPeers(ctx context.Context, req *ModifyBaselineStatusForPeersRequest) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ModifyBaselineStatusForPeers not implemented")
}
func (*UnimplementedNetworkBaselineServiceServer) LockNetworkBaseline(ctx context.Context, req *ResourceByID) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LockNetworkBaseline not implemented")
}
func (*UnimplementedNetworkBaselineServiceServer) UnlockNetworkBaseline(ctx context.Context, req *ResourceByID) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UnlockNetworkBaseline not implemented")
}

func RegisterNetworkBaselineServiceServer(s *grpc.Server, srv NetworkBaselineServiceServer) {
	s.RegisterService(&_NetworkBaselineService_serviceDesc, srv)
}

func _NetworkBaselineService_GetNetworkBaselineStatusForFlows_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NetworkBaselineStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkBaselineServiceServer).GetNetworkBaselineStatusForFlows(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.NetworkBaselineService/GetNetworkBaselineStatusForFlows",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkBaselineServiceServer).GetNetworkBaselineStatusForFlows(ctx, req.(*NetworkBaselineStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkBaselineService_GetNetworkBaseline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkBaselineServiceServer).GetNetworkBaseline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.NetworkBaselineService/GetNetworkBaseline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkBaselineServiceServer).GetNetworkBaseline(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkBaselineService_ModifyBaselineStatusForPeers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ModifyBaselineStatusForPeersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkBaselineServiceServer).ModifyBaselineStatusForPeers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.NetworkBaselineService/ModifyBaselineStatusForPeers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkBaselineServiceServer).ModifyBaselineStatusForPeers(ctx, req.(*ModifyBaselineStatusForPeersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkBaselineService_LockNetworkBaseline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkBaselineServiceServer).LockNetworkBaseline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.NetworkBaselineService/LockNetworkBaseline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkBaselineServiceServer).LockNetworkBaseline(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkBaselineService_UnlockNetworkBaseline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkBaselineServiceServer).UnlockNetworkBaseline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.NetworkBaselineService/UnlockNetworkBaseline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkBaselineServiceServer).UnlockNetworkBaseline(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

var _NetworkBaselineService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1.NetworkBaselineService",
	HandlerType: (*NetworkBaselineServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetNetworkBaselineStatusForFlows",
			Handler:    _NetworkBaselineService_GetNetworkBaselineStatusForFlows_Handler,
		},
		{
			MethodName: "GetNetworkBaseline",
			Handler:    _NetworkBaselineService_GetNetworkBaseline_Handler,
		},
		{
			MethodName: "ModifyBaselineStatusForPeers",
			Handler:    _NetworkBaselineService_ModifyBaselineStatusForPeers_Handler,
		},
		{
			MethodName: "LockNetworkBaseline",
			Handler:    _NetworkBaselineService_LockNetworkBaseline_Handler,
		},
		{
			MethodName: "UnlockNetworkBaseline",
			Handler:    _NetworkBaselineService_UnlockNetworkBaseline_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/v1/network_baseline_service.proto",
}

func (m *NetworkBaselinePeerEntity) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkBaselinePeerEntity) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkBaselinePeerEntity) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Type != 0 {
		i = encodeVarintNetworkBaselineService(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintNetworkBaselineService(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NetworkBaselineStatusPeer) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkBaselineStatusPeer) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkBaselineStatusPeer) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Ingress {
		i--
		if m.Ingress {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.Protocol != 0 {
		i = encodeVarintNetworkBaselineService(dAtA, i, uint64(m.Protocol))
		i--
		dAtA[i] = 0x18
	}
	if m.Port != 0 {
		i = encodeVarintNetworkBaselineService(dAtA, i, uint64(m.Port))
		i--
		dAtA[i] = 0x10
	}
	if m.Entity != nil {
		{
			size, err := m.Entity.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkBaselineService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NetworkBaselinePeerStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkBaselinePeerStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkBaselinePeerStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Status != 0 {
		i = encodeVarintNetworkBaselineService(dAtA, i, uint64(m.Status))
		i--
		dAtA[i] = 0x10
	}
	if m.Peer != nil {
		{
			size, err := m.Peer.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkBaselineService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NetworkBaselineStatusRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkBaselineStatusRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkBaselineStatusRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Peers) > 0 {
		for iNdEx := len(m.Peers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Peers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintNetworkBaselineService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.DeploymentId) > 0 {
		i -= len(m.DeploymentId)
		copy(dAtA[i:], m.DeploymentId)
		i = encodeVarintNetworkBaselineService(dAtA, i, uint64(len(m.DeploymentId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NetworkBaselineStatusResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkBaselineStatusResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkBaselineStatusResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Statuses) > 0 {
		for iNdEx := len(m.Statuses) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Statuses[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintNetworkBaselineService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ModifyBaselineStatusForPeersRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ModifyBaselineStatusForPeersRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ModifyBaselineStatusForPeersRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Peers) > 0 {
		for iNdEx := len(m.Peers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Peers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintNetworkBaselineService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.DeploymentId) > 0 {
		i -= len(m.DeploymentId)
		copy(dAtA[i:], m.DeploymentId)
		i = encodeVarintNetworkBaselineService(dAtA, i, uint64(len(m.DeploymentId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintNetworkBaselineService(dAtA []byte, offset int, v uint64) int {
	offset -= sovNetworkBaselineService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *NetworkBaselinePeerEntity) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovNetworkBaselineService(uint64(l))
	}
	if m.Type != 0 {
		n += 1 + sovNetworkBaselineService(uint64(m.Type))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkBaselineStatusPeer) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Entity != nil {
		l = m.Entity.Size()
		n += 1 + l + sovNetworkBaselineService(uint64(l))
	}
	if m.Port != 0 {
		n += 1 + sovNetworkBaselineService(uint64(m.Port))
	}
	if m.Protocol != 0 {
		n += 1 + sovNetworkBaselineService(uint64(m.Protocol))
	}
	if m.Ingress {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkBaselinePeerStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Peer != nil {
		l = m.Peer.Size()
		n += 1 + l + sovNetworkBaselineService(uint64(l))
	}
	if m.Status != 0 {
		n += 1 + sovNetworkBaselineService(uint64(m.Status))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkBaselineStatusRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DeploymentId)
	if l > 0 {
		n += 1 + l + sovNetworkBaselineService(uint64(l))
	}
	if len(m.Peers) > 0 {
		for _, e := range m.Peers {
			l = e.Size()
			n += 1 + l + sovNetworkBaselineService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkBaselineStatusResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Statuses) > 0 {
		for _, e := range m.Statuses {
			l = e.Size()
			n += 1 + l + sovNetworkBaselineService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ModifyBaselineStatusForPeersRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DeploymentId)
	if l > 0 {
		n += 1 + l + sovNetworkBaselineService(uint64(l))
	}
	if len(m.Peers) > 0 {
		for _, e := range m.Peers {
			l = e.Size()
			n += 1 + l + sovNetworkBaselineService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovNetworkBaselineService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozNetworkBaselineService(x uint64) (n int) {
	return sovNetworkBaselineService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *NetworkBaselinePeerEntity) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkBaselineService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkBaselinePeerEntity: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkBaselinePeerEntity: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkBaselineService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkBaselineService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkBaselineService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkBaselineService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= storage.NetworkEntityInfo_Type(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkBaselineService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkBaselineService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkBaselineStatusPeer) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkBaselineService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkBaselineStatusPeer: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkBaselineStatusPeer: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Entity", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkBaselineService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkBaselineService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkBaselineService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Entity == nil {
				m.Entity = &NetworkBaselinePeerEntity{}
			}
			if err := m.Entity.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			m.Port = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkBaselineService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Port |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Protocol", wireType)
			}
			m.Protocol = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkBaselineService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Protocol |= storage.L4Protocol(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ingress", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkBaselineService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Ingress = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkBaselineService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkBaselineService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkBaselinePeerStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkBaselineService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkBaselinePeerStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkBaselinePeerStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Peer", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkBaselineService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkBaselineService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkBaselineService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Peer == nil {
				m.Peer = &NetworkBaselineStatusPeer{}
			}
			if err := m.Peer.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkBaselineService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= NetworkBaselinePeerStatus_Status(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkBaselineService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkBaselineService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkBaselineStatusRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkBaselineService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkBaselineStatusRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkBaselineStatusRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkBaselineService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkBaselineService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkBaselineService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Peers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkBaselineService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkBaselineService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkBaselineService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Peers = append(m.Peers, &NetworkBaselineStatusPeer{})
			if err := m.Peers[len(m.Peers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkBaselineService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkBaselineService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkBaselineStatusResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkBaselineService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkBaselineStatusResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkBaselineStatusResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Statuses", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkBaselineService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkBaselineService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkBaselineService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Statuses = append(m.Statuses, &NetworkBaselinePeerStatus{})
			if err := m.Statuses[len(m.Statuses)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkBaselineService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkBaselineService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ModifyBaselineStatusForPeersRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkBaselineService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ModifyBaselineStatusForPeersRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ModifyBaselineStatusForPeersRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkBaselineService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkBaselineService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkBaselineService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Peers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkBaselineService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkBaselineService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkBaselineService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Peers = append(m.Peers, &NetworkBaselinePeerStatus{})
			if err := m.Peers[len(m.Peers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkBaselineService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkBaselineService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipNetworkBaselineService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowNetworkBaselineService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowNetworkBaselineService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowNetworkBaselineService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthNetworkBaselineService
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupNetworkBaselineService
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthNetworkBaselineService
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthNetworkBaselineService        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowNetworkBaselineService          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupNetworkBaselineService = fmt.Errorf("proto: unexpected end of group")
)
