// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api/v1/network_graph_service.proto

package v1

import (
	context "context"
	fmt "fmt"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	storage "github.com/stackrox/rox/generated/storage"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type NetworkGraphScope struct {
	Query                string   `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NetworkGraphScope) Reset()         { *m = NetworkGraphScope{} }
func (m *NetworkGraphScope) String() string { return proto.CompactTextString(m) }
func (*NetworkGraphScope) ProtoMessage()    {}
func (*NetworkGraphScope) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1c337f7e92a3e31, []int{0}
}
func (m *NetworkGraphScope) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkGraphScope) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkGraphScope.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkGraphScope) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkGraphScope.Merge(m, src)
}
func (m *NetworkGraphScope) XXX_Size() int {
	return m.Size()
}
func (m *NetworkGraphScope) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkGraphScope.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkGraphScope proto.InternalMessageInfo

func (m *NetworkGraphScope) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *NetworkGraphScope) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkGraphScope) Clone() *NetworkGraphScope {
	if m == nil {
		return nil
	}
	cloned := new(NetworkGraphScope)
	*cloned = *m

	return cloned
}

type NetworkEdgeProperties struct {
	Port                 uint32             `protobuf:"varint,1,opt,name=port,proto3" json:"port,omitempty"`
	Protocol             storage.L4Protocol `protobuf:"varint,2,opt,name=protocol,proto3,enum=storage.L4Protocol" json:"protocol,omitempty"`
	LastActiveTimestamp  *types.Timestamp   `protobuf:"bytes,3,opt,name=last_active_timestamp,json=lastActiveTimestamp,proto3" json:"last_active_timestamp,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *NetworkEdgeProperties) Reset()         { *m = NetworkEdgeProperties{} }
func (m *NetworkEdgeProperties) String() string { return proto.CompactTextString(m) }
func (*NetworkEdgeProperties) ProtoMessage()    {}
func (*NetworkEdgeProperties) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1c337f7e92a3e31, []int{1}
}
func (m *NetworkEdgeProperties) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkEdgeProperties) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkEdgeProperties.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkEdgeProperties) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkEdgeProperties.Merge(m, src)
}
func (m *NetworkEdgeProperties) XXX_Size() int {
	return m.Size()
}
func (m *NetworkEdgeProperties) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkEdgeProperties.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkEdgeProperties proto.InternalMessageInfo

func (m *NetworkEdgeProperties) GetPort() uint32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *NetworkEdgeProperties) GetProtocol() storage.L4Protocol {
	if m != nil {
		return m.Protocol
	}
	return storage.L4Protocol_L4_PROTOCOL_UNKNOWN
}

func (m *NetworkEdgeProperties) GetLastActiveTimestamp() *types.Timestamp {
	if m != nil {
		return m.LastActiveTimestamp
	}
	return nil
}

func (m *NetworkEdgeProperties) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkEdgeProperties) Clone() *NetworkEdgeProperties {
	if m == nil {
		return nil
	}
	cloned := new(NetworkEdgeProperties)
	*cloned = *m

	cloned.LastActiveTimestamp = m.LastActiveTimestamp.Clone()
	return cloned
}

type NetworkEdgePropertiesBundle struct {
	Properties           []*NetworkEdgeProperties `protobuf:"bytes,1,rep,name=properties,proto3" json:"properties,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *NetworkEdgePropertiesBundle) Reset()         { *m = NetworkEdgePropertiesBundle{} }
func (m *NetworkEdgePropertiesBundle) String() string { return proto.CompactTextString(m) }
func (*NetworkEdgePropertiesBundle) ProtoMessage()    {}
func (*NetworkEdgePropertiesBundle) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1c337f7e92a3e31, []int{2}
}
func (m *NetworkEdgePropertiesBundle) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkEdgePropertiesBundle) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkEdgePropertiesBundle.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkEdgePropertiesBundle) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkEdgePropertiesBundle.Merge(m, src)
}
func (m *NetworkEdgePropertiesBundle) XXX_Size() int {
	return m.Size()
}
func (m *NetworkEdgePropertiesBundle) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkEdgePropertiesBundle.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkEdgePropertiesBundle proto.InternalMessageInfo

func (m *NetworkEdgePropertiesBundle) GetProperties() []*NetworkEdgeProperties {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *NetworkEdgePropertiesBundle) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkEdgePropertiesBundle) Clone() *NetworkEdgePropertiesBundle {
	if m == nil {
		return nil
	}
	cloned := new(NetworkEdgePropertiesBundle)
	*cloned = *m

	if m.Properties != nil {
		cloned.Properties = make([]*NetworkEdgeProperties, len(m.Properties))
		for idx, v := range m.Properties {
			cloned.Properties[idx] = v.Clone()
		}
	}
	return cloned
}

type NetworkNode struct {
	Entity               *storage.NetworkEntityInfo             `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	InternetAccess       bool                                   `protobuf:"varint,2,opt,name=internet_access,json=internetAccess,proto3" json:"internet_access,omitempty"`
	PolicyIds            []string                               `protobuf:"bytes,3,rep,name=policy_ids,json=policyIds,proto3" json:"policy_ids,omitempty"`
	NonIsolatedIngress   bool                                   `protobuf:"varint,5,opt,name=non_isolated_ingress,json=nonIsolatedIngress,proto3" json:"non_isolated_ingress,omitempty"`
	NonIsolatedEgress    bool                                   `protobuf:"varint,6,opt,name=non_isolated_egress,json=nonIsolatedEgress,proto3" json:"non_isolated_egress,omitempty"`
	QueryMatch           bool                                   `protobuf:"varint,7,opt,name=query_match,json=queryMatch,proto3" json:"query_match,omitempty"`
	OutEdges             map[int32]*NetworkEdgePropertiesBundle `protobuf:"bytes,4,rep,name=out_edges,json=outEdges,proto3" json:"out_edges,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                               `json:"-"`
	XXX_unrecognized     []byte                                 `json:"-"`
	XXX_sizecache        int32                                  `json:"-"`
}

func (m *NetworkNode) Reset()         { *m = NetworkNode{} }
func (m *NetworkNode) String() string { return proto.CompactTextString(m) }
func (*NetworkNode) ProtoMessage()    {}
func (*NetworkNode) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1c337f7e92a3e31, []int{3}
}
func (m *NetworkNode) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkNode) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkNode.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkNode) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkNode.Merge(m, src)
}
func (m *NetworkNode) XXX_Size() int {
	return m.Size()
}
func (m *NetworkNode) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkNode.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkNode proto.InternalMessageInfo

func (m *NetworkNode) GetEntity() *storage.NetworkEntityInfo {
	if m != nil {
		return m.Entity
	}
	return nil
}

func (m *NetworkNode) GetInternetAccess() bool {
	if m != nil {
		return m.InternetAccess
	}
	return false
}

func (m *NetworkNode) GetPolicyIds() []string {
	if m != nil {
		return m.PolicyIds
	}
	return nil
}

func (m *NetworkNode) GetNonIsolatedIngress() bool {
	if m != nil {
		return m.NonIsolatedIngress
	}
	return false
}

func (m *NetworkNode) GetNonIsolatedEgress() bool {
	if m != nil {
		return m.NonIsolatedEgress
	}
	return false
}

func (m *NetworkNode) GetQueryMatch() bool {
	if m != nil {
		return m.QueryMatch
	}
	return false
}

func (m *NetworkNode) GetOutEdges() map[int32]*NetworkEdgePropertiesBundle {
	if m != nil {
		return m.OutEdges
	}
	return nil
}

func (m *NetworkNode) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkNode) Clone() *NetworkNode {
	if m == nil {
		return nil
	}
	cloned := new(NetworkNode)
	*cloned = *m

	cloned.Entity = m.Entity.Clone()
	if m.PolicyIds != nil {
		cloned.PolicyIds = make([]string, len(m.PolicyIds))
		copy(cloned.PolicyIds, m.PolicyIds)
	}
	if m.OutEdges != nil {
		cloned.OutEdges = make(map[int32]*NetworkEdgePropertiesBundle, len(m.OutEdges))
		for k, v := range m.OutEdges {
			cloned.OutEdges[k] = v.Clone()
		}
	}
	return cloned
}

type NetworkGraphRequest struct {
	ClusterId            string             `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	Query                string             `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	Since                *types.Timestamp   `protobuf:"bytes,3,opt,name=since,proto3" json:"since,omitempty"`
	IncludePorts         bool               `protobuf:"varint,4,opt,name=include_ports,json=includePorts,proto3" json:"include_ports,omitempty"`
	Scope                *NetworkGraphScope `protobuf:"bytes,5,opt,name=scope,proto3" json:"scope,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *NetworkGraphRequest) Reset()         { *m = NetworkGraphRequest{} }
func (m *NetworkGraphRequest) String() string { return proto.CompactTextString(m) }
func (*NetworkGraphRequest) ProtoMessage()    {}
func (*NetworkGraphRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1c337f7e92a3e31, []int{4}
}
func (m *NetworkGraphRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkGraphRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkGraphRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkGraphRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkGraphRequest.Merge(m, src)
}
func (m *NetworkGraphRequest) XXX_Size() int {
	return m.Size()
}
func (m *NetworkGraphRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkGraphRequest.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkGraphRequest proto.InternalMessageInfo

func (m *NetworkGraphRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *NetworkGraphRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *NetworkGraphRequest) GetSince() *types.Timestamp {
	if m != nil {
		return m.Since
	}
	return nil
}

func (m *NetworkGraphRequest) GetIncludePorts() bool {
	if m != nil {
		return m.IncludePorts
	}
	return false
}

func (m *NetworkGraphRequest) GetScope() *NetworkGraphScope {
	if m != nil {
		return m.Scope
	}
	return nil
}

func (m *NetworkGraphRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkGraphRequest) Clone() *NetworkGraphRequest {
	if m == nil {
		return nil
	}
	cloned := new(NetworkGraphRequest)
	*cloned = *m

	cloned.Since = m.Since.Clone()
	cloned.Scope = m.Scope.Clone()
	return cloned
}

type NetworkGraph struct {
	Epoch                uint32         `protobuf:"varint,1,opt,name=epoch,proto3" json:"epoch,omitempty"`
	Nodes                []*NetworkNode `protobuf:"bytes,2,rep,name=nodes,proto3" json:"nodes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *NetworkGraph) Reset()         { *m = NetworkGraph{} }
func (m *NetworkGraph) String() string { return proto.CompactTextString(m) }
func (*NetworkGraph) ProtoMessage()    {}
func (*NetworkGraph) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1c337f7e92a3e31, []int{5}
}
func (m *NetworkGraph) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkGraph) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkGraph.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkGraph) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkGraph.Merge(m, src)
}
func (m *NetworkGraph) XXX_Size() int {
	return m.Size()
}
func (m *NetworkGraph) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkGraph.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkGraph proto.InternalMessageInfo

func (m *NetworkGraph) GetEpoch() uint32 {
	if m != nil {
		return m.Epoch
	}
	return 0
}

func (m *NetworkGraph) GetNodes() []*NetworkNode {
	if m != nil {
		return m.Nodes
	}
	return nil
}

func (m *NetworkGraph) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkGraph) Clone() *NetworkGraph {
	if m == nil {
		return nil
	}
	cloned := new(NetworkGraph)
	*cloned = *m

	if m.Nodes != nil {
		cloned.Nodes = make([]*NetworkNode, len(m.Nodes))
		for idx, v := range m.Nodes {
			cloned.Nodes[idx] = v.Clone()
		}
	}
	return cloned
}

type CreateNetworkEntityRequest struct {
	ClusterId            string                                    `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	Entity               *storage.NetworkEntityInfo_ExternalSource `protobuf:"bytes,2,opt,name=entity,proto3" json:"entity,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                  `json:"-"`
	XXX_unrecognized     []byte                                    `json:"-"`
	XXX_sizecache        int32                                     `json:"-"`
}

func (m *CreateNetworkEntityRequest) Reset()         { *m = CreateNetworkEntityRequest{} }
func (m *CreateNetworkEntityRequest) String() string { return proto.CompactTextString(m) }
func (*CreateNetworkEntityRequest) ProtoMessage()    {}
func (*CreateNetworkEntityRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1c337f7e92a3e31, []int{6}
}
func (m *CreateNetworkEntityRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CreateNetworkEntityRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CreateNetworkEntityRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CreateNetworkEntityRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateNetworkEntityRequest.Merge(m, src)
}
func (m *CreateNetworkEntityRequest) XXX_Size() int {
	return m.Size()
}
func (m *CreateNetworkEntityRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateNetworkEntityRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateNetworkEntityRequest proto.InternalMessageInfo

func (m *CreateNetworkEntityRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CreateNetworkEntityRequest) GetEntity() *storage.NetworkEntityInfo_ExternalSource {
	if m != nil {
		return m.Entity
	}
	return nil
}

func (m *CreateNetworkEntityRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *CreateNetworkEntityRequest) Clone() *CreateNetworkEntityRequest {
	if m == nil {
		return nil
	}
	cloned := new(CreateNetworkEntityRequest)
	*cloned = *m

	cloned.Entity = m.Entity.Clone()
	return cloned
}

type PatchNetworkEntityRequest struct {
	Id                   string   `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Name                 string   `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PatchNetworkEntityRequest) Reset()         { *m = PatchNetworkEntityRequest{} }
func (m *PatchNetworkEntityRequest) String() string { return proto.CompactTextString(m) }
func (*PatchNetworkEntityRequest) ProtoMessage()    {}
func (*PatchNetworkEntityRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1c337f7e92a3e31, []int{7}
}
func (m *PatchNetworkEntityRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PatchNetworkEntityRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PatchNetworkEntityRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PatchNetworkEntityRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PatchNetworkEntityRequest.Merge(m, src)
}
func (m *PatchNetworkEntityRequest) XXX_Size() int {
	return m.Size()
}
func (m *PatchNetworkEntityRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PatchNetworkEntityRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PatchNetworkEntityRequest proto.InternalMessageInfo

func (m *PatchNetworkEntityRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *PatchNetworkEntityRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *PatchNetworkEntityRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *PatchNetworkEntityRequest) Clone() *PatchNetworkEntityRequest {
	if m == nil {
		return nil
	}
	cloned := new(PatchNetworkEntityRequest)
	*cloned = *m

	return cloned
}

type GetExternalNetworkEntitiesRequest struct {
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	Query                string   `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetExternalNetworkEntitiesRequest) Reset()         { *m = GetExternalNetworkEntitiesRequest{} }
func (m *GetExternalNetworkEntitiesRequest) String() string { return proto.CompactTextString(m) }
func (*GetExternalNetworkEntitiesRequest) ProtoMessage()    {}
func (*GetExternalNetworkEntitiesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1c337f7e92a3e31, []int{8}
}
func (m *GetExternalNetworkEntitiesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetExternalNetworkEntitiesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetExternalNetworkEntitiesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetExternalNetworkEntitiesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetExternalNetworkEntitiesRequest.Merge(m, src)
}
func (m *GetExternalNetworkEntitiesRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetExternalNetworkEntitiesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetExternalNetworkEntitiesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetExternalNetworkEntitiesRequest proto.InternalMessageInfo

func (m *GetExternalNetworkEntitiesRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *GetExternalNetworkEntitiesRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *GetExternalNetworkEntitiesRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetExternalNetworkEntitiesRequest) Clone() *GetExternalNetworkEntitiesRequest {
	if m == nil {
		return nil
	}
	cloned := new(GetExternalNetworkEntitiesRequest)
	*cloned = *m

	return cloned
}

type GetExternalNetworkEntitiesResponse struct {
	Entities             []*storage.NetworkEntity `protobuf:"bytes,1,rep,name=entities,proto3" json:"entities,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *GetExternalNetworkEntitiesResponse) Reset()         { *m = GetExternalNetworkEntitiesResponse{} }
func (m *GetExternalNetworkEntitiesResponse) String() string { return proto.CompactTextString(m) }
func (*GetExternalNetworkEntitiesResponse) ProtoMessage()    {}
func (*GetExternalNetworkEntitiesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1c337f7e92a3e31, []int{9}
}
func (m *GetExternalNetworkEntitiesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetExternalNetworkEntitiesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetExternalNetworkEntitiesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetExternalNetworkEntitiesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetExternalNetworkEntitiesResponse.Merge(m, src)
}
func (m *GetExternalNetworkEntitiesResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetExternalNetworkEntitiesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetExternalNetworkEntitiesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetExternalNetworkEntitiesResponse proto.InternalMessageInfo

func (m *GetExternalNetworkEntitiesResponse) GetEntities() []*storage.NetworkEntity {
	if m != nil {
		return m.Entities
	}
	return nil
}

func (m *GetExternalNetworkEntitiesResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetExternalNetworkEntitiesResponse) Clone() *GetExternalNetworkEntitiesResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetExternalNetworkEntitiesResponse)
	*cloned = *m

	if m.Entities != nil {
		cloned.Entities = make([]*storage.NetworkEntity, len(m.Entities))
		for idx, v := range m.Entities {
			cloned.Entities[idx] = v.Clone()
		}
	}
	return cloned
}

type PutNetworkGraphConfigRequest struct {
	Config               *storage.NetworkGraphConfig `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *PutNetworkGraphConfigRequest) Reset()         { *m = PutNetworkGraphConfigRequest{} }
func (m *PutNetworkGraphConfigRequest) String() string { return proto.CompactTextString(m) }
func (*PutNetworkGraphConfigRequest) ProtoMessage()    {}
func (*PutNetworkGraphConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c1c337f7e92a3e31, []int{10}
}
func (m *PutNetworkGraphConfigRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PutNetworkGraphConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PutNetworkGraphConfigRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PutNetworkGraphConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PutNetworkGraphConfigRequest.Merge(m, src)
}
func (m *PutNetworkGraphConfigRequest) XXX_Size() int {
	return m.Size()
}
func (m *PutNetworkGraphConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PutNetworkGraphConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PutNetworkGraphConfigRequest proto.InternalMessageInfo

func (m *PutNetworkGraphConfigRequest) GetConfig() *storage.NetworkGraphConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *PutNetworkGraphConfigRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *PutNetworkGraphConfigRequest) Clone() *PutNetworkGraphConfigRequest {
	if m == nil {
		return nil
	}
	cloned := new(PutNetworkGraphConfigRequest)
	*cloned = *m

	cloned.Config = m.Config.Clone()
	return cloned
}

func init() {
	proto.RegisterType((*NetworkGraphScope)(nil), "v1.NetworkGraphScope")
	proto.RegisterType((*NetworkEdgeProperties)(nil), "v1.NetworkEdgeProperties")
	proto.RegisterType((*NetworkEdgePropertiesBundle)(nil), "v1.NetworkEdgePropertiesBundle")
	proto.RegisterType((*NetworkNode)(nil), "v1.NetworkNode")
	proto.RegisterMapType((map[int32]*NetworkEdgePropertiesBundle)(nil), "v1.NetworkNode.OutEdgesEntry")
	proto.RegisterType((*NetworkGraphRequest)(nil), "v1.NetworkGraphRequest")
	proto.RegisterType((*NetworkGraph)(nil), "v1.NetworkGraph")
	proto.RegisterType((*CreateNetworkEntityRequest)(nil), "v1.CreateNetworkEntityRequest")
	proto.RegisterType((*PatchNetworkEntityRequest)(nil), "v1.PatchNetworkEntityRequest")
	proto.RegisterType((*GetExternalNetworkEntitiesRequest)(nil), "v1.GetExternalNetworkEntitiesRequest")
	proto.RegisterType((*GetExternalNetworkEntitiesResponse)(nil), "v1.GetExternalNetworkEntitiesResponse")
	proto.RegisterType((*PutNetworkGraphConfigRequest)(nil), "v1.PutNetworkGraphConfigRequest")
}

func init() {
	proto.RegisterFile("api/v1/network_graph_service.proto", fileDescriptor_c1c337f7e92a3e31)
}

var fileDescriptor_c1c337f7e92a3e31 = []byte{
	// 1074 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x56, 0xcf, 0x6e, 0x1b, 0xd5,
	0x17, 0xee, 0xd8, 0x75, 0x1a, 0x1f, 0x37, 0x49, 0x7b, 0xd3, 0xfc, 0xea, 0x4c, 0xd2, 0xc4, 0xbf,
	0x41, 0x69, 0xdd, 0x54, 0x8c, 0x6b, 0x17, 0x50, 0x09, 0x12, 0x28, 0x69, 0xa3, 0xc8, 0x02, 0x42,
	0x34, 0x61, 0x11, 0x21, 0xa4, 0x61, 0x3a, 0x73, 0xe2, 0x0c, 0x19, 0xdf, 0x3b, 0x9d, 0xb9, 0xe3,
	0xd6, 0x54, 0x65, 0xc1, 0x82, 0x17, 0x60, 0xd3, 0x15, 0x4b, 0x36, 0xf0, 0x20, 0xac, 0x10, 0x12,
	0x2f, 0x80, 0x02, 0x0f, 0x82, 0xee, 0x1f, 0x3b, 0x13, 0xd7, 0x4e, 0x23, 0xd8, 0x79, 0xce, 0xf9,
	0xee, 0x39, 0xdf, 0x7c, 0xe7, 0x3b, 0x77, 0x0c, 0x96, 0x17, 0x87, 0x8d, 0x5e, 0xb3, 0x41, 0x91,
	0x3f, 0x63, 0xc9, 0xb1, 0xdb, 0x49, 0xbc, 0xf8, 0xc8, 0x4d, 0x31, 0xe9, 0x85, 0x3e, 0xda, 0x71,
	0xc2, 0x38, 0x23, 0x85, 0x5e, 0xd3, 0x5c, 0xee, 0x30, 0xd6, 0x89, 0xb0, 0x21, 0xe0, 0x1e, 0xa5,
	0x8c, 0x7b, 0x3c, 0x64, 0x34, 0x55, 0x08, 0x73, 0x55, 0x67, 0xe5, 0xd3, 0x93, 0xec, 0xb0, 0xc1,
	0xc3, 0x2e, 0xa6, 0xdc, 0xeb, 0xc6, 0x1a, 0x60, 0xa6, 0x9c, 0x25, 0x5e, 0x07, 0x87, 0x7d, 0x0e,
	0x23, 0xf6, 0x4c, 0xe7, 0xac, 0xd1, 0x9c, 0xe2, 0xe0, 0x33, 0x7a, 0x18, 0x76, 0x34, 0x66, 0x5e,
	0xd3, 0xf4, 0x59, 0xb7, 0xcb, 0xa8, 0x0e, 0x12, 0x1d, 0xc4, 0x6e, 0xcc, 0xfb, 0x2a, 0x66, 0xdd,
	0x85, 0xeb, 0xbb, 0xaa, 0xcc, 0x8e, 0xa8, 0xb2, 0xef, 0xb3, 0x18, 0xc9, 0x0d, 0x28, 0x3d, 0xcd,
	0x30, 0xe9, 0x57, 0x8d, 0x9a, 0x51, 0x2f, 0x3b, 0xea, 0xc1, 0xfa, 0xc5, 0x80, 0x05, 0x8d, 0xdd,
	0x0e, 0x3a, 0xb8, 0x97, 0xb0, 0x18, 0x13, 0x1e, 0x62, 0x4a, 0x08, 0x5c, 0x8e, 0x59, 0xc2, 0x25,
	0x7c, 0xc6, 0x91, 0xbf, 0x49, 0x03, 0xa6, 0x65, 0x07, 0x9f, 0x45, 0xd5, 0x42, 0xcd, 0xa8, 0xcf,
	0xb6, 0xe6, 0x6d, 0x4d, 0xdc, 0xfe, 0xe4, 0x9d, 0x3d, 0x9d, 0x72, 0x86, 0x20, 0xb2, 0x0b, 0x0b,
	0x91, 0x97, 0x72, 0xd7, 0xf3, 0x79, 0xd8, 0x43, 0x77, 0xa8, 0x48, 0xb5, 0x58, 0x33, 0xea, 0x95,
	0x96, 0x69, 0x2b, 0xcd, 0xec, 0x81, 0x66, 0xf6, 0xe7, 0x03, 0x84, 0x33, 0x2f, 0x0e, 0x6e, 0xca,
	0x73, 0xc3, 0xa0, 0x75, 0x00, 0x4b, 0x63, 0xd9, 0x6e, 0x65, 0x34, 0x88, 0x90, 0xbc, 0x0f, 0x10,
	0x0f, 0x63, 0x55, 0xa3, 0x56, 0xac, 0x57, 0x5a, 0x8b, 0x76, 0xaf, 0x69, 0x8f, 0x3d, 0xe4, 0xe4,
	0xc0, 0xd6, 0x4f, 0x45, 0xa8, 0x68, 0xd4, 0x2e, 0x0b, 0x90, 0xb4, 0x60, 0x0a, 0x29, 0x0f, 0xb9,
	0xd2, 0x4b, 0x50, 0x1d, 0xbc, 0xe8, 0xa0, 0x96, 0xcc, 0xb6, 0xe9, 0x21, 0x73, 0x34, 0x92, 0xdc,
	0x81, 0xb9, 0x90, 0x72, 0x4c, 0x28, 0x8a, 0x37, 0xf6, 0x31, 0x4d, 0xa5, 0x4a, 0xd3, 0xce, 0xec,
	0x20, 0xbc, 0x29, 0xa3, 0xe4, 0x16, 0x40, 0xcc, 0xa2, 0xd0, 0xef, 0xbb, 0x61, 0x90, 0x56, 0x8b,
	0xb5, 0x62, 0xbd, 0xec, 0x94, 0x55, 0xa4, 0x1d, 0xa4, 0xe4, 0x3e, 0xdc, 0xa0, 0x8c, 0xba, 0x61,
	0xca, 0x22, 0x8f, 0x63, 0xe0, 0x86, 0xb4, 0x93, 0x88, 0x62, 0x25, 0x59, 0x8c, 0x50, 0x46, 0xdb,
	0x3a, 0xd5, 0x56, 0x19, 0x62, 0xc3, 0xfc, 0x99, 0x13, 0xa8, 0x0e, 0x4c, 0xc9, 0x03, 0xd7, 0x73,
	0x07, 0xb6, 0x15, 0x7e, 0x15, 0x2a, 0x72, 0xfe, 0x6e, 0xd7, 0xe3, 0xfe, 0x51, 0xf5, 0x8a, 0xc4,
	0x81, 0x0c, 0x7d, 0x2a, 0x22, 0x64, 0x03, 0xca, 0x2c, 0xe3, 0x2e, 0x06, 0x1d, 0x4c, 0xab, 0x97,
	0xa5, 0x90, 0xb7, 0x72, 0x42, 0x0a, 0x89, 0xec, 0xcf, 0x32, 0x2e, 0x04, 0x4d, 0xb7, 0x29, 0x4f,
	0xfa, 0xce, 0x34, 0xd3, 0x8f, 0xe6, 0x97, 0x30, 0x73, 0x26, 0x45, 0xae, 0x41, 0xf1, 0x18, 0x95,
	0x90, 0x25, 0x47, 0xfc, 0x24, 0xef, 0x42, 0xa9, 0xe7, 0x45, 0x19, 0x4a, 0x7d, 0x2a, 0xad, 0xd5,
	0x89, 0x33, 0x52, 0x83, 0x75, 0x14, 0x7a, 0xa3, 0xf0, 0xd0, 0xb0, 0x7e, 0x33, 0x60, 0x3e, 0xef,
	0x6e, 0x07, 0x9f, 0x66, 0x98, 0x72, 0xa1, 0xa9, 0x1f, 0x65, 0x29, 0xc7, 0xc4, 0x0d, 0x03, 0x6d,
	0xf2, 0xb2, 0x8e, 0xb4, 0x83, 0x53, 0xfb, 0x17, 0x72, 0xf6, 0x27, 0xf7, 0xa1, 0x94, 0x86, 0xd4,
	0xc7, 0x0b, 0xf8, 0x51, 0x01, 0xc9, 0x5b, 0x30, 0x13, 0x52, 0x3f, 0xca, 0x02, 0x74, 0xc5, 0x4a,
	0x08, 0x71, 0x84, 0x76, 0x57, 0x75, 0x70, 0x4f, 0xc4, 0xc8, 0x3d, 0x28, 0xa5, 0x62, 0xe9, 0xe4,
	0xc4, 0x2a, 0xad, 0x85, 0xdc, 0xeb, 0x9d, 0x6e, 0xa4, 0xa3, 0x30, 0xd6, 0xc7, 0x70, 0x35, 0x9f,
	0x13, 0x4c, 0x31, 0x66, 0xfe, 0x91, 0xde, 0x3c, 0xf5, 0x40, 0xd6, 0xa0, 0x44, 0x59, 0x80, 0xc2,
	0x51, 0x62, 0x18, 0x73, 0x23, 0xc3, 0x70, 0x54, 0xd6, 0xfa, 0x16, 0xcc, 0x47, 0x09, 0x7a, 0x1c,
	0xcf, 0xb8, 0xf4, 0x82, 0x1a, 0x6d, 0x0e, 0x3d, 0xaf, 0xc6, 0x72, 0x77, 0xb2, 0xe7, 0xed, 0xed,
	0xe7, 0xc2, 0xd1, 0x5e, 0xb4, 0xcf, 0xb2, 0xc4, 0xc7, 0xc1, 0x0a, 0x58, 0x1f, 0xc1, 0xe2, 0x9e,
	0x30, 0xd0, 0xd8, 0xf6, 0xb3, 0x50, 0x18, 0xb6, 0x2d, 0x84, 0x81, 0xb8, 0x62, 0xa8, 0xd7, 0x45,
	0x3d, 0x12, 0xf9, 0xdb, 0x3a, 0x80, 0xff, 0xef, 0x20, 0x1f, 0x54, 0xcf, 0x97, 0x11, 0x1b, 0xfb,
	0x1f, 0x66, 0x6d, 0x1d, 0x80, 0x75, 0x5e, 0xe5, 0x34, 0x66, 0x34, 0x15, 0x7b, 0x3f, 0x8d, 0x3a,
	0xa6, 0x2f, 0x90, 0xff, 0x8d, 0x57, 0xc1, 0x19, 0xe2, 0xac, 0x7d, 0x58, 0xde, 0xcb, 0x78, 0x7e,
	0x88, 0x8f, 0xe4, 0xbd, 0x3d, 0xa0, 0xfb, 0x00, 0xa6, 0xd4, 0x45, 0xae, 0xef, 0x92, 0xa5, 0xd1,
	0x8a, 0xf9, 0x33, 0x1a, 0xda, 0xfa, 0xf1, 0xca, 0x59, 0x9f, 0xef, 0xab, 0xcf, 0x11, 0x39, 0x86,
	0xb9, 0x1d, 0x3c, 0xd3, 0x8c, 0xdc, 0x1c, 0xf5, 0x97, 0x6e, 0x6c, 0x5e, 0x1b, 0x4d, 0x58, 0x6f,
	0x7f, 0xf7, 0xc7, 0xdf, 0x3f, 0x14, 0xee, 0x90, 0xb5, 0xdc, 0xf7, 0x4e, 0x7e, 0x6a, 0x1a, 0x5a,
	0xbe, 0xc6, 0x8b, 0x53, 0x65, 0x5f, 0x92, 0x9f, 0x0d, 0x30, 0x27, 0x8b, 0x46, 0xd6, 0x44, 0xfd,
	0x37, 0x8e, 0xcb, 0xbc, 0xfd, 0x26, 0x98, 0xd2, 0xde, 0xfa, 0x50, 0x92, 0x7b, 0x48, 0xde, 0xbb,
	0x10, 0xb9, 0x06, 0xea, 0x72, 0x83, 0x39, 0x90, 0x57, 0x06, 0x2c, 0x29, 0xf7, 0x8f, 0xeb, 0xd4,
	0x27, 0x2b, 0x82, 0xc7, 0xe4, 0xf5, 0x30, 0x27, 0x4c, 0xda, 0xda, 0x94, 0xbc, 0x3e, 0xb0, 0xfe,
	0x25, 0xaf, 0x0d, 0x63, 0x9d, 0x7c, 0x6f, 0x80, 0x29, 0x17, 0x63, 0x3c, 0x33, 0x79, 0xb7, 0x4e,
	0x5c, 0x9c, 0x89, 0xc4, 0x9a, 0x92, 0xd8, 0xbd, 0xd6, 0xed, 0xd7, 0x88, 0x8d, 0x72, 0x68, 0xbc,
	0x08, 0x83, 0x97, 0x82, 0xc8, 0xd7, 0xb0, 0xf4, 0x18, 0x23, 0x9c, 0x24, 0x91, 0x74, 0x8c, 0x83,
	0xa9, 0xdc, 0xea, 0xad, 0x7e, 0xfb, 0xb1, 0x59, 0x16, 0x91, 0x6d, 0xf1, 0xef, 0xc2, 0xb2, 0x65,
	0xbb, 0xfa, 0xfa, 0x05, 0xdb, 0x91, 0xaf, 0x60, 0x61, 0xc4, 0xaa, 0xca, 0xe3, 0xe4, 0xb4, 0xa6,
	0x79, 0xde, 0x2e, 0x58, 0xab, 0xb2, 0xe1, 0x22, 0xb9, 0xf9, 0xba, 0xf0, 0xaa, 0xd0, 0x37, 0xb0,
	0x30, 0x76, 0xf3, 0x48, 0x4d, 0x0a, 0x7a, 0xce, 0x52, 0x9e, 0xdf, 0xd8, 0x92, 0x8d, 0x97, 0xcd,
	0x49, 0x8d, 0x37, 0x8c, 0xf5, 0x2d, 0xfb, 0xd7, 0x93, 0x15, 0xe3, 0xf7, 0x93, 0x15, 0xe3, 0xcf,
	0x93, 0x15, 0xe3, 0xd5, 0x5f, 0x2b, 0x97, 0xa0, 0x1a, 0x32, 0x3b, 0xe5, 0x9e, 0x7f, 0x9c, 0xb0,
	0xe7, 0xea, 0x13, 0x62, 0x7b, 0x71, 0x68, 0xf7, 0x9a, 0x5f, 0x14, 0x7a, 0xcd, 0x83, 0x4b, 0x4f,
	0xa6, 0x64, 0xec, 0xc1, 0x3f, 0x01, 0x00, 0x00, 0xff, 0xff, 0x0a, 0xfa, 0x14, 0xeb, 0x70, 0x0a,
	0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// NetworkGraphServiceClient is the client API for NetworkGraphService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConnInterface.NewStream.
type NetworkGraphServiceClient interface {
	GetNetworkGraph(ctx context.Context, in *NetworkGraphRequest, opts ...grpc.CallOption) (*NetworkGraph, error)
	GetExternalNetworkEntities(ctx context.Context, in *GetExternalNetworkEntitiesRequest, opts ...grpc.CallOption) (*GetExternalNetworkEntitiesResponse, error)
	CreateExternalNetworkEntity(ctx context.Context, in *CreateNetworkEntityRequest, opts ...grpc.CallOption) (*storage.NetworkEntity, error)
	PatchExternalNetworkEntity(ctx context.Context, in *PatchNetworkEntityRequest, opts ...grpc.CallOption) (*storage.NetworkEntity, error)
	DeleteExternalNetworkEntity(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*Empty, error)
	GetNetworkGraphConfig(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*storage.NetworkGraphConfig, error)
	PutNetworkGraphConfig(ctx context.Context, in *PutNetworkGraphConfigRequest, opts ...grpc.CallOption) (*storage.NetworkGraphConfig, error)
}

type networkGraphServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewNetworkGraphServiceClient(cc grpc.ClientConnInterface) NetworkGraphServiceClient {
	return &networkGraphServiceClient{cc}
}

func (c *networkGraphServiceClient) GetNetworkGraph(ctx context.Context, in *NetworkGraphRequest, opts ...grpc.CallOption) (*NetworkGraph, error) {
	out := new(NetworkGraph)
	err := c.cc.Invoke(ctx, "/v1.NetworkGraphService/GetNetworkGraph", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkGraphServiceClient) GetExternalNetworkEntities(ctx context.Context, in *GetExternalNetworkEntitiesRequest, opts ...grpc.CallOption) (*GetExternalNetworkEntitiesResponse, error) {
	out := new(GetExternalNetworkEntitiesResponse)
	err := c.cc.Invoke(ctx, "/v1.NetworkGraphService/GetExternalNetworkEntities", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkGraphServiceClient) CreateExternalNetworkEntity(ctx context.Context, in *CreateNetworkEntityRequest, opts ...grpc.CallOption) (*storage.NetworkEntity, error) {
	out := new(storage.NetworkEntity)
	err := c.cc.Invoke(ctx, "/v1.NetworkGraphService/CreateExternalNetworkEntity", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkGraphServiceClient) PatchExternalNetworkEntity(ctx context.Context, in *PatchNetworkEntityRequest, opts ...grpc.CallOption) (*storage.NetworkEntity, error) {
	out := new(storage.NetworkEntity)
	err := c.cc.Invoke(ctx, "/v1.NetworkGraphService/PatchExternalNetworkEntity", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkGraphServiceClient) DeleteExternalNetworkEntity(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.NetworkGraphService/DeleteExternalNetworkEntity", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkGraphServiceClient) GetNetworkGraphConfig(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*storage.NetworkGraphConfig, error) {
	out := new(storage.NetworkGraphConfig)
	err := c.cc.Invoke(ctx, "/v1.NetworkGraphService/GetNetworkGraphConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkGraphServiceClient) PutNetworkGraphConfig(ctx context.Context, in *PutNetworkGraphConfigRequest, opts ...grpc.CallOption) (*storage.NetworkGraphConfig, error) {
	out := new(storage.NetworkGraphConfig)
	err := c.cc.Invoke(ctx, "/v1.NetworkGraphService/PutNetworkGraphConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// NetworkGraphServiceServer is the server API for NetworkGraphService service.
type NetworkGraphServiceServer interface {
	GetNetworkGraph(context.Context, *NetworkGraphRequest) (*NetworkGraph, error)
	GetExternalNetworkEntities(context.Context, *GetExternalNetworkEntitiesRequest) (*GetExternalNetworkEntitiesResponse, error)
	CreateExternalNetworkEntity(context.Context, *CreateNetworkEntityRequest) (*storage.NetworkEntity, error)
	PatchExternalNetworkEntity(context.Context, *PatchNetworkEntityRequest) (*storage.NetworkEntity, error)
	DeleteExternalNetworkEntity(context.Context, *ResourceByID) (*Empty, error)
	GetNetworkGraphConfig(context.Context, *Empty) (*storage.NetworkGraphConfig, error)
	PutNetworkGraphConfig(context.Context, *PutNetworkGraphConfigRequest) (*storage.NetworkGraphConfig, error)
}

// UnimplementedNetworkGraphServiceServer can be embedded to have forward compatible implementations.
type UnimplementedNetworkGraphServiceServer struct {
}

func (*UnimplementedNetworkGraphServiceServer) GetNetworkGraph(ctx context.Context, req *NetworkGraphRequest) (*NetworkGraph, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNetworkGraph not implemented")
}
func (*UnimplementedNetworkGraphServiceServer) GetExternalNetworkEntities(ctx context.Context, req *GetExternalNetworkEntitiesRequest) (*GetExternalNetworkEntitiesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetExternalNetworkEntities not implemented")
}
func (*UnimplementedNetworkGraphServiceServer) CreateExternalNetworkEntity(ctx context.Context, req *CreateNetworkEntityRequest) (*storage.NetworkEntity, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateExternalNetworkEntity not implemented")
}
func (*UnimplementedNetworkGraphServiceServer) PatchExternalNetworkEntity(ctx context.Context, req *PatchNetworkEntityRequest) (*storage.NetworkEntity, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PatchExternalNetworkEntity not implemented")
}
func (*UnimplementedNetworkGraphServiceServer) DeleteExternalNetworkEntity(ctx context.Context, req *ResourceByID) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteExternalNetworkEntity not implemented")
}
func (*UnimplementedNetworkGraphServiceServer) GetNetworkGraphConfig(ctx context.Context, req *Empty) (*storage.NetworkGraphConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNetworkGraphConfig not implemented")
}
func (*UnimplementedNetworkGraphServiceServer) PutNetworkGraphConfig(ctx context.Context, req *PutNetworkGraphConfigRequest) (*storage.NetworkGraphConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PutNetworkGraphConfig not implemented")
}

func RegisterNetworkGraphServiceServer(s *grpc.Server, srv NetworkGraphServiceServer) {
	s.RegisterService(&_NetworkGraphService_serviceDesc, srv)
}

func _NetworkGraphService_GetNetworkGraph_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NetworkGraphRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkGraphServiceServer).GetNetworkGraph(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.NetworkGraphService/GetNetworkGraph",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkGraphServiceServer).GetNetworkGraph(ctx, req.(*NetworkGraphRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkGraphService_GetExternalNetworkEntities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetExternalNetworkEntitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkGraphServiceServer).GetExternalNetworkEntities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.NetworkGraphService/GetExternalNetworkEntities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkGraphServiceServer).GetExternalNetworkEntities(ctx, req.(*GetExternalNetworkEntitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkGraphService_CreateExternalNetworkEntity_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateNetworkEntityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkGraphServiceServer).CreateExternalNetworkEntity(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.NetworkGraphService/CreateExternalNetworkEntity",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkGraphServiceServer).CreateExternalNetworkEntity(ctx, req.(*CreateNetworkEntityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkGraphService_PatchExternalNetworkEntity_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchNetworkEntityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkGraphServiceServer).PatchExternalNetworkEntity(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.NetworkGraphService/PatchExternalNetworkEntity",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkGraphServiceServer).PatchExternalNetworkEntity(ctx, req.(*PatchNetworkEntityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkGraphService_DeleteExternalNetworkEntity_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkGraphServiceServer).DeleteExternalNetworkEntity(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.NetworkGraphService/DeleteExternalNetworkEntity",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkGraphServiceServer).DeleteExternalNetworkEntity(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkGraphService_GetNetworkGraphConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkGraphServiceServer).GetNetworkGraphConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.NetworkGraphService/GetNetworkGraphConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkGraphServiceServer).GetNetworkGraphConfig(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkGraphService_PutNetworkGraphConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PutNetworkGraphConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkGraphServiceServer).PutNetworkGraphConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.NetworkGraphService/PutNetworkGraphConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkGraphServiceServer).PutNetworkGraphConfig(ctx, req.(*PutNetworkGraphConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _NetworkGraphService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1.NetworkGraphService",
	HandlerType: (*NetworkGraphServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetNetworkGraph",
			Handler:    _NetworkGraphService_GetNetworkGraph_Handler,
		},
		{
			MethodName: "GetExternalNetworkEntities",
			Handler:    _NetworkGraphService_GetExternalNetworkEntities_Handler,
		},
		{
			MethodName: "CreateExternalNetworkEntity",
			Handler:    _NetworkGraphService_CreateExternalNetworkEntity_Handler,
		},
		{
			MethodName: "PatchExternalNetworkEntity",
			Handler:    _NetworkGraphService_PatchExternalNetworkEntity_Handler,
		},
		{
			MethodName: "DeleteExternalNetworkEntity",
			Handler:    _NetworkGraphService_DeleteExternalNetworkEntity_Handler,
		},
		{
			MethodName: "GetNetworkGraphConfig",
			Handler:    _NetworkGraphService_GetNetworkGraphConfig_Handler,
		},
		{
			MethodName: "PutNetworkGraphConfig",
			Handler:    _NetworkGraphService_PutNetworkGraphConfig_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/v1/network_graph_service.proto",
}

func (m *NetworkGraphScope) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkGraphScope) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkGraphScope) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Query) > 0 {
		i -= len(m.Query)
		copy(dAtA[i:], m.Query)
		i = encodeVarintNetworkGraphService(dAtA, i, uint64(len(m.Query)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NetworkEdgeProperties) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkEdgeProperties) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkEdgeProperties) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.LastActiveTimestamp != nil {
		{
			size, err := m.LastActiveTimestamp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkGraphService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Protocol != 0 {
		i = encodeVarintNetworkGraphService(dAtA, i, uint64(m.Protocol))
		i--
		dAtA[i] = 0x10
	}
	if m.Port != 0 {
		i = encodeVarintNetworkGraphService(dAtA, i, uint64(m.Port))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *NetworkEdgePropertiesBundle) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkEdgePropertiesBundle) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkEdgePropertiesBundle) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Properties) > 0 {
		for iNdEx := len(m.Properties) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Properties[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintNetworkGraphService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *NetworkNode) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkNode) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkNode) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.QueryMatch {
		i--
		if m.QueryMatch {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x38
	}
	if m.NonIsolatedEgress {
		i--
		if m.NonIsolatedEgress {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if m.NonIsolatedIngress {
		i--
		if m.NonIsolatedIngress {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if len(m.OutEdges) > 0 {
		for k := range m.OutEdges {
			v := m.OutEdges[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintNetworkGraphService(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i = encodeVarintNetworkGraphService(dAtA, i, uint64(k))
			i--
			dAtA[i] = 0x8
			i = encodeVarintNetworkGraphService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.PolicyIds) > 0 {
		for iNdEx := len(m.PolicyIds) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.PolicyIds[iNdEx])
			copy(dAtA[i:], m.PolicyIds[iNdEx])
			i = encodeVarintNetworkGraphService(dAtA, i, uint64(len(m.PolicyIds[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.InternetAccess {
		i--
		if m.InternetAccess {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if m.Entity != nil {
		{
			size, err := m.Entity.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkGraphService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NetworkGraphRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkGraphRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkGraphRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Scope != nil {
		{
			size, err := m.Scope.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkGraphService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.IncludePorts {
		i--
		if m.IncludePorts {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.Since != nil {
		{
			size, err := m.Since.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkGraphService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Query) > 0 {
		i -= len(m.Query)
		copy(dAtA[i:], m.Query)
		i = encodeVarintNetworkGraphService(dAtA, i, uint64(len(m.Query)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintNetworkGraphService(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NetworkGraph) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkGraph) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkGraph) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Nodes) > 0 {
		for iNdEx := len(m.Nodes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Nodes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintNetworkGraphService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Epoch != 0 {
		i = encodeVarintNetworkGraphService(dAtA, i, uint64(m.Epoch))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CreateNetworkEntityRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CreateNetworkEntityRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CreateNetworkEntityRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Entity != nil {
		{
			size, err := m.Entity.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkGraphService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintNetworkGraphService(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PatchNetworkEntityRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PatchNetworkEntityRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PatchNetworkEntityRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintNetworkGraphService(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintNetworkGraphService(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetExternalNetworkEntitiesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetExternalNetworkEntitiesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetExternalNetworkEntitiesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Query) > 0 {
		i -= len(m.Query)
		copy(dAtA[i:], m.Query)
		i = encodeVarintNetworkGraphService(dAtA, i, uint64(len(m.Query)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintNetworkGraphService(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetExternalNetworkEntitiesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetExternalNetworkEntitiesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetExternalNetworkEntitiesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Entities) > 0 {
		for iNdEx := len(m.Entities) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Entities[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintNetworkGraphService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *PutNetworkGraphConfigRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PutNetworkGraphConfigRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PutNetworkGraphConfigRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Config != nil {
		{
			size, err := m.Config.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkGraphService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintNetworkGraphService(dAtA []byte, offset int, v uint64) int {
	offset -= sovNetworkGraphService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *NetworkGraphScope) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Query)
	if l > 0 {
		n += 1 + l + sovNetworkGraphService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkEdgeProperties) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Port != 0 {
		n += 1 + sovNetworkGraphService(uint64(m.Port))
	}
	if m.Protocol != 0 {
		n += 1 + sovNetworkGraphService(uint64(m.Protocol))
	}
	if m.LastActiveTimestamp != nil {
		l = m.LastActiveTimestamp.Size()
		n += 1 + l + sovNetworkGraphService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkEdgePropertiesBundle) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Properties) > 0 {
		for _, e := range m.Properties {
			l = e.Size()
			n += 1 + l + sovNetworkGraphService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkNode) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Entity != nil {
		l = m.Entity.Size()
		n += 1 + l + sovNetworkGraphService(uint64(l))
	}
	if m.InternetAccess {
		n += 2
	}
	if len(m.PolicyIds) > 0 {
		for _, s := range m.PolicyIds {
			l = len(s)
			n += 1 + l + sovNetworkGraphService(uint64(l))
		}
	}
	if len(m.OutEdges) > 0 {
		for k, v := range m.OutEdges {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovNetworkGraphService(uint64(l))
			}
			mapEntrySize := 1 + sovNetworkGraphService(uint64(k)) + l
			n += mapEntrySize + 1 + sovNetworkGraphService(uint64(mapEntrySize))
		}
	}
	if m.NonIsolatedIngress {
		n += 2
	}
	if m.NonIsolatedEgress {
		n += 2
	}
	if m.QueryMatch {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkGraphRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovNetworkGraphService(uint64(l))
	}
	l = len(m.Query)
	if l > 0 {
		n += 1 + l + sovNetworkGraphService(uint64(l))
	}
	if m.Since != nil {
		l = m.Since.Size()
		n += 1 + l + sovNetworkGraphService(uint64(l))
	}
	if m.IncludePorts {
		n += 2
	}
	if m.Scope != nil {
		l = m.Scope.Size()
		n += 1 + l + sovNetworkGraphService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkGraph) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Epoch != 0 {
		n += 1 + sovNetworkGraphService(uint64(m.Epoch))
	}
	if len(m.Nodes) > 0 {
		for _, e := range m.Nodes {
			l = e.Size()
			n += 1 + l + sovNetworkGraphService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CreateNetworkEntityRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovNetworkGraphService(uint64(l))
	}
	if m.Entity != nil {
		l = m.Entity.Size()
		n += 1 + l + sovNetworkGraphService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PatchNetworkEntityRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovNetworkGraphService(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovNetworkGraphService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetExternalNetworkEntitiesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovNetworkGraphService(uint64(l))
	}
	l = len(m.Query)
	if l > 0 {
		n += 1 + l + sovNetworkGraphService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetExternalNetworkEntitiesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Entities) > 0 {
		for _, e := range m.Entities {
			l = e.Size()
			n += 1 + l + sovNetworkGraphService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PutNetworkGraphConfigRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Config != nil {
		l = m.Config.Size()
		n += 1 + l + sovNetworkGraphService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovNetworkGraphService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozNetworkGraphService(x uint64) (n int) {
	return sovNetworkGraphService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *NetworkGraphScope) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkGraphService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkGraphScope: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkGraphScope: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkGraphService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Query = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkGraphService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkEdgeProperties) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkGraphService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkEdgeProperties: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkEdgeProperties: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			m.Port = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkGraphService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Port |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Protocol", wireType)
			}
			m.Protocol = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkGraphService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Protocol |= storage.L4Protocol(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastActiveTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkGraphService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastActiveTimestamp == nil {
				m.LastActiveTimestamp = &types.Timestamp{}
			}
			if err := m.LastActiveTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkGraphService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkEdgePropertiesBundle) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkGraphService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkEdgePropertiesBundle: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkEdgePropertiesBundle: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Properties", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkGraphService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Properties = append(m.Properties, &NetworkEdgeProperties{})
			if err := m.Properties[len(m.Properties)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkGraphService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkNode) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkGraphService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkNode: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkNode: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Entity", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkGraphService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Entity == nil {
				m.Entity = &storage.NetworkEntityInfo{}
			}
			if err := m.Entity.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InternetAccess", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkGraphService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.InternetAccess = bool(v != 0)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PolicyIds", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkGraphService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PolicyIds = append(m.PolicyIds, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OutEdges", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkGraphService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.OutEdges == nil {
				m.OutEdges = make(map[int32]*NetworkEdgePropertiesBundle)
			}
			var mapkey int32
			var mapvalue *NetworkEdgePropertiesBundle
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowNetworkGraphService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowNetworkGraphService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowNetworkGraphService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthNetworkGraphService
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthNetworkGraphService
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &NetworkEdgePropertiesBundle{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipNetworkGraphService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthNetworkGraphService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.OutEdges[mapkey] = mapvalue
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NonIsolatedIngress", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkGraphService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NonIsolatedIngress = bool(v != 0)
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NonIsolatedEgress", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkGraphService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NonIsolatedEgress = bool(v != 0)
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field QueryMatch", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkGraphService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.QueryMatch = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkGraphService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkGraphRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkGraphService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkGraphRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkGraphRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkGraphService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkGraphService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Query = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Since", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkGraphService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Since == nil {
				m.Since = &types.Timestamp{}
			}
			if err := m.Since.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IncludePorts", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkGraphService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IncludePorts = bool(v != 0)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scope", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkGraphService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Scope == nil {
				m.Scope = &NetworkGraphScope{}
			}
			if err := m.Scope.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkGraphService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkGraph) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkGraphService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkGraph: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkGraph: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Epoch", wireType)
			}
			m.Epoch = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkGraphService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Epoch |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nodes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkGraphService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Nodes = append(m.Nodes, &NetworkNode{})
			if err := m.Nodes[len(m.Nodes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkGraphService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CreateNetworkEntityRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkGraphService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CreateNetworkEntityRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CreateNetworkEntityRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkGraphService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Entity", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkGraphService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Entity == nil {
				m.Entity = &storage.NetworkEntityInfo_ExternalSource{}
			}
			if err := m.Entity.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkGraphService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PatchNetworkEntityRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkGraphService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PatchNetworkEntityRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PatchNetworkEntityRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkGraphService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkGraphService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkGraphService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetExternalNetworkEntitiesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkGraphService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetExternalNetworkEntitiesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetExternalNetworkEntitiesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkGraphService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkGraphService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Query = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkGraphService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetExternalNetworkEntitiesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkGraphService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetExternalNetworkEntitiesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetExternalNetworkEntitiesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Entities", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkGraphService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Entities = append(m.Entities, &storage.NetworkEntity{})
			if err := m.Entities[len(m.Entities)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkGraphService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PutNetworkGraphConfigRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkGraphService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PutNetworkGraphConfigRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PutNetworkGraphConfigRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Config", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkGraphService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Config == nil {
				m.Config = &storage.NetworkGraphConfig{}
			}
			if err := m.Config.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkGraphService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkGraphService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipNetworkGraphService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowNetworkGraphService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowNetworkGraphService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowNetworkGraphService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthNetworkGraphService
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupNetworkGraphService
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthNetworkGraphService
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthNetworkGraphService        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowNetworkGraphService          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupNetworkGraphService = fmt.Errorf("proto: unexpected end of group")
)
