// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api/v1/network_policy_service.proto

package v1

import (
	context "context"
	fmt "fmt"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	storage "github.com/stackrox/rox/generated/storage"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type NetworkPolicyInSimulation_Status int32

const (
	NetworkPolicyInSimulation_INVALID   NetworkPolicyInSimulation_Status = 0
	NetworkPolicyInSimulation_UNCHANGED NetworkPolicyInSimulation_Status = 1
	NetworkPolicyInSimulation_MODIFIED  NetworkPolicyInSimulation_Status = 2
	NetworkPolicyInSimulation_ADDED     NetworkPolicyInSimulation_Status = 3
	NetworkPolicyInSimulation_DELETED   NetworkPolicyInSimulation_Status = 4
)

var NetworkPolicyInSimulation_Status_name = map[int32]string{
	0: "INVALID",
	1: "UNCHANGED",
	2: "MODIFIED",
	3: "ADDED",
	4: "DELETED",
}

var NetworkPolicyInSimulation_Status_value = map[string]int32{
	"INVALID":   0,
	"UNCHANGED": 1,
	"MODIFIED":  2,
	"ADDED":     3,
	"DELETED":   4,
}

func (x NetworkPolicyInSimulation_Status) String() string {
	return proto.EnumName(NetworkPolicyInSimulation_Status_name, int32(x))
}

func (NetworkPolicyInSimulation_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_725659a65cce3ede, []int{8, 0}
}

type GenerateNetworkPoliciesRequest_DeleteExistingPoliciesMode int32

const (
	GenerateNetworkPoliciesRequest_UNKNOWN        GenerateNetworkPoliciesRequest_DeleteExistingPoliciesMode = 0
	GenerateNetworkPoliciesRequest_NONE           GenerateNetworkPoliciesRequest_DeleteExistingPoliciesMode = 1
	GenerateNetworkPoliciesRequest_GENERATED_ONLY GenerateNetworkPoliciesRequest_DeleteExistingPoliciesMode = 2
	GenerateNetworkPoliciesRequest_ALL            GenerateNetworkPoliciesRequest_DeleteExistingPoliciesMode = 3
)

var GenerateNetworkPoliciesRequest_DeleteExistingPoliciesMode_name = map[int32]string{
	0: "UNKNOWN",
	1: "NONE",
	2: "GENERATED_ONLY",
	3: "ALL",
}

var GenerateNetworkPoliciesRequest_DeleteExistingPoliciesMode_value = map[string]int32{
	"UNKNOWN":        0,
	"NONE":           1,
	"GENERATED_ONLY": 2,
	"ALL":            3,
}

func (x GenerateNetworkPoliciesRequest_DeleteExistingPoliciesMode) String() string {
	return proto.EnumName(GenerateNetworkPoliciesRequest_DeleteExistingPoliciesMode_name, int32(x))
}

func (GenerateNetworkPoliciesRequest_DeleteExistingPoliciesMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_725659a65cce3ede, []int{14, 0}
}

type GetNetworkPoliciesRequest struct {
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	DeploymentQuery      string   `protobuf:"bytes,2,opt,name=deployment_query,json=deploymentQuery,proto3" json:"deployment_query,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetNetworkPoliciesRequest) Reset()         { *m = GetNetworkPoliciesRequest{} }
func (m *GetNetworkPoliciesRequest) String() string { return proto.CompactTextString(m) }
func (*GetNetworkPoliciesRequest) ProtoMessage()    {}
func (*GetNetworkPoliciesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_725659a65cce3ede, []int{0}
}
func (m *GetNetworkPoliciesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetNetworkPoliciesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetNetworkPoliciesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetNetworkPoliciesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetNetworkPoliciesRequest.Merge(m, src)
}
func (m *GetNetworkPoliciesRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetNetworkPoliciesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetNetworkPoliciesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetNetworkPoliciesRequest proto.InternalMessageInfo

func (m *GetNetworkPoliciesRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *GetNetworkPoliciesRequest) GetDeploymentQuery() string {
	if m != nil {
		return m.DeploymentQuery
	}
	return ""
}

func (m *GetNetworkPoliciesRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetNetworkPoliciesRequest) Clone() *GetNetworkPoliciesRequest {
	if m == nil {
		return nil
	}
	cloned := new(GetNetworkPoliciesRequest)
	*cloned = *m

	return cloned
}

type NetworkPoliciesResponse struct {
	NetworkPolicies      []*storage.NetworkPolicy `protobuf:"bytes,1,rep,name=network_policies,json=networkPolicies,proto3" json:"network_policies,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *NetworkPoliciesResponse) Reset()         { *m = NetworkPoliciesResponse{} }
func (m *NetworkPoliciesResponse) String() string { return proto.CompactTextString(m) }
func (*NetworkPoliciesResponse) ProtoMessage()    {}
func (*NetworkPoliciesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_725659a65cce3ede, []int{1}
}
func (m *NetworkPoliciesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkPoliciesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkPoliciesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkPoliciesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkPoliciesResponse.Merge(m, src)
}
func (m *NetworkPoliciesResponse) XXX_Size() int {
	return m.Size()
}
func (m *NetworkPoliciesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkPoliciesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkPoliciesResponse proto.InternalMessageInfo

func (m *NetworkPoliciesResponse) GetNetworkPolicies() []*storage.NetworkPolicy {
	if m != nil {
		return m.NetworkPolicies
	}
	return nil
}

func (m *NetworkPoliciesResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkPoliciesResponse) Clone() *NetworkPoliciesResponse {
	if m == nil {
		return nil
	}
	cloned := new(NetworkPoliciesResponse)
	*cloned = *m

	if m.NetworkPolicies != nil {
		cloned.NetworkPolicies = make([]*storage.NetworkPolicy, len(m.NetworkPolicies))
		for idx, v := range m.NetworkPolicies {
			cloned.NetworkPolicies[idx] = v.Clone()
		}
	}
	return cloned
}

type SendNetworkPolicyYamlRequest struct {
	ClusterId            string                             `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	NotifierIds          []string                           `protobuf:"bytes,2,rep,name=notifier_ids,json=notifierIds,proto3" json:"notifier_ids,omitempty"`
	Modification         *storage.NetworkPolicyModification `protobuf:"bytes,3,opt,name=modification,proto3" json:"modification,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *SendNetworkPolicyYamlRequest) Reset()         { *m = SendNetworkPolicyYamlRequest{} }
func (m *SendNetworkPolicyYamlRequest) String() string { return proto.CompactTextString(m) }
func (*SendNetworkPolicyYamlRequest) ProtoMessage()    {}
func (*SendNetworkPolicyYamlRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_725659a65cce3ede, []int{2}
}
func (m *SendNetworkPolicyYamlRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SendNetworkPolicyYamlRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SendNetworkPolicyYamlRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SendNetworkPolicyYamlRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SendNetworkPolicyYamlRequest.Merge(m, src)
}
func (m *SendNetworkPolicyYamlRequest) XXX_Size() int {
	return m.Size()
}
func (m *SendNetworkPolicyYamlRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SendNetworkPolicyYamlRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SendNetworkPolicyYamlRequest proto.InternalMessageInfo

func (m *SendNetworkPolicyYamlRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SendNetworkPolicyYamlRequest) GetNotifierIds() []string {
	if m != nil {
		return m.NotifierIds
	}
	return nil
}

func (m *SendNetworkPolicyYamlRequest) GetModification() *storage.NetworkPolicyModification {
	if m != nil {
		return m.Modification
	}
	return nil
}

func (m *SendNetworkPolicyYamlRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *SendNetworkPolicyYamlRequest) Clone() *SendNetworkPolicyYamlRequest {
	if m == nil {
		return nil
	}
	cloned := new(SendNetworkPolicyYamlRequest)
	*cloned = *m

	if m.NotifierIds != nil {
		cloned.NotifierIds = make([]string, len(m.NotifierIds))
		copy(cloned.NotifierIds, m.NotifierIds)
	}
	cloned.Modification = m.Modification.Clone()
	return cloned
}

type GetNetworkGraphRequest struct {
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	Query     string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// If set to true, include port-level information in the network policy graph.
	IncludePorts         bool               `protobuf:"varint,3,opt,name=include_ports,json=includePorts,proto3" json:"include_ports,omitempty"`
	Scope                *NetworkGraphScope `protobuf:"bytes,4,opt,name=scope,proto3" json:"scope,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *GetNetworkGraphRequest) Reset()         { *m = GetNetworkGraphRequest{} }
func (m *GetNetworkGraphRequest) String() string { return proto.CompactTextString(m) }
func (*GetNetworkGraphRequest) ProtoMessage()    {}
func (*GetNetworkGraphRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_725659a65cce3ede, []int{3}
}
func (m *GetNetworkGraphRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetNetworkGraphRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetNetworkGraphRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetNetworkGraphRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetNetworkGraphRequest.Merge(m, src)
}
func (m *GetNetworkGraphRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetNetworkGraphRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetNetworkGraphRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetNetworkGraphRequest proto.InternalMessageInfo

func (m *GetNetworkGraphRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *GetNetworkGraphRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *GetNetworkGraphRequest) GetIncludePorts() bool {
	if m != nil {
		return m.IncludePorts
	}
	return false
}

func (m *GetNetworkGraphRequest) GetScope() *NetworkGraphScope {
	if m != nil {
		return m.Scope
	}
	return nil
}

func (m *GetNetworkGraphRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetNetworkGraphRequest) Clone() *GetNetworkGraphRequest {
	if m == nil {
		return nil
	}
	cloned := new(GetNetworkGraphRequest)
	*cloned = *m

	cloned.Scope = m.Scope.Clone()
	return cloned
}

type SimulateNetworkGraphRequest struct {
	ClusterId    string                             `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	Query        string                             `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	Modification *storage.NetworkPolicyModification `protobuf:"bytes,3,opt,name=modification,proto3" json:"modification,omitempty"`
	// If set to true, include port-level information in the network policy graph.
	IncludePorts         bool               `protobuf:"varint,4,opt,name=include_ports,json=includePorts,proto3" json:"include_ports,omitempty"`
	IncludeNodeDiff      bool               `protobuf:"varint,5,opt,name=include_node_diff,json=includeNodeDiff,proto3" json:"include_node_diff,omitempty"`
	Scope                *NetworkGraphScope `protobuf:"bytes,6,opt,name=scope,proto3" json:"scope,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *SimulateNetworkGraphRequest) Reset()         { *m = SimulateNetworkGraphRequest{} }
func (m *SimulateNetworkGraphRequest) String() string { return proto.CompactTextString(m) }
func (*SimulateNetworkGraphRequest) ProtoMessage()    {}
func (*SimulateNetworkGraphRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_725659a65cce3ede, []int{4}
}
func (m *SimulateNetworkGraphRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SimulateNetworkGraphRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SimulateNetworkGraphRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SimulateNetworkGraphRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SimulateNetworkGraphRequest.Merge(m, src)
}
func (m *SimulateNetworkGraphRequest) XXX_Size() int {
	return m.Size()
}
func (m *SimulateNetworkGraphRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SimulateNetworkGraphRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SimulateNetworkGraphRequest proto.InternalMessageInfo

func (m *SimulateNetworkGraphRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SimulateNetworkGraphRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *SimulateNetworkGraphRequest) GetModification() *storage.NetworkPolicyModification {
	if m != nil {
		return m.Modification
	}
	return nil
}

func (m *SimulateNetworkGraphRequest) GetIncludePorts() bool {
	if m != nil {
		return m.IncludePorts
	}
	return false
}

func (m *SimulateNetworkGraphRequest) GetIncludeNodeDiff() bool {
	if m != nil {
		return m.IncludeNodeDiff
	}
	return false
}

func (m *SimulateNetworkGraphRequest) GetScope() *NetworkGraphScope {
	if m != nil {
		return m.Scope
	}
	return nil
}

func (m *SimulateNetworkGraphRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *SimulateNetworkGraphRequest) Clone() *SimulateNetworkGraphRequest {
	if m == nil {
		return nil
	}
	cloned := new(SimulateNetworkGraphRequest)
	*cloned = *m

	cloned.Modification = m.Modification.Clone()
	cloned.Scope = m.Scope.Clone()
	return cloned
}

type ApplyNetworkPolicyYamlRequest struct {
	ClusterId            string                             `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	Modification         *storage.NetworkPolicyModification `protobuf:"bytes,2,opt,name=modification,proto3" json:"modification,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *ApplyNetworkPolicyYamlRequest) Reset()         { *m = ApplyNetworkPolicyYamlRequest{} }
func (m *ApplyNetworkPolicyYamlRequest) String() string { return proto.CompactTextString(m) }
func (*ApplyNetworkPolicyYamlRequest) ProtoMessage()    {}
func (*ApplyNetworkPolicyYamlRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_725659a65cce3ede, []int{5}
}
func (m *ApplyNetworkPolicyYamlRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ApplyNetworkPolicyYamlRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ApplyNetworkPolicyYamlRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ApplyNetworkPolicyYamlRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplyNetworkPolicyYamlRequest.Merge(m, src)
}
func (m *ApplyNetworkPolicyYamlRequest) XXX_Size() int {
	return m.Size()
}
func (m *ApplyNetworkPolicyYamlRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplyNetworkPolicyYamlRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ApplyNetworkPolicyYamlRequest proto.InternalMessageInfo

func (m *ApplyNetworkPolicyYamlRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *ApplyNetworkPolicyYamlRequest) GetModification() *storage.NetworkPolicyModification {
	if m != nil {
		return m.Modification
	}
	return nil
}

func (m *ApplyNetworkPolicyYamlRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ApplyNetworkPolicyYamlRequest) Clone() *ApplyNetworkPolicyYamlRequest {
	if m == nil {
		return nil
	}
	cloned := new(ApplyNetworkPolicyYamlRequest)
	*cloned = *m

	cloned.Modification = m.Modification.Clone()
	return cloned
}

type GetUndoModificationRequest struct {
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetUndoModificationRequest) Reset()         { *m = GetUndoModificationRequest{} }
func (m *GetUndoModificationRequest) String() string { return proto.CompactTextString(m) }
func (*GetUndoModificationRequest) ProtoMessage()    {}
func (*GetUndoModificationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_725659a65cce3ede, []int{6}
}
func (m *GetUndoModificationRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetUndoModificationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetUndoModificationRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetUndoModificationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetUndoModificationRequest.Merge(m, src)
}
func (m *GetUndoModificationRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetUndoModificationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetUndoModificationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetUndoModificationRequest proto.InternalMessageInfo

func (m *GetUndoModificationRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *GetUndoModificationRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetUndoModificationRequest) Clone() *GetUndoModificationRequest {
	if m == nil {
		return nil
	}
	cloned := new(GetUndoModificationRequest)
	*cloned = *m

	return cloned
}

type GetUndoModificationResponse struct {
	UndoRecord           *storage.NetworkPolicyApplicationUndoRecord `protobuf:"bytes,1,opt,name=undo_record,json=undoRecord,proto3" json:"undo_record,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                    `json:"-"`
	XXX_unrecognized     []byte                                      `json:"-"`
	XXX_sizecache        int32                                       `json:"-"`
}

func (m *GetUndoModificationResponse) Reset()         { *m = GetUndoModificationResponse{} }
func (m *GetUndoModificationResponse) String() string { return proto.CompactTextString(m) }
func (*GetUndoModificationResponse) ProtoMessage()    {}
func (*GetUndoModificationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_725659a65cce3ede, []int{7}
}
func (m *GetUndoModificationResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetUndoModificationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetUndoModificationResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetUndoModificationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetUndoModificationResponse.Merge(m, src)
}
func (m *GetUndoModificationResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetUndoModificationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetUndoModificationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetUndoModificationResponse proto.InternalMessageInfo

func (m *GetUndoModificationResponse) GetUndoRecord() *storage.NetworkPolicyApplicationUndoRecord {
	if m != nil {
		return m.UndoRecord
	}
	return nil
}

func (m *GetUndoModificationResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetUndoModificationResponse) Clone() *GetUndoModificationResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetUndoModificationResponse)
	*cloned = *m

	cloned.UndoRecord = m.UndoRecord.Clone()
	return cloned
}

type NetworkPolicyInSimulation struct {
	Policy               *storage.NetworkPolicy           `protobuf:"bytes,1,opt,name=policy,proto3" json:"policy,omitempty"`
	Status               NetworkPolicyInSimulation_Status `protobuf:"varint,2,opt,name=status,proto3,enum=v1.NetworkPolicyInSimulation_Status" json:"status,omitempty"`
	OldPolicy            *storage.NetworkPolicy           `protobuf:"bytes,3,opt,name=old_policy,json=oldPolicy,proto3" json:"old_policy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_unrecognized     []byte                           `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *NetworkPolicyInSimulation) Reset()         { *m = NetworkPolicyInSimulation{} }
func (m *NetworkPolicyInSimulation) String() string { return proto.CompactTextString(m) }
func (*NetworkPolicyInSimulation) ProtoMessage()    {}
func (*NetworkPolicyInSimulation) Descriptor() ([]byte, []int) {
	return fileDescriptor_725659a65cce3ede, []int{8}
}
func (m *NetworkPolicyInSimulation) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkPolicyInSimulation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkPolicyInSimulation.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkPolicyInSimulation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkPolicyInSimulation.Merge(m, src)
}
func (m *NetworkPolicyInSimulation) XXX_Size() int {
	return m.Size()
}
func (m *NetworkPolicyInSimulation) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkPolicyInSimulation.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkPolicyInSimulation proto.InternalMessageInfo

func (m *NetworkPolicyInSimulation) GetPolicy() *storage.NetworkPolicy {
	if m != nil {
		return m.Policy
	}
	return nil
}

func (m *NetworkPolicyInSimulation) GetStatus() NetworkPolicyInSimulation_Status {
	if m != nil {
		return m.Status
	}
	return NetworkPolicyInSimulation_INVALID
}

func (m *NetworkPolicyInSimulation) GetOldPolicy() *storage.NetworkPolicy {
	if m != nil {
		return m.OldPolicy
	}
	return nil
}

func (m *NetworkPolicyInSimulation) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkPolicyInSimulation) Clone() *NetworkPolicyInSimulation {
	if m == nil {
		return nil
	}
	cloned := new(NetworkPolicyInSimulation)
	*cloned = *m

	cloned.Policy = m.Policy.Clone()
	cloned.OldPolicy = m.OldPolicy.Clone()
	return cloned
}

type NetworkNodeDiff struct {
	PolicyIds            []string                                `protobuf:"bytes,1,rep,name=policy_ids,json=policyIds,proto3" json:"policy_ids,omitempty"`
	DEPRECATEDOutEdges   map[int32]*NetworkEdgePropertiesBundle  `protobuf:"bytes,2,rep,name=DEPRECATED_out_edges,json=DEPRECATEDOutEdges,proto3" json:"DEPRECATED_out_edges,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"` // Deprecated: Do not use.
	OutEdges             map[string]*NetworkEdgePropertiesBundle `protobuf:"bytes,5,rep,name=out_edges,json=outEdges,proto3" json:"out_edges,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	NonIsolatedIngress   bool                                    `protobuf:"varint,3,opt,name=non_isolated_ingress,json=nonIsolatedIngress,proto3" json:"non_isolated_ingress,omitempty"`
	NonIsolatedEgress    bool                                    `protobuf:"varint,4,opt,name=non_isolated_egress,json=nonIsolatedEgress,proto3" json:"non_isolated_egress,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                `json:"-"`
	XXX_unrecognized     []byte                                  `json:"-"`
	XXX_sizecache        int32                                   `json:"-"`
}

func (m *NetworkNodeDiff) Reset()         { *m = NetworkNodeDiff{} }
func (m *NetworkNodeDiff) String() string { return proto.CompactTextString(m) }
func (*NetworkNodeDiff) ProtoMessage()    {}
func (*NetworkNodeDiff) Descriptor() ([]byte, []int) {
	return fileDescriptor_725659a65cce3ede, []int{9}
}
func (m *NetworkNodeDiff) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkNodeDiff) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkNodeDiff.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkNodeDiff) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkNodeDiff.Merge(m, src)
}
func (m *NetworkNodeDiff) XXX_Size() int {
	return m.Size()
}
func (m *NetworkNodeDiff) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkNodeDiff.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkNodeDiff proto.InternalMessageInfo

func (m *NetworkNodeDiff) GetPolicyIds() []string {
	if m != nil {
		return m.PolicyIds
	}
	return nil
}

// Deprecated: Do not use.
func (m *NetworkNodeDiff) GetDEPRECATEDOutEdges() map[int32]*NetworkEdgePropertiesBundle {
	if m != nil {
		return m.DEPRECATEDOutEdges
	}
	return nil
}

func (m *NetworkNodeDiff) GetOutEdges() map[string]*NetworkEdgePropertiesBundle {
	if m != nil {
		return m.OutEdges
	}
	return nil
}

func (m *NetworkNodeDiff) GetNonIsolatedIngress() bool {
	if m != nil {
		return m.NonIsolatedIngress
	}
	return false
}

func (m *NetworkNodeDiff) GetNonIsolatedEgress() bool {
	if m != nil {
		return m.NonIsolatedEgress
	}
	return false
}

func (m *NetworkNodeDiff) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkNodeDiff) Clone() *NetworkNodeDiff {
	if m == nil {
		return nil
	}
	cloned := new(NetworkNodeDiff)
	*cloned = *m

	if m.PolicyIds != nil {
		cloned.PolicyIds = make([]string, len(m.PolicyIds))
		copy(cloned.PolicyIds, m.PolicyIds)
	}
	if m.DEPRECATEDOutEdges != nil {
		cloned.DEPRECATEDOutEdges = make(map[int32]*NetworkEdgePropertiesBundle, len(m.DEPRECATEDOutEdges))
		for k, v := range m.DEPRECATEDOutEdges {
			cloned.DEPRECATEDOutEdges[k] = v.Clone()
		}
	}
	if m.OutEdges != nil {
		cloned.OutEdges = make(map[string]*NetworkEdgePropertiesBundle, len(m.OutEdges))
		for k, v := range m.OutEdges {
			cloned.OutEdges[k] = v.Clone()
		}
	}
	return cloned
}

type NetworkGraphDiff struct {
	DEPRECATEDNodeDiffs  map[int32]*NetworkNodeDiff  `protobuf:"bytes,1,rep,name=DEPRECATED_node_diffs,json=DEPRECATEDNodeDiffs,proto3" json:"DEPRECATED_node_diffs,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"` // Deprecated: Do not use.
	NodeDiffs            map[string]*NetworkNodeDiff `protobuf:"bytes,2,rep,name=node_diffs,json=nodeDiffs,proto3" json:"node_diffs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *NetworkGraphDiff) Reset()         { *m = NetworkGraphDiff{} }
func (m *NetworkGraphDiff) String() string { return proto.CompactTextString(m) }
func (*NetworkGraphDiff) ProtoMessage()    {}
func (*NetworkGraphDiff) Descriptor() ([]byte, []int) {
	return fileDescriptor_725659a65cce3ede, []int{10}
}
func (m *NetworkGraphDiff) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkGraphDiff) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkGraphDiff.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkGraphDiff) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkGraphDiff.Merge(m, src)
}
func (m *NetworkGraphDiff) XXX_Size() int {
	return m.Size()
}
func (m *NetworkGraphDiff) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkGraphDiff.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkGraphDiff proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *NetworkGraphDiff) GetDEPRECATEDNodeDiffs() map[int32]*NetworkNodeDiff {
	if m != nil {
		return m.DEPRECATEDNodeDiffs
	}
	return nil
}

func (m *NetworkGraphDiff) GetNodeDiffs() map[string]*NetworkNodeDiff {
	if m != nil {
		return m.NodeDiffs
	}
	return nil
}

func (m *NetworkGraphDiff) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkGraphDiff) Clone() *NetworkGraphDiff {
	if m == nil {
		return nil
	}
	cloned := new(NetworkGraphDiff)
	*cloned = *m

	if m.DEPRECATEDNodeDiffs != nil {
		cloned.DEPRECATEDNodeDiffs = make(map[int32]*NetworkNodeDiff, len(m.DEPRECATEDNodeDiffs))
		for k, v := range m.DEPRECATEDNodeDiffs {
			cloned.DEPRECATEDNodeDiffs[k] = v.Clone()
		}
	}
	if m.NodeDiffs != nil {
		cloned.NodeDiffs = make(map[string]*NetworkNodeDiff, len(m.NodeDiffs))
		for k, v := range m.NodeDiffs {
			cloned.NodeDiffs[k] = v.Clone()
		}
	}
	return cloned
}

type SimulateNetworkGraphResponse struct {
	SimulatedGraph       *NetworkGraph                `protobuf:"bytes,1,opt,name=simulated_graph,json=simulatedGraph,proto3" json:"simulated_graph,omitempty"`
	Policies             []*NetworkPolicyInSimulation `protobuf:"bytes,2,rep,name=policies,proto3" json:"policies,omitempty"`
	Added                *NetworkGraphDiff            `protobuf:"bytes,3,opt,name=added,proto3" json:"added,omitempty"`
	Removed              *NetworkGraphDiff            `protobuf:"bytes,4,opt,name=removed,proto3" json:"removed,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *SimulateNetworkGraphResponse) Reset()         { *m = SimulateNetworkGraphResponse{} }
func (m *SimulateNetworkGraphResponse) String() string { return proto.CompactTextString(m) }
func (*SimulateNetworkGraphResponse) ProtoMessage()    {}
func (*SimulateNetworkGraphResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_725659a65cce3ede, []int{11}
}
func (m *SimulateNetworkGraphResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SimulateNetworkGraphResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SimulateNetworkGraphResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SimulateNetworkGraphResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SimulateNetworkGraphResponse.Merge(m, src)
}
func (m *SimulateNetworkGraphResponse) XXX_Size() int {
	return m.Size()
}
func (m *SimulateNetworkGraphResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SimulateNetworkGraphResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SimulateNetworkGraphResponse proto.InternalMessageInfo

func (m *SimulateNetworkGraphResponse) GetSimulatedGraph() *NetworkGraph {
	if m != nil {
		return m.SimulatedGraph
	}
	return nil
}

func (m *SimulateNetworkGraphResponse) GetPolicies() []*NetworkPolicyInSimulation {
	if m != nil {
		return m.Policies
	}
	return nil
}

func (m *SimulateNetworkGraphResponse) GetAdded() *NetworkGraphDiff {
	if m != nil {
		return m.Added
	}
	return nil
}

func (m *SimulateNetworkGraphResponse) GetRemoved() *NetworkGraphDiff {
	if m != nil {
		return m.Removed
	}
	return nil
}

func (m *SimulateNetworkGraphResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *SimulateNetworkGraphResponse) Clone() *SimulateNetworkGraphResponse {
	if m == nil {
		return nil
	}
	cloned := new(SimulateNetworkGraphResponse)
	*cloned = *m

	cloned.SimulatedGraph = m.SimulatedGraph.Clone()
	if m.Policies != nil {
		cloned.Policies = make([]*NetworkPolicyInSimulation, len(m.Policies))
		for idx, v := range m.Policies {
			cloned.Policies[idx] = v.Clone()
		}
	}
	cloned.Added = m.Added.Clone()
	cloned.Removed = m.Removed.Clone()
	return cloned
}

type GetNetworkGraphEpochRequest struct {
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetNetworkGraphEpochRequest) Reset()         { *m = GetNetworkGraphEpochRequest{} }
func (m *GetNetworkGraphEpochRequest) String() string { return proto.CompactTextString(m) }
func (*GetNetworkGraphEpochRequest) ProtoMessage()    {}
func (*GetNetworkGraphEpochRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_725659a65cce3ede, []int{12}
}
func (m *GetNetworkGraphEpochRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetNetworkGraphEpochRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetNetworkGraphEpochRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetNetworkGraphEpochRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetNetworkGraphEpochRequest.Merge(m, src)
}
func (m *GetNetworkGraphEpochRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetNetworkGraphEpochRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetNetworkGraphEpochRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetNetworkGraphEpochRequest proto.InternalMessageInfo

func (m *GetNetworkGraphEpochRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *GetNetworkGraphEpochRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetNetworkGraphEpochRequest) Clone() *GetNetworkGraphEpochRequest {
	if m == nil {
		return nil
	}
	cloned := new(GetNetworkGraphEpochRequest)
	*cloned = *m

	return cloned
}

type NetworkGraphEpoch struct {
	Epoch                uint32   `protobuf:"varint,1,opt,name=epoch,proto3" json:"epoch,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NetworkGraphEpoch) Reset()         { *m = NetworkGraphEpoch{} }
func (m *NetworkGraphEpoch) String() string { return proto.CompactTextString(m) }
func (*NetworkGraphEpoch) ProtoMessage()    {}
func (*NetworkGraphEpoch) Descriptor() ([]byte, []int) {
	return fileDescriptor_725659a65cce3ede, []int{13}
}
func (m *NetworkGraphEpoch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkGraphEpoch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkGraphEpoch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkGraphEpoch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkGraphEpoch.Merge(m, src)
}
func (m *NetworkGraphEpoch) XXX_Size() int {
	return m.Size()
}
func (m *NetworkGraphEpoch) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkGraphEpoch.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkGraphEpoch proto.InternalMessageInfo

func (m *NetworkGraphEpoch) GetEpoch() uint32 {
	if m != nil {
		return m.Epoch
	}
	return 0
}

func (m *NetworkGraphEpoch) MessageClone() proto.Message {
	return m.Clone()
}
func (m *NetworkGraphEpoch) Clone() *NetworkGraphEpoch {
	if m == nil {
		return nil
	}
	cloned := new(NetworkGraphEpoch)
	*cloned = *m

	return cloned
}

// Next available tag: 5
type GenerateNetworkPoliciesRequest struct {
	ClusterId            string                                                    `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	Query                string                                                    `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	DeleteExisting       GenerateNetworkPoliciesRequest_DeleteExistingPoliciesMode `protobuf:"varint,3,opt,name=delete_existing,json=deleteExisting,proto3,enum=v1.GenerateNetworkPoliciesRequest_DeleteExistingPoliciesMode" json:"delete_existing,omitempty"`
	NetworkDataSince     *types.Timestamp                                          `protobuf:"bytes,4,opt,name=network_data_since,json=networkDataSince,proto3" json:"network_data_since,omitempty"`
	IncludePorts         bool                                                      `protobuf:"varint,5,opt,name=include_ports,json=includePorts,proto3" json:"include_ports,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                                  `json:"-"`
	XXX_unrecognized     []byte                                                    `json:"-"`
	XXX_sizecache        int32                                                     `json:"-"`
}

func (m *GenerateNetworkPoliciesRequest) Reset()         { *m = GenerateNetworkPoliciesRequest{} }
func (m *GenerateNetworkPoliciesRequest) String() string { return proto.CompactTextString(m) }
func (*GenerateNetworkPoliciesRequest) ProtoMessage()    {}
func (*GenerateNetworkPoliciesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_725659a65cce3ede, []int{14}
}
func (m *GenerateNetworkPoliciesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GenerateNetworkPoliciesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GenerateNetworkPoliciesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GenerateNetworkPoliciesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenerateNetworkPoliciesRequest.Merge(m, src)
}
func (m *GenerateNetworkPoliciesRequest) XXX_Size() int {
	return m.Size()
}
func (m *GenerateNetworkPoliciesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GenerateNetworkPoliciesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GenerateNetworkPoliciesRequest proto.InternalMessageInfo

func (m *GenerateNetworkPoliciesRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *GenerateNetworkPoliciesRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *GenerateNetworkPoliciesRequest) GetDeleteExisting() GenerateNetworkPoliciesRequest_DeleteExistingPoliciesMode {
	if m != nil {
		return m.DeleteExisting
	}
	return GenerateNetworkPoliciesRequest_UNKNOWN
}

func (m *GenerateNetworkPoliciesRequest) GetNetworkDataSince() *types.Timestamp {
	if m != nil {
		return m.NetworkDataSince
	}
	return nil
}

func (m *GenerateNetworkPoliciesRequest) GetIncludePorts() bool {
	if m != nil {
		return m.IncludePorts
	}
	return false
}

func (m *GenerateNetworkPoliciesRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GenerateNetworkPoliciesRequest) Clone() *GenerateNetworkPoliciesRequest {
	if m == nil {
		return nil
	}
	cloned := new(GenerateNetworkPoliciesRequest)
	*cloned = *m

	cloned.NetworkDataSince = m.NetworkDataSince.Clone()
	return cloned
}

// Next available tag: 2
type GenerateNetworkPoliciesResponse struct {
	Modification         *storage.NetworkPolicyModification `protobuf:"bytes,1,opt,name=modification,proto3" json:"modification,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *GenerateNetworkPoliciesResponse) Reset()         { *m = GenerateNetworkPoliciesResponse{} }
func (m *GenerateNetworkPoliciesResponse) String() string { return proto.CompactTextString(m) }
func (*GenerateNetworkPoliciesResponse) ProtoMessage()    {}
func (*GenerateNetworkPoliciesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_725659a65cce3ede, []int{15}
}
func (m *GenerateNetworkPoliciesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GenerateNetworkPoliciesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GenerateNetworkPoliciesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GenerateNetworkPoliciesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenerateNetworkPoliciesResponse.Merge(m, src)
}
func (m *GenerateNetworkPoliciesResponse) XXX_Size() int {
	return m.Size()
}
func (m *GenerateNetworkPoliciesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GenerateNetworkPoliciesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GenerateNetworkPoliciesResponse proto.InternalMessageInfo

func (m *GenerateNetworkPoliciesResponse) GetModification() *storage.NetworkPolicyModification {
	if m != nil {
		return m.Modification
	}
	return nil
}

func (m *GenerateNetworkPoliciesResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GenerateNetworkPoliciesResponse) Clone() *GenerateNetworkPoliciesResponse {
	if m == nil {
		return nil
	}
	cloned := new(GenerateNetworkPoliciesResponse)
	*cloned = *m

	cloned.Modification = m.Modification.Clone()
	return cloned
}

type GetBaselineGeneratedPolicyForDeploymentRequest struct {
	DeploymentId         string                                                    `protobuf:"bytes,1,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	DeleteExisting       GenerateNetworkPoliciesRequest_DeleteExistingPoliciesMode `protobuf:"varint,2,opt,name=delete_existing,json=deleteExisting,proto3,enum=v1.GenerateNetworkPoliciesRequest_DeleteExistingPoliciesMode" json:"delete_existing,omitempty"`
	IncludePorts         bool                                                      `protobuf:"varint,3,opt,name=include_ports,json=includePorts,proto3" json:"include_ports,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                                  `json:"-"`
	XXX_unrecognized     []byte                                                    `json:"-"`
	XXX_sizecache        int32                                                     `json:"-"`
}

func (m *GetBaselineGeneratedPolicyForDeploymentRequest) Reset() {
	*m = GetBaselineGeneratedPolicyForDeploymentRequest{}
}
func (m *GetBaselineGeneratedPolicyForDeploymentRequest) String() string {
	return proto.CompactTextString(m)
}
func (*GetBaselineGeneratedPolicyForDeploymentRequest) ProtoMessage() {}
func (*GetBaselineGeneratedPolicyForDeploymentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_725659a65cce3ede, []int{16}
}
func (m *GetBaselineGeneratedPolicyForDeploymentRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetBaselineGeneratedPolicyForDeploymentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetBaselineGeneratedPolicyForDeploymentRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetBaselineGeneratedPolicyForDeploymentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetBaselineGeneratedPolicyForDeploymentRequest.Merge(m, src)
}
func (m *GetBaselineGeneratedPolicyForDeploymentRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetBaselineGeneratedPolicyForDeploymentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetBaselineGeneratedPolicyForDeploymentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetBaselineGeneratedPolicyForDeploymentRequest proto.InternalMessageInfo

func (m *GetBaselineGeneratedPolicyForDeploymentRequest) GetDeploymentId() string {
	if m != nil {
		return m.DeploymentId
	}
	return ""
}

func (m *GetBaselineGeneratedPolicyForDeploymentRequest) GetDeleteExisting() GenerateNetworkPoliciesRequest_DeleteExistingPoliciesMode {
	if m != nil {
		return m.DeleteExisting
	}
	return GenerateNetworkPoliciesRequest_UNKNOWN
}

func (m *GetBaselineGeneratedPolicyForDeploymentRequest) GetIncludePorts() bool {
	if m != nil {
		return m.IncludePorts
	}
	return false
}

func (m *GetBaselineGeneratedPolicyForDeploymentRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetBaselineGeneratedPolicyForDeploymentRequest) Clone() *GetBaselineGeneratedPolicyForDeploymentRequest {
	if m == nil {
		return nil
	}
	cloned := new(GetBaselineGeneratedPolicyForDeploymentRequest)
	*cloned = *m

	return cloned
}

type GetBaselineGeneratedPolicyForDeploymentResponse struct {
	Modification         *storage.NetworkPolicyModification `protobuf:"bytes,1,opt,name=modification,proto3" json:"modification,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *GetBaselineGeneratedPolicyForDeploymentResponse) Reset() {
	*m = GetBaselineGeneratedPolicyForDeploymentResponse{}
}
func (m *GetBaselineGeneratedPolicyForDeploymentResponse) String() string {
	return proto.CompactTextString(m)
}
func (*GetBaselineGeneratedPolicyForDeploymentResponse) ProtoMessage() {}
func (*GetBaselineGeneratedPolicyForDeploymentResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_725659a65cce3ede, []int{17}
}
func (m *GetBaselineGeneratedPolicyForDeploymentResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetBaselineGeneratedPolicyForDeploymentResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetBaselineGeneratedPolicyForDeploymentResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetBaselineGeneratedPolicyForDeploymentResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetBaselineGeneratedPolicyForDeploymentResponse.Merge(m, src)
}
func (m *GetBaselineGeneratedPolicyForDeploymentResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetBaselineGeneratedPolicyForDeploymentResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetBaselineGeneratedPolicyForDeploymentResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetBaselineGeneratedPolicyForDeploymentResponse proto.InternalMessageInfo

func (m *GetBaselineGeneratedPolicyForDeploymentResponse) GetModification() *storage.NetworkPolicyModification {
	if m != nil {
		return m.Modification
	}
	return nil
}

func (m *GetBaselineGeneratedPolicyForDeploymentResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetBaselineGeneratedPolicyForDeploymentResponse) Clone() *GetBaselineGeneratedPolicyForDeploymentResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetBaselineGeneratedPolicyForDeploymentResponse)
	*cloned = *m

	cloned.Modification = m.Modification.Clone()
	return cloned
}

type GetAllowedPeersFromCurrentPolicyForDeploymentResponse struct {
	AllowedPeers         []*NetworkBaselineStatusPeer `protobuf:"bytes,1,rep,name=allowed_peers,json=allowedPeers,proto3" json:"allowed_peers,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *GetAllowedPeersFromCurrentPolicyForDeploymentResponse) Reset() {
	*m = GetAllowedPeersFromCurrentPolicyForDeploymentResponse{}
}
func (m *GetAllowedPeersFromCurrentPolicyForDeploymentResponse) String() string {
	return proto.CompactTextString(m)
}
func (*GetAllowedPeersFromCurrentPolicyForDeploymentResponse) ProtoMessage() {}
func (*GetAllowedPeersFromCurrentPolicyForDeploymentResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_725659a65cce3ede, []int{18}
}
func (m *GetAllowedPeersFromCurrentPolicyForDeploymentResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetAllowedPeersFromCurrentPolicyForDeploymentResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetAllowedPeersFromCurrentPolicyForDeploymentResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetAllowedPeersFromCurrentPolicyForDeploymentResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetAllowedPeersFromCurrentPolicyForDeploymentResponse.Merge(m, src)
}
func (m *GetAllowedPeersFromCurrentPolicyForDeploymentResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetAllowedPeersFromCurrentPolicyForDeploymentResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetAllowedPeersFromCurrentPolicyForDeploymentResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetAllowedPeersFromCurrentPolicyForDeploymentResponse proto.InternalMessageInfo

func (m *GetAllowedPeersFromCurrentPolicyForDeploymentResponse) GetAllowedPeers() []*NetworkBaselineStatusPeer {
	if m != nil {
		return m.AllowedPeers
	}
	return nil
}

func (m *GetAllowedPeersFromCurrentPolicyForDeploymentResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetAllowedPeersFromCurrentPolicyForDeploymentResponse) Clone() *GetAllowedPeersFromCurrentPolicyForDeploymentResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetAllowedPeersFromCurrentPolicyForDeploymentResponse)
	*cloned = *m

	if m.AllowedPeers != nil {
		cloned.AllowedPeers = make([]*NetworkBaselineStatusPeer, len(m.AllowedPeers))
		for idx, v := range m.AllowedPeers {
			cloned.AllowedPeers[idx] = v.Clone()
		}
	}
	return cloned
}

type ApplyNetworkPolicyYamlForDeploymentRequest struct {
	DeploymentId         string                             `protobuf:"bytes,1,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	Modification         *storage.NetworkPolicyModification `protobuf:"bytes,2,opt,name=modification,proto3" json:"modification,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *ApplyNetworkPolicyYamlForDeploymentRequest) Reset() {
	*m = ApplyNetworkPolicyYamlForDeploymentRequest{}
}
func (m *ApplyNetworkPolicyYamlForDeploymentRequest) String() string {
	return proto.CompactTextString(m)
}
func (*ApplyNetworkPolicyYamlForDeploymentRequest) ProtoMessage() {}
func (*ApplyNetworkPolicyYamlForDeploymentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_725659a65cce3ede, []int{19}
}
func (m *ApplyNetworkPolicyYamlForDeploymentRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ApplyNetworkPolicyYamlForDeploymentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ApplyNetworkPolicyYamlForDeploymentRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ApplyNetworkPolicyYamlForDeploymentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplyNetworkPolicyYamlForDeploymentRequest.Merge(m, src)
}
func (m *ApplyNetworkPolicyYamlForDeploymentRequest) XXX_Size() int {
	return m.Size()
}
func (m *ApplyNetworkPolicyYamlForDeploymentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplyNetworkPolicyYamlForDeploymentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ApplyNetworkPolicyYamlForDeploymentRequest proto.InternalMessageInfo

func (m *ApplyNetworkPolicyYamlForDeploymentRequest) GetDeploymentId() string {
	if m != nil {
		return m.DeploymentId
	}
	return ""
}

func (m *ApplyNetworkPolicyYamlForDeploymentRequest) GetModification() *storage.NetworkPolicyModification {
	if m != nil {
		return m.Modification
	}
	return nil
}

func (m *ApplyNetworkPolicyYamlForDeploymentRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ApplyNetworkPolicyYamlForDeploymentRequest) Clone() *ApplyNetworkPolicyYamlForDeploymentRequest {
	if m == nil {
		return nil
	}
	cloned := new(ApplyNetworkPolicyYamlForDeploymentRequest)
	*cloned = *m

	cloned.Modification = m.Modification.Clone()
	return cloned
}

type GetUndoModificationForDeploymentResponse struct {
	UndoRecord           *storage.NetworkPolicyApplicationUndoRecord `protobuf:"bytes,1,opt,name=undo_record,json=undoRecord,proto3" json:"undo_record,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                    `json:"-"`
	XXX_unrecognized     []byte                                      `json:"-"`
	XXX_sizecache        int32                                       `json:"-"`
}

func (m *GetUndoModificationForDeploymentResponse) Reset() {
	*m = GetUndoModificationForDeploymentResponse{}
}
func (m *GetUndoModificationForDeploymentResponse) String() string { return proto.CompactTextString(m) }
func (*GetUndoModificationForDeploymentResponse) ProtoMessage()    {}
func (*GetUndoModificationForDeploymentResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_725659a65cce3ede, []int{20}
}
func (m *GetUndoModificationForDeploymentResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetUndoModificationForDeploymentResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetUndoModificationForDeploymentResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetUndoModificationForDeploymentResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetUndoModificationForDeploymentResponse.Merge(m, src)
}
func (m *GetUndoModificationForDeploymentResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetUndoModificationForDeploymentResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetUndoModificationForDeploymentResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetUndoModificationForDeploymentResponse proto.InternalMessageInfo

func (m *GetUndoModificationForDeploymentResponse) GetUndoRecord() *storage.NetworkPolicyApplicationUndoRecord {
	if m != nil {
		return m.UndoRecord
	}
	return nil
}

func (m *GetUndoModificationForDeploymentResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetUndoModificationForDeploymentResponse) Clone() *GetUndoModificationForDeploymentResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetUndoModificationForDeploymentResponse)
	*cloned = *m

	cloned.UndoRecord = m.UndoRecord.Clone()
	return cloned
}

type GetDiffFlowsReconciledFlow struct {
	Entity               *storage.NetworkEntityInfo                     `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	Added                []*storage.NetworkBaselineConnectionProperties `protobuf:"bytes,2,rep,name=added,proto3" json:"added,omitempty"`
	Removed              []*storage.NetworkBaselineConnectionProperties `protobuf:"bytes,3,rep,name=removed,proto3" json:"removed,omitempty"`
	Unchanged            []*storage.NetworkBaselineConnectionProperties `protobuf:"bytes,4,rep,name=unchanged,proto3" json:"unchanged,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                       `json:"-"`
	XXX_unrecognized     []byte                                         `json:"-"`
	XXX_sizecache        int32                                          `json:"-"`
}

func (m *GetDiffFlowsReconciledFlow) Reset()         { *m = GetDiffFlowsReconciledFlow{} }
func (m *GetDiffFlowsReconciledFlow) String() string { return proto.CompactTextString(m) }
func (*GetDiffFlowsReconciledFlow) ProtoMessage()    {}
func (*GetDiffFlowsReconciledFlow) Descriptor() ([]byte, []int) {
	return fileDescriptor_725659a65cce3ede, []int{21}
}
func (m *GetDiffFlowsReconciledFlow) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetDiffFlowsReconciledFlow) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetDiffFlowsReconciledFlow.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetDiffFlowsReconciledFlow) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDiffFlowsReconciledFlow.Merge(m, src)
}
func (m *GetDiffFlowsReconciledFlow) XXX_Size() int {
	return m.Size()
}
func (m *GetDiffFlowsReconciledFlow) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDiffFlowsReconciledFlow.DiscardUnknown(m)
}

var xxx_messageInfo_GetDiffFlowsReconciledFlow proto.InternalMessageInfo

func (m *GetDiffFlowsReconciledFlow) GetEntity() *storage.NetworkEntityInfo {
	if m != nil {
		return m.Entity
	}
	return nil
}

func (m *GetDiffFlowsReconciledFlow) GetAdded() []*storage.NetworkBaselineConnectionProperties {
	if m != nil {
		return m.Added
	}
	return nil
}

func (m *GetDiffFlowsReconciledFlow) GetRemoved() []*storage.NetworkBaselineConnectionProperties {
	if m != nil {
		return m.Removed
	}
	return nil
}

func (m *GetDiffFlowsReconciledFlow) GetUnchanged() []*storage.NetworkBaselineConnectionProperties {
	if m != nil {
		return m.Unchanged
	}
	return nil
}

func (m *GetDiffFlowsReconciledFlow) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetDiffFlowsReconciledFlow) Clone() *GetDiffFlowsReconciledFlow {
	if m == nil {
		return nil
	}
	cloned := new(GetDiffFlowsReconciledFlow)
	*cloned = *m

	cloned.Entity = m.Entity.Clone()
	if m.Added != nil {
		cloned.Added = make([]*storage.NetworkBaselineConnectionProperties, len(m.Added))
		for idx, v := range m.Added {
			cloned.Added[idx] = v.Clone()
		}
	}
	if m.Removed != nil {
		cloned.Removed = make([]*storage.NetworkBaselineConnectionProperties, len(m.Removed))
		for idx, v := range m.Removed {
			cloned.Removed[idx] = v.Clone()
		}
	}
	if m.Unchanged != nil {
		cloned.Unchanged = make([]*storage.NetworkBaselineConnectionProperties, len(m.Unchanged))
		for idx, v := range m.Unchanged {
			cloned.Unchanged[idx] = v.Clone()
		}
	}
	return cloned
}

type GetDiffFlowsGroupedFlow struct {
	Entity               *storage.NetworkEntityInfo                     `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	Properties           []*storage.NetworkBaselineConnectionProperties `protobuf:"bytes,2,rep,name=properties,proto3" json:"properties,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                       `json:"-"`
	XXX_unrecognized     []byte                                         `json:"-"`
	XXX_sizecache        int32                                          `json:"-"`
}

func (m *GetDiffFlowsGroupedFlow) Reset()         { *m = GetDiffFlowsGroupedFlow{} }
func (m *GetDiffFlowsGroupedFlow) String() string { return proto.CompactTextString(m) }
func (*GetDiffFlowsGroupedFlow) ProtoMessage()    {}
func (*GetDiffFlowsGroupedFlow) Descriptor() ([]byte, []int) {
	return fileDescriptor_725659a65cce3ede, []int{22}
}
func (m *GetDiffFlowsGroupedFlow) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetDiffFlowsGroupedFlow) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetDiffFlowsGroupedFlow.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetDiffFlowsGroupedFlow) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDiffFlowsGroupedFlow.Merge(m, src)
}
func (m *GetDiffFlowsGroupedFlow) XXX_Size() int {
	return m.Size()
}
func (m *GetDiffFlowsGroupedFlow) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDiffFlowsGroupedFlow.DiscardUnknown(m)
}

var xxx_messageInfo_GetDiffFlowsGroupedFlow proto.InternalMessageInfo

func (m *GetDiffFlowsGroupedFlow) GetEntity() *storage.NetworkEntityInfo {
	if m != nil {
		return m.Entity
	}
	return nil
}

func (m *GetDiffFlowsGroupedFlow) GetProperties() []*storage.NetworkBaselineConnectionProperties {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *GetDiffFlowsGroupedFlow) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetDiffFlowsGroupedFlow) Clone() *GetDiffFlowsGroupedFlow {
	if m == nil {
		return nil
	}
	cloned := new(GetDiffFlowsGroupedFlow)
	*cloned = *m

	cloned.Entity = m.Entity.Clone()
	if m.Properties != nil {
		cloned.Properties = make([]*storage.NetworkBaselineConnectionProperties, len(m.Properties))
		for idx, v := range m.Properties {
			cloned.Properties[idx] = v.Clone()
		}
	}
	return cloned
}

type GetDiffFlowsResponse struct {
	Added                []*GetDiffFlowsGroupedFlow    `protobuf:"bytes,1,rep,name=added,proto3" json:"added,omitempty"`
	Removed              []*GetDiffFlowsGroupedFlow    `protobuf:"bytes,2,rep,name=removed,proto3" json:"removed,omitempty"`
	Reconciled           []*GetDiffFlowsReconciledFlow `protobuf:"bytes,3,rep,name=reconciled,proto3" json:"reconciled,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *GetDiffFlowsResponse) Reset()         { *m = GetDiffFlowsResponse{} }
func (m *GetDiffFlowsResponse) String() string { return proto.CompactTextString(m) }
func (*GetDiffFlowsResponse) ProtoMessage()    {}
func (*GetDiffFlowsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_725659a65cce3ede, []int{23}
}
func (m *GetDiffFlowsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetDiffFlowsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetDiffFlowsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetDiffFlowsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDiffFlowsResponse.Merge(m, src)
}
func (m *GetDiffFlowsResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetDiffFlowsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDiffFlowsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetDiffFlowsResponse proto.InternalMessageInfo

func (m *GetDiffFlowsResponse) GetAdded() []*GetDiffFlowsGroupedFlow {
	if m != nil {
		return m.Added
	}
	return nil
}

func (m *GetDiffFlowsResponse) GetRemoved() []*GetDiffFlowsGroupedFlow {
	if m != nil {
		return m.Removed
	}
	return nil
}

func (m *GetDiffFlowsResponse) GetReconciled() []*GetDiffFlowsReconciledFlow {
	if m != nil {
		return m.Reconciled
	}
	return nil
}

func (m *GetDiffFlowsResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetDiffFlowsResponse) Clone() *GetDiffFlowsResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetDiffFlowsResponse)
	*cloned = *m

	if m.Added != nil {
		cloned.Added = make([]*GetDiffFlowsGroupedFlow, len(m.Added))
		for idx, v := range m.Added {
			cloned.Added[idx] = v.Clone()
		}
	}
	if m.Removed != nil {
		cloned.Removed = make([]*GetDiffFlowsGroupedFlow, len(m.Removed))
		for idx, v := range m.Removed {
			cloned.Removed[idx] = v.Clone()
		}
	}
	if m.Reconciled != nil {
		cloned.Reconciled = make([]*GetDiffFlowsReconciledFlow, len(m.Reconciled))
		for idx, v := range m.Reconciled {
			cloned.Reconciled[idx] = v.Clone()
		}
	}
	return cloned
}

func init() {
	proto.RegisterEnum("v1.NetworkPolicyInSimulation_Status", NetworkPolicyInSimulation_Status_name, NetworkPolicyInSimulation_Status_value)
	proto.RegisterEnum("v1.GenerateNetworkPoliciesRequest_DeleteExistingPoliciesMode", GenerateNetworkPoliciesRequest_DeleteExistingPoliciesMode_name, GenerateNetworkPoliciesRequest_DeleteExistingPoliciesMode_value)
	proto.RegisterType((*GetNetworkPoliciesRequest)(nil), "v1.GetNetworkPoliciesRequest")
	proto.RegisterType((*NetworkPoliciesResponse)(nil), "v1.NetworkPoliciesResponse")
	proto.RegisterType((*SendNetworkPolicyYamlRequest)(nil), "v1.SendNetworkPolicyYamlRequest")
	proto.RegisterType((*GetNetworkGraphRequest)(nil), "v1.GetNetworkGraphRequest")
	proto.RegisterType((*SimulateNetworkGraphRequest)(nil), "v1.SimulateNetworkGraphRequest")
	proto.RegisterType((*ApplyNetworkPolicyYamlRequest)(nil), "v1.ApplyNetworkPolicyYamlRequest")
	proto.RegisterType((*GetUndoModificationRequest)(nil), "v1.GetUndoModificationRequest")
	proto.RegisterType((*GetUndoModificationResponse)(nil), "v1.GetUndoModificationResponse")
	proto.RegisterType((*NetworkPolicyInSimulation)(nil), "v1.NetworkPolicyInSimulation")
	proto.RegisterType((*NetworkNodeDiff)(nil), "v1.NetworkNodeDiff")
	proto.RegisterMapType((map[int32]*NetworkEdgePropertiesBundle)(nil), "v1.NetworkNodeDiff.DEPRECATEDOutEdgesEntry")
	proto.RegisterMapType((map[string]*NetworkEdgePropertiesBundle)(nil), "v1.NetworkNodeDiff.OutEdgesEntry")
	proto.RegisterType((*NetworkGraphDiff)(nil), "v1.NetworkGraphDiff")
	proto.RegisterMapType((map[int32]*NetworkNodeDiff)(nil), "v1.NetworkGraphDiff.DEPRECATEDNodeDiffsEntry")
	proto.RegisterMapType((map[string]*NetworkNodeDiff)(nil), "v1.NetworkGraphDiff.NodeDiffsEntry")
	proto.RegisterType((*SimulateNetworkGraphResponse)(nil), "v1.SimulateNetworkGraphResponse")
	proto.RegisterType((*GetNetworkGraphEpochRequest)(nil), "v1.GetNetworkGraphEpochRequest")
	proto.RegisterType((*NetworkGraphEpoch)(nil), "v1.NetworkGraphEpoch")
	proto.RegisterType((*GenerateNetworkPoliciesRequest)(nil), "v1.GenerateNetworkPoliciesRequest")
	proto.RegisterType((*GenerateNetworkPoliciesResponse)(nil), "v1.GenerateNetworkPoliciesResponse")
	proto.RegisterType((*GetBaselineGeneratedPolicyForDeploymentRequest)(nil), "v1.GetBaselineGeneratedPolicyForDeploymentRequest")
	proto.RegisterType((*GetBaselineGeneratedPolicyForDeploymentResponse)(nil), "v1.GetBaselineGeneratedPolicyForDeploymentResponse")
	proto.RegisterType((*GetAllowedPeersFromCurrentPolicyForDeploymentResponse)(nil), "v1.GetAllowedPeersFromCurrentPolicyForDeploymentResponse")
	proto.RegisterType((*ApplyNetworkPolicyYamlForDeploymentRequest)(nil), "v1.ApplyNetworkPolicyYamlForDeploymentRequest")
	proto.RegisterType((*GetUndoModificationForDeploymentResponse)(nil), "v1.GetUndoModificationForDeploymentResponse")
	proto.RegisterType((*GetDiffFlowsReconciledFlow)(nil), "v1.GetDiffFlowsReconciledFlow")
	proto.RegisterType((*GetDiffFlowsGroupedFlow)(nil), "v1.GetDiffFlowsGroupedFlow")
	proto.RegisterType((*GetDiffFlowsResponse)(nil), "v1.GetDiffFlowsResponse")
}

func init() {
	proto.RegisterFile("api/v1/network_policy_service.proto", fileDescriptor_725659a65cce3ede)
}

var fileDescriptor_725659a65cce3ede = []byte{
	// 2048 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x58, 0xcd, 0x6f, 0xdb, 0xc8,
	0x15, 0x0f, 0xe5, 0xd8, 0x89, 0x9e, 0xbf, 0x94, 0xb1, 0xb3, 0xd1, 0xd2, 0xf1, 0x47, 0xe8, 0x6e,
	0xd7, 0x71, 0xd6, 0x54, 0xec, 0xd4, 0x6d, 0x93, 0xa6, 0xdb, 0x95, 0x22, 0x5a, 0xab, 0xad, 0x23,
	0x7b, 0xe9, 0xa4, 0xed, 0xb6, 0x8b, 0x0a, 0x8c, 0x38, 0xd2, 0x12, 0xa1, 0x66, 0x18, 0x92, 0xb2,
	0x23, 0x04, 0x01, 0x8a, 0x02, 0xed, 0x69, 0x6f, 0xdd, 0x05, 0xb6, 0xed, 0xa1, 0xe8, 0x6d, 0x81,
	0xfe, 0x13, 0x3d, 0xf6, 0x58, 0xa0, 0xc7, 0x5e, 0x8a, 0xb4, 0xd7, 0x02, 0xbd, 0x17, 0x28, 0x0a,
	0x0e, 0x87, 0x12, 0x29, 0x0d, 0x15, 0xd9, 0xeb, 0xbd, 0x91, 0xf3, 0x3e, 0xe7, 0xf7, 0x1e, 0xdf,
	0xfc, 0x38, 0xb0, 0x6e, 0x38, 0x56, 0xe1, 0x78, 0xbb, 0x40, 0xb0, 0x7f, 0x42, 0xdd, 0xa7, 0x75,
	0x87, 0xda, 0x56, 0xa3, 0x5b, 0xf7, 0xb0, 0x7b, 0x6c, 0x35, 0xb0, 0xea, 0xb8, 0xd4, 0xa7, 0x28,
	0x73, 0xbc, 0x2d, 0x5f, 0x6f, 0x51, 0xda, 0xb2, 0x71, 0x21, 0xd0, 0x37, 0x08, 0xa1, 0xbe, 0xe1,
	0x5b, 0x94, 0x78, 0xa1, 0x86, 0xbc, 0xca, 0xa5, 0xec, 0xed, 0x49, 0xa7, 0x59, 0xf0, 0xad, 0x36,
	0xf6, 0x7c, 0xa3, 0xed, 0x70, 0x85, 0xb7, 0x06, 0xe2, 0x3c, 0x31, 0x3c, 0x6c, 0x5b, 0x04, 0x27,
	0x23, 0xc9, 0xca, 0x80, 0x5a, 0xcb, 0x35, 0x9c, 0x4f, 0x06, 0x74, 0x16, 0xb8, 0x4e, 0x83, 0xb6,
	0xdb, 0x94, 0xf0, 0x45, 0xc4, 0x17, 0x71, 0xdb, 0xf1, 0xbb, 0x7c, 0x6d, 0xc5, 0xf3, 0xa9, 0x6b,
	0xb4, 0xf0, 0x50, 0x50, 0x2e, 0x97, 0x07, 0xe5, 0x4d, 0x9b, 0x9e, 0x70, 0xd9, 0xf5, 0x41, 0x59,
	0x08, 0x4c, 0x28, 0x55, 0x30, 0xbc, 0x59, 0xc1, 0x7e, 0x2d, 0x14, 0x1d, 0x06, 0x12, 0x0b, 0x7b,
	0x3a, 0x7e, 0xd6, 0xc1, 0x9e, 0x8f, 0x96, 0x01, 0x1a, 0x76, 0xc7, 0xf3, 0xb1, 0x5b, 0xb7, 0xcc,
	0xbc, 0xb4, 0x26, 0x6d, 0x64, 0xf5, 0x2c, 0x5f, 0xa9, 0x9a, 0xe8, 0x26, 0xe4, 0x4c, 0xec, 0xd8,
	0xb4, 0xdb, 0xc6, 0xc4, 0xaf, 0x3f, 0xeb, 0x60, 0xb7, 0x9b, 0xcf, 0x30, 0xa5, 0xf9, 0xfe, 0xfa,
	0x87, 0xc1, 0xb2, 0xf2, 0x31, 0x5c, 0x1b, 0x8a, 0xe1, 0x39, 0x94, 0x78, 0x18, 0x15, 0x21, 0x97,
	0xc8, 0xcc, 0xc2, 0x5e, 0x5e, 0x5a, 0x9b, 0xd8, 0x98, 0xde, 0x79, 0x43, 0xe5, 0xa9, 0xab, 0x71,
	0xdb, 0xae, 0x3e, 0x4f, 0x92, 0xae, 0x94, 0x2f, 0x25, 0xb8, 0x7e, 0x84, 0x89, 0x99, 0x50, 0xfb,
	0xc8, 0x68, 0xdb, 0x63, 0x6e, 0xe4, 0x06, 0xcc, 0x10, 0xea, 0x5b, 0x4d, 0x8b, 0xc9, 0xbd, 0x7c,
	0x66, 0x6d, 0x62, 0x23, 0xab, 0x4f, 0x47, 0x6b, 0x55, 0xd3, 0x43, 0x7b, 0x30, 0xd3, 0xa6, 0xa6,
	0xd5, 0xb4, 0x1a, 0xac, 0x5b, 0xf2, 0x13, 0x6b, 0xd2, 0xc6, 0xf4, 0x8e, 0x22, 0xce, 0xf0, 0x61,
	0x4c, 0x53, 0x4f, 0xd8, 0x29, 0x7f, 0x90, 0xe0, 0x8d, 0x3e, 0xe0, 0x95, 0xa0, 0x29, 0xc6, 0x4c,
	0x72, 0x11, 0x26, 0xe3, 0x10, 0x87, 0x2f, 0x68, 0x1d, 0x66, 0x2d, 0xd2, 0xb0, 0x3b, 0x26, 0xae,
	0x3b, 0xd4, 0xf5, 0x3d, 0x96, 0xd8, 0x65, 0x7d, 0x86, 0x2f, 0x1e, 0x06, 0x6b, 0xe8, 0x16, 0x4c,
	0x7a, 0x0d, 0xea, 0xe0, 0xfc, 0x45, 0x96, 0xf5, 0x55, 0xf5, 0x78, 0x5b, 0x8d, 0x67, 0x70, 0x14,
	0x08, 0xf5, 0x50, 0x47, 0xf9, 0x22, 0x03, 0x4b, 0x47, 0x56, 0xbb, 0x63, 0x1b, 0x3e, 0x3e, 0xb7,
	0x34, 0xcf, 0x09, 0xbe, 0xe1, 0xed, 0x5e, 0x14, 0x6c, 0x77, 0x13, 0xae, 0x44, 0x4a, 0x84, 0x9a,
	0xb8, 0x6e, 0x5a, 0xcd, 0x66, 0x7e, 0x92, 0x29, 0xce, 0x73, 0x41, 0x8d, 0x9a, 0xb8, 0x6c, 0x35,
	0x9b, 0x7d, 0x68, 0xa6, 0xc6, 0x80, 0xe6, 0xd7, 0x12, 0x2c, 0x17, 0x1d, 0xc7, 0xee, 0x9e, 0xb5,
	0xd1, 0x06, 0x61, 0xc8, 0x9c, 0xb1, 0x8b, 0xbe, 0x07, 0x72, 0x05, 0xfb, 0x8f, 0x89, 0x49, 0x13,
	0x4a, 0x63, 0x25, 0xa1, 0x3c, 0x85, 0x25, 0xa1, 0x31, 0xff, 0x1e, 0xf7, 0x61, 0xba, 0x43, 0x4c,
	0x5a, 0x77, 0x71, 0x83, 0xba, 0xa1, 0xf9, 0xf4, 0xce, 0x2d, 0x71, 0x8a, 0x01, 0x18, 0xdc, 0x3e,
	0xf0, 0xa7, 0x33, 0x13, 0x1d, 0x3a, 0xbd, 0x67, 0xe5, 0xd3, 0x0c, 0xbc, 0x99, 0x30, 0xa9, 0x12,
	0xde, 0x5c, 0x41, 0x39, 0x55, 0x98, 0x0a, 0xa7, 0x11, 0x0f, 0x93, 0xf6, 0xc5, 0x73, 0x2d, 0x74,
	0x1f, 0xa6, 0x3c, 0xdf, 0xf0, 0x3b, 0x1e, 0x43, 0x6e, 0x6e, 0xe7, 0x1b, 0xb1, 0x72, 0x0d, 0xbb,
	0x57, 0x8f, 0x98, 0xae, 0xce, 0x6d, 0xd0, 0x2e, 0x00, 0xb5, 0x4d, 0x3e, 0xff, 0x78, 0x0b, 0xa6,
	0x45, 0xcc, 0x52, 0xdb, 0x0c, 0x1f, 0x95, 0x0f, 0x60, 0x2a, 0x74, 0x84, 0xa6, 0xe1, 0x52, 0xb5,
	0xf6, 0xa3, 0xe2, 0x7e, 0xb5, 0x9c, 0xbb, 0x80, 0x66, 0x21, 0xfb, 0xb8, 0xf6, 0xe0, 0xfd, 0x62,
	0xad, 0xa2, 0x95, 0x73, 0x12, 0x9a, 0x81, 0xcb, 0x0f, 0x0f, 0xca, 0xd5, 0xbd, 0xaa, 0x56, 0xce,
	0x65, 0x50, 0x16, 0x26, 0x8b, 0xe5, 0xb2, 0x56, 0xce, 0x4d, 0x04, 0x46, 0x65, 0x6d, 0x5f, 0x7b,
	0xa4, 0x95, 0x73, 0x17, 0x95, 0xff, 0x4e, 0xc0, 0x3c, 0x0f, 0xd4, 0x6b, 0xc1, 0x65, 0x00, 0x7e,
	0x56, 0x05, 0xb3, 0x47, 0x62, 0xb3, 0x27, 0x1b, 0xae, 0x04, 0x93, 0xc7, 0x80, 0xc5, 0xb2, 0x76,
	0xa8, 0x6b, 0x0f, 0x8a, 0x8f, 0xb4, 0x72, 0x9d, 0x76, 0xfc, 0x3a, 0x36, 0x5b, 0x38, 0x1c, 0x52,
	0x41, 0x61, 0xfa, 0x08, 0x44, 0x1e, 0xd5, 0xbe, 0xfe, 0x41, 0xc7, 0xd7, 0x02, 0x6d, 0x8d, 0xf8,
	0x6e, 0xb7, 0x94, 0xc9, 0x4b, 0x3a, 0x1a, 0x16, 0xa2, 0x77, 0x21, 0xdb, 0xf7, 0x3b, 0xc9, 0xfc,
	0xde, 0x10, 0xf9, 0x4d, 0x78, 0xd3, 0x2f, 0xd3, 0xc8, 0xfe, 0x36, 0x2c, 0x12, 0x4a, 0xea, 0x96,
	0x47, 0x83, 0xa1, 0x61, 0xd6, 0x2d, 0xd2, 0x72, 0xb1, 0x17, 0xcd, 0x22, 0x44, 0x28, 0xa9, 0x72,
	0x51, 0x35, 0x94, 0x20, 0x15, 0x16, 0x12, 0x16, 0x38, 0x34, 0x08, 0xbf, 0xe6, 0x2b, 0x31, 0x03,
	0x8d, 0x09, 0xe4, 0x26, 0x5c, 0x4b, 0xd9, 0x14, 0xca, 0xc1, 0xc4, 0x53, 0x1c, 0x36, 0xd0, 0xa4,
	0x1e, 0x3c, 0xa2, 0x5d, 0x98, 0x3c, 0x36, 0xec, 0x0e, 0xe6, 0x9f, 0xd7, 0x6a, 0x6c, 0x2b, 0x81,
	0xdd, 0xa1, 0x4b, 0x1d, 0xec, 0xfa, 0x16, 0xf6, 0x4a, 0x1d, 0x62, 0xda, 0x58, 0x0f, 0xb5, 0xef,
	0x65, 0xbe, 0x2b, 0xc9, 0x1f, 0xc3, 0x6c, 0xaa, 0xf7, 0xec, 0x57, 0xf5, 0xae, 0xfc, 0x3b, 0x03,
	0xb9, 0xf8, 0x70, 0x61, 0xe5, 0xc7, 0x70, 0x35, 0x56, 0xdf, 0xde, 0xc0, 0x8a, 0x0e, 0xc1, 0xad,
	0xc1, 0x89, 0x34, 0x50, 0xe1, 0xa8, 0x38, 0xb1, 0x12, 0x2f, 0x08, 0xa4, 0xa8, 0x04, 0x10, 0xf3,
	0x1d, 0x36, 0xcf, 0xba, 0xd0, 0x77, 0xd2, 0xa3, 0x9e, 0x25, 0xd1, 0xbb, 0xfc, 0x33, 0xc8, 0xa7,
	0x05, 0x16, 0x94, 0xe1, 0x66, 0x12, 0xa8, 0x05, 0x41, 0x47, 0xc5, 0xa1, 0xff, 0x10, 0xe6, 0xd2,
	0x5d, 0x66, 0xcf, 0xe2, 0x52, 0xf9, 0x4f, 0xc0, 0x0b, 0x84, 0x47, 0x19, 0x9f, 0x75, 0x77, 0x61,
	0xde, 0xe3, 0x72, 0x33, 0x64, 0x68, 0x7c, 0x10, 0xe5, 0x06, 0x91, 0xd1, 0xe7, 0x7a, 0x8a, 0xec,
	0x1d, 0xdd, 0x85, 0xcb, 0x3d, 0xba, 0x12, 0xa2, 0xb9, 0x3c, 0x72, 0x18, 0xe9, 0x3d, 0x75, 0xb4,
	0x09, 0x93, 0x86, 0x69, 0x62, 0x93, 0x8f, 0xa0, 0x45, 0x51, 0x15, 0xf4, 0x50, 0x05, 0xa9, 0x70,
	0xc9, 0xc5, 0x6d, 0x7a, 0x8c, 0x4d, 0x7e, 0x78, 0x8b, 0xb5, 0x23, 0x25, 0xe5, 0x3e, 0x1b, 0xee,
	0x71, 0xb9, 0xe6, 0xd0, 0xc6, 0x98, 0x87, 0xb7, 0x72, 0x13, 0xae, 0x0c, 0x99, 0x06, 0x27, 0x3a,
	0x0e, 0x1e, 0x98, 0xfa, 0xac, 0x1e, 0xbe, 0x28, 0xff, 0xcb, 0xc0, 0x4a, 0x05, 0x13, 0xec, 0xf6,
	0xb1, 0x3d, 0x25, 0x7d, 0x14, 0x33, 0x85, 0x26, 0xcc, 0x9b, 0xd8, 0xc6, 0x3e, 0xae, 0xe3, 0xe7,
	0x96, 0xe7, 0x5b, 0xa4, 0xc5, 0x60, 0x9a, 0xdb, 0xf9, 0x7e, 0xb0, 0xf1, 0xd1, 0x11, 0xd5, 0x32,
	0xb3, 0xd4, 0xb8, 0x61, 0x24, 0x7d, 0x48, 0x4d, 0xac, 0xcf, 0x99, 0x09, 0x19, 0x7a, 0x1f, 0x50,
	0x44, 0x3b, 0x4d, 0xc3, 0x37, 0xea, 0x9e, 0x45, 0x1a, 0x11, 0x41, 0x92, 0xd5, 0xf0, 0x27, 0x40,
	0x8d, 0x7e, 0x02, 0xd4, 0x47, 0xd1, 0x4f, 0x80, 0x1e, 0x91, 0xd5, 0xb2, 0xe1, 0x1b, 0x47, 0x81,
	0xcd, 0x30, 0x27, 0x99, 0x1c, 0xe6, 0x24, 0xca, 0x21, 0xc8, 0xe9, 0xc9, 0x05, 0x67, 0xc4, 0xe3,
	0xda, 0x0f, 0x6b, 0x07, 0x3f, 0xae, 0xe5, 0x2e, 0xa0, 0xcb, 0x70, 0xb1, 0x76, 0x50, 0xd3, 0x72,
	0x12, 0x42, 0x30, 0x57, 0xd1, 0x6a, 0x9a, 0xce, 0x26, 0xc3, 0x41, 0x6d, 0xff, 0xa3, 0x5c, 0x06,
	0x5d, 0x82, 0x89, 0xe2, 0xfe, 0x7e, 0x6e, 0x42, 0xb1, 0x60, 0x35, 0x15, 0x0d, 0xde, 0xde, 0x83,
	0x74, 0x43, 0x3a, 0x23, 0xdd, 0x78, 0x25, 0x81, 0x5a, 0xc1, 0x7e, 0x89, 0xff, 0x74, 0x44, 0x61,
	0xf9, 0x01, 0xb9, 0x47, 0xdd, 0x72, 0x8f, 0xee, 0x47, 0xb5, 0x5f, 0x87, 0xd9, 0xd8, 0xbf, 0x41,
	0xaf, 0xfc, 0x33, 0xfd, 0xc5, 0xaa, 0x29, 0xaa, 0x75, 0xe6, 0xeb, 0xa8, 0xf5, 0x38, 0x24, 0x59,
	0xe9, 0x42, 0x61, 0xec, 0x3d, 0x9e, 0x33, 0xbe, 0x2f, 0x60, 0xb7, 0x82, 0xfd, 0xa2, 0x6d, 0xd3,
	0x13, 0x6c, 0x1e, 0x62, 0xec, 0x7a, 0x7b, 0x2e, 0x6d, 0x3f, 0xe8, 0xb8, 0x2e, 0x26, 0xfe, 0xa8,
	0x04, 0x4a, 0x30, 0x6b, 0x84, 0x56, 0x75, 0x27, 0x30, 0xe3, 0x67, 0x46, 0x7c, 0x12, 0x45, 0x1b,
	0x0a, 0x29, 0x4c, 0xe0, 0x5c, 0x9f, 0x31, 0x62, 0x91, 0x94, 0xdf, 0x4a, 0xb0, 0x29, 0x26, 0xb5,
	0x67, 0x2f, 0xec, 0x79, 0xf1, 0xdc, 0xe7, 0xb0, 0x21, 0xa0, 0xaa, 0x62, 0x2c, 0xce, 0x97, 0xb7,
	0x7e, 0x99, 0x61, 0x14, 0x3b, 0x18, 0xae, 0x7b, 0x36, 0x3d, 0xf1, 0x82, 0x65, 0xd2, 0xb0, 0x6c,
	0x6c, 0x06, 0xaf, 0x68, 0x07, 0xa6, 0x30, 0xf1, 0x2d, 0x3f, 0x22, 0xae, 0xf2, 0x60, 0x1c, 0x8d,
	0x49, 0xab, 0xa4, 0x49, 0x75, 0xae, 0x89, 0x4a, 0xd1, 0xd8, 0x0f, 0x8f, 0x8b, 0x77, 0x06, 0x4d,
	0xa2, 0x4a, 0x3d, 0xa0, 0x84, 0xe0, 0x46, 0x90, 0x5b, 0x9f, 0x4b, 0x44, 0xc7, 0xc1, 0x5e, 0xff,
	0x38, 0x98, 0x38, 0x83, 0x97, 0xc8, 0x18, 0x7d, 0x00, 0xd9, 0x0e, 0x69, 0x7c, 0x62, 0x90, 0x16,
	0x3b, 0x58, 0x4e, 0xef, 0xa9, 0x6f, 0xae, 0xfc, 0x5e, 0x82, 0x6b, 0x71, 0xa8, 0x2a, 0x2e, 0xed,
	0x38, 0x5f, 0x01, 0xa7, 0x7d, 0x00, 0xa7, 0x17, 0xe8, 0x4c, 0x60, 0xc5, 0xec, 0x95, 0x3f, 0x4b,
	0xb0, 0x98, 0x2c, 0x24, 0xef, 0x97, 0xed, 0xa8, 0x1c, 0xe1, 0x37, 0xb3, 0x14, 0x8e, 0x1c, 0xe1,
	0x36, 0x22, 0xf4, 0x77, 0xfb, 0xe8, 0x67, 0x5e, 0x6f, 0xd4, 0x03, 0xfb, 0x5d, 0x00, 0xb7, 0xd7,
	0x3e, 0xbc, 0x6e, 0x2b, 0x83, 0x96, 0xc9, 0x06, 0xd3, 0x63, 0x16, 0x3b, 0x9f, 0x5f, 0x81, 0xc5,
	0x44, 0xfb, 0x1e, 0x85, 0xb7, 0x48, 0xe8, 0xe7, 0x90, 0x1b, 0xb8, 0xbc, 0xe9, 0x22, 0xc6, 0x5c,
	0x74, 0xec, 0xd1, 0x8e, 0xdb, 0xc0, 0xa5, 0x6e, 0xb5, 0x2c, 0xa7, 0xfc, 0xe2, 0x28, 0x6b, 0xbf,
	0xfc, 0xdb, 0xbf, 0x7e, 0x93, 0x91, 0x51, 0x3e, 0x76, 0x4d, 0x15, 0x71, 0x94, 0xc2, 0x0b, 0xcb,
	0x7c, 0x89, 0xda, 0x80, 0x86, 0x2f, 0x87, 0xd0, 0x32, 0x4f, 0x5d, 0x3c, 0x97, 0xe5, 0xa5, 0x41,
	0x1a, 0x14, 0x3b, 0x91, 0x94, 0x25, 0x16, 0xf3, 0x2a, 0x5a, 0x10, 0xc4, 0x44, 0xcf, 0x60, 0x7e,
	0x80, 0xbb, 0x20, 0x39, 0x19, 0x2b, 0x7e, 0x11, 0x21, 0x0f, 0x71, 0x34, 0xe5, 0x36, 0xf3, 0xbe,
	0x89, 0x36, 0x44, 0x3b, 0xe2, 0xc4, 0xa3, 0xf0, 0xa2, 0xcf, 0x49, 0x5e, 0xa2, 0x13, 0xd6, 0x1c,
	0xc3, 0x9c, 0x67, 0x55, 0x10, 0x37, 0x4e, 0xa4, 0xe4, 0xa1, 0x8b, 0x02, 0x26, 0x55, 0xde, 0x66,
	0x19, 0xdc, 0x40, 0xab, 0xa2, 0x0c, 0x18, 0xc1, 0x2c, 0x30, 0xfa, 0x84, 0x7e, 0x21, 0x01, 0x1a,
	0x9e, 0xba, 0x88, 0xfd, 0x76, 0x8d, 0xbc, 0x62, 0x90, 0xb3, 0x81, 0x8a, 0xd6, 0x76, 0xfc, 0xae,
	0x72, 0x9f, 0x45, 0xfb, 0xb6, 0xf2, 0x4d, 0x51, 0x34, 0x23, 0xf0, 0x92, 0xd8, 0xed, 0xbd, 0xe4,
	0x5d, 0xca, 0xaf, 0x24, 0x58, 0x10, 0x4c, 0x57, 0x14, 0xb5, 0x66, 0xca, 0xf5, 0x82, 0xbc, 0x9a,
	0x2a, 0xe7, 0x45, 0xde, 0x62, 0x69, 0xbd, 0x8d, 0xde, 0x12, 0xa5, 0x15, 0xcc, 0xd8, 0x64, 0x0d,
	0x7e, 0x27, 0xc1, 0xa2, 0x88, 0xa5, 0x87, 0x45, 0x18, 0x71, 0x15, 0x25, 0xaf, 0xa5, 0x2b, 0xf0,
	0x54, 0x7e, 0xc0, 0x52, 0xb9, 0xab, 0xdc, 0x14, 0xa5, 0x12, 0x31, 0xfa, 0x51, 0x20, 0x7d, 0x2a,
	0xc1, 0xd5, 0xe1, 0xab, 0xc5, 0xe2, 0xc3, 0x7d, 0x14, 0x06, 0x1f, 0x71, 0xeb, 0x18, 0xaf, 0xd4,
	0x1e, 0xcb, 0xe3, 0x3d, 0xe5, 0xf6, 0xd8, 0x79, 0x14, 0xd8, 0xed, 0x63, 0x77, 0x20, 0x9d, 0xcf,
	0xd9, 0xac, 0x15, 0xf2, 0x22, 0xa4, 0xbc, 0x9e, 0x34, 0xc9, 0xeb, 0x23, 0x75, 0x38, 0x68, 0xdb,
	0x2c, 0xd9, 0x5b, 0x48, 0x08, 0x5a, 0x8b, 0x1b, 0x27, 0x6b, 0xf8, 0xf7, 0x14, 0x86, 0x98, 0xc0,
	0x26, 0x71, 0x6e, 0xa3, 0x1d, 0xde, 0x46, 0xa7, 0x60, 0x95, 0xf2, 0x9d, 0x53, 0xd9, 0xf0, 0xed,
	0xbc, 0xc7, 0xb6, 0x73, 0x4f, 0xd9, 0x1d, 0xb9, 0x9d, 0xe8, 0x46, 0xbd, 0xf0, 0x22, 0x41, 0x6f,
	0x5e, 0xde, 0x93, 0x36, 0xd1, 0x9f, 0x24, 0xd8, 0x3a, 0x15, 0x41, 0x13, 0x4c, 0xe1, 0xbb, 0x3c,
	0xf5, 0xd3, 0xb3, 0xbc, 0xd1, 0xdf, 0x13, 0xe7, 0x72, 0x8c, 0xfe, 0x85, 0x53, 0xfb, 0x8f, 0x12,
	0xac, 0x8f, 0x41, 0xe8, 0x90, 0x9a, 0x3e, 0x6b, 0x84, 0xe0, 0xc7, 0xda, 0x39, 0xfa, 0xac, 0xbe,
	0x95, 0x3e, 0x78, 0xfa, 0x28, 0x8a, 0x10, 0xfd, 0x4c, 0x82, 0xb5, 0xd7, 0x31, 0x3b, 0x01, 0x88,
	0xef, 0xa4, 0x8c, 0x1e, 0x31, 0x6e, 0x23, 0x8f, 0x03, 0x36, 0x87, 0xe2, 0x49, 0x06, 0xd0, 0x7d,
	0x26, 0xc1, 0x76, 0xfc, 0x50, 0x2e, 0x61, 0xff, 0x04, 0x63, 0xc2, 0x49, 0x23, 0x31, 0xa3, 0xbe,
	0x7b, 0x5d, 0x9e, 0xf9, 0xe1, 0xd3, 0x9d, 0xe7, 0x74, 0x87, 0xe5, 0xb4, 0x85, 0x6e, 0x89, 0x72,
	0x8a, 0x7a, 0xb0, 0x41, 0xdb, 0x8e, 0xe1, 0x5a, 0x1e, 0x25, 0xbd, 0xb4, 0xb6, 0xe2, 0xde, 0x82,
	0xbe, 0x39, 0x2d, 0x74, 0xe9, 0x29, 0x7d, 0x87, 0xa5, 0xb4, 0x8d, 0x0a, 0x69, 0x30, 0xa5, 0xa4,
	0x55, 0x52, 0xff, 0xf2, 0x6a, 0x45, 0xfa, 0xeb, 0xab, 0x15, 0xe9, 0x1f, 0xaf, 0x56, 0xa4, 0x2f,
	0xfe, 0xb9, 0x72, 0x01, 0xf2, 0x16, 0x55, 0x3d, 0xdf, 0x68, 0x3c, 0x75, 0xe9, 0xf3, 0xf0, 0xe7,
	0x59, 0x35, 0x1c, 0x4b, 0x3d, 0xde, 0xfe, 0x69, 0xe6, 0x78, 0xfb, 0x27, 0x17, 0x9e, 0x4c, 0xb1,
	0xb5, 0x3b, 0xff, 0x0f, 0x00, 0x00, 0xff, 0xff, 0xe7, 0x18, 0x36, 0x8c, 0xac, 0x1b, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// NetworkPolicyServiceClient is the client API for NetworkPolicyService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConnInterface.NewStream.
type NetworkPolicyServiceClient interface {
	GetNetworkPolicy(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*storage.NetworkPolicy, error)
	GetNetworkPolicies(ctx context.Context, in *GetNetworkPoliciesRequest, opts ...grpc.CallOption) (*NetworkPoliciesResponse, error)
	GetNetworkGraph(ctx context.Context, in *GetNetworkGraphRequest, opts ...grpc.CallOption) (*NetworkGraph, error)
	GetNetworkGraphEpoch(ctx context.Context, in *GetNetworkGraphEpochRequest, opts ...grpc.CallOption) (*NetworkGraphEpoch, error)
	ApplyNetworkPolicy(ctx context.Context, in *ApplyNetworkPolicyYamlRequest, opts ...grpc.CallOption) (*Empty, error)
	GetUndoModification(ctx context.Context, in *GetUndoModificationRequest, opts ...grpc.CallOption) (*GetUndoModificationResponse, error)
	SimulateNetworkGraph(ctx context.Context, in *SimulateNetworkGraphRequest, opts ...grpc.CallOption) (*SimulateNetworkGraphResponse, error)
	SendNetworkPolicyYAML(ctx context.Context, in *SendNetworkPolicyYamlRequest, opts ...grpc.CallOption) (*Empty, error)
	GenerateNetworkPolicies(ctx context.Context, in *GenerateNetworkPoliciesRequest, opts ...grpc.CallOption) (*GenerateNetworkPoliciesResponse, error)
	GetBaselineGeneratedNetworkPolicyForDeployment(ctx context.Context, in *GetBaselineGeneratedPolicyForDeploymentRequest, opts ...grpc.CallOption) (*GetBaselineGeneratedPolicyForDeploymentResponse, error)
	GetAllowedPeersFromCurrentPolicyForDeployment(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*GetAllowedPeersFromCurrentPolicyForDeploymentResponse, error)
	ApplyNetworkPolicyYamlForDeployment(ctx context.Context, in *ApplyNetworkPolicyYamlForDeploymentRequest, opts ...grpc.CallOption) (*Empty, error)
	GetUndoModificationForDeployment(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*GetUndoModificationForDeploymentResponse, error)
	GetDiffFlowsBetweenPolicyAndBaselineForDeployment(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*GetDiffFlowsResponse, error)
	GetDiffFlowsFromUndoModificationForDeployment(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*GetDiffFlowsResponse, error)
}

type networkPolicyServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewNetworkPolicyServiceClient(cc grpc.ClientConnInterface) NetworkPolicyServiceClient {
	return &networkPolicyServiceClient{cc}
}

func (c *networkPolicyServiceClient) GetNetworkPolicy(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*storage.NetworkPolicy, error) {
	out := new(storage.NetworkPolicy)
	err := c.cc.Invoke(ctx, "/v1.NetworkPolicyService/GetNetworkPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkPolicyServiceClient) GetNetworkPolicies(ctx context.Context, in *GetNetworkPoliciesRequest, opts ...grpc.CallOption) (*NetworkPoliciesResponse, error) {
	out := new(NetworkPoliciesResponse)
	err := c.cc.Invoke(ctx, "/v1.NetworkPolicyService/GetNetworkPolicies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkPolicyServiceClient) GetNetworkGraph(ctx context.Context, in *GetNetworkGraphRequest, opts ...grpc.CallOption) (*NetworkGraph, error) {
	out := new(NetworkGraph)
	err := c.cc.Invoke(ctx, "/v1.NetworkPolicyService/GetNetworkGraph", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkPolicyServiceClient) GetNetworkGraphEpoch(ctx context.Context, in *GetNetworkGraphEpochRequest, opts ...grpc.CallOption) (*NetworkGraphEpoch, error) {
	out := new(NetworkGraphEpoch)
	err := c.cc.Invoke(ctx, "/v1.NetworkPolicyService/GetNetworkGraphEpoch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkPolicyServiceClient) ApplyNetworkPolicy(ctx context.Context, in *ApplyNetworkPolicyYamlRequest, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.NetworkPolicyService/ApplyNetworkPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkPolicyServiceClient) GetUndoModification(ctx context.Context, in *GetUndoModificationRequest, opts ...grpc.CallOption) (*GetUndoModificationResponse, error) {
	out := new(GetUndoModificationResponse)
	err := c.cc.Invoke(ctx, "/v1.NetworkPolicyService/GetUndoModification", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkPolicyServiceClient) SimulateNetworkGraph(ctx context.Context, in *SimulateNetworkGraphRequest, opts ...grpc.CallOption) (*SimulateNetworkGraphResponse, error) {
	out := new(SimulateNetworkGraphResponse)
	err := c.cc.Invoke(ctx, "/v1.NetworkPolicyService/SimulateNetworkGraph", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkPolicyServiceClient) SendNetworkPolicyYAML(ctx context.Context, in *SendNetworkPolicyYamlRequest, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.NetworkPolicyService/SendNetworkPolicyYAML", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkPolicyServiceClient) GenerateNetworkPolicies(ctx context.Context, in *GenerateNetworkPoliciesRequest, opts ...grpc.CallOption) (*GenerateNetworkPoliciesResponse, error) {
	out := new(GenerateNetworkPoliciesResponse)
	err := c.cc.Invoke(ctx, "/v1.NetworkPolicyService/GenerateNetworkPolicies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkPolicyServiceClient) GetBaselineGeneratedNetworkPolicyForDeployment(ctx context.Context, in *GetBaselineGeneratedPolicyForDeploymentRequest, opts ...grpc.CallOption) (*GetBaselineGeneratedPolicyForDeploymentResponse, error) {
	out := new(GetBaselineGeneratedPolicyForDeploymentResponse)
	err := c.cc.Invoke(ctx, "/v1.NetworkPolicyService/GetBaselineGeneratedNetworkPolicyForDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkPolicyServiceClient) GetAllowedPeersFromCurrentPolicyForDeployment(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*GetAllowedPeersFromCurrentPolicyForDeploymentResponse, error) {
	out := new(GetAllowedPeersFromCurrentPolicyForDeploymentResponse)
	err := c.cc.Invoke(ctx, "/v1.NetworkPolicyService/GetAllowedPeersFromCurrentPolicyForDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkPolicyServiceClient) ApplyNetworkPolicyYamlForDeployment(ctx context.Context, in *ApplyNetworkPolicyYamlForDeploymentRequest, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.NetworkPolicyService/ApplyNetworkPolicyYamlForDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkPolicyServiceClient) GetUndoModificationForDeployment(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*GetUndoModificationForDeploymentResponse, error) {
	out := new(GetUndoModificationForDeploymentResponse)
	err := c.cc.Invoke(ctx, "/v1.NetworkPolicyService/GetUndoModificationForDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkPolicyServiceClient) GetDiffFlowsBetweenPolicyAndBaselineForDeployment(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*GetDiffFlowsResponse, error) {
	out := new(GetDiffFlowsResponse)
	err := c.cc.Invoke(ctx, "/v1.NetworkPolicyService/GetDiffFlowsBetweenPolicyAndBaselineForDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkPolicyServiceClient) GetDiffFlowsFromUndoModificationForDeployment(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*GetDiffFlowsResponse, error) {
	out := new(GetDiffFlowsResponse)
	err := c.cc.Invoke(ctx, "/v1.NetworkPolicyService/GetDiffFlowsFromUndoModificationForDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// NetworkPolicyServiceServer is the server API for NetworkPolicyService service.
type NetworkPolicyServiceServer interface {
	GetNetworkPolicy(context.Context, *ResourceByID) (*storage.NetworkPolicy, error)
	GetNetworkPolicies(context.Context, *GetNetworkPoliciesRequest) (*NetworkPoliciesResponse, error)
	GetNetworkGraph(context.Context, *GetNetworkGraphRequest) (*NetworkGraph, error)
	GetNetworkGraphEpoch(context.Context, *GetNetworkGraphEpochRequest) (*NetworkGraphEpoch, error)
	ApplyNetworkPolicy(context.Context, *ApplyNetworkPolicyYamlRequest) (*Empty, error)
	GetUndoModification(context.Context, *GetUndoModificationRequest) (*GetUndoModificationResponse, error)
	SimulateNetworkGraph(context.Context, *SimulateNetworkGraphRequest) (*SimulateNetworkGraphResponse, error)
	SendNetworkPolicyYAML(context.Context, *SendNetworkPolicyYamlRequest) (*Empty, error)
	GenerateNetworkPolicies(context.Context, *GenerateNetworkPoliciesRequest) (*GenerateNetworkPoliciesResponse, error)
	GetBaselineGeneratedNetworkPolicyForDeployment(context.Context, *GetBaselineGeneratedPolicyForDeploymentRequest) (*GetBaselineGeneratedPolicyForDeploymentResponse, error)
	GetAllowedPeersFromCurrentPolicyForDeployment(context.Context, *ResourceByID) (*GetAllowedPeersFromCurrentPolicyForDeploymentResponse, error)
	ApplyNetworkPolicyYamlForDeployment(context.Context, *ApplyNetworkPolicyYamlForDeploymentRequest) (*Empty, error)
	GetUndoModificationForDeployment(context.Context, *ResourceByID) (*GetUndoModificationForDeploymentResponse, error)
	GetDiffFlowsBetweenPolicyAndBaselineForDeployment(context.Context, *ResourceByID) (*GetDiffFlowsResponse, error)
	GetDiffFlowsFromUndoModificationForDeployment(context.Context, *ResourceByID) (*GetDiffFlowsResponse, error)
}

// UnimplementedNetworkPolicyServiceServer can be embedded to have forward compatible implementations.
type UnimplementedNetworkPolicyServiceServer struct {
}

func (*UnimplementedNetworkPolicyServiceServer) GetNetworkPolicy(ctx context.Context, req *ResourceByID) (*storage.NetworkPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNetworkPolicy not implemented")
}
func (*UnimplementedNetworkPolicyServiceServer) GetNetworkPolicies(ctx context.Context, req *GetNetworkPoliciesRequest) (*NetworkPoliciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNetworkPolicies not implemented")
}
func (*UnimplementedNetworkPolicyServiceServer) GetNetworkGraph(ctx context.Context, req *GetNetworkGraphRequest) (*NetworkGraph, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNetworkGraph not implemented")
}
func (*UnimplementedNetworkPolicyServiceServer) GetNetworkGraphEpoch(ctx context.Context, req *GetNetworkGraphEpochRequest) (*NetworkGraphEpoch, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNetworkGraphEpoch not implemented")
}
func (*UnimplementedNetworkPolicyServiceServer) ApplyNetworkPolicy(ctx context.Context, req *ApplyNetworkPolicyYamlRequest) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ApplyNetworkPolicy not implemented")
}
func (*UnimplementedNetworkPolicyServiceServer) GetUndoModification(ctx context.Context, req *GetUndoModificationRequest) (*GetUndoModificationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetUndoModification not implemented")
}
func (*UnimplementedNetworkPolicyServiceServer) SimulateNetworkGraph(ctx context.Context, req *SimulateNetworkGraphRequest) (*SimulateNetworkGraphResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SimulateNetworkGraph not implemented")
}
func (*UnimplementedNetworkPolicyServiceServer) SendNetworkPolicyYAML(ctx context.Context, req *SendNetworkPolicyYamlRequest) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SendNetworkPolicyYAML not implemented")
}
func (*UnimplementedNetworkPolicyServiceServer) GenerateNetworkPolicies(ctx context.Context, req *GenerateNetworkPoliciesRequest) (*GenerateNetworkPoliciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateNetworkPolicies not implemented")
}
func (*UnimplementedNetworkPolicyServiceServer) GetBaselineGeneratedNetworkPolicyForDeployment(ctx context.Context, req *GetBaselineGeneratedPolicyForDeploymentRequest) (*GetBaselineGeneratedPolicyForDeploymentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBaselineGeneratedNetworkPolicyForDeployment not implemented")
}
func (*UnimplementedNetworkPolicyServiceServer) GetAllowedPeersFromCurrentPolicyForDeployment(ctx context.Context, req *ResourceByID) (*GetAllowedPeersFromCurrentPolicyForDeploymentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAllowedPeersFromCurrentPolicyForDeployment not implemented")
}
func (*UnimplementedNetworkPolicyServiceServer) ApplyNetworkPolicyYamlForDeployment(ctx context.Context, req *ApplyNetworkPolicyYamlForDeploymentRequest) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ApplyNetworkPolicyYamlForDeployment not implemented")
}
func (*UnimplementedNetworkPolicyServiceServer) GetUndoModificationForDeployment(ctx context.Context, req *ResourceByID) (*GetUndoModificationForDeploymentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetUndoModificationForDeployment not implemented")
}
func (*UnimplementedNetworkPolicyServiceServer) GetDiffFlowsBetweenPolicyAndBaselineForDeployment(ctx context.Context, req *ResourceByID) (*GetDiffFlowsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDiffFlowsBetweenPolicyAndBaselineForDeployment not implemented")
}
func (*UnimplementedNetworkPolicyServiceServer) GetDiffFlowsFromUndoModificationForDeployment(ctx context.Context, req *ResourceByID) (*GetDiffFlowsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDiffFlowsFromUndoModificationForDeployment not implemented")
}

func RegisterNetworkPolicyServiceServer(s *grpc.Server, srv NetworkPolicyServiceServer) {
	s.RegisterService(&_NetworkPolicyService_serviceDesc, srv)
}

func _NetworkPolicyService_GetNetworkPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkPolicyServiceServer).GetNetworkPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.NetworkPolicyService/GetNetworkPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkPolicyServiceServer).GetNetworkPolicy(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkPolicyService_GetNetworkPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNetworkPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkPolicyServiceServer).GetNetworkPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.NetworkPolicyService/GetNetworkPolicies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkPolicyServiceServer).GetNetworkPolicies(ctx, req.(*GetNetworkPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkPolicyService_GetNetworkGraph_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNetworkGraphRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkPolicyServiceServer).GetNetworkGraph(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.NetworkPolicyService/GetNetworkGraph",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkPolicyServiceServer).GetNetworkGraph(ctx, req.(*GetNetworkGraphRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkPolicyService_GetNetworkGraphEpoch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNetworkGraphEpochRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkPolicyServiceServer).GetNetworkGraphEpoch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.NetworkPolicyService/GetNetworkGraphEpoch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkPolicyServiceServer).GetNetworkGraphEpoch(ctx, req.(*GetNetworkGraphEpochRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkPolicyService_ApplyNetworkPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplyNetworkPolicyYamlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkPolicyServiceServer).ApplyNetworkPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.NetworkPolicyService/ApplyNetworkPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkPolicyServiceServer).ApplyNetworkPolicy(ctx, req.(*ApplyNetworkPolicyYamlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkPolicyService_GetUndoModification_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetUndoModificationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkPolicyServiceServer).GetUndoModification(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.NetworkPolicyService/GetUndoModification",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkPolicyServiceServer).GetUndoModification(ctx, req.(*GetUndoModificationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkPolicyService_SimulateNetworkGraph_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SimulateNetworkGraphRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkPolicyServiceServer).SimulateNetworkGraph(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.NetworkPolicyService/SimulateNetworkGraph",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkPolicyServiceServer).SimulateNetworkGraph(ctx, req.(*SimulateNetworkGraphRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkPolicyService_SendNetworkPolicyYAML_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SendNetworkPolicyYamlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkPolicyServiceServer).SendNetworkPolicyYAML(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.NetworkPolicyService/SendNetworkPolicyYAML",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkPolicyServiceServer).SendNetworkPolicyYAML(ctx, req.(*SendNetworkPolicyYamlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkPolicyService_GenerateNetworkPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateNetworkPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkPolicyServiceServer).GenerateNetworkPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.NetworkPolicyService/GenerateNetworkPolicies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkPolicyServiceServer).GenerateNetworkPolicies(ctx, req.(*GenerateNetworkPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkPolicyService_GetBaselineGeneratedNetworkPolicyForDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBaselineGeneratedPolicyForDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkPolicyServiceServer).GetBaselineGeneratedNetworkPolicyForDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.NetworkPolicyService/GetBaselineGeneratedNetworkPolicyForDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkPolicyServiceServer).GetBaselineGeneratedNetworkPolicyForDeployment(ctx, req.(*GetBaselineGeneratedPolicyForDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkPolicyService_GetAllowedPeersFromCurrentPolicyForDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkPolicyServiceServer).GetAllowedPeersFromCurrentPolicyForDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.NetworkPolicyService/GetAllowedPeersFromCurrentPolicyForDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkPolicyServiceServer).GetAllowedPeersFromCurrentPolicyForDeployment(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkPolicyService_ApplyNetworkPolicyYamlForDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplyNetworkPolicyYamlForDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkPolicyServiceServer).ApplyNetworkPolicyYamlForDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.NetworkPolicyService/ApplyNetworkPolicyYamlForDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkPolicyServiceServer).ApplyNetworkPolicyYamlForDeployment(ctx, req.(*ApplyNetworkPolicyYamlForDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkPolicyService_GetUndoModificationForDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkPolicyServiceServer).GetUndoModificationForDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.NetworkPolicyService/GetUndoModificationForDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkPolicyServiceServer).GetUndoModificationForDeployment(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkPolicyService_GetDiffFlowsBetweenPolicyAndBaselineForDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkPolicyServiceServer).GetDiffFlowsBetweenPolicyAndBaselineForDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.NetworkPolicyService/GetDiffFlowsBetweenPolicyAndBaselineForDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkPolicyServiceServer).GetDiffFlowsBetweenPolicyAndBaselineForDeployment(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkPolicyService_GetDiffFlowsFromUndoModificationForDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkPolicyServiceServer).GetDiffFlowsFromUndoModificationForDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.NetworkPolicyService/GetDiffFlowsFromUndoModificationForDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkPolicyServiceServer).GetDiffFlowsFromUndoModificationForDeployment(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

var _NetworkPolicyService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1.NetworkPolicyService",
	HandlerType: (*NetworkPolicyServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetNetworkPolicy",
			Handler:    _NetworkPolicyService_GetNetworkPolicy_Handler,
		},
		{
			MethodName: "GetNetworkPolicies",
			Handler:    _NetworkPolicyService_GetNetworkPolicies_Handler,
		},
		{
			MethodName: "GetNetworkGraph",
			Handler:    _NetworkPolicyService_GetNetworkGraph_Handler,
		},
		{
			MethodName: "GetNetworkGraphEpoch",
			Handler:    _NetworkPolicyService_GetNetworkGraphEpoch_Handler,
		},
		{
			MethodName: "ApplyNetworkPolicy",
			Handler:    _NetworkPolicyService_ApplyNetworkPolicy_Handler,
		},
		{
			MethodName: "GetUndoModification",
			Handler:    _NetworkPolicyService_GetUndoModification_Handler,
		},
		{
			MethodName: "SimulateNetworkGraph",
			Handler:    _NetworkPolicyService_SimulateNetworkGraph_Handler,
		},
		{
			MethodName: "SendNetworkPolicyYAML",
			Handler:    _NetworkPolicyService_SendNetworkPolicyYAML_Handler,
		},
		{
			MethodName: "GenerateNetworkPolicies",
			Handler:    _NetworkPolicyService_GenerateNetworkPolicies_Handler,
		},
		{
			MethodName: "GetBaselineGeneratedNetworkPolicyForDeployment",
			Handler:    _NetworkPolicyService_GetBaselineGeneratedNetworkPolicyForDeployment_Handler,
		},
		{
			MethodName: "GetAllowedPeersFromCurrentPolicyForDeployment",
			Handler:    _NetworkPolicyService_GetAllowedPeersFromCurrentPolicyForDeployment_Handler,
		},
		{
			MethodName: "ApplyNetworkPolicyYamlForDeployment",
			Handler:    _NetworkPolicyService_ApplyNetworkPolicyYamlForDeployment_Handler,
		},
		{
			MethodName: "GetUndoModificationForDeployment",
			Handler:    _NetworkPolicyService_GetUndoModificationForDeployment_Handler,
		},
		{
			MethodName: "GetDiffFlowsBetweenPolicyAndBaselineForDeployment",
			Handler:    _NetworkPolicyService_GetDiffFlowsBetweenPolicyAndBaselineForDeployment_Handler,
		},
		{
			MethodName: "GetDiffFlowsFromUndoModificationForDeployment",
			Handler:    _NetworkPolicyService_GetDiffFlowsFromUndoModificationForDeployment_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/v1/network_policy_service.proto",
}

func (m *GetNetworkPoliciesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetNetworkPoliciesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetNetworkPoliciesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.DeploymentQuery) > 0 {
		i -= len(m.DeploymentQuery)
		copy(dAtA[i:], m.DeploymentQuery)
		i = encodeVarintNetworkPolicyService(dAtA, i, uint64(len(m.DeploymentQuery)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintNetworkPolicyService(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NetworkPoliciesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkPoliciesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkPoliciesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.NetworkPolicies) > 0 {
		for iNdEx := len(m.NetworkPolicies) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.NetworkPolicies[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintNetworkPolicyService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *SendNetworkPolicyYamlRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SendNetworkPolicyYamlRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SendNetworkPolicyYamlRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Modification != nil {
		{
			size, err := m.Modification.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkPolicyService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.NotifierIds) > 0 {
		for iNdEx := len(m.NotifierIds) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.NotifierIds[iNdEx])
			copy(dAtA[i:], m.NotifierIds[iNdEx])
			i = encodeVarintNetworkPolicyService(dAtA, i, uint64(len(m.NotifierIds[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintNetworkPolicyService(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetNetworkGraphRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetNetworkGraphRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetNetworkGraphRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Scope != nil {
		{
			size, err := m.Scope.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkPolicyService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.IncludePorts {
		i--
		if m.IncludePorts {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.Query) > 0 {
		i -= len(m.Query)
		copy(dAtA[i:], m.Query)
		i = encodeVarintNetworkPolicyService(dAtA, i, uint64(len(m.Query)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintNetworkPolicyService(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SimulateNetworkGraphRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SimulateNetworkGraphRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SimulateNetworkGraphRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Scope != nil {
		{
			size, err := m.Scope.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkPolicyService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.IncludeNodeDiff {
		i--
		if m.IncludeNodeDiff {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if m.IncludePorts {
		i--
		if m.IncludePorts {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.Modification != nil {
		{
			size, err := m.Modification.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkPolicyService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Query) > 0 {
		i -= len(m.Query)
		copy(dAtA[i:], m.Query)
		i = encodeVarintNetworkPolicyService(dAtA, i, uint64(len(m.Query)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintNetworkPolicyService(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ApplyNetworkPolicyYamlRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ApplyNetworkPolicyYamlRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ApplyNetworkPolicyYamlRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Modification != nil {
		{
			size, err := m.Modification.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkPolicyService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintNetworkPolicyService(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetUndoModificationRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetUndoModificationRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetUndoModificationRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintNetworkPolicyService(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetUndoModificationResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetUndoModificationResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetUndoModificationResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.UndoRecord != nil {
		{
			size, err := m.UndoRecord.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkPolicyService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NetworkPolicyInSimulation) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkPolicyInSimulation) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkPolicyInSimulation) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.OldPolicy != nil {
		{
			size, err := m.OldPolicy.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkPolicyService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Status != 0 {
		i = encodeVarintNetworkPolicyService(dAtA, i, uint64(m.Status))
		i--
		dAtA[i] = 0x10
	}
	if m.Policy != nil {
		{
			size, err := m.Policy.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkPolicyService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NetworkNodeDiff) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkNodeDiff) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkNodeDiff) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.OutEdges) > 0 {
		for k := range m.OutEdges {
			v := m.OutEdges[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintNetworkPolicyService(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintNetworkPolicyService(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintNetworkPolicyService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.NonIsolatedEgress {
		i--
		if m.NonIsolatedEgress {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.NonIsolatedIngress {
		i--
		if m.NonIsolatedIngress {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.DEPRECATEDOutEdges) > 0 {
		for k := range m.DEPRECATEDOutEdges {
			v := m.DEPRECATEDOutEdges[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintNetworkPolicyService(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i = encodeVarintNetworkPolicyService(dAtA, i, uint64(k))
			i--
			dAtA[i] = 0x8
			i = encodeVarintNetworkPolicyService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.PolicyIds) > 0 {
		for iNdEx := len(m.PolicyIds) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.PolicyIds[iNdEx])
			copy(dAtA[i:], m.PolicyIds[iNdEx])
			i = encodeVarintNetworkPolicyService(dAtA, i, uint64(len(m.PolicyIds[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *NetworkGraphDiff) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkGraphDiff) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkGraphDiff) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.NodeDiffs) > 0 {
		for k := range m.NodeDiffs {
			v := m.NodeDiffs[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintNetworkPolicyService(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintNetworkPolicyService(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintNetworkPolicyService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.DEPRECATEDNodeDiffs) > 0 {
		for k := range m.DEPRECATEDNodeDiffs {
			v := m.DEPRECATEDNodeDiffs[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintNetworkPolicyService(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i = encodeVarintNetworkPolicyService(dAtA, i, uint64(k))
			i--
			dAtA[i] = 0x8
			i = encodeVarintNetworkPolicyService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *SimulateNetworkGraphResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SimulateNetworkGraphResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SimulateNetworkGraphResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Removed != nil {
		{
			size, err := m.Removed.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkPolicyService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.Added != nil {
		{
			size, err := m.Added.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkPolicyService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Policies) > 0 {
		for iNdEx := len(m.Policies) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Policies[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintNetworkPolicyService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.SimulatedGraph != nil {
		{
			size, err := m.SimulatedGraph.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkPolicyService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetNetworkGraphEpochRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetNetworkGraphEpochRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetNetworkGraphEpochRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintNetworkPolicyService(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NetworkGraphEpoch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkGraphEpoch) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkGraphEpoch) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Epoch != 0 {
		i = encodeVarintNetworkPolicyService(dAtA, i, uint64(m.Epoch))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *GenerateNetworkPoliciesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GenerateNetworkPoliciesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GenerateNetworkPoliciesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.IncludePorts {
		i--
		if m.IncludePorts {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if m.NetworkDataSince != nil {
		{
			size, err := m.NetworkDataSince.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkPolicyService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.DeleteExisting != 0 {
		i = encodeVarintNetworkPolicyService(dAtA, i, uint64(m.DeleteExisting))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Query) > 0 {
		i -= len(m.Query)
		copy(dAtA[i:], m.Query)
		i = encodeVarintNetworkPolicyService(dAtA, i, uint64(len(m.Query)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ClusterId) > 0 {
		i -= len(m.ClusterId)
		copy(dAtA[i:], m.ClusterId)
		i = encodeVarintNetworkPolicyService(dAtA, i, uint64(len(m.ClusterId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GenerateNetworkPoliciesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GenerateNetworkPoliciesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GenerateNetworkPoliciesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Modification != nil {
		{
			size, err := m.Modification.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkPolicyService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetBaselineGeneratedPolicyForDeploymentRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetBaselineGeneratedPolicyForDeploymentRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetBaselineGeneratedPolicyForDeploymentRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.IncludePorts {
		i--
		if m.IncludePorts {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.DeleteExisting != 0 {
		i = encodeVarintNetworkPolicyService(dAtA, i, uint64(m.DeleteExisting))
		i--
		dAtA[i] = 0x10
	}
	if len(m.DeploymentId) > 0 {
		i -= len(m.DeploymentId)
		copy(dAtA[i:], m.DeploymentId)
		i = encodeVarintNetworkPolicyService(dAtA, i, uint64(len(m.DeploymentId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetBaselineGeneratedPolicyForDeploymentResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetBaselineGeneratedPolicyForDeploymentResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetBaselineGeneratedPolicyForDeploymentResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Modification != nil {
		{
			size, err := m.Modification.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkPolicyService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetAllowedPeersFromCurrentPolicyForDeploymentResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetAllowedPeersFromCurrentPolicyForDeploymentResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetAllowedPeersFromCurrentPolicyForDeploymentResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.AllowedPeers) > 0 {
		for iNdEx := len(m.AllowedPeers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.AllowedPeers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintNetworkPolicyService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ApplyNetworkPolicyYamlForDeploymentRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ApplyNetworkPolicyYamlForDeploymentRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ApplyNetworkPolicyYamlForDeploymentRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Modification != nil {
		{
			size, err := m.Modification.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkPolicyService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.DeploymentId) > 0 {
		i -= len(m.DeploymentId)
		copy(dAtA[i:], m.DeploymentId)
		i = encodeVarintNetworkPolicyService(dAtA, i, uint64(len(m.DeploymentId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetUndoModificationForDeploymentResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetUndoModificationForDeploymentResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetUndoModificationForDeploymentResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.UndoRecord != nil {
		{
			size, err := m.UndoRecord.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkPolicyService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetDiffFlowsReconciledFlow) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetDiffFlowsReconciledFlow) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetDiffFlowsReconciledFlow) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Unchanged) > 0 {
		for iNdEx := len(m.Unchanged) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Unchanged[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintNetworkPolicyService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Removed) > 0 {
		for iNdEx := len(m.Removed) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Removed[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintNetworkPolicyService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Added) > 0 {
		for iNdEx := len(m.Added) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Added[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintNetworkPolicyService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Entity != nil {
		{
			size, err := m.Entity.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkPolicyService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetDiffFlowsGroupedFlow) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetDiffFlowsGroupedFlow) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetDiffFlowsGroupedFlow) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Properties) > 0 {
		for iNdEx := len(m.Properties) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Properties[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintNetworkPolicyService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Entity != nil {
		{
			size, err := m.Entity.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNetworkPolicyService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetDiffFlowsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetDiffFlowsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetDiffFlowsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Reconciled) > 0 {
		for iNdEx := len(m.Reconciled) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Reconciled[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintNetworkPolicyService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Removed) > 0 {
		for iNdEx := len(m.Removed) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Removed[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintNetworkPolicyService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Added) > 0 {
		for iNdEx := len(m.Added) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Added[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintNetworkPolicyService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func encodeVarintNetworkPolicyService(dAtA []byte, offset int, v uint64) int {
	offset -= sovNetworkPolicyService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *GetNetworkPoliciesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovNetworkPolicyService(uint64(l))
	}
	l = len(m.DeploymentQuery)
	if l > 0 {
		n += 1 + l + sovNetworkPolicyService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkPoliciesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.NetworkPolicies) > 0 {
		for _, e := range m.NetworkPolicies {
			l = e.Size()
			n += 1 + l + sovNetworkPolicyService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SendNetworkPolicyYamlRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovNetworkPolicyService(uint64(l))
	}
	if len(m.NotifierIds) > 0 {
		for _, s := range m.NotifierIds {
			l = len(s)
			n += 1 + l + sovNetworkPolicyService(uint64(l))
		}
	}
	if m.Modification != nil {
		l = m.Modification.Size()
		n += 1 + l + sovNetworkPolicyService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetNetworkGraphRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovNetworkPolicyService(uint64(l))
	}
	l = len(m.Query)
	if l > 0 {
		n += 1 + l + sovNetworkPolicyService(uint64(l))
	}
	if m.IncludePorts {
		n += 2
	}
	if m.Scope != nil {
		l = m.Scope.Size()
		n += 1 + l + sovNetworkPolicyService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SimulateNetworkGraphRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovNetworkPolicyService(uint64(l))
	}
	l = len(m.Query)
	if l > 0 {
		n += 1 + l + sovNetworkPolicyService(uint64(l))
	}
	if m.Modification != nil {
		l = m.Modification.Size()
		n += 1 + l + sovNetworkPolicyService(uint64(l))
	}
	if m.IncludePorts {
		n += 2
	}
	if m.IncludeNodeDiff {
		n += 2
	}
	if m.Scope != nil {
		l = m.Scope.Size()
		n += 1 + l + sovNetworkPolicyService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ApplyNetworkPolicyYamlRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovNetworkPolicyService(uint64(l))
	}
	if m.Modification != nil {
		l = m.Modification.Size()
		n += 1 + l + sovNetworkPolicyService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetUndoModificationRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovNetworkPolicyService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetUndoModificationResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.UndoRecord != nil {
		l = m.UndoRecord.Size()
		n += 1 + l + sovNetworkPolicyService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkPolicyInSimulation) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Policy != nil {
		l = m.Policy.Size()
		n += 1 + l + sovNetworkPolicyService(uint64(l))
	}
	if m.Status != 0 {
		n += 1 + sovNetworkPolicyService(uint64(m.Status))
	}
	if m.OldPolicy != nil {
		l = m.OldPolicy.Size()
		n += 1 + l + sovNetworkPolicyService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkNodeDiff) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.PolicyIds) > 0 {
		for _, s := range m.PolicyIds {
			l = len(s)
			n += 1 + l + sovNetworkPolicyService(uint64(l))
		}
	}
	if len(m.DEPRECATEDOutEdges) > 0 {
		for k, v := range m.DEPRECATEDOutEdges {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovNetworkPolicyService(uint64(l))
			}
			mapEntrySize := 1 + sovNetworkPolicyService(uint64(k)) + l
			n += mapEntrySize + 1 + sovNetworkPolicyService(uint64(mapEntrySize))
		}
	}
	if m.NonIsolatedIngress {
		n += 2
	}
	if m.NonIsolatedEgress {
		n += 2
	}
	if len(m.OutEdges) > 0 {
		for k, v := range m.OutEdges {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovNetworkPolicyService(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovNetworkPolicyService(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovNetworkPolicyService(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkGraphDiff) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.DEPRECATEDNodeDiffs) > 0 {
		for k, v := range m.DEPRECATEDNodeDiffs {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovNetworkPolicyService(uint64(l))
			}
			mapEntrySize := 1 + sovNetworkPolicyService(uint64(k)) + l
			n += mapEntrySize + 1 + sovNetworkPolicyService(uint64(mapEntrySize))
		}
	}
	if len(m.NodeDiffs) > 0 {
		for k, v := range m.NodeDiffs {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovNetworkPolicyService(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovNetworkPolicyService(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovNetworkPolicyService(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SimulateNetworkGraphResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.SimulatedGraph != nil {
		l = m.SimulatedGraph.Size()
		n += 1 + l + sovNetworkPolicyService(uint64(l))
	}
	if len(m.Policies) > 0 {
		for _, e := range m.Policies {
			l = e.Size()
			n += 1 + l + sovNetworkPolicyService(uint64(l))
		}
	}
	if m.Added != nil {
		l = m.Added.Size()
		n += 1 + l + sovNetworkPolicyService(uint64(l))
	}
	if m.Removed != nil {
		l = m.Removed.Size()
		n += 1 + l + sovNetworkPolicyService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetNetworkGraphEpochRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovNetworkPolicyService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkGraphEpoch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Epoch != 0 {
		n += 1 + sovNetworkPolicyService(uint64(m.Epoch))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GenerateNetworkPoliciesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterId)
	if l > 0 {
		n += 1 + l + sovNetworkPolicyService(uint64(l))
	}
	l = len(m.Query)
	if l > 0 {
		n += 1 + l + sovNetworkPolicyService(uint64(l))
	}
	if m.DeleteExisting != 0 {
		n += 1 + sovNetworkPolicyService(uint64(m.DeleteExisting))
	}
	if m.NetworkDataSince != nil {
		l = m.NetworkDataSince.Size()
		n += 1 + l + sovNetworkPolicyService(uint64(l))
	}
	if m.IncludePorts {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GenerateNetworkPoliciesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Modification != nil {
		l = m.Modification.Size()
		n += 1 + l + sovNetworkPolicyService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetBaselineGeneratedPolicyForDeploymentRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DeploymentId)
	if l > 0 {
		n += 1 + l + sovNetworkPolicyService(uint64(l))
	}
	if m.DeleteExisting != 0 {
		n += 1 + sovNetworkPolicyService(uint64(m.DeleteExisting))
	}
	if m.IncludePorts {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetBaselineGeneratedPolicyForDeploymentResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Modification != nil {
		l = m.Modification.Size()
		n += 1 + l + sovNetworkPolicyService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetAllowedPeersFromCurrentPolicyForDeploymentResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.AllowedPeers) > 0 {
		for _, e := range m.AllowedPeers {
			l = e.Size()
			n += 1 + l + sovNetworkPolicyService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ApplyNetworkPolicyYamlForDeploymentRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DeploymentId)
	if l > 0 {
		n += 1 + l + sovNetworkPolicyService(uint64(l))
	}
	if m.Modification != nil {
		l = m.Modification.Size()
		n += 1 + l + sovNetworkPolicyService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetUndoModificationForDeploymentResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.UndoRecord != nil {
		l = m.UndoRecord.Size()
		n += 1 + l + sovNetworkPolicyService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetDiffFlowsReconciledFlow) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Entity != nil {
		l = m.Entity.Size()
		n += 1 + l + sovNetworkPolicyService(uint64(l))
	}
	if len(m.Added) > 0 {
		for _, e := range m.Added {
			l = e.Size()
			n += 1 + l + sovNetworkPolicyService(uint64(l))
		}
	}
	if len(m.Removed) > 0 {
		for _, e := range m.Removed {
			l = e.Size()
			n += 1 + l + sovNetworkPolicyService(uint64(l))
		}
	}
	if len(m.Unchanged) > 0 {
		for _, e := range m.Unchanged {
			l = e.Size()
			n += 1 + l + sovNetworkPolicyService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetDiffFlowsGroupedFlow) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Entity != nil {
		l = m.Entity.Size()
		n += 1 + l + sovNetworkPolicyService(uint64(l))
	}
	if len(m.Properties) > 0 {
		for _, e := range m.Properties {
			l = e.Size()
			n += 1 + l + sovNetworkPolicyService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetDiffFlowsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Added) > 0 {
		for _, e := range m.Added {
			l = e.Size()
			n += 1 + l + sovNetworkPolicyService(uint64(l))
		}
	}
	if len(m.Removed) > 0 {
		for _, e := range m.Removed {
			l = e.Size()
			n += 1 + l + sovNetworkPolicyService(uint64(l))
		}
	}
	if len(m.Reconciled) > 0 {
		for _, e := range m.Reconciled {
			l = e.Size()
			n += 1 + l + sovNetworkPolicyService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovNetworkPolicyService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozNetworkPolicyService(x uint64) (n int) {
	return sovNetworkPolicyService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *GetNetworkPoliciesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkPolicyService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetNetworkPoliciesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetNetworkPoliciesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentQuery", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentQuery = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkPolicyService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkPoliciesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkPolicyService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkPoliciesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkPoliciesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetworkPolicies", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NetworkPolicies = append(m.NetworkPolicies, &storage.NetworkPolicy{})
			if err := m.NetworkPolicies[len(m.NetworkPolicies)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkPolicyService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SendNetworkPolicyYamlRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkPolicyService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SendNetworkPolicyYamlRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SendNetworkPolicyYamlRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NotifierIds", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NotifierIds = append(m.NotifierIds, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Modification", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Modification == nil {
				m.Modification = &storage.NetworkPolicyModification{}
			}
			if err := m.Modification.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkPolicyService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetNetworkGraphRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkPolicyService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetNetworkGraphRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetNetworkGraphRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Query = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IncludePorts", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IncludePorts = bool(v != 0)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scope", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Scope == nil {
				m.Scope = &NetworkGraphScope{}
			}
			if err := m.Scope.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkPolicyService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SimulateNetworkGraphRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkPolicyService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SimulateNetworkGraphRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SimulateNetworkGraphRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Query = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Modification", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Modification == nil {
				m.Modification = &storage.NetworkPolicyModification{}
			}
			if err := m.Modification.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IncludePorts", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IncludePorts = bool(v != 0)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IncludeNodeDiff", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IncludeNodeDiff = bool(v != 0)
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scope", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Scope == nil {
				m.Scope = &NetworkGraphScope{}
			}
			if err := m.Scope.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkPolicyService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ApplyNetworkPolicyYamlRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkPolicyService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ApplyNetworkPolicyYamlRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ApplyNetworkPolicyYamlRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Modification", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Modification == nil {
				m.Modification = &storage.NetworkPolicyModification{}
			}
			if err := m.Modification.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkPolicyService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetUndoModificationRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkPolicyService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetUndoModificationRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetUndoModificationRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkPolicyService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetUndoModificationResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkPolicyService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetUndoModificationResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetUndoModificationResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UndoRecord", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UndoRecord == nil {
				m.UndoRecord = &storage.NetworkPolicyApplicationUndoRecord{}
			}
			if err := m.UndoRecord.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkPolicyService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkPolicyInSimulation) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkPolicyService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkPolicyInSimulation: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkPolicyInSimulation: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Policy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Policy == nil {
				m.Policy = &storage.NetworkPolicy{}
			}
			if err := m.Policy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= NetworkPolicyInSimulation_Status(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OldPolicy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.OldPolicy == nil {
				m.OldPolicy = &storage.NetworkPolicy{}
			}
			if err := m.OldPolicy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkPolicyService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkNodeDiff) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkPolicyService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkNodeDiff: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkNodeDiff: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PolicyIds", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PolicyIds = append(m.PolicyIds, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DEPRECATEDOutEdges", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DEPRECATEDOutEdges == nil {
				m.DEPRECATEDOutEdges = make(map[int32]*NetworkEdgePropertiesBundle)
			}
			var mapkey int32
			var mapvalue *NetworkEdgePropertiesBundle
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowNetworkPolicyService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowNetworkPolicyService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowNetworkPolicyService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthNetworkPolicyService
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthNetworkPolicyService
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &NetworkEdgePropertiesBundle{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipNetworkPolicyService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthNetworkPolicyService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.DEPRECATEDOutEdges[mapkey] = mapvalue
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NonIsolatedIngress", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NonIsolatedIngress = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NonIsolatedEgress", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NonIsolatedEgress = bool(v != 0)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OutEdges", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.OutEdges == nil {
				m.OutEdges = make(map[string]*NetworkEdgePropertiesBundle)
			}
			var mapkey string
			var mapvalue *NetworkEdgePropertiesBundle
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowNetworkPolicyService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowNetworkPolicyService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthNetworkPolicyService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthNetworkPolicyService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowNetworkPolicyService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthNetworkPolicyService
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthNetworkPolicyService
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &NetworkEdgePropertiesBundle{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipNetworkPolicyService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthNetworkPolicyService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.OutEdges[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkPolicyService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkGraphDiff) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkPolicyService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkGraphDiff: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkGraphDiff: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DEPRECATEDNodeDiffs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DEPRECATEDNodeDiffs == nil {
				m.DEPRECATEDNodeDiffs = make(map[int32]*NetworkNodeDiff)
			}
			var mapkey int32
			var mapvalue *NetworkNodeDiff
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowNetworkPolicyService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowNetworkPolicyService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowNetworkPolicyService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthNetworkPolicyService
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthNetworkPolicyService
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &NetworkNodeDiff{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipNetworkPolicyService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthNetworkPolicyService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.DEPRECATEDNodeDiffs[mapkey] = mapvalue
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeDiffs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NodeDiffs == nil {
				m.NodeDiffs = make(map[string]*NetworkNodeDiff)
			}
			var mapkey string
			var mapvalue *NetworkNodeDiff
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowNetworkPolicyService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowNetworkPolicyService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthNetworkPolicyService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthNetworkPolicyService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowNetworkPolicyService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthNetworkPolicyService
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthNetworkPolicyService
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &NetworkNodeDiff{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipNetworkPolicyService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthNetworkPolicyService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.NodeDiffs[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkPolicyService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SimulateNetworkGraphResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkPolicyService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SimulateNetworkGraphResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SimulateNetworkGraphResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SimulatedGraph", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SimulatedGraph == nil {
				m.SimulatedGraph = &NetworkGraph{}
			}
			if err := m.SimulatedGraph.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Policies", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Policies = append(m.Policies, &NetworkPolicyInSimulation{})
			if err := m.Policies[len(m.Policies)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Added", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Added == nil {
				m.Added = &NetworkGraphDiff{}
			}
			if err := m.Added.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Removed", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Removed == nil {
				m.Removed = &NetworkGraphDiff{}
			}
			if err := m.Removed.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkPolicyService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetNetworkGraphEpochRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkPolicyService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetNetworkGraphEpochRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetNetworkGraphEpochRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkPolicyService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkGraphEpoch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkPolicyService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkGraphEpoch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkGraphEpoch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Epoch", wireType)
			}
			m.Epoch = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Epoch |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkPolicyService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GenerateNetworkPoliciesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkPolicyService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GenerateNetworkPoliciesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GenerateNetworkPoliciesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Query = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeleteExisting", wireType)
			}
			m.DeleteExisting = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DeleteExisting |= GenerateNetworkPoliciesRequest_DeleteExistingPoliciesMode(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetworkDataSince", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NetworkDataSince == nil {
				m.NetworkDataSince = &types.Timestamp{}
			}
			if err := m.NetworkDataSince.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IncludePorts", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IncludePorts = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkPolicyService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GenerateNetworkPoliciesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkPolicyService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GenerateNetworkPoliciesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GenerateNetworkPoliciesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Modification", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Modification == nil {
				m.Modification = &storage.NetworkPolicyModification{}
			}
			if err := m.Modification.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkPolicyService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetBaselineGeneratedPolicyForDeploymentRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkPolicyService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetBaselineGeneratedPolicyForDeploymentRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetBaselineGeneratedPolicyForDeploymentRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeleteExisting", wireType)
			}
			m.DeleteExisting = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DeleteExisting |= GenerateNetworkPoliciesRequest_DeleteExistingPoliciesMode(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IncludePorts", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IncludePorts = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkPolicyService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetBaselineGeneratedPolicyForDeploymentResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkPolicyService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetBaselineGeneratedPolicyForDeploymentResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetBaselineGeneratedPolicyForDeploymentResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Modification", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Modification == nil {
				m.Modification = &storage.NetworkPolicyModification{}
			}
			if err := m.Modification.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkPolicyService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetAllowedPeersFromCurrentPolicyForDeploymentResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkPolicyService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetAllowedPeersFromCurrentPolicyForDeploymentResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetAllowedPeersFromCurrentPolicyForDeploymentResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllowedPeers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AllowedPeers = append(m.AllowedPeers, &NetworkBaselineStatusPeer{})
			if err := m.AllowedPeers[len(m.AllowedPeers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkPolicyService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ApplyNetworkPolicyYamlForDeploymentRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkPolicyService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ApplyNetworkPolicyYamlForDeploymentRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ApplyNetworkPolicyYamlForDeploymentRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Modification", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Modification == nil {
				m.Modification = &storage.NetworkPolicyModification{}
			}
			if err := m.Modification.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkPolicyService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetUndoModificationForDeploymentResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkPolicyService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetUndoModificationForDeploymentResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetUndoModificationForDeploymentResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UndoRecord", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UndoRecord == nil {
				m.UndoRecord = &storage.NetworkPolicyApplicationUndoRecord{}
			}
			if err := m.UndoRecord.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkPolicyService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetDiffFlowsReconciledFlow) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkPolicyService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetDiffFlowsReconciledFlow: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetDiffFlowsReconciledFlow: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Entity", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Entity == nil {
				m.Entity = &storage.NetworkEntityInfo{}
			}
			if err := m.Entity.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Added", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Added = append(m.Added, &storage.NetworkBaselineConnectionProperties{})
			if err := m.Added[len(m.Added)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Removed", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Removed = append(m.Removed, &storage.NetworkBaselineConnectionProperties{})
			if err := m.Removed[len(m.Removed)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Unchanged", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Unchanged = append(m.Unchanged, &storage.NetworkBaselineConnectionProperties{})
			if err := m.Unchanged[len(m.Unchanged)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkPolicyService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetDiffFlowsGroupedFlow) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkPolicyService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetDiffFlowsGroupedFlow: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetDiffFlowsGroupedFlow: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Entity", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Entity == nil {
				m.Entity = &storage.NetworkEntityInfo{}
			}
			if err := m.Entity.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Properties", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Properties = append(m.Properties, &storage.NetworkBaselineConnectionProperties{})
			if err := m.Properties[len(m.Properties)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkPolicyService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetDiffFlowsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkPolicyService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetDiffFlowsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetDiffFlowsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Added", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Added = append(m.Added, &GetDiffFlowsGroupedFlow{})
			if err := m.Added[len(m.Added)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Removed", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Removed = append(m.Removed, &GetDiffFlowsGroupedFlow{})
			if err := m.Removed[len(m.Removed)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reconciled", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Reconciled = append(m.Reconciled, &GetDiffFlowsReconciledFlow{})
			if err := m.Reconciled[len(m.Reconciled)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkPolicyService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkPolicyService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipNetworkPolicyService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowNetworkPolicyService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowNetworkPolicyService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthNetworkPolicyService
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupNetworkPolicyService
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthNetworkPolicyService
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthNetworkPolicyService        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowNetworkPolicyService          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupNetworkPolicyService = fmt.Errorf("proto: unexpected end of group")
)
