// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api/v1/notifier_service.proto

package v1

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	storage "github.com/stackrox/rox/generated/storage"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type GetNotifiersRequest struct {
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Type                 string   `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetNotifiersRequest) Reset()         { *m = GetNotifiersRequest{} }
func (m *GetNotifiersRequest) String() string { return proto.CompactTextString(m) }
func (*GetNotifiersRequest) ProtoMessage()    {}
func (*GetNotifiersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d701d52c602e61b, []int{0}
}
func (m *GetNotifiersRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetNotifiersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetNotifiersRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetNotifiersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetNotifiersRequest.Merge(m, src)
}
func (m *GetNotifiersRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetNotifiersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetNotifiersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetNotifiersRequest proto.InternalMessageInfo

func (m *GetNotifiersRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetNotifiersRequest) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *GetNotifiersRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetNotifiersRequest) Clone() *GetNotifiersRequest {
	if m == nil {
		return nil
	}
	cloned := new(GetNotifiersRequest)
	*cloned = *m

	return cloned
}

type GetNotifiersResponse struct {
	Notifiers            []*storage.Notifier `protobuf:"bytes,1,rep,name=notifiers,proto3" json:"notifiers,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *GetNotifiersResponse) Reset()         { *m = GetNotifiersResponse{} }
func (m *GetNotifiersResponse) String() string { return proto.CompactTextString(m) }
func (*GetNotifiersResponse) ProtoMessage()    {}
func (*GetNotifiersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d701d52c602e61b, []int{1}
}
func (m *GetNotifiersResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetNotifiersResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetNotifiersResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetNotifiersResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetNotifiersResponse.Merge(m, src)
}
func (m *GetNotifiersResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetNotifiersResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetNotifiersResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetNotifiersResponse proto.InternalMessageInfo

func (m *GetNotifiersResponse) GetNotifiers() []*storage.Notifier {
	if m != nil {
		return m.Notifiers
	}
	return nil
}

func (m *GetNotifiersResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetNotifiersResponse) Clone() *GetNotifiersResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetNotifiersResponse)
	*cloned = *m

	if m.Notifiers != nil {
		cloned.Notifiers = make([]*storage.Notifier, len(m.Notifiers))
		for idx, v := range m.Notifiers {
			cloned.Notifiers[idx] = v.Clone()
		}
	}
	return cloned
}

type DeleteNotifierRequest struct {
	Id                   string   `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Force                bool     `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteNotifierRequest) Reset()         { *m = DeleteNotifierRequest{} }
func (m *DeleteNotifierRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteNotifierRequest) ProtoMessage()    {}
func (*DeleteNotifierRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d701d52c602e61b, []int{2}
}
func (m *DeleteNotifierRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeleteNotifierRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeleteNotifierRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeleteNotifierRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteNotifierRequest.Merge(m, src)
}
func (m *DeleteNotifierRequest) XXX_Size() int {
	return m.Size()
}
func (m *DeleteNotifierRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteNotifierRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteNotifierRequest proto.InternalMessageInfo

func (m *DeleteNotifierRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *DeleteNotifierRequest) GetForce() bool {
	if m != nil {
		return m.Force
	}
	return false
}

func (m *DeleteNotifierRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *DeleteNotifierRequest) Clone() *DeleteNotifierRequest {
	if m == nil {
		return nil
	}
	cloned := new(DeleteNotifierRequest)
	*cloned = *m

	return cloned
}

type UpdateNotifierRequest struct {
	Notifier *storage.Notifier `protobuf:"bytes,1,opt,name=notifier,proto3" json:"notifier,omitempty"`
	// When false, use the stored credentials of an existing notifier configuration given its ID.
	UpdatePassword       bool     `protobuf:"varint,2,opt,name=update_password,json=updatePassword,proto3" json:"update_password,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateNotifierRequest) Reset()         { *m = UpdateNotifierRequest{} }
func (m *UpdateNotifierRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateNotifierRequest) ProtoMessage()    {}
func (*UpdateNotifierRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d701d52c602e61b, []int{3}
}
func (m *UpdateNotifierRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpdateNotifierRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UpdateNotifierRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UpdateNotifierRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateNotifierRequest.Merge(m, src)
}
func (m *UpdateNotifierRequest) XXX_Size() int {
	return m.Size()
}
func (m *UpdateNotifierRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateNotifierRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateNotifierRequest proto.InternalMessageInfo

func (m *UpdateNotifierRequest) GetNotifier() *storage.Notifier {
	if m != nil {
		return m.Notifier
	}
	return nil
}

func (m *UpdateNotifierRequest) GetUpdatePassword() bool {
	if m != nil {
		return m.UpdatePassword
	}
	return false
}

func (m *UpdateNotifierRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *UpdateNotifierRequest) Clone() *UpdateNotifierRequest {
	if m == nil {
		return nil
	}
	cloned := new(UpdateNotifierRequest)
	*cloned = *m

	cloned.Notifier = m.Notifier.Clone()
	return cloned
}

func init() {
	proto.RegisterType((*GetNotifiersRequest)(nil), "v1.GetNotifiersRequest")
	proto.RegisterType((*GetNotifiersResponse)(nil), "v1.GetNotifiersResponse")
	proto.RegisterType((*DeleteNotifierRequest)(nil), "v1.DeleteNotifierRequest")
	proto.RegisterType((*UpdateNotifierRequest)(nil), "v1.UpdateNotifierRequest")
}

func init() { proto.RegisterFile("api/v1/notifier_service.proto", fileDescriptor_2d701d52c602e61b) }

var fileDescriptor_2d701d52c602e61b = []byte{
	// 542 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x94, 0xc1, 0x6e, 0xd3, 0x4c,
	0x10, 0xc7, 0x6b, 0x7f, 0x5f, 0x51, 0x33, 0x09, 0x09, 0x6c, 0x12, 0x6a, 0x0c, 0x0d, 0xd1, 0x4a,
	0x40, 0x15, 0x09, 0x5b, 0x09, 0xb7, 0x4a, 0xbd, 0x54, 0x45, 0x15, 0x20, 0x45, 0x91, 0x01, 0xa9,
	0xe2, 0x40, 0xe5, 0xda, 0xdb, 0x68, 0x45, 0xe3, 0x35, 0xde, 0x8d, 0x21, 0x42, 0x5c, 0x78, 0x05,
	0x2e, 0x3c, 0x0c, 0x0f, 0xc0, 0x11, 0x89, 0x17, 0x40, 0x81, 0x07, 0x41, 0xeb, 0xdd, 0xa4, 0x76,
	0x6d, 0x21, 0xf5, 0xb6, 0xfe, 0xef, 0xcc, 0x6f, 0xfe, 0x9e, 0x19, 0x1b, 0x76, 0xfc, 0x98, 0xba,
	0xe9, 0xd0, 0x8d, 0x98, 0xa0, 0x67, 0x94, 0x24, 0x27, 0x9c, 0x24, 0x29, 0x0d, 0x88, 0x13, 0x27,
	0x4c, 0x30, 0x64, 0xa6, 0x43, 0xfb, 0xee, 0x94, 0xb1, 0xe9, 0x39, 0x71, 0x65, 0xa4, 0x1f, 0x45,
	0x4c, 0xf8, 0x82, 0xb2, 0x88, 0xab, 0x08, 0xbb, 0xad, 0x01, 0x01, 0x9b, 0xcd, 0x58, 0xa4, 0x45,
	0xa4, 0x45, 0x32, 0x8b, 0xc5, 0x42, 0x6b, 0xb7, 0xb8, 0x60, 0x89, 0x3f, 0x25, 0xeb, 0x52, 0x4a,
	0xc7, 0xfb, 0xd0, 0x3e, 0x22, 0x62, 0xac, 0x45, 0xee, 0x91, 0x77, 0x73, 0xc2, 0x05, 0x42, 0xf0,
	0x7f, 0xe4, 0xcf, 0x88, 0x65, 0xf4, 0x8d, 0xdd, 0x9a, 0x97, 0x9d, 0xa5, 0x26, 0x16, 0x31, 0xb1,
	0x4c, 0xa5, 0xc9, 0x33, 0x3e, 0x82, 0x4e, 0x31, 0x9d, 0xc7, 0x2c, 0xe2, 0x04, 0xb9, 0x50, 0x5b,
	0x15, 0xe2, 0x96, 0xd1, 0xff, 0x6f, 0xb7, 0x3e, 0xba, 0xe9, 0x68, 0x0b, 0xce, 0x2a, 0xdc, 0xbb,
	0x88, 0xc1, 0xfb, 0xd0, 0x3d, 0x24, 0xe7, 0x44, 0x90, 0xf5, 0xa5, 0x76, 0xd2, 0x04, 0x93, 0x86,
	0xda, 0x87, 0x49, 0x43, 0xd4, 0x81, 0xcd, 0x33, 0x96, 0x04, 0xca, 0xc6, 0x96, 0xa7, 0x1e, 0x30,
	0x83, 0xee, 0xab, 0x38, 0xf4, 0xcb, 0xe9, 0x8f, 0x60, 0x6b, 0x55, 0x24, 0x83, 0x54, 0xfa, 0x58,
	0x87, 0xa0, 0x87, 0xd0, 0x9a, 0x67, 0x9c, 0x93, 0xd8, 0xe7, 0xfc, 0x3d, 0x4b, 0x42, 0x5d, 0xa7,
	0xa9, 0xe4, 0x89, 0x56, 0x47, 0xdf, 0x36, 0xa1, 0xb5, 0xca, 0x7f, 0xa1, 0x86, 0x86, 0xc6, 0x50,
	0xcf, 0x35, 0x03, 0xdd, 0x70, 0xd2, 0xa1, 0xe3, 0x11, 0xce, 0xe6, 0x49, 0x40, 0x0e, 0x16, 0x4f,
	0x0f, 0xed, 0x72, 0x69, 0x6c, 0x7f, 0xfe, 0xf9, 0xe7, 0x8b, 0xd9, 0x41, 0x28, 0xbf, 0x06, 0xdc,
	0xfd, 0x48, 0xc3, 0x4f, 0xe8, 0x18, 0x1a, 0xf9, 0xe6, 0xa2, 0x6d, 0x09, 0xac, 0x98, 0x96, 0x6d,
	0x95, 0x2f, 0xd4, 0x1c, 0x70, 0x37, 0xc3, 0xb7, 0xd0, 0xf5, 0x02, 0x1e, 0x3d, 0x83, 0xfa, 0x64,
	0x7e, 0xe1, 0xb4, 0xec, 0xcb, 0xae, 0x49, 0xe4, 0x13, 0xb9, 0x40, 0x78, 0x27, 0x63, 0x6c, 0xdb,
	0x15, 0x16, 0xf7, 0x8c, 0x01, 0x1a, 0x43, 0x63, 0xc2, 0xf8, 0x3f, 0x61, 0x15, 0xef, 0x6d, 0x65,
	0x50, 0x84, 0x8b, 0xc6, 0x24, 0xef, 0x39, 0x34, 0x5e, 0x12, 0x7e, 0x45, 0x73, 0xf8, 0x92, 0x39,
	0x41, 0xb8, 0x90, 0x30, 0x0f, 0x9a, 0xc5, 0xb5, 0x42, 0xb7, 0x65, 0x6e, 0xe5, 0xaa, 0xe5, 0xb1,
	0x7a, 0x2c, 0x83, 0xaa, 0xb1, 0xbc, 0x81, 0x66, 0x71, 0xd7, 0x14, 0xb3, 0x72, 0xff, 0xf2, 0xcc,
	0x07, 0x19, 0xb3, 0x3f, 0xba, 0x73, 0x89, 0xb9, 0xfe, 0x22, 0x75, 0x43, 0x4f, 0xa1, 0x2d, 0x1b,
	0xa0, 0x78, 0xe1, 0x15, 0x8b, 0xdc, 0xcf, 0x8a, 0xdc, 0xc3, 0x76, 0xb9, 0x1f, 0xae, 0x5a, 0xe1,
	0x70, 0xcf, 0x18, 0x1c, 0x38, 0xdf, 0x97, 0x3d, 0xe3, 0xc7, 0xb2, 0x67, 0xfc, 0x5a, 0xf6, 0x8c,
	0xaf, 0xbf, 0x7b, 0x1b, 0x60, 0x51, 0xe6, 0x70, 0xe1, 0x07, 0x6f, 0x13, 0xf6, 0x41, 0xfd, 0x1b,
	0x1c, 0x3f, 0xa6, 0x4e, 0x3a, 0x7c, 0x6d, 0xa6, 0xc3, 0xe3, 0x8d, 0xd3, 0x6b, 0x99, 0xf6, 0xf8,
	0x6f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xdc, 0x18, 0xff, 0xa9, 0xb3, 0x04, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// NotifierServiceClient is the client API for NotifierService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConnInterface.NewStream.
type NotifierServiceClient interface {
	// GetNotifier returns the notifier configuration given its ID.
	GetNotifier(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*storage.Notifier, error)
	// GetNotifiers returns all notifier configurations that match the request filters.
	GetNotifiers(ctx context.Context, in *GetNotifiersRequest, opts ...grpc.CallOption) (*GetNotifiersResponse, error)
	// PutNotifier modifies a given notifier, without using stored credential reconciliation.
	PutNotifier(ctx context.Context, in *storage.Notifier, opts ...grpc.CallOption) (*Empty, error)
	// PostNotifier creates a notifier configuration.
	PostNotifier(ctx context.Context, in *storage.Notifier, opts ...grpc.CallOption) (*storage.Notifier, error)
	// TestNotifier checks if a notifier is correctly configured.
	TestNotifier(ctx context.Context, in *storage.Notifier, opts ...grpc.CallOption) (*Empty, error)
	// DeleteNotifier removes a notifier configuration given its ID.
	DeleteNotifier(ctx context.Context, in *DeleteNotifierRequest, opts ...grpc.CallOption) (*Empty, error)
	// UpdateNotifier modifies a given notifier, with optional stored credential reconciliation.
	UpdateNotifier(ctx context.Context, in *UpdateNotifierRequest, opts ...grpc.CallOption) (*Empty, error)
	// TestUpdatedNotifier checks if the given notifier is correctly configured, with optional stored credential reconciliation.
	TestUpdatedNotifier(ctx context.Context, in *UpdateNotifierRequest, opts ...grpc.CallOption) (*Empty, error)
}

type notifierServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewNotifierServiceClient(cc grpc.ClientConnInterface) NotifierServiceClient {
	return &notifierServiceClient{cc}
}

func (c *notifierServiceClient) GetNotifier(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*storage.Notifier, error) {
	out := new(storage.Notifier)
	err := c.cc.Invoke(ctx, "/v1.NotifierService/GetNotifier", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notifierServiceClient) GetNotifiers(ctx context.Context, in *GetNotifiersRequest, opts ...grpc.CallOption) (*GetNotifiersResponse, error) {
	out := new(GetNotifiersResponse)
	err := c.cc.Invoke(ctx, "/v1.NotifierService/GetNotifiers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notifierServiceClient) PutNotifier(ctx context.Context, in *storage.Notifier, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.NotifierService/PutNotifier", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notifierServiceClient) PostNotifier(ctx context.Context, in *storage.Notifier, opts ...grpc.CallOption) (*storage.Notifier, error) {
	out := new(storage.Notifier)
	err := c.cc.Invoke(ctx, "/v1.NotifierService/PostNotifier", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notifierServiceClient) TestNotifier(ctx context.Context, in *storage.Notifier, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.NotifierService/TestNotifier", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notifierServiceClient) DeleteNotifier(ctx context.Context, in *DeleteNotifierRequest, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.NotifierService/DeleteNotifier", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notifierServiceClient) UpdateNotifier(ctx context.Context, in *UpdateNotifierRequest, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.NotifierService/UpdateNotifier", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notifierServiceClient) TestUpdatedNotifier(ctx context.Context, in *UpdateNotifierRequest, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.NotifierService/TestUpdatedNotifier", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// NotifierServiceServer is the server API for NotifierService service.
type NotifierServiceServer interface {
	// GetNotifier returns the notifier configuration given its ID.
	GetNotifier(context.Context, *ResourceByID) (*storage.Notifier, error)
	// GetNotifiers returns all notifier configurations that match the request filters.
	GetNotifiers(context.Context, *GetNotifiersRequest) (*GetNotifiersResponse, error)
	// PutNotifier modifies a given notifier, without using stored credential reconciliation.
	PutNotifier(context.Context, *storage.Notifier) (*Empty, error)
	// PostNotifier creates a notifier configuration.
	PostNotifier(context.Context, *storage.Notifier) (*storage.Notifier, error)
	// TestNotifier checks if a notifier is correctly configured.
	TestNotifier(context.Context, *storage.Notifier) (*Empty, error)
	// DeleteNotifier removes a notifier configuration given its ID.
	DeleteNotifier(context.Context, *DeleteNotifierRequest) (*Empty, error)
	// UpdateNotifier modifies a given notifier, with optional stored credential reconciliation.
	UpdateNotifier(context.Context, *UpdateNotifierRequest) (*Empty, error)
	// TestUpdatedNotifier checks if the given notifier is correctly configured, with optional stored credential reconciliation.
	TestUpdatedNotifier(context.Context, *UpdateNotifierRequest) (*Empty, error)
}

// UnimplementedNotifierServiceServer can be embedded to have forward compatible implementations.
type UnimplementedNotifierServiceServer struct {
}

func (*UnimplementedNotifierServiceServer) GetNotifier(ctx context.Context, req *ResourceByID) (*storage.Notifier, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNotifier not implemented")
}
func (*UnimplementedNotifierServiceServer) GetNotifiers(ctx context.Context, req *GetNotifiersRequest) (*GetNotifiersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNotifiers not implemented")
}
func (*UnimplementedNotifierServiceServer) PutNotifier(ctx context.Context, req *storage.Notifier) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PutNotifier not implemented")
}
func (*UnimplementedNotifierServiceServer) PostNotifier(ctx context.Context, req *storage.Notifier) (*storage.Notifier, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PostNotifier not implemented")
}
func (*UnimplementedNotifierServiceServer) TestNotifier(ctx context.Context, req *storage.Notifier) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestNotifier not implemented")
}
func (*UnimplementedNotifierServiceServer) DeleteNotifier(ctx context.Context, req *DeleteNotifierRequest) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteNotifier not implemented")
}
func (*UnimplementedNotifierServiceServer) UpdateNotifier(ctx context.Context, req *UpdateNotifierRequest) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateNotifier not implemented")
}
func (*UnimplementedNotifierServiceServer) TestUpdatedNotifier(ctx context.Context, req *UpdateNotifierRequest) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestUpdatedNotifier not implemented")
}

func RegisterNotifierServiceServer(s *grpc.Server, srv NotifierServiceServer) {
	s.RegisterService(&_NotifierService_serviceDesc, srv)
}

func _NotifierService_GetNotifier_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotifierServiceServer).GetNotifier(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.NotifierService/GetNotifier",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotifierServiceServer).GetNotifier(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotifierService_GetNotifiers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNotifiersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotifierServiceServer).GetNotifiers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.NotifierService/GetNotifiers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotifierServiceServer).GetNotifiers(ctx, req.(*GetNotifiersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotifierService_PutNotifier_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(storage.Notifier)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotifierServiceServer).PutNotifier(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.NotifierService/PutNotifier",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotifierServiceServer).PutNotifier(ctx, req.(*storage.Notifier))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotifierService_PostNotifier_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(storage.Notifier)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotifierServiceServer).PostNotifier(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.NotifierService/PostNotifier",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotifierServiceServer).PostNotifier(ctx, req.(*storage.Notifier))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotifierService_TestNotifier_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(storage.Notifier)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotifierServiceServer).TestNotifier(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.NotifierService/TestNotifier",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotifierServiceServer).TestNotifier(ctx, req.(*storage.Notifier))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotifierService_DeleteNotifier_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNotifierRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotifierServiceServer).DeleteNotifier(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.NotifierService/DeleteNotifier",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotifierServiceServer).DeleteNotifier(ctx, req.(*DeleteNotifierRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotifierService_UpdateNotifier_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateNotifierRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotifierServiceServer).UpdateNotifier(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.NotifierService/UpdateNotifier",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotifierServiceServer).UpdateNotifier(ctx, req.(*UpdateNotifierRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotifierService_TestUpdatedNotifier_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateNotifierRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotifierServiceServer).TestUpdatedNotifier(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.NotifierService/TestUpdatedNotifier",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotifierServiceServer).TestUpdatedNotifier(ctx, req.(*UpdateNotifierRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _NotifierService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1.NotifierService",
	HandlerType: (*NotifierServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetNotifier",
			Handler:    _NotifierService_GetNotifier_Handler,
		},
		{
			MethodName: "GetNotifiers",
			Handler:    _NotifierService_GetNotifiers_Handler,
		},
		{
			MethodName: "PutNotifier",
			Handler:    _NotifierService_PutNotifier_Handler,
		},
		{
			MethodName: "PostNotifier",
			Handler:    _NotifierService_PostNotifier_Handler,
		},
		{
			MethodName: "TestNotifier",
			Handler:    _NotifierService_TestNotifier_Handler,
		},
		{
			MethodName: "DeleteNotifier",
			Handler:    _NotifierService_DeleteNotifier_Handler,
		},
		{
			MethodName: "UpdateNotifier",
			Handler:    _NotifierService_UpdateNotifier_Handler,
		},
		{
			MethodName: "TestUpdatedNotifier",
			Handler:    _NotifierService_TestUpdatedNotifier_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/v1/notifier_service.proto",
}

func (m *GetNotifiersRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetNotifiersRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetNotifiersRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintNotifierService(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintNotifierService(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetNotifiersResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetNotifiersResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetNotifiersResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Notifiers) > 0 {
		for iNdEx := len(m.Notifiers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Notifiers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintNotifierService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *DeleteNotifierRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeleteNotifierRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeleteNotifierRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Force {
		i--
		if m.Force {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintNotifierService(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *UpdateNotifierRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpdateNotifierRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UpdateNotifierRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.UpdatePassword {
		i--
		if m.UpdatePassword {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if m.Notifier != nil {
		{
			size, err := m.Notifier.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintNotifierService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintNotifierService(dAtA []byte, offset int, v uint64) int {
	offset -= sovNotifierService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *GetNotifiersRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovNotifierService(uint64(l))
	}
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovNotifierService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetNotifiersResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Notifiers) > 0 {
		for _, e := range m.Notifiers {
			l = e.Size()
			n += 1 + l + sovNotifierService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeleteNotifierRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovNotifierService(uint64(l))
	}
	if m.Force {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *UpdateNotifierRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Notifier != nil {
		l = m.Notifier.Size()
		n += 1 + l + sovNotifierService(uint64(l))
	}
	if m.UpdatePassword {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovNotifierService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozNotifierService(x uint64) (n int) {
	return sovNotifierService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *GetNotifiersRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNotifierService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetNotifiersRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetNotifiersRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNotifierService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNotifierService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNotifierService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNotifierService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNotifierService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNotifierService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNotifierService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNotifierService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetNotifiersResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNotifierService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetNotifiersResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetNotifiersResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Notifiers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNotifierService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNotifierService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNotifierService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Notifiers = append(m.Notifiers, &storage.Notifier{})
			if err := m.Notifiers[len(m.Notifiers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNotifierService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNotifierService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeleteNotifierRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNotifierService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeleteNotifierRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeleteNotifierRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNotifierService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNotifierService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNotifierService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Force", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNotifierService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Force = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipNotifierService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNotifierService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateNotifierRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNotifierService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateNotifierRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateNotifierRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Notifier", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNotifierService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNotifierService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNotifierService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Notifier == nil {
				m.Notifier = &storage.Notifier{}
			}
			if err := m.Notifier.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpdatePassword", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNotifierService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UpdatePassword = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipNotifierService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNotifierService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipNotifierService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowNotifierService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowNotifierService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowNotifierService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthNotifierService
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupNotifierService
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthNotifierService
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthNotifierService        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowNotifierService          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupNotifierService = fmt.Errorf("proto: unexpected end of group")
)
