// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api/v1/pod_service.proto

package v1

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	storage "github.com/stackrox/rox/generated/storage"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type PodsResponse struct {
	Pods                 []*storage.Pod `protobuf:"bytes,1,rep,name=pods,proto3" json:"pods,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *PodsResponse) Reset()         { *m = PodsResponse{} }
func (m *PodsResponse) String() string { return proto.CompactTextString(m) }
func (*PodsResponse) ProtoMessage()    {}
func (*PodsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5092c07627247a99, []int{0}
}
func (m *PodsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PodsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PodsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PodsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodsResponse.Merge(m, src)
}
func (m *PodsResponse) XXX_Size() int {
	return m.Size()
}
func (m *PodsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PodsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PodsResponse proto.InternalMessageInfo

func (m *PodsResponse) GetPods() []*storage.Pod {
	if m != nil {
		return m.Pods
	}
	return nil
}

func (m *PodsResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *PodsResponse) Clone() *PodsResponse {
	if m == nil {
		return nil
	}
	cloned := new(PodsResponse)
	*cloned = *m

	if m.Pods != nil {
		cloned.Pods = make([]*storage.Pod, len(m.Pods))
		for idx, v := range m.Pods {
			cloned.Pods[idx] = v.Clone()
		}
	}
	return cloned
}

func init() {
	proto.RegisterType((*PodsResponse)(nil), "v1.PodsResponse")
}

func init() { proto.RegisterFile("api/v1/pod_service.proto", fileDescriptor_5092c07627247a99) }

var fileDescriptor_5092c07627247a99 = []byte{
	// 255 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x54, 0x8f, 0xb1, 0x4e, 0xc3, 0x30,
	0x10, 0x86, 0x9b, 0x80, 0x00, 0x99, 0x0c, 0x55, 0xa6, 0x28, 0xa0, 0xa8, 0xea, 0xc4, 0xe4, 0xe0,
	0x32, 0xb2, 0xb1, 0x20, 0xb6, 0x10, 0x16, 0xc4, 0x82, 0x4c, 0x7c, 0x0a, 0x16, 0xc5, 0x67, 0xf9,
	0x8c, 0xa1, 0x2b, 0xaf, 0xc0, 0xc2, 0x23, 0x31, 0x22, 0xf1, 0x02, 0x28, 0xf0, 0x20, 0x28, 0x4d,
	0x06, 0x3a, 0xde, 0xfd, 0xff, 0xf7, 0xe9, 0x8e, 0x65, 0xd2, 0xea, 0x32, 0x88, 0xd2, 0xa2, 0xba,
	0x25, 0x70, 0x41, 0x37, 0xc0, 0xad, 0x43, 0x8f, 0x69, 0x1c, 0x44, 0x7e, 0xd8, 0x22, 0xb6, 0x4b,
	0x28, 0xfb, 0x92, 0x34, 0x06, 0xbd, 0xf4, 0x1a, 0x0d, 0x0d, 0x8d, 0xfc, 0x60, 0x64, 0x09, 0xa4,
	0x6b, 0xee, 0x37, 0xf1, 0x3c, 0x23, 0x8f, 0x4e, 0xb6, 0x50, 0x2a, 0xb0, 0x4b, 0x5c, 0x3d, 0x82,
	0xf1, 0x43, 0x32, 0x3f, 0x66, 0x49, 0x85, 0x8a, 0x6a, 0x20, 0x8b, 0x86, 0x20, 0x9d, 0xb1, 0x6d,
	0x8b, 0x8a, 0xb2, 0x68, 0xb6, 0x75, 0xb4, 0xbf, 0x48, 0xf8, 0x08, 0xf2, 0x0a, 0x55, 0xbd, 0x4e,
	0x16, 0x17, 0x8c, 0x55, 0xa8, 0xae, 0x06, 0x7f, 0x7a, 0xca, 0x76, 0xcf, 0xc1, 0xf7, 0x8a, 0x34,
	0xe1, 0x41, 0xf0, 0x5a, 0x3e, 0x5f, 0x3e, 0x81, 0x5b, 0xe5, 0xd3, 0x7e, 0xfa, 0xaf, 0x9e, 0x4f,
	0x5f, 0xbf, 0x7e, 0xdf, 0x62, 0x96, 0xee, 0x8d, 0x2f, 0xd2, 0x19, 0xff, 0xe8, 0x8a, 0xe8, 0xb3,
	0x2b, 0xa2, 0xef, 0xae, 0x88, 0xde, 0x7f, 0x8a, 0x09, 0xcb, 0x34, 0x72, 0xf2, 0xb2, 0x79, 0x70,
	0xf8, 0x32, 0x5c, 0xc8, 0xa5, 0xd5, 0x3c, 0x88, 0x9b, 0x38, 0x88, 0xeb, 0xc9, 0xdd, 0xce, 0x7a,
	0x77, 0xf2, 0x17, 0x00, 0x00, 0xff, 0xff, 0xa2, 0x8f, 0x9c, 0x79, 0x2a, 0x01, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// PodServiceClient is the client API for PodService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConnInterface.NewStream.
type PodServiceClient interface {
	// GetPods returns the pods.
	GetPods(ctx context.Context, in *RawQuery, opts ...grpc.CallOption) (*PodsResponse, error)
}

type podServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewPodServiceClient(cc grpc.ClientConnInterface) PodServiceClient {
	return &podServiceClient{cc}
}

func (c *podServiceClient) GetPods(ctx context.Context, in *RawQuery, opts ...grpc.CallOption) (*PodsResponse, error) {
	out := new(PodsResponse)
	err := c.cc.Invoke(ctx, "/v1.PodService/GetPods", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PodServiceServer is the server API for PodService service.
type PodServiceServer interface {
	// GetPods returns the pods.
	GetPods(context.Context, *RawQuery) (*PodsResponse, error)
}

// UnimplementedPodServiceServer can be embedded to have forward compatible implementations.
type UnimplementedPodServiceServer struct {
}

func (*UnimplementedPodServiceServer) GetPods(ctx context.Context, req *RawQuery) (*PodsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPods not implemented")
}

func RegisterPodServiceServer(s *grpc.Server, srv PodServiceServer) {
	s.RegisterService(&_PodService_serviceDesc, srv)
}

func _PodService_GetPods_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RawQuery)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PodServiceServer).GetPods(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.PodService/GetPods",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PodServiceServer).GetPods(ctx, req.(*RawQuery))
	}
	return interceptor(ctx, in, info, handler)
}

var _PodService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1.PodService",
	HandlerType: (*PodServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetPods",
			Handler:    _PodService_GetPods_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/v1/pod_service.proto",
}

func (m *PodsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PodsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PodsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Pods) > 0 {
		for iNdEx := len(m.Pods) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Pods[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPodService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func encodeVarintPodService(dAtA []byte, offset int, v uint64) int {
	offset -= sovPodService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *PodsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Pods) > 0 {
		for _, e := range m.Pods {
			l = e.Size()
			n += 1 + l + sovPodService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovPodService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozPodService(x uint64) (n int) {
	return sovPodService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *PodsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPodService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PodsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PodsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pods", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPodService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPodService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPodService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Pods = append(m.Pods, &storage.Pod{})
			if err := m.Pods[len(m.Pods)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPodService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPodService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipPodService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowPodService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowPodService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowPodService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthPodService
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupPodService
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthPodService
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthPodService        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowPodService          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupPodService = fmt.Errorf("proto: unexpected end of group")
)
