// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api/v1/process_baseline_service.proto

package v1

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	storage "github.com/stackrox/rox/generated/storage"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type GetProcessBaselineRequest struct {
	Key                  *storage.ProcessBaselineKey `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *GetProcessBaselineRequest) Reset()         { *m = GetProcessBaselineRequest{} }
func (m *GetProcessBaselineRequest) String() string { return proto.CompactTextString(m) }
func (*GetProcessBaselineRequest) ProtoMessage()    {}
func (*GetProcessBaselineRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7b38ebbdd88dd918, []int{0}
}
func (m *GetProcessBaselineRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetProcessBaselineRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetProcessBaselineRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetProcessBaselineRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetProcessBaselineRequest.Merge(m, src)
}
func (m *GetProcessBaselineRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetProcessBaselineRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetProcessBaselineRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetProcessBaselineRequest proto.InternalMessageInfo

func (m *GetProcessBaselineRequest) GetKey() *storage.ProcessBaselineKey {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *GetProcessBaselineRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetProcessBaselineRequest) Clone() *GetProcessBaselineRequest {
	if m == nil {
		return nil
	}
	cloned := new(GetProcessBaselineRequest)
	*cloned = *m

	cloned.Key = m.Key.Clone()
	return cloned
}

type UpdateProcessBaselinesRequest struct {
	Keys                 []*storage.ProcessBaselineKey `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
	AddElements          []*storage.BaselineItem       `protobuf:"bytes,2,rep,name=add_elements,json=addElements,proto3" json:"add_elements,omitempty"`
	RemoveElements       []*storage.BaselineItem       `protobuf:"bytes,3,rep,name=remove_elements,json=removeElements,proto3" json:"remove_elements,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *UpdateProcessBaselinesRequest) Reset()         { *m = UpdateProcessBaselinesRequest{} }
func (m *UpdateProcessBaselinesRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateProcessBaselinesRequest) ProtoMessage()    {}
func (*UpdateProcessBaselinesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7b38ebbdd88dd918, []int{1}
}
func (m *UpdateProcessBaselinesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpdateProcessBaselinesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UpdateProcessBaselinesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UpdateProcessBaselinesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateProcessBaselinesRequest.Merge(m, src)
}
func (m *UpdateProcessBaselinesRequest) XXX_Size() int {
	return m.Size()
}
func (m *UpdateProcessBaselinesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateProcessBaselinesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateProcessBaselinesRequest proto.InternalMessageInfo

func (m *UpdateProcessBaselinesRequest) GetKeys() []*storage.ProcessBaselineKey {
	if m != nil {
		return m.Keys
	}
	return nil
}

func (m *UpdateProcessBaselinesRequest) GetAddElements() []*storage.BaselineItem {
	if m != nil {
		return m.AddElements
	}
	return nil
}

func (m *UpdateProcessBaselinesRequest) GetRemoveElements() []*storage.BaselineItem {
	if m != nil {
		return m.RemoveElements
	}
	return nil
}

func (m *UpdateProcessBaselinesRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *UpdateProcessBaselinesRequest) Clone() *UpdateProcessBaselinesRequest {
	if m == nil {
		return nil
	}
	cloned := new(UpdateProcessBaselinesRequest)
	*cloned = *m

	if m.Keys != nil {
		cloned.Keys = make([]*storage.ProcessBaselineKey, len(m.Keys))
		for idx, v := range m.Keys {
			cloned.Keys[idx] = v.Clone()
		}
	}
	if m.AddElements != nil {
		cloned.AddElements = make([]*storage.BaselineItem, len(m.AddElements))
		for idx, v := range m.AddElements {
			cloned.AddElements[idx] = v.Clone()
		}
	}
	if m.RemoveElements != nil {
		cloned.RemoveElements = make([]*storage.BaselineItem, len(m.RemoveElements))
		for idx, v := range m.RemoveElements {
			cloned.RemoveElements[idx] = v.Clone()
		}
	}
	return cloned
}

type ProcessBaselinesResponse struct {
	Baselines            []*storage.ProcessBaseline `protobuf:"bytes,1,rep,name=baselines,proto3" json:"baselines,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *ProcessBaselinesResponse) Reset()         { *m = ProcessBaselinesResponse{} }
func (m *ProcessBaselinesResponse) String() string { return proto.CompactTextString(m) }
func (*ProcessBaselinesResponse) ProtoMessage()    {}
func (*ProcessBaselinesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_7b38ebbdd88dd918, []int{2}
}
func (m *ProcessBaselinesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProcessBaselinesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProcessBaselinesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProcessBaselinesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBaselinesResponse.Merge(m, src)
}
func (m *ProcessBaselinesResponse) XXX_Size() int {
	return m.Size()
}
func (m *ProcessBaselinesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBaselinesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBaselinesResponse proto.InternalMessageInfo

func (m *ProcessBaselinesResponse) GetBaselines() []*storage.ProcessBaseline {
	if m != nil {
		return m.Baselines
	}
	return nil
}

func (m *ProcessBaselinesResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ProcessBaselinesResponse) Clone() *ProcessBaselinesResponse {
	if m == nil {
		return nil
	}
	cloned := new(ProcessBaselinesResponse)
	*cloned = *m

	if m.Baselines != nil {
		cloned.Baselines = make([]*storage.ProcessBaseline, len(m.Baselines))
		for idx, v := range m.Baselines {
			cloned.Baselines[idx] = v.Clone()
		}
	}
	return cloned
}

type ProcessBaselineUpdateError struct {
	Error                string                      `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	Key                  *storage.ProcessBaselineKey `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *ProcessBaselineUpdateError) Reset()         { *m = ProcessBaselineUpdateError{} }
func (m *ProcessBaselineUpdateError) String() string { return proto.CompactTextString(m) }
func (*ProcessBaselineUpdateError) ProtoMessage()    {}
func (*ProcessBaselineUpdateError) Descriptor() ([]byte, []int) {
	return fileDescriptor_7b38ebbdd88dd918, []int{3}
}
func (m *ProcessBaselineUpdateError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProcessBaselineUpdateError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProcessBaselineUpdateError.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProcessBaselineUpdateError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBaselineUpdateError.Merge(m, src)
}
func (m *ProcessBaselineUpdateError) XXX_Size() int {
	return m.Size()
}
func (m *ProcessBaselineUpdateError) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBaselineUpdateError.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBaselineUpdateError proto.InternalMessageInfo

func (m *ProcessBaselineUpdateError) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *ProcessBaselineUpdateError) GetKey() *storage.ProcessBaselineKey {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *ProcessBaselineUpdateError) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ProcessBaselineUpdateError) Clone() *ProcessBaselineUpdateError {
	if m == nil {
		return nil
	}
	cloned := new(ProcessBaselineUpdateError)
	*cloned = *m

	cloned.Key = m.Key.Clone()
	return cloned
}

type UpdateProcessBaselinesResponse struct {
	Baselines            []*storage.ProcessBaseline    `protobuf:"bytes,1,rep,name=baselines,proto3" json:"baselines,omitempty"`
	Errors               []*ProcessBaselineUpdateError `protobuf:"bytes,2,rep,name=errors,proto3" json:"errors,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *UpdateProcessBaselinesResponse) Reset()         { *m = UpdateProcessBaselinesResponse{} }
func (m *UpdateProcessBaselinesResponse) String() string { return proto.CompactTextString(m) }
func (*UpdateProcessBaselinesResponse) ProtoMessage()    {}
func (*UpdateProcessBaselinesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_7b38ebbdd88dd918, []int{4}
}
func (m *UpdateProcessBaselinesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpdateProcessBaselinesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UpdateProcessBaselinesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UpdateProcessBaselinesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateProcessBaselinesResponse.Merge(m, src)
}
func (m *UpdateProcessBaselinesResponse) XXX_Size() int {
	return m.Size()
}
func (m *UpdateProcessBaselinesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateProcessBaselinesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateProcessBaselinesResponse proto.InternalMessageInfo

func (m *UpdateProcessBaselinesResponse) GetBaselines() []*storage.ProcessBaseline {
	if m != nil {
		return m.Baselines
	}
	return nil
}

func (m *UpdateProcessBaselinesResponse) GetErrors() []*ProcessBaselineUpdateError {
	if m != nil {
		return m.Errors
	}
	return nil
}

func (m *UpdateProcessBaselinesResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *UpdateProcessBaselinesResponse) Clone() *UpdateProcessBaselinesResponse {
	if m == nil {
		return nil
	}
	cloned := new(UpdateProcessBaselinesResponse)
	*cloned = *m

	if m.Baselines != nil {
		cloned.Baselines = make([]*storage.ProcessBaseline, len(m.Baselines))
		for idx, v := range m.Baselines {
			cloned.Baselines[idx] = v.Clone()
		}
	}
	if m.Errors != nil {
		cloned.Errors = make([]*ProcessBaselineUpdateError, len(m.Errors))
		for idx, v := range m.Errors {
			cloned.Errors[idx] = v.Clone()
		}
	}
	return cloned
}

type LockProcessBaselinesRequest struct {
	Keys                 []*storage.ProcessBaselineKey `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
	Locked               bool                          `protobuf:"varint,2,opt,name=locked,proto3" json:"locked,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *LockProcessBaselinesRequest) Reset()         { *m = LockProcessBaselinesRequest{} }
func (m *LockProcessBaselinesRequest) String() string { return proto.CompactTextString(m) }
func (*LockProcessBaselinesRequest) ProtoMessage()    {}
func (*LockProcessBaselinesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7b38ebbdd88dd918, []int{5}
}
func (m *LockProcessBaselinesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LockProcessBaselinesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LockProcessBaselinesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LockProcessBaselinesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LockProcessBaselinesRequest.Merge(m, src)
}
func (m *LockProcessBaselinesRequest) XXX_Size() int {
	return m.Size()
}
func (m *LockProcessBaselinesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_LockProcessBaselinesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_LockProcessBaselinesRequest proto.InternalMessageInfo

func (m *LockProcessBaselinesRequest) GetKeys() []*storage.ProcessBaselineKey {
	if m != nil {
		return m.Keys
	}
	return nil
}

func (m *LockProcessBaselinesRequest) GetLocked() bool {
	if m != nil {
		return m.Locked
	}
	return false
}

func (m *LockProcessBaselinesRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *LockProcessBaselinesRequest) Clone() *LockProcessBaselinesRequest {
	if m == nil {
		return nil
	}
	cloned := new(LockProcessBaselinesRequest)
	*cloned = *m

	if m.Keys != nil {
		cloned.Keys = make([]*storage.ProcessBaselineKey, len(m.Keys))
		for idx, v := range m.Keys {
			cloned.Keys[idx] = v.Clone()
		}
	}
	return cloned
}

type DeleteProcessBaselinesRequest struct {
	Query                string   `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	Confirm              bool     `protobuf:"varint,2,opt,name=confirm,proto3" json:"confirm,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteProcessBaselinesRequest) Reset()         { *m = DeleteProcessBaselinesRequest{} }
func (m *DeleteProcessBaselinesRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteProcessBaselinesRequest) ProtoMessage()    {}
func (*DeleteProcessBaselinesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7b38ebbdd88dd918, []int{6}
}
func (m *DeleteProcessBaselinesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeleteProcessBaselinesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeleteProcessBaselinesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeleteProcessBaselinesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteProcessBaselinesRequest.Merge(m, src)
}
func (m *DeleteProcessBaselinesRequest) XXX_Size() int {
	return m.Size()
}
func (m *DeleteProcessBaselinesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteProcessBaselinesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteProcessBaselinesRequest proto.InternalMessageInfo

func (m *DeleteProcessBaselinesRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *DeleteProcessBaselinesRequest) GetConfirm() bool {
	if m != nil {
		return m.Confirm
	}
	return false
}

func (m *DeleteProcessBaselinesRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *DeleteProcessBaselinesRequest) Clone() *DeleteProcessBaselinesRequest {
	if m == nil {
		return nil
	}
	cloned := new(DeleteProcessBaselinesRequest)
	*cloned = *m

	return cloned
}

type DeleteProcessBaselinesResponse struct {
	NumDeleted           int32    `protobuf:"varint,1,opt,name=num_deleted,json=numDeleted,proto3" json:"num_deleted,omitempty"`
	DryRun               bool     `protobuf:"varint,2,opt,name=dry_run,json=dryRun,proto3" json:"dry_run,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteProcessBaselinesResponse) Reset()         { *m = DeleteProcessBaselinesResponse{} }
func (m *DeleteProcessBaselinesResponse) String() string { return proto.CompactTextString(m) }
func (*DeleteProcessBaselinesResponse) ProtoMessage()    {}
func (*DeleteProcessBaselinesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_7b38ebbdd88dd918, []int{7}
}
func (m *DeleteProcessBaselinesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeleteProcessBaselinesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeleteProcessBaselinesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeleteProcessBaselinesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteProcessBaselinesResponse.Merge(m, src)
}
func (m *DeleteProcessBaselinesResponse) XXX_Size() int {
	return m.Size()
}
func (m *DeleteProcessBaselinesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteProcessBaselinesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteProcessBaselinesResponse proto.InternalMessageInfo

func (m *DeleteProcessBaselinesResponse) GetNumDeleted() int32 {
	if m != nil {
		return m.NumDeleted
	}
	return 0
}

func (m *DeleteProcessBaselinesResponse) GetDryRun() bool {
	if m != nil {
		return m.DryRun
	}
	return false
}

func (m *DeleteProcessBaselinesResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *DeleteProcessBaselinesResponse) Clone() *DeleteProcessBaselinesResponse {
	if m == nil {
		return nil
	}
	cloned := new(DeleteProcessBaselinesResponse)
	*cloned = *m

	return cloned
}

func init() {
	proto.RegisterType((*GetProcessBaselineRequest)(nil), "v1.GetProcessBaselineRequest")
	proto.RegisterType((*UpdateProcessBaselinesRequest)(nil), "v1.UpdateProcessBaselinesRequest")
	proto.RegisterType((*ProcessBaselinesResponse)(nil), "v1.ProcessBaselinesResponse")
	proto.RegisterType((*ProcessBaselineUpdateError)(nil), "v1.ProcessBaselineUpdateError")
	proto.RegisterType((*UpdateProcessBaselinesResponse)(nil), "v1.UpdateProcessBaselinesResponse")
	proto.RegisterType((*LockProcessBaselinesRequest)(nil), "v1.LockProcessBaselinesRequest")
	proto.RegisterType((*DeleteProcessBaselinesRequest)(nil), "v1.DeleteProcessBaselinesRequest")
	proto.RegisterType((*DeleteProcessBaselinesResponse)(nil), "v1.DeleteProcessBaselinesResponse")
}

func init() {
	proto.RegisterFile("api/v1/process_baseline_service.proto", fileDescriptor_7b38ebbdd88dd918)
}

var fileDescriptor_7b38ebbdd88dd918 = []byte{
	// 596 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x54, 0xdf, 0x8a, 0xd3, 0x4e,
	0x18, 0xdd, 0x74, 0xff, 0xfd, 0xf6, 0xeb, 0x0f, 0x85, 0xa1, 0xd6, 0x34, 0xbb, 0x4d, 0x6b, 0x50,
	0x90, 0x05, 0x53, 0xba, 0xc2, 0x22, 0x5e, 0x78, 0xb1, 0xb8, 0x88, 0x7f, 0x40, 0x89, 0x08, 0xb2,
	0x37, 0x25, 0x9b, 0x7c, 0x5b, 0x42, 0x9a, 0x4c, 0x76, 0x26, 0x09, 0xe6, 0x42, 0x50, 0x5f, 0x40,
	0xc1, 0x1b, 0x1f, 0x49, 0xbc, 0x12, 0x7c, 0x01, 0xa9, 0x3e, 0x88, 0x64, 0x26, 0xd9, 0x95, 0x36,
	0x89, 0x0b, 0x7a, 0xd7, 0xe9, 0x9c, 0x73, 0xe6, 0xcc, 0xf9, 0xce, 0x04, 0x6e, 0xd8, 0x91, 0x37,
	0x4a, 0xc7, 0xa3, 0x88, 0x51, 0x07, 0x39, 0x9f, 0x1c, 0xdb, 0x1c, 0x67, 0x5e, 0x88, 0x13, 0x8e,
	0x2c, 0xf5, 0x1c, 0x34, 0x23, 0x46, 0x63, 0x4a, 0x5a, 0xe9, 0x58, 0xdb, 0x99, 0x52, 0x3a, 0x9d,
	0xe1, 0x28, 0x67, 0xd8, 0x61, 0x48, 0x63, 0x3b, 0xf6, 0x68, 0xc8, 0x25, 0x42, 0xd3, 0x79, 0x4c,
	0x99, 0x3d, 0xc5, 0x25, 0x25, 0xb9, 0x6f, 0x3c, 0x82, 0xde, 0x03, 0x8c, 0x9f, 0xc9, 0xcd, 0x83,
	0x62, 0xcf, 0xc2, 0xd3, 0x04, 0x79, 0x4c, 0x6e, 0xc1, 0xaa, 0x8f, 0x99, 0xaa, 0x0c, 0x95, 0x9b,
	0xed, 0xbd, 0x6d, 0xb3, 0x90, 0x32, 0x17, 0xd0, 0x8f, 0x31, 0xb3, 0x72, 0x9c, 0xf1, 0x45, 0x81,
	0xfe, 0x8b, 0xc8, 0xb5, 0x63, 0x5c, 0x40, 0xf0, 0x52, 0x70, 0x04, 0x6b, 0x3e, 0x66, 0x5c, 0x55,
	0x86, 0xab, 0x7f, 0x52, 0x14, 0x40, 0x72, 0x07, 0xfe, 0xb7, 0x5d, 0x77, 0x82, 0x33, 0x0c, 0x30,
	0x8c, 0xb9, 0xda, 0x12, 0xc4, 0x2b, 0x67, 0xc4, 0x92, 0xf1, 0x30, 0xc6, 0xc0, 0x6a, 0xdb, 0xae,
	0x7b, 0x58, 0x20, 0xc9, 0x3d, 0xb8, 0xcc, 0x30, 0xa0, 0x29, 0x9e, 0x93, 0x57, 0x9b, 0xc8, 0x97,
	0x24, 0xba, 0xe4, 0x1b, 0x16, 0xa8, 0xcb, 0xb7, 0xe0, 0x11, 0x0d, 0x39, 0x92, 0x7d, 0xd8, 0x2a,
	0x63, 0x2c, 0xef, 0xa2, 0xd6, 0xdd, 0xc5, 0x3a, 0x87, 0x1a, 0x36, 0x68, 0x0b, 0xbb, 0x32, 0xae,
	0x43, 0xc6, 0x28, 0x23, 0x1d, 0x58, 0xc7, 0xfc, 0x87, 0xc8, 0x7b, 0xcb, 0x92, 0x8b, 0x72, 0x06,
	0xad, 0x0b, 0xce, 0xe0, 0x83, 0x02, 0x7a, 0xdd, 0x0c, 0xfe, 0xce, 0x3d, 0xd9, 0x87, 0x0d, 0x61,
	0xa9, 0x9c, 0x82, 0x6e, 0xa6, 0x63, 0xb3, 0xfe, 0x3e, 0x56, 0x81, 0x36, 0x4e, 0x60, 0xfb, 0x09,
	0x75, 0xfc, 0x7f, 0xd6, 0x89, 0x2e, 0x6c, 0xcc, 0xa8, 0xe3, 0xa3, 0x2b, 0x42, 0xf9, 0xcf, 0x2a,
	0x56, 0xc6, 0x53, 0xe8, 0xdf, 0xc7, 0x19, 0xd6, 0xb7, 0xaf, 0x03, 0xeb, 0xa7, 0x09, 0xb2, 0xac,
	0x0c, 0x58, 0x2c, 0x88, 0x0a, 0x9b, 0x0e, 0x0d, 0x4f, 0x3c, 0x16, 0x14, 0x7a, 0xe5, 0xd2, 0x38,
	0x02, 0xbd, 0x4e, 0xb0, 0x88, 0x72, 0x00, 0xed, 0x30, 0x09, 0x26, 0xae, 0x40, 0xb9, 0x42, 0x77,
	0xdd, 0x82, 0x30, 0x09, 0x24, 0xcf, 0x25, 0x57, 0x61, 0xd3, 0x65, 0xd9, 0x84, 0x25, 0x61, 0x69,
	0xd6, 0x65, 0x99, 0x95, 0x84, 0x7b, 0xef, 0xd7, 0xa0, 0xbb, 0x20, 0xfb, 0x5c, 0x3e, 0x6d, 0x42,
	0x81, 0x2c, 0x3f, 0x49, 0xd2, 0xcf, 0xd3, 0xae, 0x7d, 0xaa, 0x5a, 0xed, 0x04, 0x8d, 0xe1, 0xbb,
	0x6f, 0x3f, 0x3f, 0xb6, 0x34, 0xa2, 0xfe, 0xf6, 0x3d, 0x39, 0x1b, 0xea, 0xc8, 0xc7, 0x8c, 0xbc,
	0x51, 0xa0, 0x5b, 0xdd, 0x19, 0x72, 0x2d, 0x3f, 0xb5, 0xf1, 0x4d, 0x6b, 0x46, 0x13, 0x44, 0xe6,
	0x64, 0x0c, 0x84, 0x87, 0x9e, 0xd6, 0xa9, 0xf2, 0x70, 0x57, 0xd9, 0x25, 0x6f, 0x15, 0xe8, 0x54,
	0x95, 0x84, 0x0c, 0x72, 0xf5, 0x86, 0xfa, 0x5c, 0xe8, 0xf8, 0xeb, 0xe2, 0x78, 0x5d, 0xeb, 0x55,
	0x46, 0x90, 0xd7, 0x27, 0xf7, 0xf0, 0x1a, 0xba, 0xd5, 0xe3, 0x96, 0x29, 0x34, 0x76, 0x4b, 0xda,
	0x68, 0x6e, 0x8b, 0xb1, 0x23, 0x6c, 0x74, 0x77, 0x2b, 0x53, 0x38, 0x30, 0x3f, 0xcf, 0x75, 0xe5,
	0xeb, 0x5c, 0x57, 0xbe, 0xcf, 0x75, 0xe5, 0xd3, 0x0f, 0x7d, 0x05, 0x54, 0x8f, 0x9a, 0x3c, 0xb6,
	0x1d, 0x9f, 0xd1, 0x57, 0xf2, 0x73, 0x6d, 0xda, 0x91, 0x67, 0xa6, 0xe3, 0xa3, 0x56, 0x3a, 0x7e,
	0xb9, 0x72, 0xbc, 0x21, 0xfe, 0xbb, 0xfd, 0x2b, 0x00, 0x00, 0xff, 0xff, 0xf9, 0xc8, 0x1b, 0x3d,
	0x2d, 0x06, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ProcessBaselineServiceClient is the client API for ProcessBaselineService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConnInterface.NewStream.
type ProcessBaselineServiceClient interface {
	// `GetProcessBaselineById` returns the single
	// process baseline referenced by the given ID.
	GetProcessBaseline(ctx context.Context, in *GetProcessBaselineRequest, opts ...grpc.CallOption) (*storage.ProcessBaseline, error)
	// `AddToProcessBaselines` adds a list of process
	// names to each of a list of process baselines.
	UpdateProcessBaselines(ctx context.Context, in *UpdateProcessBaselinesRequest, opts ...grpc.CallOption) (*UpdateProcessBaselinesResponse, error)
	// `LockProcessBaselines` accepts a list of baseline IDs, locks
	// those baselines, and returns the updated baseline objects.
	LockProcessBaselines(ctx context.Context, in *LockProcessBaselinesRequest, opts ...grpc.CallOption) (*UpdateProcessBaselinesResponse, error)
	// `DeleteProcessBaselines` deletes baselines.
	DeleteProcessBaselines(ctx context.Context, in *DeleteProcessBaselinesRequest, opts ...grpc.CallOption) (*DeleteProcessBaselinesResponse, error)
}

type processBaselineServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewProcessBaselineServiceClient(cc grpc.ClientConnInterface) ProcessBaselineServiceClient {
	return &processBaselineServiceClient{cc}
}

func (c *processBaselineServiceClient) GetProcessBaseline(ctx context.Context, in *GetProcessBaselineRequest, opts ...grpc.CallOption) (*storage.ProcessBaseline, error) {
	out := new(storage.ProcessBaseline)
	err := c.cc.Invoke(ctx, "/v1.ProcessBaselineService/GetProcessBaseline", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *processBaselineServiceClient) UpdateProcessBaselines(ctx context.Context, in *UpdateProcessBaselinesRequest, opts ...grpc.CallOption) (*UpdateProcessBaselinesResponse, error) {
	out := new(UpdateProcessBaselinesResponse)
	err := c.cc.Invoke(ctx, "/v1.ProcessBaselineService/UpdateProcessBaselines", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *processBaselineServiceClient) LockProcessBaselines(ctx context.Context, in *LockProcessBaselinesRequest, opts ...grpc.CallOption) (*UpdateProcessBaselinesResponse, error) {
	out := new(UpdateProcessBaselinesResponse)
	err := c.cc.Invoke(ctx, "/v1.ProcessBaselineService/LockProcessBaselines", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *processBaselineServiceClient) DeleteProcessBaselines(ctx context.Context, in *DeleteProcessBaselinesRequest, opts ...grpc.CallOption) (*DeleteProcessBaselinesResponse, error) {
	out := new(DeleteProcessBaselinesResponse)
	err := c.cc.Invoke(ctx, "/v1.ProcessBaselineService/DeleteProcessBaselines", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ProcessBaselineServiceServer is the server API for ProcessBaselineService service.
type ProcessBaselineServiceServer interface {
	// `GetProcessBaselineById` returns the single
	// process baseline referenced by the given ID.
	GetProcessBaseline(context.Context, *GetProcessBaselineRequest) (*storage.ProcessBaseline, error)
	// `AddToProcessBaselines` adds a list of process
	// names to each of a list of process baselines.
	UpdateProcessBaselines(context.Context, *UpdateProcessBaselinesRequest) (*UpdateProcessBaselinesResponse, error)
	// `LockProcessBaselines` accepts a list of baseline IDs, locks
	// those baselines, and returns the updated baseline objects.
	LockProcessBaselines(context.Context, *LockProcessBaselinesRequest) (*UpdateProcessBaselinesResponse, error)
	// `DeleteProcessBaselines` deletes baselines.
	DeleteProcessBaselines(context.Context, *DeleteProcessBaselinesRequest) (*DeleteProcessBaselinesResponse, error)
}

// UnimplementedProcessBaselineServiceServer can be embedded to have forward compatible implementations.
type UnimplementedProcessBaselineServiceServer struct {
}

func (*UnimplementedProcessBaselineServiceServer) GetProcessBaseline(ctx context.Context, req *GetProcessBaselineRequest) (*storage.ProcessBaseline, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProcessBaseline not implemented")
}
func (*UnimplementedProcessBaselineServiceServer) UpdateProcessBaselines(ctx context.Context, req *UpdateProcessBaselinesRequest) (*UpdateProcessBaselinesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateProcessBaselines not implemented")
}
func (*UnimplementedProcessBaselineServiceServer) LockProcessBaselines(ctx context.Context, req *LockProcessBaselinesRequest) (*UpdateProcessBaselinesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LockProcessBaselines not implemented")
}
func (*UnimplementedProcessBaselineServiceServer) DeleteProcessBaselines(ctx context.Context, req *DeleteProcessBaselinesRequest) (*DeleteProcessBaselinesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteProcessBaselines not implemented")
}

func RegisterProcessBaselineServiceServer(s *grpc.Server, srv ProcessBaselineServiceServer) {
	s.RegisterService(&_ProcessBaselineService_serviceDesc, srv)
}

func _ProcessBaselineService_GetProcessBaseline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProcessBaselineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProcessBaselineServiceServer).GetProcessBaseline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ProcessBaselineService/GetProcessBaseline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProcessBaselineServiceServer).GetProcessBaseline(ctx, req.(*GetProcessBaselineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProcessBaselineService_UpdateProcessBaselines_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateProcessBaselinesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProcessBaselineServiceServer).UpdateProcessBaselines(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ProcessBaselineService/UpdateProcessBaselines",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProcessBaselineServiceServer).UpdateProcessBaselines(ctx, req.(*UpdateProcessBaselinesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProcessBaselineService_LockProcessBaselines_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LockProcessBaselinesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProcessBaselineServiceServer).LockProcessBaselines(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ProcessBaselineService/LockProcessBaselines",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProcessBaselineServiceServer).LockProcessBaselines(ctx, req.(*LockProcessBaselinesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProcessBaselineService_DeleteProcessBaselines_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteProcessBaselinesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProcessBaselineServiceServer).DeleteProcessBaselines(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ProcessBaselineService/DeleteProcessBaselines",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProcessBaselineServiceServer).DeleteProcessBaselines(ctx, req.(*DeleteProcessBaselinesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ProcessBaselineService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1.ProcessBaselineService",
	HandlerType: (*ProcessBaselineServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetProcessBaseline",
			Handler:    _ProcessBaselineService_GetProcessBaseline_Handler,
		},
		{
			MethodName: "UpdateProcessBaselines",
			Handler:    _ProcessBaselineService_UpdateProcessBaselines_Handler,
		},
		{
			MethodName: "LockProcessBaselines",
			Handler:    _ProcessBaselineService_LockProcessBaselines_Handler,
		},
		{
			MethodName: "DeleteProcessBaselines",
			Handler:    _ProcessBaselineService_DeleteProcessBaselines_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/v1/process_baseline_service.proto",
}

func (m *GetProcessBaselineRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetProcessBaselineRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetProcessBaselineRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Key != nil {
		{
			size, err := m.Key.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProcessBaselineService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *UpdateProcessBaselinesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpdateProcessBaselinesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UpdateProcessBaselinesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.RemoveElements) > 0 {
		for iNdEx := len(m.RemoveElements) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.RemoveElements[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintProcessBaselineService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.AddElements) > 0 {
		for iNdEx := len(m.AddElements) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.AddElements[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintProcessBaselineService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Keys) > 0 {
		for iNdEx := len(m.Keys) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Keys[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintProcessBaselineService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ProcessBaselinesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProcessBaselinesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProcessBaselinesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Baselines) > 0 {
		for iNdEx := len(m.Baselines) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Baselines[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintProcessBaselineService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ProcessBaselineUpdateError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProcessBaselineUpdateError) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProcessBaselineUpdateError) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Key != nil {
		{
			size, err := m.Key.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintProcessBaselineService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Error) > 0 {
		i -= len(m.Error)
		copy(dAtA[i:], m.Error)
		i = encodeVarintProcessBaselineService(dAtA, i, uint64(len(m.Error)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *UpdateProcessBaselinesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpdateProcessBaselinesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UpdateProcessBaselinesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Errors) > 0 {
		for iNdEx := len(m.Errors) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Errors[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintProcessBaselineService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Baselines) > 0 {
		for iNdEx := len(m.Baselines) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Baselines[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintProcessBaselineService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *LockProcessBaselinesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LockProcessBaselinesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LockProcessBaselinesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Locked {
		i--
		if m.Locked {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.Keys) > 0 {
		for iNdEx := len(m.Keys) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Keys[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintProcessBaselineService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *DeleteProcessBaselinesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeleteProcessBaselinesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeleteProcessBaselinesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Confirm {
		i--
		if m.Confirm {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.Query) > 0 {
		i -= len(m.Query)
		copy(dAtA[i:], m.Query)
		i = encodeVarintProcessBaselineService(dAtA, i, uint64(len(m.Query)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DeleteProcessBaselinesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeleteProcessBaselinesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeleteProcessBaselinesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.DryRun {
		i--
		if m.DryRun {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if m.NumDeleted != 0 {
		i = encodeVarintProcessBaselineService(dAtA, i, uint64(m.NumDeleted))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintProcessBaselineService(dAtA []byte, offset int, v uint64) int {
	offset -= sovProcessBaselineService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *GetProcessBaselineRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Key != nil {
		l = m.Key.Size()
		n += 1 + l + sovProcessBaselineService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *UpdateProcessBaselinesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Keys) > 0 {
		for _, e := range m.Keys {
			l = e.Size()
			n += 1 + l + sovProcessBaselineService(uint64(l))
		}
	}
	if len(m.AddElements) > 0 {
		for _, e := range m.AddElements {
			l = e.Size()
			n += 1 + l + sovProcessBaselineService(uint64(l))
		}
	}
	if len(m.RemoveElements) > 0 {
		for _, e := range m.RemoveElements {
			l = e.Size()
			n += 1 + l + sovProcessBaselineService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ProcessBaselinesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Baselines) > 0 {
		for _, e := range m.Baselines {
			l = e.Size()
			n += 1 + l + sovProcessBaselineService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ProcessBaselineUpdateError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovProcessBaselineService(uint64(l))
	}
	if m.Key != nil {
		l = m.Key.Size()
		n += 1 + l + sovProcessBaselineService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *UpdateProcessBaselinesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Baselines) > 0 {
		for _, e := range m.Baselines {
			l = e.Size()
			n += 1 + l + sovProcessBaselineService(uint64(l))
		}
	}
	if len(m.Errors) > 0 {
		for _, e := range m.Errors {
			l = e.Size()
			n += 1 + l + sovProcessBaselineService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LockProcessBaselinesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Keys) > 0 {
		for _, e := range m.Keys {
			l = e.Size()
			n += 1 + l + sovProcessBaselineService(uint64(l))
		}
	}
	if m.Locked {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeleteProcessBaselinesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Query)
	if l > 0 {
		n += 1 + l + sovProcessBaselineService(uint64(l))
	}
	if m.Confirm {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeleteProcessBaselinesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.NumDeleted != 0 {
		n += 1 + sovProcessBaselineService(uint64(m.NumDeleted))
	}
	if m.DryRun {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovProcessBaselineService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozProcessBaselineService(x uint64) (n int) {
	return sovProcessBaselineService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *GetProcessBaselineRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessBaselineService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetProcessBaselineRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetProcessBaselineRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessBaselineService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessBaselineService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProcessBaselineService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Key == nil {
				m.Key = &storage.ProcessBaselineKey{}
			}
			if err := m.Key.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessBaselineService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProcessBaselineService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateProcessBaselinesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessBaselineService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateProcessBaselinesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateProcessBaselinesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Keys", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessBaselineService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessBaselineService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProcessBaselineService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Keys = append(m.Keys, &storage.ProcessBaselineKey{})
			if err := m.Keys[len(m.Keys)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AddElements", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessBaselineService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessBaselineService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProcessBaselineService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AddElements = append(m.AddElements, &storage.BaselineItem{})
			if err := m.AddElements[len(m.AddElements)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RemoveElements", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessBaselineService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessBaselineService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProcessBaselineService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RemoveElements = append(m.RemoveElements, &storage.BaselineItem{})
			if err := m.RemoveElements[len(m.RemoveElements)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessBaselineService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProcessBaselineService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProcessBaselinesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessBaselineService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProcessBaselinesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProcessBaselinesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Baselines", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessBaselineService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessBaselineService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProcessBaselineService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Baselines = append(m.Baselines, &storage.ProcessBaseline{})
			if err := m.Baselines[len(m.Baselines)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessBaselineService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProcessBaselineService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProcessBaselineUpdateError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessBaselineService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProcessBaselineUpdateError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProcessBaselineUpdateError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessBaselineService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProcessBaselineService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProcessBaselineService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessBaselineService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessBaselineService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProcessBaselineService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Key == nil {
				m.Key = &storage.ProcessBaselineKey{}
			}
			if err := m.Key.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessBaselineService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProcessBaselineService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateProcessBaselinesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessBaselineService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateProcessBaselinesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateProcessBaselinesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Baselines", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessBaselineService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessBaselineService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProcessBaselineService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Baselines = append(m.Baselines, &storage.ProcessBaseline{})
			if err := m.Baselines[len(m.Baselines)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Errors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessBaselineService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessBaselineService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProcessBaselineService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Errors = append(m.Errors, &ProcessBaselineUpdateError{})
			if err := m.Errors[len(m.Errors)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessBaselineService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProcessBaselineService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LockProcessBaselinesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessBaselineService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LockProcessBaselinesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LockProcessBaselinesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Keys", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessBaselineService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessBaselineService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProcessBaselineService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Keys = append(m.Keys, &storage.ProcessBaselineKey{})
			if err := m.Keys[len(m.Keys)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Locked", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessBaselineService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Locked = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipProcessBaselineService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProcessBaselineService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeleteProcessBaselinesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessBaselineService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeleteProcessBaselinesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeleteProcessBaselinesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessBaselineService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProcessBaselineService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProcessBaselineService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Query = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Confirm", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessBaselineService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Confirm = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipProcessBaselineService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProcessBaselineService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeleteProcessBaselinesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessBaselineService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeleteProcessBaselinesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeleteProcessBaselinesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumDeleted", wireType)
			}
			m.NumDeleted = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessBaselineService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumDeleted |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DryRun", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessBaselineService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DryRun = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipProcessBaselineService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProcessBaselineService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipProcessBaselineService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowProcessBaselineService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowProcessBaselineService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowProcessBaselineService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthProcessBaselineService
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupProcessBaselineService
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthProcessBaselineService
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthProcessBaselineService        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowProcessBaselineService          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupProcessBaselineService = fmt.Errorf("proto: unexpected end of group")
)
