// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api/v1/process_service.proto

package v1

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	storage "github.com/stackrox/rox/generated/storage"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type GetProcessesByDeploymentRequest struct {
	DeploymentId         string   `protobuf:"bytes,1,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetProcessesByDeploymentRequest) Reset()         { *m = GetProcessesByDeploymentRequest{} }
func (m *GetProcessesByDeploymentRequest) String() string { return proto.CompactTextString(m) }
func (*GetProcessesByDeploymentRequest) ProtoMessage()    {}
func (*GetProcessesByDeploymentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_38d7d55baf8cc025, []int{0}
}
func (m *GetProcessesByDeploymentRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetProcessesByDeploymentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetProcessesByDeploymentRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetProcessesByDeploymentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetProcessesByDeploymentRequest.Merge(m, src)
}
func (m *GetProcessesByDeploymentRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetProcessesByDeploymentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetProcessesByDeploymentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetProcessesByDeploymentRequest proto.InternalMessageInfo

func (m *GetProcessesByDeploymentRequest) GetDeploymentId() string {
	if m != nil {
		return m.DeploymentId
	}
	return ""
}

func (m *GetProcessesByDeploymentRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetProcessesByDeploymentRequest) Clone() *GetProcessesByDeploymentRequest {
	if m == nil {
		return nil
	}
	cloned := new(GetProcessesByDeploymentRequest)
	*cloned = *m

	return cloned
}

type GetProcessesResponse struct {
	Processes            []*storage.ProcessIndicator `protobuf:"bytes,1,rep,name=processes,proto3" json:"processes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *GetProcessesResponse) Reset()         { *m = GetProcessesResponse{} }
func (m *GetProcessesResponse) String() string { return proto.CompactTextString(m) }
func (*GetProcessesResponse) ProtoMessage()    {}
func (*GetProcessesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_38d7d55baf8cc025, []int{1}
}
func (m *GetProcessesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetProcessesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetProcessesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetProcessesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetProcessesResponse.Merge(m, src)
}
func (m *GetProcessesResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetProcessesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetProcessesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetProcessesResponse proto.InternalMessageInfo

func (m *GetProcessesResponse) GetProcesses() []*storage.ProcessIndicator {
	if m != nil {
		return m.Processes
	}
	return nil
}

func (m *GetProcessesResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetProcessesResponse) Clone() *GetProcessesResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetProcessesResponse)
	*cloned = *m

	if m.Processes != nil {
		cloned.Processes = make([]*storage.ProcessIndicator, len(m.Processes))
		for idx, v := range m.Processes {
			cloned.Processes[idx] = v.Clone()
		}
	}
	return cloned
}

type ProcessGroup struct {
	Args                 string                      `protobuf:"bytes,1,opt,name=args,proto3" json:"args,omitempty"`
	Signals              []*storage.ProcessIndicator `protobuf:"bytes,2,rep,name=signals,proto3" json:"signals,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *ProcessGroup) Reset()         { *m = ProcessGroup{} }
func (m *ProcessGroup) String() string { return proto.CompactTextString(m) }
func (*ProcessGroup) ProtoMessage()    {}
func (*ProcessGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_38d7d55baf8cc025, []int{2}
}
func (m *ProcessGroup) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProcessGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProcessGroup.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProcessGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessGroup.Merge(m, src)
}
func (m *ProcessGroup) XXX_Size() int {
	return m.Size()
}
func (m *ProcessGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessGroup.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessGroup proto.InternalMessageInfo

func (m *ProcessGroup) GetArgs() string {
	if m != nil {
		return m.Args
	}
	return ""
}

func (m *ProcessGroup) GetSignals() []*storage.ProcessIndicator {
	if m != nil {
		return m.Signals
	}
	return nil
}

func (m *ProcessGroup) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ProcessGroup) Clone() *ProcessGroup {
	if m == nil {
		return nil
	}
	cloned := new(ProcessGroup)
	*cloned = *m

	if m.Signals != nil {
		cloned.Signals = make([]*storage.ProcessIndicator, len(m.Signals))
		for idx, v := range m.Signals {
			cloned.Signals[idx] = v.Clone()
		}
	}
	return cloned
}

type ProcessNameGroup struct {
	Name                 string          `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	TimesExecuted        uint32          `protobuf:"varint,2,opt,name=times_executed,json=timesExecuted,proto3" json:"times_executed,omitempty"`
	Groups               []*ProcessGroup `protobuf:"bytes,3,rep,name=groups,proto3" json:"groups,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ProcessNameGroup) Reset()         { *m = ProcessNameGroup{} }
func (m *ProcessNameGroup) String() string { return proto.CompactTextString(m) }
func (*ProcessNameGroup) ProtoMessage()    {}
func (*ProcessNameGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_38d7d55baf8cc025, []int{3}
}
func (m *ProcessNameGroup) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProcessNameGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProcessNameGroup.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProcessNameGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessNameGroup.Merge(m, src)
}
func (m *ProcessNameGroup) XXX_Size() int {
	return m.Size()
}
func (m *ProcessNameGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessNameGroup.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessNameGroup proto.InternalMessageInfo

func (m *ProcessNameGroup) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ProcessNameGroup) GetTimesExecuted() uint32 {
	if m != nil {
		return m.TimesExecuted
	}
	return 0
}

func (m *ProcessNameGroup) GetGroups() []*ProcessGroup {
	if m != nil {
		return m.Groups
	}
	return nil
}

func (m *ProcessNameGroup) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ProcessNameGroup) Clone() *ProcessNameGroup {
	if m == nil {
		return nil
	}
	cloned := new(ProcessNameGroup)
	*cloned = *m

	if m.Groups != nil {
		cloned.Groups = make([]*ProcessGroup, len(m.Groups))
		for idx, v := range m.Groups {
			cloned.Groups[idx] = v.Clone()
		}
	}
	return cloned
}

type GetGroupedProcessesResponse struct {
	Groups               []*ProcessNameGroup `protobuf:"bytes,3,rep,name=groups,proto3" json:"groups,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *GetGroupedProcessesResponse) Reset()         { *m = GetGroupedProcessesResponse{} }
func (m *GetGroupedProcessesResponse) String() string { return proto.CompactTextString(m) }
func (*GetGroupedProcessesResponse) ProtoMessage()    {}
func (*GetGroupedProcessesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_38d7d55baf8cc025, []int{4}
}
func (m *GetGroupedProcessesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetGroupedProcessesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetGroupedProcessesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetGroupedProcessesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetGroupedProcessesResponse.Merge(m, src)
}
func (m *GetGroupedProcessesResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetGroupedProcessesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetGroupedProcessesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetGroupedProcessesResponse proto.InternalMessageInfo

func (m *GetGroupedProcessesResponse) GetGroups() []*ProcessNameGroup {
	if m != nil {
		return m.Groups
	}
	return nil
}

func (m *GetGroupedProcessesResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetGroupedProcessesResponse) Clone() *GetGroupedProcessesResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetGroupedProcessesResponse)
	*cloned = *m

	if m.Groups != nil {
		cloned.Groups = make([]*ProcessNameGroup, len(m.Groups))
		for idx, v := range m.Groups {
			cloned.Groups[idx] = v.Clone()
		}
	}
	return cloned
}

type ProcessNameAndContainerNameGroup struct {
	Name                 string          `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	ContainerName        string          `protobuf:"bytes,2,opt,name=container_name,json=containerName,proto3" json:"container_name,omitempty"`
	TimesExecuted        uint32          `protobuf:"varint,3,opt,name=times_executed,json=timesExecuted,proto3" json:"times_executed,omitempty"`
	Groups               []*ProcessGroup `protobuf:"bytes,4,rep,name=groups,proto3" json:"groups,omitempty"`
	Suspicious           bool            `protobuf:"varint,5,opt,name=suspicious,proto3" json:"suspicious,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ProcessNameAndContainerNameGroup) Reset()         { *m = ProcessNameAndContainerNameGroup{} }
func (m *ProcessNameAndContainerNameGroup) String() string { return proto.CompactTextString(m) }
func (*ProcessNameAndContainerNameGroup) ProtoMessage()    {}
func (*ProcessNameAndContainerNameGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_38d7d55baf8cc025, []int{5}
}
func (m *ProcessNameAndContainerNameGroup) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProcessNameAndContainerNameGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProcessNameAndContainerNameGroup.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProcessNameAndContainerNameGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessNameAndContainerNameGroup.Merge(m, src)
}
func (m *ProcessNameAndContainerNameGroup) XXX_Size() int {
	return m.Size()
}
func (m *ProcessNameAndContainerNameGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessNameAndContainerNameGroup.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessNameAndContainerNameGroup proto.InternalMessageInfo

func (m *ProcessNameAndContainerNameGroup) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ProcessNameAndContainerNameGroup) GetContainerName() string {
	if m != nil {
		return m.ContainerName
	}
	return ""
}

func (m *ProcessNameAndContainerNameGroup) GetTimesExecuted() uint32 {
	if m != nil {
		return m.TimesExecuted
	}
	return 0
}

func (m *ProcessNameAndContainerNameGroup) GetGroups() []*ProcessGroup {
	if m != nil {
		return m.Groups
	}
	return nil
}

func (m *ProcessNameAndContainerNameGroup) GetSuspicious() bool {
	if m != nil {
		return m.Suspicious
	}
	return false
}

func (m *ProcessNameAndContainerNameGroup) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ProcessNameAndContainerNameGroup) Clone() *ProcessNameAndContainerNameGroup {
	if m == nil {
		return nil
	}
	cloned := new(ProcessNameAndContainerNameGroup)
	*cloned = *m

	if m.Groups != nil {
		cloned.Groups = make([]*ProcessGroup, len(m.Groups))
		for idx, v := range m.Groups {
			cloned.Groups[idx] = v.Clone()
		}
	}
	return cloned
}

type GetGroupedProcessesWithContainerResponse struct {
	Groups               []*ProcessNameAndContainerNameGroup `protobuf:"bytes,3,rep,name=groups,proto3" json:"groups,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                            `json:"-"`
	XXX_unrecognized     []byte                              `json:"-"`
	XXX_sizecache        int32                               `json:"-"`
}

func (m *GetGroupedProcessesWithContainerResponse) Reset() {
	*m = GetGroupedProcessesWithContainerResponse{}
}
func (m *GetGroupedProcessesWithContainerResponse) String() string { return proto.CompactTextString(m) }
func (*GetGroupedProcessesWithContainerResponse) ProtoMessage()    {}
func (*GetGroupedProcessesWithContainerResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_38d7d55baf8cc025, []int{6}
}
func (m *GetGroupedProcessesWithContainerResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetGroupedProcessesWithContainerResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetGroupedProcessesWithContainerResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetGroupedProcessesWithContainerResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetGroupedProcessesWithContainerResponse.Merge(m, src)
}
func (m *GetGroupedProcessesWithContainerResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetGroupedProcessesWithContainerResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetGroupedProcessesWithContainerResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetGroupedProcessesWithContainerResponse proto.InternalMessageInfo

func (m *GetGroupedProcessesWithContainerResponse) GetGroups() []*ProcessNameAndContainerNameGroup {
	if m != nil {
		return m.Groups
	}
	return nil
}

func (m *GetGroupedProcessesWithContainerResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetGroupedProcessesWithContainerResponse) Clone() *GetGroupedProcessesWithContainerResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetGroupedProcessesWithContainerResponse)
	*cloned = *m

	if m.Groups != nil {
		cloned.Groups = make([]*ProcessNameAndContainerNameGroup, len(m.Groups))
		for idx, v := range m.Groups {
			cloned.Groups[idx] = v.Clone()
		}
	}
	return cloned
}

func init() {
	proto.RegisterType((*GetProcessesByDeploymentRequest)(nil), "v1.GetProcessesByDeploymentRequest")
	proto.RegisterType((*GetProcessesResponse)(nil), "v1.GetProcessesResponse")
	proto.RegisterType((*ProcessGroup)(nil), "v1.ProcessGroup")
	proto.RegisterType((*ProcessNameGroup)(nil), "v1.ProcessNameGroup")
	proto.RegisterType((*GetGroupedProcessesResponse)(nil), "v1.GetGroupedProcessesResponse")
	proto.RegisterType((*ProcessNameAndContainerNameGroup)(nil), "v1.ProcessNameAndContainerNameGroup")
	proto.RegisterType((*GetGroupedProcessesWithContainerResponse)(nil), "v1.GetGroupedProcessesWithContainerResponse")
}

func init() { proto.RegisterFile("api/v1/process_service.proto", fileDescriptor_38d7d55baf8cc025) }

var fileDescriptor_38d7d55baf8cc025 = []byte{
	// 571 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x94, 0xcb, 0x6e, 0xd3, 0x40,
	0x14, 0x86, 0x3b, 0x6e, 0x28, 0x74, 0x68, 0xaa, 0x6a, 0xd4, 0x85, 0x09, 0x25, 0x89, 0x5c, 0x90,
	0x0c, 0xaa, 0xec, 0x26, 0x5d, 0x80, 0x50, 0x37, 0x84, 0x4b, 0x54, 0x21, 0x01, 0x32, 0x8b, 0x22,
	0x36, 0xd1, 0x60, 0x1f, 0xb9, 0x23, 0x92, 0x19, 0xe3, 0x19, 0x9b, 0x56, 0x88, 0x0d, 0x12, 0x2b,
	0x96, 0x6c, 0xd8, 0xf1, 0x2e, 0xac, 0x58, 0x21, 0x24, 0x5e, 0x00, 0x05, 0x1e, 0x04, 0xc5, 0xb7,
	0x98, 0x34, 0x97, 0x76, 0x37, 0xfa, 0xcf, 0xef, 0xdf, 0xdf, 0x39, 0x9e, 0x63, 0xbc, 0x45, 0x03,
	0x66, 0xc7, 0x2d, 0x3b, 0x08, 0x85, 0x0b, 0x52, 0xf6, 0x24, 0x84, 0x31, 0x73, 0xc1, 0x0a, 0x42,
	0xa1, 0x04, 0xd1, 0xe2, 0x56, 0x6d, 0xcb, 0x17, 0xc2, 0xef, 0x83, 0x3d, 0x32, 0x52, 0xce, 0x85,
	0xa2, 0x8a, 0x09, 0x2e, 0x53, 0x47, 0xad, 0x21, 0x95, 0x08, 0xa9, 0x0f, 0x45, 0x00, 0xe3, 0x1e,
	0x73, 0xa9, 0x12, 0x61, 0x6a, 0x30, 0x1e, 0xe1, 0x46, 0x17, 0xd4, 0xb3, 0xb4, 0x0a, 0xb2, 0x73,
	0xf2, 0x00, 0x82, 0xbe, 0x38, 0x19, 0x00, 0x57, 0x0e, 0xbc, 0x89, 0x40, 0x2a, 0xb2, 0x8d, 0xab,
	0x5e, 0x21, 0xf6, 0x98, 0xa7, 0xa3, 0x26, 0x32, 0x57, 0x9d, 0xb5, 0xb1, 0x78, 0xe0, 0x19, 0x4f,
	0xf1, 0x66, 0x39, 0xc7, 0x01, 0x19, 0x08, 0x2e, 0x81, 0xdc, 0xc6, 0xab, 0x41, 0x2e, 0xea, 0xa8,
	0xb9, 0x6c, 0x5e, 0x6e, 0x5f, 0xb1, 0x32, 0x28, 0x2b, 0xb3, 0x1f, 0xe4, 0x4c, 0xce, 0xd8, 0x6b,
	0x1c, 0xe2, 0xb5, 0xac, 0xdc, 0x0d, 0x45, 0x14, 0x10, 0x82, 0x2b, 0x34, 0xf4, 0x65, 0xf6, 0xf2,
	0xe4, 0x4c, 0xf6, 0xf0, 0x45, 0xc9, 0x7c, 0x4e, 0xfb, 0x52, 0xd7, 0x16, 0x45, 0xe7, 0x4e, 0xe3,
	0x2d, 0xde, 0xc8, 0x8a, 0x4f, 0xe8, 0x00, 0x8a, 0x70, 0x4e, 0x07, 0x90, 0x87, 0x8f, 0xce, 0xe4,
	0x06, 0x5e, 0x57, 0x6c, 0x00, 0xb2, 0x07, 0xc7, 0xe0, 0x46, 0x0a, 0x3c, 0x5d, 0x6b, 0x22, 0xb3,
	0xea, 0x54, 0x13, 0xf5, 0x61, 0x26, 0x12, 0x13, 0xaf, 0xf8, 0xa3, 0x0c, 0xa9, 0x2f, 0x27, 0x08,
	0x1b, 0x56, 0xdc, 0xb2, 0xca, 0xe4, 0x4e, 0x56, 0x37, 0x1e, 0xe3, 0xab, 0x5d, 0x50, 0x89, 0x06,
	0xde, 0xe9, 0x49, 0xed, 0x4c, 0x04, 0x6d, 0x96, 0x82, 0x0a, 0xd2, 0x22, 0xec, 0x07, 0xc2, 0xcd,
	0x52, 0xf1, 0x1e, 0xf7, 0xee, 0x0b, 0xae, 0x28, 0xe3, 0x10, 0x2e, 0x6c, 0xcb, 0xcd, 0x9d, 0xbd,
	0xa4, 0xaa, 0x25, 0xd5, 0xaa, 0x5b, 0x7e, 0x7e, 0x4a, 0xf7, 0xcb, 0xf3, 0xbb, 0xaf, 0xcc, 0xef,
	0x9e, 0xd4, 0x31, 0x96, 0x91, 0x0c, 0x98, 0xcb, 0x44, 0x24, 0xf5, 0x0b, 0x4d, 0x64, 0x5e, 0x72,
	0x4a, 0x8a, 0x71, 0x84, 0xcd, 0x29, 0xd3, 0x39, 0x64, 0xea, 0xa8, 0x68, 0xac, 0x18, 0xd5, 0xfe,
	0xc4, 0xa8, 0xae, 0x4f, 0x8c, 0x6a, 0xea, 0x34, 0x72, 0x92, 0xf6, 0xc7, 0x0a, 0x5e, 0xcf, 0xcc,
	0xcf, 0xd3, 0x75, 0x22, 0x9f, 0x10, 0xd6, 0x67, 0xad, 0x01, 0xd9, 0x1e, 0xa5, 0x2f, 0x58, 0x92,
	0x9a, 0x3e, 0x69, 0xca, 0x61, 0x8d, 0xdd, 0x0f, 0xbf, 0xfe, 0x7e, 0xd6, 0x6e, 0x11, 0xb3, 0xb4,
	0xc7, 0x20, 0xed, 0xf1, 0xf6, 0xd8, 0xef, 0xfe, 0x5b, 0xaf, 0xf7, 0xe4, 0x2b, 0xc2, 0xd7, 0x4e,
	0xcd, 0xe2, 0xfc, 0x48, 0x8d, 0xcc, 0x34, 0xeb, 0xc6, 0x19, 0x77, 0x12, 0xb2, 0x36, 0xd9, 0x3d,
	0x2b, 0x99, 0xed, 0xa7, 0x51, 0xe4, 0x1b, 0xc2, 0x37, 0xe7, 0x12, 0x96, 0xbf, 0xc0, 0xd9, 0x68,
	0x77, 0x66, 0xd0, 0x4e, 0xbd, 0x01, 0x46, 0x27, 0x41, 0xdf, 0x27, 0x77, 0xcf, 0x8b, 0x6e, 0x17,
	0xd7, 0xbc, 0x63, 0x7d, 0x1f, 0xd6, 0xd1, 0xcf, 0x61, 0x1d, 0xfd, 0x1e, 0xd6, 0xd1, 0x97, 0x3f,
	0xf5, 0x25, 0xac, 0x33, 0x61, 0x49, 0x45, 0xdd, 0xd7, 0xa1, 0x38, 0x4e, 0xff, 0x8f, 0x16, 0x0d,
	0x98, 0x15, 0xb7, 0x5e, 0x6a, 0x71, 0xeb, 0xc5, 0xd2, 0xab, 0x95, 0x44, 0xdb, 0xfb, 0x17, 0x00,
	0x00, 0xff, 0xff, 0x31, 0xca, 0x6d, 0xd1, 0x96, 0x05, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ProcessServiceClient is the client API for ProcessService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConnInterface.NewStream.
type ProcessServiceClient interface {
	// GetProcessesByDeployment returns the processes executed in the given deployment.
	GetProcessesByDeployment(ctx context.Context, in *GetProcessesByDeploymentRequest, opts ...grpc.CallOption) (*GetProcessesResponse, error)
	// GetGroupedProcessByDeployment returns all the processes executed grouped by deployment.
	GetGroupedProcessByDeployment(ctx context.Context, in *GetProcessesByDeploymentRequest, opts ...grpc.CallOption) (*GetGroupedProcessesResponse, error)
	// GetGroupedProcessByDeploymentAndContainer returns all the processes executed grouped by deployment and container.
	GetGroupedProcessByDeploymentAndContainer(ctx context.Context, in *GetProcessesByDeploymentRequest, opts ...grpc.CallOption) (*GetGroupedProcessesWithContainerResponse, error)
}

type processServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewProcessServiceClient(cc grpc.ClientConnInterface) ProcessServiceClient {
	return &processServiceClient{cc}
}

func (c *processServiceClient) GetProcessesByDeployment(ctx context.Context, in *GetProcessesByDeploymentRequest, opts ...grpc.CallOption) (*GetProcessesResponse, error) {
	out := new(GetProcessesResponse)
	err := c.cc.Invoke(ctx, "/v1.ProcessService/GetProcessesByDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *processServiceClient) GetGroupedProcessByDeployment(ctx context.Context, in *GetProcessesByDeploymentRequest, opts ...grpc.CallOption) (*GetGroupedProcessesResponse, error) {
	out := new(GetGroupedProcessesResponse)
	err := c.cc.Invoke(ctx, "/v1.ProcessService/GetGroupedProcessByDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *processServiceClient) GetGroupedProcessByDeploymentAndContainer(ctx context.Context, in *GetProcessesByDeploymentRequest, opts ...grpc.CallOption) (*GetGroupedProcessesWithContainerResponse, error) {
	out := new(GetGroupedProcessesWithContainerResponse)
	err := c.cc.Invoke(ctx, "/v1.ProcessService/GetGroupedProcessByDeploymentAndContainer", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ProcessServiceServer is the server API for ProcessService service.
type ProcessServiceServer interface {
	// GetProcessesByDeployment returns the processes executed in the given deployment.
	GetProcessesByDeployment(context.Context, *GetProcessesByDeploymentRequest) (*GetProcessesResponse, error)
	// GetGroupedProcessByDeployment returns all the processes executed grouped by deployment.
	GetGroupedProcessByDeployment(context.Context, *GetProcessesByDeploymentRequest) (*GetGroupedProcessesResponse, error)
	// GetGroupedProcessByDeploymentAndContainer returns all the processes executed grouped by deployment and container.
	GetGroupedProcessByDeploymentAndContainer(context.Context, *GetProcessesByDeploymentRequest) (*GetGroupedProcessesWithContainerResponse, error)
}

// UnimplementedProcessServiceServer can be embedded to have forward compatible implementations.
type UnimplementedProcessServiceServer struct {
}

func (*UnimplementedProcessServiceServer) GetProcessesByDeployment(ctx context.Context, req *GetProcessesByDeploymentRequest) (*GetProcessesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProcessesByDeployment not implemented")
}
func (*UnimplementedProcessServiceServer) GetGroupedProcessByDeployment(ctx context.Context, req *GetProcessesByDeploymentRequest) (*GetGroupedProcessesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGroupedProcessByDeployment not implemented")
}
func (*UnimplementedProcessServiceServer) GetGroupedProcessByDeploymentAndContainer(ctx context.Context, req *GetProcessesByDeploymentRequest) (*GetGroupedProcessesWithContainerResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGroupedProcessByDeploymentAndContainer not implemented")
}

func RegisterProcessServiceServer(s *grpc.Server, srv ProcessServiceServer) {
	s.RegisterService(&_ProcessService_serviceDesc, srv)
}

func _ProcessService_GetProcessesByDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProcessesByDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProcessServiceServer).GetProcessesByDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ProcessService/GetProcessesByDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProcessServiceServer).GetProcessesByDeployment(ctx, req.(*GetProcessesByDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProcessService_GetGroupedProcessByDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProcessesByDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProcessServiceServer).GetGroupedProcessByDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ProcessService/GetGroupedProcessByDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProcessServiceServer).GetGroupedProcessByDeployment(ctx, req.(*GetProcessesByDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProcessService_GetGroupedProcessByDeploymentAndContainer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProcessesByDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProcessServiceServer).GetGroupedProcessByDeploymentAndContainer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ProcessService/GetGroupedProcessByDeploymentAndContainer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProcessServiceServer).GetGroupedProcessByDeploymentAndContainer(ctx, req.(*GetProcessesByDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ProcessService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1.ProcessService",
	HandlerType: (*ProcessServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetProcessesByDeployment",
			Handler:    _ProcessService_GetProcessesByDeployment_Handler,
		},
		{
			MethodName: "GetGroupedProcessByDeployment",
			Handler:    _ProcessService_GetGroupedProcessByDeployment_Handler,
		},
		{
			MethodName: "GetGroupedProcessByDeploymentAndContainer",
			Handler:    _ProcessService_GetGroupedProcessByDeploymentAndContainer_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/v1/process_service.proto",
}

func (m *GetProcessesByDeploymentRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetProcessesByDeploymentRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetProcessesByDeploymentRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.DeploymentId) > 0 {
		i -= len(m.DeploymentId)
		copy(dAtA[i:], m.DeploymentId)
		i = encodeVarintProcessService(dAtA, i, uint64(len(m.DeploymentId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetProcessesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetProcessesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetProcessesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Processes) > 0 {
		for iNdEx := len(m.Processes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Processes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintProcessService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ProcessGroup) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProcessGroup) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProcessGroup) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Signals) > 0 {
		for iNdEx := len(m.Signals) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Signals[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintProcessService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Args) > 0 {
		i -= len(m.Args)
		copy(dAtA[i:], m.Args)
		i = encodeVarintProcessService(dAtA, i, uint64(len(m.Args)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ProcessNameGroup) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProcessNameGroup) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProcessNameGroup) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Groups) > 0 {
		for iNdEx := len(m.Groups) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Groups[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintProcessService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.TimesExecuted != 0 {
		i = encodeVarintProcessService(dAtA, i, uint64(m.TimesExecuted))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintProcessService(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetGroupedProcessesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetGroupedProcessesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetGroupedProcessesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Groups) > 0 {
		for iNdEx := len(m.Groups) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Groups[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintProcessService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	return len(dAtA) - i, nil
}

func (m *ProcessNameAndContainerNameGroup) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProcessNameAndContainerNameGroup) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProcessNameAndContainerNameGroup) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Suspicious {
		i--
		if m.Suspicious {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if len(m.Groups) > 0 {
		for iNdEx := len(m.Groups) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Groups[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintProcessService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if m.TimesExecuted != 0 {
		i = encodeVarintProcessService(dAtA, i, uint64(m.TimesExecuted))
		i--
		dAtA[i] = 0x18
	}
	if len(m.ContainerName) > 0 {
		i -= len(m.ContainerName)
		copy(dAtA[i:], m.ContainerName)
		i = encodeVarintProcessService(dAtA, i, uint64(len(m.ContainerName)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintProcessService(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetGroupedProcessesWithContainerResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetGroupedProcessesWithContainerResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetGroupedProcessesWithContainerResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Groups) > 0 {
		for iNdEx := len(m.Groups) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Groups[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintProcessService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	return len(dAtA) - i, nil
}

func encodeVarintProcessService(dAtA []byte, offset int, v uint64) int {
	offset -= sovProcessService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *GetProcessesByDeploymentRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DeploymentId)
	if l > 0 {
		n += 1 + l + sovProcessService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetProcessesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Processes) > 0 {
		for _, e := range m.Processes {
			l = e.Size()
			n += 1 + l + sovProcessService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ProcessGroup) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Args)
	if l > 0 {
		n += 1 + l + sovProcessService(uint64(l))
	}
	if len(m.Signals) > 0 {
		for _, e := range m.Signals {
			l = e.Size()
			n += 1 + l + sovProcessService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ProcessNameGroup) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovProcessService(uint64(l))
	}
	if m.TimesExecuted != 0 {
		n += 1 + sovProcessService(uint64(m.TimesExecuted))
	}
	if len(m.Groups) > 0 {
		for _, e := range m.Groups {
			l = e.Size()
			n += 1 + l + sovProcessService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetGroupedProcessesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Groups) > 0 {
		for _, e := range m.Groups {
			l = e.Size()
			n += 1 + l + sovProcessService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ProcessNameAndContainerNameGroup) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovProcessService(uint64(l))
	}
	l = len(m.ContainerName)
	if l > 0 {
		n += 1 + l + sovProcessService(uint64(l))
	}
	if m.TimesExecuted != 0 {
		n += 1 + sovProcessService(uint64(m.TimesExecuted))
	}
	if len(m.Groups) > 0 {
		for _, e := range m.Groups {
			l = e.Size()
			n += 1 + l + sovProcessService(uint64(l))
		}
	}
	if m.Suspicious {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetGroupedProcessesWithContainerResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Groups) > 0 {
		for _, e := range m.Groups {
			l = e.Size()
			n += 1 + l + sovProcessService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovProcessService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozProcessService(x uint64) (n int) {
	return sovProcessService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *GetProcessesByDeploymentRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetProcessesByDeploymentRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetProcessesByDeploymentRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProcessService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProcessService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProcessService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetProcessesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetProcessesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetProcessesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Processes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProcessService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Processes = append(m.Processes, &storage.ProcessIndicator{})
			if err := m.Processes[len(m.Processes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProcessService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProcessGroup) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProcessGroup: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProcessGroup: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Args", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProcessService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProcessService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Args = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Signals", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProcessService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Signals = append(m.Signals, &storage.ProcessIndicator{})
			if err := m.Signals[len(m.Signals)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProcessService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProcessNameGroup) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProcessNameGroup: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProcessNameGroup: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProcessService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProcessService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimesExecuted", wireType)
			}
			m.TimesExecuted = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TimesExecuted |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Groups", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProcessService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Groups = append(m.Groups, &ProcessGroup{})
			if err := m.Groups[len(m.Groups)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProcessService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetGroupedProcessesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetGroupedProcessesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetGroupedProcessesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Groups", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProcessService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Groups = append(m.Groups, &ProcessNameGroup{})
			if err := m.Groups[len(m.Groups)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProcessService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProcessNameAndContainerNameGroup) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProcessNameAndContainerNameGroup: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProcessNameAndContainerNameGroup: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProcessService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProcessService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProcessService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthProcessService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainerName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimesExecuted", wireType)
			}
			m.TimesExecuted = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TimesExecuted |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Groups", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProcessService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Groups = append(m.Groups, &ProcessGroup{})
			if err := m.Groups[len(m.Groups)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Suspicious", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Suspicious = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipProcessService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProcessService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetGroupedProcessesWithContainerResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetGroupedProcessesWithContainerResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetGroupedProcessesWithContainerResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Groups", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthProcessService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Groups = append(m.Groups, &ProcessNameAndContainerNameGroup{})
			if err := m.Groups[len(m.Groups)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthProcessService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipProcessService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowProcessService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowProcessService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowProcessService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthProcessService
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupProcessService
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthProcessService
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthProcessService        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowProcessService          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupProcessService = fmt.Errorf("proto: unexpected end of group")
)
