// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api/v1/rbac_service.proto

package v1

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	storage "github.com/stackrox/rox/generated/storage"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// A list of k8s roles (free of scoped information)
// Next Tag: 2
type ListRolesResponse struct {
	Roles                []*storage.K8SRole `protobuf:"bytes,1,rep,name=roles,proto3" json:"roles,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *ListRolesResponse) Reset()         { *m = ListRolesResponse{} }
func (m *ListRolesResponse) String() string { return proto.CompactTextString(m) }
func (*ListRolesResponse) ProtoMessage()    {}
func (*ListRolesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_c3524f4bea3cf307, []int{0}
}
func (m *ListRolesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListRolesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListRolesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListRolesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListRolesResponse.Merge(m, src)
}
func (m *ListRolesResponse) XXX_Size() int {
	return m.Size()
}
func (m *ListRolesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListRolesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListRolesResponse proto.InternalMessageInfo

func (m *ListRolesResponse) GetRoles() []*storage.K8SRole {
	if m != nil {
		return m.Roles
	}
	return nil
}

func (m *ListRolesResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ListRolesResponse) Clone() *ListRolesResponse {
	if m == nil {
		return nil
	}
	cloned := new(ListRolesResponse)
	*cloned = *m

	if m.Roles != nil {
		cloned.Roles = make([]*storage.K8SRole, len(m.Roles))
		for idx, v := range m.Roles {
			cloned.Roles[idx] = v.Clone()
		}
	}
	return cloned
}

type GetRoleResponse struct {
	Role                 *storage.K8SRole `protobuf:"bytes,1,opt,name=role,proto3" json:"role,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *GetRoleResponse) Reset()         { *m = GetRoleResponse{} }
func (m *GetRoleResponse) String() string { return proto.CompactTextString(m) }
func (*GetRoleResponse) ProtoMessage()    {}
func (*GetRoleResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_c3524f4bea3cf307, []int{1}
}
func (m *GetRoleResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetRoleResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetRoleResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetRoleResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetRoleResponse.Merge(m, src)
}
func (m *GetRoleResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetRoleResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetRoleResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetRoleResponse proto.InternalMessageInfo

func (m *GetRoleResponse) GetRole() *storage.K8SRole {
	if m != nil {
		return m.Role
	}
	return nil
}

func (m *GetRoleResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetRoleResponse) Clone() *GetRoleResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetRoleResponse)
	*cloned = *m

	cloned.Role = m.Role.Clone()
	return cloned
}

// A list of k8s role bindings (free of scoped information)
// Next Tag: 2
type ListRoleBindingsResponse struct {
	Bindings             []*storage.K8SRoleBinding `protobuf:"bytes,1,rep,name=bindings,proto3" json:"bindings,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *ListRoleBindingsResponse) Reset()         { *m = ListRoleBindingsResponse{} }
func (m *ListRoleBindingsResponse) String() string { return proto.CompactTextString(m) }
func (*ListRoleBindingsResponse) ProtoMessage()    {}
func (*ListRoleBindingsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_c3524f4bea3cf307, []int{2}
}
func (m *ListRoleBindingsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListRoleBindingsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListRoleBindingsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListRoleBindingsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListRoleBindingsResponse.Merge(m, src)
}
func (m *ListRoleBindingsResponse) XXX_Size() int {
	return m.Size()
}
func (m *ListRoleBindingsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListRoleBindingsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListRoleBindingsResponse proto.InternalMessageInfo

func (m *ListRoleBindingsResponse) GetBindings() []*storage.K8SRoleBinding {
	if m != nil {
		return m.Bindings
	}
	return nil
}

func (m *ListRoleBindingsResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ListRoleBindingsResponse) Clone() *ListRoleBindingsResponse {
	if m == nil {
		return nil
	}
	cloned := new(ListRoleBindingsResponse)
	*cloned = *m

	if m.Bindings != nil {
		cloned.Bindings = make([]*storage.K8SRoleBinding, len(m.Bindings))
		for idx, v := range m.Bindings {
			cloned.Bindings[idx] = v.Clone()
		}
	}
	return cloned
}

type GetRoleBindingResponse struct {
	Binding              *storage.K8SRoleBinding `protobuf:"bytes,1,opt,name=binding,proto3" json:"binding,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *GetRoleBindingResponse) Reset()         { *m = GetRoleBindingResponse{} }
func (m *GetRoleBindingResponse) String() string { return proto.CompactTextString(m) }
func (*GetRoleBindingResponse) ProtoMessage()    {}
func (*GetRoleBindingResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_c3524f4bea3cf307, []int{3}
}
func (m *GetRoleBindingResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetRoleBindingResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetRoleBindingResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetRoleBindingResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetRoleBindingResponse.Merge(m, src)
}
func (m *GetRoleBindingResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetRoleBindingResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetRoleBindingResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetRoleBindingResponse proto.InternalMessageInfo

func (m *GetRoleBindingResponse) GetBinding() *storage.K8SRoleBinding {
	if m != nil {
		return m.Binding
	}
	return nil
}

func (m *GetRoleBindingResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetRoleBindingResponse) Clone() *GetRoleBindingResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetRoleBindingResponse)
	*cloned = *m

	cloned.Binding = m.Binding.Clone()
	return cloned
}

// A list of k8s subjects (users and groups only, for service accounts, try the service account service)
// Next Tag: 2
type ListSubjectsResponse struct {
	SubjectAndRoles      []*SubjectAndRoles `protobuf:"bytes,1,rep,name=subject_and_roles,json=subjectAndRoles,proto3" json:"subject_and_roles,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *ListSubjectsResponse) Reset()         { *m = ListSubjectsResponse{} }
func (m *ListSubjectsResponse) String() string { return proto.CompactTextString(m) }
func (*ListSubjectsResponse) ProtoMessage()    {}
func (*ListSubjectsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_c3524f4bea3cf307, []int{4}
}
func (m *ListSubjectsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListSubjectsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListSubjectsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListSubjectsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSubjectsResponse.Merge(m, src)
}
func (m *ListSubjectsResponse) XXX_Size() int {
	return m.Size()
}
func (m *ListSubjectsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSubjectsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListSubjectsResponse proto.InternalMessageInfo

func (m *ListSubjectsResponse) GetSubjectAndRoles() []*SubjectAndRoles {
	if m != nil {
		return m.SubjectAndRoles
	}
	return nil
}

func (m *ListSubjectsResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ListSubjectsResponse) Clone() *ListSubjectsResponse {
	if m == nil {
		return nil
	}
	cloned := new(ListSubjectsResponse)
	*cloned = *m

	if m.SubjectAndRoles != nil {
		cloned.SubjectAndRoles = make([]*SubjectAndRoles, len(m.SubjectAndRoles))
		for idx, v := range m.SubjectAndRoles {
			cloned.SubjectAndRoles[idx] = v.Clone()
		}
	}
	return cloned
}

type SubjectAndRoles struct {
	Subject              *storage.Subject   `protobuf:"bytes,1,opt,name=subject,proto3" json:"subject,omitempty"`
	Roles                []*storage.K8SRole `protobuf:"bytes,2,rep,name=roles,proto3" json:"roles,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *SubjectAndRoles) Reset()         { *m = SubjectAndRoles{} }
func (m *SubjectAndRoles) String() string { return proto.CompactTextString(m) }
func (*SubjectAndRoles) ProtoMessage()    {}
func (*SubjectAndRoles) Descriptor() ([]byte, []int) {
	return fileDescriptor_c3524f4bea3cf307, []int{5}
}
func (m *SubjectAndRoles) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SubjectAndRoles) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SubjectAndRoles.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SubjectAndRoles) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SubjectAndRoles.Merge(m, src)
}
func (m *SubjectAndRoles) XXX_Size() int {
	return m.Size()
}
func (m *SubjectAndRoles) XXX_DiscardUnknown() {
	xxx_messageInfo_SubjectAndRoles.DiscardUnknown(m)
}

var xxx_messageInfo_SubjectAndRoles proto.InternalMessageInfo

func (m *SubjectAndRoles) GetSubject() *storage.Subject {
	if m != nil {
		return m.Subject
	}
	return nil
}

func (m *SubjectAndRoles) GetRoles() []*storage.K8SRole {
	if m != nil {
		return m.Roles
	}
	return nil
}

func (m *SubjectAndRoles) MessageClone() proto.Message {
	return m.Clone()
}
func (m *SubjectAndRoles) Clone() *SubjectAndRoles {
	if m == nil {
		return nil
	}
	cloned := new(SubjectAndRoles)
	*cloned = *m

	cloned.Subject = m.Subject.Clone()
	if m.Roles != nil {
		cloned.Roles = make([]*storage.K8SRole, len(m.Roles))
		for idx, v := range m.Roles {
			cloned.Roles[idx] = v.Clone()
		}
	}
	return cloned
}

type GetSubjectResponse struct {
	Subject              *storage.Subject   `protobuf:"bytes,1,opt,name=subject,proto3" json:"subject,omitempty"`
	ClusterRoles         []*storage.K8SRole `protobuf:"bytes,2,rep,name=cluster_roles,json=clusterRoles,proto3" json:"cluster_roles,omitempty"`
	ScopedRoles          []*ScopedRoles     `protobuf:"bytes,3,rep,name=scoped_roles,json=scopedRoles,proto3" json:"scoped_roles,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *GetSubjectResponse) Reset()         { *m = GetSubjectResponse{} }
func (m *GetSubjectResponse) String() string { return proto.CompactTextString(m) }
func (*GetSubjectResponse) ProtoMessage()    {}
func (*GetSubjectResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_c3524f4bea3cf307, []int{6}
}
func (m *GetSubjectResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetSubjectResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetSubjectResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetSubjectResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetSubjectResponse.Merge(m, src)
}
func (m *GetSubjectResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetSubjectResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetSubjectResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetSubjectResponse proto.InternalMessageInfo

func (m *GetSubjectResponse) GetSubject() *storage.Subject {
	if m != nil {
		return m.Subject
	}
	return nil
}

func (m *GetSubjectResponse) GetClusterRoles() []*storage.K8SRole {
	if m != nil {
		return m.ClusterRoles
	}
	return nil
}

func (m *GetSubjectResponse) GetScopedRoles() []*ScopedRoles {
	if m != nil {
		return m.ScopedRoles
	}
	return nil
}

func (m *GetSubjectResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetSubjectResponse) Clone() *GetSubjectResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetSubjectResponse)
	*cloned = *m

	cloned.Subject = m.Subject.Clone()
	if m.ClusterRoles != nil {
		cloned.ClusterRoles = make([]*storage.K8SRole, len(m.ClusterRoles))
		for idx, v := range m.ClusterRoles {
			cloned.ClusterRoles[idx] = v.Clone()
		}
	}
	if m.ScopedRoles != nil {
		cloned.ScopedRoles = make([]*ScopedRoles, len(m.ScopedRoles))
		for idx, v := range m.ScopedRoles {
			cloned.ScopedRoles[idx] = v.Clone()
		}
	}
	return cloned
}

type ScopedRoles struct {
	Namespace            string             `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Roles                []*storage.K8SRole `protobuf:"bytes,2,rep,name=roles,proto3" json:"roles,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *ScopedRoles) Reset()         { *m = ScopedRoles{} }
func (m *ScopedRoles) String() string { return proto.CompactTextString(m) }
func (*ScopedRoles) ProtoMessage()    {}
func (*ScopedRoles) Descriptor() ([]byte, []int) {
	return fileDescriptor_c3524f4bea3cf307, []int{7}
}
func (m *ScopedRoles) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ScopedRoles) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ScopedRoles.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ScopedRoles) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScopedRoles.Merge(m, src)
}
func (m *ScopedRoles) XXX_Size() int {
	return m.Size()
}
func (m *ScopedRoles) XXX_DiscardUnknown() {
	xxx_messageInfo_ScopedRoles.DiscardUnknown(m)
}

var xxx_messageInfo_ScopedRoles proto.InternalMessageInfo

func (m *ScopedRoles) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *ScopedRoles) GetRoles() []*storage.K8SRole {
	if m != nil {
		return m.Roles
	}
	return nil
}

func (m *ScopedRoles) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ScopedRoles) Clone() *ScopedRoles {
	if m == nil {
		return nil
	}
	cloned := new(ScopedRoles)
	*cloned = *m

	if m.Roles != nil {
		cloned.Roles = make([]*storage.K8SRole, len(m.Roles))
		for idx, v := range m.Roles {
			cloned.Roles[idx] = v.Clone()
		}
	}
	return cloned
}

func init() {
	proto.RegisterType((*ListRolesResponse)(nil), "v1.ListRolesResponse")
	proto.RegisterType((*GetRoleResponse)(nil), "v1.GetRoleResponse")
	proto.RegisterType((*ListRoleBindingsResponse)(nil), "v1.ListRoleBindingsResponse")
	proto.RegisterType((*GetRoleBindingResponse)(nil), "v1.GetRoleBindingResponse")
	proto.RegisterType((*ListSubjectsResponse)(nil), "v1.ListSubjectsResponse")
	proto.RegisterType((*SubjectAndRoles)(nil), "v1.SubjectAndRoles")
	proto.RegisterType((*GetSubjectResponse)(nil), "v1.GetSubjectResponse")
	proto.RegisterType((*ScopedRoles)(nil), "v1.ScopedRoles")
}

func init() { proto.RegisterFile("api/v1/rbac_service.proto", fileDescriptor_c3524f4bea3cf307) }

var fileDescriptor_c3524f4bea3cf307 = []byte{
	// 609 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x94, 0xcf, 0x6e, 0xd3, 0x40,
	0x10, 0xc6, 0xeb, 0xb4, 0x50, 0x3a, 0x09, 0x4d, 0xba, 0x21, 0xa9, 0x9b, 0x86, 0xa8, 0x5a, 0x21,
	0x84, 0x38, 0x38, 0x72, 0x2a, 0x04, 0x12, 0x07, 0x44, 0x84, 0x54, 0x50, 0x41, 0xa8, 0x8e, 0x10,
	0x7f, 0x0e, 0x44, 0x9b, 0xcd, 0x2a, 0x18, 0x12, 0xaf, 0xe5, 0x75, 0x0c, 0x15, 0xe2, 0xc2, 0x95,
	0x23, 0x17, 0xde, 0x81, 0x17, 0xe1, 0x88, 0xc4, 0x0b, 0xa0, 0xc0, 0x83, 0x20, 0xef, 0xae, 0xed,
	0xc4, 0x09, 0x15, 0x1c, 0x3d, 0xf3, 0xcd, 0x37, 0xbf, 0xcc, 0xce, 0x04, 0xf6, 0x88, 0xef, 0xb6,
	0x23, 0xbb, 0x1d, 0x0c, 0x08, 0xed, 0x0b, 0x16, 0x44, 0x2e, 0x65, 0x96, 0x1f, 0xf0, 0x90, 0xa3,
	0x42, 0x64, 0x37, 0x9a, 0x23, 0xce, 0x47, 0x63, 0xd6, 0x8e, 0x55, 0xc4, 0xf3, 0x78, 0x48, 0x42,
	0x97, 0x7b, 0x42, 0x29, 0x1a, 0x55, 0x5d, 0x4c, 0xf9, 0x64, 0xc2, 0x3d, 0x1d, 0x44, 0x22, 0xe4,
	0x01, 0x19, 0x31, 0x69, 0xa9, 0x63, 0xfb, 0x5a, 0x28, 0x18, 0x09, 0xe8, 0xab, 0xc5, 0x3e, 0xf8,
	0x36, 0xec, 0x3c, 0x74, 0x45, 0xe8, 0xf0, 0x31, 0x13, 0x0e, 0x13, 0x3e, 0xf7, 0x04, 0x43, 0x57,
	0xe1, 0x5c, 0x10, 0x07, 0x4c, 0xe3, 0x60, 0xfd, 0x5a, 0xb1, 0x53, 0xb1, 0xb4, 0xab, 0x75, 0x7c,
	0x4b, 0xc4, 0x4a, 0x47, 0xa5, 0xf1, 0x4d, 0x28, 0x1f, 0x31, 0x59, 0x9b, 0x96, 0x5e, 0x81, 0x8d,
	0x38, 0x67, 0x1a, 0x07, 0xc6, 0xca, 0x4a, 0x99, 0xc5, 0x8f, 0xc1, 0x4c, 0xba, 0x76, 0x5d, 0x6f,
	0xe8, 0x7a, 0xa3, 0xac, 0xf9, 0x21, 0x5c, 0x18, 0xe8, 0x98, 0xee, 0xbf, 0x9b, 0x77, 0xd1, 0x35,
	0x4e, 0x2a, 0xc4, 0xc7, 0x50, 0xd7, 0x24, 0x49, 0x2e, 0xb1, 0xb3, 0x61, 0x53, 0xab, 0x34, 0xd3,
	0x5f, 0xdd, 0x12, 0x1d, 0x7e, 0x0a, 0x97, 0x62, 0xba, 0xde, 0x74, 0xf0, 0x9a, 0xd1, 0x30, 0x23,
	0xbb, 0x03, 0x3b, 0x42, 0xc5, 0xfa, 0xc4, 0x1b, 0xf6, 0xe7, 0x47, 0x54, 0xb5, 0x22, 0xdb, 0xd2,
	0x05, 0x77, 0xbd, 0xa1, 0x1a, 0x67, 0x59, 0x2c, 0x06, 0x30, 0x83, 0x72, 0x4e, 0x83, 0xae, 0xc3,
	0xa6, 0x56, 0x2d, 0x8d, 0x4c, 0x4b, 0x9d, 0x44, 0x90, 0x3d, 0x4b, 0xe1, 0xec, 0x67, 0xf9, 0x6a,
	0x00, 0x3a, 0x62, 0x09, 0x7f, 0x8a, 0xff, 0x3f, 0xad, 0x6e, 0xc0, 0x45, 0x3a, 0x9e, 0x8a, 0x90,
	0x05, 0xfd, 0xb3, 0x5b, 0x96, 0xb4, 0x4c, 0xfd, 0x9a, 0x0e, 0x94, 0x04, 0xe5, 0x3e, 0x4b, 0x86,
	0xb3, 0x2e, 0xab, 0xca, 0x72, 0x38, 0x32, 0xae, 0x06, 0x53, 0x14, 0xd9, 0x07, 0xee, 0x41, 0x71,
	0x2e, 0x87, 0x9a, 0xb0, 0xe5, 0x91, 0x09, 0x13, 0x3e, 0xa1, 0x6a, 0x8b, 0xb6, 0x9c, 0x2c, 0xf0,
	0xaf, 0x23, 0xe8, 0x7c, 0xda, 0x80, 0xa2, 0x33, 0x20, 0xb4, 0xa7, 0x96, 0x1d, 0x3d, 0x82, 0x4d,
	0xbd, 0x1f, 0xa8, 0x12, 0xd3, 0x38, 0x4c, 0xf0, 0x69, 0x40, 0x59, 0xf7, 0xf4, 0xc1, 0xbd, 0x86,
	0x7c, 0xbc, 0xdc, 0x22, 0xe3, 0xfd, 0x8f, 0x3f, 0x7e, 0x7f, 0x2e, 0xd4, 0x50, 0x35, 0x39, 0xd0,
	0xb6, 0x74, 0x6e, 0xbf, 0x77, 0x87, 0x1f, 0xd0, 0x7d, 0xd8, 0x4a, 0xaf, 0x06, 0x95, 0xa4, 0x21,
	0x79, 0x7b, 0x32, 0x65, 0xc1, 0x69, 0xa3, 0x16, 0x7f, 0x2d, 0x9d, 0x14, 0xae, 0x4b, 0xbb, 0x0a,
	0xda, 0x5e, 0xb4, 0x43, 0x2f, 0x61, 0x7b, 0x71, 0x71, 0x57, 0xf0, 0x35, 0xe6, 0xf8, 0x72, 0xeb,
	0x8d, 0x5b, 0xd2, 0xd7, 0x44, 0xf5, 0xd4, 0x37, 0xb9, 0x09, 0x45, 0xfa, 0x1c, 0x2a, 0xf9, 0x4b,
	0xcb, 0x01, 0x37, 0xe7, 0x81, 0xf3, 0xd7, 0x88, 0xf7, 0xa4, 0x7f, 0x15, 0xed, 0x2c, 0xf9, 0xa3,
	0x27, 0x00, 0xd9, 0x96, 0xad, 0xc0, 0xae, 0x6b, 0xec, 0xdc, 0x1e, 0xe2, 0xcb, 0xd2, 0x72, 0x17,
	0xd5, 0x52, 0x4b, 0xbd, 0x75, 0x8a, 0xf8, 0x04, 0x4a, 0xf3, 0xd7, 0x97, 0xa3, 0x35, 0x13, 0xda,
	0xfc, 0x75, 0xae, 0x20, 0xd5, 0xb6, 0xa2, 0x6b, 0x7d, 0x9b, 0xb5, 0x8c, 0xef, 0xb3, 0x96, 0xf1,
	0x73, 0xd6, 0x32, 0xbe, 0xfc, 0x6a, 0xad, 0x81, 0xe9, 0x72, 0x4b, 0x84, 0x84, 0xbe, 0x09, 0xf8,
	0x3b, 0xf5, 0x4f, 0x68, 0x11, 0xdf, 0xb5, 0x22, 0xfb, 0x45, 0x21, 0xb2, 0x9f, 0xad, 0x0d, 0xce,
	0xcb, 0xd8, 0xe1, 0x9f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x81, 0xaa, 0xcb, 0x46, 0xa2, 0x05, 0x00,
	0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// RbacServiceClient is the client API for RbacService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConnInterface.NewStream.
type RbacServiceClient interface {
	GetRole(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*GetRoleResponse, error)
	ListRoles(ctx context.Context, in *RawQuery, opts ...grpc.CallOption) (*ListRolesResponse, error)
	GetRoleBinding(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*GetRoleBindingResponse, error)
	ListRoleBindings(ctx context.Context, in *RawQuery, opts ...grpc.CallOption) (*ListRoleBindingsResponse, error)
	// Subjects served from this API are Groups and Users only.
	// Id in this case is the Name field, since for users and groups, that is unique, and subjects do not have IDs.
	GetSubject(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*GetSubjectResponse, error)
	ListSubjects(ctx context.Context, in *RawQuery, opts ...grpc.CallOption) (*ListSubjectsResponse, error)
}

type rbacServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewRbacServiceClient(cc grpc.ClientConnInterface) RbacServiceClient {
	return &rbacServiceClient{cc}
}

func (c *rbacServiceClient) GetRole(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*GetRoleResponse, error) {
	out := new(GetRoleResponse)
	err := c.cc.Invoke(ctx, "/v1.RbacService/GetRole", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *rbacServiceClient) ListRoles(ctx context.Context, in *RawQuery, opts ...grpc.CallOption) (*ListRolesResponse, error) {
	out := new(ListRolesResponse)
	err := c.cc.Invoke(ctx, "/v1.RbacService/ListRoles", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *rbacServiceClient) GetRoleBinding(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*GetRoleBindingResponse, error) {
	out := new(GetRoleBindingResponse)
	err := c.cc.Invoke(ctx, "/v1.RbacService/GetRoleBinding", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *rbacServiceClient) ListRoleBindings(ctx context.Context, in *RawQuery, opts ...grpc.CallOption) (*ListRoleBindingsResponse, error) {
	out := new(ListRoleBindingsResponse)
	err := c.cc.Invoke(ctx, "/v1.RbacService/ListRoleBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *rbacServiceClient) GetSubject(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*GetSubjectResponse, error) {
	out := new(GetSubjectResponse)
	err := c.cc.Invoke(ctx, "/v1.RbacService/GetSubject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *rbacServiceClient) ListSubjects(ctx context.Context, in *RawQuery, opts ...grpc.CallOption) (*ListSubjectsResponse, error) {
	out := new(ListSubjectsResponse)
	err := c.cc.Invoke(ctx, "/v1.RbacService/ListSubjects", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RbacServiceServer is the server API for RbacService service.
type RbacServiceServer interface {
	GetRole(context.Context, *ResourceByID) (*GetRoleResponse, error)
	ListRoles(context.Context, *RawQuery) (*ListRolesResponse, error)
	GetRoleBinding(context.Context, *ResourceByID) (*GetRoleBindingResponse, error)
	ListRoleBindings(context.Context, *RawQuery) (*ListRoleBindingsResponse, error)
	// Subjects served from this API are Groups and Users only.
	// Id in this case is the Name field, since for users and groups, that is unique, and subjects do not have IDs.
	GetSubject(context.Context, *ResourceByID) (*GetSubjectResponse, error)
	ListSubjects(context.Context, *RawQuery) (*ListSubjectsResponse, error)
}

// UnimplementedRbacServiceServer can be embedded to have forward compatible implementations.
type UnimplementedRbacServiceServer struct {
}

func (*UnimplementedRbacServiceServer) GetRole(ctx context.Context, req *ResourceByID) (*GetRoleResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRole not implemented")
}
func (*UnimplementedRbacServiceServer) ListRoles(ctx context.Context, req *RawQuery) (*ListRolesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRoles not implemented")
}
func (*UnimplementedRbacServiceServer) GetRoleBinding(ctx context.Context, req *ResourceByID) (*GetRoleBindingResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRoleBinding not implemented")
}
func (*UnimplementedRbacServiceServer) ListRoleBindings(ctx context.Context, req *RawQuery) (*ListRoleBindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRoleBindings not implemented")
}
func (*UnimplementedRbacServiceServer) GetSubject(ctx context.Context, req *ResourceByID) (*GetSubjectResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSubject not implemented")
}
func (*UnimplementedRbacServiceServer) ListSubjects(ctx context.Context, req *RawQuery) (*ListSubjectsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSubjects not implemented")
}

func RegisterRbacServiceServer(s *grpc.Server, srv RbacServiceServer) {
	s.RegisterService(&_RbacService_serviceDesc, srv)
}

func _RbacService_GetRole_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RbacServiceServer).GetRole(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.RbacService/GetRole",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RbacServiceServer).GetRole(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

func _RbacService_ListRoles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RawQuery)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RbacServiceServer).ListRoles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.RbacService/ListRoles",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RbacServiceServer).ListRoles(ctx, req.(*RawQuery))
	}
	return interceptor(ctx, in, info, handler)
}

func _RbacService_GetRoleBinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RbacServiceServer).GetRoleBinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.RbacService/GetRoleBinding",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RbacServiceServer).GetRoleBinding(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

func _RbacService_ListRoleBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RawQuery)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RbacServiceServer).ListRoleBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.RbacService/ListRoleBindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RbacServiceServer).ListRoleBindings(ctx, req.(*RawQuery))
	}
	return interceptor(ctx, in, info, handler)
}

func _RbacService_GetSubject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RbacServiceServer).GetSubject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.RbacService/GetSubject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RbacServiceServer).GetSubject(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

func _RbacService_ListSubjects_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RawQuery)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RbacServiceServer).ListSubjects(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.RbacService/ListSubjects",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RbacServiceServer).ListSubjects(ctx, req.(*RawQuery))
	}
	return interceptor(ctx, in, info, handler)
}

var _RbacService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1.RbacService",
	HandlerType: (*RbacServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetRole",
			Handler:    _RbacService_GetRole_Handler,
		},
		{
			MethodName: "ListRoles",
			Handler:    _RbacService_ListRoles_Handler,
		},
		{
			MethodName: "GetRoleBinding",
			Handler:    _RbacService_GetRoleBinding_Handler,
		},
		{
			MethodName: "ListRoleBindings",
			Handler:    _RbacService_ListRoleBindings_Handler,
		},
		{
			MethodName: "GetSubject",
			Handler:    _RbacService_GetSubject_Handler,
		},
		{
			MethodName: "ListSubjects",
			Handler:    _RbacService_ListSubjects_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/v1/rbac_service.proto",
}

func (m *ListRolesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListRolesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListRolesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Roles) > 0 {
		for iNdEx := len(m.Roles) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Roles[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRbacService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *GetRoleResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetRoleResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetRoleResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Role != nil {
		{
			size, err := m.Role.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRbacService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ListRoleBindingsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListRoleBindingsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListRoleBindingsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Bindings) > 0 {
		for iNdEx := len(m.Bindings) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Bindings[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRbacService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *GetRoleBindingResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetRoleBindingResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetRoleBindingResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Binding != nil {
		{
			size, err := m.Binding.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRbacService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ListSubjectsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListSubjectsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListSubjectsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.SubjectAndRoles) > 0 {
		for iNdEx := len(m.SubjectAndRoles) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.SubjectAndRoles[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRbacService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *SubjectAndRoles) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SubjectAndRoles) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SubjectAndRoles) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Roles) > 0 {
		for iNdEx := len(m.Roles) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Roles[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRbacService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Subject != nil {
		{
			size, err := m.Subject.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRbacService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetSubjectResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetSubjectResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetSubjectResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ScopedRoles) > 0 {
		for iNdEx := len(m.ScopedRoles) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ScopedRoles[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRbacService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.ClusterRoles) > 0 {
		for iNdEx := len(m.ClusterRoles) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ClusterRoles[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRbacService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Subject != nil {
		{
			size, err := m.Subject.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRbacService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ScopedRoles) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ScopedRoles) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScopedRoles) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Roles) > 0 {
		for iNdEx := len(m.Roles) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Roles[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRbacService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintRbacService(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintRbacService(dAtA []byte, offset int, v uint64) int {
	offset -= sovRbacService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ListRolesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Roles) > 0 {
		for _, e := range m.Roles {
			l = e.Size()
			n += 1 + l + sovRbacService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetRoleResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Role != nil {
		l = m.Role.Size()
		n += 1 + l + sovRbacService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListRoleBindingsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Bindings) > 0 {
		for _, e := range m.Bindings {
			l = e.Size()
			n += 1 + l + sovRbacService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetRoleBindingResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Binding != nil {
		l = m.Binding.Size()
		n += 1 + l + sovRbacService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListSubjectsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.SubjectAndRoles) > 0 {
		for _, e := range m.SubjectAndRoles {
			l = e.Size()
			n += 1 + l + sovRbacService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SubjectAndRoles) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Subject != nil {
		l = m.Subject.Size()
		n += 1 + l + sovRbacService(uint64(l))
	}
	if len(m.Roles) > 0 {
		for _, e := range m.Roles {
			l = e.Size()
			n += 1 + l + sovRbacService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetSubjectResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Subject != nil {
		l = m.Subject.Size()
		n += 1 + l + sovRbacService(uint64(l))
	}
	if len(m.ClusterRoles) > 0 {
		for _, e := range m.ClusterRoles {
			l = e.Size()
			n += 1 + l + sovRbacService(uint64(l))
		}
	}
	if len(m.ScopedRoles) > 0 {
		for _, e := range m.ScopedRoles {
			l = e.Size()
			n += 1 + l + sovRbacService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ScopedRoles) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovRbacService(uint64(l))
	}
	if len(m.Roles) > 0 {
		for _, e := range m.Roles {
			l = e.Size()
			n += 1 + l + sovRbacService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovRbacService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozRbacService(x uint64) (n int) {
	return sovRbacService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ListRolesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRbacService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListRolesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListRolesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Roles", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbacService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRbacService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRbacService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Roles = append(m.Roles, &storage.K8SRole{})
			if err := m.Roles[len(m.Roles)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRbacService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRbacService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetRoleResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRbacService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetRoleResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetRoleResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Role", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbacService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRbacService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRbacService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Role == nil {
				m.Role = &storage.K8SRole{}
			}
			if err := m.Role.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRbacService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRbacService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListRoleBindingsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRbacService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListRoleBindingsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListRoleBindingsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bindings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbacService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRbacService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRbacService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Bindings = append(m.Bindings, &storage.K8SRoleBinding{})
			if err := m.Bindings[len(m.Bindings)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRbacService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRbacService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetRoleBindingResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRbacService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetRoleBindingResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetRoleBindingResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Binding", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbacService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRbacService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRbacService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Binding == nil {
				m.Binding = &storage.K8SRoleBinding{}
			}
			if err := m.Binding.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRbacService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRbacService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListSubjectsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRbacService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListSubjectsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListSubjectsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubjectAndRoles", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbacService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRbacService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRbacService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SubjectAndRoles = append(m.SubjectAndRoles, &SubjectAndRoles{})
			if err := m.SubjectAndRoles[len(m.SubjectAndRoles)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRbacService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRbacService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SubjectAndRoles) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRbacService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SubjectAndRoles: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SubjectAndRoles: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subject", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbacService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRbacService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRbacService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Subject == nil {
				m.Subject = &storage.Subject{}
			}
			if err := m.Subject.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Roles", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbacService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRbacService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRbacService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Roles = append(m.Roles, &storage.K8SRole{})
			if err := m.Roles[len(m.Roles)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRbacService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRbacService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetSubjectResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRbacService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetSubjectResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetSubjectResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subject", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbacService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRbacService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRbacService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Subject == nil {
				m.Subject = &storage.Subject{}
			}
			if err := m.Subject.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterRoles", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbacService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRbacService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRbacService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterRoles = append(m.ClusterRoles, &storage.K8SRole{})
			if err := m.ClusterRoles[len(m.ClusterRoles)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScopedRoles", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbacService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRbacService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRbacService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ScopedRoles = append(m.ScopedRoles, &ScopedRoles{})
			if err := m.ScopedRoles[len(m.ScopedRoles)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRbacService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRbacService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ScopedRoles) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRbacService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ScopedRoles: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ScopedRoles: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbacService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRbacService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRbacService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Roles", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRbacService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRbacService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRbacService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Roles = append(m.Roles, &storage.K8SRole{})
			if err := m.Roles[len(m.Roles)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRbacService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRbacService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipRbacService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowRbacService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRbacService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRbacService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthRbacService
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupRbacService
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthRbacService
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthRbacService        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowRbacService          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupRbacService = fmt.Errorf("proto: unexpected end of group")
)
