// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api/v1/report_configuration_service.proto

package v1

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	storage "github.com/stackrox/rox/generated/storage"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type GetReportConfigurationsResponse struct {
	ReportConfigs        []*storage.ReportConfiguration `protobuf:"bytes,1,rep,name=report_configs,json=reportConfigs,proto3" json:"report_configs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *GetReportConfigurationsResponse) Reset()         { *m = GetReportConfigurationsResponse{} }
func (m *GetReportConfigurationsResponse) String() string { return proto.CompactTextString(m) }
func (*GetReportConfigurationsResponse) ProtoMessage()    {}
func (*GetReportConfigurationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_d908ae451b889f35, []int{0}
}
func (m *GetReportConfigurationsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetReportConfigurationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetReportConfigurationsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetReportConfigurationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetReportConfigurationsResponse.Merge(m, src)
}
func (m *GetReportConfigurationsResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetReportConfigurationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetReportConfigurationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetReportConfigurationsResponse proto.InternalMessageInfo

func (m *GetReportConfigurationsResponse) GetReportConfigs() []*storage.ReportConfiguration {
	if m != nil {
		return m.ReportConfigs
	}
	return nil
}

func (m *GetReportConfigurationsResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetReportConfigurationsResponse) Clone() *GetReportConfigurationsResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetReportConfigurationsResponse)
	*cloned = *m

	if m.ReportConfigs != nil {
		cloned.ReportConfigs = make([]*storage.ReportConfiguration, len(m.ReportConfigs))
		for idx, v := range m.ReportConfigs {
			cloned.ReportConfigs[idx] = v.Clone()
		}
	}
	return cloned
}

type GetReportConfigurationResponse struct {
	ReportConfig         *storage.ReportConfiguration `protobuf:"bytes,1,opt,name=report_config,json=reportConfig,proto3" json:"report_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *GetReportConfigurationResponse) Reset()         { *m = GetReportConfigurationResponse{} }
func (m *GetReportConfigurationResponse) String() string { return proto.CompactTextString(m) }
func (*GetReportConfigurationResponse) ProtoMessage()    {}
func (*GetReportConfigurationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_d908ae451b889f35, []int{1}
}
func (m *GetReportConfigurationResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetReportConfigurationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetReportConfigurationResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetReportConfigurationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetReportConfigurationResponse.Merge(m, src)
}
func (m *GetReportConfigurationResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetReportConfigurationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetReportConfigurationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetReportConfigurationResponse proto.InternalMessageInfo

func (m *GetReportConfigurationResponse) GetReportConfig() *storage.ReportConfiguration {
	if m != nil {
		return m.ReportConfig
	}
	return nil
}

func (m *GetReportConfigurationResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetReportConfigurationResponse) Clone() *GetReportConfigurationResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetReportConfigurationResponse)
	*cloned = *m

	cloned.ReportConfig = m.ReportConfig.Clone()
	return cloned
}

type PostReportConfigurationResponse struct {
	ReportConfig         *storage.ReportConfiguration `protobuf:"bytes,1,opt,name=report_config,json=reportConfig,proto3" json:"report_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *PostReportConfigurationResponse) Reset()         { *m = PostReportConfigurationResponse{} }
func (m *PostReportConfigurationResponse) String() string { return proto.CompactTextString(m) }
func (*PostReportConfigurationResponse) ProtoMessage()    {}
func (*PostReportConfigurationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_d908ae451b889f35, []int{2}
}
func (m *PostReportConfigurationResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PostReportConfigurationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PostReportConfigurationResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PostReportConfigurationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PostReportConfigurationResponse.Merge(m, src)
}
func (m *PostReportConfigurationResponse) XXX_Size() int {
	return m.Size()
}
func (m *PostReportConfigurationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PostReportConfigurationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PostReportConfigurationResponse proto.InternalMessageInfo

func (m *PostReportConfigurationResponse) GetReportConfig() *storage.ReportConfiguration {
	if m != nil {
		return m.ReportConfig
	}
	return nil
}

func (m *PostReportConfigurationResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *PostReportConfigurationResponse) Clone() *PostReportConfigurationResponse {
	if m == nil {
		return nil
	}
	cloned := new(PostReportConfigurationResponse)
	*cloned = *m

	cloned.ReportConfig = m.ReportConfig.Clone()
	return cloned
}

type PostReportConfigurationRequest struct {
	ReportConfig         *storage.ReportConfiguration `protobuf:"bytes,1,opt,name=report_config,json=reportConfig,proto3" json:"report_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *PostReportConfigurationRequest) Reset()         { *m = PostReportConfigurationRequest{} }
func (m *PostReportConfigurationRequest) String() string { return proto.CompactTextString(m) }
func (*PostReportConfigurationRequest) ProtoMessage()    {}
func (*PostReportConfigurationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d908ae451b889f35, []int{3}
}
func (m *PostReportConfigurationRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PostReportConfigurationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PostReportConfigurationRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PostReportConfigurationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PostReportConfigurationRequest.Merge(m, src)
}
func (m *PostReportConfigurationRequest) XXX_Size() int {
	return m.Size()
}
func (m *PostReportConfigurationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PostReportConfigurationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PostReportConfigurationRequest proto.InternalMessageInfo

func (m *PostReportConfigurationRequest) GetReportConfig() *storage.ReportConfiguration {
	if m != nil {
		return m.ReportConfig
	}
	return nil
}

func (m *PostReportConfigurationRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *PostReportConfigurationRequest) Clone() *PostReportConfigurationRequest {
	if m == nil {
		return nil
	}
	cloned := new(PostReportConfigurationRequest)
	*cloned = *m

	cloned.ReportConfig = m.ReportConfig.Clone()
	return cloned
}

type UpdateReportConfigurationRequest struct {
	Id                   string                       `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	ReportConfig         *storage.ReportConfiguration `protobuf:"bytes,2,opt,name=report_config,json=reportConfig,proto3" json:"report_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *UpdateReportConfigurationRequest) Reset()         { *m = UpdateReportConfigurationRequest{} }
func (m *UpdateReportConfigurationRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateReportConfigurationRequest) ProtoMessage()    {}
func (*UpdateReportConfigurationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d908ae451b889f35, []int{4}
}
func (m *UpdateReportConfigurationRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpdateReportConfigurationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UpdateReportConfigurationRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UpdateReportConfigurationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateReportConfigurationRequest.Merge(m, src)
}
func (m *UpdateReportConfigurationRequest) XXX_Size() int {
	return m.Size()
}
func (m *UpdateReportConfigurationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateReportConfigurationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateReportConfigurationRequest proto.InternalMessageInfo

func (m *UpdateReportConfigurationRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *UpdateReportConfigurationRequest) GetReportConfig() *storage.ReportConfiguration {
	if m != nil {
		return m.ReportConfig
	}
	return nil
}

func (m *UpdateReportConfigurationRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *UpdateReportConfigurationRequest) Clone() *UpdateReportConfigurationRequest {
	if m == nil {
		return nil
	}
	cloned := new(UpdateReportConfigurationRequest)
	*cloned = *m

	cloned.ReportConfig = m.ReportConfig.Clone()
	return cloned
}

type CountReportConfigurationsResponse struct {
	Count                int32    `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CountReportConfigurationsResponse) Reset()         { *m = CountReportConfigurationsResponse{} }
func (m *CountReportConfigurationsResponse) String() string { return proto.CompactTextString(m) }
func (*CountReportConfigurationsResponse) ProtoMessage()    {}
func (*CountReportConfigurationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_d908ae451b889f35, []int{5}
}
func (m *CountReportConfigurationsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CountReportConfigurationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CountReportConfigurationsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CountReportConfigurationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CountReportConfigurationsResponse.Merge(m, src)
}
func (m *CountReportConfigurationsResponse) XXX_Size() int {
	return m.Size()
}
func (m *CountReportConfigurationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CountReportConfigurationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CountReportConfigurationsResponse proto.InternalMessageInfo

func (m *CountReportConfigurationsResponse) GetCount() int32 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *CountReportConfigurationsResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *CountReportConfigurationsResponse) Clone() *CountReportConfigurationsResponse {
	if m == nil {
		return nil
	}
	cloned := new(CountReportConfigurationsResponse)
	*cloned = *m

	return cloned
}

func init() {
	proto.RegisterType((*GetReportConfigurationsResponse)(nil), "v1.GetReportConfigurationsResponse")
	proto.RegisterType((*GetReportConfigurationResponse)(nil), "v1.GetReportConfigurationResponse")
	proto.RegisterType((*PostReportConfigurationResponse)(nil), "v1.PostReportConfigurationResponse")
	proto.RegisterType((*PostReportConfigurationRequest)(nil), "v1.PostReportConfigurationRequest")
	proto.RegisterType((*UpdateReportConfigurationRequest)(nil), "v1.UpdateReportConfigurationRequest")
	proto.RegisterType((*CountReportConfigurationsResponse)(nil), "v1.CountReportConfigurationsResponse")
}

func init() {
	proto.RegisterFile("api/v1/report_configuration_service.proto", fileDescriptor_d908ae451b889f35)
}

var fileDescriptor_d908ae451b889f35 = []byte{
	// 522 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0xd4, 0xcf, 0x6b, 0xd4, 0x40,
	0x14, 0x07, 0xf0, 0x26, 0x52, 0xa1, 0xcf, 0xb6, 0xc8, 0x28, 0x76, 0x37, 0x2d, 0xd9, 0xdd, 0x69,
	0xfd, 0xd1, 0x42, 0x13, 0x52, 0x4f, 0x7a, 0xb3, 0x5b, 0x11, 0x6f, 0x1a, 0x11, 0xc4, 0x4b, 0x8d,
	0x93, 0xe9, 0x1a, 0xec, 0xe6, 0xc5, 0x99, 0x49, 0xea, 0x22, 0x5e, 0x3c, 0x79, 0xf7, 0xe2, 0x9f,
	0xe4, 0x51, 0xf0, 0x1f, 0x90, 0x55, 0xfc, 0x3b, 0x24, 0x93, 0xd0, 0x6e, 0x6c, 0xb2, 0x41, 0xd0,
	0xe3, 0xbc, 0x7d, 0xf3, 0x3e, 0xc9, 0xe3, 0xbb, 0x81, 0xed, 0x20, 0x89, 0xdc, 0xcc, 0x73, 0x05,
	0x4f, 0x50, 0xa8, 0x43, 0x86, 0xf1, 0x51, 0x34, 0x4a, 0x45, 0xa0, 0x22, 0x8c, 0x0f, 0x25, 0x17,
	0x59, 0xc4, 0xb8, 0x93, 0x08, 0x54, 0x48, 0xcc, 0xcc, 0xb3, 0x36, 0x46, 0x88, 0xa3, 0x63, 0xee,
	0xe6, 0xb7, 0x82, 0x38, 0x46, 0xa5, 0x1b, 0x65, 0xd1, 0x61, 0x5d, 0x29, 0x87, 0x31, 0x1c, 0x8f,
	0x31, 0x2e, 0x8b, 0xa4, 0x2c, 0xf2, 0x71, 0xa2, 0x26, 0x65, 0x6d, 0xbd, 0xac, 0x49, 0x1e, 0x08,
	0xf6, 0xaa, 0xea, 0x58, 0x54, 0x2a, 0x14, 0xc1, 0x88, 0xd7, 0x3e, 0x53, 0xd1, 0x43, 0x8f, 0xa0,
	0xf7, 0x80, 0x2b, 0x5f, 0x37, 0x0c, 0x67, 0x7f, 0x97, 0x3e, 0x97, 0x09, 0xc6, 0x92, 0x93, 0x21,
	0xac, 0x56, 0x06, 0xc8, 0x8e, 0xd1, 0xbf, 0x70, 0xeb, 0xd2, 0xde, 0x86, 0x53, 0xce, 0x77, 0x6a,
	0xae, 0xfb, 0x2b, 0x62, 0xa6, 0x28, 0x29, 0x03, 0xbb, 0xde, 0x39, 0x65, 0xee, 0xc1, 0x4a, 0x85,
	0xe9, 0x18, 0x7d, 0xa3, 0x55, 0x59, 0x9e, 0x55, 0x68, 0x08, 0xbd, 0x47, 0x28, 0xff, 0xb7, 0xc2,
	0xc0, 0x6e, 0x54, 0xde, 0xa4, 0x5c, 0xaa, 0x7f, 0x81, 0xa4, 0xd0, 0x7f, 0x9a, 0x84, 0x81, 0xe2,
	0x73, 0x98, 0x55, 0x30, 0xa3, 0x50, 0xcf, 0x5e, 0xf2, 0xcd, 0x28, 0x3c, 0xcf, 0x9a, 0x7f, 0xcd,
	0xde, 0x81, 0xc1, 0x10, 0xd3, 0x78, 0x7e, 0x20, 0xae, 0xc2, 0x22, 0xcb, 0x9b, 0x34, 0xbd, 0xe8,
	0x17, 0x87, 0xbd, 0x5f, 0x8b, 0x60, 0xd5, 0x5c, 0x7b, 0x52, 0x44, 0x92, 0x20, 0xac, 0x35, 0x04,
	0x8d, 0x2c, 0x3b, 0x99, 0xe7, 0xf8, 0xc1, 0xc9, 0xe3, 0x94, 0x8b, 0x89, 0xb5, 0x99, 0x9f, 0x5a,
	0x32, 0x49, 0x07, 0x1f, 0xbe, 0xfd, 0xfc, 0x64, 0xae, 0x93, 0xee, 0xd9, 0x5f, 0xce, 0x65, 0xd5,
	0xa9, 0x19, 0x5c, 0xab, 0x9f, 0x42, 0x2e, 0x6b, 0x8f, 0x4b, 0x4c, 0x05, 0xe3, 0xfb, 0x93, 0x87,
	0x07, 0x16, 0x6d, 0x36, 0x4f, 0xc9, 0x1b, 0x9a, 0xec, 0x13, 0xbb, 0x91, 0x74, 0xdf, 0x45, 0xe1,
	0x7b, 0xf2, 0xd1, 0x80, 0xb5, 0x86, 0x7c, 0x10, 0xed, 0xcc, 0x0f, 0x4f, 0xf1, 0xfe, 0x2d, 0x31,
	0xa6, 0x5b, 0xfa, 0x61, 0x6c, 0xda, 0xfc, 0xfe, 0x77, 0x8d, 0x1d, 0x72, 0x02, 0xdd, 0xc6, 0x10,
	0x91, 0xad, 0xdc, 0x69, 0xcb, 0x98, 0xb5, 0x94, 0x77, 0xdd, 0xcf, 0xbf, 0x38, 0x74, 0x5b, 0x9b,
	0x9b, 0x56, 0xcb, 0x02, 0x72, 0xf8, 0x05, 0x74, 0x0f, 0xf8, 0x31, 0xaf, 0x87, 0xcf, 0xaf, 0x7f,
	0x06, 0x29, 0xb7, 0xbc, 0xd3, 0xb6, 0xe5, 0x09, 0x74, 0x1b, 0x83, 0xfa, 0x47, 0xa0, 0xae, 0xe7,
	0xa7, 0xd6, 0x54, 0xd3, 0x9b, 0x5a, 0x1e, 0x90, 0xde, 0x99, 0xbc, 0x5b, 0x95, 0x77, 0x75, 0xd0,
	0xf7, 0x9d, 0x2f, 0x53, 0xdb, 0xf8, 0x3a, 0xb5, 0x8d, 0xef, 0x53, 0xdb, 0xf8, 0xfc, 0xc3, 0x5e,
	0x80, 0x4e, 0x84, 0x8e, 0x54, 0x01, 0x7b, 0x2d, 0xf0, 0x6d, 0xf1, 0x5d, 0x75, 0x82, 0x24, 0x72,
	0x32, 0xef, 0xb9, 0x99, 0x79, 0xcf, 0x16, 0x5e, 0x5e, 0xd4, 0xb5, 0xdb, 0xbf, 0x03, 0x00, 0x00,
	0xff, 0xff, 0xfe, 0x80, 0xdf, 0xfc, 0x24, 0x06, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ReportConfigurationServiceClient is the client API for ReportConfigurationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConnInterface.NewStream.
type ReportConfigurationServiceClient interface {
	GetReportConfigurations(ctx context.Context, in *RawQuery, opts ...grpc.CallOption) (*GetReportConfigurationsResponse, error)
	GetReportConfiguration(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*GetReportConfigurationResponse, error)
	// PostReportConfiguration creates a report configuration
	PostReportConfiguration(ctx context.Context, in *PostReportConfigurationRequest, opts ...grpc.CallOption) (*PostReportConfigurationResponse, error)
	// UpdateReportConfiguration updates a report configuration
	UpdateReportConfiguration(ctx context.Context, in *UpdateReportConfigurationRequest, opts ...grpc.CallOption) (*Empty, error)
	// DeleteReportConfiguration removes a report configuration given its id
	DeleteReportConfiguration(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*Empty, error)
	// CountReportConfigurations returns the number of report configurations.
	CountReportConfigurations(ctx context.Context, in *RawQuery, opts ...grpc.CallOption) (*CountReportConfigurationsResponse, error)
}

type reportConfigurationServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewReportConfigurationServiceClient(cc grpc.ClientConnInterface) ReportConfigurationServiceClient {
	return &reportConfigurationServiceClient{cc}
}

func (c *reportConfigurationServiceClient) GetReportConfigurations(ctx context.Context, in *RawQuery, opts ...grpc.CallOption) (*GetReportConfigurationsResponse, error) {
	out := new(GetReportConfigurationsResponse)
	err := c.cc.Invoke(ctx, "/v1.ReportConfigurationService/GetReportConfigurations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reportConfigurationServiceClient) GetReportConfiguration(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*GetReportConfigurationResponse, error) {
	out := new(GetReportConfigurationResponse)
	err := c.cc.Invoke(ctx, "/v1.ReportConfigurationService/GetReportConfiguration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reportConfigurationServiceClient) PostReportConfiguration(ctx context.Context, in *PostReportConfigurationRequest, opts ...grpc.CallOption) (*PostReportConfigurationResponse, error) {
	out := new(PostReportConfigurationResponse)
	err := c.cc.Invoke(ctx, "/v1.ReportConfigurationService/PostReportConfiguration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reportConfigurationServiceClient) UpdateReportConfiguration(ctx context.Context, in *UpdateReportConfigurationRequest, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.ReportConfigurationService/UpdateReportConfiguration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reportConfigurationServiceClient) DeleteReportConfiguration(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.ReportConfigurationService/DeleteReportConfiguration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reportConfigurationServiceClient) CountReportConfigurations(ctx context.Context, in *RawQuery, opts ...grpc.CallOption) (*CountReportConfigurationsResponse, error) {
	out := new(CountReportConfigurationsResponse)
	err := c.cc.Invoke(ctx, "/v1.ReportConfigurationService/CountReportConfigurations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ReportConfigurationServiceServer is the server API for ReportConfigurationService service.
type ReportConfigurationServiceServer interface {
	GetReportConfigurations(context.Context, *RawQuery) (*GetReportConfigurationsResponse, error)
	GetReportConfiguration(context.Context, *ResourceByID) (*GetReportConfigurationResponse, error)
	// PostReportConfiguration creates a report configuration
	PostReportConfiguration(context.Context, *PostReportConfigurationRequest) (*PostReportConfigurationResponse, error)
	// UpdateReportConfiguration updates a report configuration
	UpdateReportConfiguration(context.Context, *UpdateReportConfigurationRequest) (*Empty, error)
	// DeleteReportConfiguration removes a report configuration given its id
	DeleteReportConfiguration(context.Context, *ResourceByID) (*Empty, error)
	// CountReportConfigurations returns the number of report configurations.
	CountReportConfigurations(context.Context, *RawQuery) (*CountReportConfigurationsResponse, error)
}

// UnimplementedReportConfigurationServiceServer can be embedded to have forward compatible implementations.
type UnimplementedReportConfigurationServiceServer struct {
}

func (*UnimplementedReportConfigurationServiceServer) GetReportConfigurations(ctx context.Context, req *RawQuery) (*GetReportConfigurationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetReportConfigurations not implemented")
}
func (*UnimplementedReportConfigurationServiceServer) GetReportConfiguration(ctx context.Context, req *ResourceByID) (*GetReportConfigurationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetReportConfiguration not implemented")
}
func (*UnimplementedReportConfigurationServiceServer) PostReportConfiguration(ctx context.Context, req *PostReportConfigurationRequest) (*PostReportConfigurationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PostReportConfiguration not implemented")
}
func (*UnimplementedReportConfigurationServiceServer) UpdateReportConfiguration(ctx context.Context, req *UpdateReportConfigurationRequest) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateReportConfiguration not implemented")
}
func (*UnimplementedReportConfigurationServiceServer) DeleteReportConfiguration(ctx context.Context, req *ResourceByID) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteReportConfiguration not implemented")
}
func (*UnimplementedReportConfigurationServiceServer) CountReportConfigurations(ctx context.Context, req *RawQuery) (*CountReportConfigurationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CountReportConfigurations not implemented")
}

func RegisterReportConfigurationServiceServer(s *grpc.Server, srv ReportConfigurationServiceServer) {
	s.RegisterService(&_ReportConfigurationService_serviceDesc, srv)
}

func _ReportConfigurationService_GetReportConfigurations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RawQuery)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReportConfigurationServiceServer).GetReportConfigurations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ReportConfigurationService/GetReportConfigurations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReportConfigurationServiceServer).GetReportConfigurations(ctx, req.(*RawQuery))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReportConfigurationService_GetReportConfiguration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReportConfigurationServiceServer).GetReportConfiguration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ReportConfigurationService/GetReportConfiguration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReportConfigurationServiceServer).GetReportConfiguration(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReportConfigurationService_PostReportConfiguration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PostReportConfigurationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReportConfigurationServiceServer).PostReportConfiguration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ReportConfigurationService/PostReportConfiguration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReportConfigurationServiceServer).PostReportConfiguration(ctx, req.(*PostReportConfigurationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReportConfigurationService_UpdateReportConfiguration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateReportConfigurationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReportConfigurationServiceServer).UpdateReportConfiguration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ReportConfigurationService/UpdateReportConfiguration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReportConfigurationServiceServer).UpdateReportConfiguration(ctx, req.(*UpdateReportConfigurationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReportConfigurationService_DeleteReportConfiguration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReportConfigurationServiceServer).DeleteReportConfiguration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ReportConfigurationService/DeleteReportConfiguration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReportConfigurationServiceServer).DeleteReportConfiguration(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReportConfigurationService_CountReportConfigurations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RawQuery)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReportConfigurationServiceServer).CountReportConfigurations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ReportConfigurationService/CountReportConfigurations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReportConfigurationServiceServer).CountReportConfigurations(ctx, req.(*RawQuery))
	}
	return interceptor(ctx, in, info, handler)
}

var _ReportConfigurationService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1.ReportConfigurationService",
	HandlerType: (*ReportConfigurationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetReportConfigurations",
			Handler:    _ReportConfigurationService_GetReportConfigurations_Handler,
		},
		{
			MethodName: "GetReportConfiguration",
			Handler:    _ReportConfigurationService_GetReportConfiguration_Handler,
		},
		{
			MethodName: "PostReportConfiguration",
			Handler:    _ReportConfigurationService_PostReportConfiguration_Handler,
		},
		{
			MethodName: "UpdateReportConfiguration",
			Handler:    _ReportConfigurationService_UpdateReportConfiguration_Handler,
		},
		{
			MethodName: "DeleteReportConfiguration",
			Handler:    _ReportConfigurationService_DeleteReportConfiguration_Handler,
		},
		{
			MethodName: "CountReportConfigurations",
			Handler:    _ReportConfigurationService_CountReportConfigurations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/v1/report_configuration_service.proto",
}

func (m *GetReportConfigurationsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetReportConfigurationsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetReportConfigurationsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ReportConfigs) > 0 {
		for iNdEx := len(m.ReportConfigs) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ReportConfigs[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintReportConfigurationService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *GetReportConfigurationResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetReportConfigurationResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetReportConfigurationResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ReportConfig != nil {
		{
			size, err := m.ReportConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintReportConfigurationService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PostReportConfigurationResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PostReportConfigurationResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PostReportConfigurationResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ReportConfig != nil {
		{
			size, err := m.ReportConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintReportConfigurationService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PostReportConfigurationRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PostReportConfigurationRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PostReportConfigurationRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ReportConfig != nil {
		{
			size, err := m.ReportConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintReportConfigurationService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *UpdateReportConfigurationRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpdateReportConfigurationRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UpdateReportConfigurationRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ReportConfig != nil {
		{
			size, err := m.ReportConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintReportConfigurationService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintReportConfigurationService(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CountReportConfigurationsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CountReportConfigurationsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CountReportConfigurationsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Count != 0 {
		i = encodeVarintReportConfigurationService(dAtA, i, uint64(m.Count))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintReportConfigurationService(dAtA []byte, offset int, v uint64) int {
	offset -= sovReportConfigurationService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *GetReportConfigurationsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ReportConfigs) > 0 {
		for _, e := range m.ReportConfigs {
			l = e.Size()
			n += 1 + l + sovReportConfigurationService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetReportConfigurationResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ReportConfig != nil {
		l = m.ReportConfig.Size()
		n += 1 + l + sovReportConfigurationService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PostReportConfigurationResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ReportConfig != nil {
		l = m.ReportConfig.Size()
		n += 1 + l + sovReportConfigurationService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PostReportConfigurationRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ReportConfig != nil {
		l = m.ReportConfig.Size()
		n += 1 + l + sovReportConfigurationService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *UpdateReportConfigurationRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovReportConfigurationService(uint64(l))
	}
	if m.ReportConfig != nil {
		l = m.ReportConfig.Size()
		n += 1 + l + sovReportConfigurationService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CountReportConfigurationsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Count != 0 {
		n += 1 + sovReportConfigurationService(uint64(m.Count))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovReportConfigurationService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozReportConfigurationService(x uint64) (n int) {
	return sovReportConfigurationService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *GetReportConfigurationsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowReportConfigurationService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetReportConfigurationsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetReportConfigurationsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReportConfigs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportConfigurationService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportConfigurationService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportConfigurationService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ReportConfigs = append(m.ReportConfigs, &storage.ReportConfiguration{})
			if err := m.ReportConfigs[len(m.ReportConfigs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipReportConfigurationService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthReportConfigurationService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetReportConfigurationResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowReportConfigurationService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetReportConfigurationResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetReportConfigurationResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReportConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportConfigurationService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportConfigurationService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportConfigurationService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReportConfig == nil {
				m.ReportConfig = &storage.ReportConfiguration{}
			}
			if err := m.ReportConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipReportConfigurationService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthReportConfigurationService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PostReportConfigurationResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowReportConfigurationService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PostReportConfigurationResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PostReportConfigurationResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReportConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportConfigurationService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportConfigurationService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportConfigurationService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReportConfig == nil {
				m.ReportConfig = &storage.ReportConfiguration{}
			}
			if err := m.ReportConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipReportConfigurationService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthReportConfigurationService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PostReportConfigurationRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowReportConfigurationService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PostReportConfigurationRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PostReportConfigurationRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReportConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportConfigurationService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportConfigurationService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportConfigurationService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReportConfig == nil {
				m.ReportConfig = &storage.ReportConfiguration{}
			}
			if err := m.ReportConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipReportConfigurationService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthReportConfigurationService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateReportConfigurationRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowReportConfigurationService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateReportConfigurationRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateReportConfigurationRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportConfigurationService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReportConfigurationService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReportConfigurationService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReportConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportConfigurationService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportConfigurationService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportConfigurationService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReportConfig == nil {
				m.ReportConfig = &storage.ReportConfiguration{}
			}
			if err := m.ReportConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipReportConfigurationService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthReportConfigurationService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CountReportConfigurationsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowReportConfigurationService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CountReportConfigurationsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CountReportConfigurationsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Count", wireType)
			}
			m.Count = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportConfigurationService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Count |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipReportConfigurationService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthReportConfigurationService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipReportConfigurationService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowReportConfigurationService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowReportConfigurationService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowReportConfigurationService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthReportConfigurationService
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupReportConfigurationService
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthReportConfigurationService
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthReportConfigurationService        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowReportConfigurationService          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupReportConfigurationService = fmt.Errorf("proto: unexpected end of group")
)
