// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api/v1/role_service.proto

package v1

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	storage "github.com/stackrox/rox/generated/storage"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type ComputeEffectiveAccessScopeRequest_Detail int32

const (
	ComputeEffectiveAccessScopeRequest_STANDARD ComputeEffectiveAccessScopeRequest_Detail = 0
	ComputeEffectiveAccessScopeRequest_MINIMAL  ComputeEffectiveAccessScopeRequest_Detail = 1
	ComputeEffectiveAccessScopeRequest_HIGH     ComputeEffectiveAccessScopeRequest_Detail = 2
)

var ComputeEffectiveAccessScopeRequest_Detail_name = map[int32]string{
	0: "STANDARD",
	1: "MINIMAL",
	2: "HIGH",
}

var ComputeEffectiveAccessScopeRequest_Detail_value = map[string]int32{
	"STANDARD": 0,
	"MINIMAL":  1,
	"HIGH":     2,
}

func (x ComputeEffectiveAccessScopeRequest_Detail) String() string {
	return proto.EnumName(ComputeEffectiveAccessScopeRequest_Detail_name, int32(x))
}

func (ComputeEffectiveAccessScopeRequest_Detail) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_f2751be16bbd500c, []int{6, 0}
}

type Permission struct {
	Resource             string         `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	Access               storage.Access `protobuf:"varint,2,opt,name=access,proto3,enum=storage.Access" json:"access,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Permission) Reset()         { *m = Permission{} }
func (m *Permission) String() string { return proto.CompactTextString(m) }
func (*Permission) ProtoMessage()    {}
func (*Permission) Descriptor() ([]byte, []int) {
	return fileDescriptor_f2751be16bbd500c, []int{0}
}
func (m *Permission) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Permission) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Permission.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Permission) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Permission.Merge(m, src)
}
func (m *Permission) XXX_Size() int {
	return m.Size()
}
func (m *Permission) XXX_DiscardUnknown() {
	xxx_messageInfo_Permission.DiscardUnknown(m)
}

var xxx_messageInfo_Permission proto.InternalMessageInfo

func (m *Permission) GetResource() string {
	if m != nil {
		return m.Resource
	}
	return ""
}

func (m *Permission) GetAccess() storage.Access {
	if m != nil {
		return m.Access
	}
	return storage.Access_NO_ACCESS
}

func (m *Permission) MessageClone() proto.Message {
	return m.Clone()
}
func (m *Permission) Clone() *Permission {
	if m == nil {
		return nil
	}
	cloned := new(Permission)
	*cloned = *m

	return cloned
}

type GetRolesResponse struct {
	Roles                []*storage.Role `protobuf:"bytes,1,rep,name=roles,proto3" json:"roles,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *GetRolesResponse) Reset()         { *m = GetRolesResponse{} }
func (m *GetRolesResponse) String() string { return proto.CompactTextString(m) }
func (*GetRolesResponse) ProtoMessage()    {}
func (*GetRolesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f2751be16bbd500c, []int{1}
}
func (m *GetRolesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetRolesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetRolesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetRolesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetRolesResponse.Merge(m, src)
}
func (m *GetRolesResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetRolesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetRolesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetRolesResponse proto.InternalMessageInfo

func (m *GetRolesResponse) GetRoles() []*storage.Role {
	if m != nil {
		return m.Roles
	}
	return nil
}

func (m *GetRolesResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetRolesResponse) Clone() *GetRolesResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetRolesResponse)
	*cloned = *m

	if m.Roles != nil {
		cloned.Roles = make([]*storage.Role, len(m.Roles))
		for idx, v := range m.Roles {
			cloned.Roles[idx] = v.Clone()
		}
	}
	return cloned
}

// GetPermissionsResponse is wire-compatible with the old format of the Role
// message and represents a collection of aggregated permissions.
type GetPermissionsResponse struct {
	ResourceToAccess     map[string]storage.Access `protobuf:"bytes,3,rep,name=resource_to_access,json=resourceToAccess,proto3" json:"resource_to_access,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3,enum=storage.Access"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *GetPermissionsResponse) Reset()         { *m = GetPermissionsResponse{} }
func (m *GetPermissionsResponse) String() string { return proto.CompactTextString(m) }
func (*GetPermissionsResponse) ProtoMessage()    {}
func (*GetPermissionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f2751be16bbd500c, []int{2}
}
func (m *GetPermissionsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetPermissionsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetPermissionsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetPermissionsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetPermissionsResponse.Merge(m, src)
}
func (m *GetPermissionsResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetPermissionsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetPermissionsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetPermissionsResponse proto.InternalMessageInfo

func (m *GetPermissionsResponse) GetResourceToAccess() map[string]storage.Access {
	if m != nil {
		return m.ResourceToAccess
	}
	return nil
}

func (m *GetPermissionsResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetPermissionsResponse) Clone() *GetPermissionsResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetPermissionsResponse)
	*cloned = *m

	if m.ResourceToAccess != nil {
		cloned.ResourceToAccess = make(map[string]storage.Access, len(m.ResourceToAccess))
		for k, v := range m.ResourceToAccess {
			cloned.ResourceToAccess[k] = v
		}
	}
	return cloned
}

type GetResourcesResponse struct {
	Resources            []string `protobuf:"bytes,1,rep,name=resources,proto3" json:"resources,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetResourcesResponse) Reset()         { *m = GetResourcesResponse{} }
func (m *GetResourcesResponse) String() string { return proto.CompactTextString(m) }
func (*GetResourcesResponse) ProtoMessage()    {}
func (*GetResourcesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f2751be16bbd500c, []int{3}
}
func (m *GetResourcesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetResourcesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetResourcesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetResourcesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetResourcesResponse.Merge(m, src)
}
func (m *GetResourcesResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetResourcesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetResourcesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetResourcesResponse proto.InternalMessageInfo

func (m *GetResourcesResponse) GetResources() []string {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *GetResourcesResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetResourcesResponse) Clone() *GetResourcesResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetResourcesResponse)
	*cloned = *m

	if m.Resources != nil {
		cloned.Resources = make([]string, len(m.Resources))
		copy(cloned.Resources, m.Resources)
	}
	return cloned
}

type ListPermissionSetsResponse struct {
	PermissionSets       []*storage.PermissionSet `protobuf:"bytes,1,rep,name=permission_sets,json=permissionSets,proto3" json:"permission_sets,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *ListPermissionSetsResponse) Reset()         { *m = ListPermissionSetsResponse{} }
func (m *ListPermissionSetsResponse) String() string { return proto.CompactTextString(m) }
func (*ListPermissionSetsResponse) ProtoMessage()    {}
func (*ListPermissionSetsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f2751be16bbd500c, []int{4}
}
func (m *ListPermissionSetsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListPermissionSetsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListPermissionSetsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListPermissionSetsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListPermissionSetsResponse.Merge(m, src)
}
func (m *ListPermissionSetsResponse) XXX_Size() int {
	return m.Size()
}
func (m *ListPermissionSetsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListPermissionSetsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListPermissionSetsResponse proto.InternalMessageInfo

func (m *ListPermissionSetsResponse) GetPermissionSets() []*storage.PermissionSet {
	if m != nil {
		return m.PermissionSets
	}
	return nil
}

func (m *ListPermissionSetsResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ListPermissionSetsResponse) Clone() *ListPermissionSetsResponse {
	if m == nil {
		return nil
	}
	cloned := new(ListPermissionSetsResponse)
	*cloned = *m

	if m.PermissionSets != nil {
		cloned.PermissionSets = make([]*storage.PermissionSet, len(m.PermissionSets))
		for idx, v := range m.PermissionSets {
			cloned.PermissionSets[idx] = v.Clone()
		}
	}
	return cloned
}

type ListSimpleAccessScopesResponse struct {
	AccessScopes         []*storage.SimpleAccessScope `protobuf:"bytes,1,rep,name=access_scopes,json=accessScopes,proto3" json:"access_scopes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *ListSimpleAccessScopesResponse) Reset()         { *m = ListSimpleAccessScopesResponse{} }
func (m *ListSimpleAccessScopesResponse) String() string { return proto.CompactTextString(m) }
func (*ListSimpleAccessScopesResponse) ProtoMessage()    {}
func (*ListSimpleAccessScopesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f2751be16bbd500c, []int{5}
}
func (m *ListSimpleAccessScopesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListSimpleAccessScopesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListSimpleAccessScopesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListSimpleAccessScopesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSimpleAccessScopesResponse.Merge(m, src)
}
func (m *ListSimpleAccessScopesResponse) XXX_Size() int {
	return m.Size()
}
func (m *ListSimpleAccessScopesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSimpleAccessScopesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListSimpleAccessScopesResponse proto.InternalMessageInfo

func (m *ListSimpleAccessScopesResponse) GetAccessScopes() []*storage.SimpleAccessScope {
	if m != nil {
		return m.AccessScopes
	}
	return nil
}

func (m *ListSimpleAccessScopesResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ListSimpleAccessScopesResponse) Clone() *ListSimpleAccessScopesResponse {
	if m == nil {
		return nil
	}
	cloned := new(ListSimpleAccessScopesResponse)
	*cloned = *m

	if m.AccessScopes != nil {
		cloned.AccessScopes = make([]*storage.SimpleAccessScope, len(m.AccessScopes))
		for idx, v := range m.AccessScopes {
			cloned.AccessScopes[idx] = v.Clone()
		}
	}
	return cloned
}

type ComputeEffectiveAccessScopeRequest struct {
	Detail               ComputeEffectiveAccessScopeRequest_Detail   `protobuf:"varint,1,opt,name=detail,proto3,enum=v1.ComputeEffectiveAccessScopeRequest_Detail" json:"detail,omitempty"`
	AccessScope          *ComputeEffectiveAccessScopeRequest_Payload `protobuf:"bytes,2,opt,name=access_scope,json=accessScope,proto3" json:"access_scope,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                    `json:"-"`
	XXX_unrecognized     []byte                                      `json:"-"`
	XXX_sizecache        int32                                       `json:"-"`
}

func (m *ComputeEffectiveAccessScopeRequest) Reset()         { *m = ComputeEffectiveAccessScopeRequest{} }
func (m *ComputeEffectiveAccessScopeRequest) String() string { return proto.CompactTextString(m) }
func (*ComputeEffectiveAccessScopeRequest) ProtoMessage()    {}
func (*ComputeEffectiveAccessScopeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f2751be16bbd500c, []int{6}
}
func (m *ComputeEffectiveAccessScopeRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ComputeEffectiveAccessScopeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ComputeEffectiveAccessScopeRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ComputeEffectiveAccessScopeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ComputeEffectiveAccessScopeRequest.Merge(m, src)
}
func (m *ComputeEffectiveAccessScopeRequest) XXX_Size() int {
	return m.Size()
}
func (m *ComputeEffectiveAccessScopeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ComputeEffectiveAccessScopeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ComputeEffectiveAccessScopeRequest proto.InternalMessageInfo

func (m *ComputeEffectiveAccessScopeRequest) GetDetail() ComputeEffectiveAccessScopeRequest_Detail {
	if m != nil {
		return m.Detail
	}
	return ComputeEffectiveAccessScopeRequest_STANDARD
}

func (m *ComputeEffectiveAccessScopeRequest) GetAccessScope() *ComputeEffectiveAccessScopeRequest_Payload {
	if m != nil {
		return m.AccessScope
	}
	return nil
}

func (m *ComputeEffectiveAccessScopeRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ComputeEffectiveAccessScopeRequest) Clone() *ComputeEffectiveAccessScopeRequest {
	if m == nil {
		return nil
	}
	cloned := new(ComputeEffectiveAccessScopeRequest)
	*cloned = *m

	cloned.AccessScope = m.AccessScope.Clone()
	return cloned
}

type ComputeEffectiveAccessScopeRequest_Payload struct {
	// Other definitions of access scope rules is science fiction for now;
	// however, prepare for that possible future.
	//
	// Types that are valid to be assigned to RulesOpt:
	//	*ComputeEffectiveAccessScopeRequest_Payload_SimpleRules
	RulesOpt             isComputeEffectiveAccessScopeRequest_Payload_RulesOpt `protobuf_oneof:"rules_opt"`
	XXX_NoUnkeyedLiteral struct{}                                              `json:"-"`
	XXX_unrecognized     []byte                                                `json:"-"`
	XXX_sizecache        int32                                                 `json:"-"`
}

func (m *ComputeEffectiveAccessScopeRequest_Payload) Reset() {
	*m = ComputeEffectiveAccessScopeRequest_Payload{}
}
func (m *ComputeEffectiveAccessScopeRequest_Payload) String() string {
	return proto.CompactTextString(m)
}
func (*ComputeEffectiveAccessScopeRequest_Payload) ProtoMessage() {}
func (*ComputeEffectiveAccessScopeRequest_Payload) Descriptor() ([]byte, []int) {
	return fileDescriptor_f2751be16bbd500c, []int{6, 0}
}
func (m *ComputeEffectiveAccessScopeRequest_Payload) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ComputeEffectiveAccessScopeRequest_Payload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ComputeEffectiveAccessScopeRequest_Payload.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ComputeEffectiveAccessScopeRequest_Payload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ComputeEffectiveAccessScopeRequest_Payload.Merge(m, src)
}
func (m *ComputeEffectiveAccessScopeRequest_Payload) XXX_Size() int {
	return m.Size()
}
func (m *ComputeEffectiveAccessScopeRequest_Payload) XXX_DiscardUnknown() {
	xxx_messageInfo_ComputeEffectiveAccessScopeRequest_Payload.DiscardUnknown(m)
}

var xxx_messageInfo_ComputeEffectiveAccessScopeRequest_Payload proto.InternalMessageInfo

type isComputeEffectiveAccessScopeRequest_Payload_RulesOpt interface {
	isComputeEffectiveAccessScopeRequest_Payload_RulesOpt()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isComputeEffectiveAccessScopeRequest_Payload_RulesOpt
}

type ComputeEffectiveAccessScopeRequest_Payload_SimpleRules struct {
	SimpleRules *storage.SimpleAccessScope_Rules `protobuf:"bytes,1,opt,name=simple_rules,json=simpleRules,proto3,oneof" json:"simple_rules,omitempty"`
}

func (*ComputeEffectiveAccessScopeRequest_Payload_SimpleRules) isComputeEffectiveAccessScopeRequest_Payload_RulesOpt() {
}
func (m *ComputeEffectiveAccessScopeRequest_Payload_SimpleRules) Clone() isComputeEffectiveAccessScopeRequest_Payload_RulesOpt {
	if m == nil {
		return nil
	}
	cloned := new(ComputeEffectiveAccessScopeRequest_Payload_SimpleRules)
	*cloned = *m

	cloned.SimpleRules = m.SimpleRules.Clone()
	return cloned
}

func (m *ComputeEffectiveAccessScopeRequest_Payload) GetRulesOpt() isComputeEffectiveAccessScopeRequest_Payload_RulesOpt {
	if m != nil {
		return m.RulesOpt
	}
	return nil
}

func (m *ComputeEffectiveAccessScopeRequest_Payload) GetSimpleRules() *storage.SimpleAccessScope_Rules {
	if x, ok := m.GetRulesOpt().(*ComputeEffectiveAccessScopeRequest_Payload_SimpleRules); ok {
		return x.SimpleRules
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ComputeEffectiveAccessScopeRequest_Payload) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ComputeEffectiveAccessScopeRequest_Payload_SimpleRules)(nil),
	}
}

func (m *ComputeEffectiveAccessScopeRequest_Payload) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ComputeEffectiveAccessScopeRequest_Payload) Clone() *ComputeEffectiveAccessScopeRequest_Payload {
	if m == nil {
		return nil
	}
	cloned := new(ComputeEffectiveAccessScopeRequest_Payload)
	*cloned = *m

	if m.RulesOpt != nil {
		cloned.RulesOpt = m.RulesOpt.Clone()
	}
	return cloned
}

// CreateRoleRequest unites name we take from the URL path and role body in the same structure.
// This way we can verify that name in the path and name in the body are identical.
type CreateRoleRequest struct {
	Name                 string        `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Role                 *storage.Role `protobuf:"bytes,2,opt,name=role,proto3" json:"role,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *CreateRoleRequest) Reset()         { *m = CreateRoleRequest{} }
func (m *CreateRoleRequest) String() string { return proto.CompactTextString(m) }
func (*CreateRoleRequest) ProtoMessage()    {}
func (*CreateRoleRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f2751be16bbd500c, []int{7}
}
func (m *CreateRoleRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CreateRoleRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CreateRoleRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CreateRoleRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateRoleRequest.Merge(m, src)
}
func (m *CreateRoleRequest) XXX_Size() int {
	return m.Size()
}
func (m *CreateRoleRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateRoleRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateRoleRequest proto.InternalMessageInfo

func (m *CreateRoleRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateRoleRequest) GetRole() *storage.Role {
	if m != nil {
		return m.Role
	}
	return nil
}

func (m *CreateRoleRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *CreateRoleRequest) Clone() *CreateRoleRequest {
	if m == nil {
		return nil
	}
	cloned := new(CreateRoleRequest)
	*cloned = *m

	cloned.Role = m.Role.Clone()
	return cloned
}

func init() {
	proto.RegisterEnum("v1.ComputeEffectiveAccessScopeRequest_Detail", ComputeEffectiveAccessScopeRequest_Detail_name, ComputeEffectiveAccessScopeRequest_Detail_value)
	proto.RegisterType((*Permission)(nil), "v1.Permission")
	proto.RegisterType((*GetRolesResponse)(nil), "v1.GetRolesResponse")
	proto.RegisterType((*GetPermissionsResponse)(nil), "v1.GetPermissionsResponse")
	proto.RegisterMapType((map[string]storage.Access)(nil), "v1.GetPermissionsResponse.ResourceToAccessEntry")
	proto.RegisterType((*GetResourcesResponse)(nil), "v1.GetResourcesResponse")
	proto.RegisterType((*ListPermissionSetsResponse)(nil), "v1.ListPermissionSetsResponse")
	proto.RegisterType((*ListSimpleAccessScopesResponse)(nil), "v1.ListSimpleAccessScopesResponse")
	proto.RegisterType((*ComputeEffectiveAccessScopeRequest)(nil), "v1.ComputeEffectiveAccessScopeRequest")
	proto.RegisterType((*ComputeEffectiveAccessScopeRequest_Payload)(nil), "v1.ComputeEffectiveAccessScopeRequest.Payload")
	proto.RegisterType((*CreateRoleRequest)(nil), "v1.CreateRoleRequest")
}

func init() { proto.RegisterFile("api/v1/role_service.proto", fileDescriptor_f2751be16bbd500c) }

var fileDescriptor_f2751be16bbd500c = []byte{
	// 1058 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x56, 0x5d, 0x6f, 0x1a, 0x47,
	0x14, 0xf5, 0x62, 0x62, 0xc3, 0x05, 0xdb, 0xeb, 0xb1, 0xc1, 0x78, 0x6d, 0x13, 0x32, 0x51, 0x53,
	0xcb, 0x52, 0x96, 0x42, 0x5b, 0xb5, 0xf2, 0x43, 0x2b, 0x6c, 0x90, 0x3f, 0x14, 0x5b, 0x64, 0x71,
	0xa5, 0xb6, 0x91, 0x8b, 0x36, 0x78, 0x62, 0xad, 0x02, 0xcc, 0x76, 0x77, 0x41, 0x45, 0x55, 0x5e,
	0x2a, 0xf5, 0x17, 0xf4, 0xa5, 0x52, 0xff, 0x50, 0x1f, 0xfa, 0x50, 0xa9, 0x6f, 0x7d, 0xaa, 0xdc,
	0xfe, 0x90, 0x6a, 0x3e, 0x16, 0x86, 0x8f, 0xc5, 0xce, 0x1b, 0x3b, 0x33, 0xe7, 0x9c, 0x7b, 0xcf,
	0x9d, 0x7b, 0x07, 0xd8, 0xb6, 0x5d, 0xa7, 0xd8, 0x2f, 0x15, 0x3d, 0xda, 0x26, 0x4d, 0x9f, 0x78,
	0x7d, 0xa7, 0x45, 0x4c, 0xd7, 0xa3, 0x01, 0x45, 0xb1, 0x7e, 0xc9, 0xd8, 0xbd, 0xa5, 0xf4, 0xb6,
	0x4d, 0x8a, 0xec, 0x94, 0xdd, 0xed, 0xd2, 0xc0, 0x0e, 0x1c, 0xda, 0xf5, 0xc5, 0x09, 0x63, 0x43,
	0x82, 0x5b, 0xb4, 0xd3, 0xa1, 0x5d, 0xb9, 0x88, 0xe4, 0x22, 0xe9, 0xb8, 0xc1, 0x20, 0x5c, 0xf3,
	0x03, 0xea, 0xd9, 0xb7, 0x84, 0xcb, 0x88, 0x35, 0xfc, 0x12, 0xa0, 0x4e, 0xbc, 0x8e, 0xe3, 0xfb,
	0x0e, 0xed, 0x22, 0x03, 0x12, 0x1e, 0xf1, 0x69, 0xcf, 0x6b, 0x91, 0x9c, 0x56, 0xd0, 0xf6, 0x93,
	0xd6, 0xf0, 0x1b, 0x7d, 0x08, 0x4b, 0x76, 0xab, 0x45, 0x7c, 0x3f, 0x17, 0x2b, 0x68, 0xfb, 0xab,
	0xe5, 0x35, 0x53, 0xd2, 0x99, 0x15, 0xbe, 0x6c, 0xc9, 0x6d, 0xfc, 0x19, 0xe8, 0x27, 0x24, 0xb0,
	0x68, 0x9b, 0xf8, 0x16, 0xf1, 0x5d, 0xda, 0xf5, 0x09, 0x7a, 0x0a, 0x8f, 0x98, 0xa8, 0x9f, 0xd3,
	0x0a, 0x8b, 0xfb, 0xa9, 0xf2, 0xca, 0x10, 0xcb, 0x8e, 0x59, 0x62, 0x0f, 0xff, 0xad, 0x41, 0xf6,
	0x84, 0x04, 0xa3, 0x78, 0x46, 0xf8, 0xef, 0x00, 0x85, 0x81, 0x34, 0x03, 0xda, 0x94, 0x81, 0x2c,
	0x72, 0xb2, 0x8f, 0xcc, 0x7e, 0xc9, 0x9c, 0x8d, 0x33, 0x2d, 0x09, 0xba, 0xa2, 0x22, 0xc8, 0x5a,
	0x37, 0xf0, 0x06, 0x96, 0xee, 0x4d, 0x2c, 0x1b, 0x57, 0x90, 0x99, 0x79, 0x14, 0xe9, 0xb0, 0xf8,
	0x96, 0x0c, 0xa4, 0x19, 0xec, 0x27, 0xfa, 0x00, 0x1e, 0xf5, 0xed, 0x76, 0x8f, 0x44, 0xd9, 0x20,
	0x76, 0x0f, 0x63, 0x9f, 0x6b, 0xe7, 0xf1, 0x84, 0xa6, 0xc7, 0xce, 0xe3, 0x89, 0x98, 0xbe, 0x88,
	0x3f, 0x81, 0x4d, 0xe6, 0x8a, 0x14, 0x19, 0x65, 0xb6, 0x0b, 0xc9, 0x30, 0x1a, 0xe1, 0x4e, 0xd2,
	0x1a, 0x2d, 0xe0, 0x6b, 0x30, 0x5e, 0x38, 0xbe, 0x92, 0x5a, 0x83, 0x04, 0x23, 0xec, 0x97, 0xb0,
	0xe6, 0x0e, 0x77, 0x9a, 0x3e, 0x09, 0x42, 0x7f, 0xb3, 0xc3, 0xa0, 0xc6, 0x90, 0xd6, 0xaa, 0x3b,
	0x46, 0x84, 0x6d, 0xc8, 0x33, 0xfa, 0x86, 0xd3, 0x71, 0xdb, 0x44, 0xc4, 0xdf, 0x68, 0x51, 0x97,
	0xa8, 0x12, 0x2b, 0xc2, 0xec, 0xa6, 0xcf, 0x37, 0xa4, 0x80, 0x31, 0x14, 0x98, 0xc2, 0x5a, 0x69,
	0x5b, 0x21, 0xc2, 0x7f, 0xc4, 0x00, 0x1f, 0xd3, 0x8e, 0xdb, 0x0b, 0x48, 0xed, 0xcd, 0x1b, 0xd2,
	0x0a, 0x9c, 0xfe, 0xd8, 0x69, 0xf2, 0x7d, 0x8f, 0xf8, 0x01, 0xaa, 0xc1, 0xd2, 0x0d, 0x09, 0x6c,
	0xa7, 0xcd, 0xad, 0x5e, 0x2d, 0x3f, 0x67, 0x45, 0xbd, 0x1f, 0x67, 0x56, 0x39, 0xc8, 0x92, 0x60,
	0xf4, 0x12, 0xd2, 0x6a, 0xb8, 0xbc, 0x46, 0xa9, 0xb2, 0xf9, 0x40, 0xb2, 0xba, 0x3d, 0x68, 0x53,
	0xfb, 0xc6, 0x4a, 0x29, 0x19, 0x18, 0xd7, 0xb0, 0x2c, 0xd7, 0x51, 0x0d, 0xd2, 0x3e, 0x4f, 0xb7,
	0xe9, 0xf5, 0xc4, 0x65, 0x66, 0xec, 0x85, 0x68, 0x2f, 0x4c, 0x8b, 0x9d, 0x3b, 0x5d, 0xb0, 0x52,
	0x02, 0xc7, 0x3f, 0x8f, 0x52, 0x90, 0xe4, 0xf8, 0x26, 0x75, 0x03, 0xfc, 0x1c, 0x96, 0x44, 0x0e,
	0x28, 0x0d, 0x89, 0xc6, 0x55, 0xe5, 0xb2, 0x5a, 0xb1, 0xaa, 0xfa, 0x02, 0x4a, 0xc1, 0xf2, 0xc5,
	0xd9, 0xe5, 0xd9, 0x45, 0xe5, 0x85, 0xae, 0xa1, 0x04, 0xc4, 0x4f, 0xcf, 0x4e, 0x4e, 0xf5, 0x18,
	0x3e, 0x87, 0xf5, 0x63, 0x8f, 0xd8, 0x01, 0xe1, 0x8d, 0x23, 0xcd, 0x43, 0x10, 0xef, 0xda, 0x9d,
	0xb0, 0x65, 0xf9, 0x6f, 0xf4, 0x04, 0xe2, 0xac, 0xab, 0xa4, 0x03, 0x13, 0x0d, 0xc7, 0xb7, 0xca,
	0x3f, 0xaf, 0x40, 0x8a, 0x7d, 0x36, 0xc4, 0xc0, 0x41, 0x5f, 0x40, 0x22, 0x6c, 0x5c, 0x94, 0x64,
	0x96, 0xd5, 0xd8, 0xf0, 0x30, 0x36, 0x65, 0x7f, 0x8d, 0x75, 0x34, 0x5e, 0xff, 0xe9, 0xaf, 0xff,
	0x7e, 0x89, 0xa5, 0x50, 0x32, 0x9c, 0x5b, 0x3e, 0x3a, 0x82, 0x65, 0x79, 0x0c, 0xe9, 0x0c, 0x13,
	0x5e, 0xf6, 0xa3, 0xc1, 0x59, 0xd5, 0x18, 0x8f, 0x00, 0x67, 0x39, 0x5c, 0x47, 0xab, 0x43, 0x78,
	0xf1, 0x47, 0xe7, 0xe6, 0x1d, 0xba, 0xe2, 0xc3, 0xe3, 0x62, 0xa0, 0x34, 0xb3, 0x1a, 0x8b, 0x11,
	0xdd, 0xeb, 0x78, 0x9b, 0x53, 0x6e, 0xa0, 0x75, 0x46, 0xd9, 0x19, 0xb8, 0x0a, 0xc3, 0x25, 0xc0,
	0xc8, 0x35, 0x94, 0xe1, 0xd7, 0x61, 0xd2, 0x45, 0x63, 0x24, 0x83, 0xf3, 0x9c, 0x2a, 0x87, 0x75,
	0x25, 0x3a, 0xe6, 0xea, 0xbb, 0x43, 0xee, 0x1c, 0x3a, 0x06, 0xf8, 0xca, 0xbd, 0x09, 0xf9, 0xc6,
	0x53, 0x53, 0x79, 0x76, 0x38, 0x4f, 0xc6, 0x98, 0xe6, 0xd1, 0x0e, 0x50, 0x05, 0xa0, 0x4a, 0xda,
	0x44, 0x92, 0x4c, 0x3b, 0xa6, 0xf0, 0x48, 0xb7, 0x0e, 0x26, 0xdd, 0x3a, 0x87, 0xb4, 0x3a, 0x54,
	0x54, 0xa7, 0x72, 0x61, 0xd5, 0x26, 0x27, 0x0e, 0xce, 0x70, 0xb2, 0x35, 0xb4, 0xc2, 0xc9, 0x86,
	0xd8, 0x6b, 0xee, 0xfc, 0xd8, 0xbc, 0x98, 0x11, 0x54, 0xc4, 0x64, 0xc1, 0x8f, 0x39, 0xe9, 0x36,
	0xda, 0x62, 0xa4, 0x8a, 0xf5, 0x24, 0x90, 0xa1, 0xbe, 0x02, 0x34, 0x3d, 0xc9, 0xd4, 0x80, 0xf3,
	0xec, 0x67, 0xf4, 0xb0, 0xc3, 0x06, 0x57, 0xd8, 0x44, 0x68, 0x5a, 0x01, 0xbd, 0x86, 0xf5, 0x3a,
	0x9d, 0x40, 0xa2, 0x88, 0x50, 0x23, 0x53, 0xd8, 0xe3, 0x02, 0x5b, 0x78, 0x86, 0x00, 0x2b, 0xd7,
	0x37, 0xa0, 0xd7, 0x7b, 0x0f, 0x94, 0x50, 0x4a, 0x87, 0x39, 0xeb, 0xae, 0x11, 0x65, 0x0c, 0xa3,
	0x6e, 0xc0, 0x86, 0xb8, 0x09, 0xf7, 0xb9, 0xaf, 0xf0, 0x4a, 0xc3, 0x0f, 0x22, 0x0d, 0x77, 0xf8,
	0x83, 0x33, 0x35, 0x92, 0x66, 0xb0, 0xce, 0x19, 0xe6, 0xf8, 0x29, 0x97, 0xd9, 0x43, 0x3b, 0x4c,
	0x46, 0x0c, 0x31, 0x31, 0x1c, 0xc5, 0x73, 0x20, 0xa4, 0x6e, 0x21, 0x3b, 0xfb, 0x19, 0x51, 0xeb,
	0x8b, 0xc3, 0xfa, 0x46, 0xbf, 0x36, 0x61, 0xdf, 0xa1, 0xec, 0x6c, 0x35, 0xe4, 0x41, 0x86, 0xd5,
	0x79, 0x3a, 0xa9, 0x39, 0x29, 0xcc, 0x4d, 0xef, 0x09, 0x17, 0xdc, 0xc1, 0x11, 0x82, 0xac, 0x38,
	0x04, 0x36, 0xeb, 0xbd, 0xf7, 0x94, 0x54, 0xea, 0xf4, 0x8c, 0x2b, 0x14, 0x8c, 0x79, 0x06, 0x32,
	0x99, 0x57, 0xb0, 0x25, 0xee, 0xc0, 0x43, 0x2a, 0xa6, 0xf0, 0xcb, 0x02, 0x1d, 0xcc, 0x2d, 0xd0,
	0x6f, 0x1a, 0xec, 0xcc, 0x79, 0xff, 0xd0, 0xb3, 0x87, 0x3d, 0x90, 0xc6, 0xde, 0x30, 0xe7, 0x59,
	0xa7, 0xf0, 0xa7, 0x3c, 0x96, 0x22, 0x7e, 0x2c, 0xff, 0x8e, 0x32, 0x3a, 0x12, 0x1e, 0x54, 0xa2,
	0x3a, 0x1c, 0x7b, 0xa4, 0x8f, 0xcc, 0xdf, 0xef, 0xf2, 0xda, 0x9f, 0x77, 0x79, 0xed, 0x9f, 0xbb,
	0xbc, 0xf6, 0xeb, 0xbf, 0xf9, 0x05, 0xc8, 0x39, 0xd4, 0xf4, 0x03, 0xbb, 0xf5, 0xd6, 0xa3, 0x3f,
	0x88, 0x3f, 0xaa, 0xa6, 0xed, 0x3a, 0x66, 0xbf, 0xf4, 0x6d, 0xac, 0x5f, 0xfa, 0x7a, 0xe1, 0xf5,
	0x12, 0x5f, 0xfb, 0xf8, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x22, 0x86, 0x4e, 0xec, 0x38, 0x0b,
	0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// RoleServiceClient is the client API for RoleService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConnInterface.NewStream.
type RoleServiceClient interface {
	GetRoles(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*GetRolesResponse, error)
	GetRole(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*storage.Role, error)
	GetMyPermissions(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*GetPermissionsResponse, error)
	CreateRole(ctx context.Context, in *CreateRoleRequest, opts ...grpc.CallOption) (*Empty, error)
	UpdateRole(ctx context.Context, in *storage.Role, opts ...grpc.CallOption) (*Empty, error)
	DeleteRole(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*Empty, error)
	GetResources(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*GetResourcesResponse, error)
	GetPermissionSet(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*storage.PermissionSet, error)
	ListPermissionSets(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*ListPermissionSetsResponse, error)
	// PostPermissionSet
	//
	// PermissionSet.id is disallowed in request and set in response.
	PostPermissionSet(ctx context.Context, in *storage.PermissionSet, opts ...grpc.CallOption) (*storage.PermissionSet, error)
	PutPermissionSet(ctx context.Context, in *storage.PermissionSet, opts ...grpc.CallOption) (*Empty, error)
	DeletePermissionSet(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*Empty, error)
	GetSimpleAccessScope(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*storage.SimpleAccessScope, error)
	ListSimpleAccessScopes(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*ListSimpleAccessScopesResponse, error)
	// PostSimpleAccessScope
	//
	// SimpleAccessScope.id is disallowed in request and set in response.
	PostSimpleAccessScope(ctx context.Context, in *storage.SimpleAccessScope, opts ...grpc.CallOption) (*storage.SimpleAccessScope, error)
	PutSimpleAccessScope(ctx context.Context, in *storage.SimpleAccessScope, opts ...grpc.CallOption) (*Empty, error)
	DeleteSimpleAccessScope(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*Empty, error)
	// ComputeEffectiveAccessScope
	//
	// Returns effective access scope based on the rules in the request. Does
	// not persist anything; not idempotent due to possible changes to clusters
	// and namespaces. POST is chosen due to potentially large payload.
	//
	// There are advantages in both keeping the response slim and detailed. If
	// only IDs of selected clusters and namespaces are included, response
	// latency and processing time are lower but the caller shall overlay the
	// response with its view of the world which is susceptible to consistency
	// issues. Listing all clusters and namespaces with related metadata is
	// convenient for the caller but bloat the message with secondary data.
	//
	// We let the caller decide what level of detail they would like to have:
	//
	//   * Minimal, when only roots of included subtrees are listed by their
	//     IDs. Clusters can be either INCLUDED (its namespaces are included but
	//     are not listed) or PARTIAL (at least one namespace is explicitly
	//     included). Namespaces can only be INCLUDED.
	//
	//   * Standard [default], when all known clusters and namespaces are listed
	//     with their IDs and names. Clusters can be INCLUDED (all its
	//     namespaces are explicitly listed as INCLUDED), PARTIAL (all its
	//     namespaces are explicitly listed, some as INCLUDED and some as
	//     EXCLUDED), and EXCLUDED (all its namespaces are explicitly listed as
	//     EXCLUDED). Namespaces can be either INCLUDED or EXCLUDED.
	//
	//   * High, when every cluster and namespace is augmented with metadata.
	ComputeEffectiveAccessScope(ctx context.Context, in *ComputeEffectiveAccessScopeRequest, opts ...grpc.CallOption) (*storage.EffectiveAccessScope, error)
}

type roleServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewRoleServiceClient(cc grpc.ClientConnInterface) RoleServiceClient {
	return &roleServiceClient{cc}
}

func (c *roleServiceClient) GetRoles(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*GetRolesResponse, error) {
	out := new(GetRolesResponse)
	err := c.cc.Invoke(ctx, "/v1.RoleService/GetRoles", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *roleServiceClient) GetRole(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*storage.Role, error) {
	out := new(storage.Role)
	err := c.cc.Invoke(ctx, "/v1.RoleService/GetRole", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *roleServiceClient) GetMyPermissions(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*GetPermissionsResponse, error) {
	out := new(GetPermissionsResponse)
	err := c.cc.Invoke(ctx, "/v1.RoleService/GetMyPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *roleServiceClient) CreateRole(ctx context.Context, in *CreateRoleRequest, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.RoleService/CreateRole", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *roleServiceClient) UpdateRole(ctx context.Context, in *storage.Role, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.RoleService/UpdateRole", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *roleServiceClient) DeleteRole(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.RoleService/DeleteRole", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *roleServiceClient) GetResources(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*GetResourcesResponse, error) {
	out := new(GetResourcesResponse)
	err := c.cc.Invoke(ctx, "/v1.RoleService/GetResources", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *roleServiceClient) GetPermissionSet(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*storage.PermissionSet, error) {
	out := new(storage.PermissionSet)
	err := c.cc.Invoke(ctx, "/v1.RoleService/GetPermissionSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *roleServiceClient) ListPermissionSets(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*ListPermissionSetsResponse, error) {
	out := new(ListPermissionSetsResponse)
	err := c.cc.Invoke(ctx, "/v1.RoleService/ListPermissionSets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *roleServiceClient) PostPermissionSet(ctx context.Context, in *storage.PermissionSet, opts ...grpc.CallOption) (*storage.PermissionSet, error) {
	out := new(storage.PermissionSet)
	err := c.cc.Invoke(ctx, "/v1.RoleService/PostPermissionSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *roleServiceClient) PutPermissionSet(ctx context.Context, in *storage.PermissionSet, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.RoleService/PutPermissionSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *roleServiceClient) DeletePermissionSet(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.RoleService/DeletePermissionSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *roleServiceClient) GetSimpleAccessScope(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*storage.SimpleAccessScope, error) {
	out := new(storage.SimpleAccessScope)
	err := c.cc.Invoke(ctx, "/v1.RoleService/GetSimpleAccessScope", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *roleServiceClient) ListSimpleAccessScopes(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*ListSimpleAccessScopesResponse, error) {
	out := new(ListSimpleAccessScopesResponse)
	err := c.cc.Invoke(ctx, "/v1.RoleService/ListSimpleAccessScopes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *roleServiceClient) PostSimpleAccessScope(ctx context.Context, in *storage.SimpleAccessScope, opts ...grpc.CallOption) (*storage.SimpleAccessScope, error) {
	out := new(storage.SimpleAccessScope)
	err := c.cc.Invoke(ctx, "/v1.RoleService/PostSimpleAccessScope", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *roleServiceClient) PutSimpleAccessScope(ctx context.Context, in *storage.SimpleAccessScope, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.RoleService/PutSimpleAccessScope", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *roleServiceClient) DeleteSimpleAccessScope(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/v1.RoleService/DeleteSimpleAccessScope", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *roleServiceClient) ComputeEffectiveAccessScope(ctx context.Context, in *ComputeEffectiveAccessScopeRequest, opts ...grpc.CallOption) (*storage.EffectiveAccessScope, error) {
	out := new(storage.EffectiveAccessScope)
	err := c.cc.Invoke(ctx, "/v1.RoleService/ComputeEffectiveAccessScope", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RoleServiceServer is the server API for RoleService service.
type RoleServiceServer interface {
	GetRoles(context.Context, *Empty) (*GetRolesResponse, error)
	GetRole(context.Context, *ResourceByID) (*storage.Role, error)
	GetMyPermissions(context.Context, *Empty) (*GetPermissionsResponse, error)
	CreateRole(context.Context, *CreateRoleRequest) (*Empty, error)
	UpdateRole(context.Context, *storage.Role) (*Empty, error)
	DeleteRole(context.Context, *ResourceByID) (*Empty, error)
	GetResources(context.Context, *Empty) (*GetResourcesResponse, error)
	GetPermissionSet(context.Context, *ResourceByID) (*storage.PermissionSet, error)
	ListPermissionSets(context.Context, *Empty) (*ListPermissionSetsResponse, error)
	// PostPermissionSet
	//
	// PermissionSet.id is disallowed in request and set in response.
	PostPermissionSet(context.Context, *storage.PermissionSet) (*storage.PermissionSet, error)
	PutPermissionSet(context.Context, *storage.PermissionSet) (*Empty, error)
	DeletePermissionSet(context.Context, *ResourceByID) (*Empty, error)
	GetSimpleAccessScope(context.Context, *ResourceByID) (*storage.SimpleAccessScope, error)
	ListSimpleAccessScopes(context.Context, *Empty) (*ListSimpleAccessScopesResponse, error)
	// PostSimpleAccessScope
	//
	// SimpleAccessScope.id is disallowed in request and set in response.
	PostSimpleAccessScope(context.Context, *storage.SimpleAccessScope) (*storage.SimpleAccessScope, error)
	PutSimpleAccessScope(context.Context, *storage.SimpleAccessScope) (*Empty, error)
	DeleteSimpleAccessScope(context.Context, *ResourceByID) (*Empty, error)
	// ComputeEffectiveAccessScope
	//
	// Returns effective access scope based on the rules in the request. Does
	// not persist anything; not idempotent due to possible changes to clusters
	// and namespaces. POST is chosen due to potentially large payload.
	//
	// There are advantages in both keeping the response slim and detailed. If
	// only IDs of selected clusters and namespaces are included, response
	// latency and processing time are lower but the caller shall overlay the
	// response with its view of the world which is susceptible to consistency
	// issues. Listing all clusters and namespaces with related metadata is
	// convenient for the caller but bloat the message with secondary data.
	//
	// We let the caller decide what level of detail they would like to have:
	//
	//   * Minimal, when only roots of included subtrees are listed by their
	//     IDs. Clusters can be either INCLUDED (its namespaces are included but
	//     are not listed) or PARTIAL (at least one namespace is explicitly
	//     included). Namespaces can only be INCLUDED.
	//
	//   * Standard [default], when all known clusters and namespaces are listed
	//     with their IDs and names. Clusters can be INCLUDED (all its
	//     namespaces are explicitly listed as INCLUDED), PARTIAL (all its
	//     namespaces are explicitly listed, some as INCLUDED and some as
	//     EXCLUDED), and EXCLUDED (all its namespaces are explicitly listed as
	//     EXCLUDED). Namespaces can be either INCLUDED or EXCLUDED.
	//
	//   * High, when every cluster and namespace is augmented with metadata.
	ComputeEffectiveAccessScope(context.Context, *ComputeEffectiveAccessScopeRequest) (*storage.EffectiveAccessScope, error)
}

// UnimplementedRoleServiceServer can be embedded to have forward compatible implementations.
type UnimplementedRoleServiceServer struct {
}

func (*UnimplementedRoleServiceServer) GetRoles(ctx context.Context, req *Empty) (*GetRolesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRoles not implemented")
}
func (*UnimplementedRoleServiceServer) GetRole(ctx context.Context, req *ResourceByID) (*storage.Role, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRole not implemented")
}
func (*UnimplementedRoleServiceServer) GetMyPermissions(ctx context.Context, req *Empty) (*GetPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMyPermissions not implemented")
}
func (*UnimplementedRoleServiceServer) CreateRole(ctx context.Context, req *CreateRoleRequest) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRole not implemented")
}
func (*UnimplementedRoleServiceServer) UpdateRole(ctx context.Context, req *storage.Role) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateRole not implemented")
}
func (*UnimplementedRoleServiceServer) DeleteRole(ctx context.Context, req *ResourceByID) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRole not implemented")
}
func (*UnimplementedRoleServiceServer) GetResources(ctx context.Context, req *Empty) (*GetResourcesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetResources not implemented")
}
func (*UnimplementedRoleServiceServer) GetPermissionSet(ctx context.Context, req *ResourceByID) (*storage.PermissionSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPermissionSet not implemented")
}
func (*UnimplementedRoleServiceServer) ListPermissionSets(ctx context.Context, req *Empty) (*ListPermissionSetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPermissionSets not implemented")
}
func (*UnimplementedRoleServiceServer) PostPermissionSet(ctx context.Context, req *storage.PermissionSet) (*storage.PermissionSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PostPermissionSet not implemented")
}
func (*UnimplementedRoleServiceServer) PutPermissionSet(ctx context.Context, req *storage.PermissionSet) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PutPermissionSet not implemented")
}
func (*UnimplementedRoleServiceServer) DeletePermissionSet(ctx context.Context, req *ResourceByID) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePermissionSet not implemented")
}
func (*UnimplementedRoleServiceServer) GetSimpleAccessScope(ctx context.Context, req *ResourceByID) (*storage.SimpleAccessScope, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSimpleAccessScope not implemented")
}
func (*UnimplementedRoleServiceServer) ListSimpleAccessScopes(ctx context.Context, req *Empty) (*ListSimpleAccessScopesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSimpleAccessScopes not implemented")
}
func (*UnimplementedRoleServiceServer) PostSimpleAccessScope(ctx context.Context, req *storage.SimpleAccessScope) (*storage.SimpleAccessScope, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PostSimpleAccessScope not implemented")
}
func (*UnimplementedRoleServiceServer) PutSimpleAccessScope(ctx context.Context, req *storage.SimpleAccessScope) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PutSimpleAccessScope not implemented")
}
func (*UnimplementedRoleServiceServer) DeleteSimpleAccessScope(ctx context.Context, req *ResourceByID) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSimpleAccessScope not implemented")
}
func (*UnimplementedRoleServiceServer) ComputeEffectiveAccessScope(ctx context.Context, req *ComputeEffectiveAccessScopeRequest) (*storage.EffectiveAccessScope, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ComputeEffectiveAccessScope not implemented")
}

func RegisterRoleServiceServer(s *grpc.Server, srv RoleServiceServer) {
	s.RegisterService(&_RoleService_serviceDesc, srv)
}

func _RoleService_GetRoles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RoleServiceServer).GetRoles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.RoleService/GetRoles",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RoleServiceServer).GetRoles(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _RoleService_GetRole_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RoleServiceServer).GetRole(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.RoleService/GetRole",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RoleServiceServer).GetRole(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

func _RoleService_GetMyPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RoleServiceServer).GetMyPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.RoleService/GetMyPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RoleServiceServer).GetMyPermissions(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _RoleService_CreateRole_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRoleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RoleServiceServer).CreateRole(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.RoleService/CreateRole",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RoleServiceServer).CreateRole(ctx, req.(*CreateRoleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RoleService_UpdateRole_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(storage.Role)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RoleServiceServer).UpdateRole(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.RoleService/UpdateRole",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RoleServiceServer).UpdateRole(ctx, req.(*storage.Role))
	}
	return interceptor(ctx, in, info, handler)
}

func _RoleService_DeleteRole_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RoleServiceServer).DeleteRole(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.RoleService/DeleteRole",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RoleServiceServer).DeleteRole(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

func _RoleService_GetResources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RoleServiceServer).GetResources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.RoleService/GetResources",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RoleServiceServer).GetResources(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _RoleService_GetPermissionSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RoleServiceServer).GetPermissionSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.RoleService/GetPermissionSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RoleServiceServer).GetPermissionSet(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

func _RoleService_ListPermissionSets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RoleServiceServer).ListPermissionSets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.RoleService/ListPermissionSets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RoleServiceServer).ListPermissionSets(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _RoleService_PostPermissionSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(storage.PermissionSet)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RoleServiceServer).PostPermissionSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.RoleService/PostPermissionSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RoleServiceServer).PostPermissionSet(ctx, req.(*storage.PermissionSet))
	}
	return interceptor(ctx, in, info, handler)
}

func _RoleService_PutPermissionSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(storage.PermissionSet)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RoleServiceServer).PutPermissionSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.RoleService/PutPermissionSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RoleServiceServer).PutPermissionSet(ctx, req.(*storage.PermissionSet))
	}
	return interceptor(ctx, in, info, handler)
}

func _RoleService_DeletePermissionSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RoleServiceServer).DeletePermissionSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.RoleService/DeletePermissionSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RoleServiceServer).DeletePermissionSet(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

func _RoleService_GetSimpleAccessScope_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RoleServiceServer).GetSimpleAccessScope(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.RoleService/GetSimpleAccessScope",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RoleServiceServer).GetSimpleAccessScope(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

func _RoleService_ListSimpleAccessScopes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RoleServiceServer).ListSimpleAccessScopes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.RoleService/ListSimpleAccessScopes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RoleServiceServer).ListSimpleAccessScopes(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _RoleService_PostSimpleAccessScope_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(storage.SimpleAccessScope)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RoleServiceServer).PostSimpleAccessScope(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.RoleService/PostSimpleAccessScope",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RoleServiceServer).PostSimpleAccessScope(ctx, req.(*storage.SimpleAccessScope))
	}
	return interceptor(ctx, in, info, handler)
}

func _RoleService_PutSimpleAccessScope_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(storage.SimpleAccessScope)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RoleServiceServer).PutSimpleAccessScope(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.RoleService/PutSimpleAccessScope",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RoleServiceServer).PutSimpleAccessScope(ctx, req.(*storage.SimpleAccessScope))
	}
	return interceptor(ctx, in, info, handler)
}

func _RoleService_DeleteSimpleAccessScope_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RoleServiceServer).DeleteSimpleAccessScope(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.RoleService/DeleteSimpleAccessScope",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RoleServiceServer).DeleteSimpleAccessScope(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

func _RoleService_ComputeEffectiveAccessScope_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ComputeEffectiveAccessScopeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RoleServiceServer).ComputeEffectiveAccessScope(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.RoleService/ComputeEffectiveAccessScope",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RoleServiceServer).ComputeEffectiveAccessScope(ctx, req.(*ComputeEffectiveAccessScopeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _RoleService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1.RoleService",
	HandlerType: (*RoleServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetRoles",
			Handler:    _RoleService_GetRoles_Handler,
		},
		{
			MethodName: "GetRole",
			Handler:    _RoleService_GetRole_Handler,
		},
		{
			MethodName: "GetMyPermissions",
			Handler:    _RoleService_GetMyPermissions_Handler,
		},
		{
			MethodName: "CreateRole",
			Handler:    _RoleService_CreateRole_Handler,
		},
		{
			MethodName: "UpdateRole",
			Handler:    _RoleService_UpdateRole_Handler,
		},
		{
			MethodName: "DeleteRole",
			Handler:    _RoleService_DeleteRole_Handler,
		},
		{
			MethodName: "GetResources",
			Handler:    _RoleService_GetResources_Handler,
		},
		{
			MethodName: "GetPermissionSet",
			Handler:    _RoleService_GetPermissionSet_Handler,
		},
		{
			MethodName: "ListPermissionSets",
			Handler:    _RoleService_ListPermissionSets_Handler,
		},
		{
			MethodName: "PostPermissionSet",
			Handler:    _RoleService_PostPermissionSet_Handler,
		},
		{
			MethodName: "PutPermissionSet",
			Handler:    _RoleService_PutPermissionSet_Handler,
		},
		{
			MethodName: "DeletePermissionSet",
			Handler:    _RoleService_DeletePermissionSet_Handler,
		},
		{
			MethodName: "GetSimpleAccessScope",
			Handler:    _RoleService_GetSimpleAccessScope_Handler,
		},
		{
			MethodName: "ListSimpleAccessScopes",
			Handler:    _RoleService_ListSimpleAccessScopes_Handler,
		},
		{
			MethodName: "PostSimpleAccessScope",
			Handler:    _RoleService_PostSimpleAccessScope_Handler,
		},
		{
			MethodName: "PutSimpleAccessScope",
			Handler:    _RoleService_PutSimpleAccessScope_Handler,
		},
		{
			MethodName: "DeleteSimpleAccessScope",
			Handler:    _RoleService_DeleteSimpleAccessScope_Handler,
		},
		{
			MethodName: "ComputeEffectiveAccessScope",
			Handler:    _RoleService_ComputeEffectiveAccessScope_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/v1/role_service.proto",
}

func (m *Permission) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Permission) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Permission) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Access != 0 {
		i = encodeVarintRoleService(dAtA, i, uint64(m.Access))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Resource) > 0 {
		i -= len(m.Resource)
		copy(dAtA[i:], m.Resource)
		i = encodeVarintRoleService(dAtA, i, uint64(len(m.Resource)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetRolesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetRolesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetRolesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Roles) > 0 {
		for iNdEx := len(m.Roles) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Roles[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRoleService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *GetPermissionsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetPermissionsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetPermissionsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ResourceToAccess) > 0 {
		for k := range m.ResourceToAccess {
			v := m.ResourceToAccess[k]
			baseI := i
			i = encodeVarintRoleService(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintRoleService(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintRoleService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x1a
		}
	}
	return len(dAtA) - i, nil
}

func (m *GetResourcesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetResourcesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetResourcesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Resources) > 0 {
		for iNdEx := len(m.Resources) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Resources[iNdEx])
			copy(dAtA[i:], m.Resources[iNdEx])
			i = encodeVarintRoleService(dAtA, i, uint64(len(m.Resources[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ListPermissionSetsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListPermissionSetsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListPermissionSetsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.PermissionSets) > 0 {
		for iNdEx := len(m.PermissionSets) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.PermissionSets[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRoleService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ListSimpleAccessScopesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListSimpleAccessScopesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListSimpleAccessScopesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.AccessScopes) > 0 {
		for iNdEx := len(m.AccessScopes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.AccessScopes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRoleService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ComputeEffectiveAccessScopeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ComputeEffectiveAccessScopeRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ComputeEffectiveAccessScopeRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.AccessScope != nil {
		{
			size, err := m.AccessScope.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRoleService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Detail != 0 {
		i = encodeVarintRoleService(dAtA, i, uint64(m.Detail))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ComputeEffectiveAccessScopeRequest_Payload) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ComputeEffectiveAccessScopeRequest_Payload) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ComputeEffectiveAccessScopeRequest_Payload) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.RulesOpt != nil {
		{
			size := m.RulesOpt.Size()
			i -= size
			if _, err := m.RulesOpt.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *ComputeEffectiveAccessScopeRequest_Payload_SimpleRules) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ComputeEffectiveAccessScopeRequest_Payload_SimpleRules) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.SimpleRules != nil {
		{
			size, err := m.SimpleRules.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRoleService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *CreateRoleRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CreateRoleRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CreateRoleRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Role != nil {
		{
			size, err := m.Role.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRoleService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintRoleService(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintRoleService(dAtA []byte, offset int, v uint64) int {
	offset -= sovRoleService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Permission) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Resource)
	if l > 0 {
		n += 1 + l + sovRoleService(uint64(l))
	}
	if m.Access != 0 {
		n += 1 + sovRoleService(uint64(m.Access))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetRolesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Roles) > 0 {
		for _, e := range m.Roles {
			l = e.Size()
			n += 1 + l + sovRoleService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetPermissionsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ResourceToAccess) > 0 {
		for k, v := range m.ResourceToAccess {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovRoleService(uint64(len(k))) + 1 + sovRoleService(uint64(v))
			n += mapEntrySize + 1 + sovRoleService(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetResourcesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Resources) > 0 {
		for _, s := range m.Resources {
			l = len(s)
			n += 1 + l + sovRoleService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListPermissionSetsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.PermissionSets) > 0 {
		for _, e := range m.PermissionSets {
			l = e.Size()
			n += 1 + l + sovRoleService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListSimpleAccessScopesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.AccessScopes) > 0 {
		for _, e := range m.AccessScopes {
			l = e.Size()
			n += 1 + l + sovRoleService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ComputeEffectiveAccessScopeRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Detail != 0 {
		n += 1 + sovRoleService(uint64(m.Detail))
	}
	if m.AccessScope != nil {
		l = m.AccessScope.Size()
		n += 1 + l + sovRoleService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ComputeEffectiveAccessScopeRequest_Payload) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RulesOpt != nil {
		n += m.RulesOpt.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ComputeEffectiveAccessScopeRequest_Payload_SimpleRules) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.SimpleRules != nil {
		l = m.SimpleRules.Size()
		n += 1 + l + sovRoleService(uint64(l))
	}
	return n
}
func (m *CreateRoleRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovRoleService(uint64(l))
	}
	if m.Role != nil {
		l = m.Role.Size()
		n += 1 + l + sovRoleService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovRoleService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozRoleService(x uint64) (n int) {
	return sovRoleService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Permission) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoleService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Permission: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Permission: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resource", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoleService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoleService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoleService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Resource = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Access", wireType)
			}
			m.Access = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoleService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Access |= storage.Access(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRoleService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRoleService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetRolesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoleService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetRolesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetRolesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Roles", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoleService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoleService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoleService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Roles = append(m.Roles, &storage.Role{})
			if err := m.Roles[len(m.Roles)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoleService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRoleService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetPermissionsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoleService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetPermissionsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetPermissionsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceToAccess", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoleService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoleService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoleService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResourceToAccess == nil {
				m.ResourceToAccess = make(map[string]storage.Access)
			}
			var mapkey string
			var mapvalue storage.Access
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRoleService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRoleService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthRoleService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthRoleService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRoleService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= storage.Access(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipRoleService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthRoleService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ResourceToAccess[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoleService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRoleService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetResourcesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoleService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetResourcesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetResourcesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoleService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoleService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoleService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Resources = append(m.Resources, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoleService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRoleService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListPermissionSetsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoleService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListPermissionSetsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListPermissionSetsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PermissionSets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoleService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoleService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoleService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PermissionSets = append(m.PermissionSets, &storage.PermissionSet{})
			if err := m.PermissionSets[len(m.PermissionSets)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoleService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRoleService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListSimpleAccessScopesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoleService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListSimpleAccessScopesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListSimpleAccessScopesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessScopes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoleService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoleService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoleService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccessScopes = append(m.AccessScopes, &storage.SimpleAccessScope{})
			if err := m.AccessScopes[len(m.AccessScopes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoleService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRoleService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ComputeEffectiveAccessScopeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoleService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ComputeEffectiveAccessScopeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ComputeEffectiveAccessScopeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Detail", wireType)
			}
			m.Detail = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoleService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Detail |= ComputeEffectiveAccessScopeRequest_Detail(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessScope", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoleService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoleService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoleService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AccessScope == nil {
				m.AccessScope = &ComputeEffectiveAccessScopeRequest_Payload{}
			}
			if err := m.AccessScope.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoleService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRoleService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ComputeEffectiveAccessScopeRequest_Payload) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoleService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Payload: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Payload: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SimpleRules", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoleService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoleService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoleService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &storage.SimpleAccessScope_Rules{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.RulesOpt = &ComputeEffectiveAccessScopeRequest_Payload_SimpleRules{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoleService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRoleService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CreateRoleRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoleService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CreateRoleRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CreateRoleRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoleService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoleService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRoleService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Role", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoleService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoleService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRoleService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Role == nil {
				m.Role = &storage.Role{}
			}
			if err := m.Role.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoleService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRoleService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipRoleService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowRoleService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRoleService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRoleService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthRoleService
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupRoleService
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthRoleService
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthRoleService        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowRoleService          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupRoleService = fmt.Errorf("proto: unexpected end of group")
)
