// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api/v1/search_service.proto

package v1

import (
	context "context"
	encoding_binary "encoding/binary"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Next available tag: 32
type SearchCategory int32

const (
	SearchCategory_SEARCH_UNSET             SearchCategory = 0
	SearchCategory_ALERTS                   SearchCategory = 1
	SearchCategory_IMAGES                   SearchCategory = 2
	SearchCategory_IMAGE_COMPONENTS         SearchCategory = 20
	SearchCategory_IMAGE_VULN_EDGE          SearchCategory = 27
	SearchCategory_IMAGE_COMPONENT_EDGE     SearchCategory = 23
	SearchCategory_POLICIES                 SearchCategory = 3
	SearchCategory_DEPLOYMENTS              SearchCategory = 4
	SearchCategory_ACTIVE_COMPONENT         SearchCategory = 30
	SearchCategory_PODS                     SearchCategory = 25
	SearchCategory_SECRETS                  SearchCategory = 5
	SearchCategory_PROCESS_INDICATORS       SearchCategory = 6
	SearchCategory_COMPLIANCE               SearchCategory = 7
	SearchCategory_CLUSTERS                 SearchCategory = 8
	SearchCategory_NAMESPACES               SearchCategory = 9
	SearchCategory_NODES                    SearchCategory = 10
	SearchCategory_NODE_VULN_EDGE           SearchCategory = 28
	SearchCategory_NODE_COMPONENT_EDGE      SearchCategory = 29
	SearchCategory_COMPLIANCE_STANDARD      SearchCategory = 11
	SearchCategory_COMPLIANCE_CONTROL_GROUP SearchCategory = 12
	SearchCategory_COMPLIANCE_CONTROL       SearchCategory = 13
	SearchCategory_SERVICE_ACCOUNTS         SearchCategory = 14
	SearchCategory_ROLES                    SearchCategory = 15
	SearchCategory_ROLEBINDINGS             SearchCategory = 16
	SearchCategory_REPORT_CONFIGURATIONS    SearchCategory = 33
	SearchCategory_PROCESS_BASELINES        SearchCategory = 17
	SearchCategory_SUBJECTS                 SearchCategory = 18
	SearchCategory_RISKS                    SearchCategory = 19
	SearchCategory_VULNERABILITIES          SearchCategory = 21
	SearchCategory_COMPONENT_VULN_EDGE      SearchCategory = 22
	SearchCategory_CLUSTER_VULN_EDGE        SearchCategory = 24
	SearchCategory_NETWORK_ENTITY           SearchCategory = 26
	SearchCategory_VULN_REQUEST             SearchCategory = 32
)

var SearchCategory_name = map[int32]string{
	0:  "SEARCH_UNSET",
	1:  "ALERTS",
	2:  "IMAGES",
	20: "IMAGE_COMPONENTS",
	27: "IMAGE_VULN_EDGE",
	23: "IMAGE_COMPONENT_EDGE",
	3:  "POLICIES",
	4:  "DEPLOYMENTS",
	30: "ACTIVE_COMPONENT",
	25: "PODS",
	5:  "SECRETS",
	6:  "PROCESS_INDICATORS",
	7:  "COMPLIANCE",
	8:  "CLUSTERS",
	9:  "NAMESPACES",
	10: "NODES",
	28: "NODE_VULN_EDGE",
	29: "NODE_COMPONENT_EDGE",
	11: "COMPLIANCE_STANDARD",
	12: "COMPLIANCE_CONTROL_GROUP",
	13: "COMPLIANCE_CONTROL",
	14: "SERVICE_ACCOUNTS",
	15: "ROLES",
	16: "ROLEBINDINGS",
	33: "REPORT_CONFIGURATIONS",
	17: "PROCESS_BASELINES",
	18: "SUBJECTS",
	19: "RISKS",
	21: "VULNERABILITIES",
	22: "COMPONENT_VULN_EDGE",
	24: "CLUSTER_VULN_EDGE",
	26: "NETWORK_ENTITY",
	32: "VULN_REQUEST",
}

var SearchCategory_value = map[string]int32{
	"SEARCH_UNSET":             0,
	"ALERTS":                   1,
	"IMAGES":                   2,
	"IMAGE_COMPONENTS":         20,
	"IMAGE_VULN_EDGE":          27,
	"IMAGE_COMPONENT_EDGE":     23,
	"POLICIES":                 3,
	"DEPLOYMENTS":              4,
	"ACTIVE_COMPONENT":         30,
	"PODS":                     25,
	"SECRETS":                  5,
	"PROCESS_INDICATORS":       6,
	"COMPLIANCE":               7,
	"CLUSTERS":                 8,
	"NAMESPACES":               9,
	"NODES":                    10,
	"NODE_VULN_EDGE":           28,
	"NODE_COMPONENT_EDGE":      29,
	"COMPLIANCE_STANDARD":      11,
	"COMPLIANCE_CONTROL_GROUP": 12,
	"COMPLIANCE_CONTROL":       13,
	"SERVICE_ACCOUNTS":         14,
	"ROLES":                    15,
	"ROLEBINDINGS":             16,
	"REPORT_CONFIGURATIONS":    33,
	"PROCESS_BASELINES":        17,
	"SUBJECTS":                 18,
	"RISKS":                    19,
	"VULNERABILITIES":          21,
	"COMPONENT_VULN_EDGE":      22,
	"CLUSTER_VULN_EDGE":        24,
	"NETWORK_ENTITY":           26,
	"VULN_REQUEST":             32,
}

func (x SearchCategory) String() string {
	return proto.EnumName(SearchCategory_name, int32(x))
}

func (SearchCategory) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_c4215e5dded92b40, []int{0}
}

type SearchDataType int32

const (
	SearchDataType_SEARCH_BOOL     SearchDataType = 0
	SearchDataType_SEARCH_NUMERIC  SearchDataType = 1
	SearchDataType_SEARCH_STRING   SearchDataType = 2
	SearchDataType_SEARCH_DATETIME SearchDataType = 3
	SearchDataType_SEARCH_MAP      SearchDataType = 4
	SearchDataType_SEARCH_ENUM     SearchDataType = 5
)

var SearchDataType_name = map[int32]string{
	0: "SEARCH_BOOL",
	1: "SEARCH_NUMERIC",
	2: "SEARCH_STRING",
	3: "SEARCH_DATETIME",
	4: "SEARCH_MAP",
	5: "SEARCH_ENUM",
}

var SearchDataType_value = map[string]int32{
	"SEARCH_BOOL":     0,
	"SEARCH_NUMERIC":  1,
	"SEARCH_STRING":   2,
	"SEARCH_DATETIME": 3,
	"SEARCH_MAP":      4,
	"SEARCH_ENUM":     5,
}

func (x SearchDataType) String() string {
	return proto.EnumName(SearchDataType_name, int32(x))
}

func (SearchDataType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_c4215e5dded92b40, []int{1}
}

// RawQuery represents the search query string.
// The format of the query string is "<field name>:<value,value,...>+<field name>:<value, value,...>+..."
// For example:
// To search for deployments named "central" and "sensor" in the namespace "stackrox", the query string would be
// "Deployment:central,sensor+Namespace:stackrox"
// RawQuery is used in ListAPIs to search for a particular object.
type RawQuery struct {
	Query                string      `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	Pagination           *Pagination `protobuf:"bytes,2,opt,name=pagination,proto3" json:"pagination,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *RawQuery) Reset()         { *m = RawQuery{} }
func (m *RawQuery) String() string { return proto.CompactTextString(m) }
func (*RawQuery) ProtoMessage()    {}
func (*RawQuery) Descriptor() ([]byte, []int) {
	return fileDescriptor_c4215e5dded92b40, []int{0}
}
func (m *RawQuery) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RawQuery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RawQuery.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RawQuery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawQuery.Merge(m, src)
}
func (m *RawQuery) XXX_Size() int {
	return m.Size()
}
func (m *RawQuery) XXX_DiscardUnknown() {
	xxx_messageInfo_RawQuery.DiscardUnknown(m)
}

var xxx_messageInfo_RawQuery proto.InternalMessageInfo

func (m *RawQuery) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *RawQuery) GetPagination() *Pagination {
	if m != nil {
		return m.Pagination
	}
	return nil
}

func (m *RawQuery) MessageClone() proto.Message {
	return m.Clone()
}
func (m *RawQuery) Clone() *RawQuery {
	if m == nil {
		return nil
	}
	cloned := new(RawQuery)
	*cloned = *m

	cloned.Pagination = m.Pagination.Clone()
	return cloned
}

// RawSearchRequest is used to scope a given search in a specific category.
// The search categories could be deployments, policies, images etc.
type RawSearchRequest struct {
	Query                string           `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	Categories           []SearchCategory `protobuf:"varint,2,rep,packed,name=categories,proto3,enum=v1.SearchCategory" json:"categories,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *RawSearchRequest) Reset()         { *m = RawSearchRequest{} }
func (m *RawSearchRequest) String() string { return proto.CompactTextString(m) }
func (*RawSearchRequest) ProtoMessage()    {}
func (*RawSearchRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c4215e5dded92b40, []int{1}
}
func (m *RawSearchRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RawSearchRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RawSearchRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RawSearchRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawSearchRequest.Merge(m, src)
}
func (m *RawSearchRequest) XXX_Size() int {
	return m.Size()
}
func (m *RawSearchRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RawSearchRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RawSearchRequest proto.InternalMessageInfo

func (m *RawSearchRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *RawSearchRequest) GetCategories() []SearchCategory {
	if m != nil {
		return m.Categories
	}
	return nil
}

func (m *RawSearchRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *RawSearchRequest) Clone() *RawSearchRequest {
	if m == nil {
		return nil
	}
	cloned := new(RawSearchRequest)
	*cloned = *m

	if m.Categories != nil {
		cloned.Categories = make([]SearchCategory, len(m.Categories))
		copy(cloned.Categories, m.Categories)
	}
	return cloned
}

type QuerySortOption struct {
	Field    string `protobuf:"bytes,1,opt,name=field,proto3" json:"field,omitempty"`
	Reversed bool   `protobuf:"varint,2,opt,name=reversed,proto3" json:"reversed,omitempty"`
	// Types that are valid to be assigned to SearchAfterOpt:
	//	*QuerySortOption_SearchAfter
	SearchAfterOpt       isQuerySortOption_SearchAfterOpt `protobuf_oneof:"search_after_opt"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_unrecognized     []byte                           `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *QuerySortOption) Reset()         { *m = QuerySortOption{} }
func (m *QuerySortOption) String() string { return proto.CompactTextString(m) }
func (*QuerySortOption) ProtoMessage()    {}
func (*QuerySortOption) Descriptor() ([]byte, []int) {
	return fileDescriptor_c4215e5dded92b40, []int{2}
}
func (m *QuerySortOption) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QuerySortOption) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QuerySortOption.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QuerySortOption) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QuerySortOption.Merge(m, src)
}
func (m *QuerySortOption) XXX_Size() int {
	return m.Size()
}
func (m *QuerySortOption) XXX_DiscardUnknown() {
	xxx_messageInfo_QuerySortOption.DiscardUnknown(m)
}

var xxx_messageInfo_QuerySortOption proto.InternalMessageInfo

type isQuerySortOption_SearchAfterOpt interface {
	isQuerySortOption_SearchAfterOpt()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isQuerySortOption_SearchAfterOpt
}

type QuerySortOption_SearchAfter struct {
	SearchAfter string `protobuf:"bytes,3,opt,name=search_after,json=searchAfter,proto3,oneof" json:"search_after,omitempty"`
}

func (*QuerySortOption_SearchAfter) isQuerySortOption_SearchAfterOpt() {}
func (m *QuerySortOption_SearchAfter) Clone() isQuerySortOption_SearchAfterOpt {
	if m == nil {
		return nil
	}
	cloned := new(QuerySortOption_SearchAfter)
	*cloned = *m

	return cloned
}

func (m *QuerySortOption) GetSearchAfterOpt() isQuerySortOption_SearchAfterOpt {
	if m != nil {
		return m.SearchAfterOpt
	}
	return nil
}

func (m *QuerySortOption) GetField() string {
	if m != nil {
		return m.Field
	}
	return ""
}

func (m *QuerySortOption) GetReversed() bool {
	if m != nil {
		return m.Reversed
	}
	return false
}

func (m *QuerySortOption) GetSearchAfter() string {
	if x, ok := m.GetSearchAfterOpt().(*QuerySortOption_SearchAfter); ok {
		return x.SearchAfter
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*QuerySortOption) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*QuerySortOption_SearchAfter)(nil),
	}
}

func (m *QuerySortOption) MessageClone() proto.Message {
	return m.Clone()
}
func (m *QuerySortOption) Clone() *QuerySortOption {
	if m == nil {
		return nil
	}
	cloned := new(QuerySortOption)
	*cloned = *m

	if m.SearchAfterOpt != nil {
		cloned.SearchAfterOpt = m.SearchAfterOpt.Clone()
	}
	return cloned
}

type QueryPagination struct {
	Limit                int32              `protobuf:"varint,1,opt,name=limit,proto3" json:"limit,omitempty"`
	Offset               int32              `protobuf:"varint,2,opt,name=offset,proto3" json:"offset,omitempty"`
	SortOptions          []*QuerySortOption `protobuf:"bytes,3,rep,name=sort_options,json=sortOptions,proto3" json:"sort_options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *QueryPagination) Reset()         { *m = QueryPagination{} }
func (m *QueryPagination) String() string { return proto.CompactTextString(m) }
func (*QueryPagination) ProtoMessage()    {}
func (*QueryPagination) Descriptor() ([]byte, []int) {
	return fileDescriptor_c4215e5dded92b40, []int{3}
}
func (m *QueryPagination) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryPagination) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryPagination.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryPagination) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryPagination.Merge(m, src)
}
func (m *QueryPagination) XXX_Size() int {
	return m.Size()
}
func (m *QueryPagination) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryPagination.DiscardUnknown(m)
}

var xxx_messageInfo_QueryPagination proto.InternalMessageInfo

func (m *QueryPagination) GetLimit() int32 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *QueryPagination) GetOffset() int32 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *QueryPagination) GetSortOptions() []*QuerySortOption {
	if m != nil {
		return m.SortOptions
	}
	return nil
}

func (m *QueryPagination) MessageClone() proto.Message {
	return m.Clone()
}
func (m *QueryPagination) Clone() *QueryPagination {
	if m == nil {
		return nil
	}
	cloned := new(QueryPagination)
	*cloned = *m

	if m.SortOptions != nil {
		cloned.SortOptions = make([]*QuerySortOption, len(m.SortOptions))
		for idx, v := range m.SortOptions {
			cloned.SortOptions[idx] = v.Clone()
		}
	}
	return cloned
}

type BooleanQuery struct {
	Must                 *ConjunctionQuery `protobuf:"bytes,1,opt,name=must,proto3" json:"must,omitempty"`
	MustNot              *DisjunctionQuery `protobuf:"bytes,2,opt,name=must_not,json=mustNot,proto3" json:"must_not,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *BooleanQuery) Reset()         { *m = BooleanQuery{} }
func (m *BooleanQuery) String() string { return proto.CompactTextString(m) }
func (*BooleanQuery) ProtoMessage()    {}
func (*BooleanQuery) Descriptor() ([]byte, []int) {
	return fileDescriptor_c4215e5dded92b40, []int{4}
}
func (m *BooleanQuery) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BooleanQuery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BooleanQuery.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *BooleanQuery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BooleanQuery.Merge(m, src)
}
func (m *BooleanQuery) XXX_Size() int {
	return m.Size()
}
func (m *BooleanQuery) XXX_DiscardUnknown() {
	xxx_messageInfo_BooleanQuery.DiscardUnknown(m)
}

var xxx_messageInfo_BooleanQuery proto.InternalMessageInfo

func (m *BooleanQuery) GetMust() *ConjunctionQuery {
	if m != nil {
		return m.Must
	}
	return nil
}

func (m *BooleanQuery) GetMustNot() *DisjunctionQuery {
	if m != nil {
		return m.MustNot
	}
	return nil
}

func (m *BooleanQuery) MessageClone() proto.Message {
	return m.Clone()
}
func (m *BooleanQuery) Clone() *BooleanQuery {
	if m == nil {
		return nil
	}
	cloned := new(BooleanQuery)
	*cloned = *m

	cloned.Must = m.Must.Clone()
	cloned.MustNot = m.MustNot.Clone()
	return cloned
}

type Query struct {
	// Types that are valid to be assigned to Query:
	//	*Query_Conjunction
	//	*Query_Disjunction
	//	*Query_BaseQuery
	//	*Query_BooleanQuery
	Query                isQuery_Query    `protobuf_oneof:"query"`
	Pagination           *QueryPagination `protobuf:"bytes,4,opt,name=pagination,proto3" json:"pagination,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Query) Reset()         { *m = Query{} }
func (m *Query) String() string { return proto.CompactTextString(m) }
func (*Query) ProtoMessage()    {}
func (*Query) Descriptor() ([]byte, []int) {
	return fileDescriptor_c4215e5dded92b40, []int{5}
}
func (m *Query) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Query) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Query.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Query) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Query.Merge(m, src)
}
func (m *Query) XXX_Size() int {
	return m.Size()
}
func (m *Query) XXX_DiscardUnknown() {
	xxx_messageInfo_Query.DiscardUnknown(m)
}

var xxx_messageInfo_Query proto.InternalMessageInfo

type isQuery_Query interface {
	isQuery_Query()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isQuery_Query
}

type Query_Conjunction struct {
	Conjunction *ConjunctionQuery `protobuf:"bytes,1,opt,name=conjunction,proto3,oneof" json:"conjunction,omitempty"`
}
type Query_Disjunction struct {
	Disjunction *DisjunctionQuery `protobuf:"bytes,2,opt,name=disjunction,proto3,oneof" json:"disjunction,omitempty"`
}
type Query_BaseQuery struct {
	BaseQuery *BaseQuery `protobuf:"bytes,3,opt,name=base_query,json=baseQuery,proto3,oneof" json:"base_query,omitempty"`
}
type Query_BooleanQuery struct {
	BooleanQuery *BooleanQuery `protobuf:"bytes,6,opt,name=boolean_query,json=booleanQuery,proto3,oneof" json:"boolean_query,omitempty"`
}

func (*Query_Conjunction) isQuery_Query() {}
func (m *Query_Conjunction) Clone() isQuery_Query {
	if m == nil {
		return nil
	}
	cloned := new(Query_Conjunction)
	*cloned = *m

	cloned.Conjunction = m.Conjunction.Clone()
	return cloned
}
func (*Query_Disjunction) isQuery_Query() {}
func (m *Query_Disjunction) Clone() isQuery_Query {
	if m == nil {
		return nil
	}
	cloned := new(Query_Disjunction)
	*cloned = *m

	cloned.Disjunction = m.Disjunction.Clone()
	return cloned
}
func (*Query_BaseQuery) isQuery_Query() {}
func (m *Query_BaseQuery) Clone() isQuery_Query {
	if m == nil {
		return nil
	}
	cloned := new(Query_BaseQuery)
	*cloned = *m

	cloned.BaseQuery = m.BaseQuery.Clone()
	return cloned
}
func (*Query_BooleanQuery) isQuery_Query() {}
func (m *Query_BooleanQuery) Clone() isQuery_Query {
	if m == nil {
		return nil
	}
	cloned := new(Query_BooleanQuery)
	*cloned = *m

	cloned.BooleanQuery = m.BooleanQuery.Clone()
	return cloned
}

func (m *Query) GetQuery() isQuery_Query {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *Query) GetConjunction() *ConjunctionQuery {
	if x, ok := m.GetQuery().(*Query_Conjunction); ok {
		return x.Conjunction
	}
	return nil
}

func (m *Query) GetDisjunction() *DisjunctionQuery {
	if x, ok := m.GetQuery().(*Query_Disjunction); ok {
		return x.Disjunction
	}
	return nil
}

func (m *Query) GetBaseQuery() *BaseQuery {
	if x, ok := m.GetQuery().(*Query_BaseQuery); ok {
		return x.BaseQuery
	}
	return nil
}

func (m *Query) GetBooleanQuery() *BooleanQuery {
	if x, ok := m.GetQuery().(*Query_BooleanQuery); ok {
		return x.BooleanQuery
	}
	return nil
}

func (m *Query) GetPagination() *QueryPagination {
	if m != nil {
		return m.Pagination
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Query) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Query_Conjunction)(nil),
		(*Query_Disjunction)(nil),
		(*Query_BaseQuery)(nil),
		(*Query_BooleanQuery)(nil),
	}
}

func (m *Query) MessageClone() proto.Message {
	return m.Clone()
}
func (m *Query) Clone() *Query {
	if m == nil {
		return nil
	}
	cloned := new(Query)
	*cloned = *m

	if m.Query != nil {
		cloned.Query = m.Query.Clone()
	}
	cloned.Pagination = m.Pagination.Clone()
	return cloned
}

// StringQuery represents a query that matches documents that contain the
// query text in _any_ of their fields.
type StringQuery struct {
	Query                string   `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StringQuery) Reset()         { *m = StringQuery{} }
func (m *StringQuery) String() string { return proto.CompactTextString(m) }
func (*StringQuery) ProtoMessage()    {}
func (*StringQuery) Descriptor() ([]byte, []int) {
	return fileDescriptor_c4215e5dded92b40, []int{6}
}
func (m *StringQuery) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StringQuery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StringQuery.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StringQuery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StringQuery.Merge(m, src)
}
func (m *StringQuery) XXX_Size() int {
	return m.Size()
}
func (m *StringQuery) XXX_DiscardUnknown() {
	xxx_messageInfo_StringQuery.DiscardUnknown(m)
}

var xxx_messageInfo_StringQuery proto.InternalMessageInfo

func (m *StringQuery) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *StringQuery) MessageClone() proto.Message {
	return m.Clone()
}
func (m *StringQuery) Clone() *StringQuery {
	if m == nil {
		return nil
	}
	cloned := new(StringQuery)
	*cloned = *m

	return cloned
}

// MatchFieldQuery represents a query that matches documents containing the
// query text in the provided field.
type MatchFieldQuery struct {
	Field                string   `protobuf:"bytes,1,opt,name=field,proto3" json:"field,omitempty"`
	Value                string   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	Highlight            bool     `protobuf:"varint,3,opt,name=highlight,proto3" json:"highlight,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MatchFieldQuery) Reset()         { *m = MatchFieldQuery{} }
func (m *MatchFieldQuery) String() string { return proto.CompactTextString(m) }
func (*MatchFieldQuery) ProtoMessage()    {}
func (*MatchFieldQuery) Descriptor() ([]byte, []int) {
	return fileDescriptor_c4215e5dded92b40, []int{7}
}
func (m *MatchFieldQuery) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MatchFieldQuery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MatchFieldQuery.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MatchFieldQuery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MatchFieldQuery.Merge(m, src)
}
func (m *MatchFieldQuery) XXX_Size() int {
	return m.Size()
}
func (m *MatchFieldQuery) XXX_DiscardUnknown() {
	xxx_messageInfo_MatchFieldQuery.DiscardUnknown(m)
}

var xxx_messageInfo_MatchFieldQuery proto.InternalMessageInfo

func (m *MatchFieldQuery) GetField() string {
	if m != nil {
		return m.Field
	}
	return ""
}

func (m *MatchFieldQuery) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *MatchFieldQuery) GetHighlight() bool {
	if m != nil {
		return m.Highlight
	}
	return false
}

func (m *MatchFieldQuery) MessageClone() proto.Message {
	return m.Clone()
}
func (m *MatchFieldQuery) Clone() *MatchFieldQuery {
	if m == nil {
		return nil
	}
	cloned := new(MatchFieldQuery)
	*cloned = *m

	return cloned
}

// MatchLinkedFieldsQuery represents a query that matches documents which have matches for all the provided
// field values, in corresponding locations.
type MatchLinkedFieldsQuery struct {
	Query                []*MatchFieldQuery `protobuf:"bytes,1,rep,name=query,proto3" json:"query,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *MatchLinkedFieldsQuery) Reset()         { *m = MatchLinkedFieldsQuery{} }
func (m *MatchLinkedFieldsQuery) String() string { return proto.CompactTextString(m) }
func (*MatchLinkedFieldsQuery) ProtoMessage()    {}
func (*MatchLinkedFieldsQuery) Descriptor() ([]byte, []int) {
	return fileDescriptor_c4215e5dded92b40, []int{8}
}
func (m *MatchLinkedFieldsQuery) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MatchLinkedFieldsQuery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MatchLinkedFieldsQuery.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MatchLinkedFieldsQuery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MatchLinkedFieldsQuery.Merge(m, src)
}
func (m *MatchLinkedFieldsQuery) XXX_Size() int {
	return m.Size()
}
func (m *MatchLinkedFieldsQuery) XXX_DiscardUnknown() {
	xxx_messageInfo_MatchLinkedFieldsQuery.DiscardUnknown(m)
}

var xxx_messageInfo_MatchLinkedFieldsQuery proto.InternalMessageInfo

func (m *MatchLinkedFieldsQuery) GetQuery() []*MatchFieldQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *MatchLinkedFieldsQuery) MessageClone() proto.Message {
	return m.Clone()
}
func (m *MatchLinkedFieldsQuery) Clone() *MatchLinkedFieldsQuery {
	if m == nil {
		return nil
	}
	cloned := new(MatchLinkedFieldsQuery)
	*cloned = *m

	if m.Query != nil {
		cloned.Query = make([]*MatchFieldQuery, len(m.Query))
		for idx, v := range m.Query {
			cloned.Query[idx] = v.Clone()
		}
	}
	return cloned
}

// DocIDQuery represents a query that matches documents with the provided ids.
type DocIDQuery struct {
	Ids                  []string `protobuf:"bytes,1,rep,name=ids,proto3" json:"ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DocIDQuery) Reset()         { *m = DocIDQuery{} }
func (m *DocIDQuery) String() string { return proto.CompactTextString(m) }
func (*DocIDQuery) ProtoMessage()    {}
func (*DocIDQuery) Descriptor() ([]byte, []int) {
	return fileDescriptor_c4215e5dded92b40, []int{9}
}
func (m *DocIDQuery) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DocIDQuery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DocIDQuery.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DocIDQuery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DocIDQuery.Merge(m, src)
}
func (m *DocIDQuery) XXX_Size() int {
	return m.Size()
}
func (m *DocIDQuery) XXX_DiscardUnknown() {
	xxx_messageInfo_DocIDQuery.DiscardUnknown(m)
}

var xxx_messageInfo_DocIDQuery proto.InternalMessageInfo

func (m *DocIDQuery) GetIds() []string {
	if m != nil {
		return m.Ids
	}
	return nil
}

func (m *DocIDQuery) MessageClone() proto.Message {
	return m.Clone()
}
func (m *DocIDQuery) Clone() *DocIDQuery {
	if m == nil {
		return nil
	}
	cloned := new(DocIDQuery)
	*cloned = *m

	if m.Ids != nil {
		cloned.Ids = make([]string, len(m.Ids))
		copy(cloned.Ids, m.Ids)
	}
	return cloned
}

type BaseQuery struct {
	// Types that are valid to be assigned to Query:
	//	*BaseQuery_MatchFieldQuery
	//	*BaseQuery_MatchLinkedFieldsQuery
	//	*BaseQuery_DocIdQuery
	//	*BaseQuery_MatchNoneQuery
	Query                isBaseQuery_Query `protobuf_oneof:"query"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *BaseQuery) Reset()         { *m = BaseQuery{} }
func (m *BaseQuery) String() string { return proto.CompactTextString(m) }
func (*BaseQuery) ProtoMessage()    {}
func (*BaseQuery) Descriptor() ([]byte, []int) {
	return fileDescriptor_c4215e5dded92b40, []int{10}
}
func (m *BaseQuery) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BaseQuery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BaseQuery.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *BaseQuery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BaseQuery.Merge(m, src)
}
func (m *BaseQuery) XXX_Size() int {
	return m.Size()
}
func (m *BaseQuery) XXX_DiscardUnknown() {
	xxx_messageInfo_BaseQuery.DiscardUnknown(m)
}

var xxx_messageInfo_BaseQuery proto.InternalMessageInfo

type isBaseQuery_Query interface {
	isBaseQuery_Query()
	MarshalTo([]byte) (int, error)
	Size() int
	Clone() isBaseQuery_Query
}

type BaseQuery_MatchFieldQuery struct {
	MatchFieldQuery *MatchFieldQuery `protobuf:"bytes,2,opt,name=match_field_query,json=matchFieldQuery,proto3,oneof" json:"match_field_query,omitempty"`
}
type BaseQuery_MatchLinkedFieldsQuery struct {
	MatchLinkedFieldsQuery *MatchLinkedFieldsQuery `protobuf:"bytes,3,opt,name=match_linked_fields_query,json=matchLinkedFieldsQuery,proto3,oneof" json:"match_linked_fields_query,omitempty"`
}
type BaseQuery_DocIdQuery struct {
	DocIdQuery *DocIDQuery `protobuf:"bytes,4,opt,name=doc_id_query,json=docIdQuery,proto3,oneof" json:"doc_id_query,omitempty"`
}
type BaseQuery_MatchNoneQuery struct {
	MatchNoneQuery *MatchNoneQuery `protobuf:"bytes,5,opt,name=match_none_query,json=matchNoneQuery,proto3,oneof" json:"match_none_query,omitempty"`
}

func (*BaseQuery_MatchFieldQuery) isBaseQuery_Query() {}
func (m *BaseQuery_MatchFieldQuery) Clone() isBaseQuery_Query {
	if m == nil {
		return nil
	}
	cloned := new(BaseQuery_MatchFieldQuery)
	*cloned = *m

	cloned.MatchFieldQuery = m.MatchFieldQuery.Clone()
	return cloned
}
func (*BaseQuery_MatchLinkedFieldsQuery) isBaseQuery_Query() {}
func (m *BaseQuery_MatchLinkedFieldsQuery) Clone() isBaseQuery_Query {
	if m == nil {
		return nil
	}
	cloned := new(BaseQuery_MatchLinkedFieldsQuery)
	*cloned = *m

	cloned.MatchLinkedFieldsQuery = m.MatchLinkedFieldsQuery.Clone()
	return cloned
}
func (*BaseQuery_DocIdQuery) isBaseQuery_Query() {}
func (m *BaseQuery_DocIdQuery) Clone() isBaseQuery_Query {
	if m == nil {
		return nil
	}
	cloned := new(BaseQuery_DocIdQuery)
	*cloned = *m

	cloned.DocIdQuery = m.DocIdQuery.Clone()
	return cloned
}
func (*BaseQuery_MatchNoneQuery) isBaseQuery_Query() {}
func (m *BaseQuery_MatchNoneQuery) Clone() isBaseQuery_Query {
	if m == nil {
		return nil
	}
	cloned := new(BaseQuery_MatchNoneQuery)
	*cloned = *m

	cloned.MatchNoneQuery = m.MatchNoneQuery.Clone()
	return cloned
}

func (m *BaseQuery) GetQuery() isBaseQuery_Query {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *BaseQuery) GetMatchFieldQuery() *MatchFieldQuery {
	if x, ok := m.GetQuery().(*BaseQuery_MatchFieldQuery); ok {
		return x.MatchFieldQuery
	}
	return nil
}

func (m *BaseQuery) GetMatchLinkedFieldsQuery() *MatchLinkedFieldsQuery {
	if x, ok := m.GetQuery().(*BaseQuery_MatchLinkedFieldsQuery); ok {
		return x.MatchLinkedFieldsQuery
	}
	return nil
}

func (m *BaseQuery) GetDocIdQuery() *DocIDQuery {
	if x, ok := m.GetQuery().(*BaseQuery_DocIdQuery); ok {
		return x.DocIdQuery
	}
	return nil
}

func (m *BaseQuery) GetMatchNoneQuery() *MatchNoneQuery {
	if x, ok := m.GetQuery().(*BaseQuery_MatchNoneQuery); ok {
		return x.MatchNoneQuery
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*BaseQuery) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*BaseQuery_MatchFieldQuery)(nil),
		(*BaseQuery_MatchLinkedFieldsQuery)(nil),
		(*BaseQuery_DocIdQuery)(nil),
		(*BaseQuery_MatchNoneQuery)(nil),
	}
}

func (m *BaseQuery) MessageClone() proto.Message {
	return m.Clone()
}
func (m *BaseQuery) Clone() *BaseQuery {
	if m == nil {
		return nil
	}
	cloned := new(BaseQuery)
	*cloned = *m

	if m.Query != nil {
		cloned.Query = m.Query.Clone()
	}
	return cloned
}

type ConjunctionQuery struct {
	Queries              []*Query `protobuf:"bytes,1,rep,name=queries,proto3" json:"queries,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ConjunctionQuery) Reset()         { *m = ConjunctionQuery{} }
func (m *ConjunctionQuery) String() string { return proto.CompactTextString(m) }
func (*ConjunctionQuery) ProtoMessage()    {}
func (*ConjunctionQuery) Descriptor() ([]byte, []int) {
	return fileDescriptor_c4215e5dded92b40, []int{11}
}
func (m *ConjunctionQuery) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ConjunctionQuery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ConjunctionQuery.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ConjunctionQuery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConjunctionQuery.Merge(m, src)
}
func (m *ConjunctionQuery) XXX_Size() int {
	return m.Size()
}
func (m *ConjunctionQuery) XXX_DiscardUnknown() {
	xxx_messageInfo_ConjunctionQuery.DiscardUnknown(m)
}

var xxx_messageInfo_ConjunctionQuery proto.InternalMessageInfo

func (m *ConjunctionQuery) GetQueries() []*Query {
	if m != nil {
		return m.Queries
	}
	return nil
}

func (m *ConjunctionQuery) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ConjunctionQuery) Clone() *ConjunctionQuery {
	if m == nil {
		return nil
	}
	cloned := new(ConjunctionQuery)
	*cloned = *m

	if m.Queries != nil {
		cloned.Queries = make([]*Query, len(m.Queries))
		for idx, v := range m.Queries {
			cloned.Queries[idx] = v.Clone()
		}
	}
	return cloned
}

type DisjunctionQuery struct {
	Queries              []*Query `protobuf:"bytes,1,rep,name=queries,proto3" json:"queries,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DisjunctionQuery) Reset()         { *m = DisjunctionQuery{} }
func (m *DisjunctionQuery) String() string { return proto.CompactTextString(m) }
func (*DisjunctionQuery) ProtoMessage()    {}
func (*DisjunctionQuery) Descriptor() ([]byte, []int) {
	return fileDescriptor_c4215e5dded92b40, []int{12}
}
func (m *DisjunctionQuery) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DisjunctionQuery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DisjunctionQuery.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DisjunctionQuery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DisjunctionQuery.Merge(m, src)
}
func (m *DisjunctionQuery) XXX_Size() int {
	return m.Size()
}
func (m *DisjunctionQuery) XXX_DiscardUnknown() {
	xxx_messageInfo_DisjunctionQuery.DiscardUnknown(m)
}

var xxx_messageInfo_DisjunctionQuery proto.InternalMessageInfo

func (m *DisjunctionQuery) GetQueries() []*Query {
	if m != nil {
		return m.Queries
	}
	return nil
}

func (m *DisjunctionQuery) MessageClone() proto.Message {
	return m.Clone()
}
func (m *DisjunctionQuery) Clone() *DisjunctionQuery {
	if m == nil {
		return nil
	}
	cloned := new(DisjunctionQuery)
	*cloned = *m

	if m.Queries != nil {
		cloned.Queries = make([]*Query, len(m.Queries))
		for idx, v := range m.Queries {
			cloned.Queries[idx] = v.Clone()
		}
	}
	return cloned
}

type MatchNoneQuery struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MatchNoneQuery) Reset()         { *m = MatchNoneQuery{} }
func (m *MatchNoneQuery) String() string { return proto.CompactTextString(m) }
func (*MatchNoneQuery) ProtoMessage()    {}
func (*MatchNoneQuery) Descriptor() ([]byte, []int) {
	return fileDescriptor_c4215e5dded92b40, []int{13}
}
func (m *MatchNoneQuery) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MatchNoneQuery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MatchNoneQuery.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MatchNoneQuery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MatchNoneQuery.Merge(m, src)
}
func (m *MatchNoneQuery) XXX_Size() int {
	return m.Size()
}
func (m *MatchNoneQuery) XXX_DiscardUnknown() {
	xxx_messageInfo_MatchNoneQuery.DiscardUnknown(m)
}

var xxx_messageInfo_MatchNoneQuery proto.InternalMessageInfo

func (m *MatchNoneQuery) MessageClone() proto.Message {
	return m.Clone()
}
func (m *MatchNoneQuery) Clone() *MatchNoneQuery {
	if m == nil {
		return nil
	}
	cloned := new(MatchNoneQuery)
	*cloned = *m

	return cloned
}

type SearchResult struct {
	Id             string                           `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Name           string                           `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Category       SearchCategory                   `protobuf:"varint,3,opt,name=category,proto3,enum=v1.SearchCategory" json:"category,omitempty"`
	FieldToMatches map[string]*SearchResult_Matches `protobuf:"bytes,4,rep,name=field_to_matches,json=fieldToMatches,proto3" json:"field_to_matches,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Score          float64                          `protobuf:"fixed64,5,opt,name=score,proto3" json:"score,omitempty"`
	// Location is intended to be a unique, yet human readable,
	// identifier for the result. For example, for a deployment,
	// the location will be "$cluster_name/$namespace/$deployment_name.
	// It is displayed in the UI in the global search results, underneath
	// the name for each result.
	Location             string   `protobuf:"bytes,6,opt,name=location,proto3" json:"location,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchResult) Reset()         { *m = SearchResult{} }
func (m *SearchResult) String() string { return proto.CompactTextString(m) }
func (*SearchResult) ProtoMessage()    {}
func (*SearchResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_c4215e5dded92b40, []int{14}
}
func (m *SearchResult) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SearchResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SearchResult.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SearchResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchResult.Merge(m, src)
}
func (m *SearchResult) XXX_Size() int {
	return m.Size()
}
func (m *SearchResult) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchResult.DiscardUnknown(m)
}

var xxx_messageInfo_SearchResult proto.InternalMessageInfo

func (m *SearchResult) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *SearchResult) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SearchResult) GetCategory() SearchCategory {
	if m != nil {
		return m.Category
	}
	return SearchCategory_SEARCH_UNSET
}

func (m *SearchResult) GetFieldToMatches() map[string]*SearchResult_Matches {
	if m != nil {
		return m.FieldToMatches
	}
	return nil
}

func (m *SearchResult) GetScore() float64 {
	if m != nil {
		return m.Score
	}
	return 0
}

func (m *SearchResult) GetLocation() string {
	if m != nil {
		return m.Location
	}
	return ""
}

func (m *SearchResult) MessageClone() proto.Message {
	return m.Clone()
}
func (m *SearchResult) Clone() *SearchResult {
	if m == nil {
		return nil
	}
	cloned := new(SearchResult)
	*cloned = *m

	if m.FieldToMatches != nil {
		cloned.FieldToMatches = make(map[string]*SearchResult_Matches, len(m.FieldToMatches))
		for k, v := range m.FieldToMatches {
			cloned.FieldToMatches[k] = v.Clone()
		}
	}
	return cloned
}

type SearchResult_Matches struct {
	Values               []string `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchResult_Matches) Reset()         { *m = SearchResult_Matches{} }
func (m *SearchResult_Matches) String() string { return proto.CompactTextString(m) }
func (*SearchResult_Matches) ProtoMessage()    {}
func (*SearchResult_Matches) Descriptor() ([]byte, []int) {
	return fileDescriptor_c4215e5dded92b40, []int{14, 0}
}
func (m *SearchResult_Matches) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SearchResult_Matches) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SearchResult_Matches.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SearchResult_Matches) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchResult_Matches.Merge(m, src)
}
func (m *SearchResult_Matches) XXX_Size() int {
	return m.Size()
}
func (m *SearchResult_Matches) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchResult_Matches.DiscardUnknown(m)
}

var xxx_messageInfo_SearchResult_Matches proto.InternalMessageInfo

func (m *SearchResult_Matches) GetValues() []string {
	if m != nil {
		return m.Values
	}
	return nil
}

func (m *SearchResult_Matches) MessageClone() proto.Message {
	return m.Clone()
}
func (m *SearchResult_Matches) Clone() *SearchResult_Matches {
	if m == nil {
		return nil
	}
	cloned := new(SearchResult_Matches)
	*cloned = *m

	if m.Values != nil {
		cloned.Values = make([]string, len(m.Values))
		copy(cloned.Values, m.Values)
	}
	return cloned
}

type SearchResponse struct {
	Results              []*SearchResult         `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	Counts               []*SearchResponse_Count `protobuf:"bytes,2,rep,name=counts,proto3" json:"counts,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *SearchResponse) Reset()         { *m = SearchResponse{} }
func (m *SearchResponse) String() string { return proto.CompactTextString(m) }
func (*SearchResponse) ProtoMessage()    {}
func (*SearchResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_c4215e5dded92b40, []int{15}
}
func (m *SearchResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SearchResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SearchResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SearchResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchResponse.Merge(m, src)
}
func (m *SearchResponse) XXX_Size() int {
	return m.Size()
}
func (m *SearchResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SearchResponse proto.InternalMessageInfo

func (m *SearchResponse) GetResults() []*SearchResult {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *SearchResponse) GetCounts() []*SearchResponse_Count {
	if m != nil {
		return m.Counts
	}
	return nil
}

func (m *SearchResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *SearchResponse) Clone() *SearchResponse {
	if m == nil {
		return nil
	}
	cloned := new(SearchResponse)
	*cloned = *m

	if m.Results != nil {
		cloned.Results = make([]*SearchResult, len(m.Results))
		for idx, v := range m.Results {
			cloned.Results[idx] = v.Clone()
		}
	}
	if m.Counts != nil {
		cloned.Counts = make([]*SearchResponse_Count, len(m.Counts))
		for idx, v := range m.Counts {
			cloned.Counts[idx] = v.Clone()
		}
	}
	return cloned
}

type SearchResponse_Count struct {
	Category             SearchCategory `protobuf:"varint,1,opt,name=category,proto3,enum=v1.SearchCategory" json:"category,omitempty"`
	Count                int64          `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *SearchResponse_Count) Reset()         { *m = SearchResponse_Count{} }
func (m *SearchResponse_Count) String() string { return proto.CompactTextString(m) }
func (*SearchResponse_Count) ProtoMessage()    {}
func (*SearchResponse_Count) Descriptor() ([]byte, []int) {
	return fileDescriptor_c4215e5dded92b40, []int{15, 0}
}
func (m *SearchResponse_Count) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SearchResponse_Count) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SearchResponse_Count.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SearchResponse_Count) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchResponse_Count.Merge(m, src)
}
func (m *SearchResponse_Count) XXX_Size() int {
	return m.Size()
}
func (m *SearchResponse_Count) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchResponse_Count.DiscardUnknown(m)
}

var xxx_messageInfo_SearchResponse_Count proto.InternalMessageInfo

func (m *SearchResponse_Count) GetCategory() SearchCategory {
	if m != nil {
		return m.Category
	}
	return SearchCategory_SEARCH_UNSET
}

func (m *SearchResponse_Count) GetCount() int64 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *SearchResponse_Count) MessageClone() proto.Message {
	return m.Clone()
}
func (m *SearchResponse_Count) Clone() *SearchResponse_Count {
	if m == nil {
		return nil
	}
	cloned := new(SearchResponse_Count)
	*cloned = *m

	return cloned
}

type SearchOptionsRequest struct {
	Categories           []SearchCategory `protobuf:"varint,1,rep,packed,name=categories,proto3,enum=v1.SearchCategory" json:"categories,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *SearchOptionsRequest) Reset()         { *m = SearchOptionsRequest{} }
func (m *SearchOptionsRequest) String() string { return proto.CompactTextString(m) }
func (*SearchOptionsRequest) ProtoMessage()    {}
func (*SearchOptionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c4215e5dded92b40, []int{16}
}
func (m *SearchOptionsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SearchOptionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SearchOptionsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SearchOptionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchOptionsRequest.Merge(m, src)
}
func (m *SearchOptionsRequest) XXX_Size() int {
	return m.Size()
}
func (m *SearchOptionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchOptionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SearchOptionsRequest proto.InternalMessageInfo

func (m *SearchOptionsRequest) GetCategories() []SearchCategory {
	if m != nil {
		return m.Categories
	}
	return nil
}

func (m *SearchOptionsRequest) MessageClone() proto.Message {
	return m.Clone()
}
func (m *SearchOptionsRequest) Clone() *SearchOptionsRequest {
	if m == nil {
		return nil
	}
	cloned := new(SearchOptionsRequest)
	*cloned = *m

	if m.Categories != nil {
		cloned.Categories = make([]SearchCategory, len(m.Categories))
		copy(cloned.Categories, m.Categories)
	}
	return cloned
}

type SearchOptionsResponse struct {
	Options              []string `protobuf:"bytes,1,rep,name=options,proto3" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchOptionsResponse) Reset()         { *m = SearchOptionsResponse{} }
func (m *SearchOptionsResponse) String() string { return proto.CompactTextString(m) }
func (*SearchOptionsResponse) ProtoMessage()    {}
func (*SearchOptionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_c4215e5dded92b40, []int{17}
}
func (m *SearchOptionsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SearchOptionsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SearchOptionsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SearchOptionsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchOptionsResponse.Merge(m, src)
}
func (m *SearchOptionsResponse) XXX_Size() int {
	return m.Size()
}
func (m *SearchOptionsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchOptionsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SearchOptionsResponse proto.InternalMessageInfo

func (m *SearchOptionsResponse) GetOptions() []string {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *SearchOptionsResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *SearchOptionsResponse) Clone() *SearchOptionsResponse {
	if m == nil {
		return nil
	}
	cloned := new(SearchOptionsResponse)
	*cloned = *m

	if m.Options != nil {
		cloned.Options = make([]string, len(m.Options))
		copy(cloned.Options, m.Options)
	}
	return cloned
}

type AutocompleteResponse struct {
	Values               []string `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AutocompleteResponse) Reset()         { *m = AutocompleteResponse{} }
func (m *AutocompleteResponse) String() string { return proto.CompactTextString(m) }
func (*AutocompleteResponse) ProtoMessage()    {}
func (*AutocompleteResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_c4215e5dded92b40, []int{18}
}
func (m *AutocompleteResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AutocompleteResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AutocompleteResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AutocompleteResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AutocompleteResponse.Merge(m, src)
}
func (m *AutocompleteResponse) XXX_Size() int {
	return m.Size()
}
func (m *AutocompleteResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AutocompleteResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AutocompleteResponse proto.InternalMessageInfo

func (m *AutocompleteResponse) GetValues() []string {
	if m != nil {
		return m.Values
	}
	return nil
}

func (m *AutocompleteResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *AutocompleteResponse) Clone() *AutocompleteResponse {
	if m == nil {
		return nil
	}
	cloned := new(AutocompleteResponse)
	*cloned = *m

	if m.Values != nil {
		cloned.Values = make([]string, len(m.Values))
		copy(cloned.Values, m.Values)
	}
	return cloned
}

func init() {
	proto.RegisterEnum("v1.SearchCategory", SearchCategory_name, SearchCategory_value)
	proto.RegisterEnum("v1.SearchDataType", SearchDataType_name, SearchDataType_value)
	proto.RegisterType((*RawQuery)(nil), "v1.RawQuery")
	proto.RegisterType((*RawSearchRequest)(nil), "v1.RawSearchRequest")
	proto.RegisterType((*QuerySortOption)(nil), "v1.QuerySortOption")
	proto.RegisterType((*QueryPagination)(nil), "v1.QueryPagination")
	proto.RegisterType((*BooleanQuery)(nil), "v1.BooleanQuery")
	proto.RegisterType((*Query)(nil), "v1.Query")
	proto.RegisterType((*StringQuery)(nil), "v1.StringQuery")
	proto.RegisterType((*MatchFieldQuery)(nil), "v1.MatchFieldQuery")
	proto.RegisterType((*MatchLinkedFieldsQuery)(nil), "v1.MatchLinkedFieldsQuery")
	proto.RegisterType((*DocIDQuery)(nil), "v1.DocIDQuery")
	proto.RegisterType((*BaseQuery)(nil), "v1.BaseQuery")
	proto.RegisterType((*ConjunctionQuery)(nil), "v1.ConjunctionQuery")
	proto.RegisterType((*DisjunctionQuery)(nil), "v1.DisjunctionQuery")
	proto.RegisterType((*MatchNoneQuery)(nil), "v1.MatchNoneQuery")
	proto.RegisterType((*SearchResult)(nil), "v1.SearchResult")
	proto.RegisterMapType((map[string]*SearchResult_Matches)(nil), "v1.SearchResult.FieldToMatchesEntry")
	proto.RegisterType((*SearchResult_Matches)(nil), "v1.SearchResult.Matches")
	proto.RegisterType((*SearchResponse)(nil), "v1.SearchResponse")
	proto.RegisterType((*SearchResponse_Count)(nil), "v1.SearchResponse.Count")
	proto.RegisterType((*SearchOptionsRequest)(nil), "v1.SearchOptionsRequest")
	proto.RegisterType((*SearchOptionsResponse)(nil), "v1.SearchOptionsResponse")
	proto.RegisterType((*AutocompleteResponse)(nil), "v1.AutocompleteResponse")
}

func init() { proto.RegisterFile("api/v1/search_service.proto", fileDescriptor_c4215e5dded92b40) }

var fileDescriptor_c4215e5dded92b40 = []byte{
	// 1569 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x57, 0x4d, 0x6f, 0xdb, 0xc8,
	0x19, 0xd6, 0xf7, 0xc7, 0x2b, 0x59, 0x9e, 0x8c, 0x15, 0x47, 0x56, 0xb2, 0xae, 0x97, 0xe9, 0xc1,
	0xcd, 0x41, 0xae, 0xbd, 0x40, 0x77, 0xd1, 0x43, 0x01, 0x8a, 0x9a, 0xd8, 0xcc, 0x4a, 0xa4, 0x76,
	0x86, 0xca, 0x76, 0xbb, 0x05, 0x08, 0x5a, 0xa2, 0x6d, 0x36, 0x12, 0xa9, 0x15, 0x29, 0xa5, 0x01,
	0x8a, 0x02, 0xed, 0x5f, 0xe8, 0xa5, 0x97, 0xde, 0x7a, 0xe8, 0x9f, 0xe8, 0xbd, 0xc7, 0x02, 0xfd,
	0x03, 0x45, 0xba, 0x3f, 0xa4, 0x98, 0x19, 0x52, 0xa2, 0x64, 0x27, 0xc8, 0xc9, 0x33, 0xef, 0x3c,
	0xcf, 0xf3, 0x7e, 0xce, 0x50, 0x86, 0xa7, 0xce, 0xdc, 0x3b, 0x5b, 0x9d, 0x9f, 0x85, 0xae, 0xb3,
	0x18, 0xdf, 0xd9, 0xa1, 0xbb, 0x58, 0x79, 0x63, 0xb7, 0x33, 0x5f, 0x04, 0x51, 0x80, 0x73, 0xab,
	0xf3, 0xf6, 0xb3, 0xdb, 0x20, 0xb8, 0x9d, 0xba, 0x67, 0x1c, 0xe7, 0xf8, 0x7e, 0x10, 0x39, 0x91,
	0x17, 0xf8, 0xa1, 0x44, 0xb4, 0x9f, 0xc4, 0xf4, 0xb9, 0x73, 0xeb, 0xf9, 0xe2, 0x44, 0x1e, 0x28,
	0x43, 0xa8, 0x50, 0xe7, 0xed, 0x37, 0x4b, 0x77, 0xf1, 0x0e, 0x37, 0xa1, 0xf8, 0x03, 0x5f, 0xb4,
	0xb2, 0x27, 0xd9, 0xd3, 0x2a, 0x95, 0x1b, 0xdc, 0x01, 0xd8, 0xb0, 0x5a, 0xb9, 0x93, 0xec, 0x69,
	0xed, 0xa2, 0xd1, 0x59, 0x9d, 0x77, 0x86, 0x6b, 0x2b, 0x4d, 0x21, 0x94, 0xdf, 0x02, 0xa2, 0xce,
	0x5b, 0x26, 0xe2, 0xa4, 0xee, 0x0f, 0x4b, 0x37, 0x8c, 0x3e, 0xa0, 0x7c, 0x01, 0x30, 0x76, 0x22,
	0xf7, 0x36, 0x58, 0x78, 0x6e, 0xd8, 0xca, 0x9d, 0xe4, 0x4f, 0x1b, 0x17, 0x98, 0x2b, 0x4b, 0xb2,
	0x26, 0xcf, 0xde, 0xd1, 0x14, 0x4a, 0xf9, 0x03, 0xec, 0x8b, 0x60, 0x59, 0xb0, 0x88, 0xcc, 0x39,
	0x77, 0xc8, 0xc5, 0x6f, 0x3c, 0x77, 0x3a, 0x49, 0xc4, 0xc5, 0x06, 0xb7, 0xa1, 0xb2, 0x70, 0x57,
	0xee, 0x22, 0x74, 0x27, 0x22, 0xe8, 0x0a, 0x5d, 0xef, 0xf1, 0x73, 0xa8, 0xc7, 0x75, 0x74, 0x6e,
	0x22, 0x77, 0xd1, 0xca, 0x73, 0xe2, 0x55, 0x86, 0xd6, 0xa4, 0x55, 0xe5, 0xc6, 0x2e, 0x06, 0x94,
	0x06, 0xd9, 0xc1, 0x3c, 0x52, 0xde, 0xc6, 0xde, 0x37, 0xa9, 0x73, 0xef, 0x53, 0x6f, 0xe6, 0x45,
	0xc2, 0x7b, 0x91, 0xca, 0x0d, 0x3e, 0x84, 0x52, 0x70, 0x73, 0x13, 0xba, 0x91, 0xf0, 0x5d, 0xa4,
	0xf1, 0x0e, 0xff, 0x02, 0xea, 0x61, 0xb0, 0x88, 0xb8, 0x18, 0xef, 0x4e, 0x2b, 0x7f, 0x92, 0x3f,
	0xad, 0x5d, 0x1c, 0xf0, 0xa4, 0x77, 0xd2, 0xa2, 0xb5, 0x70, 0xbd, 0x0e, 0x15, 0x0f, 0xea, 0xdd,
	0x20, 0x98, 0xba, 0x8e, 0x2f, 0x5b, 0x75, 0x0a, 0x85, 0xd9, 0x32, 0x94, 0x4e, 0x6b, 0x17, 0x4d,
	0xce, 0xd7, 0x02, 0xff, 0x77, 0x4b, 0x7f, 0xcc, 0xf1, 0x02, 0x43, 0x05, 0x02, 0x9f, 0x41, 0x85,
	0xff, 0xb5, 0xfd, 0x20, 0x8a, 0x9b, 0x27, 0xd0, 0x3d, 0x2f, 0xdc, 0x46, 0x97, 0x39, 0xca, 0x08,
	0x22, 0xe5, 0x1f, 0x39, 0x28, 0x4a, 0x27, 0x5f, 0x41, 0x6d, 0xbc, 0x11, 0xfd, 0x98, 0x2f, 0x5e,
	0xbb, 0x14, 0x94, 0x33, 0x27, 0x1b, 0x07, 0x1f, 0xf3, 0xcb, 0x99, 0x29, 0x28, 0x9f, 0xb6, 0x6b,
	0x27, 0x74, 0x6d, 0x39, 0x2e, 0x79, 0x41, 0xdc, 0xe3, 0xc4, 0xae, 0x13, 0xba, 0x09, 0xa3, 0x7a,
	0x9d, 0x6c, 0xf0, 0x97, 0xb0, 0x77, 0x2d, 0x0b, 0x13, 0x53, 0x4a, 0x82, 0x82, 0x04, 0x25, 0x55,
	0xb1, 0xab, 0x0c, 0xad, 0x5f, 0xa7, 0x2b, 0xf8, 0xc5, 0xd6, 0x58, 0x17, 0x04, 0x6b, 0xd3, 0x87,
	0x87, 0x67, 0xbb, 0x5b, 0x8e, 0xe7, 0xf8, 0x55, 0xa1, 0x52, 0x44, 0x25, 0xe5, 0x39, 0xd4, 0x58,
	0xb4, 0xf0, 0xfc, 0xdb, 0x8f, 0xdc, 0x1f, 0xe5, 0x7b, 0xd8, 0x1f, 0x38, 0xd1, 0xf8, 0xee, 0x25,
	0x1f, 0xcb, 0x35, 0xf0, 0x81, 0x89, 0x6d, 0x42, 0x71, 0xe5, 0x4c, 0x97, 0xae, 0x28, 0x57, 0x95,
	0xca, 0x0d, 0x7e, 0x06, 0xd5, 0x3b, 0xef, 0xf6, 0x6e, 0xea, 0xdd, 0xde, 0x45, 0xa2, 0x1e, 0x15,
	0xba, 0x31, 0x28, 0x1a, 0x1c, 0x0a, 0xf1, 0xbe, 0xe7, 0xbf, 0x71, 0x27, 0xc2, 0x45, 0x28, 0x7d,
	0xfc, 0x6c, 0x13, 0xcc, 0x7a, 0xc4, 0x76, 0xe2, 0x48, 0x22, 0x3c, 0x06, 0xe8, 0x05, 0x63, 0xbd,
	0x27, 0x89, 0x08, 0xf2, 0xde, 0x24, 0x14, 0xb4, 0x2a, 0xe5, 0x4b, 0xe5, 0xef, 0x39, 0xa8, 0xae,
	0xcb, 0x8f, 0x55, 0x78, 0x34, 0xe3, 0x3a, 0xb6, 0x88, 0x3a, 0xae, 0x7a, 0x6e, 0x53, 0xbf, 0x1d,
	0x27, 0x57, 0x19, 0xba, 0x3f, 0xdb, 0xc9, 0xff, 0x5b, 0x38, 0x92, 0x12, 0x53, 0x11, 0xb6, 0x54,
	0x0a, 0xb7, 0x7a, 0xde, 0x5e, 0x4b, 0xdd, 0x4b, 0xed, 0x2a, 0x43, 0x0f, 0x67, 0x0f, 0x27, 0x7d,
	0x01, 0xf5, 0x49, 0x30, 0xb6, 0xbd, 0x24, 0xac, 0xc2, 0xe6, 0xb5, 0xda, 0x64, 0x78, 0x95, 0xa1,
	0x30, 0x09, 0xc6, 0x7a, 0x1c, 0xcc, 0xaf, 0x00, 0xc9, 0x60, 0xfc, 0xc0, 0x4f, 0xe6, 0xae, 0x28,
	0x78, 0x78, 0x1d, 0x83, 0x11, 0xf8, 0xeb, 0xe1, 0x6b, 0xcc, 0xb6, 0x2c, 0xeb, 0x99, 0x50, 0xbe,
	0x04, 0xb4, 0x7b, 0x2f, 0xf0, 0x73, 0x28, 0xf3, 0x43, 0xfe, 0xbe, 0xc9, 0x3e, 0x54, 0xd7, 0x23,
	0x46, 0x93, 0x13, 0x4e, 0xdc, 0xbd, 0x16, 0x9f, 0x46, 0x44, 0xd0, 0xd8, 0x0e, 0x4f, 0xf9, 0x31,
	0x07, 0xf5, 0xe4, 0xe9, 0x0d, 0x97, 0xd3, 0x08, 0x37, 0x20, 0xe7, 0x25, 0x73, 0x96, 0xf3, 0x26,
	0x18, 0x43, 0xc1, 0x77, 0x66, 0xc9, 0x8c, 0x89, 0x35, 0xee, 0x40, 0x25, 0x7e, 0x61, 0x65, 0xf5,
	0x1f, 0x7e, 0x85, 0xd7, 0x18, 0x6c, 0x00, 0x92, 0xbd, 0x8f, 0x02, 0x5b, 0x14, 0xc3, 0x0d, 0x5b,
	0x05, 0x11, 0xe4, 0x4f, 0x37, 0x3c, 0xe9, 0xbf, 0x23, 0xba, 0x63, 0x05, 0x03, 0x09, 0x23, 0x7e,
	0xb4, 0x78, 0x47, 0x1b, 0x37, 0x5b, 0x46, 0x3e, 0xf8, 0xe1, 0x38, 0x58, 0xb8, 0xa2, 0xec, 0x59,
	0x2a, 0x37, 0xfc, 0x01, 0x9f, 0x06, 0x63, 0x79, 0x3d, 0x4b, 0x22, 0xda, 0xf5, 0xbe, 0xfd, 0x39,
	0x94, 0x13, 0xf2, 0x21, 0x94, 0xc4, 0x45, 0x49, 0x26, 0x36, 0xde, 0xb5, 0xbf, 0x87, 0x83, 0x07,
	0x7c, 0xf3, 0xe9, 0x7e, 0xe3, 0x26, 0x37, 0x94, 0x2f, 0x71, 0x27, 0x7d, 0xed, 0x6a, 0x17, 0xad,
	0x7b, 0x29, 0xc4, 0xfc, 0xf8, 0x42, 0xfe, 0x32, 0xf7, 0x55, 0x56, 0xf9, 0x67, 0x16, 0x1a, 0x6b,
	0xcc, 0x3c, 0xf0, 0x43, 0x17, 0xbf, 0x80, 0xf2, 0x42, 0xe0, 0x93, 0x86, 0xa1, 0x5d, 0x21, 0x9a,
	0x00, 0xf0, 0xcf, 0xa1, 0x34, 0x0e, 0x96, 0x7e, 0x24, 0x3f, 0x7a, 0xbb, 0x3e, 0x85, 0x5e, 0x47,
	0xe3, 0x00, 0x1a, 0xe3, 0xda, 0x03, 0x28, 0x0a, 0xc3, 0x56, 0xaf, 0xb2, 0x9f, 0xd0, 0xab, 0x26,
	0x14, 0x85, 0x84, 0xc8, 0x2e, 0x4f, 0xe5, 0x46, 0x79, 0x05, 0x4d, 0xc9, 0x88, 0xbf, 0x2f, 0xc9,
	0x77, 0x7a, 0xfb, 0x8b, 0x9c, 0xfd, 0xa4, 0x2f, 0xf2, 0x39, 0x3c, 0xde, 0xd1, 0x8a, 0x2b, 0xd2,
	0x82, 0x72, 0xf2, 0x99, 0x93, 0xad, 0x49, 0xb6, 0x4a, 0x07, 0x9a, 0xea, 0x32, 0x0a, 0xc6, 0xc1,
	0x6c, 0x3e, 0x75, 0x23, 0x77, 0xcd, 0xf8, 0x40, 0x2f, 0x5f, 0xfc, 0xa9, 0x98, 0x94, 0x3b, 0x89,
	0x00, 0x23, 0xa8, 0x33, 0xa2, 0x52, 0xed, 0xca, 0x1e, 0x19, 0x8c, 0x58, 0x28, 0x83, 0x01, 0x4a,
	0x6a, 0x9f, 0x50, 0x8b, 0xa1, 0x2c, 0x5f, 0xeb, 0x03, 0xf5, 0x92, 0x30, 0x94, 0xc3, 0x4d, 0x40,
	0x62, 0x6d, 0x6b, 0xe6, 0x60, 0x68, 0x1a, 0xc4, 0xb0, 0x18, 0x6a, 0xe2, 0x03, 0xd8, 0x97, 0xd6,
	0xd7, 0xa3, 0xbe, 0x61, 0x93, 0xde, 0x25, 0x41, 0x4f, 0x71, 0x0b, 0x9a, 0x3b, 0x50, 0x79, 0xf2,
	0x04, 0xd7, 0xa1, 0x32, 0x34, 0xfb, 0xba, 0xa6, 0x13, 0x86, 0xf2, 0x78, 0x1f, 0x6a, 0x3d, 0x32,
	0xec, 0x9b, 0xdf, 0x0d, 0x84, 0x5a, 0x81, 0xfb, 0x50, 0x35, 0x4b, 0x7f, 0x9d, 0x62, 0xa2, 0x63,
	0x5c, 0x81, 0xc2, 0xd0, 0xec, 0x31, 0x74, 0x84, 0x6b, 0x50, 0x66, 0x44, 0xa3, 0xc4, 0x62, 0xa8,
	0x88, 0x0f, 0x01, 0x0f, 0xa9, 0xa9, 0x11, 0xc6, 0x6c, 0xdd, 0xe8, 0xe9, 0x9a, 0x6a, 0x99, 0x94,
	0xa1, 0x12, 0x6e, 0x00, 0x70, 0x76, 0x5f, 0x57, 0x0d, 0x8d, 0xa0, 0x32, 0xf7, 0xa9, 0xf5, 0x47,
	0xcc, 0x22, 0x94, 0xa1, 0x0a, 0x3f, 0x35, 0xd4, 0x01, 0x61, 0x43, 0x55, 0x23, 0x0c, 0x55, 0x71,
	0x15, 0x8a, 0x86, 0xd9, 0x23, 0x0c, 0x01, 0xc6, 0xd0, 0xe0, 0xcb, 0x54, 0x2a, 0xcf, 0xf0, 0x13,
	0x38, 0x10, 0xb6, 0x9d, 0x4c, 0x3e, 0xe3, 0x07, 0x1b, 0x2f, 0x36, 0xb3, 0x54, 0xa3, 0xa7, 0xd2,
	0x1e, 0xaa, 0xe1, 0x67, 0xd0, 0x4a, 0x1d, 0x68, 0xa6, 0x61, 0x51, 0xb3, 0x6f, 0x5f, 0x52, 0x73,
	0x34, 0x44, 0x75, 0x1e, 0xf4, 0xfd, 0x53, 0xb4, 0xc7, 0x33, 0x67, 0x84, 0xbe, 0xd6, 0x35, 0x62,
	0xab, 0x9a, 0x66, 0x8e, 0x78, 0x3d, 0x1a, 0x3c, 0x38, 0x6a, 0xf6, 0x09, 0x43, 0xfb, 0xbc, 0x51,
	0x7c, 0xd9, 0xe5, 0xa9, 0x1a, 0x97, 0x0c, 0x21, 0x7c, 0x04, 0x8f, 0x29, 0x19, 0x9a, 0xd4, 0xe2,
	0x32, 0x2f, 0xf5, 0xcb, 0x11, 0x55, 0x2d, 0xdd, 0x34, 0x18, 0xfa, 0x1c, 0x3f, 0x86, 0x47, 0x49,
	0x69, 0xba, 0x2a, 0x23, 0x7d, 0xdd, 0x20, 0x0c, 0x3d, 0xe2, 0x95, 0x60, 0xa3, 0xee, 0x2b, 0xa2,
	0x59, 0x0c, 0x61, 0x21, 0xae, 0xb3, 0xaf, 0x19, 0x3a, 0xe0, 0x5d, 0xe4, 0x49, 0x13, 0xaa, 0x76,
	0xf5, 0xbe, 0x6e, 0xf1, 0xee, 0x3c, 0x4e, 0x32, 0x94, 0x59, 0x6f, 0x6a, 0x72, 0xc8, 0xd5, 0xe3,
	0x82, 0xa6, 0xcc, 0x2d, 0x51, 0x3e, 0x62, 0x7d, 0x6b, 0xd2, 0xaf, 0x6d, 0x62, 0x58, 0xba, 0xf5,
	0x1d, 0x6a, 0xf3, 0xa8, 0x05, 0x84, 0x92, 0x6f, 0x46, 0x84, 0x59, 0xe8, 0xe4, 0xc5, 0x1f, 0x93,
	0x11, 0xec, 0x39, 0x91, 0x63, 0xbd, 0x9b, 0xbb, 0x7c, 0x0a, 0xe2, 0x11, 0xec, 0x9a, 0x66, 0x1f,
	0x65, 0xb8, 0x50, 0x6c, 0x30, 0x46, 0x03, 0x42, 0x75, 0x0d, 0x65, 0xf1, 0x23, 0xd8, 0x8b, 0x6d,
	0xcc, 0xa2, 0xba, 0x71, 0x89, 0x72, 0x3c, 0xe8, 0xd8, 0xd4, 0x53, 0x2d, 0x62, 0xe9, 0x03, 0x82,
	0xf2, 0xbc, 0xbd, 0xb1, 0x71, 0xa0, 0x0e, 0x51, 0x21, 0x25, 0x4e, 0x8c, 0xd1, 0x00, 0x15, 0x2f,
	0xfe, 0x96, 0x83, 0x3d, 0x19, 0x00, 0x93, 0xbf, 0xfd, 0xf1, 0x4b, 0x28, 0x49, 0x03, 0x16, 0xbf,
	0xac, 0x76, 0x7f, 0x74, 0xb7, 0xf1, 0xfd, 0x57, 0x45, 0xc1, 0x7f, 0xfe, 0xcf, 0x8f, 0x7f, 0xc9,
	0xd5, 0x31, 0x6c, 0xfe, 0x97, 0xc0, 0x63, 0x28, 0xc7, 0x57, 0x17, 0xa7, 0x1e, 0xa2, 0xed, 0x97,
	0xa1, 0x7d, 0xf4, 0xc0, 0x49, 0xac, 0xf9, 0x5c, 0x68, 0x7e, 0x86, 0x9f, 0x6e, 0x34, 0xcf, 0x66,
	0x6e, 0xe4, 0x4c, 0x9c, 0xc8, 0x39, 0x8b, 0xaf, 0x3c, 0xb6, 0xa1, 0x9e, 0xbe, 0xf2, 0x1f, 0x08,
	0x59, 0xf8, 0x7f, 0xe8, 0x69, 0x50, 0x7e, 0x22, 0x9c, 0x1c, 0xe1, 0x27, 0x29, 0x27, 0x4e, 0x0a,
	0xd8, 0xed, 0xfc, 0xeb, 0xfd, 0x71, 0xf6, 0xdf, 0xef, 0x8f, 0xb3, 0xff, 0x7d, 0x7f, 0x9c, 0xfd,
	0xeb, 0xff, 0x8e, 0x33, 0xd0, 0xf2, 0x82, 0x4e, 0x18, 0x39, 0xe3, 0x37, 0x8b, 0xe0, 0xf7, 0xf2,
	0xbf, 0x9d, 0x8e, 0x33, 0xf7, 0x3a, 0xab, 0xf3, 0xdf, 0xe4, 0x56, 0xe7, 0xbf, 0xce, 0x5c, 0x97,
	0x84, 0xed, 0x8b, 0xff, 0x07, 0x00, 0x00, 0xff, 0xff, 0x63, 0xb1, 0xe3, 0xab, 0x5b, 0x0d, 0x00,
	0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SearchServiceClient is the client API for SearchService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConnInterface.NewStream.
type SearchServiceClient interface {
	Search(ctx context.Context, in *RawSearchRequest, opts ...grpc.CallOption) (*SearchResponse, error)
	Options(ctx context.Context, in *SearchOptionsRequest, opts ...grpc.CallOption) (*SearchOptionsResponse, error)
	Autocomplete(ctx context.Context, in *RawSearchRequest, opts ...grpc.CallOption) (*AutocompleteResponse, error)
}

type searchServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSearchServiceClient(cc grpc.ClientConnInterface) SearchServiceClient {
	return &searchServiceClient{cc}
}

func (c *searchServiceClient) Search(ctx context.Context, in *RawSearchRequest, opts ...grpc.CallOption) (*SearchResponse, error) {
	out := new(SearchResponse)
	err := c.cc.Invoke(ctx, "/v1.SearchService/Search", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *searchServiceClient) Options(ctx context.Context, in *SearchOptionsRequest, opts ...grpc.CallOption) (*SearchOptionsResponse, error) {
	out := new(SearchOptionsResponse)
	err := c.cc.Invoke(ctx, "/v1.SearchService/Options", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *searchServiceClient) Autocomplete(ctx context.Context, in *RawSearchRequest, opts ...grpc.CallOption) (*AutocompleteResponse, error) {
	out := new(AutocompleteResponse)
	err := c.cc.Invoke(ctx, "/v1.SearchService/Autocomplete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SearchServiceServer is the server API for SearchService service.
type SearchServiceServer interface {
	Search(context.Context, *RawSearchRequest) (*SearchResponse, error)
	Options(context.Context, *SearchOptionsRequest) (*SearchOptionsResponse, error)
	Autocomplete(context.Context, *RawSearchRequest) (*AutocompleteResponse, error)
}

// UnimplementedSearchServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSearchServiceServer struct {
}

func (*UnimplementedSearchServiceServer) Search(ctx context.Context, req *RawSearchRequest) (*SearchResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Search not implemented")
}
func (*UnimplementedSearchServiceServer) Options(ctx context.Context, req *SearchOptionsRequest) (*SearchOptionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Options not implemented")
}
func (*UnimplementedSearchServiceServer) Autocomplete(ctx context.Context, req *RawSearchRequest) (*AutocompleteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Autocomplete not implemented")
}

func RegisterSearchServiceServer(s *grpc.Server, srv SearchServiceServer) {
	s.RegisterService(&_SearchService_serviceDesc, srv)
}

func _SearchService_Search_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RawSearchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SearchServiceServer).Search(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.SearchService/Search",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SearchServiceServer).Search(ctx, req.(*RawSearchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SearchService_Options_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchOptionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SearchServiceServer).Options(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.SearchService/Options",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SearchServiceServer).Options(ctx, req.(*SearchOptionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SearchService_Autocomplete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RawSearchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SearchServiceServer).Autocomplete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.SearchService/Autocomplete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SearchServiceServer).Autocomplete(ctx, req.(*RawSearchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SearchService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1.SearchService",
	HandlerType: (*SearchServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Search",
			Handler:    _SearchService_Search_Handler,
		},
		{
			MethodName: "Options",
			Handler:    _SearchService_Options_Handler,
		},
		{
			MethodName: "Autocomplete",
			Handler:    _SearchService_Autocomplete_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/v1/search_service.proto",
}

func (m *RawQuery) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RawQuery) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RawQuery) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Pagination != nil {
		{
			size, err := m.Pagination.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSearchService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Query) > 0 {
		i -= len(m.Query)
		copy(dAtA[i:], m.Query)
		i = encodeVarintSearchService(dAtA, i, uint64(len(m.Query)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RawSearchRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RawSearchRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RawSearchRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Categories) > 0 {
		dAtA3 := make([]byte, len(m.Categories)*10)
		var j2 int
		for _, num := range m.Categories {
			for num >= 1<<7 {
				dAtA3[j2] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j2++
			}
			dAtA3[j2] = uint8(num)
			j2++
		}
		i -= j2
		copy(dAtA[i:], dAtA3[:j2])
		i = encodeVarintSearchService(dAtA, i, uint64(j2))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Query) > 0 {
		i -= len(m.Query)
		copy(dAtA[i:], m.Query)
		i = encodeVarintSearchService(dAtA, i, uint64(len(m.Query)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *QuerySortOption) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QuerySortOption) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QuerySortOption) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.SearchAfterOpt != nil {
		{
			size := m.SearchAfterOpt.Size()
			i -= size
			if _, err := m.SearchAfterOpt.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.Reversed {
		i--
		if m.Reversed {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.Field) > 0 {
		i -= len(m.Field)
		copy(dAtA[i:], m.Field)
		i = encodeVarintSearchService(dAtA, i, uint64(len(m.Field)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *QuerySortOption_SearchAfter) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QuerySortOption_SearchAfter) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.SearchAfter)
	copy(dAtA[i:], m.SearchAfter)
	i = encodeVarintSearchService(dAtA, i, uint64(len(m.SearchAfter)))
	i--
	dAtA[i] = 0x1a
	return len(dAtA) - i, nil
}
func (m *QueryPagination) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryPagination) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryPagination) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.SortOptions) > 0 {
		for iNdEx := len(m.SortOptions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.SortOptions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintSearchService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.Offset != 0 {
		i = encodeVarintSearchService(dAtA, i, uint64(m.Offset))
		i--
		dAtA[i] = 0x10
	}
	if m.Limit != 0 {
		i = encodeVarintSearchService(dAtA, i, uint64(m.Limit))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *BooleanQuery) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BooleanQuery) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *BooleanQuery) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.MustNot != nil {
		{
			size, err := m.MustNot.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSearchService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Must != nil {
		{
			size, err := m.Must.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSearchService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Query) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Query) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Query) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Query != nil {
		{
			size := m.Query.Size()
			i -= size
			if _, err := m.Query.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.Pagination != nil {
		{
			size, err := m.Pagination.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSearchService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	return len(dAtA) - i, nil
}

func (m *Query_Conjunction) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Query_Conjunction) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Conjunction != nil {
		{
			size, err := m.Conjunction.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSearchService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *Query_Disjunction) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Query_Disjunction) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Disjunction != nil {
		{
			size, err := m.Disjunction.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSearchService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *Query_BaseQuery) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Query_BaseQuery) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.BaseQuery != nil {
		{
			size, err := m.BaseQuery.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSearchService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *Query_BooleanQuery) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Query_BooleanQuery) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.BooleanQuery != nil {
		{
			size, err := m.BooleanQuery.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSearchService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	return len(dAtA) - i, nil
}
func (m *StringQuery) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StringQuery) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StringQuery) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Query) > 0 {
		i -= len(m.Query)
		copy(dAtA[i:], m.Query)
		i = encodeVarintSearchService(dAtA, i, uint64(len(m.Query)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MatchFieldQuery) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MatchFieldQuery) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MatchFieldQuery) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Highlight {
		i--
		if m.Highlight {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintSearchService(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Field) > 0 {
		i -= len(m.Field)
		copy(dAtA[i:], m.Field)
		i = encodeVarintSearchService(dAtA, i, uint64(len(m.Field)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MatchLinkedFieldsQuery) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MatchLinkedFieldsQuery) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MatchLinkedFieldsQuery) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Query) > 0 {
		for iNdEx := len(m.Query) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Query[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintSearchService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *DocIDQuery) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DocIDQuery) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DocIDQuery) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Ids) > 0 {
		for iNdEx := len(m.Ids) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Ids[iNdEx])
			copy(dAtA[i:], m.Ids[iNdEx])
			i = encodeVarintSearchService(dAtA, i, uint64(len(m.Ids[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *BaseQuery) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BaseQuery) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *BaseQuery) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Query != nil {
		{
			size := m.Query.Size()
			i -= size
			if _, err := m.Query.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *BaseQuery_MatchFieldQuery) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *BaseQuery_MatchFieldQuery) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.MatchFieldQuery != nil {
		{
			size, err := m.MatchFieldQuery.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSearchService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *BaseQuery_MatchLinkedFieldsQuery) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *BaseQuery_MatchLinkedFieldsQuery) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.MatchLinkedFieldsQuery != nil {
		{
			size, err := m.MatchLinkedFieldsQuery.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSearchService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *BaseQuery_DocIdQuery) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *BaseQuery_DocIdQuery) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.DocIdQuery != nil {
		{
			size, err := m.DocIdQuery.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSearchService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	return len(dAtA) - i, nil
}
func (m *BaseQuery_MatchNoneQuery) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *BaseQuery_MatchNoneQuery) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.MatchNoneQuery != nil {
		{
			size, err := m.MatchNoneQuery.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSearchService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	return len(dAtA) - i, nil
}
func (m *ConjunctionQuery) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConjunctionQuery) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ConjunctionQuery) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Queries) > 0 {
		for iNdEx := len(m.Queries) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Queries[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintSearchService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *DisjunctionQuery) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DisjunctionQuery) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DisjunctionQuery) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Queries) > 0 {
		for iNdEx := len(m.Queries) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Queries[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintSearchService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *MatchNoneQuery) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MatchNoneQuery) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MatchNoneQuery) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *SearchResult) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SearchResult) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SearchResult) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Location) > 0 {
		i -= len(m.Location)
		copy(dAtA[i:], m.Location)
		i = encodeVarintSearchService(dAtA, i, uint64(len(m.Location)))
		i--
		dAtA[i] = 0x32
	}
	if m.Score != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Score))))
		i--
		dAtA[i] = 0x29
	}
	if len(m.FieldToMatches) > 0 {
		for k := range m.FieldToMatches {
			v := m.FieldToMatches[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintSearchService(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintSearchService(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintSearchService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x22
		}
	}
	if m.Category != 0 {
		i = encodeVarintSearchService(dAtA, i, uint64(m.Category))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintSearchService(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintSearchService(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SearchResult_Matches) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SearchResult_Matches) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SearchResult_Matches) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Values) > 0 {
		for iNdEx := len(m.Values) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Values[iNdEx])
			copy(dAtA[i:], m.Values[iNdEx])
			i = encodeVarintSearchService(dAtA, i, uint64(len(m.Values[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *SearchResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SearchResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SearchResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Counts) > 0 {
		for iNdEx := len(m.Counts) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Counts[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintSearchService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Results) > 0 {
		for iNdEx := len(m.Results) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Results[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintSearchService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *SearchResponse_Count) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SearchResponse_Count) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SearchResponse_Count) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Count != 0 {
		i = encodeVarintSearchService(dAtA, i, uint64(m.Count))
		i--
		dAtA[i] = 0x10
	}
	if m.Category != 0 {
		i = encodeVarintSearchService(dAtA, i, uint64(m.Category))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *SearchOptionsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SearchOptionsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SearchOptionsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Categories) > 0 {
		dAtA17 := make([]byte, len(m.Categories)*10)
		var j16 int
		for _, num := range m.Categories {
			for num >= 1<<7 {
				dAtA17[j16] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j16++
			}
			dAtA17[j16] = uint8(num)
			j16++
		}
		i -= j16
		copy(dAtA[i:], dAtA17[:j16])
		i = encodeVarintSearchService(dAtA, i, uint64(j16))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SearchOptionsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SearchOptionsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SearchOptionsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Options) > 0 {
		for iNdEx := len(m.Options) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Options[iNdEx])
			copy(dAtA[i:], m.Options[iNdEx])
			i = encodeVarintSearchService(dAtA, i, uint64(len(m.Options[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *AutocompleteResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AutocompleteResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AutocompleteResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Values) > 0 {
		for iNdEx := len(m.Values) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Values[iNdEx])
			copy(dAtA[i:], m.Values[iNdEx])
			i = encodeVarintSearchService(dAtA, i, uint64(len(m.Values[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func encodeVarintSearchService(dAtA []byte, offset int, v uint64) int {
	offset -= sovSearchService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *RawQuery) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Query)
	if l > 0 {
		n += 1 + l + sovSearchService(uint64(l))
	}
	if m.Pagination != nil {
		l = m.Pagination.Size()
		n += 1 + l + sovSearchService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RawSearchRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Query)
	if l > 0 {
		n += 1 + l + sovSearchService(uint64(l))
	}
	if len(m.Categories) > 0 {
		l = 0
		for _, e := range m.Categories {
			l += sovSearchService(uint64(e))
		}
		n += 1 + sovSearchService(uint64(l)) + l
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *QuerySortOption) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Field)
	if l > 0 {
		n += 1 + l + sovSearchService(uint64(l))
	}
	if m.Reversed {
		n += 2
	}
	if m.SearchAfterOpt != nil {
		n += m.SearchAfterOpt.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *QuerySortOption_SearchAfter) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.SearchAfter)
	n += 1 + l + sovSearchService(uint64(l))
	return n
}
func (m *QueryPagination) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Limit != 0 {
		n += 1 + sovSearchService(uint64(m.Limit))
	}
	if m.Offset != 0 {
		n += 1 + sovSearchService(uint64(m.Offset))
	}
	if len(m.SortOptions) > 0 {
		for _, e := range m.SortOptions {
			l = e.Size()
			n += 1 + l + sovSearchService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *BooleanQuery) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Must != nil {
		l = m.Must.Size()
		n += 1 + l + sovSearchService(uint64(l))
	}
	if m.MustNot != nil {
		l = m.MustNot.Size()
		n += 1 + l + sovSearchService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Query) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Query != nil {
		n += m.Query.Size()
	}
	if m.Pagination != nil {
		l = m.Pagination.Size()
		n += 1 + l + sovSearchService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Query_Conjunction) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Conjunction != nil {
		l = m.Conjunction.Size()
		n += 1 + l + sovSearchService(uint64(l))
	}
	return n
}
func (m *Query_Disjunction) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Disjunction != nil {
		l = m.Disjunction.Size()
		n += 1 + l + sovSearchService(uint64(l))
	}
	return n
}
func (m *Query_BaseQuery) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.BaseQuery != nil {
		l = m.BaseQuery.Size()
		n += 1 + l + sovSearchService(uint64(l))
	}
	return n
}
func (m *Query_BooleanQuery) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.BooleanQuery != nil {
		l = m.BooleanQuery.Size()
		n += 1 + l + sovSearchService(uint64(l))
	}
	return n
}
func (m *StringQuery) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Query)
	if l > 0 {
		n += 1 + l + sovSearchService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MatchFieldQuery) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Field)
	if l > 0 {
		n += 1 + l + sovSearchService(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovSearchService(uint64(l))
	}
	if m.Highlight {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MatchLinkedFieldsQuery) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Query) > 0 {
		for _, e := range m.Query {
			l = e.Size()
			n += 1 + l + sovSearchService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DocIDQuery) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Ids) > 0 {
		for _, s := range m.Ids {
			l = len(s)
			n += 1 + l + sovSearchService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *BaseQuery) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Query != nil {
		n += m.Query.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *BaseQuery_MatchFieldQuery) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MatchFieldQuery != nil {
		l = m.MatchFieldQuery.Size()
		n += 1 + l + sovSearchService(uint64(l))
	}
	return n
}
func (m *BaseQuery_MatchLinkedFieldsQuery) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MatchLinkedFieldsQuery != nil {
		l = m.MatchLinkedFieldsQuery.Size()
		n += 1 + l + sovSearchService(uint64(l))
	}
	return n
}
func (m *BaseQuery_DocIdQuery) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.DocIdQuery != nil {
		l = m.DocIdQuery.Size()
		n += 1 + l + sovSearchService(uint64(l))
	}
	return n
}
func (m *BaseQuery_MatchNoneQuery) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MatchNoneQuery != nil {
		l = m.MatchNoneQuery.Size()
		n += 1 + l + sovSearchService(uint64(l))
	}
	return n
}
func (m *ConjunctionQuery) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Queries) > 0 {
		for _, e := range m.Queries {
			l = e.Size()
			n += 1 + l + sovSearchService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DisjunctionQuery) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Queries) > 0 {
		for _, e := range m.Queries {
			l = e.Size()
			n += 1 + l + sovSearchService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MatchNoneQuery) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SearchResult) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovSearchService(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovSearchService(uint64(l))
	}
	if m.Category != 0 {
		n += 1 + sovSearchService(uint64(m.Category))
	}
	if len(m.FieldToMatches) > 0 {
		for k, v := range m.FieldToMatches {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovSearchService(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovSearchService(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovSearchService(uint64(mapEntrySize))
		}
	}
	if m.Score != 0 {
		n += 9
	}
	l = len(m.Location)
	if l > 0 {
		n += 1 + l + sovSearchService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SearchResult_Matches) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Values) > 0 {
		for _, s := range m.Values {
			l = len(s)
			n += 1 + l + sovSearchService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SearchResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Results) > 0 {
		for _, e := range m.Results {
			l = e.Size()
			n += 1 + l + sovSearchService(uint64(l))
		}
	}
	if len(m.Counts) > 0 {
		for _, e := range m.Counts {
			l = e.Size()
			n += 1 + l + sovSearchService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SearchResponse_Count) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Category != 0 {
		n += 1 + sovSearchService(uint64(m.Category))
	}
	if m.Count != 0 {
		n += 1 + sovSearchService(uint64(m.Count))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SearchOptionsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Categories) > 0 {
		l = 0
		for _, e := range m.Categories {
			l += sovSearchService(uint64(e))
		}
		n += 1 + sovSearchService(uint64(l)) + l
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SearchOptionsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Options) > 0 {
		for _, s := range m.Options {
			l = len(s)
			n += 1 + l + sovSearchService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AutocompleteResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Values) > 0 {
		for _, s := range m.Values {
			l = len(s)
			n += 1 + l + sovSearchService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovSearchService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozSearchService(x uint64) (n int) {
	return sovSearchService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *RawQuery) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSearchService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RawQuery: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RawQuery: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSearchService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSearchService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Query = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pagination", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSearchService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSearchService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Pagination == nil {
				m.Pagination = &Pagination{}
			}
			if err := m.Pagination.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSearchService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSearchService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RawSearchRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSearchService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RawSearchRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RawSearchRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSearchService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSearchService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Query = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType == 0 {
				var v SearchCategory
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowSearchService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= SearchCategory(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Categories = append(m.Categories, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowSearchService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthSearchService
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthSearchService
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				if elementCount != 0 && len(m.Categories) == 0 {
					m.Categories = make([]SearchCategory, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v SearchCategory
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowSearchService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= SearchCategory(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Categories = append(m.Categories, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Categories", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipSearchService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSearchService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QuerySortOption) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSearchService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QuerySortOption: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QuerySortOption: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Field", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSearchService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSearchService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Field = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reversed", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Reversed = bool(v != 0)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SearchAfter", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSearchService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSearchService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SearchAfterOpt = &QuerySortOption_SearchAfter{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSearchService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSearchService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryPagination) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSearchService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryPagination: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryPagination: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limit", wireType)
			}
			m.Limit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Limit |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Offset", wireType)
			}
			m.Offset = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Offset |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SortOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSearchService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSearchService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SortOptions = append(m.SortOptions, &QuerySortOption{})
			if err := m.SortOptions[len(m.SortOptions)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSearchService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSearchService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BooleanQuery) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSearchService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BooleanQuery: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BooleanQuery: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Must", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSearchService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSearchService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Must == nil {
				m.Must = &ConjunctionQuery{}
			}
			if err := m.Must.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MustNot", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSearchService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSearchService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MustNot == nil {
				m.MustNot = &DisjunctionQuery{}
			}
			if err := m.MustNot.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSearchService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSearchService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Query) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSearchService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Query: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Query: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Conjunction", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSearchService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSearchService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ConjunctionQuery{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Query = &Query_Conjunction{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Disjunction", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSearchService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSearchService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &DisjunctionQuery{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Query = &Query_Disjunction{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BaseQuery", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSearchService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSearchService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &BaseQuery{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Query = &Query_BaseQuery{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pagination", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSearchService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSearchService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Pagination == nil {
				m.Pagination = &QueryPagination{}
			}
			if err := m.Pagination.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BooleanQuery", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSearchService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSearchService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &BooleanQuery{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Query = &Query_BooleanQuery{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSearchService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSearchService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StringQuery) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSearchService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StringQuery: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StringQuery: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSearchService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSearchService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Query = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSearchService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSearchService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MatchFieldQuery) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSearchService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MatchFieldQuery: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MatchFieldQuery: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Field", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSearchService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSearchService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Field = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSearchService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSearchService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Highlight", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Highlight = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipSearchService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSearchService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MatchLinkedFieldsQuery) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSearchService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MatchLinkedFieldsQuery: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MatchLinkedFieldsQuery: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSearchService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSearchService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Query = append(m.Query, &MatchFieldQuery{})
			if err := m.Query[len(m.Query)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSearchService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSearchService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DocIDQuery) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSearchService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DocIDQuery: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DocIDQuery: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ids", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSearchService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSearchService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ids = append(m.Ids, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSearchService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSearchService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BaseQuery) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSearchService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BaseQuery: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BaseQuery: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MatchFieldQuery", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSearchService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSearchService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &MatchFieldQuery{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Query = &BaseQuery_MatchFieldQuery{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MatchLinkedFieldsQuery", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSearchService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSearchService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &MatchLinkedFieldsQuery{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Query = &BaseQuery_MatchLinkedFieldsQuery{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DocIdQuery", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSearchService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSearchService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &DocIDQuery{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Query = &BaseQuery_DocIdQuery{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MatchNoneQuery", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSearchService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSearchService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &MatchNoneQuery{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Query = &BaseQuery_MatchNoneQuery{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSearchService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSearchService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConjunctionQuery) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSearchService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConjunctionQuery: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConjunctionQuery: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Queries", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSearchService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSearchService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Queries = append(m.Queries, &Query{})
			if err := m.Queries[len(m.Queries)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSearchService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSearchService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DisjunctionQuery) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSearchService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DisjunctionQuery: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DisjunctionQuery: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Queries", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSearchService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSearchService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Queries = append(m.Queries, &Query{})
			if err := m.Queries[len(m.Queries)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSearchService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSearchService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MatchNoneQuery) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSearchService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MatchNoneQuery: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MatchNoneQuery: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipSearchService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSearchService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SearchResult) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSearchService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SearchResult: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SearchResult: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSearchService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSearchService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSearchService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSearchService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Category", wireType)
			}
			m.Category = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Category |= SearchCategory(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FieldToMatches", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSearchService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSearchService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FieldToMatches == nil {
				m.FieldToMatches = make(map[string]*SearchResult_Matches)
			}
			var mapkey string
			var mapvalue *SearchResult_Matches
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowSearchService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowSearchService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthSearchService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthSearchService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowSearchService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthSearchService
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthSearchService
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &SearchResult_Matches{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipSearchService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthSearchService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.FieldToMatches[mapkey] = mapvalue
			iNdEx = postIndex
		case 5:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Score", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Score = float64(math.Float64frombits(v))
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Location", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSearchService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSearchService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Location = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSearchService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSearchService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SearchResult_Matches) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSearchService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Matches: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Matches: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSearchService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSearchService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Values = append(m.Values, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSearchService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSearchService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SearchResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSearchService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SearchResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SearchResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Results", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSearchService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSearchService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Results = append(m.Results, &SearchResult{})
			if err := m.Results[len(m.Results)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Counts", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSearchService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSearchService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Counts = append(m.Counts, &SearchResponse_Count{})
			if err := m.Counts[len(m.Counts)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSearchService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSearchService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SearchResponse_Count) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSearchService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Count: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Count: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Category", wireType)
			}
			m.Category = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Category |= SearchCategory(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Count", wireType)
			}
			m.Count = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Count |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipSearchService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSearchService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SearchOptionsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSearchService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SearchOptionsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SearchOptionsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 0 {
				var v SearchCategory
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowSearchService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= SearchCategory(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Categories = append(m.Categories, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowSearchService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthSearchService
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthSearchService
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				if elementCount != 0 && len(m.Categories) == 0 {
					m.Categories = make([]SearchCategory, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v SearchCategory
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowSearchService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= SearchCategory(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Categories = append(m.Categories, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Categories", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipSearchService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSearchService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SearchOptionsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSearchService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SearchOptionsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SearchOptionsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSearchService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSearchService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Options = append(m.Options, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSearchService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSearchService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AutocompleteResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSearchService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AutocompleteResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AutocompleteResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSearchService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSearchService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Values = append(m.Values, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSearchService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSearchService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipSearchService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowSearchService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSearchService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthSearchService
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupSearchService
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthSearchService
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthSearchService        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowSearchService          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupSearchService = fmt.Errorf("proto: unexpected end of group")
)
