// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api/v1/service_account_service.proto

package v1

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	storage "github.com/stackrox/rox/generated/storage"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// A list of service accounts (free of scoped information)
// Next Tag: 2
type ListServiceAccountResponse struct {
	SaAndRoles           []*ServiceAccountAndRoles `protobuf:"bytes,1,rep,name=sa_and_roles,json=saAndRoles,proto3" json:"sa_and_roles,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *ListServiceAccountResponse) Reset()         { *m = ListServiceAccountResponse{} }
func (m *ListServiceAccountResponse) String() string { return proto.CompactTextString(m) }
func (*ListServiceAccountResponse) ProtoMessage()    {}
func (*ListServiceAccountResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ddf1e7223a6d354, []int{0}
}
func (m *ListServiceAccountResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListServiceAccountResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListServiceAccountResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListServiceAccountResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListServiceAccountResponse.Merge(m, src)
}
func (m *ListServiceAccountResponse) XXX_Size() int {
	return m.Size()
}
func (m *ListServiceAccountResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListServiceAccountResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListServiceAccountResponse proto.InternalMessageInfo

func (m *ListServiceAccountResponse) GetSaAndRoles() []*ServiceAccountAndRoles {
	if m != nil {
		return m.SaAndRoles
	}
	return nil
}

func (m *ListServiceAccountResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ListServiceAccountResponse) Clone() *ListServiceAccountResponse {
	if m == nil {
		return nil
	}
	cloned := new(ListServiceAccountResponse)
	*cloned = *m

	if m.SaAndRoles != nil {
		cloned.SaAndRoles = make([]*ServiceAccountAndRoles, len(m.SaAndRoles))
		for idx, v := range m.SaAndRoles {
			cloned.SaAndRoles[idx] = v.Clone()
		}
	}
	return cloned
}

// A service account and the roles that reference it
// Next Tag: 5
type ServiceAccountAndRoles struct {
	ServiceAccount          *storage.ServiceAccount     `protobuf:"bytes,1,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	ClusterRoles            []*storage.K8SRole          `protobuf:"bytes,2,rep,name=cluster_roles,json=clusterRoles,proto3" json:"cluster_roles,omitempty"`
	ScopedRoles             []*ScopedRoles              `protobuf:"bytes,3,rep,name=scoped_roles,json=scopedRoles,proto3" json:"scoped_roles,omitempty"`
	DeploymentRelationships []*SADeploymentRelationship `protobuf:"bytes,4,rep,name=deployment_relationships,json=deploymentRelationships,proto3" json:"deployment_relationships,omitempty"`
	XXX_NoUnkeyedLiteral    struct{}                    `json:"-"`
	XXX_unrecognized        []byte                      `json:"-"`
	XXX_sizecache           int32                       `json:"-"`
}

func (m *ServiceAccountAndRoles) Reset()         { *m = ServiceAccountAndRoles{} }
func (m *ServiceAccountAndRoles) String() string { return proto.CompactTextString(m) }
func (*ServiceAccountAndRoles) ProtoMessage()    {}
func (*ServiceAccountAndRoles) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ddf1e7223a6d354, []int{1}
}
func (m *ServiceAccountAndRoles) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServiceAccountAndRoles) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServiceAccountAndRoles.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ServiceAccountAndRoles) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServiceAccountAndRoles.Merge(m, src)
}
func (m *ServiceAccountAndRoles) XXX_Size() int {
	return m.Size()
}
func (m *ServiceAccountAndRoles) XXX_DiscardUnknown() {
	xxx_messageInfo_ServiceAccountAndRoles.DiscardUnknown(m)
}

var xxx_messageInfo_ServiceAccountAndRoles proto.InternalMessageInfo

func (m *ServiceAccountAndRoles) GetServiceAccount() *storage.ServiceAccount {
	if m != nil {
		return m.ServiceAccount
	}
	return nil
}

func (m *ServiceAccountAndRoles) GetClusterRoles() []*storage.K8SRole {
	if m != nil {
		return m.ClusterRoles
	}
	return nil
}

func (m *ServiceAccountAndRoles) GetScopedRoles() []*ScopedRoles {
	if m != nil {
		return m.ScopedRoles
	}
	return nil
}

func (m *ServiceAccountAndRoles) GetDeploymentRelationships() []*SADeploymentRelationship {
	if m != nil {
		return m.DeploymentRelationships
	}
	return nil
}

func (m *ServiceAccountAndRoles) MessageClone() proto.Message {
	return m.Clone()
}
func (m *ServiceAccountAndRoles) Clone() *ServiceAccountAndRoles {
	if m == nil {
		return nil
	}
	cloned := new(ServiceAccountAndRoles)
	*cloned = *m

	cloned.ServiceAccount = m.ServiceAccount.Clone()
	if m.ClusterRoles != nil {
		cloned.ClusterRoles = make([]*storage.K8SRole, len(m.ClusterRoles))
		for idx, v := range m.ClusterRoles {
			cloned.ClusterRoles[idx] = v.Clone()
		}
	}
	if m.ScopedRoles != nil {
		cloned.ScopedRoles = make([]*ScopedRoles, len(m.ScopedRoles))
		for idx, v := range m.ScopedRoles {
			cloned.ScopedRoles[idx] = v.Clone()
		}
	}
	if m.DeploymentRelationships != nil {
		cloned.DeploymentRelationships = make([]*SADeploymentRelationship, len(m.DeploymentRelationships))
		for idx, v := range m.DeploymentRelationships {
			cloned.DeploymentRelationships[idx] = v.Clone()
		}
	}
	return cloned
}

// One service account
// Next Tag: 2
type GetServiceAccountResponse struct {
	SaAndRole            *ServiceAccountAndRoles `protobuf:"bytes,1,opt,name=sa_and_role,json=saAndRole,proto3" json:"sa_and_role,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *GetServiceAccountResponse) Reset()         { *m = GetServiceAccountResponse{} }
func (m *GetServiceAccountResponse) String() string { return proto.CompactTextString(m) }
func (*GetServiceAccountResponse) ProtoMessage()    {}
func (*GetServiceAccountResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ddf1e7223a6d354, []int{2}
}
func (m *GetServiceAccountResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetServiceAccountResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetServiceAccountResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetServiceAccountResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetServiceAccountResponse.Merge(m, src)
}
func (m *GetServiceAccountResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetServiceAccountResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetServiceAccountResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetServiceAccountResponse proto.InternalMessageInfo

func (m *GetServiceAccountResponse) GetSaAndRole() *ServiceAccountAndRoles {
	if m != nil {
		return m.SaAndRole
	}
	return nil
}

func (m *GetServiceAccountResponse) MessageClone() proto.Message {
	return m.Clone()
}
func (m *GetServiceAccountResponse) Clone() *GetServiceAccountResponse {
	if m == nil {
		return nil
	}
	cloned := new(GetServiceAccountResponse)
	*cloned = *m

	cloned.SaAndRole = m.SaAndRole.Clone()
	return cloned
}

// Service accounts can be used by a deployment.
// Next Tag: 3
type SADeploymentRelationship struct {
	// Id of the deployment using the service account
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Name of the deployment.
	Name                 string   `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SADeploymentRelationship) Reset()         { *m = SADeploymentRelationship{} }
func (m *SADeploymentRelationship) String() string { return proto.CompactTextString(m) }
func (*SADeploymentRelationship) ProtoMessage()    {}
func (*SADeploymentRelationship) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ddf1e7223a6d354, []int{3}
}
func (m *SADeploymentRelationship) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SADeploymentRelationship) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SADeploymentRelationship.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SADeploymentRelationship) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SADeploymentRelationship.Merge(m, src)
}
func (m *SADeploymentRelationship) XXX_Size() int {
	return m.Size()
}
func (m *SADeploymentRelationship) XXX_DiscardUnknown() {
	xxx_messageInfo_SADeploymentRelationship.DiscardUnknown(m)
}

var xxx_messageInfo_SADeploymentRelationship proto.InternalMessageInfo

func (m *SADeploymentRelationship) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *SADeploymentRelationship) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SADeploymentRelationship) MessageClone() proto.Message {
	return m.Clone()
}
func (m *SADeploymentRelationship) Clone() *SADeploymentRelationship {
	if m == nil {
		return nil
	}
	cloned := new(SADeploymentRelationship)
	*cloned = *m

	return cloned
}

func init() {
	proto.RegisterType((*ListServiceAccountResponse)(nil), "v1.ListServiceAccountResponse")
	proto.RegisterType((*ServiceAccountAndRoles)(nil), "v1.ServiceAccountAndRoles")
	proto.RegisterType((*GetServiceAccountResponse)(nil), "v1.GetServiceAccountResponse")
	proto.RegisterType((*SADeploymentRelationship)(nil), "v1.SADeploymentRelationship")
}

func init() {
	proto.RegisterFile("api/v1/service_account_service.proto", fileDescriptor_7ddf1e7223a6d354)
}

var fileDescriptor_7ddf1e7223a6d354 = []byte{
	// 507 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x7c, 0x53, 0xcf, 0x6f, 0xd3, 0x30,
	0x14, 0x5e, 0xb2, 0x09, 0x69, 0x6e, 0xd9, 0x86, 0xab, 0xb1, 0x2c, 0xdb, 0xa2, 0x2a, 0xe2, 0xb0,
	0x53, 0xaa, 0x14, 0x21, 0x21, 0x84, 0x10, 0x9d, 0x26, 0x21, 0x04, 0x17, 0xc2, 0x61, 0x68, 0x97,
	0xe0, 0x39, 0xa6, 0xb3, 0x48, 0xed, 0xc8, 0xcf, 0x0d, 0x54, 0x88, 0x0b, 0xff, 0x02, 0x17, 0x4e,
	0xfc, 0x3d, 0x1c, 0x91, 0xf8, 0x07, 0xa0, 0xf0, 0x87, 0xa0, 0x38, 0x6e, 0xe9, 0x4f, 0x6e, 0x79,
	0x9f, 0xbf, 0xef, 0x7d, 0xdf, 0x7b, 0xb1, 0xd1, 0x1d, 0x52, 0xf0, 0x4e, 0x19, 0x77, 0x80, 0xa9,
	0x92, 0x53, 0x96, 0x12, 0x4a, 0xe5, 0x50, 0xe8, 0xd4, 0xd6, 0x51, 0xa1, 0xa4, 0x96, 0xd8, 0x2d,
	0x63, 0xff, 0xb8, 0x2f, 0x65, 0x3f, 0x67, 0x9d, 0x4a, 0x40, 0x84, 0x90, 0x9a, 0x68, 0x2e, 0x05,
	0xd4, 0x0c, 0xbf, 0x65, 0xfb, 0x50, 0x39, 0x18, 0x48, 0x61, 0xc1, 0xa3, 0x69, 0x73, 0xa2, 0xe8,
	0xf5, 0x7c, 0x4f, 0xff, 0xd0, 0x1e, 0xaa, 0x2b, 0x42, 0x17, 0x8e, 0x4e, 0x40, 0x4b, 0x45, 0xfa,
	0x6c, 0x31, 0x95, 0x3d, 0xc6, 0x93, 0xe3, 0x4a, 0x5a, 0x63, 0xe1, 0x25, 0xf2, 0x9f, 0x73, 0xd0,
	0x2f, 0x6b, 0x41, 0xaf, 0xe6, 0x27, 0x0c, 0x0a, 0x29, 0x80, 0xe1, 0x87, 0xa8, 0x09, 0x24, 0x25,
	0x22, 0x4b, 0x95, 0xcc, 0x19, 0x78, 0x4e, 0x7b, 0xf3, 0xb4, 0xd1, 0xf5, 0xa3, 0x32, 0x8e, 0xe6,
	0x15, 0x3d, 0x91, 0x25, 0x15, 0x23, 0x41, 0x40, 0x26, 0xdf, 0xe1, 0x57, 0x17, 0xdd, 0x5e, 0x4d,
	0xc3, 0x8f, 0xd1, 0xee, 0x42, 0x46, 0xcf, 0x69, 0x3b, 0xa7, 0x8d, 0xee, 0x41, 0x64, 0x43, 0x2e,
	0x18, 0x24, 0x3b, 0x30, 0x57, 0xe3, 0x7b, 0xe8, 0x26, 0xcd, 0x87, 0xa0, 0x99, 0xb2, 0xd9, 0x5c,
	0x93, 0x6d, 0x6f, 0xaa, 0x7f, 0x76, 0x1f, 0x2a, 0xaf, 0xa4, 0x69, 0x69, 0xb5, 0x71, 0x17, 0x35,
	0x81, 0xca, 0x82, 0x4d, 0x26, 0xda, 0x34, 0xaa, 0x5d, 0x33, 0x91, 0xc1, 0xeb, 0x31, 0x1a, 0xf0,
	0xaf, 0xc0, 0x17, 0xc8, 0xcb, 0x58, 0x91, 0xcb, 0xd1, 0x80, 0x09, 0x9d, 0x2a, 0x96, 0xd7, 0x7f,
	0xf0, 0x9a, 0x17, 0xe0, 0x6d, 0x19, 0xfd, 0xb1, 0xd1, 0xf7, 0xce, 0xa7, 0xac, 0x64, 0x86, 0x94,
	0x1c, 0x64, 0x2b, 0x71, 0x08, 0x2f, 0xd0, 0xe1, 0x13, 0xb6, 0x6e, 0xf7, 0x0f, 0x50, 0x63, 0x66,
	0xf7, 0x76, 0x3d, 0xff, 0x5b, 0xfd, 0xf6, 0x74, 0xf5, 0xe1, 0x23, 0xe4, 0xad, 0x4b, 0x83, 0x77,
	0x90, 0xcb, 0x33, 0xd3, 0x6e, 0x3b, 0x71, 0x79, 0x86, 0x31, 0xda, 0x12, 0x64, 0xc0, 0x3c, 0xd7,
	0x20, 0xe6, 0xbb, 0xfb, 0xcb, 0x41, 0xfb, 0xf3, 0x2e, 0xb6, 0xc2, 0x6f, 0xd0, 0xad, 0xa5, 0xc8,
	0x78, 0xaf, 0x4a, 0x95, 0x30, 0x90, 0x43, 0x45, 0xd9, 0xd9, 0xe8, 0xe9, 0xb9, 0x7f, 0x52, 0x21,
	0x6b, 0x67, 0x0b, 0xdb, 0x9f, 0x7e, 0xfc, 0xf9, 0xec, 0xfa, 0xd8, 0x9b, 0x79, 0x42, 0xf6, 0x1e,
	0x40, 0xe7, 0x03, 0xcf, 0x3e, 0xe2, 0xd7, 0xa8, 0xb5, 0x7c, 0x2f, 0x01, 0x37, 0x8d, 0x13, 0x79,
	0xf7, 0x62, 0xc8, 0xd4, 0xc8, 0x0f, 0xaa, 0x6a, 0xfd, 0xf5, 0x0d, 0x8f, 0x8c, 0xcd, 0x3e, 0x6e,
	0xad, 0xb0, 0x39, 0x8b, 0xbe, 0x8d, 0x03, 0xe7, 0xfb, 0x38, 0x70, 0x7e, 0x8e, 0x03, 0xe7, 0xcb,
	0xef, 0x60, 0x03, 0x79, 0x5c, 0x46, 0xa0, 0x09, 0x7d, 0xab, 0xe4, 0xfb, 0xfa, 0x79, 0x44, 0xa4,
	0xe0, 0x51, 0x19, 0x5f, 0xba, 0x65, 0xfc, 0x6a, 0xe3, 0xea, 0x86, 0xc1, 0xee, 0xfe, 0x0d, 0x00,
	0x00, 0xff, 0xff, 0x3a, 0xcd, 0x36, 0x4a, 0xfc, 0x03, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ServiceAccountServiceClient is the client API for ServiceAccountService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConnInterface.NewStream.
type ServiceAccountServiceClient interface {
	GetServiceAccount(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*GetServiceAccountResponse, error)
	ListServiceAccounts(ctx context.Context, in *RawQuery, opts ...grpc.CallOption) (*ListServiceAccountResponse, error)
}

type serviceAccountServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewServiceAccountServiceClient(cc grpc.ClientConnInterface) ServiceAccountServiceClient {
	return &serviceAccountServiceClient{cc}
}

func (c *serviceAccountServiceClient) GetServiceAccount(ctx context.Context, in *ResourceByID, opts ...grpc.CallOption) (*GetServiceAccountResponse, error) {
	out := new(GetServiceAccountResponse)
	err := c.cc.Invoke(ctx, "/v1.ServiceAccountService/GetServiceAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceAccountServiceClient) ListServiceAccounts(ctx context.Context, in *RawQuery, opts ...grpc.CallOption) (*ListServiceAccountResponse, error) {
	out := new(ListServiceAccountResponse)
	err := c.cc.Invoke(ctx, "/v1.ServiceAccountService/ListServiceAccounts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ServiceAccountServiceServer is the server API for ServiceAccountService service.
type ServiceAccountServiceServer interface {
	GetServiceAccount(context.Context, *ResourceByID) (*GetServiceAccountResponse, error)
	ListServiceAccounts(context.Context, *RawQuery) (*ListServiceAccountResponse, error)
}

// UnimplementedServiceAccountServiceServer can be embedded to have forward compatible implementations.
type UnimplementedServiceAccountServiceServer struct {
}

func (*UnimplementedServiceAccountServiceServer) GetServiceAccount(ctx context.Context, req *ResourceByID) (*GetServiceAccountResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetServiceAccount not implemented")
}
func (*UnimplementedServiceAccountServiceServer) ListServiceAccounts(ctx context.Context, req *RawQuery) (*ListServiceAccountResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListServiceAccounts not implemented")
}

func RegisterServiceAccountServiceServer(s *grpc.Server, srv ServiceAccountServiceServer) {
	s.RegisterService(&_ServiceAccountService_serviceDesc, srv)
}

func _ServiceAccountService_GetServiceAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceByID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceAccountServiceServer).GetServiceAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ServiceAccountService/GetServiceAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceAccountServiceServer).GetServiceAccount(ctx, req.(*ResourceByID))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceAccountService_ListServiceAccounts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RawQuery)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceAccountServiceServer).ListServiceAccounts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1.ServiceAccountService/ListServiceAccounts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceAccountServiceServer).ListServiceAccounts(ctx, req.(*RawQuery))
	}
	return interceptor(ctx, in, info, handler)
}

var _ServiceAccountService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1.ServiceAccountService",
	HandlerType: (*ServiceAccountServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetServiceAccount",
			Handler:    _ServiceAccountService_GetServiceAccount_Handler,
		},
		{
			MethodName: "ListServiceAccounts",
			Handler:    _ServiceAccountService_ListServiceAccounts_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/v1/service_account_service.proto",
}

func (m *ListServiceAccountResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListServiceAccountResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListServiceAccountResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.SaAndRoles) > 0 {
		for iNdEx := len(m.SaAndRoles) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.SaAndRoles[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintServiceAccountService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ServiceAccountAndRoles) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServiceAccountAndRoles) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServiceAccountAndRoles) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.DeploymentRelationships) > 0 {
		for iNdEx := len(m.DeploymentRelationships) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.DeploymentRelationships[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintServiceAccountService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.ScopedRoles) > 0 {
		for iNdEx := len(m.ScopedRoles) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ScopedRoles[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintServiceAccountService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.ClusterRoles) > 0 {
		for iNdEx := len(m.ClusterRoles) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ClusterRoles[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintServiceAccountService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.ServiceAccount != nil {
		{
			size, err := m.ServiceAccount.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintServiceAccountService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetServiceAccountResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetServiceAccountResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetServiceAccountResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.SaAndRole != nil {
		{
			size, err := m.SaAndRole.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintServiceAccountService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SADeploymentRelationship) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SADeploymentRelationship) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SADeploymentRelationship) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintServiceAccountService(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintServiceAccountService(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintServiceAccountService(dAtA []byte, offset int, v uint64) int {
	offset -= sovServiceAccountService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ListServiceAccountResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.SaAndRoles) > 0 {
		for _, e := range m.SaAndRoles {
			l = e.Size()
			n += 1 + l + sovServiceAccountService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ServiceAccountAndRoles) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ServiceAccount != nil {
		l = m.ServiceAccount.Size()
		n += 1 + l + sovServiceAccountService(uint64(l))
	}
	if len(m.ClusterRoles) > 0 {
		for _, e := range m.ClusterRoles {
			l = e.Size()
			n += 1 + l + sovServiceAccountService(uint64(l))
		}
	}
	if len(m.ScopedRoles) > 0 {
		for _, e := range m.ScopedRoles {
			l = e.Size()
			n += 1 + l + sovServiceAccountService(uint64(l))
		}
	}
	if len(m.DeploymentRelationships) > 0 {
		for _, e := range m.DeploymentRelationships {
			l = e.Size()
			n += 1 + l + sovServiceAccountService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetServiceAccountResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.SaAndRole != nil {
		l = m.SaAndRole.Size()
		n += 1 + l + sovServiceAccountService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SADeploymentRelationship) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovServiceAccountService(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovServiceAccountService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovServiceAccountService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozServiceAccountService(x uint64) (n int) {
	return sovServiceAccountService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ListServiceAccountResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowServiceAccountService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListServiceAccountResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListServiceAccountResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SaAndRoles", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowServiceAccountService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthServiceAccountService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthServiceAccountService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SaAndRoles = append(m.SaAndRoles, &ServiceAccountAndRoles{})
			if err := m.SaAndRoles[len(m.SaAndRoles)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipServiceAccountService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthServiceAccountService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServiceAccountAndRoles) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowServiceAccountService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServiceAccountAndRoles: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServiceAccountAndRoles: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServiceAccount", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowServiceAccountService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthServiceAccountService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthServiceAccountService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ServiceAccount == nil {
				m.ServiceAccount = &storage.ServiceAccount{}
			}
			if err := m.ServiceAccount.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterRoles", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowServiceAccountService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthServiceAccountService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthServiceAccountService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterRoles = append(m.ClusterRoles, &storage.K8SRole{})
			if err := m.ClusterRoles[len(m.ClusterRoles)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScopedRoles", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowServiceAccountService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthServiceAccountService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthServiceAccountService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ScopedRoles = append(m.ScopedRoles, &ScopedRoles{})
			if err := m.ScopedRoles[len(m.ScopedRoles)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentRelationships", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowServiceAccountService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthServiceAccountService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthServiceAccountService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentRelationships = append(m.DeploymentRelationships, &SADeploymentRelationship{})
			if err := m.DeploymentRelationships[len(m.DeploymentRelationships)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipServiceAccountService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthServiceAccountService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetServiceAccountResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowServiceAccountService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetServiceAccountResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetServiceAccountResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SaAndRole", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowServiceAccountService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthServiceAccountService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthServiceAccountService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SaAndRole == nil {
				m.SaAndRole = &ServiceAccountAndRoles{}
			}
			if err := m.SaAndRole.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipServiceAccountService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthServiceAccountService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SADeploymentRelationship) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowServiceAccountService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SADeploymentRelationship: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SADeploymentRelationship: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowServiceAccountService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthServiceAccountService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthServiceAccountService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowServiceAccountService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthServiceAccountService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthServiceAccountService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipServiceAccountService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthServiceAccountService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipServiceAccountService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowServiceAccountService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowServiceAccountService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowServiceAccountService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthServiceAccountService
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupServiceAccountService
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthServiceAccountService
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthServiceAccountService        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowServiceAccountService          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupServiceAccountService = fmt.Errorf("proto: unexpected end of group")
)
